/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.aop;

import com.alibaba.fastjson.JSON;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.IPAddress.IpUtils;
import com.mopaas.server.common.IPAddress.QQWry;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.LoginHistoryRepository;
import com.mopaas.server.dao.OperationLogRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.LoginHistory;
import com.mopaas.server.entity.OperationLog;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.User;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.LicenseService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class UserStateInterceptor
extends HandlerInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(UserStateInterceptor.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    @Autowired
    private DepUsersRepository depUsersRepository;
    @Autowired
    private DomainRepository domainRepository;
    @Autowired
    private LoginHistoryRepository loginHistoryRepository;
    @Autowired
    private OperationLogRepository operationLogRepository;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private LicenseService licenseService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("startTime", (Object)new Date(System.currentTimeMillis()));
        String uri = request.getRequestURI();
        if (!uri.contains("anon")) {
            List dus;
            HttpSession session = request.getSession();
            String domainId = request.getHeader("domain");
            Subject subject = SecurityUtils.getSubject();
            if (null != domainId && !"null".equals(domainId)) {
                Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(Long.parseLong(domainId)), Integer.valueOf(0));
                if (null == domain || domain.getStatus() != 1) {
                    this.returnResponse(subject, response, "msg.domain.unavailable");
                    return false;
                }
                session.setAttribute("domain", (Object)domain.getId());
            } else {
                List domains = this.domainRepository.findByDeletedAndStatus(Integer.valueOf(0), Integer.valueOf(1));
                if (domains != null && !domains.isEmpty()) {
                    session.setAttribute("domain", (Object)((Domain)domains.get(0)).getId());
                } else {
                    this.returnResponse(subject, response, "msg.domain.unavailable");
                    return false;
                }
            }
            this.licenseService.licenseCheck();
            Long userId = (Long)session.getAttribute("userId");
            if (null == userId) {
                this.returnResponse(subject, response, "msg.account.unauthenticated");
                return false;
            }
            User user = (User)this.userRepository.findOne((Serializable)userId);
            if (user != null && (user.getState() != 1 || user.getStatus() != 1 || user.getDeleted() == 1)) {
                this.returnResponse(subject, response, "msg.account.unauthenticated");
                return false;
            }
            if (uri.contains("api/logout") || uri.contains("api/user/info") || uri.contains("api/org/info") || uri.contains("api/dep/mine") || uri.contains("api/domain/list") || uri.contains("api/account/user/notices") || uri.contains("api/pay/balance/") || uri.contains("api/account/user/notice/state") || uri.contains("api/dep/resource/count") || uri.contains("api/overview/payment") || uri.contains("api/reference/statistics") || uri.contains("api/dep/create") || uri.contains("api/user/payment") || uri.contains("api/user/recharge") || uri.contains("api/user/ticket/") || uri.contains("api/module")) {
                return super.preHandle(request, response, handler);
            }
            if (uri.contains("api/dep/members") && (null == (dus = this.depUsersRepository.findByUser(user)) || dus.isEmpty())) {
                return super.preHandle(request, response, handler);
            }
            Long depId = (Long)session.getAttribute("departmentId");
            if (uri.contains("api/account/dep/choose")) {
                String[] split = uri.split("/");
                depId = Long.parseLong(split[split.length - 1]);
                session.setAttribute("departmentId", (Object)depId);
            }
            if (!uri.contains("api/account/dep/choose") && null == depId) {
                this.returnResponse(subject, response, "msg.account.unauthenticated");
                return false;
            }
            OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
            DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
            if (depUsers == null || depUsers.getState() != 1 || dep.getStatus() != null && dep.getStatus() == 0) {
                this.returnResponse(subject, response, "msg.account.unauthenticated");
                return false;
            }
        }
        return super.preHandle(request, response, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnResponse(Subject subject, HttpServletResponse response, String msgExpress) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_MSG);
        res.setMessage(this.messageUtil.getMessage(msgExpress));
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            writer.println(JSON.toJSONString((Object)res));
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        if (subject.isAuthenticated()) {
            subject.logout();
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HttpSession httpSession;
        Long userId;
        block97: {
            userId = null;
            httpSession = request.getSession();
            try {
                if (null != httpSession && null != httpSession.getAttribute("userId")) {
                    userId = (Long)httpSession.getAttribute("userId");
                }
            }
            catch (Exception e) {
                if (e.getLocalizedMessage().contains("no session")) break block97;
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Integer resourceType = (Integer)request.getAttribute("resourceType");
        if (userId != null) {
            LoginHistory loginHistory = this.loginHistoryRepository.findTopByUserIdOrderByIdDesc(userId);
            loginHistory.setEnd(new Date());
            this.loginHistoryRepository.saveAndFlush((Object)loginHistory);
            if (null != resourceType) {
                User user = (User)this.userRepository.findOne((Serializable)userId);
                OperationLog log = new OperationLog();
                if (handler instanceof HandlerMethod) {
                    String apiUri;
                    Object domainId;
                    Long depId = (Long)httpSession.getAttribute("departmentId");
                    if (depId != null) {
                        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
                        log.setDepartment(dep);
                        log.setOrganization(dep.getOrgConfig().getOrganization());
                    }
                    if (null != (domainId = httpSession.getAttribute("domain"))) {
                        Domain domain = this.domainRepository.findByIdAndDeleted((Long)domainId, Integer.valueOf(0));
                        log.setDomain(domain);
                    }
                    log.setName(user.getName());
                    log.setUsername(user.getUsername());
                    String resourceGuid = (String)request.getAttribute("resourceGuid");
                    String resourceName = (String)request.getAttribute("resourceName");
                    log.setResourceGuid(resourceGuid);
                    log.setResourceName(resourceName);
                    log.setResourceType(resourceType);
                    Date startTime = (Date)request.getAttribute("startTime");
                    Long duration = System.currentTimeMillis() - startTime.getTime();
                    log.setDuration(duration);
                    if (null != ex || null == request.getAttribute("result") || !"true".equals(request.getAttribute("result"))) {
                        log.setRes(Constants.SC_ERROR);
                    } else {
                        log.setRes(Constants.SC_OK);
                    }
                    try {
                        String remoteHost = IpUtils.getOuterNetIp((HttpServletRequest)request);
                        if (null != remoteHost && !remoteHost.isEmpty()) {
                            log.setOperationIp(remoteHost);
                            QQWry qqwry = new QQWry();
                            log.setAddress(qqwry.findIP(remoteHost) == null ? null : qqwry.findIP(remoteHost).getMainInfo());
                        }
                    }
                    catch (Exception e) {
                        this.logger.info(e.getMessage());
                    }
                    log.setCreatedAt(new Date(System.currentTimeMillis()));
                    String errorMessage = (String)request.getAttribute("errorMessage");
                    log.setErrorMessage(errorMessage);
                    if ((null == errorMessage || errorMessage.isEmpty()) && null != ex) {
                        log.setErrorMessage(ex.getMessage());
                    }
                    if ((apiUri = request.getRequestURI()) != null && apiUri.endsWith("/api/job/param") && "POST".equals(request.getMethod())) {
                        if (request.getAttribute("operation") != null) {
                            log.setContent(String.valueOf(request.getAttribute("operation")));
                        } else {
                            log.setContent(this.messageUtil.getMessageJson("msg.create.param.job"));
                        }
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/storage") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.create.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.matches(".*/api/storage/[0-9]*$") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.update.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/capacity/") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.update.capacity.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.matches(".*/api/storage/pwd/[0-9]*$") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.update.pwd.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/expose/") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.exposed.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/storage/remove") && "DELETE".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.remove.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/") && apiUri.endsWith("/share") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.share.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/") && apiUri.endsWith("/upload") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.upload.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/") && apiUri.endsWith("/file/remove") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.remove.file.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/") && apiUri.endsWith("/files/download") && "GET".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.download.files.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/") && apiUri.endsWith("/file/download") && "GET".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.download.file.storage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/annotation") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.create.annotation"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/annotation/remove") && "DELETE".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.remove.annotation"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/model/new") && "POST".equals(request.getMethod())) {
                        if (request.getAttribute("operation") != null) {
                            log.setContent(String.valueOf(request.getAttribute("operation")));
                        } else {
                            log.setContent(this.messageUtil.getMessageJson("msg.create.model"));
                        }
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/model") && "DELETE".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.remove.model"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/modelmanage/create") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.create.modelmanage"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/model/repository/new") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.create.repo"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/model/repository/public/") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.public.repo"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.matches(".*/api/model/repository/delete/[0-9]*$") && "DELETE".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.remove.repo"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/model/repository/delete") && "DELETE".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.remove.repo"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/repository/image/delete") && "DELETE".equals(request.getMethod())) {
                        if (request.getAttribute("operation") != null) {
                            log.setContent(String.valueOf(request.getAttribute("operation")));
                        } else {
                            log.setContent(this.messageUtil.getMessageJson("msg.remove.image"));
                        }
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/repository/image/update") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.update.image"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/model/repository/image/inactive") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.inactive.image"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/model/repository/image/active") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.active.image"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.endsWith("/api/model/repository/share") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.share.image"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/resource/") && apiUri.endsWith("/file/export") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.resource.backup"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/resource/") && apiUri.endsWith("/download") && "GET".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.resource.backup.download"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/resource/file/") && "DELETE".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.remove.resource.backup"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/annotation/") && apiUri.endsWith("/update") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.update.annotation"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/model/remark") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.update.remark"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/storage/name/") && "PUT".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.update.name"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/frame/repository/new") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.create.repository"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/repository/image/inactive") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.inactive.repository"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/repository/image/active") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.active.repository"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/model/repository/pwd") && "POST".equals(request.getMethod())) {
                        if (request.getAttribute("operation") != null) {
                            log.setContent(String.valueOf(request.getAttribute("operation")));
                        } else {
                            log.setContent(this.messageUtil.getMessageJson("msg.update.pwd"));
                        }
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/resource/snapshot/") && "DELETE".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.snapshot.remove.resource"));
                        this.operationLogRepository.save((Object)log);
                    } else if (apiUri != null && apiUri.contains("/api/repository/image/tag/labels/set") && "POST".equals(request.getMethod())) {
                        log.setContent(this.messageUtil.getMessageJson("msg.set.label.image"));
                        this.operationLogRepository.save((Object)log);
                    }
                }
            }
        }
        super.afterCompletion(request, response, handler, ex);
    }
}

