/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.aop.log;

import com.mopaas.server.aop.log.LogOperation;
import java.beans.ConstructorProperties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Component
public class LogAspect {
    final LogOperation logOperation;

    @Pointcut(value="@annotation(com.mopaas.server.aop.log.LogAnnotation)")
    public void logPointCut() {
    }

    @Before(value="logPointCut()")
    public void doBefore() {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ra.setAttribute("startTime", (Object)System.currentTimeMillis(), 0);
    }

    @AfterReturning(pointcut="logPointCut()", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Object jsonResult) {
        this.logOperation.addOperationLog(joinPoint, jsonResult);
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        this.logOperation.addOperationLog(joinPoint, (Object)e);
    }

    @ConstructorProperties(value={"logOperation"})
    public LogAspect(LogOperation logOperation) {
        this.logOperation = logOperation;
    }
}

