/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.aop.log;

import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.aop.log.LogAspect;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.IPAddress.IpUtils;
import com.mopaas.server.common.IPAddress.QQWry;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.OperationLog;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.User;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.OperationLogService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class LogOperation {
    final OperationLogService operationLogService;
    final UserRepository userRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DomainRepository domainRepository;
    final MessageUtil messageUtil;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAspect.class);
    private static QQWry qqwry;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void addOperationLog(JoinPoint joinPoint, Object object) {
        LogAnnotation myLog = this.getAnnotationLog(joinPoint);
        if (myLog == null) {
            return;
        }
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        HttpSession session = request.getSession();
        Object userId = session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)((Long)userId));
        OperationLog log = new OperationLog();
        try {
            String ip = IpUtils.getOuterNetIp((HttpServletRequest)request);
            log.setOperationIp(ip);
            log.setAddress(qqwry.findIP(ip) == null ? null : qqwry.findIP(ip).getMainInfo());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        log.setName(user.getName());
        log.setUsername(user.getUsername());
        log.setDuration(Long.valueOf(System.currentTimeMillis() - (Long)ra.getAttribute("startTime", 0)));
        log.setCreatedAt(new Date());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId != null) {
            OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
            log.setDepartment(dep);
            log.setOrganization(dep.getOrgConfig().getOrganization());
        }
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        log.setDomain(domain);
        log.setResourceType(Integer.valueOf(myLog.type()));
        log.setContent(this.messageUtil.getMessageJson(myLog.msgExpression()));
        if (null == object) {
            log.setRes(Constants.SC_OK);
        } else if (object instanceof Exception) {
            log.setRes(Constants.SC_ERROR);
            if (object instanceof MessageJsonException) {
                MessageJsonException exception = (MessageJsonException)object;
                String[] args = exception.getArgs();
                if (null != args) {
                    StringBuilder sb = new StringBuilder(8);
                    StringBuilder sbEN = new StringBuilder(8);
                    for (String arg : args) {
                        if (arg.startsWith("msg")) {
                            sb.append(this.messageUtil.getMessageZh(arg));
                            sbEN.append(this.messageUtil.getMessageEn(arg));
                            continue;
                        }
                        sb.append(arg);
                        sbEN.append(arg);
                    }
                    log.setErrorMessage(this.messageUtil.getMessageJson(exception.getCode(), new String[]{sb.toString()}, new String[]{sbEN.toString()}));
                } else {
                    log.setErrorMessage(this.messageUtil.getMessageJson(exception.getCode()));
                }
                log.setResourceGuid(exception.getGuid());
                log.setResourceName(exception.getResource());
            } else if (object instanceof MessageCodeException) {
                MessageCodeException ex = (MessageCodeException)object;
                log.setErrorMessage(this.messageUtil.getMessageJson(ex.getCode(), ex.getArgs()));
                log.setResourceGuid(ex.getGuid());
                log.setResourceName(ex.getResource());
            } else {
                log.setErrorMessage(((Exception)object).getMessage());
            }
        } else {
            ResultResponse res = (ResultResponse)object;
            log.setRes(res.getCode().equals(Constants.SC_OK) ? Constants.SC_OK : Constants.SC_ERROR);
            log.setErrorMessage(res.getMessage());
            log.setResourceName(res.getEntity());
            log.setResourceGuid(res.getGuid());
        }
        this.operationLogService.save(log);
    }

    private LogAnnotation getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(LogAnnotation.class);
        }
        return null;
    }

    @ConstructorProperties(value={"operationLogService", "userRepository", "orgConfigDepartmentRepository", "domainRepository", "messageUtil"})
    public LogOperation(OperationLogService operationLogService, UserRepository userRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DomainRepository domainRepository, MessageUtil messageUtil) {
        this.operationLogService = operationLogService;
        this.userRepository = userRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.domainRepository = domainRepository;
        this.messageUtil = messageUtil;
    }

    static {
        try {
            qqwry = new QQWry();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

