/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.automl;

import com.mopaas.server.automl.AutoMLService;
import com.mopaas.server.automl.domain.ExperimentDetailVO;
import com.mopaas.server.automl.domain.ExperimentEditRequestDto;
import com.mopaas.server.automl.domain.ExperimentInfoVO;
import com.mopaas.server.automl.domain.ExperimentVO;
import com.mopaas.server.automl.domain.TrialListVO;
import com.mopaas.server.model.request.ExperimentParamRequest;
import com.mopaas.server.model.request.ExperimentRequest;
import com.mopaas.server.model.request.ExperimentSortPageRequest;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.JobParamSortPageRequest;
import com.mopaas.server.model.request.RemarkUpdateRequest;
import com.mopaas.server.model.response.ExperimentParamModel;
import com.mopaas.server.model.response.ExperimentParamsResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.ResultResponse;
import io.kubernetes.client.openapi.ApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"autoML"})
@RestController
public class AutoMLController {
    @Autowired
    private AutoMLService autoMLService;

    @ApiOperation(value="\u521b\u5efaexperiment", notes="v3.3\u4fee\u6539\uff0c\u63a5\u53e3\u4f20\u53c2-\u65b0\u589e\u53c2\u6570saveParam\uff0cparamName\uff0cparamRemark\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570error")
    @PostMapping(value={"api/experiment"})
    public ResultResponse create(@RequestBody ExperimentRequest dto, HttpServletRequest request) throws Exception {
        return this.autoMLService.create(dto, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u8bd5\u9a8c\u5217\u8868")
    @PostMapping(value={"api/experiments"})
    public ListResultResponse<ExperimentVO> list(@RequestBody @Valid ExperimentSortPageRequest dto, HttpServletRequest request) throws Exception {
        return this.autoMLService.list(dto, request.getSession());
    }

    @ApiOperation(value="\u5220\u9664\u8bd5\u9a8c")
    @PostMapping(value={"api/experiments/remove"})
    public ResultResponse remove(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) throws ApiException {
        return this.autoMLService.remove(dto, request.getSession());
    }

    @ApiOperation(value="\u4fee\u6539\u8bd5\u9a8c\u540d\u79f0")
    @PutMapping(value={"api/experiment/{id}/{name}"})
    public ResultResponse nameEdit(@PathVariable(value="id") Long id, @PathVariable(value="name") String name, HttpServletRequest request) {
        return this.autoMLService.nameEdit(id, name, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u8bd5\u9a8c\u8be6\u60c5")
    @GetMapping(value={"api/experiment/{id}"})
    public ExperimentInfoVO getExperiment(@PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        return this.autoMLService.getDetail(id, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u8bd5\u9a8c\u8bad\u7ec3\u5217\u8868")
    @GetMapping(value={"api/experiment/{id}/trials"})
    public TrialListVO listTrials(@PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        return this.autoMLService.listTrials(id, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u8bd5\u9a8c\u914d\u7f6e")
    @GetMapping(value={"api/experiment/{id}/detail"})
    public ExperimentDetailVO experimentDetail(@PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        return this.autoMLService.experimentDetail(id, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u8bd5\u9a8cyaml")
    @GetMapping(value={"api/experiment/{id}/yaml"})
    public String experimentYaml(@PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        return this.autoMLService.experimentYaml(id, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u8bd5\u9a8c\u6307\u6807\u8be6\u60c5")
    @GetMapping(value={"api/trial/{namespace}/{name}"})
    public String trialMetric(@PathVariable(value="namespace") String namespace, @PathVariable(value="name") String name, HttpServletRequest request) throws ApiException {
        return this.autoMLService.trialMetric(name, namespace, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u53c2\u6570\u7ba1\u7406\u5217\u8868", notes="v3.3\u65b0\u589e")
    @PostMapping(value={"api/experiment/param/list"})
    public ListResultResponse<ExperimentParamModel> list(@RequestBody @Valid JobParamSortPageRequest dto, HttpServletRequest request) {
        return this.autoMLService.listParam(dto, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u53c2\u6570\u8be6\u60c5", notes="v3.3\u65b0\u589e")
    @GetMapping(value={"api/experiment/param/{id}"})
    public ExperimentParamsResponse trialMetric(@PathVariable(value="id") @ApiParam(value="\u53c2\u6570id") Long id, HttpServletRequest request) {
        return this.autoMLService.getParam(id, request.getSession());
    }

    @ApiOperation(value="\u5220\u9664\u53c2\u6570", notes="v3.3\u65b0\u589e")
    @PostMapping(value={"api/experiment/param/remove"})
    public ResultResponse removeParam(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) {
        return this.autoMLService.removeParam(dto, request.getSession());
    }

    @ApiOperation(value="\u7f16\u8f91\u53c2\u6570", notes="v3.3\u65b0\u589e")
    @PostMapping(value={"api/experiment/param/edit"})
    public ResultResponse editParam(@RequestBody ExperimentEditRequestDto dto, HttpServletRequest request) {
        return this.autoMLService.editParam(dto, request.getSession());
    }

    @ApiOperation(value="\u4fee\u6539\u53c2\u6570\u5907\u6ce8", notes="v3.3\u65b0\u589e")
    @PostMapping(value={"api/experiment/param/remark"})
    public ResultResponse editParamRemark(@RequestBody RemarkUpdateRequest dto, HttpServletRequest request) {
        return this.autoMLService.editParamRemark(dto, request.getSession());
    }

    @ApiOperation(value="\u542f\u52a8\u8bd5\u9a8c", notes="v3.3\u65b0\u589e")
    @PutMapping(value={"api/experiment/start/{id}"})
    public ResultResponse start(@PathVariable(value="id") @ApiParam(value="\u8bd5\u9a8cid") Long id, HttpServletRequest request) throws Exception {
        return this.autoMLService.start(id, request.getSession());
    }

    @ApiOperation(value="\u505c\u6b62\u8bd5\u9a8c", notes="v3.3\u65b0\u589e")
    @PutMapping(value={"api/experiment/stop/{id}"})
    public ResultResponse stop(@PathVariable(value="id") @ApiParam(value="\u8bd5\u9a8cid") Long id, HttpServletRequest request) {
        return this.autoMLService.stop(id, request.getSession());
    }

    @ApiOperation(value="\u8d85\u53c2\u8c03\u4f18-\u8d44\u6e90\u662f\u5426\u53ef\u7528")
    @RequestMapping(value={"/api/experiment/quota"}, method={RequestMethod.GET})
    public ResultResponse automlQuota(HttpServletRequest request) {
        return this.autoMLService.checkAutomlQuota(request.getSession());
    }

    @ApiOperation(value="\u4fdd\u5b58\u53c2\u6570\uff08v3.4\u65b0\u589e\u63a5\u53e3\uff09", notes="v3.4\u65b0\u589e\u63a5\u53e3")
    @PostMapping(value={"api/experiment/param/save"})
    public ResultResponse saveParam(@RequestBody ExperimentParamRequest dto, HttpServletRequest request) {
        return this.autoMLService.saveParam(dto, request.getSession());
    }

    @ApiOperation(value="\u83b7\u53d6\u8d85\u53c2\u8c03\u4f18\u7684\u53c2\u6570\u4fe1\u606f\uff08v3.4\u65b0\u589e\u63a5\u53e3\uff09", notes="v3.4\u65b0\u589e\u63a5\u53e3")
    @GetMapping(value={"api/experiment/{id}/info"})
    public ExperimentParamsResponse getAutomlInfo(@PathVariable(value="id") @ApiParam(value="\u8bd5\u9a8cid") Long id, HttpServletRequest request) throws Exception {
        return this.autoMLService.getAutomlInfo(id, request.getSession());
    }
}

