/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.automl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.automl.AutoMLService;
import com.mopaas.server.automl.domain.ExperimentDetailVO;
import com.mopaas.server.automl.domain.ExperimentEditRequestDto;
import com.mopaas.server.automl.domain.ExperimentInfoVO;
import com.mopaas.server.automl.domain.ExperimentVO;
import com.mopaas.server.automl.domain.TrialHeaderVO;
import com.mopaas.server.automl.domain.TrialListVO;
import com.mopaas.server.automl.domain.TrialVO;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.ExperimentParamsRepository;
import com.mopaas.server.dao.ExperimentRepository;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.ReferTrialDurationRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.dto.JudgeResourceDto;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.Experiment;
import com.mopaas.server.entity.ExperimentParams;
import com.mopaas.server.entity.Job;
import com.mopaas.server.entity.JobVersion;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.ReferTrialDuration;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.User;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.kubeflow.katib.V1beta1Experiment;
import com.mopaas.server.kubeflow.katib.V1beta1ExperimentCondition;
import com.mopaas.server.kubeflow.katib.V1beta1ExperimentSpec;
import com.mopaas.server.kubeflow.katib.V1beta1ExperimentStatus;
import com.mopaas.server.kubeflow.katib.V1beta1Metric;
import com.mopaas.server.kubeflow.katib.V1beta1MetricStrategy;
import com.mopaas.server.kubeflow.katib.V1beta1ObjectiveSpec;
import com.mopaas.server.kubeflow.katib.V1beta1Observation;
import com.mopaas.server.kubeflow.katib.V1beta1ParameterAssignment;
import com.mopaas.server.kubeflow.katib.V1beta1ParameterSpec;
import com.mopaas.server.kubeflow.katib.V1beta1Trial;
import com.mopaas.server.kubeflow.katib.V1beta1TrialCondition;
import com.mopaas.server.kubeflow.katib.V1beta1TrialList;
import com.mopaas.server.model.InstantMetricModel;
import com.mopaas.server.model.request.ExperimentParamRequest;
import com.mopaas.server.model.request.ExperimentRequest;
import com.mopaas.server.model.request.ExperimentSortPageRequest;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.JobParamSortPageRequest;
import com.mopaas.server.model.request.RemarkUpdateRequest;
import com.mopaas.server.model.response.ExperimentParamModel;
import com.mopaas.server.model.response.ExperimentParamsResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.AutoMLAsyncService;
import com.mopaas.server.service.CommonService;
import com.mopaas.server.service.NoticeUserService;
import com.mopaas.server.service.ResourceService;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.util.Yaml;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AutoMLService {
    final ExperimentRepository experimentRepository;
    final UserRepository userRepository;
    final JobVersionRepository jobVersionRepository;
    final MessageUtil messageUtil;
    final DepUsersRepository depUsersRepository;
    final MaterialsRepository materialsRepository;
    final DomainRepository domainRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final StorageServiceFactory storageServiceFactory;
    final ResourceService resourceService;
    final CommonService commonService;
    final ExperimentParamsRepository experimentParamsRepository;
    final DepQuotasRepository depQuotasRepository;
    final ReferDurationRepository referDurationRepository;
    final ReferTrialDurationRepository referTrialDurationRepository;
    final SystemConfigRepository systemConfigRepository;
    final NoticeUserService noticeUserService;
    final AutoMLAsyncService autoMLAsyncService;
    final OrganizationQuotasRepository organizationQuotasRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoMLService.class);
    private static final Map<String, Integer> probe = new HashMap();

    private void judgeSysResource(ResourceIdentityDto dto) throws ApiException {
        JudgeResourceDto jrd = this.commonService.preJudgeSysResource(dto);
        if (null != jrd) {
            this.commonService.sysResourceInsufficientException(jrd);
        }
    }

    public void checkDepQuota(ResourceIdentityDto dto) {
        DepQuotas depQuotas;
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(dto.getUser(), dto.getDepartment());
        if (depUsers != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomain(dto.getDepartment(), dto.getDomain()))) {
            Integer user_count;
            Organization org = dto.getDepartment().getOrgConfig().getOrganization();
            String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
            for (OrgConfig config : org.getOrgConfigs()) {
                if (1 != config.getLevel()) continue;
                depName = config.getName();
                break;
            }
            if (null != depQuotas.getAutomlCount() && depQuotas.getAutomlCount() != -1 && null != (user_count = this.experimentRepository.countByDepartmentAndDeletedAndDomainAndUser(dto.getDepartment(), Integer.valueOf(0), dto.getDomain(), dto.getUser())) && user_count >= depQuotas.getAutomlCount()) {
                throw new MessageCodeException(dto.getName(), dto.getGuid(), "msg.dep.resource.insufficient.error", new String[]{depName});
            }
            if (null != depQuotas.getAutomlTime() && depQuotas.getAutomlTime() != -1.0) {
                List namespaces = this.experimentRepository.findGuidByDepartmentAndDeletedAndDomainAndUser(dto.getDepartment(), Integer.valueOf(0), dto.getDomain(), dto.getUser());
                Long rUserDuration = 0L;
                if (null != namespaces && !namespaces.isEmpty()) {
                    rUserDuration = this.referTrialDurationRepository.calculateByNamespaceIn(namespaces, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                }
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getAutomlTime() * 60.0 * 60.0) {
                    throw new MessageCodeException(dto.getName(), dto.getGuid(), "msg.dep.resource.time.insufficient.error", new String[]{depName});
                }
            }
        }
    }

    public void checkDepQuotaStart(ResourceIdentityDto dto) {
        DepQuotas depQuotas;
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(dto.getUser(), dto.getDepartment());
        if (depUsers != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomain(dto.getDepartment(), dto.getDomain()))) {
            Integer user_count;
            Organization org = dto.getDepartment().getOrgConfig().getOrganization();
            String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
            for (OrgConfig config : org.getOrgConfigs()) {
                if (1 != config.getLevel()) continue;
                depName = config.getName();
                break;
            }
            if (null != depQuotas.getAutomlCount() && depQuotas.getAutomlCount() != -1 && null != (user_count = this.experimentRepository.countByDepartmentAndDeletedAndDomainAndUserAndStatusIn(dto.getDepartment(), 0, dto.getDomain(), dto.getUser(), new Integer[]{0, 1, 4})) && user_count >= depQuotas.getAutomlCount()) {
                throw new MessageCodeException(dto.getName(), dto.getGuid(), "msg.dep.resource.insufficient.error", new String[]{depName});
            }
            if (null != depQuotas.getAutomlTime() && depQuotas.getAutomlTime() != -1.0) {
                List namespaces = this.experimentRepository.findGuidByDepartmentAndDeletedAndDomainAndUser(dto.getDepartment(), Integer.valueOf(0), dto.getDomain(), dto.getUser());
                Long rUserDuration = 0L;
                if (null != namespaces && !namespaces.isEmpty()) {
                    rUserDuration = this.referTrialDurationRepository.calculateByNamespaceIn(namespaces, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                }
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getAutomlTime() * 60.0 * 60.0) {
                    throw new MessageCodeException(dto.getName(), dto.getGuid(), "msg.dep.resource.time.insufficient.error", new String[]{depName});
                }
            }
        }
    }

    @LogAnnotation(type=7, msgExpression="msg.create.experiment")
    @Transactional
    public ResultResponse create(ExperimentRequest dto, HttpSession session) throws Exception {
        Integer paramNameCount;
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getName());
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, department);
        if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"automl:create", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        Integer count = this.experimentRepository.countByNameAndDepartmentIdAndDeleted(dto.getName(), depId, Integer.valueOf(0));
        if (count > 0) {
            throw new MessageJsonException(dto.getName(), null, "msg.dep.resource.name.exist.error", new String[]{"msg.type.automl"});
        }
        if (dto.getSaveParam() != null && dto.getSaveParam() == 1 && null != (paramNameCount = this.experimentParamsRepository.countByNameAndDepartmentAndDeleted(dto.getParamName(), department, Integer.valueOf(0))) && paramNameCount > 0) {
            throw new MessageCodeException(dto.getName(), null, "msg.job.param.name.exist", new String[0]);
        }
        JobVersion jobVersion = (JobVersion)this.jobVersionRepository.findOne((Serializable)dto.getJobVersionId());
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(jobVersion.getJob().getDomain()).department(department).user(user).name(dto.getName()).pack(jobVersion.getPack()).replica(dto.getParallelTrialCount()).priority(Integer.valueOf(0)).operate("create").build();
        this.checkDepQuota(identityDto);
        this.commonService.judgeResource(identityDto);
        this.judgeSysResource(identityDto);
        String guid = UUID.randomUUID().toString().replace("-", "");
        Experiment experiment = new Experiment();
        experiment.setName(dto.getName());
        experiment.setDeleted(Integer.valueOf(0));
        experiment.setDepartment(department);
        experiment.setUser(user);
        experiment.setDomain(identityDto.getDomain());
        experiment.setGuid(guid);
        experiment.setJobVersion(jobVersion);
        experiment.setStatus(Integer.valueOf(0));
        experiment.setReplica(dto.getParallelTrialCount());
        this.experimentRepository.saveAndFlush((Object)experiment);
        ExperimentParams params = null;
        if (dto.getSaveParam() != null && dto.getSaveParam() == 1) {
            params = new ExperimentParams();
            params.setJobVersion(jobVersion);
            params.setDeleted(Integer.valueOf(0));
            params.setSequence(UUID.randomUUID().toString().substring(24));
            params.setUser(user);
            params.setDepartment(department);
            params.setDomain(identityDto.getDomain());
            params.setName(dto.getParamName());
            params.setRemark(dto.getParamRemark());
            params.setParallelTrialCount(dto.getParallelTrialCount());
            params.setMaxTrialCount(dto.getMaxTrialCount());
            params.setMaxFailedTrialCount(dto.getMaxFailedTrialCount());
            params.setAlgorithm(JSONObject.fromObject((Object)dto.getAlgorithm()).toString());
            params.setEarlyStopping(dto.getEarlyStopping() != null ? JSONObject.fromObject((Object)dto.getEarlyStopping()).toString() : null);
            params.setMetricsCollectorSpec(JSONObject.fromObject((Object)dto.getMetricsCollectorSpec()).toString());
            params.setObjective(JSONObject.fromObject((Object)dto.getObjective()).toString());
            List parameters = dto.getParameters();
            JSONArray jsonArray = new JSONArray();
            for (V1beta1ParameterSpec parameterSpec : parameters) {
                jsonArray.add((Object)JSONObject.fromObject((Object)parameterSpec).toString());
            }
            params.setParameters(jsonArray.toString());
            params.setResumePolicy(dto.getResumePolicy());
            this.experimentParamsRepository.saveAndFlush((Object)params);
        }
        res.setEntity(dto.getName());
        res.setGuid(guid);
        Long paramsId = null != params ? params.getId() : null;
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        return res;
    }

    @Transactional
    @LogAnnotation(type=7, msgExpression="msg.remove.experiment")
    public ResultResponse remove(IdsRequest dto, HttpSession session) throws ApiException {
        ResultResponse res = new ResultResponse();
        List experiments = this.experimentRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        if (!experiments.isEmpty()) {
            Long domainId = (Long)session.getAttribute("domain");
            Long userId = (Long)session.getAttribute("userId");
            Long depId = (Long)session.getAttribute("departmentId");
            OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
            User user = (User)this.userRepository.findOne((Serializable)userId);
            DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            StringBuilder names = new StringBuilder();
            StringBuilder guids = new StringBuilder();
            Date now = new Date();
            for (Experiment experiment : experiments) {
                if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(experiment.getUser().getId()), (String)"automl:delete", (Long)depId)) {
                    throw new MessageCodeException(null, null, "msg.account.unauthorized", new String[0]);
                }
                experiment.setDeleted(Integer.valueOf(1));
                k8sFactory.deleteNamespace(experiment.getGuid());
                names.append(",").append(experiment.getName());
                guids.append(",").append(experiment.getGuid());
                List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(experiment.getId(), Integer.valueOf(6));
                for (Materials material : materials) {
                    material.setLastedAt(now);
                }
                List durations = this.referTrialDurationRepository.findByNamespaceAndEndIsNull(experiment.getGuid());
                if (durations == null) continue;
                for (ReferTrialDuration duration : durations) {
                    duration.setEnd(now);
                }
            }
            res.setEntity(names.substring(1));
            res.setGuid(guids.substring(1));
        }
        return res;
    }

    @Transactional
    @LogAnnotation(type=7, msgExpression="msg.start.experiment")
    public ResultResponse start(Long id, HttpSession session) throws Exception {
        ResultResponse res = new ResultResponse();
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        if (null == experiment || experiment.getDeleted() == 1) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.automl.not.exist.error"));
            return res;
        }
        res.setEntity(experiment.getName());
        res.setGuid(experiment.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(experiment.getUser().getId()), (String)"automl:start", (Long)depId)) {
            throw new MessageCodeException(null, null, "msg.account.unauthorized", new String[0]);
        }
        JobVersion jobVersion = experiment.getJobVersion();
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(jobVersion.getJob().getDomain()).department(dep).user(user).name(experiment.getName()).pack(jobVersion.getPack()).replica(experiment.getReplica()).priority(Integer.valueOf(0)).operate("start").build();
        this.checkDepQuotaStart(identityDto);
        this.commonService.judgeResource(identityDto);
        this.judgeSysResource(identityDto);
        List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(experiment.getId(), Integer.valueOf(6));
        Date now = new Date();
        for (Materials material : materials) {
            material.setLastedAt(now);
        }
        experiment.setStatus(Integer.valueOf(4));
        experiment.setStartAt(new Date());
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)experiment.getDomain().getId());
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        return res;
    }

    @Transactional
    @LogAnnotation(type=7, msgExpression="msg.stop.experiment")
    public ResultResponse stop(Long id, HttpSession session) {
        ResultResponse res = new ResultResponse();
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        if (null == experiment || experiment.getDeleted() == 1) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.automl.not.exist.error"));
            return res;
        }
        res.setEntity(experiment.getName());
        res.setGuid(experiment.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(experiment.getUser().getId()), (String)"automl:start", (Long)depId)) {
            throw new MessageCodeException(experiment.getName(), experiment.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        try {
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)experiment.getDomain().getId());
            k8sFactory.experimentApi.delete(experiment.getGuid(), "exp").throwsApiException();
            k8sFactory.deletePods(experiment.getGuid());
            experiment.setStatus(Integer.valueOf(3));
            experiment.setStopAt(new Date());
            List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(experiment.getId(), Integer.valueOf(6));
            Date now = new Date();
            for (Materials material : materials) {
                material.setLastedAt(now);
            }
            List durations = this.referTrialDurationRepository.findByNamespaceAndEndIsNull(experiment.getGuid());
            if (durations != null) {
                for (ReferTrialDuration duration : durations) {
                    duration.setEnd(now);
                }
            }
        }
        catch (ApiException e) {
            LOGGER.info(e.getResponseBody());
            res.setCode(Constants.SC_ERROR);
            throw new MessageCodeException(experiment.getName(), experiment.getGuid(), "msg.stop.experiment.failed", new String[0]);
        }
        return res;
    }

    public ListResultResponse<ExperimentVO> list(ExperimentSortPageRequest dto, HttpSession session) throws IOException, ApiException {
        ListResultResponse res = new ListResultResponse();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        Integer finalLevel = level;
        3 spec = new /* Unavailable Anonymous Inner Class!! */;
        PageRequest pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"});
        Page page = this.experimentRepository.findAll((Specification)spec, (Pageable)pageable);
        res.setPages(Integer.valueOf(page.getTotalPages()));
        res.setSize(Long.valueOf(page.getTotalElements()));
        if (page.getTotalElements() > 0L) {
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            List experiments = page.getContent();
            ArrayList<ExperimentVO> models = new ArrayList<ExperimentVO>();
            for (Experiment experiment : experiments) {
                ExperimentVO model = this.getExperimentVO(level, k8sFactory, experiment);
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    private ExperimentVO getExperimentVO(Integer level, K8sFactory k8sFactory, Experiment experiment) throws IOException {
        ExperimentVO model = new ExperimentVO();
        model.setId(experiment.getId());
        model.setName(experiment.getName());
        model.setUsername(experiment.getUser().getUsername());
        model.setFullName(experiment.getUser().getName());
        model.setSeq(experiment.getGuid());
        model.setCreatedAt(experiment.getCreatedAt());
        model.setStatus(experiment.getStatus());
        model.setErrorMessage(experiment.getMsg());
        JobVersion jobVersion = experiment.getJobVersion();
        if (null != jobVersion) {
            model.setJobName(jobVersion.getName());
            model.setJobVersion(jobVersion.getVersion());
            PricePackage pack = jobVersion.getPack();
            PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
            if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
            }
            model.setPack(packageInfoModel);
            model.setReplica(jobVersion.getReplicas());
        }
        if (level == 3) {
            model.setCreatorQuited(Integer.valueOf(0));
        } else {
            DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(experiment.getUser(), experiment.getDepartment());
            if (resourceDepUser != null) {
                model.setCreatorQuited(Integer.valueOf(0));
            } else {
                model.setCreatorQuited(Integer.valueOf(1));
            }
        }
        V1beta1Experiment exp = (V1beta1Experiment)k8sFactory.experimentApi.get(experiment.getGuid(), "exp").getObject();
        if (null != exp && experiment.getStatus() == 1) {
            experiment.setVo(Yaml.dump((Object)exp));
        } else if (null == exp) {
            if (!StringUtils.isEmpty((Object)experiment.getVo())) {
                exp = (V1beta1Experiment)Yaml.load((String)experiment.getVo());
            } else if (!StringUtils.isEmpty((Object)experiment.getYaml())) {
                exp = (V1beta1Experiment)Yaml.load((String)experiment.getYaml());
            } else {
                return model;
            }
        }
        V1beta1ObjectiveSpec objective = exp.getSpec().getObjective();
        model.setObjectiveGoal(objective.getObjectiveMetricName() + ("maximize".equals(objective.getType()) ? " > " : " < ") + objective.getGoal());
        V1beta1ExperimentStatus status = exp.getStatus();
        if (null != status) {
            List conditions = status.getConditions();
            if (conditions != null && !conditions.isEmpty()) {
                model.setState(((V1beta1ExperimentCondition)conditions.get(conditions.size() - 1)).getType());
            }
            model.setFailedTrail(status.getTrialsFailed());
            model.setRunningTrail(status.getTrialsRunning());
            model.setSuccessTrial(status.getTrialsSucceeded());
            model.setConditions(status.getConditions());
            model.setOptimalTrial(status.getCurrentOptimalTrial());
        }
        return model;
    }

    @LogAnnotation(type=7, msgExpression="msg.edit.name")
    @Transactional
    public ResultResponse nameEdit(Long id, String name, HttpSession session) {
        ResultResponse res = new ResultResponse();
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        res.setEntity(experiment.getName());
        res.setGuid(experiment.getGuid());
        Integer count = this.experimentRepository.countByNameAndDeletedAndIdNot(name, Integer.valueOf(0), id);
        if (count > 0) {
            throw new MessageCodeException(null, null, "msg.name.exist", new String[0]);
        }
        experiment.setName(name);
        res.setEntity(experiment.getName());
        return res;
    }

    public ExperimentInfoVO getDetail(Long id, HttpSession session) throws IOException, ApiException {
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        ExperimentVO experimentVO = this.getExperimentVO(level, k8sFactory, experiment);
        int cpus = experimentVO.getPack().getCpuNum();
        ExperimentInfoVO res = (ExperimentInfoVO)BeanMapper.copy((Object)experimentVO, ExperimentInfoVO.class);
        res.setStopAt(experiment.getStopAt());
        res.setStartAt(experiment.getStartAt());
        JobVersion jobVersion = experiment.getJobVersion();
        res.setJob(jobVersion.getJob().getName());
        res.setJobVersion(jobVersion.getVersion());
        String namespace = experiment.getGuid();
        List trials = ((V1beta1TrialList)k8sFactory.trialApi.list(namespace).getObject()).getItems();
        HashMap<String, List> map = new HashMap<String, List>();
        for (V1beta1Trial trial : trials) {
            V1beta1TrialCondition lastOne;
            List conditions = trial.getStatus().getConditions();
            if (null == conditions || conditions.isEmpty() || !"Running".equals((lastOne = (V1beta1TrialCondition)conditions.get(conditions.size() - 1)).getType()) || !"True".equals(lastOne.getStatus())) continue;
            String name = trial.getMetadata().getName();
            map.put(name, this.trialMetrics(namespace, k8sFactory, name, Integer.valueOf(cpus)));
        }
        res.setInstantMetrics(map);
        return res;
    }

    private List<InstantMetricModel> trialMetrics(String namespace, K8sFactory k8sFactory, String jobName, Integer cpus) {
        try {
            List podList = k8sFactory.coreV1Api.listNamespacedPod(namespace, null, null, null, null, "kubeflow-role=train,training.kubeflow.org/job-name=" + jobName, null, null, null, null, null).getItems();
            if (!podList.isEmpty()) {
                ArrayList<InstantMetricModel> models = new ArrayList<InstantMetricModel>(podList.size());
                for (V1Pod pod : podList) {
                    boolean present;
                    List conditions = pod.getStatus().getConditions();
                    if (null == conditions || conditions.isEmpty() || !(present = conditions.stream().anyMatch(e -> "Ready".equals(e.getType()) && "True".equals(e.getStatus())))) continue;
                    InstantMetricModel model = k8sFactory.podCpuMemoryUsage(pod.getMetadata().getUid(), cpus);
                    model.setGpuUsage(k8sFactory.podGpusMetrics(pod));
                    models.add(model);
                }
                return models;
            }
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage());
        }
        return null;
    }

    public TrialListVO listTrials(Long id, HttpSession session) throws IOException, ApiException {
        TrialListVO res = new TrialListVO();
        Long domainId = (Long)session.getAttribute("domain");
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        V1beta1Experiment exp = (V1beta1Experiment)k8sFactory.experimentApi.get(experiment.getGuid(), "exp").getObject();
        if (null == exp) {
            if (!StringUtils.isEmpty((Object)experiment.getYaml())) {
                exp = (V1beta1Experiment)Yaml.load((String)experiment.getYaml());
            } else {
                return res;
            }
        }
        V1beta1ExperimentSpec experimentSpec = exp.getSpec();
        ArrayList<TrialHeaderVO> headers = new ArrayList<TrialHeaderVO>();
        headers.add(TrialHeaderVO.builder().name(this.messageUtil.getMessage("msg.experiment.trial.name")).type("string").build());
        headers.add(TrialHeaderVO.builder().name(this.messageUtil.getMessage("msg.experiment.trial.status")).type("string").build());
        V1beta1ObjectiveSpec objective = experimentSpec.getObjective();
        headers.add(TrialHeaderVO.builder().name(objective.getObjectiveMetricName()).type("double").build());
        List additionalMetricNames = objective.getAdditionalMetricNames();
        if (null != additionalMetricNames) {
            for (String name : additionalMetricNames) {
                headers.add(TrialHeaderVO.builder().name(name).type("double").build());
            }
        }
        if (null != experimentSpec.getParameters()) {
            experimentSpec.getParameters().forEach(e -> headers.add(TrialHeaderVO.builder().name(e.getName()).type(e.getParameterType()).feasibleSpace("categorical".equals(e.getParameterType()) || "discrete".equals(e.getParameterType()) ? e.getFeasibleSpace().getList() : null).build()));
        }
        List items = ((V1beta1TrialList)k8sFactory.trialApi.list(experiment.getGuid()).getObject()).getItems();
        res.setSize(Integer.valueOf(items.size()));
        ArrayList<TrialVO> trials = new ArrayList<TrialVO>();
        for (V1beta1Trial trial : items) {
            TrialVO model = new TrialVO();
            model.setName(trial.getMetadata().getName());
            List conditions = trial.getStatus().getConditions();
            if (null != conditions && !conditions.isEmpty()) {
                model.setStatus(((V1beta1TrialCondition)conditions.get(conditions.size() - 1)).getType());
            }
            ArrayList<String> metrics = new ArrayList<String>();
            List metricStrategies = trial.getSpec().getObjective().getMetricStrategies();
            V1beta1Observation observation = trial.getStatus().getObservation();
            if (metricStrategies != null) {
                for (V1beta1MetricStrategy strategy : metricStrategies) {
                    if (null != observation) {
                        Optional<V1beta1Metric> optional = observation.getMetrics().stream().filter(e -> e.getName().equals(strategy.getName())).findAny();
                        if (optional.isPresent()) {
                            if ("max".equals(strategy.getValue())) {
                                metrics.add(optional.get().getMax());
                                continue;
                            }
                            metrics.add(optional.get().getMin());
                            continue;
                        }
                        metrics.add("");
                        continue;
                    }
                    metrics.add("");
                }
            }
            List parameters = trial.getSpec().getParameterAssignments();
            for (V1beta1ParameterAssignment parameter : parameters) {
                metrics.add(parameter.getValue());
            }
            model.setMetrics(metrics);
            trials.add(model);
        }
        res.setTrials(trials);
        res.setHeaders(headers);
        res.setNamespace(experiment.getGuid());
        return res;
    }

    public ExperimentDetailVO experimentDetail(Long id, HttpSession session) throws IOException, ApiException {
        ExperimentDetailVO res = new ExperimentDetailVO();
        Long domainId = (Long)session.getAttribute("domain");
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        V1beta1Experiment object = (V1beta1Experiment)k8sFactory.experimentApi.get(experiment.getGuid(), "exp").getObject();
        if (null == object) {
            if (!StringUtils.isEmpty((Object)experiment.getYaml())) {
                object = (V1beta1Experiment)Yaml.load((String)experiment.getYaml());
            } else {
                return res;
            }
        }
        V1beta1ExperimentSpec spec = object.getSpec();
        res.setObjective(spec.getObjective());
        res.setParameters(spec.getParameters());
        res.setCollector(spec.getMetricsCollectorSpec().getCollector().getKind());
        res.setAlgorithm(spec.getAlgorithm().getAlgorithmName());
        res.setMaxTrial(spec.getMaxTrialCount());
        res.setMaxFailedTrial(spec.getMaxFailedTrialCount());
        res.setParallelTrial(spec.getParallelTrialCount());
        return res;
    }

    public String experimentYaml(Long id, HttpSession session) throws ApiException {
        Long domainId = (Long)session.getAttribute("domain");
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        V1beta1Experiment object = (V1beta1Experiment)k8sFactory.experimentApi.get(experiment.getGuid(), "exp").getObject();
        return null == object ? (StringUtils.isEmpty((Object)experiment.getVo()) ? experiment.getYaml() : experiment.getVo()) : Yaml.dump((Object)object);
    }

    public String trialMetric(String trialName, String namespace, HttpSession session) throws ApiException {
        Long domainId = (Long)session.getAttribute("domain");
        return FactoryCollection.k8sFactory((Long)domainId).connectServiceProxy("katib-ui:ui", "kubeflow", String.format("katib/fetch_hp_job_trial_info/?trialName=%s&namespace=%s", trialName, namespace));
    }

    private void checkExperiment(K8sFactory k8sFactory, String namespace) {
        List trials = ((V1beta1TrialList)k8sFactory.trialApi.list(namespace).getObject()).getItems();
        for (V1beta1Trial trial : trials) {
            if (null == trial.getStatus()) continue;
            List durations = this.referTrialDurationRepository.findByUid(trial.getMetadata().getUid());
            if (CollectionUtils.isEmpty((Collection)durations)) {
                ReferTrialDuration duration = new ReferTrialDuration();
                duration.setUid(trial.getMetadata().getUid());
                duration.setNamespace(namespace);
                if (trial.getStatus().getStartTime() != null) {
                    duration.setStart(new Date(trial.getStatus().getStartTime().toInstant().toEpochMilli()));
                }
                if (trial.getStatus().getCompletionTime() != null) {
                    duration.setEnd(new Date(trial.getStatus().getCompletionTime().toInstant().toEpochMilli()));
                }
                this.referTrialDurationRepository.save((Object)duration);
                durations.add(duration);
            }
            for (ReferTrialDuration duration : durations) {
                if (duration.getStart() == null && trial.getStatus().getStartTime() != null) {
                    Date start = new Date(trial.getStatus().getStartTime().toInstant().toEpochMilli());
                    duration.setStart(start);
                }
                if (duration.getEnd() != null || trial.getStatus().getCompletionTime() == null) continue;
                Date end = new Date(trial.getStatus().getCompletionTime().toInstant().toEpochMilli());
                duration.setEnd(end);
            }
            List conditions = trial.getStatus().getConditions();
            if (null == conditions) continue;
            List materials = this.materialsRepository.findByUid(trial.getMetadata().getUid());
            for (V1beta1TrialCondition condition : conditions) {
                if (!"True".equals(condition.getStatus())) continue;
                if ("Created".equals(condition.getType()) && materials.isEmpty()) {
                    OffsetDateTime last = condition.getLastTransitionTime();
                    materials.add(this.newMaterial(trial.getMetadata(), last));
                }
                if (!"Succeeded".equals(condition.getType()) && !"Failed".equals(condition.getType())) continue;
                Date end = new Date(condition.getLastTransitionTime().toInstant().toEpochMilli());
                for (Materials material : materials) {
                    material.setLastedAt(end);
                }
            }
        }
    }

    @Transactional
    public void schedule() {
        try {
            List experiments = this.experimentRepository.findSchedule();
            for (Experiment experiment : experiments) {
                List conditions;
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)experiment.getDomain().getId());
                String guid = experiment.getGuid();
                V1beta1Experiment exp = (V1beta1Experiment)k8sFactory.experimentApi.get(guid, "exp").getObject();
                if (null == exp || null == exp.getStatus() || null == (conditions = exp.getStatus().getConditions()) || conditions.isEmpty()) continue;
                String type = ((V1beta1ExperimentCondition)conditions.get(conditions.size() - 1)).getType();
                if (!"Running".equals(type)) {
                    probe.put(guid, probe.getOrDefault(guid, 0) + 1);
                    if ((Integer)probe.get(guid) < 5) continue;
                    probe.remove(guid);
                }
                SystemConfig platform = this.systemConfigRepository.findByConfigName("PLATFORM");
                switch (type) {
                    case "Running": {
                        if (experiment.getStatus() != 0 && experiment.getStatus() != 4 || !this.experimentStatusCheck(k8sFactory, guid).booleanValue()) break;
                        experiment.setStatus(Integer.valueOf(1));
                        if (null == platform || Strings.isNullOrEmpty((String)platform.getConfigValue())) break;
                        this.noticeUserService.pushNotice(this.messageUtil.getMessageJson("msg.experiment.train.start.title"), this.messageUtil.getMessageJson("msg.experiment.train.start", new String[]{platform.getConfigValue(), experiment.getName()}), experiment.getUser());
                        this.noticeUserService.automlMessage(Integer.valueOf(0), experiment.getUser(), experiment.getName());
                        break;
                    }
                    case "Succeeded": {
                        experiment.setStatus(Integer.valueOf(2));
                        experiment.setStopAt(new Date());
                        if (null == platform || Strings.isNullOrEmpty((String)platform.getConfigValue())) break;
                        this.noticeUserService.pushNotice(this.messageUtil.getMessageJson("msg.experiment.train.succeeded.title"), this.messageUtil.getMessageJson("msg.experiment.train.succeeded", new String[]{platform.getConfigValue(), experiment.getName()}), experiment.getUser());
                        this.noticeUserService.automlMessage(Integer.valueOf(2), experiment.getUser(), experiment.getName());
                        break;
                    }
                    case "Failed": {
                        experiment.setStatus(Integer.valueOf(-1));
                        experiment.setStopAt(new Date());
                        if (null == platform || Strings.isNullOrEmpty((String)platform.getConfigValue())) break;
                        this.noticeUserService.pushNotice(this.messageUtil.getMessageJson("msg.experiment.train.failed.title"), this.messageUtil.getMessageJson("msg.experiment.train.failed", new String[]{platform.getConfigValue(), experiment.getName()}), experiment.getUser());
                        this.noticeUserService.automlMessage(Integer.valueOf(1), experiment.getUser(), experiment.getName());
                        break;
                    }
                    default: {
                        List events = k8sFactory.coreV1Api.listNamespacedEvent(guid, null, null, null, "reason=\"ReconcileError\"", null, null, null, null, null, null).getItems();
                        if (CollectionUtils.isEmpty((Collection)events)) break;
                        CoreV1Event event = (CoreV1Event)events.get(0);
                        experiment.setStatus(Integer.valueOf(-1));
                        experiment.setMsg(event.getMessage());
                        experiment.setStopAt(Date.from(event.getFirstTimestamp().toInstant()));
                        k8sFactory.deletePods(guid);
                    }
                }
                this.checkExperiment(k8sFactory, guid);
            }
        }
        catch (Exception e) {
            LOGGER.error(e instanceof ApiException ? ((ApiException)((Object)e)).getResponseBody() : e.getMessage(), (Throwable)e);
        }
    }

    private Boolean experimentStatusCheck(K8sFactory k8sFactory, String namespace) {
        try {
            List pods = k8sFactory.coreV1Api.listNamespacedPod(namespace, null, null, null, "status.phase=Running", "kubeflow-role=train", null, null, null, null, null).getItems();
            if (!pods.isEmpty()) {
                for (V1Pod pod : pods) {
                    List conditions = pod.getStatus().getConditions();
                    if (null == conditions) continue;
                    for (V1PodCondition condition : conditions) {
                        if (!"Ready".equals(condition.getType()) || !"True".equals(condition.getStatus())) continue;
                        return true;
                    }
                }
            }
        }
        catch (ApiException e) {
            LOGGER.error(e.getResponseBody(), (Throwable)e);
        }
        return false;
    }

    private Materials newMaterial(V1ObjectMeta metadata, OffsetDateTime start) {
        Materials materials = new Materials();
        materials.setUid(metadata.getUid());
        materials.setGuid(metadata.getNamespace());
        Experiment experiment = this.experimentRepository.findByGuid(metadata.getNamespace());
        if (null != experiment) {
            materials.setResourceId(experiment.getId());
            materials.setDomain(experiment.getDomain());
            materials.setDepartment(experiment.getDepartment());
            materials.setOrganization(experiment.getDepartment().getOrgConfig().getOrganization());
            JobVersion jobVersion = experiment.getJobVersion();
            materials.setPack(jobVersion.getPack());
            materials.setResourceInstance(jobVersion.getReplicas());
            materials.setUser(experiment.getUser());
        }
        Date begin = new Date(start.toInstant().toEpochMilli());
        materials.setCreatedAt(begin);
        materials.setCostTime(begin);
        materials.setPackageType(Integer.valueOf(2));
        materials.setType(Integer.valueOf(6));
        return this.materialsRepository.save(materials);
    }

    public ListResultResponse<ExperimentParamModel> listParam(JobParamSortPageRequest dto, HttpSession session) {
        PageRequest pageable;
        Integer finalLevel;
        4 spec;
        Page page;
        ListResultResponse res = new ListResultResponse();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (page = this.experimentParamsRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */), (Pageable)(pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"}))))) {
            List experimentParams = page.getContent();
            res.setPages(Integer.valueOf(page.getTotalPages()));
            res.setSize(Long.valueOf(page.getTotalElements()));
            ArrayList<ExperimentParamModel> models = new ArrayList<ExperimentParamModel>(experimentParams.size());
            for (ExperimentParams params : experimentParams) {
                ExperimentParamModel model = new ExperimentParamModel();
                JobVersion version = params.getJobVersion();
                Job job = version.getJob();
                model.setId(params.getId());
                model.setJobId(job.getId());
                model.setJobName(job.getName());
                model.setJobVersion(version.getVersion());
                model.setName(params.getName());
                model.setSeq(params.getSequence());
                model.setCreateTime(params.getCreatedAt());
                model.setUsername(params.getUser().getUsername());
                model.setFullName(params.getUser().getName());
                PricePackage pack = version.getPack();
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (null != pack.getGpu() && !Strings.isNullOrEmpty((String)pack.getGpu().getChargeItem())) {
                    packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setPack(packageInfoModel);
                model.setReplicas(version.getReplicas());
                model.setParallelTrialCount(params.getParallelTrialCount());
                model.setMaxTrialCount(params.getMaxTrialCount());
                model.setMaxFailedTrialCount(params.getMaxFailedTrialCount());
                models.add(model);
            }
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=7, msgExpression="msg.remove.params.experiment")
    @Transactional
    public ResultResponse removeParam(IdsRequest dto, HttpSession session) {
        Long userId;
        ResultResponse res = new ResultResponse();
        List paramsList = this.experimentParamsRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        if (null == paramsList) {
            return res;
        }
        StringBuilder resourceNames = new StringBuilder();
        for (ExperimentParams params : paramsList) {
            resourceNames.append("," + params.getName());
        }
        if (resourceNames.length() > 1) {
            res.setEntity(String.valueOf(resourceNames).substring(1));
        }
        if ((userId = (Long)session.getAttribute("userId")) == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (null != dto.getIds() && dto.getIds().size() > 0) {
            Long id = (Long)dto.getIds().get(0);
            ExperimentParams params = (ExperimentParams)this.experimentParamsRepository.findOne((Serializable)id);
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(params.getUser().getId()), (String)"automl:paramsdelete", (Long)depId)) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                return res;
            }
        }
        this.experimentParamsRepository.removeByIds(dto.getIds());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=7, msgExpression="msg.edit.params.experiment")
    @Transactional
    public ResultResponse editParam(ExperimentEditRequestDto dto, HttpSession session) {
        ResultResponse res = new ResultResponse();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        ExperimentParams experimentParams = (ExperimentParams)this.experimentParamsRepository.findOne((Serializable)dto.getId());
        res.setEntity(experimentParams.getName());
        res.setGuid(experimentParams.getSequence());
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(experimentParams.getUser().getId()), (String)"automl:paramsedit", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        if (!StringUtils.isEmpty((Object)dto.getName())) {
            Integer count = this.experimentParamsRepository.countByNameAndDepartmentAndDeletedAndIdNot(dto.getName(), experimentParams.getDepartment(), Integer.valueOf(0), dto.getId());
            if (count > 0) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.job.param.name.exist"));
                return res;
            }
            experimentParams.setName(dto.getName());
        }
        JobVersion jobVersion = (JobVersion)this.jobVersionRepository.findOne((Serializable)dto.getJobVersionId());
        experimentParams.setJobVersion(jobVersion);
        experimentParams.setRemark(dto.getParamRemark());
        experimentParams.setParallelTrialCount(dto.getParallelTrialCount());
        experimentParams.setMaxTrialCount(dto.getMaxTrialCount());
        experimentParams.setMaxFailedTrialCount(dto.getMaxFailedTrialCount());
        experimentParams.setAlgorithm(JSONObject.fromObject((Object)dto.getAlgorithm()).toString());
        experimentParams.setEarlyStopping(dto.getEarlyStopping() != null ? JSONObject.fromObject((Object)dto.getEarlyStopping()).toString() : null);
        experimentParams.setMetricsCollectorSpec(JSONObject.fromObject((Object)dto.getMetricsCollectorSpec()).toString());
        experimentParams.setObjective(JSONObject.fromObject((Object)dto.getObjective()).toString());
        List parameters = dto.getParameters();
        JSONArray jsonArray = new JSONArray();
        for (V1beta1ParameterSpec parameterSpec : parameters) {
            jsonArray.add((Object)JSONObject.fromObject((Object)parameterSpec).toString());
        }
        experimentParams.setParameters(jsonArray.toString());
        experimentParams.setResumePolicy(dto.getResumePolicy());
        return res;
    }

    public ExperimentParamsResponse getParam(Long id, HttpSession session) {
        ExperimentParamsResponse res = new ExperimentParamsResponse();
        ExperimentParams experimentParams = (ExperimentParams)this.experimentParamsRepository.findOne((Serializable)id);
        res.setId(experimentParams.getId());
        res.setName(experimentParams.getName());
        res.setRemark(experimentParams.getRemark());
        res.setSequence(experimentParams.getSequence());
        res.setCreatedAt(experimentParams.getCreatedAt());
        res.setParallelTrialCount(experimentParams.getParallelTrialCount());
        res.setMaxTrialCount(experimentParams.getMaxTrialCount());
        res.setMaxFailedTrialCount(experimentParams.getMaxFailedTrialCount());
        res.setAlgorithm(experimentParams.getAlgorithm());
        res.setEarlyStopping(experimentParams.getEarlyStopping());
        res.setMetricsCollectorSpec(experimentParams.getMetricsCollectorSpec());
        res.setResumePolicy(experimentParams.getResumePolicy());
        res.setYaml(experimentParams.getYaml());
        V1beta1ObjectiveSpec objective = (V1beta1ObjectiveSpec)AutoMLService.JSONToObject((String)experimentParams.getObjective(), V1beta1ObjectiveSpec.class);
        res.setObjective(objective);
        JSONArray jsonArray = JSONArray.fromObject((Object)experimentParams.getParameters());
        ArrayList<V1beta1ParameterSpec> parameters = new ArrayList<V1beta1ParameterSpec>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            V1beta1ParameterSpec parameterSpec = (V1beta1ParameterSpec)JSON.parseObject((String)String.valueOf(jsonArray.get(i)), V1beta1ParameterSpec.class);
            parameters.add(parameterSpec);
        }
        res.setParameters(parameters);
        JobVersion jobVersion = experimentParams.getJobVersion();
        Job job = jobVersion.getJob();
        res.setJobId(job.getId());
        res.setJobVersionId(jobVersion.getId());
        res.setUsername(experimentParams.getUser().getUsername());
        res.setFullName(experimentParams.getUser().getName());
        res.setJobVersionName(jobVersion.getName());
        res.setJobVersion(jobVersion.getVersion());
        res.setReplicas(jobVersion.getReplicas());
        PricePackage pack = jobVersion.getPack();
        PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
        if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
            packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
        }
        res.setPack(packageInfoModel);
        res.setPrice(pack.getCost());
        return res;
    }

    @LogAnnotation(type=7, msgExpression="msg.update.remark")
    @Transactional
    public ResultResponse editParamRemark(RemarkUpdateRequest dto, HttpSession session) {
        ResultResponse res = new ResultResponse();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        ExperimentParams experimentParams = (ExperimentParams)this.experimentParamsRepository.findOne((Serializable)dto.getId());
        res.setEntity(experimentParams.getName());
        res.setGuid(experimentParams.getSequence());
        experimentParams.setRemark(dto.getRemark());
        return res;
    }

    public static Object JSONToObject(String json, Class beanClass) {
        Gson gson = new Gson();
        Object res = gson.fromJson(json, beanClass);
        return res;
    }

    public ResultResponse checkAutomlQuota(HttpSession session) {
        DepQuotas depQuotas;
        DepUsers depUsers;
        Integer res_limit;
        ResultResponse res = new ResultResponse();
        Long domain_id = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domain_id, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domain_id);
        if (null == orgQuotas) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (orgQuotas.getStatus() != 1) {
            res.setMessage(this.messageUtil.getMessage("msg.account.org.domain.disabled"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List orgConfigs = org.getOrgConfigs();
        OrgConfig orgConfig = null;
        String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
        for (OrgConfig c : orgConfigs) {
            if (c.getLevel() != 1) continue;
            orgConfig = c;
            depName = orgConfig.getName();
            break;
        }
        if (null != (res_limit = orgQuotas.getResourceCount()) && res_limit != -1) {
            List depIds = this.orgConfigDepartmentRepository.findIdsByOrgConfigAndDeleted(orgConfig, Integer.valueOf(0));
            Integer org_count = 0;
            if (depIds != null && depIds.size() > 0) {
                for (Long dId : depIds) {
                    org_count = org_count + this.experimentRepository.countByDepartmentIdAndDeletedAndDomain(dId, Integer.valueOf(0), domain);
                }
            }
            if (org_count >= res_limit) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.resource.org.insufficient"));
                return res;
            }
        }
        if ((depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep)) != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domain_id))) {
            Integer user_count;
            if (null != depQuotas.getAutomlCount() && depQuotas.getAutomlCount() != -1 && null != (user_count = this.experimentRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user)) && user_count >= depQuotas.getAutomlCount()) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.insufficient.error", new String[]{depName}));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (null != depQuotas.getAutomlTime() && depQuotas.getAutomlTime() != -1.0) {
                List namespaces = this.experimentRepository.findGuidByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user);
                Long rUserDuration = 0L;
                if (null != namespaces && !namespaces.isEmpty()) {
                    rUserDuration = this.referTrialDurationRepository.calculateByNamespaceIn(namespaces, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                }
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getAutomlTime() * 60.0 * 60.0) {
                    res.setMessage(this.messageUtil.getMessage("msg.dep.resource.time.insufficient.error", new String[]{depName}));
                    res.setCode(Constants.SC_MSG);
                    return res;
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=7, msgExpression="msg.save.params.experiment")
    public ResultResponse saveParam(ExperimentParamRequest dto, HttpSession session) {
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getParamName());
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, department);
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)dto.getId());
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(experiment.getUser().getId()), (String)"automl:saveparam", (Long)depId)) {
            throw new MessageCodeException(null, null, "msg.account.unauthorized", new String[0]);
        }
        Integer paramNameCount = this.experimentParamsRepository.countByNameAndDepartmentAndDeleted(dto.getParamName(), department, Integer.valueOf(0));
        if (null != paramNameCount && paramNameCount > 0) {
            throw new MessageCodeException(dto.getParamName(), null, "msg.job.param.name.exist", new String[0]);
        }
        ExperimentParams params = new ExperimentParams();
        params.setJobVersion(experiment.getJobVersion());
        params.setDeleted(Integer.valueOf(0));
        params.setSequence(UUID.randomUUID().toString().substring(24));
        params.setUser(user);
        params.setDepartment(department);
        params.setDomain(domain);
        params.setName(dto.getParamName());
        params.setRemark(dto.getParamRemark());
        params.setParallelTrialCount(dto.getParallelTrialCount());
        params.setMaxTrialCount(dto.getMaxTrialCount());
        params.setMaxFailedTrialCount(dto.getMaxFailedTrialCount());
        params.setAlgorithm(JSONObject.fromObject((Object)dto.getAlgorithm()).toString());
        params.setEarlyStopping(dto.getEarlyStopping() != null ? JSONObject.fromObject((Object)dto.getEarlyStopping()).toString() : null);
        params.setMetricsCollectorSpec(JSONObject.fromObject((Object)dto.getMetricsCollectorSpec()).toString());
        params.setObjective(JSONObject.fromObject((Object)dto.getObjective()).toString());
        List parameters = dto.getParameters();
        JSONArray jsonArray = new JSONArray();
        for (V1beta1ParameterSpec parameterSpec : parameters) {
            jsonArray.add((Object)JSONObject.fromObject((Object)parameterSpec).toString());
        }
        params.setParameters(jsonArray.toString());
        params.setResumePolicy(dto.getResumePolicy());
        params.setJobVersion((JobVersion)this.jobVersionRepository.findOne((Serializable)dto.getJobVersionId()));
        this.experimentParamsRepository.save((Object)params);
        res.setEntity(dto.getParamName());
        return res;
    }

    public ExperimentParamsResponse getAutomlInfo(Long id, HttpSession session) throws IOException, ApiException {
        ExperimentParamsResponse res = new ExperimentParamsResponse();
        Long domainId = (Long)session.getAttribute("domain");
        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)id);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        V1beta1Experiment object = (V1beta1Experiment)k8sFactory.experimentApi.get(experiment.getGuid(), "exp").getObject();
        if (null == object) {
            if (!StringUtils.isEmpty((Object)experiment.getYaml())) {
                object = (V1beta1Experiment)Yaml.load((String)experiment.getYaml());
            } else {
                return res;
            }
        }
        V1beta1ExperimentSpec spec = object.getSpec();
        res.setName(experiment.getName());
        res.setParallelTrialCount(spec.getParallelTrialCount());
        res.setMaxTrialCount(spec.getMaxTrialCount());
        res.setMaxFailedTrialCount(spec.getMaxFailedTrialCount());
        res.setAlgorithm(JSONObject.fromObject((Object)spec.getAlgorithm()).toString());
        res.setEarlyStopping(JSONObject.fromObject((Object)spec.getEarlyStopping()).toString());
        res.setMetricsCollectorSpec(JSONObject.fromObject((Object)spec.getMetricsCollectorSpec()).toString());
        res.setResumePolicy(spec.getResumePolicy());
        res.setYaml(experiment.getYaml());
        V1beta1ObjectiveSpec objective = spec.getObjective();
        res.setObjective(objective);
        JSONArray jsonArray = JSONArray.fromObject((Object)spec.getParameters());
        ArrayList<V1beta1ParameterSpec> parameters = new ArrayList<V1beta1ParameterSpec>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            V1beta1ParameterSpec parameterSpec = (V1beta1ParameterSpec)JSON.parseObject((String)String.valueOf(jsonArray.get(i)), V1beta1ParameterSpec.class);
            parameters.add(parameterSpec);
        }
        res.setParameters(parameters);
        JobVersion jobVersion = experiment.getJobVersion();
        Job job = jobVersion.getJob();
        res.setJobId(job.getId());
        res.setJobVersionId(jobVersion.getId());
        res.setUsername(experiment.getUser().getUsername());
        res.setFullName(experiment.getUser().getName());
        res.setJobVersionName(jobVersion.getName());
        res.setJobVersion(jobVersion.getVersion());
        res.setReplicas(jobVersion.getReplicas());
        PricePackage pack = jobVersion.getPack();
        PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
        if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
            packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
        }
        res.setPack(packageInfoModel);
        res.setPrice(pack.getCost());
        return res;
    }

    @ConstructorProperties(value={"experimentRepository", "userRepository", "jobVersionRepository", "messageUtil", "depUsersRepository", "materialsRepository", "domainRepository", "orgConfigDepartmentRepository", "storageServiceFactory", "resourceService", "commonService", "experimentParamsRepository", "depQuotasRepository", "referDurationRepository", "referTrialDurationRepository", "systemConfigRepository", "noticeUserService", "autoMLAsyncService", "organizationQuotasRepository"})
    public AutoMLService(ExperimentRepository experimentRepository, UserRepository userRepository, JobVersionRepository jobVersionRepository, MessageUtil messageUtil, DepUsersRepository depUsersRepository, MaterialsRepository materialsRepository, DomainRepository domainRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, StorageServiceFactory storageServiceFactory, ResourceService resourceService, CommonService commonService, ExperimentParamsRepository experimentParamsRepository, DepQuotasRepository depQuotasRepository, ReferDurationRepository referDurationRepository, ReferTrialDurationRepository referTrialDurationRepository, SystemConfigRepository systemConfigRepository, NoticeUserService noticeUserService, AutoMLAsyncService autoMLAsyncService, OrganizationQuotasRepository organizationQuotasRepository) {
        this.experimentRepository = experimentRepository;
        this.userRepository = userRepository;
        this.jobVersionRepository = jobVersionRepository;
        this.messageUtil = messageUtil;
        this.depUsersRepository = depUsersRepository;
        this.materialsRepository = materialsRepository;
        this.domainRepository = domainRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.storageServiceFactory = storageServiceFactory;
        this.resourceService = resourceService;
        this.commonService = commonService;
        this.experimentParamsRepository = experimentParamsRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.referDurationRepository = referDurationRepository;
        this.referTrialDurationRepository = referTrialDurationRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.noticeUserService = noticeUserService;
        this.autoMLAsyncService = autoMLAsyncService;
        this.organizationQuotasRepository = organizationQuotasRepository;
    }
}

