/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    private static Logger logger = Logger.getLogger(DateUtil.class);
    protected static final TimeZone s_gmtTimeZone = TimeZone.getTimeZone("GMT");
    public static final String dtLong = "yyMMddHHmm";
    private static String pattern = "[dd/MM/yyyy:HH:mm:ss Z]";

    public static Date format(String str, String pattern) {
        try {
            return new SimpleDateFormat(pattern, Locale.US).parse(str);
        }
        catch (ParseException e) {
            logger.error((Object)"DateFormatError", (Throwable)e);
            return null;
        }
    }

    public static Date format(String str) {
        return DateUtil.format((String)str, (String)pattern);
    }

    public static Date afterDays(Date date, Long days) {
        Long time = date.getTime();
        time = time + days * 24L * 60L * 60L * 1000L;
        return new Date(time);
    }

    public static Date beforeDays(Date date, Long days) {
        Long time = date.getTime();
        time = time - days * 24L * 60L * 60L * 1000L;
        return new Date(time);
    }

    public static Date afterHours(Date date, Long hours) {
        Long time = date.getTime();
        time = time + hours * 60L * 60L * 1000L;
        return new Date(time);
    }

    public static Date beforeHours(Date date, Long hours) {
        Long time = date.getTime();
        time = time - hours * 60L * 60L * 1000L;
        return new Date(time);
    }

    public static Date afterMinutes(Date date, Long minutes) {
        Long time = date.getTime();
        time = time + minutes * 60L * 1000L;
        return new Date(time);
    }

    public static Date afterSeconds(Date date, Long seconds) {
        Long time = date.getTime();
        time = time + seconds * 1000L;
        return new Date(time);
    }

    public static Date beforeMinutes(Date date, Long minutes) {
        Long time = date.getTime();
        time = time - minutes * 60L * 1000L;
        return new Date(time);
    }

    public static Date endOfDay(Date date) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd").format(date) + " 23:59:59";
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date startOfDay(Date date) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd").format(date) + " 00:00:00";
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date endOfHour(Date date) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd HH:").format(date) + "59:59";
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date startOfHour(Date date) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd HH:").format(date) + "00:00";
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date ignoreSeconds(Date date) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:").format(date) + "00";
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Map<String, Integer> getTime(Double time) throws Exception {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            double dday = time / 86400.0;
            int day = (int)(time / 86400.0);
            double dhour = dday - (double)day;
            int hour = (int)(dhour * 24.0);
            double dminute = (dhour *= 24.0) - (double)hour;
            int minute = (int)(dminute * 60.0);
            double dsecond = (dminute *= 60.0) - (double)minute;
            int second = (int)(dsecond * 60.0);
            map.put("day", day);
            map.put("hour", hour);
            map.put("minute", minute);
            map.put("second", second);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return map;
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String formatDateHbase(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyyMMddHHmmss").format(date);
    }

    public static String formatDateHMSbase(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(date);
    }

    public static Date toDate(String date, String pattern) {
        Date result = null;
        try {
            result = new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            logger.warn((Object)e);
        }
        return result;
    }

    public static Date toDate(String date) {
        return DateUtil.toDate((String)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String toLocalDateStr(String dateStr, String tz) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String result = null;
        try {
            Date date = sdf.parse(dateStr);
            sdf.setTimeZone(TimeZone.getTimeZone(tz));
            result = sdf.format(date);
        }
        catch (ParseException e) {
            logger.warn((Object)e);
        }
        return result;
    }

    public static String getDateDisplayString(String tz, Date time) {
        return DateUtil.getDateDisplayString((String)tz, (Date)time, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateDisplayString(String tz, Date time, String formatString) {
        SimpleDateFormat df = new SimpleDateFormat(formatString);
        df.setTimeZone(TimeZone.getTimeZone(tz));
        return df.format(time);
    }

    public static Date latestMinute(Date date) {
        Date dateTmp = DateUtil.startOfHour((Date)date);
        while (dateTmp.before(date) || dateTmp.equals(date)) {
            dateTmp = DateUtil.afterMinutes((Date)dateTmp, (Long)3L);
        }
        return DateUtil.beforeMinutes((Date)dateTmp, (Long)3L);
    }

    public static Date latestMinute(Date date, Long minute) {
        Date dateTmp = DateUtil.startOfHour((Date)date);
        while (dateTmp.before(date) || dateTmp.equals(date)) {
            dateTmp = DateUtil.afterMinutes((Date)dateTmp, (Long)minute);
        }
        return DateUtil.beforeMinutes((Date)dateTmp, (Long)minute);
    }

    public static Date latestHours(Date date) {
        Date dateTmp = DateUtil.startOfDay((Date)date);
        while (dateTmp.before(date) || dateTmp.equals(date)) {
            dateTmp = DateUtil.afterHours((Date)dateTmp, (Long)1L);
        }
        return DateUtil.beforeHours((Date)dateTmp, (Long)1L);
    }

    public static String getOrderNum() {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmm");
        return df.format(date);
    }

    public static Date parseDate(String strDate, String format) {
        Date result;
        try {
            result = new SimpleDateFormat(format).parse(strDate);
        }
        catch (ParseException e) {
            result = null;
        }
        return result;
    }
}

