/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpClientUtils {
    private static final Logger logger = Logger.getLogger(HttpClientUtils.class);

    public static CloseableHttpClient getInstance() {
        CloseableHttpClient client = null;
        try {
            SSLContext ctx = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(0).setConnectTimeout(0).build();
            client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(requestConfig).build();
        }
        catch (KeyManagementException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (KeyStoreException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return client;
    }

    public static String postByHttp(String url) {
        ArrayList params = new ArrayList();
        return HttpClientUtils.postByHttp((String)url, params);
    }

    public static String postByHttps(String url) {
        ArrayList params = new ArrayList();
        return HttpClientUtils.postByHttps((String)url, params);
    }

    public static String postByHttp(String url, List<NameValuePair> params) {
        return HttpClientUtils.postByHttp((String)url, params, (String)"application/json", new HashMap());
    }

    public static String postByHttps(String url, List<NameValuePair> params) {
        return HttpClientUtils.postByHttps((String)url, params, (String)"application/json", new HashMap());
    }

    public static String postFormByHttps(String url, List<NameValuePair> params) {
        return HttpClientUtils.postByHttps((String)url, params, (String)"application/x-www-form-urlencoded", new HashMap());
    }

    public static String postFormByHttps(String url, List<NameValuePair> params, Map<String, String> headers) {
        return HttpClientUtils.postByHttps((String)url, params, (String)"application/x-www-form-urlencoded", headers);
    }

    public static String postByHttps(String url, List<NameValuePair> params, String contentType, Map<String, String> headers) {
        CloseableHttpClient httpclient = HttpClientUtils.getInstance();
        return HttpClientUtils.post((String)url, params, (String)contentType, (CloseableHttpClient)httpclient, headers);
    }

    public static String postByHttp(String url, List<NameValuePair> params, String contentType, Map<String, String> headers) {
        CloseableHttpClient httpclient;
        if (url.startsWith("https")) {
            httpclient = HttpClientUtils.getInstance();
        } else {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(0).setConnectTimeout(0).build();
            httpclient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        }
        return HttpClientUtils.post((String)url, params, (String)contentType, (CloseableHttpClient)httpclient, headers);
    }

    public static String postJson(String url, Map<String, Object> params) {
        CloseableHttpClient httpclient = null;
        String res = null;
        try {
            if (url.startsWith("https")) {
                httpclient = HttpClientUtils.getInstance();
            } else {
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(0).setConnectTimeout(0).build();
                httpclient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
            }
            JSONObject json = new JSONObject();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                json.put(entry.getKey(), entry.getValue());
            }
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(json.toString(), StandardCharsets.UTF_8);
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            res = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private static String post(String url, List<NameValuePair> params, String contentType, CloseableHttpClient httpclient, Map<String, String> headers) {
        String restr = null;
        try {
            logger.debug((Object)("Start call url:" + url));
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity uefentity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
            uefentity.setContentType(contentType);
            httpPost.setEntity((HttpEntity)uefentity);
            if (headers != null && headers.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (String key : headers.keySet()) {
                    httpPost.setHeader(key, headers.get(key));
                    sb.append(key + "=" + headers.get(key) + ",");
                }
                logger.debug((Object)("Header is " + sb));
            }
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            restr = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            logger.debug((Object)("Result of call url(" + url + ") is:" + restr));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return restr;
    }

    public static String getByHttp(String url, String inputParam) {
        return HttpClientUtils.getByHttp((String)url, (String)inputParam, (String)"application/json", new HashMap());
    }

    public static String getByHttp(String url, String inputParam, String contentType, Map<String, String> headers) {
        CloseableHttpClient httpclient;
        if (url.startsWith("https")) {
            httpclient = HttpClientUtils.getInstance();
        } else {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(0).setConnectTimeout(0).build();
            httpclient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        }
        return HttpClientUtils.get((String)url, (String)inputParam, (String)contentType, (CloseableHttpClient)httpclient, headers);
    }

    public static String getFormByHttps(String url, String inputParam) {
        return HttpClientUtils.getByHttps((String)url, (String)inputParam, (String)"application/x-www-form-urlencoded");
    }

    public static String getByHttps(String url, String inputParam, String contentType) {
        return HttpClientUtils.getByHttps((String)url, (String)inputParam, (String)contentType, new HashMap());
    }

    public static String getByHttps(String url, String inputParam, String contentType, Map<String, String> headers) {
        CloseableHttpClient httpclient = HttpClientUtils.getInstance();
        return HttpClientUtils.get((String)url, (String)inputParam, (String)contentType, (CloseableHttpClient)httpclient, headers);
    }

    private static String get(String url, String inputParam, String contentType, CloseableHttpClient httpclient, Map<String, String> headers) {
        String restr = null;
        try {
            logger.debug((Object)("Start call url:" + url));
            logger.debug((Object)("Param is " + inputParam));
            StringEntity reqEntity = new StringEntity(inputParam, "utf-8");
            reqEntity.setContentType(contentType);
            HttpGet httpGet = "".equals(inputParam) ? new HttpGet(url) : new HttpGet(url + "?" + inputParam);
            if (headers != null && headers.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (String key : headers.keySet()) {
                    httpGet.addHeader(key, headers.get(key));
                    sb.append(key + "=" + headers.get(key) + ",");
                }
                logger.debug((Object)("Header is " + sb));
            }
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            restr = (String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
            logger.debug((Object)("Result of call url(" + url + ") is:" + restr));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return restr;
    }

    public static void main(String[] args) {
        HttpClientUtils.postByHttp((String)"http://workorder.butterfly.mopaas.com/ticketsys/getUnsolved?ticket=ST-7-5P7WsI1OUc2Qvf2HXEsV-cas01.example.org");
    }
}

