/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common.IPAddress;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import sun.net.util.IPAddressUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class IpUtils {
    private static final Integer TIME_OUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOuterNetIp(HttpServletRequest request) throws Exception {
        String ipAddr = IpUtils.getIpAddr((HttpServletRequest)request);
        boolean internalIp = IpUtils.internalIp((String)ipAddr);
        if (!internalIp) {
            return ipAddr;
        }
        StringBuilder result = new StringBuilder();
        try (BufferedReader in = null;){
            String line;
            URL url = new URL("http://www.icanhazip.com");
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "KeepAlive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setConnectTimeout(TIME_OUT);
            connection.setReadTimeout(TIME_OUT);
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        if (result.length() == 0 || result.length() > 15) {
            return ipAddr;
        }
        return result.toString();
    }

    public static boolean internalIp(String ip) {
        if ("127.0.0.1".equalsIgnoreCase(ip)) {
            return true;
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            return true;
        }
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return IpUtils.internalIp((byte[])addr);
    }

    public static boolean internalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static final String getIpAddr(HttpServletRequest request) throws Exception {
        String[] arr;
        if (request == null) {
            throw new Exception("======================request\u4e3anull======================");
        }
        String ipString = request.getHeader("x-forwarded-for");
        if (StringUtils.isBlank((String)ipString) || "unknown".equalsIgnoreCase(ipString)) {
            ipString = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((String)ipString) || "unknown".equalsIgnoreCase(ipString)) {
            ipString = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipString == null || ipString.length() == 0 || "unknown".equalsIgnoreCase(ipString)) {
            ipString = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ipString == null || ipString.length() == 0 || "unknown".equalsIgnoreCase(ipString)) {
            ipString = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ipString == null || ipString.length() == 0 || "unknown".equalsIgnoreCase(ipString)) {
            ipString = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank((String)ipString) || "unknown".equalsIgnoreCase(ipString)) {
            ipString = request.getRemoteAddr();
        }
        for (String str : arr = ipString.split(",")) {
            if ("unknown".equalsIgnoreCase(str)) continue;
            ipString = str;
            break;
        }
        return ipString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNowIP() throws IOException {
        String ip;
        try (BufferedReader br = null;){
            String s;
            URL url = new URL("https://v6r.ipip.net/?format=callback");
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer sb = new StringBuffer();
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n");
            }
            String webContent = sb.toString();
            int start = webContent.indexOf("(") + 2;
            int end = webContent.indexOf(")") - 1;
            ip = webContent = webContent.substring(start, end);
        }
        return ip;
    }
}

