/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mopaas.server.common.CheckSumBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class MobileMessageUtil {
    public static int sendValidateCode(String phone, String templateId, String URL2, String KEY, String SECRET, String LEN) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String curTime = String.valueOf(new Date().getTime() / 1000L);
            String nonce = String.valueOf(System.currentTimeMillis() / 120000L);
            String checkSum = CheckSumBuilder.getCheckSum((String)SECRET, (String)nonce, (String)curTime);
            HttpPost httpPost = new HttpPost(URL2);
            httpPost.addHeader("AppKey", KEY);
            httpPost.addHeader("Nonce", nonce);
            httpPost.addHeader("CurTime", curTime);
            httpPost.addHeader("CheckSum", checkSum);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("templateid", templateId));
            nvps.add(new BasicNameValuePair("mobile", phone));
            nvps.add(new BasicNameValuePair("codeLen", LEN));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "utf-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String responseEntity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            String code = JSON.parseObject((String)responseEntity).getString("code");
            if ("200".equals(code)) {
                int n = 200;
                return n;
            }
            int n = Integer.parseInt(code);
            return n;
        }
    }

    public static int checkMsg(String phone, String sum, String URL2, String KEY, String SECRET) throws IOException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost post = new HttpPost(URL2);
            String nonce = String.valueOf(System.currentTimeMillis() / 120000L);
            String curTime = String.valueOf(System.currentTimeMillis() / 1000L);
            String checkSum = CheckSumBuilder.getCheckSum((String)SECRET, (String)nonce, (String)curTime);
            post.addHeader("AppKey", KEY);
            post.addHeader("Nonce", nonce);
            post.addHeader("CurTime", curTime);
            post.addHeader("CheckSum", checkSum);
            post.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("mobile", phone));
            nameValuePairs.add(new BasicNameValuePair("code", sum));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "utf-8"));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            String responseEntity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            String code = JSON.parseObject((String)responseEntity).getString("code");
            if ("200".equals(code)) {
                int n = 200;
                return n;
            }
            int n = 500;
            return n;
        }
    }

    public static int sendMsg(List<String> tels, String templateId, List<String> params, String URL2, String KEY, String SECRET) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(URL2);
            String curTime = String.valueOf(new Date().getTime() / 1000L);
            String nonce = String.valueOf(System.currentTimeMillis() / 120000L);
            String checkSum = CheckSumBuilder.getCheckSum((String)SECRET, (String)nonce, (String)curTime);
            httpPost.addHeader("AppKey", KEY);
            httpPost.addHeader("Nonce", nonce);
            httpPost.addHeader("CurTime", curTime);
            httpPost.addHeader("CheckSum", checkSum);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            JSONArray telArray = new JSONArray();
            for (String string : tels) {
                JSONObject json = new JSONObject();
                json.put("tel", (Object)string);
                telArray.add(json.get((Object)"tel"));
            }
            String MOBILES = telArray.toString();
            nvps.add(new BasicNameValuePair("templateid", templateId));
            nvps.add(new BasicNameValuePair("mobiles", MOBILES));
            if (params != null && params.size() > 0) {
                JSONArray paramArray = new JSONArray();
                for (String string : params) {
                    JSONObject json = new JSONObject();
                    json.put("param", (Object)string);
                    paramArray.add(json.get((Object)"param"));
                }
                String PARAMS = paramArray.toString();
                nvps.add(new BasicNameValuePair("params", PARAMS));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "utf-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String responseEntity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            String code = JSON.parseObject((String)responseEntity).getString("code");
            if ("200".equals(code)) {
                int n = 200;
                return n;
            }
            int n = 500;
            return n;
        }
    }
}

