/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common;

import com.mopaas.server.common.Constants;
import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.exception.RateLimitException;
import com.pingplusplus.model.Charge;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class PingPlusPlusUtil {
    private static Logger logger = Logger.getLogger(PingPlusPlusUtil.class);

    public Charge createCharge(String apiKey, String appId, String PKCS8PrivateKey, String channel, int amount, String subject, String body, String clientIp, String orderNo, Long userId, HttpServletRequest request) {
        Pingpp.apiKey = apiKey;
        Pingpp.appId = appId;
        Pingpp.privateKey = PKCS8PrivateKey;
        Charge charge = null;
        HashMap<String, Object> chargeMap = new HashMap<String, Object>();
        chargeMap.put("amount", amount);
        chargeMap.put("currency", "cny");
        chargeMap.put("subject", subject);
        chargeMap.put("body", body);
        chargeMap.put("order_no", orderNo);
        chargeMap.put("channel", channel);
        chargeMap.put("client_ip", clientIp);
        HashMap<String, String> app = new HashMap<String, String>();
        app.put("id", appId);
        chargeMap.put("app", app);
        if (request.getHeader("Host") == null) {
            logger.error((Object)Constants.SC_ERROR);
        }
        String successUrl = "http://" + request.getHeader("Host") + "/#/user/recharge/success";
        chargeMap.put("extra", this.channelExtra(channel, successUrl));
        chargeMap.put("description", request.getHeader("Host"));
        try {
            charge = Charge.create(chargeMap);
        }
        catch (APIConnectionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ChannelException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RateLimitException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (APIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return charge;
    }

    public void getChargeList(String appId) {
        try {
            Integer limit = 3;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("app[id]", appId);
            params.put("limit", limit);
            Charge.list(params);
        }
        catch (AuthenticationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (APIConnectionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (APIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ChannelException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RateLimitException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void reverseCharge(String chargeId, String appId) {
        try {
            Charge.reverse((String)chargeId);
        }
        catch (APIConnectionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ChannelException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RateLimitException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (APIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getServerIp() {
        String sysType = System.getProperties().getProperty("os.name");
        if (sysType.toLowerCase().startsWith("win")) {
            String localIP = null;
            try {
                localIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (localIP != null) {
                return localIP;
            }
        } else {
            String ip = this.getIpByEthNum("eth0");
            if (ip != null) {
                return ip;
            }
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668IP\u9519\u8bef";
    }

    private String getIpByEthNum(String ethNum) {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (!ethNum.equals(netInterface.getName())) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668IP\u9519\u8bef";
    }

    private Map<String, Object> channelExtra(String channel, String successUrl) {
        Map<String, Object> extra = new HashMap<String, Object>();
        switch (channel) {
            case "alipay": {
                extra = this.alipayExtra();
                break;
            }
            case "alipay_wap": {
                extra = this.alipayWapExtra(successUrl);
                break;
            }
            case "alipay_pc_direct": {
                extra = this.alipayPcDirectExtra(successUrl);
                break;
            }
            case "wx_pub": {
                extra = this.wxPubExtra();
                break;
            }
            case "wx_wap": {
                extra = this.wxWapExtra(successUrl);
                break;
            }
            case "upacp_pc": {
                extra = this.upacpPcExtra(successUrl);
                break;
            }
            case "upacp_wap": {
                extra = this.upacpWapExtra(successUrl);
            }
        }
        return extra;
    }

    private Map<String, Object> alipayExtra() {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("rn_check", "T");
        return extra;
    }

    private Map<String, Object> alipayWapExtra(String successUrl) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("success_url", successUrl);
        return extra;
    }

    private Map<String, Object> alipayPcDirectExtra(String successUrl) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("success_url", successUrl);
        return extra;
    }

    private Map<String, Object> wxPubExtra() {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        return extra;
    }

    private Map<String, Object> wxWapExtra(String successUrl) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("result_url", successUrl);
        return extra;
    }

    private Map<String, Object> upacpPcExtra(String successUrl) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("result_url", successUrl);
        return extra;
    }

    private Map<String, Object> upacpWapExtra(String successUrl) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("result_url", successUrl);
        return extra;
    }
}

