/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtils {
    private static Random randGen = null;
    private static char[] numbersAndLetters = null;

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isGreaterZeroInteger(String value) {
        String rexp = "^[1-9]\\d*$";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(value);
        return mat.matches();
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return value.contains(".");
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isEmpty(String s) {
        int length;
        if (s == null || (length = s.length()) == 0 || "null".equals(s)) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String nullToEmpty(String args) {
        if (args == null) {
            args = "";
        }
        return args;
    }

    public static String nullToEmpty(String args, int type) {
        if (args == null || "".equals(args)) {
            args = type == 0 ? "" : "0";
        }
        return args;
    }

    public static Object nullToEmpty(Object args, int type) {
        if (args == null || "".equals(args)) {
            args = type == 0 ? "" : "0";
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] InputStreamToByte(InputStream iStrm) throws IOException {
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        byte[] imgdata = null;
        try {
            int ch;
            while ((ch = iStrm.read()) != -1) {
                bytestream.write(ch);
            }
            imgdata = bytestream.toByteArray();
            bytestream.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (iStrm != null) {
                iStrm.close();
            }
        }
        return imgdata;
    }

    public static int[] StringToInt(String[] values) {
        int lenght = values.length;
        int[] iValues = new int[lenght];
        for (int i = 0; i < lenght; ++i) {
            iValues[i] = Integer.valueOf(values[i]);
        }
        return iValues;
    }

    public static List<Long> stringToLongList(String strArr) {
        String str = org.apache.commons.lang.StringUtils.strip((String)strArr, (String)"[]");
        if (str == null || str.length() <= 0) {
            return null;
        }
        return Arrays.stream(str.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
    }

    public static String stringToTime(String str) {
        Date date = new Date(Long.valueOf(str));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String value = formatter.format(date);
        return value;
    }

    public static String HumanFilesize(long size) {
        DecimalFormat df = new DecimalFormat("###.##");
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
        double mod = 1024.0;
        int i = 0;
        double bb = 0.0;
        i = 0;
        while ((double)size >= mod) {
            if ((double)size >= mod) {
                bb = (double)size % mod / 1000.0;
            }
            size = (long)((double)size / mod);
            ++i;
        }
        return df.format(new Float((double)size + bb).doubleValue()) + units[i];
    }

    public static String HorizontalToSlash(String str, String regex, String replacement) {
        return str.replaceAll(regex, replacement);
    }

    public static String Del_(String str, String regex) {
        int i = str.lastIndexOf(regex);
        if (i < 0) {
            i = str.length();
        }
        return str.substring(0, i);
    }

    public static String asHTML(String str) {
        if (str == null) {
            str = " ";
        }
        str = str.replace("&", "&amp;");
        str = str.replace("   ", "&nbsp;");
        str = str.replace(">", "&gt;");
        str = str.replace("<", "&lt;");
        str = str.replace("\n", "<br>");
        return str;
    }

    public static final String randomString(int length) {
        if (length < 1) {
            return null;
        }
        if (randGen == null) {
            randGen = new Random();
            numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    public static String[] delEmpty(String[] strs) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strs) {
            if (StringUtils.isEmpty((String)str)) continue;
            list.add(str);
        }
        String[] values = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            values[i] = (String)list.get(i);
        }
        return values;
    }

    public static Map<String, String> split(String str, String split) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] sp = str.split(split);
        if (sp.length != 2) {
            return null;
        }
        map.put(sp[0], sp[1]);
        return map;
    }

    public static String timeToString(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int second = calendar.get(13);
        int millisecond = calendar.get(14);
        String value = "" + year + month + day + hours + minutes + second + millisecond;
        return value;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isMobileNO(String mobiles) {
        Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        Matcher m = p.matcher(mobiles);
        return m.matches();
    }

    public static boolean isEmail(String email) {
        String str = ".+@.+";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isIp(String addr) {
        if (addr.length() < 7 || addr.length() > 15 || "".equals(addr)) {
            return false;
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(addr);
        boolean ipAddress = mat.find();
        return ipAddress;
    }

    public static boolean isPort(String port) {
        String rexp = "([0-9]|[1-9]\\d{1,3}|[1-5]\\d{4}|6[0-5]{2}[0-3][0-5])";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(port);
        return mat.matches();
    }

    public static boolean checkList(List<String> list, List<String> checklist) {
        if (list.size() != checklist.size()) {
            return false;
        }
        for (String str : list) {
            int i = 0;
            for (String check : checklist) {
                if (!str.equals(check)) continue;
                ++i;
            }
            if (i >= true) continue;
            return false;
        }
        return true;
    }

    public static String decodeJS(String str) {
        str = str.replaceAll("%20", " ");
        return str.replaceAll("%40", "@");
    }

    public static boolean isChineseChar(String str) {
        boolean temp = false;
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        if (m.find()) {
            temp = true;
        }
        return temp;
    }

    public static boolean isEnglishAndNum(String str) {
        return str.matches("[0-9A-Za-z_]*");
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String genRandomNum(int pwd_len) {
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer();
        Random r = new Random();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(str.length));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static boolean isJson(String content) {
        try {
            JSONObject.fromObject((Object)content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

