/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeUtil {
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final String ONE_SECOND_AGO = "\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String ONE_DAY_AGO = "\u5929\u524d";
    private static final String ONE_MONTH_AGO = "\u6708\u524d";
    private static final String ONE_YEAR_AGO = "\u5e74\u524d";
    protected static final Logger logger = LoggerFactory.getLogger(TimeUtil.class);

    public static Timestamp toTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss.SSS Z", new Locale("CHINESE", "CHINA"));
        try {
            Date date = sdf.parse(time);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new Timestamp(System.currentTimeMillis());
        }
    }

    public static String format(Date time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("CHINESE", "CHINA"));
        return sdf.format(time);
    }

    public static String format(Date time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, new Locale("CHINESE", "CHINA"));
        return sdf.format(time);
    }

    public static Date dateutil(String date) {
        date = date.replace("Z", " UTC");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS Z");
        Date d = null;
        try {
            d = format.parse(date);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return d;
    }

    public static Date tranDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX");
        Date dateTime = null;
        try {
            dateTime = sdf.parse(date);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return dateTime;
    }

    public static Timestamp toTime(String time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, new Locale("CHINESE", "CHINA"));
        try {
            Date date = sdf.parse(time);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new Timestamp(System.currentTimeMillis());
        }
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(TimeUtil.format((Date)new Timestamp(1431594582821L)));
        System.out.println(TimeUtil.toTime((String)"2016-06-24T21:36:02+0800", (String)"yyyy-MM-dd'T'HH:mm:ssZ"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:m:s");
        Date date = format.parse("2017-7-11 18:35:35");
        System.out.println(TimeUtil.formatRelativeDate((Date)date));
    }

    public static Date beforeMinutes(Date date, Long minutes) {
        Long time = date.getTime();
        time = time - minutes * 60L * 1000L;
        return new Date(time);
    }

    public static String formatRelativeDate(Date date) {
        long delta = new Date().getTime() - date.getTime();
        if (delta < 60000L) {
            long seconds = TimeUtil.toSeconds((long)delta);
            return (seconds <= 0L ? 1L : seconds) + "\u79d2\u524d";
        }
        if (delta < 2700000L) {
            long minutes = TimeUtil.toMinutes((long)delta);
            return (minutes <= 0L ? 1L : minutes) + "\u5206\u949f\u524d";
        }
        if (delta < 86400000L) {
            long hours = TimeUtil.toHours((long)delta);
            return (hours <= 0L ? 1L : hours) + "\u5c0f\u65f6\u524d";
        }
        if (delta < 172800000L) {
            return "\u6628\u5929";
        }
        if (delta < 2592000000L) {
            long days = TimeUtil.toDays((long)delta);
            return (days <= 0L ? 1L : days) + "\u5929\u524d";
        }
        if (delta < 29030400000L) {
            long months = TimeUtil.toMonths((long)delta);
            return (months <= 0L ? 1L : months) + "\u6708\u524d";
        }
        long years = TimeUtil.toYears((long)delta);
        return (years <= 0L ? 1L : years) + "\u5e74\u524d";
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return TimeUtil.toSeconds((long)date) / 60L;
    }

    private static long toHours(long date) {
        return TimeUtil.toMinutes((long)date) / 60L;
    }

    private static long toDays(long date) {
        return TimeUtil.toHours((long)date) / 24L;
    }

    private static long toMonths(long date) {
        return TimeUtil.toDays((long)date) / 30L;
    }

    private static long toYears(long date) {
        return TimeUtil.toMonths((long)date) / 365L;
    }

    public static Date endOfDay(Date date) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd").format(date) + " 23:59:59";
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date startOfDay(Date date) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd").format(date) + " 00:00:00";
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String millisToTime(long millis) {
        if (millis <= 0L) {
            return "00:00:00";
        }
        long second = millis / 1000L;
        long minute = second / 60L;
        long hour = minute / 60L;
        return TimeUtil.unitFormat((long)hour) + ":" + TimeUtil.unitFormat((long)(minute % 60L)) + ":" + TimeUtil.unitFormat((long)(second % 60L));
    }

    public static String unitFormat(long i) {
        String retStr = null;
        retStr = i >= 0L && i < 10L ? "0" + i : "" + i;
        return retStr;
    }

    public static String duration(Long second) {
        long day = second / 86400L;
        second = second % 86400L;
        long hour = second / 3600L;
        second = second % 3600L;
        long minute = second / 60L;
        second = second % 60L;
        StringBuffer sb = new StringBuffer();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String header = request.getHeader("Accept-Language");
        if (header.startsWith("en")) {
            if (day > 0L) {
                sb.append(day + " days");
            }
            if (hour > 0L) {
                if (sb.length() > 0) {
                    sb.append(" and " + hour + " hours");
                } else {
                    sb.append(hour + "hours");
                }
            }
            if (minute > 0L) {
                if (sb.length() > 0) {
                    sb.append(" and " + minute + " minutes");
                } else {
                    sb.append(minute + " minutes");
                }
            }
            if (second >= 0L) {
                if (sb.length() > 0) {
                    sb.append(" and " + second + " seconds");
                } else {
                    sb.append(second + " seconds");
                }
            }
        } else {
            if (day > 0L) {
                sb.append(day + "\u5929");
            }
            if (hour > 0L) {
                sb.append(hour + "\u5c0f\u65f6");
            }
            if (minute > 0L) {
                sb.append(minute + "\u5206");
            }
            if (second >= 0L) {
                sb.append(second + "\u79d2");
            }
        }
        return sb.toString();
    }

    public static Date getFirstDayDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getLastDayDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static String dateToNumber(Date time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        return sdf.format(time);
    }

    public static Date toDate(String time) {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }
}

