/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common.alipay;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.log4j.Logger;

public class AlipayCore {
    private static final Logger logger = Logger.getLogger(AlipayCore.class);

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || "".equals(value) || "sign".equalsIgnoreCase(key) || "sign_type".equalsIgnoreCase(key)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    public static void logResult(String sWord) {
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter("log4jalipay_log_" + System.currentTimeMillis() + ".txt");
            writer.write(sWord);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String getAbstract(String strFilePath, String file_digest_type) throws IOException {
        FilePartSource file = new FilePartSource(new File(strFilePath));
        if ("MD5".equals(file_digest_type)) {
            return DigestUtils.md5Hex((InputStream)file.createInputStream());
        }
        if ("SHA".equals(file_digest_type)) {
            return DigestUtils.sha256Hex((InputStream)file.createInputStream());
        }
        return "";
    }
}

