/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common.alipay;

import com.mopaas.server.common.alipay.AlipayCore;
import com.mopaas.server.common.alipay.MD5;
import com.mopaas.server.common.alipay.RSA;
import com.mopaas.server.config.AlipayConfig;
import com.mopaas.server.dao.SystemConfigRepository;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlipayNotify {
    @Autowired
    private SystemConfigRepository systemConfigRepository;
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";
    private static final Logger logger = Logger.getLogger(AlipayNotify.class);

    public static boolean verify(Map<String, String> params, AlipayConfig alipayConfig) {
        boolean isSign;
        String responseTxt = "false";
        if (params.get("notify_id") != null) {
            String notify_id = params.get("notify_id");
            responseTxt = AlipayNotify.verifyResponse((String)notify_id, (AlipayConfig)alipayConfig);
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return (isSign = AlipayNotify.getSignVeryfy(params, (String)sign, (AlipayConfig)alipayConfig)) && "true".equals(responseTxt);
    }

    public static boolean verify(Map<String, String> params, String signType, AlipayConfig alipayConfig) {
        boolean isSign;
        String responseTxt = "true";
        if (params.get("notify_id") != null) {
            String notify_id = params.get("notify_id");
            responseTxt = AlipayNotify.verifyResponse((String)notify_id, (AlipayConfig)alipayConfig);
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return (isSign = AlipayNotify.getSignVeryfy(params, (String)sign, (String)signType, (AlipayConfig)alipayConfig)) && "true".equals(responseTxt);
    }

    private static boolean getSignVeryfy(Map<String, String> Params, String sign, String signType, AlipayConfig alipayConfig) {
        Map sParaNew = AlipayCore.paraFilter(Params);
        String preSignStr = AlipayCore.createLinkString((Map)sParaNew);
        boolean isSign = false;
        if ("MD5".equalsIgnoreCase(signType)) {
            isSign = MD5.verify((String)preSignStr, (String)sign, (String)alipayConfig.key, (String)alipayConfig.input_charset);
        } else if ("RSA".equalsIgnoreCase(signType)) {
            isSign = RSA.verify((String)preSignStr, (String)sign, (String)alipayConfig.publickey, (String)alipayConfig.input_charset);
        }
        return isSign;
    }

    private static boolean getSignVeryfy(Map<String, String> Params, String sign, AlipayConfig alipayConfig) {
        Map sParaNew = AlipayCore.paraFilter(Params);
        String preSignStr = AlipayCore.createLinkString((Map)sParaNew);
        boolean isSign = false;
        if ("MD5".equals(alipayConfig.sign_type)) {
            isSign = MD5.verify((String)preSignStr, (String)sign, (String)alipayConfig.key, (String)alipayConfig.input_charset);
        }
        return isSign;
    }

    private static String verifyResponse(String notify_id, AlipayConfig alipayConfig) {
        String partner = alipayConfig.partner;
        String veryfy_url = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notify_id;
        return AlipayNotify.checkUrl((String)veryfy_url);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            inputLine = "";
        }
        return inputLine;
    }
}

