/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.common.mail;

import com.mopaas.server.exception.BusinessException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ConfigUtils {
    private static Map<String, String> configMap = new HashMap();
    private static String filePath = ConfigUtils.class.getClassLoader().getResource("system.properties").getPath();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProperty(String key) {
        if (configMap.containsKey(key)) {
            return (String)configMap.get(key);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));){
            Properties props = new Properties();
            props.load(in);
            String value = props.getProperty(key);
            if (null == value) return null;
            if (value.isEmpty()) return null;
            configMap.put(key, value);
            String string = value;
            return string;
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public static void setProperties(Map<String, String> properties) {
        Iterator<Map.Entry<String, String>> it = properties.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));){
            Properties props = new Properties();
            props.load(in);
            while (it.hasNext()) {
                entry = it.next();
                if (configMap.containsKey(entry.getKey())) {
                    configMap.replace(entry.getKey(), entry.getValue());
                } else {
                    configMap.put(entry.getKey(), entry.getValue());
                }
                props.setProperty(entry.getKey(), entry.getValue());
            }
            FileOutputStream fos = new FileOutputStream(filePath);
            props.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public static void setProperty(String key, String value) {
        try (FileInputStream in = new FileInputStream(filePath);){
            Properties props = new Properties();
            props.load(in);
            if (configMap.containsKey(key)) {
                configMap.replace(key, value);
            } else {
                configMap.put(key, value);
            }
            if (props.containsKey(key)) {
                props.setProperty(key, value);
            } else {
                props.put(key, value);
            }
            FileOutputStream fos = new FileOutputStream(filePath);
            props.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public static String getFilePath() {
        return filePath;
    }

    public static void setFilePath(String filePath) {
        ConfigUtils.filePath = filePath;
    }
}

