/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.component;

import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.controller.ServiceController;
import com.mopaas.server.dao.OperationLogRepository;
import com.mopaas.server.dao.ServiceRepository;
import com.mopaas.server.entity.OperationLog;
import com.mopaas.server.entity.Service;
import io.kubernetes.client.openapi.ApiException;
import java.io.Serializable;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class InferenceServiceJob
extends QuartzJobBean {
    @Autowired
    private ServiceController serviceController;
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private OperationLogRepository operationLogRepository;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private MessageUtil messageUtil;

    protected void executeInternal(JobExecutionContext jobExecutionContext) {
        String triggerKey = jobExecutionContext.getTrigger().getKey().getName();
        if (triggerKey.startsWith("isvc")) {
            Date begin = new Date();
            Long serviceId = jobExecutionContext.getMergedJobDataMap().getLong("service");
            Service service = (Service)this.serviceRepository.findOne((Serializable)serviceId);
            try {
                this.serviceController.deleteK8sInferenceService(serviceId);
            }
            catch (ApiException e) {
                e.printStackTrace();
            }
            OperationLog log = new OperationLog();
            log.setDepartment(service.getDepartment());
            log.setOrganization(service.getDepartment().getOrgConfig().getOrganization());
            log.setDomain(service.getDomain());
            log.setUsername(this.messageSource.getMessage("msg.system", null, null));
            log.setResourceGuid(service.getCurrent().getGuid());
            log.setResourceName(service.getName());
            log.setResourceType(Integer.valueOf(5));
            log.setDuration(Long.valueOf(System.currentTimeMillis() - begin.getTime()));
            log.setRes(Constants.SC_OK);
            log.setCreatedAt(new Date());
            log.setContent(this.messageUtil.getMessageJson("msg.stop.auto"));
            this.operationLogRepository.save((Object)log);
        }
    }
}

