/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.component;

import com.mopaas.server.automl.AutoMLService;
import com.mopaas.server.controller.AnnotationController;
import com.mopaas.server.controller.DatasetController;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.controller.JobController;
import com.mopaas.server.controller.ResourceController;
import com.mopaas.server.controller.ServiceController;
import com.mopaas.server.controller.StorageController;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.service.ResourceService;
import io.kubernetes.client.openapi.ApiException;
import java.beans.ConstructorProperties;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"env"})
public class Monitor {
    final ResourceController resourceController;
    final JobController jobController;
    final ServiceController serviceController;
    final StorageController storageController;
    final AnnotationController annotationController;
    final DepartmentController departmentController;
    final DomainRepository domainRepository;
    final ResourceService resourceService;
    final AutoMLService autoMLService;
    final DatasetController datasetController;

    @Scheduled(fixedDelayString="${scheduler.fixed.delay}")
    public void schedule() throws ApiException {
        this.resourceController.schedule();
        this.jobController.schedule();
        this.serviceController.schedule();
        this.storageController.schedule();
        this.annotationController.schedule();
        this.autoMLService.schedule();
        this.datasetController.scheduler();
    }

    @Scheduled(fixedDelayString="${scheduler.fixed.delay}")
    public void depSchedule() {
        this.departmentController.resourceSchedule();
        this.departmentController.jobSchedule();
        this.departmentController.modelSchedule();
        this.departmentController.automlSchedule();
    }

    @Scheduled(cron="${scheduler.snap.fixed.delay}")
    public void snapSchedule() throws ApiException, com.mopaas.server.harbor.ApiException {
        this.resourceController.scheduleSnapshot();
        this.resourceController.scheduleSnapshotRemove();
    }

    @ConstructorProperties(value={"resourceController", "jobController", "serviceController", "storageController", "annotationController", "departmentController", "domainRepository", "resourceService", "autoMLService", "datasetController"})
    public Monitor(ResourceController resourceController, JobController jobController, ServiceController serviceController, StorageController storageController, AnnotationController annotationController, DepartmentController departmentController, DomainRepository domainRepository, ResourceService resourceService, AutoMLService autoMLService, DatasetController datasetController) {
        this.resourceController = resourceController;
        this.jobController = jobController;
        this.serviceController = serviceController;
        this.storageController = storageController;
        this.annotationController = annotationController;
        this.departmentController = departmentController;
        this.domainRepository = domainRepository;
        this.resourceService = resourceService;
        this.autoMLService = autoMLService;
        this.datasetController = datasetController;
    }
}

