/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.config;

import com.mopaas.server.aop.UserStateInterceptor;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.ws.WsHandshakeInterceptor;
import com.mopaas.server.ws.WsK8sPodLogHandler;
import com.mopaas.server.ws.WsNotebookMetricsHandler;
import java.beans.ConstructorProperties;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableJpaAuditing
@EnableScheduling
@EnableWebSocket
@EnableAsync
public class AppConfig
extends WebMvcConfigurerAdapter
implements WebSocketConfigurer {
    final MessageSource messageSource;
    final WsNotebookMetricsHandler wsNotebookMetricsHandler;
    final WsK8sPodLogHandler wsK8sPodLogHandler;
    final WsHandshakeInterceptor wsHandshakeInterceptor;

    public Validator getValidator() {
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        validator.setValidationMessageSource(this.messageSource);
        return validator;
    }

    @Bean
    public UserStateInterceptor userStateInterceptor() {
        return new UserStateInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.userStateInterceptor()).addPathPatterns(new String[]{"/api/**"});
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)this.wsK8sPodLogHandler, new String[]{"/ws/pod/log"}).addHandler((WebSocketHandler)this.wsNotebookMetricsHandler, new String[]{"/ws/notebook/metrics"}).addInterceptors(new HandshakeInterceptor[]{this.wsHandshakeInterceptor}).setAllowedOrigins(new String[]{"*"});
    }

    @Bean
    public FilterRegistrationBean corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        config.setAllowCredentials(Boolean.valueOf(true));
        config.setMaxAge(Long.valueOf(3600L));
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(Integer.MIN_VALUE);
        return bean;
    }

    @Bean
    public MessageUtil messageUtil() {
        return new MessageUtil();
    }

    @ConstructorProperties(value={"messageSource", "wsNotebookMetricsHandler", "wsK8sPodLogHandler", "wsHandshakeInterceptor"})
    public AppConfig(MessageSource messageSource, WsNotebookMetricsHandler wsNotebookMetricsHandler, WsK8sPodLogHandler wsK8sPodLogHandler, WsHandshakeInterceptor wsHandshakeInterceptor) {
        this.messageSource = messageSource;
        this.wsNotebookMetricsHandler = wsNotebookMetricsHandler;
        this.wsK8sPodLogHandler = wsK8sPodLogHandler;
        this.wsHandshakeInterceptor = wsHandshakeInterceptor;
    }
}

