/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.config;

import com.mopaas.server.config.QuartzConfig;
import javax.sql.DataSource;
import org.quartz.spi.JobFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class QuartzConfig {
    @Bean
    public SchedulerFactoryBean schedulerFactory(DataSource dataSource, ApplicationContext applicationContext) {
        SchedulerFactoryBean factoryBean = new SchedulerFactoryBean();
        factoryBean.setSchedulerName("scheduler");
        factoryBean.setDataSource(dataSource);
        factoryBean.setConfigLocation((Resource)new ClassPathResource("quartz.properties"));
        AutowiringSpringBeanJobFactory springBeanJobFactory = new AutowiringSpringBeanJobFactory();
        springBeanJobFactory.setApplicationContext(applicationContext);
        factoryBean.setJobFactory((JobFactory)springBeanJobFactory);
        return factoryBean;
    }
}

