/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.config.shiro;

import com.mopaas.server.common.Constants;
import com.mopaas.server.model.response.ResultResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.support.RequestContext;

@RestControllerAdvice
public class ShiroExceptionHandler {
    @ExceptionHandler(value={UnauthorizedException.class})
    public ResultResponse unauthorizedException(HttpServletRequest req) {
        RequestContext context = new RequestContext(req);
        ResultResponse response = new ResultResponse();
        response.setCode(Constants.SC_ERROR);
        response.setMessage(context.getMessage("msg.account.unauthorized"));
        return response;
    }

    @ExceptionHandler(value={UnauthenticatedException.class})
    public ResultResponse unauthenticatedException(HttpServletRequest req) {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)req.getServletContext());
        ResultResponse response = new ResultResponse();
        response.setCode(Constants.SC_ERROR);
        response.setMessage(context.getMessage("msg.account.unauthenticated", null, req.getLocale()));
        return response;
    }

    @ExceptionHandler
    public ResultResponse authenticatedException(AuthenticationException e) {
        ResultResponse response = new ResultResponse();
        response.setCode(Constants.SC_MSG);
        response.setMessage(e.getMessage());
        return response;
    }
}

