/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.config.shiro;

import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.dao.DepPermissionRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.PermissionRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.DepPermission;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Permission;
import com.mopaas.server.entity.User;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.beans.factory.annotation.Autowired;

public class UserRealm
extends AuthorizingRealm {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private DepUsersRepository depUsersRepository;
    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired
    private DepPermissionRepository depPermissionRepository;
    @Autowired
    private MessageUtil messageUtil;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        String password;
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        String username = token.getUsername();
        User owner = this.userRepository.findByUsernameAndPassword(username, password = String.valueOf(token.getPassword()));
        if (null == owner) {
            throw new UnknownAccountException(this.messageUtil.getMessage("msg.account.unknown"));
        }
        if (owner.getStatus() == null) {
            owner.setStatus(Integer.valueOf(1));
        }
        if (owner.getState() == null) {
            owner.setState(Integer.valueOf(1));
        }
        if (owner.getStatus() != 1) {
            throw new UnknownAccountException(this.messageUtil.getMessage("msg.account.disabled"));
        }
        if (owner.getState() != 1) {
            throw new UnknownAccountException(this.messageUtil.getMessage("msg.account.isLocked"));
        }
        SimpleAuthenticationInfo authcInfo = new SimpleAuthenticationInfo((Object)username, (Object)password, this.getName());
        DefaultWebSessionManager sessionManager = (DefaultWebSessionManager)((DefaultWebSecurityManager)SecurityUtils.getSecurityManager()).getSessionManager();
        Collection sessions = sessionManager.getSessionDAO().getActiveSessions();
        if (null != sessions && sessions.size() > 0) {
            for (Session session : sessions) {
                if (!username.equals(String.valueOf(session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY)))) continue;
                session.stop();
            }
        }
        Session session = SecurityUtils.getSubject().getSession();
        session.setAttribute((Object)"userId", (Object)owner.getId());
        session.setAttribute((Object)"guid", (Object)owner.getGuid());
        return authcInfo;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        Session session = SecurityUtils.getSubject().getSession();
        User user = (User)this.userRepository.findOne((Serializable)((Long)session.getAttribute((Object)"userId")));
        if (null != user && user.getState() == 1) {
            SimpleAuthorizationInfo authzInfo = new SimpleAuthorizationInfo();
            List departments = user.getDepartments();
            if (departments != null && departments.size() > 0) {
                for (OrgConfigDepartment dep : departments) {
                    List memberPerissions;
                    DepUsers depUsers = this.depUsersRepository.findByUserAndDepartmentAndState(user, dep, Integer.valueOf(1));
                    Integer level = depUsers != null ? depUsers.getType() : 3;
                    List permissions = null;
                    if (level == 1) {
                        permissions = this.permissionRepository.findAll();
                    } else if (level == 2) {
                        permissions = dep.getPermissions();
                    } else if (level == 3 && null != (memberPerissions = this.permissionRepository.findByPermissionLike("%member:%")) && !memberPerissions.isEmpty()) {
                        for (Permission permission : memberPerissions) {
                            DepPermission depPermission = this.depPermissionRepository.findByDepartmentAndPermission(dep, permission);
                            if (depPermission == null) continue;
                            authzInfo.addStringPermission(permission.getPermission().substring(permission.getPermission().indexOf(":") + 1) + ":" + dep.getId());
                        }
                    }
                    if (null == permissions || permissions.isEmpty()) continue;
                    for (Permission permission : permissions) {
                        authzInfo.addStringPermission(permission.getPermission() + ":" + dep.getId());
                    }
                }
            }
            return authzInfo;
        }
        return null;
    }
}

