/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.StringUtils;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.controller.ResourceController;
import com.mopaas.server.controller.ServiceController;
import com.mopaas.server.controller.StorageController;
import com.mopaas.server.dao.AccountNoticePushRepository;
import com.mopaas.server.dao.AccountNoticeRepository;
import com.mopaas.server.dao.AccountUserRegisterRepository;
import com.mopaas.server.dao.AnnotationRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.FrameDepartmentRepository;
import com.mopaas.server.dao.HarborProjectDeptRepository;
import com.mopaas.server.dao.HarborProjectRepository;
import com.mopaas.server.dao.JobRepository;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.OrgConfigDepPackageRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrgConfigRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.OrganizationRepository;
import com.mopaas.server.dao.PermissionRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.PriceRepository;
import com.mopaas.server.dao.RegisterConfigRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.ServiceRepository;
import com.mopaas.server.dao.StorageDeptRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.AccountNoticePush;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.HarborProject;
import com.mopaas.server.entity.Job;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.ResourceStorage;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.StorageDept;
import com.mopaas.server.entity.User;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.harbor.model.Project;
import com.mopaas.server.harbor.model.Repository;
import com.mopaas.server.model.request.AccountsRequest;
import com.mopaas.server.model.request.StateRoleRequest;
import com.mopaas.server.model.response.AccountNoticePushModel;
import com.mopaas.server.model.response.DepShareModel;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.NoticeStateResponse;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.NoticeUserService;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u53f7\u7cfb\u7edf"})
@RestController
public class AccountController {
    final UserRepository userRepository;
    final OrgConfigRepository orgConfigRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final PermissionRepository permissionRepository;
    final AccountNoticeRepository accountNoticeRepository;
    final AccountNoticePushRepository accountNoticePushRepository;
    final PricePackageRepository pricePackageRepository;
    final OrgConfigDepPackageRepository orgConfigDepPackageRepository;
    final OrganizationRepository organizationRepository;
    final FrameDepartmentRepository frameDepartmentRepository;
    final HarborProjectRepository harborProjectRepository;
    final ResourceRepository resourceRepository;
    final JobRepository jobRepository;
    final ServiceRepository serviceRepository;
    final StorageDeptRepository storageDeptRepository;
    final StorageRepository storageRepository;
    final MaterialsRepository materialsRepository;
    final ResourceController resourceController;
    final ServiceController serviceController;
    final StorageController storageController;
    final DepUsersRepository depUsersRepository;
    final AccountUserRegisterRepository accountUserRegisterRepository;
    final HarborProjectDeptRepository harborProjectDeptRepository;
    final NoticeUserService noticeUserService;
    final DomainRepository domainRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final AnnotationRepository annotationRepository;
    final JobVersionRepository jobVersionRepository;
    final RegisterConfigRepository registerConfigRepository;
    final PriceRepository priceRepository;
    final MessageUtil messageUtil;
    private static final Logger logger = LoggerFactory.getLogger(AccountController.class);

    @ApiOperation(value="\u90e8\u95e8-\u5220\u9664\u90e8\u95e8")
    @Transactional
    @RequestMapping(value={"/api/account/group/delete/{id}"}, method={RequestMethod.DELETE})
    public ResultResponse deleteGroup(@ApiParam(value="groupId") @PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        List harborProjectList;
        List annotations;
        List storages;
        List services;
        List materials;
        List jobs;
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)id);
        if (dep == null || dep.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.account.group.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = Long.parseLong(request.getHeader("domain"));
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        CoreV1Api coreV1Api = k8sFactory.coreV1Api;
        Date now = new Date();
        List resources = this.resourceRepository.findByDepartmentIdAndDeletedAndDomainId(id, Integer.valueOf(0), Long.valueOf(domainId));
        if (null != resources) {
            for (Object resource : resources) {
                List storages2;
                List materials2 = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0));
                if (null != materials2) {
                    for (Object material : materials2) {
                        material.setLastedAt(now);
                        material.setOperation(null);
                    }
                }
                if (null != (storages2 = resource.getStorages()) && storages2.size() > 0) {
                    Object material;
                    material = storages2.iterator();
                    while (material.hasNext()) {
                        ResourceStorage rs = (ResourceStorage)material.next();
                        Storage storage = rs.getStorage();
                        if (storage.getType() != 2) continue;
                        List cephMaterials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(storage.getId(), Integer.valueOf(2));
                        if (null != cephMaterials) {
                            Iterator iterator = cephMaterials.iterator();
                            while (iterator.hasNext()) {
                                Materials material2 = (Materials)iterator.next();
                                material2.setLastedAt(now);
                                material2.setOperation(null);
                            }
                        }
                        storage.setDeleted(Integer.valueOf(1));
                    }
                }
                try {
                    FactoryCollection.k8sFactory((Long)domainId).deleteNamespace(resource.getGuid());
                }
                catch (Exception e) {
                    logger.error("delete resource [" + resource.getName() + "] " + e.getMessage(), (Throwable)e);
                }
                resource.setDeleted(Integer.valueOf(1));
            }
        }
        if (null != (jobs = this.jobRepository.findByDepartmentAndDeleted(dep, Integer.valueOf(0))) && !jobs.isEmpty()) {
            for (Object job : jobs) {
                List versions = this.jobVersionRepository.getByJobAndDeleted((Job)job, Integer.valueOf(0));
                for (Object version : versions) {
                    materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(version.getId(), Integer.valueOf(1));
                    if (null != materials) {
                        for (Materials material : materials) {
                            material.setLastedAt(now);
                            material.setOperation(null);
                        }
                    }
                    try {
                        k8sFactory.deleteNamespace(version.getGuid());
                    }
                    catch (Exception e) {
                        logger.error("delete job [" + job.getName() + "] " + e.getMessage());
                    }
                    version.setDeleted(Integer.valueOf(1));
                }
                job.setDeleted(Integer.valueOf(1));
            }
        }
        if (null != (services = this.serviceRepository.findByDepartmentAndDeleted(dep, Integer.valueOf(0))) && !services.isEmpty()) {
            for (Object service : services) {
                List materials3 = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(service.getId(), Integer.valueOf(3));
                if (null != materials3) {
                    for (Materials material : materials3) {
                        material.setLastedAt(now);
                        material.setOperation(null);
                    }
                }
                k8sFactory.deleteNamespace(service.getCurrent().getGuid());
                service.setDeleted(Integer.valueOf(1));
                service.getCurrent().setDeleted(Integer.valueOf(1));
            }
        }
        if (null != (storages = this.storageRepository.findByDepIdAndDeleted(id, Integer.valueOf(0)))) {
            for (Object storage : storages) {
                String guid = storage.getGuid();
                try {
                    coreV1Api.deleteNamespace(guid, null, null, Integer.valueOf(0), null, "Foreground", null);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(storage.getId(), Integer.valueOf(2));
                if (null != materials && !materials.isEmpty()) {
                    for (Materials material : materials) {
                        material.setLastedAt(now);
                    }
                }
                storage.setDeleted(Integer.valueOf(1));
            }
        }
        if (null != (annotations = this.annotationRepository.findByDepartmentAndDeleted(dep, Integer.valueOf(0))) && !annotations.isEmpty()) {
            for (Object annotation : annotations) {
                try {
                    k8sFactory.deleteNamespace(annotation.getGuid());
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                annotation.setDeleted(Integer.valueOf(1));
            }
        }
        if (null != (harborProjectList = this.harborProjectRepository.findByDepartmentId(id)) && !harborProjectList.isEmpty()) {
            for (HarborProject harborProject : harborProjectList) {
                block41: {
                    Long projectId = harborProject.getProjectId();
                    try {
                        Project project = FactoryCollection.harborApi((Long)domainId).projectsProjectIdGet(projectId);
                        if (project == null) continue;
                        List repositories = FactoryCollection.harborApi((Long)domainId).repositoriesGet(Integer.valueOf(projectId.intValue()), null, null, null, Integer.valueOf(1), Integer.valueOf(100));
                        if (repositories != null && repositories.size() > 0) {
                            for (Repository repo : repositories) {
                                FactoryCollection.harborApi((Long)domainId).repositoriesRepoNameDelete(repo.getName());
                            }
                        }
                        FactoryCollection.harborApi((Long)domainId).projectsProjectIdDelete(projectId);
                        harborProject.setDeleted(Integer.valueOf(1));
                        res.setCode(Constants.SC_OK);
                    }
                    catch (com.mopaas.server.harbor.ApiException e) {
                        logger.error(e.getResponseBody());
                        if (!e.getResponseBody().contains("contains repositories")) break block41;
                        res.setMessage(this.messageUtil.getMessage("msg.harbor.image.remove.error"));
                        res.setCode(Constants.SC_MSG);
                        return res;
                    }
                }
                List harborProjectDepts = this.harborProjectDeptRepository.findByDepartmentId(id);
                this.harborProjectDeptRepository.delete((Iterable)harborProjectDepts);
            }
        }
        List users = dep.getUsers();
        for (User u : users) {
            if (u.getDeleted() == 1 || u.getState() != 1) continue;
            this.noticeUserService.sendMemberEmail(Integer.valueOf(0), u, dep, user);
        }
        dep.setUsers(null);
        dep.setDeleted(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4e3b\u7ba1/\u6210\u5458-\u542f\u7528/\u7981\u7528")
    @Transactional
    @RequestMapping(value={"/api/account/role/state"}, method={RequestMethod.POST})
    public ResultResponse stateRole(@Valid @RequestBody StateRoleRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        Long depId = dto.getDepId();
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        if (!DepartmentController.isDepPermission((String)"consumer:state", (Long)depId)) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List userIds = dto.getUserIds();
        for (Long id : userIds) {
            User role = (User)this.userRepository.findOne((Serializable)id);
            if (role == null) {
                res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(role, dep);
            depUsers.setState(dto.getState());
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6d88\u606f-\u662f\u5426\u5df2\u8bfb(0\u6709\u672a\u8bfb\uff0c1\u5168\u90e8\u5df2\u8bfb)")
    @Transactional
    @RequestMapping(value={"/api/account/user/notice/state"}, method={RequestMethod.GET})
    public NoticeStateResponse getUserNoticeState(HttpServletRequest request) {
        NoticeStateResponse res = new NoticeStateResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        int flag = 1;
        List pushes = this.accountNoticePushRepository.findByUserIdAndunread(user.getId());
        if (pushes != null && pushes.size() > 0) {
            flag = 0;
        }
        res.setState(Integer.valueOf(flag));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6d88\u606f(\u7c7b\u578b)-\u662f\u5426\u5df2\u8bfb(0\u6709\u672a\u8bfb\uff0c1\u5168\u90e8\u5df2\u8bfb)")
    @Transactional
    @RequestMapping(value={"/api/account/user/notice/state/{type}"}, method={RequestMethod.GET})
    public NoticeStateResponse getUserTypeNoticeState(@ApiParam(value="type") @PathVariable(value="type") Integer type, HttpServletRequest request) {
        NoticeStateResponse res = new NoticeStateResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        int flag = 1;
        List pushes = this.accountNoticePushRepository.findByUserIdAndTypeAndunread(user.getId(), type);
        if (pushes != null && pushes.size() > 0) {
            flag = 0;
        }
        res.setState(Integer.valueOf(flag));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6d88\u606f-\u7528\u6237\u6d88\u606f\u901a\u77e5\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/account/user/notices"}, method={RequestMethod.POST})
    public ListResultResponse<AccountNoticePushModel> getUserNotices(@Valid @RequestBody AccountsRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        ArrayList noticePushResDtos = new ArrayList();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Integer type = dto.getType();
        if (type == null) {
            type = 0;
        }
        List noticePushs = this.accountNoticePushRepository.findByUserIdAndTypeAndDeleted(user.getId(), type, Integer.valueOf(0));
        String search = dto.getSearch();
        if (search != null && !search.isEmpty()) {
            for (int i = noticePushs.size() - 1; i >= 0; --i) {
                AccountNoticePush notice = (AccountNoticePush)noticePushs.get(i);
                String tag = notice.getTitle() + notice.getContent();
                if (tag.contains(search)) continue;
                noticePushs.remove(notice);
            }
        }
        noticePushs.sort((a1, a2) -> a2.getId().compareTo(a1.getId()));
        Integer pageNum = dto.getPageNum();
        Integer pageSize = dto.getPageSize();
        if (pageNum == null || pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
        }
        int totalSize = noticePushs.size();
        res.setSize(Long.valueOf(totalSize));
        int pageNums = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        res.setPages(Integer.valueOf(pageNums));
        for (int i = (pageNum - 1) * pageSize; i <= (pageNum * pageSize - 1 < totalSize ? pageNum * pageSize - 1 : totalSize - 1); ++i) {
            noticePushResDtos.add(noticePushs.get(i));
        }
        ArrayList<AccountNoticePushModel> list = new ArrayList<AccountNoticePushModel>();
        String language = "zh";
        String header = request.getHeader("Accept-Language");
        if (header.startsWith("en")) {
            language = "en";
        }
        for (AccountNoticePush noticePush : noticePushResDtos) {
            JSONObject jsonObject;
            AccountNoticePushModel model = new AccountNoticePushModel();
            model.setId(noticePush.getId());
            if (null != noticePush.getContent() && StringUtils.isJson((String)noticePush.getContent())) {
                jsonObject = JSONObject.fromObject((Object)noticePush.getContent());
                model.setContent(jsonObject.get(language).toString());
            } else {
                model.setContent(noticePush.getContent());
            }
            if (null != noticePush.getTitle() && StringUtils.isJson((String)noticePush.getTitle())) {
                jsonObject = JSONObject.fromObject((Object)noticePush.getTitle());
                model.setTitle(jsonObject.get(language).toString());
            } else {
                model.setTitle(noticePush.getTitle());
            }
            model.setCreatedAt(noticePush.getCreatedAt());
            model.setCreator(noticePush.getCreator());
            model.setDeleted(noticePush.getDeleted());
            model.setGroupId(noticePush.getDepartment() == null ? null : noticePush.getDepartment().getId());
            model.setNoticeId(Long.valueOf(noticePush.getNotice() == null ? 0L : noticePush.getNotice().getId()));
            model.setOrgId(noticePush.getOrganization() == null ? null : noticePush.getOrganization().getId());
            model.setUserId(noticePush.getUser().getId());
            model.setState(noticePush.getState());
            model.setType(noticePush.getType());
            list.add(model);
        }
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6d88\u606f-\u901a\u77e5\u5df2\u8bfb")
    @Transactional
    @RequestMapping(value={"/api/account/notice/push/state/{id}"}, method={RequestMethod.POST})
    public ResultResponse alterNoticePushState(@ApiParam(value="noticePushId") @PathVariable(value="id") Long id) {
        ResultResponse res = new ResultResponse();
        AccountNoticePush noticePush = (AccountNoticePush)this.accountNoticePushRepository.findOne((Serializable)id);
        noticePush.setState(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6d88\u606f-\u901a\u77e5\u5168\u90e8\u5df2\u8bfb")
    @Transactional
    @RequestMapping(value={"/api/account/notice/push/state/all"}, method={RequestMethod.POST})
    public ResultResponse alterNoticePushStateAll(HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List noticePushs = this.accountNoticePushRepository.findByUserIdAndDeleted(userId, Integer.valueOf(0));
        if (noticePushs != null) {
            for (AccountNoticePush noticePush : noticePushs) {
                noticePush.setState(Integer.valueOf(1));
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6d88\u606f-\u901a\u77e5\u5168\u90e8\u5df2\u8bfb(\u7c7b\u578b)")
    @Transactional
    @RequestMapping(value={"/api/account/notice/push/state/all/{type}"}, method={RequestMethod.POST})
    public ResultResponse alterNoticePushStateType(@ApiParam(value="type") @PathVariable(value="type") Integer type, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List noticePushs = this.accountNoticePushRepository.findByUserIdAndTypeAndDeleted(userId, type, Integer.valueOf(0));
        if (noticePushs != null) {
            for (AccountNoticePush noticePush : noticePushs) {
                noticePush.setState(Integer.valueOf(1));
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5171\u4eab\u5b58\u50a8-\u90e8\u95e8\u9009\u62e9")
    @Transactional
    @RequestMapping(value={"/api/account/group/all/{id}"}, method={RequestMethod.GET})
    public ListResultResponse<DepShareModel> getAllGroups(@ApiParam(value="storageId") @PathVariable(value="id") Long id, HttpServletRequest request) {
        DepUsers depAdmin;
        User owner;
        List depUsers;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        ArrayList<DepShareModel> groupRespons = new ArrayList<DepShareModel>();
        Storage storage = (Storage)this.storageRepository.findOne((Serializable)id);
        Long depId = storage.getDepartment().getId();
        OrgConfigDepartment dep = null;
        if (depId != null) {
            dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        }
        if ((depUsers = this.depUsersRepository.findByUserAndType(owner = (depAdmin = this.depUsersRepository.findTopByDepartmentAndType(dep, Integer.valueOf(1))).getUser(), Integer.valueOf(1))) != null && depUsers.size() > 0) {
            for (DepUsers d : depUsers) {
                OrgConfigDepartment department = d.getDepartment();
                if (!department.getUsers().contains(user)) continue;
                DepShareModel depShareModel = new DepShareModel();
                depShareModel.setId(department.getId());
                depShareModel.setName(department.getName());
                StorageDept storageDept = this.storageDeptRepository.findByStorageIdAndDepartment(id, department);
                if (storageDept == null) {
                    depShareModel.setRw(Integer.valueOf(-1));
                } else {
                    depShareModel.setRw(storageDept.getRw());
                }
                groupRespons.add(depShareModel);
            }
        }
        res.setList(groupRespons);
        res.setCode(Constants.SC_OK);
        return res;
    }

    static Integer getLevel(User user) {
        return user.getLevel();
    }

    @ConstructorProperties(value={"userRepository", "orgConfigRepository", "orgConfigDepartmentRepository", "permissionRepository", "accountNoticeRepository", "accountNoticePushRepository", "pricePackageRepository", "orgConfigDepPackageRepository", "organizationRepository", "frameDepartmentRepository", "harborProjectRepository", "resourceRepository", "jobRepository", "serviceRepository", "storageDeptRepository", "storageRepository", "materialsRepository", "resourceController", "serviceController", "storageController", "depUsersRepository", "accountUserRegisterRepository", "harborProjectDeptRepository", "noticeUserService", "domainRepository", "organizationQuotasRepository", "annotationRepository", "jobVersionRepository", "registerConfigRepository", "priceRepository", "messageUtil"})
    public AccountController(UserRepository userRepository, OrgConfigRepository orgConfigRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, PermissionRepository permissionRepository, AccountNoticeRepository accountNoticeRepository, AccountNoticePushRepository accountNoticePushRepository, PricePackageRepository pricePackageRepository, OrgConfigDepPackageRepository orgConfigDepPackageRepository, OrganizationRepository organizationRepository, FrameDepartmentRepository frameDepartmentRepository, HarborProjectRepository harborProjectRepository, ResourceRepository resourceRepository, JobRepository jobRepository, ServiceRepository serviceRepository, StorageDeptRepository storageDeptRepository, StorageRepository storageRepository, MaterialsRepository materialsRepository, ResourceController resourceController, ServiceController serviceController, StorageController storageController, DepUsersRepository depUsersRepository, AccountUserRegisterRepository accountUserRegisterRepository, HarborProjectDeptRepository harborProjectDeptRepository, NoticeUserService noticeUserService, DomainRepository domainRepository, OrganizationQuotasRepository organizationQuotasRepository, AnnotationRepository annotationRepository, JobVersionRepository jobVersionRepository, RegisterConfigRepository registerConfigRepository, PriceRepository priceRepository, MessageUtil messageUtil) {
        this.userRepository = userRepository;
        this.orgConfigRepository = orgConfigRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.permissionRepository = permissionRepository;
        this.accountNoticeRepository = accountNoticeRepository;
        this.accountNoticePushRepository = accountNoticePushRepository;
        this.pricePackageRepository = pricePackageRepository;
        this.orgConfigDepPackageRepository = orgConfigDepPackageRepository;
        this.organizationRepository = organizationRepository;
        this.frameDepartmentRepository = frameDepartmentRepository;
        this.harborProjectRepository = harborProjectRepository;
        this.resourceRepository = resourceRepository;
        this.jobRepository = jobRepository;
        this.serviceRepository = serviceRepository;
        this.storageDeptRepository = storageDeptRepository;
        this.storageRepository = storageRepository;
        this.materialsRepository = materialsRepository;
        this.resourceController = resourceController;
        this.serviceController = serviceController;
        this.storageController = storageController;
        this.depUsersRepository = depUsersRepository;
        this.accountUserRegisterRepository = accountUserRegisterRepository;
        this.harborProjectDeptRepository = harborProjectDeptRepository;
        this.noticeUserService = noticeUserService;
        this.domainRepository = domainRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.annotationRepository = annotationRepository;
        this.jobVersionRepository = jobVersionRepository;
        this.registerConfigRepository = registerConfigRepository;
        this.priceRepository = priceRepository;
        this.messageUtil = messageUtil;
    }
}

