/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.ElasticsearchUtils;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.controller.AccountImageController;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.HarborLabelRepository;
import com.mopaas.server.dao.HarborProjectDeptRepository;
import com.mopaas.server.dao.HarborProjectRepository;
import com.mopaas.server.dao.HarborRepoTagRepository;
import com.mopaas.server.dao.HarborUserRepository;
import com.mopaas.server.dao.ImagePullHistoryRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.HarborLabel;
import com.mopaas.server.entity.HarborProject;
import com.mopaas.server.entity.HarborProjectDept;
import com.mopaas.server.entity.HarborRepoTag;
import com.mopaas.server.entity.HarborUser;
import com.mopaas.server.entity.ImagePullHistory;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.exception.BusinessException;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.harbor.api.ProductsApi;
import com.mopaas.server.harbor.model.DetailedTag;
import com.mopaas.server.harbor.model.Label;
import com.mopaas.server.harbor.model.Project;
import com.mopaas.server.harbor.model.ProjectMember;
import com.mopaas.server.harbor.model.ProjectMetadata;
import com.mopaas.server.harbor.model.ProjectReq;
import com.mopaas.server.harbor.model.ProjectSummary;
import com.mopaas.server.harbor.model.Quota;
import com.mopaas.server.harbor.model.QuotaUpdateReq;
import com.mopaas.server.harbor.model.Registry;
import com.mopaas.server.harbor.model.ReplicationExecution;
import com.mopaas.server.harbor.model.ReplicationFilter;
import com.mopaas.server.harbor.model.ReplicationPolicy;
import com.mopaas.server.harbor.model.ReplicationTask;
import com.mopaas.server.harbor.model.ReplicationTrigger;
import com.mopaas.server.harbor.model.Repository;
import com.mopaas.server.harbor.model.ResourceList;
import com.mopaas.server.harbor.model.RetagReq;
import com.mopaas.server.harbor.model.User;
import com.mopaas.server.harbor.model.UserEntity;
import com.mopaas.server.model.request.IdRequest;
import com.mopaas.server.model.request.ImageAdaptRequest;
import com.mopaas.server.model.request.ImageLabelSetRequest;
import com.mopaas.server.model.request.ImagePullHistorySortPageRequest;
import com.mopaas.server.model.request.ImageSelectRequest;
import com.mopaas.server.model.request.ImageTagsRequest;
import com.mopaas.server.model.request.LogSearchRequest;
import com.mopaas.server.model.request.NewRepoRequest;
import com.mopaas.server.model.request.RepoCapacityRequest;
import com.mopaas.server.model.request.RepositorysRequest;
import com.mopaas.server.model.response.HarborStorageSetCapacityResponse;
import com.mopaas.server.model.response.IdNameModel;
import com.mopaas.server.model.response.ImageInfoResponse;
import com.mopaas.server.model.response.ImageLabelModel;
import com.mopaas.server.model.response.ImageLabelSelectModel;
import com.mopaas.server.model.response.ImagePullHistoryModel;
import com.mopaas.server.model.response.ImagePullLogResponse;
import com.mopaas.server.model.response.ImagePullRequest;
import com.mopaas.server.model.response.ImageTagModel;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.ListTagResultResponse;
import com.mopaas.server.model.response.LogResponse;
import com.mopaas.server.model.response.RepositoryProjectModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.SysConfigResponse;
import com.mopaas.server.service.CommonService;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1ContainerFluent;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobBuilder;
import io.kubernetes.client.openapi.models.V1JobFluent;
import io.kubernetes.client.openapi.models.V1JobSpecFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpecFluent;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluent;
import io.kubernetes.client.openapi.models.V1VolumeFluent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u955c\u50cf\u670d\u52a1-\u6846\u67b6\u955c\u50cf\uff08\u8bad\u7ec3\u73af\u5883\u548c\u8bad\u7ec3\u4efb\u52a1\uff09"})
public class AccountImageController {
    final UserRepository userRepository;
    final HarborProjectRepository harborProjectRepository;
    final HarborProjectDeptRepository harborProjectDeptRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DepUsersRepository depUsersRepository;
    final DomainRepository domainRepository;
    final HarborUserRepository harborUserRepository;
    final MessageUtil messageUtil;
    final SystemConfigRepository systemConfigRepository;
    final HarborRepoTagRepository harborRepoTagRepository;
    final HarborLabelRepository harborLabelRepository;
    final CommonService commonService;
    final DepQuotasRepository depQuotasRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final ImagePullHistoryRepository imagePullHistoryRepository;
    private static final Logger logger = LoggerFactory.getLogger(AccountImageController.class);
    private static final String ADAPT_JOB = "user-image-adaptor";
    private static final String ADAPT_JOB_SCRIPT = "ADAPT_JOB_SCRIPT";
    private static final String SCRIPT_NAME = "adapt-script";
    private static final String SCRIPT_FILE_NAME = "dockerfile";
    private static final String IMAGE_NOTFOUND_LOG = "no resources need to be replicated";

    @RequestMapping(value={"/api/account/image/info"}, method={RequestMethod.GET})
    @Transactional
    @ApiOperation(value="\u83b7\u53d6\u955c\u50cf\u4ed3\u5e93\u5730\u5740\u548c\u767b\u5f55\u4fe1\u606f", notes="3.5\u4fee\u6539\uff0c\u7528\u6237\u540d\u3001\u5bc6\u7801\u4e0d\u8fd4\u56de\uff0c\u548c\u5e73\u53f0\u4e00\u81f4")
    public ImageInfoResponse getImageInfo(HttpServletRequest request) {
        ImageInfoResponse res = new ImageInfoResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            return res;
        }
        res.setHarborUrl(FactoryCollection.harborDomainExternal((Long)domainId));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u521b\u5efa\u5206\u7ec4")
    @Transactional
    @RequestMapping(value={"/api/frame/repository/new"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse newRepo(@Valid @RequestBody NewRepoRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)dto.getName());
        Long userId = (Long)request.getSession().getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.user.not.exist"));
            return res;
        }
        Long depId = (Long)request.getSession().getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"image:create", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthorized"));
            return res;
        }
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        List userList = null;
        try {
            userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
        }
        catch (com.mopaas.server.harbor.ApiException e) {
            logger.error(e.getResponseBody(), (Throwable)e);
        }
        User harborUser = null;
        for (Object u : userList) {
            if (!huser.getHarborUsername().equals(u.getUsername())) continue;
            harborUser = u;
            break;
        }
        if (harborUser == null) {
            res.setMessage(this.messageUtil.getMessage("msg.repo.user.not.initialize"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.user.not.initialize"));
            return res;
        }
        if (dto.getName().length() < 2 || dto.getName().length() > 30) {
            res.setMessage(this.messageUtil.getMessage("msg.repo.project.name.length.error"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.name.length.error"));
            return res;
        }
        if (!dto.getName().matches("^[a-z]+[a-z0-9]*$")) {
            res.setMessage(this.messageUtil.getMessage("msg.repo.project.name.error"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.name.error"));
            return res;
        }
        try {
            List projects = harborApi.projectsGet(dto.getName(), null, null, null, null);
            if (projects != null && projects.size() > 0) {
                for (Project p : projects) {
                    if (!p.getName().equals(dto.getName())) continue;
                    res.setMessage(this.messageUtil.getMessage("msg.repo.project.exist"));
                    res.setCode(Constants.SC_MSG);
                    request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.exist"));
                    return res;
                }
            }
            ProjectReq projectReq = new ProjectReq();
            projectReq.setProjectName(dto.getName());
            projectReq.metadata(new ProjectMetadata()._public("false"));
            if (null != dto.getHarborStorage() && dto.getHarborStorage() != -1) {
                projectReq.setStorageLimit(Long.valueOf((long)(dto.getHarborStorage() * 1024 * 1024) * 1024L));
            }
            harborApi.projectsPost(projectReq);
            projects = harborApi.projectsGet(dto.getName(), null, null, null, null);
            Project project = null;
            if (projects != null && projects.size() > 0) {
                for (Project p : projects) {
                    if (!p.getName().equals(dto.getName())) continue;
                    project = p;
                    break;
                }
            }
            HarborProject harborProject = new HarborProject();
            harborProject.setDomain(domain);
            harborProject.setOwner(user);
            harborProject.setType(Integer.valueOf(0));
            harborProject.setProjectId(Long.valueOf(project.getProjectId().intValue()));
            harborProject.setProjectName(dto.getName());
            harborProject.setIsPublic(dto.getPublicType());
            harborProject.setOrganization(dep.getOrgConfig().getOrganization());
            harborProject.setDepartment(dep);
            harborProject.setDeleted(Integer.valueOf(0));
            harborProject.setHarborStorage(Integer.valueOf(dto.getHarborStorage() == null ? -1 : dto.getHarborStorage()));
            this.harborProjectRepository.save((Object)harborProject);
            ProjectMember projectMember = new ProjectMember();
            projectMember.setRoleId(Integer.valueOf(1));
            UserEntity userEntity = new UserEntity();
            userEntity.setUserId(harborUser.getUserId());
            userEntity.setUsername(harborUser.getUsername());
            projectMember.setMemberUser(userEntity);
            harborApi.projectsProjectIdMembersPost(Long.valueOf(project.getProjectId().intValue()), projectMember);
            res.setCode(Constants.SC_OK);
        }
        catch (com.mopaas.server.harbor.ApiException e) {
            logger.error(e.getResponseBody(), (Throwable)e);
            res.setMessage(e.getResponseBody());
            res.setCode(Constants.SC_ERROR);
            request.setAttribute("errorMessage", (Object)e.getResponseBody());
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u955c\u50cf\u4ed3\u5e93\u5217\u8868(\u8bbf\u95ee\u7ea7\u522b\u7b5b\u9009\uff0c\u641c\u7d22)")
    @Transactional
    @RequestMapping(value={"/api/frame/repository/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultResponse<RepositoryProjectModel> getRepositories(@Valid @RequestBody RepositorysRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException, ParseException {
        Integer publicType;
        List harborProjectDeptList;
        List projectList;
        int userType;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        Long domainId = (Long)session.getAttribute("domain");
        this.checkHarborInit(userId, domainId);
        DepUsers user = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        int n = userType = user == null ? 3 : user.getType();
        if (userType < 3) {
            if (null != dto.getUserId()) {
                projectList = this.harborProjectRepository.findByDepartmentIdAndOwnerIdAndDomainId(depId, dto.getUserId(), domainId);
            } else {
                projectList = this.harborProjectRepository.findByDepartmentId(depId);
                harborProjectDeptList = this.harborProjectDeptRepository.findByDepartmentId(depId);
                for (HarborProjectDept dept : harborProjectDeptList) {
                    HarborProject project = this.harborProjectRepository.findByProjectIdAndDomainId(dept.getProjectId(), domainId);
                    if (null == project || !projectList.stream().noneMatch(e -> project.getId().equals(e.getId()))) continue;
                    projectList.add(project);
                }
            }
        } else {
            projectList = this.harborProjectRepository.findByDepartmentIdAndOwnerIdAndDomainId(depId, userId, domainId);
        }
        harborProjectDeptList = this.harborProjectDeptRepository.findByDepartmentId(depId);
        if (harborProjectDeptList != null) {
            for (HarborProjectDept hpd : harborProjectDeptList) {
                Long projectId = hpd.getProjectId();
                HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomainId(projectId, domainId);
                if (harborProject == null || projectList.contains(harborProject) || harborProject.getDeleted() == 1 || !harborProject.getDomain().getId().equals((long)domainId)) continue;
                projectList.add(harborProject);
            }
        }
        ArrayList<RepositoryProjectModel> repoList = new ArrayList<RepositoryProjectModel>();
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        for (HarborProject harborProject : projectList) {
            Project project = null;
            try {
                project = harborApi.projectsProjectIdGet(harborProject.getProjectId());
            }
            catch (com.mopaas.server.harbor.ApiException e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
            if (project == null) continue;
            com.mopaas.server.entity.User owner = harborProject.getOwner();
            if (harborProject.getIsPublic() != 1 && !owner.getId().equals(userId)) continue;
            RepositoryProjectModel rpm = new RepositoryProjectModel();
            rpm.setPermission(Integer.valueOf(1));
            rpm.setProjectId(Long.valueOf(project.getProjectId().intValue()));
            rpm.setName(project.getName());
            rpm.setPublicType(Boolean.valueOf(harborProject.getIsPublic() == 1));
            rpm.setCount(project.getRepoCount());
            rpm.setCreateTime(df.parse(project.getCreationTime()));
            rpm.setType(Integer.valueOf(0));
            rpm.setUsername(owner.getUsername());
            rpm.setFullName(owner.getName() == null ? owner.getUsername() : owner.getName());
            ProjectSummary summary = harborApi.projectsProjectIdSummaryGet(harborProject.getProjectId());
            if (null != summary) {
                rpm.setUsed(SizeConverter.BTrim.convert((float)((Long)summary.getQuota().getUsed().getOrDefault((Object)"storage", (Object)0L)).longValue()));
            }
            if (harborProject.getHarborStorage() == null || harborProject.getHarborStorage() == -1) {
                rpm.setCapacity("-1");
            } else {
                rpm.setCapacity(SizeConverter.GBTrim.convert((float)harborProject.getHarborStorage().intValue()));
            }
            DepUsers resourceDepUser = this.depUsersRepository.findTopByUserIdAndDepartmentId(owner.getId(), depId);
            if (resourceDepUser != null) {
                rpm.setCreatorQuited(Integer.valueOf(0));
            } else {
                rpm.setCreatorQuited(Integer.valueOf(1));
            }
            List repositories = harborApi.repositoriesGet(project.getProjectId(), null, "-update_time", null, Integer.valueOf(1), Integer.valueOf(1));
            if (CollectionUtils.isEmpty((Collection)repositories)) {
                rpm.setUpdateTime(df.parse(project.getUpdateTime()));
            } else {
                List frames = this.commonService.getFrames(domainId);
                rpm.setUpdateTime(TimeUtil.tranDate((String)((Repository)repositories.get(0)).getUpdateTime()));
                JSONArray tagList = new JSONArray();
                for (Repository repo : repositories) {
                    List tags = harborApi.repositoriesRepoNameTagsGet(repo.getName(), null);
                    ArrayList<JSONObject> tagLabels = new ArrayList<JSONObject>();
                    if (tags != null) {
                        for (DetailedTag tag : tags) {
                            if (tag.getName().endsWith("-origin")) continue;
                            int isLabeled = 0;
                            List labels = tag.getLabels();
                            if (!CollectionUtils.isEmpty((Collection)labels) && labels.stream().filter(l -> frames.contains(l.getName()) || l.getName().startsWith("ai-")).count() > 1L) {
                                isLabeled = 1;
                            }
                            JSONObject tagLabel = new JSONObject();
                            tagLabel.put((Object)tag.getName(), (Object)isLabeled);
                            tagLabels.add(tagLabel);
                        }
                    }
                    JSONObject object = new JSONObject();
                    object.put((Object)repo.getName(), tagLabels);
                    tagList.add((Object)object);
                }
                rpm.setTagList(tagList);
            }
            repoList.add(rpm);
        }
        if (dto.getSearch() != null) {
            for (int i = repoList.size() - 1; i >= 0; --i) {
                RepositoryProjectModel rp = (RepositoryProjectModel)repoList.get(i);
                if (rp.getName().contains(dto.getSearch())) continue;
                repoList.remove(rp);
            }
        }
        if ((publicType = dto.getPublicType()) == null) {
            publicType = -1;
        }
        if (publicType != -1) {
            RepositoryProjectModel rp;
            if (dto.getPublicType() == 0) {
                for (int i = repoList.size() - 1; i >= 0; --i) {
                    rp = (RepositoryProjectModel)repoList.get(i);
                    if (!rp.getPublicType().booleanValue()) continue;
                    repoList.remove(rp);
                }
            } else {
                for (int i = repoList.size() - 1; i >= 0; --i) {
                    rp = (RepositoryProjectModel)repoList.get(i);
                    if (rp.getPublicType().booleanValue()) continue;
                    repoList.remove(rp);
                }
            }
        }
        repoList.sort((a1, a2) -> a2.getCreateTime().compareTo(a1.getCreateTime()));
        res.setList(repoList);
        return res;
    }

    private void checkHarborInit(Long userId, Long domainId) throws com.mopaas.server.harbor.ApiException {
        List userList;
        HarborUser user = this.harborUserRepository.findTopByUserIdAndDomainId(userId, domainId);
        if (user != null && !StringUtils.isEmpty((Object)user.getHarborPassword()) && !CollectionUtils.isEmpty((Collection)(userList = FactoryCollection.harborApi((Long)domainId).usersGet(user.getHarborUsername(), null, null, null))) && userList.stream().anyMatch(u -> user.getHarborUsername().equals(u.getUsername()))) {
            return;
        }
        throw new BusinessException(this.messageUtil.getMessage("msg.repo.user.not.initialize"));
    }

    @ApiOperation(value="\u955c\u50cf-\u7981\u7528")
    @Transactional
    @RequestMapping(value={"/api/repository/image/inactive"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse inactiveImage(@Valid @RequestBody ImageSelectRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ResultResponse res = new ResultResponse();
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)(dto.getRepoName() + ":" + dto.getTag()));
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long domainId = (Long)session.getAttribute("domain");
        this.checkHarborInit(userId, domainId);
        DetailedTag harborImage = this.commonService.getHarborImage(domainId, dto.getRepoName(), dto.getTag());
        if (harborImage.getLabels().stream().anyMatch(l -> "active".equals(l.getName()))) {
            this.commonService.imageInActive(domainId, dto.getRepoName(), dto.getTag());
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u955c\u50cf-\u542f\u7528")
    @Transactional
    @RequestMapping(value={"/api/repository/image/active"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse activeImage(@Valid @RequestBody ImageSelectRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ResultResponse res = new ResultResponse();
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)(dto.getRepoName() + ":" + dto.getTag()));
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long domainId = (Long)session.getAttribute("domain");
        this.checkHarborInit(userId, domainId);
        DetailedTag harborImage = this.commonService.getHarborImage(domainId, dto.getRepoName(), dto.getTag());
        this.commonService.imageActive(domainId, dto.getRepoName(), harborImage);
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u955c\u50cf\u7248\u672c\u8be6\u60c5", notes="v3.5\u4fee\u6539\uff0c\u6dfb\u52a0\u955c\u50cf\u4fe1\u606f")
    @Transactional
    @RequestMapping(value={"/api/repository/image/tags"}, method={RequestMethod.POST})
    @ResponseBody
    public ListTagResultResponse<ImageTagModel> imageTag(@Valid @RequestBody ImageTagsRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException, ApiException {
        Repository repo;
        ListTagResultResponse res = new ListTagResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomain(dto.getProjectId(), domain);
        if (harborProject != null) {
            com.mopaas.server.entity.User owner = harborProject.getOwner();
            res.setUsername(owner.getUsername());
            res.setFullName(owner.getName() == null ? owner.getUsername() : owner.getName());
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        Project project = harborApi.projectsProjectIdGet(dto.getProjectId());
        res.setProjectName(project.getName());
        List repositories = harborApi.repositoriesGet(project.getProjectId(), dto.getRepoName(), null, null, Integer.valueOf(1), Integer.valueOf(100));
        Repository repository = repo = CollectionUtils.isEmpty((Collection)repositories) ? null : (Repository)repositories.stream().filter(r -> r.getName().equals(dto.getRepoName())).findAny().orElse(null);
        if (null != repo) {
            res.setImageName(repo.getName().substring(repo.getName().indexOf("/") + 1));
            res.setCreateTime(TimeUtil.tranDate((String)repo.getCreationTime()));
            res.setUpdateTime(TimeUtil.tranDate((String)repo.getUpdateTime()));
            String repoDescription = repo.getDescription();
            if (repoDescription != null && !repoDescription.isEmpty()) {
                res.setDescription(repoDescription);
            }
        }
        ArrayList<ImageTagModel> list = new ArrayList<ImageTagModel>();
        List tags = harborApi.repositoriesRepoNameTagsGet(dto.getRepoName(), null);
        if (tags != null) {
            for (DetailedTag tag : tags) {
                if (tag.getName().endsWith("-origin")) continue;
                ImageTagModel model = new ImageTagModel();
                model.setTag(tag.getName());
                model.setStatus(Integer.valueOf(0));
                model.setState(Integer.valueOf(0));
                model.setType(Integer.valueOf(1));
                model.setCreateTime(TimeUtil.toDate((String)tag.getPushTime()));
                ArrayList<Integer> module = new ArrayList<Integer>();
                List labels = tag.getLabels();
                ArrayList<ImageLabelModel> labelsRes = new ArrayList<ImageLabelModel>();
                for (Label label : labels) {
                    if ("active".equals(label.getName())) {
                        model.setState(Integer.valueOf(1));
                        continue;
                    }
                    if ("ai-develop".equals(label.getName())) {
                        module.add(0);
                    } else if ("ai-job".equals(label.getName())) {
                        module.add(1);
                    } else if ("ai-serve".equals(label.getName())) {
                        module.add(2);
                    }
                    ImageLabelModel labelModel = new ImageLabelModel();
                    labelModel.setId(Long.valueOf(label.getId().longValue()));
                    labelModel.setName(label.getName());
                    labelsRes.add(labelModel);
                }
                model.setLabels(labelsRes);
                model.setModule(module);
                HarborRepoTag last = this.harborRepoTagRepository.findTopByRepositoryAndTagOrderByIdDesc(dto.getRepoName(), tag.getName());
                if (null != last) {
                    this.imageAdaptProbe(last, domainId);
                    model.setId(last.getId());
                    model.setNamespace(last.getNamespace());
                    model.setStatus(last.getStatus());
                    model.setType(last.getType());
                }
                list.add(model);
            }
            list.sort((a1, a2) -> a2.getCreateTime().compareTo(a1.getCreateTime()));
            res.setList(list);
            res.setTagCount(Integer.valueOf(list.size()));
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    private void imageAdaptProbe(HarborRepoTag hrt, Long domainId) throws ApiException, com.mopaas.server.harbor.ApiException {
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List pods = k8sFactory.listPods(hrt.getNamespace());
        if (!CollectionUtils.isEmpty((Collection)pods)) {
            for (V1Pod pod : pods) {
                List containerStatuses = pod.getStatus().getContainerStatuses();
                if (CollectionUtils.isEmpty((Collection)containerStatuses)) continue;
                for (V1ContainerStatus containerStatus : containerStatuses) {
                    if (!containerStatus.getReady().booleanValue()) {
                        if (containerStatus.getState() == null || containerStatus.getState().getTerminated() == null) continue;
                        Integer exitCode = containerStatus.getState().getTerminated().getExitCode();
                        if (exitCode == 0) {
                            hrt.setStatus(Integer.valueOf(2));
                            DetailedTag tag = this.commonService.getHarborImage(domainId, hrt.getRepository(), hrt.getTag());
                            this.commonService.imageActive(domainId, hrt.getRepository(), tag);
                            this.imageHash(domainId, hrt);
                            k8sFactory.deletePods(hrt.getNamespace());
                            continue;
                        }
                        hrt.setStatus(Integer.valueOf(-1));
                        continue;
                    }
                    hrt.setStatus(Integer.valueOf(1));
                }
            }
        }
    }

    @ApiOperation(value="\u7528\u6237\u955c\u50cf\u9002\u914d", notes="v3.5\u4fee\u6539\uff0c\u6dfb\u52a0\u53c2\u6570script")
    @Transactional
    @PutMapping(value={"/api/image/adapt/{type}"})
    public ResultResponse adaptor(@RequestBody @Valid ImageAdaptRequest dto, @ApiParam(value="0:\u624b\u52a8\u9002\u914d;1:\u7cfb\u7edf\u9002\u914d") @PathVariable(value="type") Integer type, HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        String userImage = FactoryCollection.harborDomain((Long)domainId) + "/" + dto.getRepoName() + ":" + dto.getTag();
        ResultResponse res = new ResultResponse();
        res.setEntity(userImage);
        HarborRepoTag tag = new HarborRepoTag();
        tag.setRepository(dto.getRepoName());
        tag.setTag(dto.getTag());
        tag.setNamespace(UUID.randomUUID().toString().replace("-", ""));
        tag.setType(type);
        tag.setDeleted(Integer.valueOf(0));
        tag.setScript(dto.getScript());
        res.setGuid(tag.getNamespace());
        this.harborRepoTagRepository.save((Object)tag);
        DetailedTag harborTag = this.commonService.getHarborImage(domainId, dto.getRepoName(), dto.getTag());
        HarborRepoTag last = this.harborRepoTagRepository.findTopByRepositoryAndTagAndStatusNotOrderByIdDesc(dto.getRepoName(), dto.getTag(), Integer.valueOf(0));
        if (type == 0) {
            this.commonService.imageActive(domainId, dto.getRepoName(), harborTag);
            tag.setStatus(Integer.valueOf(2));
            if (last != null) {
                last.setDeleted(Integer.valueOf(1));
            }
            return res;
        }
        if (StringUtils.isEmpty((Object)dto.getScript())) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.image.adapt.script.empty"));
            return res;
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        k8sFactory.createNamespace(tag.getNamespace());
        k8sFactory.createConfigMap(new V1ConfigMap().metadata(new V1ObjectMeta().name(SCRIPT_NAME).namespace(tag.getNamespace())).putDataItem(SCRIPT_FILE_NAME, dto.getScript().replace("_BASE_IMAGE", userImage + "-origin")));
        HashMap<String, String> nodeSelector = new HashMap<String, String>(2);
        if (harborTag.getLabels().stream().anyMatch(e -> "gpu".equals(e.getName()))) {
            nodeSelector.put("type", "gpu");
        } else {
            nodeSelector.put("machine", "x86");
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        DetailedTag detailedTag = this.commonService.getHarborImage(domainId, tag.getRepository(), tag.getTag());
        harborApi.repositoriesRepoNameTagsPost(tag.getRepository(), new RetagReq().tag(tag.getTag() + "-origin").override(Boolean.valueOf(true)).srcImage(tag.getRepository() + ":" + detailedTag.getDigest()));
        String adapt_job_image = FactoryCollection.harborDomain((Long)domainId) + "/" + this.systemConfigRepository.findByConfigName("ADAPT_JOB_IMAGE").getConfigValue();
        V1Job job = ((V1JobBuilder)((V1JobFluent.SpecNested)((V1JobSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.VolumesNested)((V1VolumeFluent.HostPathNested)((V1PodSpecFluent.VolumesNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.VolumesNested)((V1VolumeFluent.HostPathNested)((V1PodSpecFluent.VolumesNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.VolumesNested)((V1VolumeFluent.HostPathNested)((V1PodSpecFluent.VolumesNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.VolumesNested)((V1VolumeFluent.HostPathNested)((V1PodSpecFluent.VolumesNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.VolumesNested)((V1VolumeFluent.ConfigMapNested)((V1ConfigMapVolumeSourceFluent.ItemsNested)((V1ConfigMapVolumeSourceFluent.ItemsNested)((V1VolumeFluent.ConfigMapNested)((V1PodSpecFluent.VolumesNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.VolumeMountsNested)((V1ContainerFluent.VolumeMountsNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.VolumeMountsNested)((V1ContainerFluent.VolumeMountsNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.VolumeMountsNested)((V1ContainerFluent.VolumeMountsNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.VolumeMountsNested)((V1ContainerFluent.VolumeMountsNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.VolumeMountsNested)((V1ContainerFluent.VolumeMountsNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodTemplateSpecFluent.SpecNested)((V1JobSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.MetadataNested)((V1PodTemplateSpecFluent.MetadataNested)((V1JobFluent.SpecNested)((V1JobFluent.SpecNested)((V1JobFluent.SpecNested)((V1JobSpecFluent.SelectorNested)((V1JobFluent.SpecNested)((V1JobBuilder)((V1JobFluent.MetadataNested)((V1JobFluent.MetadataNested)new V1JobBuilder().withNewMetadata().withName(ADAPT_JOB)).addToLabels("job", "adapt")).endMetadata()).withNewSpec().withManualSelector(Boolean.valueOf(true))).withNewSelector().addToMatchLabels("job", "adapt")).endSelector()).withBackoffLimit(Integer.valueOf(0))).withTtlSecondsAfterFinished(Integer.valueOf(10))).withNewTemplate().withNewMetadata().addToLabels("job", "adapt")).addToLabels("log", "true")).endMetadata()).withNewSpec().withNodeSelector(nodeSelector)).withRestartPolicy("Never")).addNewContainer().withName("adaptor")).withImage(adapt_job_image)).withTty(Boolean.valueOf(true))).addNewArg(FactoryCollection.harborUsername((Long)domainId))).addNewArg(FactoryCollection.harborPassword((Long)domainId))).addNewArg(userImage)).addNewArg("/tmp/Dockerfile")).addNewVolumeMount().withName(SCRIPT_NAME)).withMountPath("/tmp")).endVolumeMount()).addNewVolumeMount().withName("timezone")).withMountPath("/etc/localtime")).endVolumeMount()).addNewVolumeMount().withName("docker")).withMountPath("/usr/bin/docker")).endVolumeMount()).addNewVolumeMount().withName("docker-sock")).withMountPath("/var/run/docker.sock")).endVolumeMount()).addNewVolumeMount().withName("docker-containers")).withMountPath("/var/lib/docker/containers")).endVolumeMount()).endContainer()).addNewVolume().withName(SCRIPT_NAME)).withNewConfigMap().withName(SCRIPT_NAME)).addNewItem().withKey(SCRIPT_FILE_NAME)).withPath("Dockerfile")).endItem()).endConfigMap()).endVolume()).addNewVolume().withName("timezone")).withNewHostPath().withPath("/usr/share/zoneinfo/Asia/Shanghai")).endHostPath()).endVolume()).addNewVolume().withName("docker")).withNewHostPath().withPath("/opt/kube/bin/docker")).endHostPath()).endVolume()).addNewVolume().withName("docker-sock")).withNewHostPath().withPath("/var/run/docker.sock")).endHostPath()).endVolume()).addNewVolume().withName("docker-containers")).withNewHostPath().withPath("/var/lib/docker/containers")).endHostPath()).endVolume()).endSpec()).endTemplate()).endSpec()).build();
        k8sFactory.batchV1Api.createNamespacedJob(tag.getNamespace(), job, null, null, null);
        if (null != last) {
            k8sFactory.deleteNamespace(last.getNamespace());
            last.setDeleted(Integer.valueOf(1));
        }
        tag.setStatus(Integer.valueOf(0));
        return res;
    }

    private void imageHash(Long domainId, HarborRepoTag hrt) throws ApiException {
        String lastLine;
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List pods = k8sFactory.listPods(hrt.getNamespace());
        if (!CollectionUtils.isEmpty((Collection)pods) && (lastLine = k8sFactory.coreV1Api.readNamespacedPodLog(((V1Pod)pods.get(0)).getMetadata().getName(), hrt.getNamespace(), null, Boolean.valueOf(false), null, null, null, Boolean.valueOf(false), null, Integer.valueOf(1), Boolean.valueOf(false))).startsWith("sha256")) {
            hrt.setSha256(lastLine);
        }
    }

    @ApiOperation(value="\u9002\u914d\u65e5\u5fd7", notes="v3.5\u65b0\u589e")
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/image/{namespace}/log"})
    public LogResponse log(@ApiParam(value="tag \u5bf9\u5e94\u7684namespace") @PathVariable(value="namespace") String namespace, @RequestBody LogSearchRequest dto, HttpServletRequest request) {
        LogResponse res = new LogResponse();
        HarborRepoTag repoTag = this.harborRepoTagRepository.findByNamespace(namespace);
        res.setEntity(repoTag.getRepository() + ":" + repoTag.getTag());
        res.setGuid(namespace);
        try {
            Date start = Optional.ofNullable(repoTag.getCreatedAt()).orElse(dto.getStart());
            Date end = dto.getEnd();
            long domain = Long.parseLong(request.getHeader("Domain"));
            res = ElasticsearchUtils.query((Long)domain, (String)namespace, null, (String)dto.getKeyword(), (Date)(null == dto.getStart() || start.after(dto.getStart()) ? start : dto.getStart()), (Date)(null == dto.getEnd() || end.before(dto.getEnd()) ? new Date(end.getTime() + 3600000L) : dto.getEnd()), (String)dto.getScrollId(), (Integer)dto.getSize());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            res.setCode(Constants.SC_MSG);
        }
        return res;
    }

    @ApiOperation(value="\u65e5\u5fd7\u4e0b\u8f7d")
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/image/{namespace}/log/download"})
    public ResultResponse logDownload(@ApiParam(value="tag \u5bf9\u5e94\u7684namespace") @PathVariable(value="namespace") String namespace, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultResponse res = new ResultResponse();
        HarborRepoTag repoTag = this.harborRepoTagRepository.findByNamespace(namespace);
        res.setEntity(repoTag.getRepository() + ":" + repoTag.getTag());
        res.setGuid(namespace);
        ElasticsearchUtils.downloadLog((HttpServletRequest)request, (HttpServletResponse)response, (String)namespace, null, (String)repoTag.getTag(), null, null);
        return res;
    }

    @ApiOperation(value="\u955c\u50cf\u7248\u672c\u8bbe\u7f6e\u6807\u7b7e", notes="v3.4\u4fee\u6539\uff0c\u8bf7\u6c42\u65b0\u589e\u53c2\u6570module")
    @Transactional
    @RequestMapping(value={"/api/repository/image/tag/labels/set"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse setLabels(@Valid @RequestBody ImageLabelSetRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        List labels;
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)(dto.getRepoName() + ":" + dto.getTag()));
        Long domainId = (Long)session.getAttribute("domain");
        Long depId = (Long)request.getSession().getAttribute("departmentId");
        if (!DepartmentController.isDepPermission((String)"image:label", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        DetailedTag harborImage = this.commonService.getHarborImage(domainId, dto.getRepoName(), dto.getTag());
        List labelIds = dto.getLabelIds() == null ? new ArrayList() : dto.getLabelIds();
        List modules = dto.getModule();
        if (!CollectionUtils.isEmpty((Collection)modules)) {
            ArrayList<String> mList = new ArrayList<String>(3);
            if (modules.contains(0)) {
                mList.add("ai-develop");
            }
            if (modules.contains(1)) {
                mList.add("ai-job");
            }
            if (modules.contains(2)) {
                mList.add("ai-serve");
            }
            labels = this.harborLabelRepository.findByDomainIdAndNameIn(domainId, mList);
            Optional.ofNullable(labels).ifPresent(harborLabels -> harborLabels.forEach(l -> labelIds.add(l.getHarborId())));
        }
        ProductsApi productsApi = FactoryCollection.harborApi((Long)domainId);
        labels = harborImage.getLabels();
        List removeLabels = labels.stream().filter(l -> !labelIds.contains(l.getId())).collect(Collectors.toList());
        for (Label label : removeLabels) {
            if ("active".equals(label.getName())) continue;
            productsApi.repositoriesRepoNameTagsTagLabelsLabelIdDelete(dto.getRepoName(), dto.getTag(), label.getId());
        }
        for (Integer labelId : labelIds) {
            if (!labels.stream().noneMatch(l -> labelId.equals(l.getId()))) continue;
            Label label = productsApi.labelsIdGet(Long.valueOf(labelId.longValue()));
            productsApi.repositoriesRepoNameTagsTagLabelsPost(dto.getRepoName(), dto.getTag(), label);
        }
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u955c\u50cf\u7248\u672c\u83b7\u53d6\u6807\u7b7e\uff080\u672a\u9009\uff0c1\u5df2\u9009\uff09", notes="v3.4\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570module")
    @Transactional
    @RequestMapping(value={"/api/repository/image/tag/labels"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultResponse<ImageLabelSelectModel> getLabels(@Valid @RequestBody ImageSelectRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        ArrayList<ImageLabelSelectModel> list = new ArrayList<ImageLabelSelectModel>();
        DetailedTag harborImage = this.commonService.getHarborImage(domainId, dto.getRepoName(), dto.getTag());
        List imageLabels = harborImage.getLabels();
        List labels = this.harborLabelRepository.findByTypeAndDomainId(Integer.valueOf(0), domainId);
        HarborLabel gpuLabel = this.harborLabelRepository.findByNameAndDomainId("gpu", domainId);
        HarborLabel x86Label = this.harborLabelRepository.findByNameAndDomainId("x86", domainId);
        labels.add(gpuLabel);
        labels.add(x86Label);
        for (HarborLabel label : labels) {
            ImageLabelSelectModel model = new ImageLabelSelectModel();
            model.setId(label.getHarborId());
            model.setName(label.getName());
            if (!CollectionUtils.isEmpty((Collection)imageLabels) && imageLabels.stream().anyMatch(l -> label.getHarborId().equals(l.getId()))) {
                model.setSelected(Integer.valueOf(1));
            } else {
                model.setSelected(Integer.valueOf(0));
            }
            ArrayList<Integer> module = new ArrayList<Integer>();
            switch (label.getName()) {
                case "matlab": 
                case "ray": {
                    module.add(0);
                    break;
                }
                case "tensorflow": 
                case "pytorch": {
                    module.add(0);
                    module.add(1);
                    module.add(2);
                    break;
                }
                case "gpu": 
                case "x86": {
                    break;
                }
                default: {
                    module.add(0);
                    module.add(1);
                }
            }
            model.setModule(module);
            list.add(model);
        }
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u955c\u50cf\u9002\u914d\u811a\u672c\u5185\u5bb9", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"/api/repository/adapt/script"})
    public SysConfigResponse getAdaptScript(@RequestBody @ApiParam(value="id\u4e3a\u7248\u672c\u9002\u914d\u8bb0\u5f55Id\uff0c\u5982\u679cid\u4e3a\u7a7a\u5219\u4e0d\u4f20") IdRequest dto) {
        HarborRepoTag hrt;
        SysConfigResponse res = new SysConfigResponse();
        if (null != dto.getId() && !StringUtils.isEmpty((Object)(hrt = (HarborRepoTag)this.harborRepoTagRepository.findOne((Serializable)dto.getId())).getScript())) {
            res.setValue(hrt.getScript());
            return res;
        }
        SystemConfig config = this.systemConfigRepository.findByConfigName(ADAPT_JOB_SCRIPT);
        res.setValue(config.getConfigValue());
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u955c\u50cf\u4ed3\u5e93\u53ef\u7528\u914d\u989d", notes="v3.5\u65b0\u589e")
    @Transactional
    @GetMapping(value={"/api/frame/repository/quota"})
    public HarborStorageSetCapacityResponse repositoryQuota(HttpServletRequest request) {
        int depRemained;
        Integer depAllAllocated;
        int orgRemained;
        HarborStorageSetCapacityResponse res = new HarborStorageSetCapacityResponse();
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        Long domainId = (Long)session.getAttribute("domain");
        String depName = null;
        for (OrgConfig config : org.getOrgConfigs()) {
            if (1 != config.getLevel()) continue;
            depName = config.getName();
        }
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domainId);
        if (null == orgQuotas) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer allAllocated = this.harborProjectRepository.sumQuotaAllocatedByOrgAndDomainId(org, domainId);
        if (null == allAllocated) {
            allAllocated = 0;
        }
        if ((orgRemained = orgQuotas.getHarborStorage() == null || orgQuotas.getHarborStorage() == -1 ? -1 : Math.max(orgQuotas.getHarborStorage() - allAllocated, 0)) != -1 && orgRemained <= 0) {
            res.setType(this.messageUtil.getMessage("msg.org"));
        }
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId);
        int depCapacity = -1;
        if (depQuotas != null && depQuotas.getHarborStorage() != null) {
            int n = depCapacity = depQuotas.getHarborStorage() == null ? -1 : depQuotas.getHarborStorage();
        }
        if (null == (depAllAllocated = this.harborProjectRepository.sumHarborStorageByDepAndDomain(depId, domainId))) {
            depAllAllocated = 0;
        }
        if ((depRemained = depCapacity == -1 ? -1 : Math.max(depCapacity - depAllAllocated, 0)) != -1 && depRemained <= 0) {
            res.setType(depName != null ? depName : this.messageUtil.getMessage("msg.dep"));
        }
        int capacity = -1;
        if (orgRemained != -1 && depRemained != -1) {
            capacity = Math.min(orgRemained, depRemained);
        } else if (orgRemained != -1) {
            capacity = orgRemained;
        } else if (depRemained != -1) {
            capacity = depRemained;
        }
        res.setCapacity(Integer.valueOf(capacity));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u955c\u50cf\u4ed3\u5e93\u5217\u8868", notes="v3.5\u65b0\u589e")
    @GetMapping(value={"api/image/registries"})
    public ListResultResponse<IdNameModel> registries(HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ListResultResponse res = new ListResultResponse();
        Long domainId = (Long)request.getSession().getAttribute("domain");
        List registries = FactoryCollection.harborApi((Long)domainId).registriesGet(null);
        if (!CollectionUtils.isEmpty((Collection)registries)) {
            List urls = registries.stream().map(r -> IdNameModel.builder().id(r.getId()).name(r.getName()).registry(r.getUrl().split("//")[1]).build()).collect(Collectors.toList());
            res.setList(urls);
        }
        return res;
    }

    @LogAnnotation(type=6, msgExpression="msg.image.pull")
    @ApiOperation(value="\u955c\u50cf\u5bfc\u5165", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/image/pull"})
    public ResultResponse imageImport(@RequestBody @Valid ImagePullRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getImage());
        res.setGuid(UUID.randomUUID().toString());
        if (!dto.getImage().matches("^[a-z0-9]+([-_/a-z0-9]+)*[a-z0-9]+:[a-z0-9]+([-.a-z0-9]+)*[a-z0-9]+$")) {
            res.setMessage(this.messageUtil.getMessage("msg.image.name.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        Registry registry = harborApi.registriesIdGet(dto.getId());
        String image = dto.getImage();
        if (registry.getName().startsWith("DockerHub") && !image.contains("/")) {
            image = "library/" + image;
        }
        ImagePullHistory oldHistory = this.imagePullHistoryRepository.findTopByImageAndProjectAndRegistryIdOrderByIdDesc(image, dto.getProject(), dto.getId());
        ReplicationPolicy policy = null;
        if (null != oldHistory) {
            try {
                policy = harborApi.replicationPoliciesIdGet(oldHistory.getPolicyId());
            }
            catch (com.mopaas.server.harbor.ApiException e) {
                logger.info(e.getResponseBody());
            }
        }
        if (null == policy) {
            String policyName = res.getGuid().substring(24);
            String[] split = image.split(":");
            policy = new ReplicationPolicy().name(policyName).deletion(Boolean.valueOf(false)).destNamespace(dto.getProject()).enabled(Boolean.valueOf(true)).override(Boolean.valueOf(true)).addFiltersItem(new ReplicationFilter().type("name").value(split[0])).addFiltersItem(new ReplicationFilter().type("tag").value(split[1])).srcRegistry(registry).trigger(new ReplicationTrigger().type("manual"));
            harborApi.replicationPoliciesPost(policy);
            List policies = harborApi.replicationPoliciesGet(policyName, Integer.valueOf(1), Integer.valueOf(10));
            Optional<ReplicationPolicy> any = policies.stream().filter(p -> policyName.equals(p.getName())).findAny();
            if (any.isPresent()) {
                policy = any.get();
            }
        }
        harborApi.replicationExecutionsPost(new ReplicationExecution().policyId(Integer.valueOf(policy.getId().intValue())));
        ImagePullHistory history = new ImagePullHistory();
        history.setImage(image);
        history.setProject(dto.getProject());
        history.setName(registry.getName());
        history.setRegistry(registry.getUrl());
        history.setRegistryId(registry.getId());
        history.setStatus("InProgress");
        history.setDomain((Domain)this.domainRepository.findOne((Serializable)domainId));
        history.setDepartment((OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)((Long)session.getAttribute("departmentId"))));
        history.setUser((com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)((Long)session.getAttribute("userId"))));
        history.setPolicyId(policy.getId());
        history.setPolicy(policy.getName());
        this.imagePullHistoryRepository.save((Object)history);
        return res;
    }

    @ApiOperation(value="\u955c\u50cf\u5bfc\u5165\u65e5\u5fd7\u5217\u8868", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/image/pull/history"})
    public ListResultResponse<ImagePullHistoryModel> imagePullHistories(@RequestBody @Valid ImagePullHistorySortPageRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ListResultResponse res = new ListResultResponse();
        PageRequest pageable = dto.getStatusSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getStatusSort() == 0 ? Sort.Direction.DESC : Sort.DEFAULT_DIRECTION, new String[]{"status"}) : (dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.DEFAULT_DIRECTION, new String[]{"pullTime"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"}));
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        1 spec = new /* Unavailable Anonymous Inner Class!! */;
        Page page = this.imagePullHistoryRepository.findAll((Specification)spec, (Pageable)pageable);
        res.setSize(Long.valueOf(page.getTotalElements()));
        res.setPages(Integer.valueOf(page.getTotalPages()));
        if (page.getTotalElements() > 0L) {
            ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
            ArrayList<ImagePullHistoryModel> models = new ArrayList<ImagePullHistoryModel>();
            res.setList(models);
            List content = page.getContent();
            for (ImagePullHistory history : content) {
                ImagePullHistoryModel model = new ImagePullHistoryModel();
                if (history.getExecutionsId() == null) {
                    List executions = null;
                    try {
                        executions = harborApi.replicationExecutionsGet(Integer.valueOf(history.getPolicyId().intValue()), null, null, Integer.valueOf(1), Integer.valueOf(10));
                    }
                    catch (com.mopaas.server.harbor.ApiException e) {
                        logger.info("Get harbor policy: {} --- executions---{}", (Object)history.getPolicy(), (Object)e.getResponseBody());
                    }
                    if (!CollectionUtils.isEmpty(executions)) {
                        history.setExecutionsId(Long.valueOf(((ReplicationExecution)executions.get(0)).getId().longValue()));
                    }
                }
                if (null != history.getExecutionsId()) {
                    if (!"Succeed".equals(history.getStatus()) && !"Failed".equals(history.getStatus())) {
                        try {
                            ReplicationExecution execution = harborApi.replicationExecutionsIdGet(history.getExecutionsId());
                            if (null != execution) {
                                if ("Succeed".equals(execution.getStatus()) && IMAGE_NOTFOUND_LOG.equals(execution.getStatusText())) {
                                    history.setStatus("Failed");
                                } else {
                                    history.setStatus(execution.getStatus());
                                }
                                if (IMAGE_NOTFOUND_LOG.equals(execution.getStatusText())) {
                                    history.setErrorMessage(this.messageUtil.getMessage("msg.image.not.exist"));
                                } else if (!StringUtils.isEmpty((Object)execution.getStatusText())) {
                                    history.setErrorMessage(execution.getStatusText());
                                }
                                history.setPullTime(execution.getStartTime());
                            }
                        }
                        catch (com.mopaas.server.harbor.ApiException e) {
                            logger.info("Get harbor executions: {} --- policy: {} ---{}", new Object[]{history.getExecutionsId(), history.getPolicy(), e.getResponseBody()});
                        }
                        try {
                            List tasks = harborApi.replicationExecutionsIdTasksGet(history.getExecutionsId());
                            if (!CollectionUtils.isEmpty((Collection)tasks)) {
                                history.setTaskId(Long.valueOf(((ReplicationTask)tasks.get(0)).getId().longValue()));
                            }
                        }
                        catch (com.mopaas.server.harbor.ApiException e) {
                            logger.info("Get harbor tasks policy: {} --- executions: {} ---{}", new Object[]{history.getPolicy(), history.getExecutionsId(), e.getResponseBody()});
                        }
                    } else if (null == history.getPolicyRemoved() || history.getPolicyRemoved() == 0) {
                        try {
                            String log = harborApi.replicationExecutionsIdTasksTaskIdLogGet(history.getExecutionsId(), history.getTaskId());
                            history.setLog(log);
                            harborApi.replicationPoliciesIdDelete(history.getPolicyId());
                        }
                        catch (com.mopaas.server.harbor.ApiException e) {
                            logger.info("delete policy {} --- {}", (Object)history.getPolicy(), (Object)e.getResponseBody());
                        }
                        history.setPolicyRemoved(Integer.valueOf(1));
                    }
                }
                BeanUtils.copyProperties((Object)history, (Object)model);
                if ("Failed".equals(history.getStatus())) {
                    model.setErrorMessage(this.messageUtil.getMessage("msg.error.check.log"));
                }
                com.mopaas.server.entity.User user = history.getUser();
                model.setUserId(user.getId());
                model.setUsername(user.getUsername());
                model.setFullName(user.getName());
                DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(user, dep);
                if (resourceDepUser != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                models.add(model);
            }
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u955c\u50cf\u5bfc\u5165\u65e5\u5fd7", notes="v3.5\u65b0\u589e")
    @GetMapping(value={"api/image/history/{id}/log"})
    @Transactional
    public ImagePullLogResponse imagePullLog(@PathVariable(value="id") Long id, HttpServletRequest request) {
        ImagePullLogResponse res = new ImagePullLogResponse();
        ImagePullHistory history = (ImagePullHistory)this.imagePullHistoryRepository.findOne((Serializable)id);
        if (null != history) {
            String log;
            if (Optional.ofNullable(history.getPolicyRemoved()).orElse(0) == 0 && history.getExecutionsId() != null && history.getTaskId() != null) {
                try {
                    Long domainId = (Long)request.getSession().getAttribute("domain");
                    String log2 = FactoryCollection.harborApi((Long)domainId).replicationExecutionsIdTasksTaskIdLogGet(history.getExecutionsId(), history.getTaskId());
                    history.setLog(log2);
                }
                catch (com.mopaas.server.harbor.ApiException e) {
                    logger.warn(e.getResponseBody());
                }
            }
            res.setLogs(StringUtils.isEmpty((Object)(log = history.getLog())) ? history.getErrorMessage() : log);
        }
        return res;
    }

    @LogAnnotation(type=6, msgExpression="msg.repo.expansion")
    @ApiOperation(value="\u5206\u7ec4\u5bb9\u91cf\u6269\u5bb9", notes="v3.5\u65b0\u589e")
    @Transactional
    @RequestMapping(value={"/api/frame/repository/expansion"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResultResponse expansion(@RequestBody @Valid RepoCapacityRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        Long userId = (Long)request.getSession().getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.user.not.exist"));
            return res;
        }
        HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomain(dto.getProjectId(), domain);
        res.setEntity(harborProject.getProjectName());
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, harborProject.getDepartment());
        if (!userId.equals(harborProject.getOwner().getId()) && depUsers.getType() == 3) {
            throw new MessageCodeException(harborProject.getProjectName(), null, "msg.account.unauthorized", new String[0]);
        }
        try {
            ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
            List quotas = harborApi.quotasGet(null, null, null, null, null);
            Integer quotaId = null;
            for (Quota quota : quotas) {
                if (!harborProject.getProjectName().equals(quota.getRef().get((Object)"name"))) continue;
                quotaId = quota.getId();
                break;
            }
            Integer harborStorage = harborProject.getHarborStorage() == null || harborProject.getHarborStorage() < 0 ? Integer.valueOf(0) : harborProject.getHarborStorage();
            QuotaUpdateReq quotaUpdateReq = new QuotaUpdateReq();
            ResourceList resourceList = new ResourceList();
            resourceList.put((Object)"count", (Object)-1L);
            resourceList.put((Object)"storage", (Object)((long)((harborStorage + dto.getCapacity()) * 1024 * 1024) * 1024L));
            quotaUpdateReq.setHard(resourceList);
            harborApi.quotasIdPut(quotaId, quotaUpdateReq);
            harborProject.setHarborStorage(Integer.valueOf(harborStorage + dto.getCapacity()));
            res.setCode(Constants.SC_OK);
        }
        catch (com.mopaas.server.harbor.ApiException e) {
            logger.error(e.getResponseBody(), (Throwable)e);
            res.setMessage(e.getResponseBody());
            res.setCode(Constants.SC_ERROR);
        }
        return res;
    }

    @ConstructorProperties(value={"userRepository", "harborProjectRepository", "harborProjectDeptRepository", "orgConfigDepartmentRepository", "depUsersRepository", "domainRepository", "harborUserRepository", "messageUtil", "systemConfigRepository", "harborRepoTagRepository", "harborLabelRepository", "commonService", "depQuotasRepository", "organizationQuotasRepository", "imagePullHistoryRepository"})
    public AccountImageController(UserRepository userRepository, HarborProjectRepository harborProjectRepository, HarborProjectDeptRepository harborProjectDeptRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DepUsersRepository depUsersRepository, DomainRepository domainRepository, HarborUserRepository harborUserRepository, MessageUtil messageUtil, SystemConfigRepository systemConfigRepository, HarborRepoTagRepository harborRepoTagRepository, HarborLabelRepository harborLabelRepository, CommonService commonService, DepQuotasRepository depQuotasRepository, OrganizationQuotasRepository organizationQuotasRepository, ImagePullHistoryRepository imagePullHistoryRepository) {
        this.userRepository = userRepository;
        this.harborProjectRepository = harborProjectRepository;
        this.harborProjectDeptRepository = harborProjectDeptRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.depUsersRepository = depUsersRepository;
        this.domainRepository = domainRepository;
        this.harborUserRepository = harborUserRepository;
        this.messageUtil = messageUtil;
        this.systemConfigRepository = systemConfigRepository;
        this.harborRepoTagRepository = harborRepoTagRepository;
        this.harborLabelRepository = harborLabelRepository;
        this.commonService = commonService;
        this.depQuotasRepository = depQuotasRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.imagePullHistoryRepository = imagePullHistoryRepository;
    }
}

