/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.EncodeUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.controller.AnnotationController;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.dao.AnnotationRepository;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.StorageDeptRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.dto.VolumeMountDto;
import com.mopaas.server.entity.Annotation;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.StorageDept;
import com.mopaas.server.entity.User;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.harbor.api.ProductsApi;
import com.mopaas.server.harbor.model.Project;
import com.mopaas.server.model.request.AnnotationRequest;
import com.mopaas.server.model.request.AnnotationSortPageRequest;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.MetricRequest;
import com.mopaas.server.model.request.PasswordEditRequest;
import com.mopaas.server.model.response.AnnotationInfoResponse;
import com.mopaas.server.model.response.AnnotationModel;
import com.mopaas.server.model.response.FrameworkModel;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.RangeMetricModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.StorageMountModel;
import com.mopaas.server.model.response.StorageMountResponse;
import com.mopaas.server.service.CommonService;
import io.kubernetes.client.Exec;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateTerminated;
import io.kubernetes.client.openapi.models.V1ContainerStateWaiting;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1HostPathVolumeSource;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6807\u6ce8"})
@RestController
public class AnnotationController {
    final StorageRepository storageRepository;
    final SystemConfigRepository systemConfigRepository;
    final UserRepository userRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DepUsersRepository depUsersRepository;
    final AnnotationRepository annotationRepository;
    final DomainRepository domainRepository;
    final StorageServiceFactory storageServiceFactory;
    final MessageUtil messageUtil;
    final PricePackageRepository pricePackageRepository;
    final BalancesRepository balancesRepository;
    final CommonService commonService;
    final MaterialsRepository materialsRepository;
    final StorageDeptRepository storageDeptRepository;
    private static final Logger logger = LoggerFactory.getLogger(AnnotationController.class);
    private static final String DEPLOY_NAME = "deploy-annotation";
    private static final String SERVICE_NAME = "svc-annotation";

    @ApiOperation(value="\u83b7\u53d6\u955c\u50cf\u5217\u8868", notes="v3.5\u65b0\u589e")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/annotation/images"})
    public ListResultResponse<FrameworkModel> images(HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        List projects = harborApi.projectsGet("ai", null, null, null, null);
        Optional<Project> project = projects.stream().filter(p -> "ai".equals(p.getName())).findAny();
        if (project.isPresent()) {
            List repositories = harborApi.repositoriesGet(project.get().getProjectId(), null, null, null, null, null);
            List models = repositories.stream().flatMap(r -> {
                try {
                    List tags = harborApi.repositoriesRepoNameTagsGet(r.getName(), null);
                    return tags.stream().filter(t -> t.getLabels().stream().filter(l -> "active".equals(l.getName()) || "ai-annotation".equals(l.getName())).count() == 2L).map(t -> {
                        FrameworkModel model = new FrameworkModel();
                        model.setName(r.getName().substring(r.getName().lastIndexOf("/") + 1));
                        model.setTag(t.getName());
                        model.setRepository(r.getName());
                        return model;
                    });
                }
                catch (com.mopaas.server.harbor.ApiException e) {
                    logger.error(e.getResponseBody(), (Throwable)e);
                    return null;
                }
            }).collect(Collectors.toList());
            res.setList(models);
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u6302\u8f7d\u5b58\u50a8\u5217\u8868", notes="\u5305\u542b\u7ec4\u7ec7\u5185\u5171\u4eab\u5b58\u50a8")
    @Transactional(readOnly=true)
    @RequestMapping(value={"api/annotation/storage/list"}, method={RequestMethod.GET})
    public StorageMountResponse<StorageMountModel> mountList(HttpServletRequest request) {
        List depts;
        StorageMountModel model;
        StorageMountResponse res = new StorageMountResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        Long domainId = (Long)session.getAttribute("domain");
        HashSet<StorageMountModel> set = new HashSet<StorageMountModel>();
        List storages = this.storageRepository.findByUserIdAndDomainIdAndDepartmentIdAndStatusAndDeletedAndTypeNot(userId, domainId, depId, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(2));
        if (null != storages) {
            for (Storage s2 : storages) {
                if (s2.getName().equalsIgnoreCase(user.getGuid().replace("-", ""))) continue;
                model = new StorageMountModel();
                model.setId(s2.getId());
                model.setName(s2.getName());
                model.setShared(s2.getShared());
                model.setPassword(EncodeUtil.rawInput((String)s2.getPassword()));
                model.setWebUrl("k8s/" + s2.getWebPort() + "/index.php?user/loginSubmit");
                model.setUpdatedAt(s2.getUpdatedAt());
                model.setGuid(s2.getGuid().substring(0, 12));
                model.setMountPath("/ai/" + s2.getMountPath());
                set.add(model);
            }
        }
        if (null != (depts = this.storageDeptRepository.findByDepartmentId(depId))) {
            for (StorageDept dept : depts) {
                Storage storage = dept.getStorage();
                if (storage.getDeleted() == 1 || !storage.getDomain().getId().equals(domainId)) continue;
                model = new StorageMountModel();
                model.setId(storage.getId());
                model.setName(storage.getName());
                model.setShared(storage.getShared());
                model.setPassword(EncodeUtil.rawInput((String)storage.getPassword()));
                model.setWebUrl("k8s/" + storage.getWebPort() + "/index.php?user/loginSubmit");
                model.setUpdatedAt(storage.getUpdatedAt());
                model.setGuid(storage.getGuid().substring(0, 12));
                model.setMountPath("/ai/" + storage.getMountPath());
                set.add(model);
            }
        }
        List list = set.stream().filter(s -> this.annotationRepository.countByStorageIdAndDeleted(s.getId(), Integer.valueOf(0)) == 0).sorted((a1, a2) -> a2.getUpdatedAt().compareTo(a1.getUpdatedAt())).collect(Collectors.toList());
        res.setList(list);
        res.setBaseDir("/ai/");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=3, msgExpression="msg.create.annotation")
    @ApiOperation(value="\u521b\u5efa\u6807\u6ce8", notes="v3.5\u4fee\u6539")
    @Transactional
    @PostMapping(value={"/api/annotation"})
    public ResultResponse create(@RequestBody @Valid AnnotationRequest dto, HttpServletRequest request) throws Exception {
        Double balance;
        Organization org;
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getName());
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        Integer count = this.annotationRepository.countByNameAndDepartmentIdAndDeleted(dto.getName(), depId, Integer.valueOf(0));
        if (null != count && count > 0) {
            throw new MessageJsonException(dto.getName(), null, "msg.dep.resource.name.exist.error", new String[]{"msg.type.annotation"});
        }
        Integer count_storage = this.annotationRepository.countByStorageIdAndDeleted(dto.getStorage(), Integer.valueOf(0));
        if (count_storage > 0) {
            throw new MessageCodeException(dto.getName(), null, "msg.annotation.storage.bind", new String[]{dto.getUsername()});
        }
        PricePackage pack = this.pricePackageRepository.findByIdAndStatusAndDeleted(dto.getPack(), Integer.valueOf(1), Integer.valueOf(0));
        if (null == pack) {
            throw new MessageCodeException(dto.getName(), null, "msg.package.not.available", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        if (pack.getCost() > 0.0 && (null == (org = dep.getOrgConfig().getOrganization()).getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            throw new MessageCodeException(dto.getName(), null, "msg.org.balance.insufficient", new String[0]);
        }
        Long domain_id = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domain_id);
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(domain).department(dep).user(user).audit(Boolean.valueOf(false)).name(dto.getName()).pack(pack).replica(Integer.valueOf(1)).operate("create").build();
        this.commonService.judgeResource(identityDto);
        this.commonService.judgeSysResource(identityDto);
        String guid = UUID.randomUUID().toString().replace("-", "");
        Annotation annotation = new Annotation();
        BeanUtils.copyProperties((Object)dto, (Object)annotation);
        annotation.setDomain(domain);
        annotation.setDepartment(dep);
        annotation.setPack(pack);
        annotation.setUser(user);
        annotation.setDeleted(Integer.valueOf(0));
        annotation.setGuid(guid);
        annotation.setStatus(Integer.valueOf(0));
        Storage storage = (Storage)this.storageRepository.findOne((Serializable)dto.getStorage());
        annotation.setStorage(storage);
        annotation.setImage(FactoryCollection.harborDomain((Long)domain_id) + "/" + dto.getRepository() + ":" + dto.getTag());
        this.annotationRepository.save((Object)annotation);
        res.setGuid(guid);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domain_id);
        try {
            k8sFactory.createNamespace(guid);
            CoreV1Api coreV1Api = k8sFactory.coreV1Api;
            ArrayList<V1Volume> volumes = new ArrayList<V1Volume>(2);
            volumes.add(new V1Volume().name("timezone").hostPath(new V1HostPathVolumeSource().path("/usr/share/zoneinfo/Asia/Shanghai")));
            ArrayList<V1VolumeMount> volumeMounts = new ArrayList<V1VolumeMount>(2);
            volumeMounts.add(new V1VolumeMount().name("timezone").mountPath("/etc/localtime"));
            this.storageServiceFactory.volumeMountPrepare(storage.getType(), volumes, volumeMounts, VolumeMountDto.builder().k8sFactory(k8sFactory).namespace(guid).storage(storage.getName()).storageGuid(storage.getGuid()).mountPath("/label-studio/data").subPath("label-studio").build());
            V1ResourceRequirements resourceRequirements = new V1ResourceRequirements().putLimitsItem("cpu", new Quantity(pack.getCpuNum().toString())).putLimitsItem("memory", new Quantity(pack.getMemoryNum() + "Gi"));
            HashMap<String, String> label = new HashMap<String, String>();
            label.put("annotation", guid);
            label.put("pvc-" + storage.getGuid(), "");
            V1Service svc = new V1Service().metadata(new V1ObjectMeta().name(SERVICE_NAME)).spec(new V1ServiceSpec().type("NodePort").putSelectorItem("annotation", guid).addPortsItem(new V1ServicePort().name("web").port(Integer.valueOf(8080))));
            svc = coreV1Api.createNamespacedService(guid, svc, null, null, null);
            V1ServicePort port = (V1ServicePort)svc.getSpec().getPorts().get(0);
            annotation.setPort(port.getNodePort());
            ArrayList<V1EnvVar> envVars = new ArrayList<V1EnvVar>(4);
            envVars.add(new V1EnvVar().name("LABEL_STUDIO_USERNAME").value(annotation.getUsername()));
            envVars.add(new V1EnvVar().name("LABEL_STUDIO_PASSWORD").value(annotation.getPassword()));
            envVars.add(new V1EnvVar().name("LABEL_STUDIO_DISABLE_SIGNUP_WITHOUT_LINK").value("true"));
            envVars.add(new V1EnvVar().name("LABEL_STUDIO_HOST").value(request.getHeader("Origin") + "/k8s/" + annotation.getPort()));
            V1Deployment deployment = new V1Deployment().metadata(new V1ObjectMeta().name(DEPLOY_NAME)).spec(new V1DeploymentSpec().replicas(Integer.valueOf(1)).selector(new V1LabelSelector().putMatchLabelsItem("annotation", guid)).template(new V1PodTemplateSpec().metadata(new V1ObjectMeta().labels(label)).spec(new V1PodSpec().putNodeSelectorItem("machine", "x86").putNodeSelectorItem("schedulable", "true").addContainersItem(new V1Container().name("annotation").image(annotation.getImage()).env(envVars).resources(resourceRequirements).volumeMounts(volumeMounts)).volumes(volumes))));
            k8sFactory.appsV1Api.createNamespacedDeployment(guid, deployment, null, null, null);
        }
        catch (ApiException e) {
            annotation.setStatus(Integer.valueOf(-1));
            annotation.setErrorMessage(e.getResponseBody());
            k8sFactory.deleteNamespace(guid);
            logger.error("annotation create [" + annotation.getName() + "]" + e.getResponseBody(), (Throwable)e);
            res.setCode(Constants.SC_ERROR);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=3, msgExpression="msg.annotation.password.edit")
    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6807\u6ce8\u7ba1\u7406\u5458\u5bc6\u7801", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"/api/annotation/{id}/password"})
    public ResultResponse password(@PathVariable(value="id") Long id, @Valid @RequestBody PasswordEditRequest dto) throws Exception {
        ResultResponse res = new ResultResponse();
        Annotation annotation = (Annotation)this.annotationRepository.findOne((Serializable)id);
        annotation.setPassword(dto.getPassword());
        this.doPassword(annotation);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPassword(Annotation annotation) throws Exception {
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)annotation.getDomain().getId());
        List pods = k8sFactory.listPods(annotation.getGuid());
        if (!CollectionUtils.isEmpty((Collection)pods)) {
            Process proc = null;
            String[] cmd = new String[]{"bash", "-c", "label-studio reset_password --username " + annotation.getUsername() + " --password " + annotation.getPassword()};
            try {
                proc = new Exec(k8sFactory.client).exec((V1Pod)pods.get(0), cmd, false, false);
                proc.waitFor();
            }
            finally {
                if (null != proc) {
                    proc.destroy();
                }
            }
        }
    }

    @LogAnnotation(type=3, msgExpression="msg.annotation.name.edit")
    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6807\u6ce8\u540d\u79f0", notes="v3.5\u4fee\u6539")
    @Transactional
    @GetMapping(value={"/api/annotation/{id}/{name}"})
    public ResultResponse update(@PathVariable(value="id") Long id, @PathVariable(value="name") @ApiParam(value="\u6570\u636e\u6807\u6ce8\u65b0\u540d\u79f0") String name, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        Annotation annotation = (Annotation)this.annotationRepository.findOne((Serializable)id);
        res.setEntity(annotation.getName());
        res.setGuid(annotation.getGuid());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(annotation.getUser().getId()), (String)"annotation:name", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        Integer count = this.annotationRepository.countByNameAndDepartmentAndDeletedAndIdNot(name, annotation.getDepartment(), Integer.valueOf(0), id);
        if (null != count && count > 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.dep.resource.name.exist.error", new String[]{this.messageUtil.getMessage("msg.type.annotation")}));
            return res;
        }
        annotation.setName(name);
        return res;
    }

    @ApiOperation(value="\u6807\u6ce8\u5217\u8868", notes="v3.5\u4fee\u6539")
    @Transactional
    @RequestMapping(value={"api/annotation/list"}, method={RequestMethod.POST})
    public ListResultResponse<AnnotationModel> list(@RequestBody @Valid AnnotationSortPageRequest dto, HttpServletRequest request) throws Exception {
        PageRequest pageable;
        Integer finalLevel;
        1 spec;
        Page page;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (page = this.annotationRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */), (Pageable)(pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.DEFAULT_DIRECTION, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"})))) && page.getTotalElements() > 0L) {
            res.setSize(Long.valueOf(page.getTotalElements()));
            res.setPages(Integer.valueOf(page.getTotalPages()));
            ArrayList<AnnotationModel> entities = new ArrayList<AnnotationModel>(page.getSize());
            String origin = request.getHeader("Origin");
            for (Annotation annotation : page) {
                AnnotationModel model = new AnnotationModel();
                model.setId(annotation.getId());
                model.setName(annotation.getName());
                model.setStatus(annotation.getStatus());
                model.setCreatedAt(annotation.getCreatedAt());
                model.setImage(annotation.getImage());
                model.setAdminUsername(annotation.getUsername());
                model.setStoragePath(annotation.getStorage().getName() + ":" + "/label-studio/data");
                model.setPack((PackageInfoModel)BeanMapper.map((Object)annotation.getPack(), PackageInfoModel.class));
                model.setGuid(annotation.getGuid());
                User creator = annotation.getUser();
                model.setUserId(creator.getId());
                model.setUsername(creator.getUsername());
                model.setFullName(creator.getName());
                DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(creator, dep);
                if (resourceDepUser != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                if (null != annotation.getPort() && DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(annotation.getUser().getId()), (String)"annotation:url", (Long)depId)) {
                    model.setUrl(origin + "/k8s/" + annotation.getPort() + "/user/login");
                }
                model.setErrorMessage(annotation.getErrorMessage());
                entities.add(model);
            }
            res.setList(entities);
        }
        return res;
    }

    @LogAnnotation(type=3, msgExpression="msg.remove.annotation")
    @ApiOperation(value="\u5220\u9664\u6807\u6ce8", notes="v3.5\u4fee\u6539")
    @Transactional
    @RequestMapping(value={"/api/annotation/remove"}, method={RequestMethod.DELETE})
    public ResultResponse remove(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        List annotations = this.annotationRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        if (!annotations.isEmpty()) {
            HttpSession session = request.getSession();
            Long domainId = (Long)session.getAttribute("domain");
            Long depId = (Long)session.getAttribute("departmentId");
            Long userId = (Long)session.getAttribute("userId");
            DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
            if (annotations.stream().anyMatch(annotation -> !DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(annotation.getUser().getId()), (String)"annotation:delete", (Long)depId))) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                return res;
            }
            StringBuilder resourceNames = new StringBuilder();
            StringBuilder resourceGuids = new StringBuilder();
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            Date now = new Date();
            for (Annotation annotation2 : annotations) {
                List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(annotation2.getId(), Integer.valueOf(7));
                if (!CollectionUtils.isEmpty((Collection)materials)) {
                    for (Materials material : materials) {
                        material.setLastedAt(now);
                        material.setOperation(null);
                    }
                }
                resourceNames.append(",").append(annotation2.getName());
                resourceGuids.append(",").append(annotation2.getGuid());
                try {
                    k8sFactory.deleteNamespace(annotation2.getGuid());
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                annotation2.setStatus(Integer.valueOf(-10));
                annotation2.setDeleted(Integer.valueOf(1));
            }
            res.setEntity(resourceNames.substring(1));
            res.setGuid(resourceGuids.substring(1));
        }
        return res;
    }

    @ApiOperation(value="\u6807\u6ce8\u8be6\u60c5", notes="v3.5\u65b0\u589e")
    @Transactional(readOnly=true)
    @RequestMapping(value={"api/annotation/{id}"}, method={RequestMethod.GET})
    public AnnotationInfoResponse annotation(@PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        K8sFactory k8sFactory;
        List pods;
        AnnotationInfoResponse res = new AnnotationInfoResponse();
        Annotation annotation = (Annotation)this.annotationRepository.findOne((Serializable)id);
        BeanUtils.copyProperties((Object)annotation, (Object)res);
        res.setAdminUsername(annotation.getUsername());
        User user = annotation.getUser();
        res.setFullName(user.getName());
        res.setUsername(user.getUsername());
        res.setPack((PackageInfoModel)BeanMapper.map((Object)annotation.getPack(), PackageInfoModel.class));
        res.setStoragePath(annotation.getStorage().getName() + " : " + "/label-studio/data");
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, annotation.getDepartment());
        if (depUsers != null) {
            res.setCreatorQuited(Integer.valueOf(0));
        } else {
            res.setCreatorQuited(Integer.valueOf(1));
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        Long domainId = (Long)session.getAttribute("domain");
        if (null != annotation.getPort() && DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(annotation.getUser().getId()), (String)"annotation:url", (Long)depId)) {
            res.setUrl("k8s/" + annotation.getPort());
        }
        if (!CollectionUtils.isEmpty((Collection)(pods = (k8sFactory = FactoryCollection.k8sFactory((Long)domainId)).listPods(annotation.getGuid())))) {
            res.setMetric(k8sFactory.podCpuMemoryUsage(((V1Pod)pods.get(0)).getMetadata().getUid(), annotation.getPack().getCpuNum()));
        }
        return res;
    }

    @ApiOperation(value="\u65f6\u95f4\u6bb5\u5185\u76d1\u63a7", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/annotation/{id}/metrics"})
    public ListResultResponse<RangeMetricModel> metric(@PathVariable(value="id") Long id, @RequestBody @Valid MetricRequest dto, HttpServletRequest request) throws Exception {
        ListResultResponse res = new ListResultResponse();
        Annotation annotation = (Annotation)this.annotationRepository.findOne((Serializable)id);
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        res.setList((Collection)this.commonService.rangeMetric(domainId, annotation.getGuid(), dto.getBegin(), dto.getEnd(), annotation.getPack().getCpuNum()));
        return res;
    }

    @Transactional
    public void schedule() {
        List annotations = this.annotationRepository.findSchedule();
        if (!CollectionUtils.isEmpty((Collection)annotations)) {
            for (Annotation annotation : annotations) {
                try {
                    V1Namespace namespace;
                    boolean ready = true;
                    Date startTime = null;
                    K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)annotation.getDomain().getId());
                    List pods = k8sFactory.listPods(annotation.getGuid());
                    Date now = new Date();
                    int status = annotation.getStatus();
                    if (!CollectionUtils.isEmpty((Collection)pods)) {
                        List containerStatuses;
                        V1Pod pod = (V1Pod)pods.get(0);
                        String phase = pod.getStatus().getPhase();
                        if (!"Running".equals(phase)) {
                            List conditions;
                            ready = false;
                            if ("Pending".equals(phase) && status != -9 && null != (conditions = pod.getStatus().getConditions()) && conditions.size() > 0) {
                                for (V1PodCondition condition : conditions) {
                                    if (!"PodScheduled".equals(condition.getType()) || "True".equals(condition.getStatus())) continue;
                                    annotation.setStatus(Integer.valueOf(-9));
                                    annotation.setErrorMessage(condition.getMessage());
                                    break;
                                }
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)(containerStatuses = pod.getStatus().getContainerStatuses()))) {
                            for (Object containerStatus : containerStatuses) {
                                if (!containerStatus.getReady().booleanValue()) {
                                    V1ContainerState state;
                                    ready = false;
                                    String message = null;
                                    V1ContainerState v1ContainerState = state = containerStatus.getState() != null ? containerStatus.getState() : containerStatus.getLastState();
                                    if (state == null) break;
                                    V1ContainerStateWaiting waiting = state.getWaiting();
                                    if (waiting != null) {
                                        message = null != waiting.getMessage() ? waiting.getReason() + ":" + waiting.getMessage() : waiting.getReason();
                                    } else {
                                        V1ContainerStateTerminated terminated = state.getTerminated();
                                        if (terminated != null) {
                                            String string = message = null != terminated.getMessage() ? terminated.getReason() + ":" + terminated.getMessage() : terminated.getReason();
                                        }
                                    }
                                    if (null == message || !message.contains("CrashLoopBackOff") && !message.contains("Error") && !message.contains("ImagePullBackOff")) break;
                                    annotation.setErrorMessage(message);
                                    annotation.setStatus(Integer.valueOf(-1));
                                    break;
                                }
                                startTime = Date.from(containerStatus.getState().getRunning().getStartedAt().toInstant());
                            }
                        }
                        if (status == 1 && annotation.getStatus() == 1) continue;
                        List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(annotation.getId(), Integer.valueOf(7));
                        if (!CollectionUtils.isEmpty((Collection)materials)) {
                            Object containerStatus;
                            containerStatus = materials.iterator();
                            while (containerStatus.hasNext()) {
                                Materials material = (Materials)containerStatus.next();
                                material.setLastedAt(now);
                                material.setOperation(null);
                            }
                        }
                        if (!ready || null == startTime) continue;
                        Materials material = new Materials();
                        material.setDomain(annotation.getDomain());
                        material.setResourceId(annotation.getId());
                        material.setUser(annotation.getUser());
                        material.setOrganization(annotation.getDepartment().getOrgConfig().getOrganization());
                        material.setDepartment(annotation.getDepartment());
                        material.setType(Integer.valueOf(7));
                        material.setCostTime(startTime);
                        material.setCreatedAt(startTime);
                        material.setPack(annotation.getPack());
                        material.setPackageType(Integer.valueOf(2));
                        material.setResourceInstance(Integer.valueOf(1));
                        this.materialsRepository.save(material);
                        annotation.setStartedAt(startTime);
                        annotation.setStatus(Integer.valueOf(1));
                        annotation.setErrorMessage(null);
                        this.doPassword(annotation);
                        continue;
                    }
                    if (status != 1 || null == (namespace = k8sFactory.coreV1Api.readNamespace(annotation.getGuid(), null, null, null)) || "Terminating".equals(namespace.getStatus().getPhase())) continue;
                    annotation.setStatus(Integer.valueOf(0));
                    List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(annotation.getId(), Integer.valueOf(7));
                    if (CollectionUtils.isEmpty((Collection)materials)) continue;
                    for (Materials material : materials) {
                        material.setLastedAt(now);
                        material.setOperation(null);
                    }
                }
                catch (Exception e) {
                    logger.error("schedule:" + (e instanceof ApiException ? ((ApiException)((Object)e)).getResponseBody() : e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    @ConstructorProperties(value={"storageRepository", "systemConfigRepository", "userRepository", "orgConfigDepartmentRepository", "depUsersRepository", "annotationRepository", "domainRepository", "storageServiceFactory", "messageUtil", "pricePackageRepository", "balancesRepository", "commonService", "materialsRepository", "storageDeptRepository"})
    public AnnotationController(StorageRepository storageRepository, SystemConfigRepository systemConfigRepository, UserRepository userRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DepUsersRepository depUsersRepository, AnnotationRepository annotationRepository, DomainRepository domainRepository, StorageServiceFactory storageServiceFactory, MessageUtil messageUtil, PricePackageRepository pricePackageRepository, BalancesRepository balancesRepository, CommonService commonService, MaterialsRepository materialsRepository, StorageDeptRepository storageDeptRepository) {
        this.storageRepository = storageRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.userRepository = userRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.depUsersRepository = depUsersRepository;
        this.annotationRepository = annotationRepository;
        this.domainRepository = domainRepository;
        this.storageServiceFactory = storageServiceFactory;
        this.messageUtil = messageUtil;
        this.pricePackageRepository = pricePackageRepository;
        this.balancesRepository = balancesRepository;
        this.commonService = commonService;
        this.materialsRepository = materialsRepository;
        this.storageDeptRepository = storageDeptRepository;
    }
}

