/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.EncodeUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.common.StringUtils;
import com.mopaas.server.controller.DatasetController;
import com.mopaas.server.dao.DatasetRepository;
import com.mopaas.server.dao.DatasetVersionRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainConfigValueRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.Dataset;
import com.mopaas.server.entity.DatasetVersion;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.User;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.model.request.DataSetPathRequest;
import com.mopaas.server.model.request.DatasetCreateRequest;
import com.mopaas.server.model.request.DatasetSortPageRequest;
import com.mopaas.server.model.request.IdNameRequest;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.RemarkUpdateRequest;
import com.mopaas.server.model.response.DataSetPathResponse;
import com.mopaas.server.model.response.DatasetModel;
import com.mopaas.server.model.response.DatasetVersionModel;
import com.mopaas.server.model.response.DatasetVersionsResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.MinioToken;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.DatasetService;
import io.minio.MinioClient;
import io.minio.Result;
import io.minio.messages.Item;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u96c6\u7ba1\u7406"})
@RestController
public class DatasetController {
    final DatasetRepository datasetRepository;
    final DatasetVersionRepository datasetVersionRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DomainRepository domainRepository;
    final UserRepository userRepository;
    final StorageRepository storageRepository;
    final DomainConfigValueRepository domainConfigValueRepository;
    final DepUsersRepository depUsersRepository;
    final DatasetService datasetService;
    final MessageUtil messageUtil;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetController.class);
    private final OkHttpClient httpClient = new OkHttpClient();

    @ApiOperation(value="\u83b7\u53d6minio token", notes="v3.5\u65b0\u589e")
    @GetMapping(value={"api/minio/token"})
    public MinioToken minioToken(HttpServletRequest request) throws IOException {
        MinioToken res = new MinioToken();
        Long domainId = (Long)request.getSession().getAttribute("domain");
        JSONObject data = new JSONObject();
        data.put("id", (Object)1);
        data.put("jsonrpc", (Object)"2.0");
        data.put("method", (Object)"web.Login");
        JSONObject credential = new JSONObject();
        credential.put("username", (Object)FactoryCollection.minioAccessKey((Long)domainId));
        credential.put("password", (Object)FactoryCollection.minioSecretKey((Long)domainId));
        data.put("params", (Object)credential);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)data.toJSONString());
        Request req = new Request.Builder().addHeader("User-Agent", "Mozilla/5.0").url(FactoryCollection.minioUrl((Long)domainId) + "/minio/webrpc").post(body).build();
        Response response = this.httpClient.newCall(req).execute();
        if (response.isSuccessful()) {
            res.setToken(JSON.parseObject((String)response.body().string()).getJSONObject("result").getString("token"));
        } else {
            res.setCode(Constants.SC_ERROR);
            res.setMessage(response.message());
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6minio\u4e0a\u4f20\u8def\u5f84", notes="v3.5\u65b0\u589e")
    @PostMapping(value={"api/dataset/minio/path"})
    public DataSetPathResponse minioPath(@org.springframework.web.bind.annotation.RequestBody DataSetPathRequest dto, HttpServletRequest request) {
        DataSetPathResponse res = new DataSetPathResponse();
        Long userId = (Long)request.getSession().getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (!StringUtils.isEmpty((String)dto.getSeq())) {
            res.setSeq(dto.getSeq());
            Dataset dataset = this.datasetRepository.findBySequence(dto.getSeq());
            int v = Integer.parseInt(dataset.getCurrent().getVersion().substring(1)) + 1;
            if (v < 10) {
                res.setVersion("V00" + v);
            } else if (v < 100) {
                res.setVersion("V0" + v);
            } else {
                res.setVersion("V" + v);
            }
        } else {
            res.setVersion("V001");
            res.setSeq(UUID.randomUUID().toString().substring(24));
        }
        Long domain = (Long)request.getSession().getAttribute("domain");
        res.setPath(FactoryCollection.minioUrl((Long)domain) + "/minio/upload/" + "ai-dataset" + "/" + user.getUsername() + "/" + res.getSeq() + "/" + res.getVersion() + "/");
        return res;
    }

    @LogAnnotation(type=8, msgExpression="msg.dataset.create")
    @Transactional
    @PostMapping(value={"api/dataset"})
    @ApiOperation(value="\u521b\u5efa\u6570\u636e\u96c6\u6216\u65b0\u589e\u7248\u672c", notes="v3.5\u65b0\u589e")
    public ResultResponse create(@org.springframework.web.bind.annotation.RequestBody @Valid DatasetCreateRequest dto, HttpServletRequest request) throws Exception {
        Dataset dataset;
        Integer count;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        res.setEntity(dto.getName());
        if (dto.getId() == null && (count = this.datasetRepository.countByDepartmentIdAndName(depId, dto.getName())) > 0) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.resource.name.exist.error", new String[]{this.messageUtil.getMessage("msg.type.dataset")}));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Storage storage = null;
        String path = null;
        if (!StringUtils.isEmpty((String)dto.getStoragePath())) {
            String[] split = dto.getStoragePath().split(":");
            storage = this.storageRepository.findByIdAndDeleted(Long.valueOf(Long.parseLong(split[0])), Integer.valueOf(0));
            if (storage == null) {
                res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            path = split[1].replace("/ai/" + storage.getMountPath(), "");
            path = path.length() <= 1 ? "*" : (path.startsWith("/") ? path.substring(1) : path);
        }
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (null == dto.getId()) {
            dataset = new Dataset();
            dataset.setDeleted(Integer.valueOf(0));
            dataset.setName(dto.getName());
            dataset.setRemark(dto.getRemark());
            dataset.setDepartment(dep);
            dataset.setDomain(domain);
            dataset.setUser(user);
            dataset.setSequence(dto.getSeq());
            this.datasetRepository.save((Object)dataset);
        } else {
            dataset = (Dataset)this.datasetRepository.findOne((Serializable)dto.getId());
        }
        DatasetVersion dv = new DatasetVersion();
        BeanUtils.copyProperties((Object)dto, (Object)dv);
        dv.setId(null);
        dv.setStatus(Integer.valueOf(0));
        dv.setDeleted(Integer.valueOf(0));
        dv.setGuid(UUID.randomUUID().toString());
        dv.setDataset(dataset);
        dv.setObsPath(user.getUsername() + "/" + dataset.getSequence() + "/" + dv.getVersion() + "/");
        this.datasetVersionRepository.saveAndFlush((Object)dv);
        dataset.setCurrent(dv);
        MinioClient client = FactoryCollection.minioClient((Long)domainId);
        if (!client.bucketExists("ai-dataset")) {
            client.makeBucket("ai-dataset");
        }
        if (null != storage) {
            Storage finalStorage = storage;
            String finalPath = path;
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        }
        res.setGuid(dataset.getSequence() + dv.getVersion());
        return res;
    }

    @ApiOperation(value="\u6570\u636e\u96c6\u5217\u8868", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/dataset/list"})
    public ListResultResponse<DatasetModel> list(@org.springframework.web.bind.annotation.RequestBody DatasetSortPageRequest dto, HttpServletRequest request) throws Exception {
        Long depId;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId = (Long)session.getAttribute("departmentId"));
        int level = depUsers != null ? depUsers.getType() : 3;
        2 spec = new /* Unavailable Anonymous Inner Class!! */;
        PageRequest pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"});
        Page page = this.datasetRepository.findAll((Specification)spec, (Pageable)pageable);
        res.setPages(Integer.valueOf(page.getTotalPages()));
        res.setSize(Long.valueOf(page.getTotalElements()));
        if (page.getTotalElements() > 0L) {
            List datasets = page.getContent();
            ArrayList<DatasetModel> models = new ArrayList<DatasetModel>(datasets.size());
            for (Dataset dataset : datasets) {
                DatasetModel model = new DatasetModel();
                BeanUtils.copyProperties((Object)dataset.getCurrent(), (Object)model);
                BeanUtils.copyProperties((Object)dataset, (Object)model);
                model.setUsername(dataset.getUser().getUsername());
                model.setFullName(dataset.getUser().getName());
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @LogAnnotation(type=8, msgExpression="msg.dataset.rename")
    @ApiOperation(value="\u6570\u636e\u96c6\u91cd\u547d\u540d", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/dataset/rename"})
    public ResultResponse rename(@org.springframework.web.bind.annotation.RequestBody IdNameRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        Long depId = (Long)request.getSession().getAttribute("departmentId");
        Integer count = this.datasetRepository.countByDepartmentIdAndName(depId, dto.getName());
        if (count > 0) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.resource.name.exist.error", new String[]{this.messageUtil.getMessage("msg.type.dataset")}));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Dataset dataset = (Dataset)this.datasetRepository.findOne((Serializable)dto.getId());
        dataset.setName(dto.getName());
        res.setEntity(dataset.getName());
        res.setGuid(dataset.getSequence());
        return res;
    }

    @LogAnnotation(type=8, msgExpression="msg.datasets.remove")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u96c6", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/datasets/remove"})
    public ResultResponse remove(@org.springframework.web.bind.annotation.RequestBody IdsRequest dto, HttpServletRequest request) throws Exception {
        ResultResponse res = new ResultResponse();
        List datasets = this.datasetRepository.findByIdIn(dto.getIds());
        if (!CollectionUtils.isEmpty((Collection)datasets)) {
            StringBuilder sb = new StringBuilder();
            Long domain = (Long)request.getSession().getAttribute("domain");
            for (Dataset dataset : datasets) {
                sb.append(dataset.getName()).append("(").append(dataset.getSequence()).append(")[");
                List versions = dataset.getVersions();
                if (!CollectionUtils.isEmpty((Collection)versions)) {
                    int i = 1;
                    int t = versions.size();
                    for (DatasetVersion version : versions) {
                        FactoryCollection.minioRemoveObjects((Long)domain, (String)"ai-dataset", (String)version.getObsPath(), (String)("dataset" + version.getId() + version.getVersion()));
                        version.setDeleted(Integer.valueOf(1));
                        sb.append(version.getVersion());
                        if (i < t) {
                            sb.append(",");
                        }
                        ++i;
                    }
                }
                sb.append("]");
                dataset.setDeleted(Integer.valueOf(1));
            }
            res.setEntity(sb.toString());
        }
        return res;
    }

    @LogAnnotation(type=8, msgExpression="msg.dataset.version.remove")
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u96c6\u7248\u672c", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/dataset/version/remove"})
    public ResultResponse removeVersion(@org.springframework.web.bind.annotation.RequestBody IdsRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        List versions = this.datasetVersionRepository.findByIdIn(dto.getIds());
        if (!CollectionUtils.isEmpty((Collection)versions)) {
            StringBuilder sb = new StringBuilder();
            Long domain = (Long)request.getSession().getAttribute("domain");
            Dataset dataset = null;
            for (DatasetVersion version : versions) {
                dataset = version.getDataset();
                if (sb.length() == 0) {
                    res.setGuid(dataset.getSequence());
                    sb.append(dataset.getName()).append("(").append(dataset.getSequence()).append(")[");
                }
                FactoryCollection.minioRemoveObjects((Long)domain, (String)"ai-dataset", (String)version.getObsPath(), (String)("dataset" + version.getId() + version.getVersion()));
                version.setDeleted(Integer.valueOf(1));
                sb.append(version.getVersion()).append(",");
            }
            res.setEntity(sb.substring(0, sb.length() - 1) + "]");
            if (null != dataset) {
                DatasetVersion version = this.datasetVersionRepository.findTopByDatasetAndDeletedAndIdNotInOrderByIdDesc(dataset, Integer.valueOf(0), dto.getIds());
                if (null != version) {
                    dataset.setCurrent(version);
                } else {
                    dataset.setDeleted(Integer.valueOf(1));
                }
            }
        }
        return res;
    }

    @LogAnnotation(type=8, msgExpression="msg.update.remark")
    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u96c6\u5907\u6ce8", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"api/dataset/remark"})
    public ResultResponse remark(@org.springframework.web.bind.annotation.RequestBody RemarkUpdateRequest dto) {
        ResultResponse res = new ResultResponse();
        Dataset dataset = (Dataset)this.datasetRepository.findOne((Serializable)dto.getId());
        dataset.setRemark(dto.getRemark());
        res.setEntity(dataset.getName());
        res.setGuid(dataset.getSequence());
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u96c6\u7248\u672c\u5217\u8868", notes="v3.5\u65b0\u589e")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/dataset/{id}/versions"})
    public DatasetVersionsResponse versions(@ApiParam(value="\u6570\u636e\u96c6id") @PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        DatasetVersionsResponse res = new DatasetVersionsResponse();
        Dataset dataset = (Dataset)this.datasetRepository.findOne((Serializable)id);
        BeanUtils.copyProperties((Object)dataset, (Object)res);
        DatasetVersion current = dataset.getCurrent();
        res.setCurrent(current.getVersion());
        res.setStatus(current.getStatus());
        res.setType(current.getType());
        res.setUsername(dataset.getUser().getUsername());
        res.setFullName(dataset.getUser().getName());
        List versions = dataset.getVersions();
        ArrayList<DatasetVersionModel> models = new ArrayList<DatasetVersionModel>(versions.size());
        res.setVersions(models);
        Long domain = (Long)request.getSession().getAttribute("domain");
        MinioClient client = FactoryCollection.minioClient((Long)domain);
        for (DatasetVersion version : versions) {
            DatasetVersionModel model = new DatasetVersionModel();
            BeanUtils.copyProperties((Object)version, (Object)model);
            if (!StringUtils.isEmpty((String)version.getStoragePath())) {
                model.setImportType(Integer.valueOf(0));
            } else {
                model.setImportType(Integer.valueOf(1));
            }
            Iterable results = client.listObjects("ai-dataset", version.getObsPath());
            long size = 0L;
            for (Result result : results) {
                Item item = (Item)result.get();
                if (item.isDir()) continue;
                size += item.objectSize();
            }
            model.setUrl("api/anon/dataset/download?uid=" + EncodeUtil.encodeBase64((byte[])version.getGuid().getBytes()));
            model.setSize(SizeConverter.BTrim.convert((float)size));
            models.add(model);
        }
        return res;
    }

    @ApiOperation(value="\u6570\u636e\u96c6\u4e0b\u8f7d")
    @Transactional(readOnly=true)
    @GetMapping(value={"/api/anon/dataset/download"})
    public ResultResponse download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultResponse res = new ResultResponse();
        String uid = request.getParameter("uid");
        if (StringUtils.isEmpty((String)uid)) {
            res.setCode(Constants.SC_ERROR);
            res.setMessage("uid is missing");
            return res;
        }
        DatasetVersion version = this.datasetVersionRepository.findByGuid(new String(EncodeUtil.decodeBase64((CharSequence)uid)));
        Long domainId = (Long)request.getSession().getAttribute("domain");
        FactoryCollection.download((HttpServletResponse)response, (Long)domainId, (String)"ai-dataset", (String)version.getObsPath());
        return res;
    }

    @Transactional
    public void scheduler() {
        List versions = this.datasetVersionRepository.findSchedule();
        if (!CollectionUtils.isEmpty((Collection)versions)) {
            Long domainId = null;
            MinioClient client = null;
            for (DatasetVersion version : versions) {
                Dataset dataset = version.getDataset();
                try {
                    Iterable results;
                    if (null == client || !dataset.getDomain().getId().equals(domainId)) {
                        domainId = dataset.getDomain().getId();
                        client = FactoryCollection.minioClient((Long)domainId);
                    }
                    if ((results = client.listIncompleteUploads("ai-dataset", dataset.getUser().getUsername() + "/" + dataset.getSequence() + "/" + version.getVersion(), true)).iterator().hasNext()) continue;
                    version.setStatus(Integer.valueOf(1));
                }
                catch (Exception e) {
                    LOGGER.info("scheduler:" + e.getMessage());
                }
            }
        }
    }

    @ConstructorProperties(value={"datasetRepository", "datasetVersionRepository", "orgConfigDepartmentRepository", "domainRepository", "userRepository", "storageRepository", "domainConfigValueRepository", "depUsersRepository", "datasetService", "messageUtil"})
    public DatasetController(DatasetRepository datasetRepository, DatasetVersionRepository datasetVersionRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DomainRepository domainRepository, UserRepository userRepository, StorageRepository storageRepository, DomainConfigValueRepository domainConfigValueRepository, DepUsersRepository depUsersRepository, DatasetService datasetService, MessageUtil messageUtil) {
        this.datasetRepository = datasetRepository;
        this.datasetVersionRepository = datasetVersionRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.domainRepository = domainRepository;
        this.userRepository = userRepository;
        this.storageRepository = storageRepository;
        this.domainConfigValueRepository = domainConfigValueRepository;
        this.depUsersRepository = depUsersRepository;
        this.datasetService = datasetService;
        this.messageUtil = messageUtil;
    }
}

