/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.RandomUtil;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.common.StringUtils;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.controller.AccountController;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.dao.AccountInviteRepository;
import com.mopaas.server.dao.AccountNoticePushRepository;
import com.mopaas.server.dao.AccountUserRegisterRepository;
import com.mopaas.server.dao.AnnotationRepository;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepPermissionRepository;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUserQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.ExperimentRepository;
import com.mopaas.server.dao.HarborProjectRepository;
import com.mopaas.server.dao.JobParamsRepository;
import com.mopaas.server.dao.JobRepository;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.ModelRepository;
import com.mopaas.server.dao.ModelVersionRepository;
import com.mopaas.server.dao.OperationLogRepository;
import com.mopaas.server.dao.OrgConfigDepPackageRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrgConfigRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.OrganizationRepository;
import com.mopaas.server.dao.PaymentRepository;
import com.mopaas.server.dao.PermissionRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.PriceRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.ReferTrialDurationRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.ServiceRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.AccountInvite;
import com.mopaas.server.entity.AccountUserRegister;
import com.mopaas.server.entity.Annotation;
import com.mopaas.server.entity.Balance;
import com.mopaas.server.entity.BaseEntity;
import com.mopaas.server.entity.DepPermission;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUserQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.Experiment;
import com.mopaas.server.entity.Job;
import com.mopaas.server.entity.JobVersion;
import com.mopaas.server.entity.MLabProject;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.OperationLog;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepPackage;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.Payment;
import com.mopaas.server.entity.Permission;
import com.mopaas.server.entity.Price;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.ReferDuration;
import com.mopaas.server.entity.ReferTrialDuration;
import com.mopaas.server.entity.Resource;
import com.mopaas.server.entity.ResourceExpansion;
import com.mopaas.server.entity.Service;
import com.mopaas.server.entity.ServiceDeployRecord;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.User;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.model.request.AllotDepPermissionRequest;
import com.mopaas.server.model.request.CreateDepRequest;
import com.mopaas.server.model.request.CreateDepRoleRequest;
import com.mopaas.server.model.request.DateRequest;
import com.mopaas.server.model.request.DepAllocationCountRequest;
import com.mopaas.server.model.request.DepAllocationQuotaRequest;
import com.mopaas.server.model.request.DepAllocationRequest;
import com.mopaas.server.model.request.DepAllocationTimeRequest;
import com.mopaas.server.model.request.DepAllocationUserStorageRequest;
import com.mopaas.server.model.request.DepBaseRequest;
import com.mopaas.server.model.request.DepResourceInfoRequest;
import com.mopaas.server.model.request.DepStorageInfoRequest;
import com.mopaas.server.model.request.DomainDepRequest;
import com.mopaas.server.model.request.InviteMemberRequest;
import com.mopaas.server.model.request.JoinDepRequest;
import com.mopaas.server.model.request.MemberChangeRequest;
import com.mopaas.server.model.request.OrgInfoRequest;
import com.mopaas.server.model.request.RoleSelectRequest;
import com.mopaas.server.model.request.SearchDepRequest;
import com.mopaas.server.model.request.SearchRequest;
import com.mopaas.server.model.response.AccountUserModel;
import com.mopaas.server.model.response.DepAllocationResponse;
import com.mopaas.server.model.response.DepInfoResponse;
import com.mopaas.server.model.response.DepJoinResponse;
import com.mopaas.server.model.response.DepMemberModel;
import com.mopaas.server.model.response.DepOverviewAllocationModel;
import com.mopaas.server.model.response.DepOverviewQuotasModel;
import com.mopaas.server.model.response.DepOverviewResponse;
import com.mopaas.server.model.response.DepResourceCountModel;
import com.mopaas.server.model.response.DepUserQuotasModel;
import com.mopaas.server.model.response.DepartmentModel;
import com.mopaas.server.model.response.InviteInfoResponse;
import com.mopaas.server.model.response.InviteResponse;
import com.mopaas.server.model.response.JobModel;
import com.mopaas.server.model.response.ListPaymentResultResponse;
import com.mopaas.server.model.response.ListResourceResultResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.OrgInfoResponse;
import com.mopaas.server.model.response.OverviewPaymentModel;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.PackageModel;
import com.mopaas.server.model.response.PermissionModel;
import com.mopaas.server.model.response.ResourceModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.StateResponse;
import com.mopaas.server.model.response.StorageUsageModel;
import com.mopaas.server.service.AccountService;
import com.mopaas.server.service.NoticeUserService;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.crypto.hash.Sha1Hash;
import org.apache.shiro.subject.Subject;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.RequestContext;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(tags={"\u56e2\u961f\u76f8\u5173"})
@RestController
public class DepartmentController {
    final UserRepository userRepository;
    final AccountInviteRepository accountInviteRepository;
    final AccountUserRegisterRepository accountUserRegisterRepository;
    final DepUsersRepository depUsersRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final OrgConfigRepository orgConfigRepository;
    final ResourceRepository resourceRepository;
    final JobRepository jobRepository;
    final ServiceRepository serviceRepository;
    final StorageRepository storageRepository;
    final MaterialsRepository materialsRepository;
    final PaymentRepository paymentRepository;
    final PermissionRepository permissionRepository;
    final DepPermissionRepository depPermissionRepository;
    final AccountController accountController;
    final OrgConfigDepPackageRepository orgConfigDepPackageRepository;
    final PricePackageRepository pricePackageRepository;
    final NoticeUserService noticeUserService;
    final AccountNoticePushRepository accountNoticePushRepository;
    final OrganizationRepository organizationRepository;
    final HarborProjectRepository harborProjectRepository;
    final BalancesRepository balancesRepository;
    final AnnotationRepository annotationRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final DomainRepository domainRepository;
    final DepQuotasRepository depQuotasRepository;
    final ReferDurationRepository referDurationRepository;
    final JobVersionRepository jobVersionRepository;
    final JobParamsRepository jobParamsRepository;
    final ModelRepository modelRepository;
    final ModelVersionRepository modelVersionRepository;
    final Scheduler scheduler;
    final PriceRepository priceRepository;
    final DepUserQuotasRepository depUserQuotasRepository;
    final OrganizationQuotasRepository quotasRepository;
    final OperationLogRepository operationLogRepository;
    final MessageSource messageSource;
    final ExperimentRepository experimentRepository;
    final ReferTrialDurationRepository referTrialDurationRepository;
    final AccountService accountService;
    final MessageUtil messageUtil;
    final StorageServiceFactory storageServiceFactory;
    private static final String TEL_REGEX = "^1\\d{10}$";
    private static final String USERNAME_REGEX = "^[a-zA-Z0-9][a-zA-Z0-9_]{0,19}(?<!_)$";
    private static final String DEPLOY_NAME = "deploy-resource";
    private static final String DEPLOY_WORKER = "deploy-worker";
    private static final String EXPERIMENT = "exp";
    private static final Logger logger = LoggerFactory.getLogger(DepartmentController.class);

    @ApiOperation(value="\u8fdb\u5165\u56e2\u961f")
    @Transactional
    @RequestMapping(value={"/api/account/dep/choose/{id}"}, method={RequestMethod.GET})
    public DepJoinResponse chooseDep(@ApiParam(value="\u56e2\u961fid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        DepJoinResponse res = new DepJoinResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)id);
        if (department == null || department.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.account.group.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (department.getStatus() != null && department.getStatus() == 0) {
            res.setMessage(this.messageUtil.getMessage("msg.account.group.forbidden"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!user.getDepartments().contains(department)) {
            return res;
        }
        ArrayList<Object> userPermissions = user.getPermissions();
        if (CollectionUtils.isEmpty((Collection)userPermissions) || userPermissions.stream().noneMatch(p -> p.getId() == 1L)) {
            userPermissions = new ArrayList<Object>(1);
            userPermissions.add(this.permissionRepository.findOne((Serializable)Long.valueOf(1L)));
            user.setPermissions(userPermissions);
        }
        List defaultPermissions = this.permissionRepository.findByState(Integer.valueOf(1));
        department.setPermissions(defaultPermissions);
        List dus = this.depUsersRepository.findByUser(user);
        JSONArray depPermissions = new JSONArray();
        if (dus != null && dus.size() > 0) {
            for (DepUsers d : dus) {
                Object depUsers;
                OrgConfigDepartment dep = d.getDepartment();
                if (dep.getDeleted() == 1 || dep.getStatus() != null && dep.getStatus() == 0 || (depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep)) != null && depUsers.getState() != null && depUsers.getState() == -1 || dep.getOrgConfig().getLevel() != 1) continue;
                ArrayList<String> pList = new ArrayList<String>();
                Integer[] type = new Integer[]{0, 1, 2};
                List permissionByTypeIn = this.permissionRepository.findPermissionByTypeIn(type);
                List permissions = dep.getPermissions();
                Integer level = this.getDepUserLevel(user, dep);
                if (level == 1) {
                    permissions = this.permissionRepository.findAll();
                    for (Permission p2 : permissions) {
                        if (!p2.getPermission().startsWith("member:") && permissionByTypeIn.contains(p2.getPermission())) {
                            pList.add(p2.getPermission());
                        }
                        if (!p2.getPermission().startsWith("member:storage:") || !permissionByTypeIn.contains(p2.getPermission())) continue;
                        pList.add(p2.getPermission().replace("member:", ""));
                    }
                } else if (level == 2) {
                    for (Permission p2 : permissions) {
                        if (!p2.getPermission().startsWith("member:") && permissionByTypeIn.contains(p2.getPermission())) {
                            pList.add(p2.getPermission());
                        }
                        if (!p2.getPermission().startsWith("member:storage:") || !permissionByTypeIn.contains(p2.getPermission())) continue;
                        pList.add(p2.getPermission().replace("member:", ""));
                    }
                } else {
                    for (Permission p2 : permissions) {
                        if (!p2.getPermission().startsWith("member:") || !permissionByTypeIn.contains(p2.getPermission())) continue;
                        pList.add(p2.getPermission());
                    }
                }
                JSONObject dp = new JSONObject();
                dp.put((Object)"depId", (Object)dep.getId());
                dp.put((Object)"level", (Object)level);
                dp.put((Object)"permissions", pList);
                depPermissions.add((Object)dp);
            }
        }
        res.setDepPermissions(depPermissions);
        Integer level = this.getDepUserLevel(user, department);
        res.setId(department.getId());
        res.setDepName(department.getName());
        res.setDescription(department.getDescription());
        res.setLevel(level);
        Organization organization = department.getOrgConfig().getOrganization();
        List orgConfigs = organization.getOrgConfigs();
        for (OrgConfig configs : orgConfigs) {
            switch (configs.getLevel()) {
                case 1: {
                    res.setDepartment(configs.getName());
                    break;
                }
                case 2: {
                    res.setDepartmentManager(configs.getName());
                    break;
                }
                case 3: {
                    res.setDepartmentMember(configs.getName());
                }
            }
        }
        res.setFree(organization.getFree());
        List balanceList = this.balancesRepository.findByOrganizationAndStatus(organization, 0);
        Double money = 0.0;
        for (Balance b : balanceList) {
            money = money + b.getMoney();
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        money = Double.valueOf(df.format(money));
        res.setBalance(money);
        res.setOrgStatus(organization.getStatus());
        session.setAttribute("departmentId", (Object)id);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5168\u5e73\u53f0\u641c\u7d22\u6210\u5458")
    @Transactional
    @RequestMapping(value={"/api/account/user/all"}, method={RequestMethod.POST})
    public ListResultResponse<AccountUserModel> getAllGroups(@Valid @RequestBody SearchRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getDepId());
        ArrayList<AccountUserModel> userResponseDtos = new ArrayList<AccountUserModel>();
        if (dto.getSearch() == null || dto.getSearch().isEmpty()) {
            res.setCode(Constants.SC_OK);
            return res;
        }
        Specification specification = (root, query, cb) -> {
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.or((Expression)cb.equal((Expression)root.get("name"), (Object)dto.getSearch().trim()), (Expression)cb.equal((Expression)root.get("username"), (Object)dto.getSearch().trim())));
            lstPredicates.add(cb.equal((Expression)root.get("deleted"), (Object)0));
            lstPredicates.add(cb.equal((Expression)root.get("state"), (Object)1));
            lstPredicates.add(cb.equal((Expression)root.get("status"), (Object)1));
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        };
        List users = this.userRepository.findAll(specification);
        Specification spec = (root, query, cb) -> {
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
            if (!StringUtils.isEmpty((String)dto.getSearch())) {
                predicateList.add(cb.like((Expression)root.get("name"), "%" + dto.getSearch().trim() + "%"));
                predicateList.add(cb.like((Expression)root.get("username"), "%" + dto.getSearch().trim() + "%"));
                Predicate[] p = new Predicate[predicateList.size()];
                predicateList.toArray(p);
                lstPredicates.add(cb.or(p));
            }
            lstPredicates.add(cb.equal((Expression)root.get("deleted"), (Object)0));
            lstPredicates.add(cb.equal((Expression)root.get("state"), (Object)1));
            lstPredicates.add(cb.equal((Expression)root.get("status"), (Object)1));
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        };
        List userList = this.userRepository.findAll(spec);
        if (userList != null) {
            for (User u : userList) {
                if (users.contains(u)) continue;
                users.add(u);
            }
        }
        if (users != null && users.size() > 0) {
            for (User u : users) {
                AccountUserModel ur = new AccountUserModel();
                ur.setId(u.getId());
                ur.setUsername(u.getUsername());
                ur.setName(u.getName() == null ? u.getUsername() : u.getName());
                ur.setState(u.getState());
                List accountNoticePushes = this.accountNoticePushRepository.idInvited(u.getId(), dto.getDepId(), user.getUsername());
                if (accountNoticePushes != null && accountNoticePushes.size() > 0) {
                    ur.setStatue(Integer.valueOf(1));
                } else {
                    ur.setStatue(Integer.valueOf(0));
                }
                DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(u, dep);
                if (depUsers != null) {
                    ur.setIndep(Integer.valueOf(1));
                    ur.setLevel(depUsers.getType());
                }
                userResponseDtos.add(ur);
            }
        }
        res.setSize(Long.valueOf(userResponseDtos.size()));
        res.setList(userResponseDtos);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u624b\u52a8\u6dfb\u52a0\u6210\u5458")
    @Transactional
    @RequestMapping(value={"/api/dep/member/create"}, method={RequestMethod.POST})
    public ResultResponse createRole(@Valid @RequestBody CreateDepRoleRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getDepId());
        Boolean permission = DepartmentController.isDepPermission((String)"consumer:create", (Long)dto.getDepId());
        if (!permission.booleanValue()) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (StringUtils.isEmpty((String)dto.getUsername())) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.empty"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (StringUtils.isEmpty((String)dto.getName())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.name.empty"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (StringUtils.isEmpty((String)dto.getPassword())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.role.password.empty"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String username = dto.getUsername().trim();
        if (!username.matches("^[a-zA-Z0-9][a-zA-Z0-9_]{0,19}(?<!_)$")) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (dto.getName().trim().length() > 20) {
            res.setMessage(this.messageUtil.getMessage("msg.user.name.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User newUser = this.userRepository.findByPhone(dto.getUsername());
        if (newUser != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.available"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        newUser = this.userRepository.findByEmail(dto.getUsername());
        if (newUser != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.available"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        newUser = this.userRepository.findByUsername(dto.getUsername());
        if (newUser != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (dto.getPassword() == null) {
            res.setMessage(this.messageUtil.getMessage("msg.password.is.not.correct"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String phone = dto.getPhone();
        User user = null;
        if (phone != null && !phone.isEmpty() && phone.matches("^1\\d{10}$")) {
            user = this.userRepository.findByPhone(phone);
        }
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.phone.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Date now = new Date();
        newUser = new User();
        newUser.setGuid(UUID.randomUUID().toString().replace("-", ""));
        newUser.setDeleted(Integer.valueOf(0));
        newUser.setUsername(username);
        newUser.setName(dto.getName().trim());
        newUser.setPassword(new Sha1Hash((Object)dto.getPassword()).toBase64());
        newUser.setPhone(dto.getPhone());
        newUser.setStatus(Integer.valueOf(1));
        newUser.setState(Integer.valueOf(1));
        newUser.setCreatedAt(now);
        newUser.setLevel(Integer.valueOf(3));
        this.userRepository.save((Object)newUser);
        AccountUserRegister userRegister = new AccountUserRegister();
        userRegister.setUser(newUser);
        userRegister.setDep(dep);
        userRegister.setType(Integer.valueOf(3));
        userRegister.setCreatedAt(now);
        this.accountUserRegisterRepository.save((Object)userRegister);
        Organization org = this.accountService.createOrg(newUser);
        org.setSource(Integer.valueOf(3));
        org.setStatus(Integer.valueOf(0));
        Balance balance = this.balancesRepository.findByOrganizationAndTypeAndStatus(org, 0, 0);
        if (balance == null) {
            balance = new Balance();
            balance.setOrganization(org);
            balance.setStatus(Integer.valueOf(0));
            balance.setType(Integer.valueOf(0));
            balance.setMoney(Double.valueOf(0.0));
        }
        if ((balance = this.balancesRepository.findByOrganizationAndTypeAndStatus(org, 1, 0)) == null) {
            balance = new Balance();
            balance.setOrganization(org);
            balance.setStatus(Integer.valueOf(0));
            balance.setType(Integer.valueOf(1));
            balance.setMoney(Double.valueOf(0.0));
        }
        DepUsers depUsers = new DepUsers();
        depUsers.setUser(newUser);
        depUsers.setDepartment(dep);
        depUsers.setState(Integer.valueOf(1));
        depUsers.setType(Integer.valueOf(3));
        depUsers.setCreatedAt(now);
        this.depUsersRepository.save((Object)depUsers);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u9080\u8bf7\u94fe\u63a5")
    @Transactional
    @RequestMapping(value={"/api/invite/code/{id}"}, method={RequestMethod.GET})
    public InviteResponse inviteGet(@ApiParam(value="\u56e2\u961fid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        String inviteCode;
        InviteResponse res = new InviteResponse();
        Long userId = (Long)request.getSession().getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)id);
        AccountInvite accountInvite = this.accountInviteRepository.findTopByOrgConfigDepartmentAndUser(dep, user);
        if (accountInvite == null) {
            accountInvite = new AccountInvite();
            accountInvite.setOrgConfigDepartment(dep);
            accountInvite.setUser(user);
            accountInvite.setCreatedAt(new Date());
            inviteCode = RandomUtil.random((int)12);
            accountInvite.setInviteCode(inviteCode);
            this.accountInviteRepository.save((Object)accountInvite);
        } else {
            inviteCode = accountInvite.getInviteCode();
        }
        res.setInviteCode(inviteCode);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u91cd\u7f6e\u9080\u8bf7\u94fe\u63a5")
    @Transactional
    @RequestMapping(value={"/api/invite/code/reset/{id}"}, method={RequestMethod.PUT})
    public InviteResponse resetInvite(@ApiParam(value="\u56e2\u961fid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        InviteResponse res = new InviteResponse();
        Long userId = (Long)request.getSession().getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)id);
        AccountInvite accountInvite = this.accountInviteRepository.findTopByOrgConfigDepartmentAndUser(dep, user);
        if (accountInvite == null) {
            accountInvite = new AccountInvite();
            accountInvite.setOrgConfigDepartment(dep);
            accountInvite.setUser(user);
            accountInvite.setCreatedAt(new Date());
        }
        String inviteCode = RandomUtil.random((int)12);
        accountInvite.setInviteCode(inviteCode);
        accountInvite.setUpdatedAt(new Date());
        this.accountInviteRepository.save((Object)accountInvite);
        res.setInviteCode(inviteCode);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u9080\u8bf7\u4fe1\u606f", notes="v3.3\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570department")
    @Transactional
    @RequestMapping(value={"/api/anon/invite/code/info/{code}"}, method={RequestMethod.GET})
    public InviteInfoResponse inviteInfo(@ApiParam(value="\u9080\u8bf7\u7801") @PathVariable(value="code") String code) {
        InviteInfoResponse res = new InviteInfoResponse();
        res.setCode(Constants.SC_ERROR);
        AccountInvite accountInvite = this.accountInviteRepository.findTopByInviteCode(code);
        if (accountInvite != null) {
            OrgConfigDepartment department = accountInvite.getOrgConfigDepartment();
            if (department == null) {
                return res;
            }
            User user = accountInvite.getUser();
            res.setUsername(user.getUsername());
            res.setName(user.getName() == null ? user.getUsername() : user.getName());
            res.setDepName(department.getName());
            Organization organization = department.getOrgConfig().getOrganization();
            List orgConfigs = organization.getOrgConfigs();
            for (OrgConfig configs : orgConfigs) {
                if (configs.getLevel() != 1) continue;
                res.setDepartment(configs.getName());
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u901a\u8fc7\u9080\u8bf7\u94fe\u63a5\u52a0\u5165\u56e2\u961f")
    @Transactional
    @RequestMapping(value={"/api/anon/invite/code/join"}, method={RequestMethod.POST})
    public StateResponse resetInvite(@Valid @RequestBody JoinDepRequest dto) {
        StateResponse res = new StateResponse();
        User user = (User)this.userRepository.findOne((Serializable)dto.getUserId());
        AccountInvite accountInvite = this.accountInviteRepository.findTopByInviteCode(dto.getInviteCode());
        if (accountInvite == null) {
            res.setState(Integer.valueOf(0));
            res.setCode(Constants.SC_OK);
            return res;
        }
        OrgConfigDepartment department = accountInvite.getOrgConfigDepartment();
        List users = department.getUsers();
        List byDepAndUsers = this.depUsersRepository.findByDepartmentAndUser(department, user);
        if (byDepAndUsers != null && byDepAndUsers.size() > 0) {
            res.setDepId(department.getId());
            res.setState(Integer.valueOf(2));
            for (int i = byDepAndUsers.size() - 1; i > 0; --i) {
                this.depUsersRepository.delete(byDepAndUsers.get(i));
            }
        } else {
            DepUsers depUsers = new DepUsers();
            depUsers.setUser(user);
            depUsers.setDepartment(department);
            depUsers.setType(Integer.valueOf(3));
            depUsers.setCreatedAt(new Date());
            depUsers.setState(Integer.valueOf(1));
            this.depUsersRepository.save((Object)depUsers);
            AccountUserRegister userRegister = this.accountUserRegisterRepository.findByUser(user);
            if (userRegister != null && userRegister.getType() != null && userRegister.getType() == 2) {
                userRegister.setInviter(accountInvite.getUser());
                userRegister.setDep(department);
            }
            for (User u : users) {
                if (u.getDeleted() == 1 || u.getState() != 1) continue;
                this.noticeUserService.sendMemberChange(Integer.valueOf(0), user.getName(), u, department);
            }
            res.setDepId(department.getId());
            res.setState(Integer.valueOf(1));
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u641c\u7d22\u6dfb\u52a0\u9080\u8bf7\u6210\u5458")
    @Transactional
    @RequestMapping(value={"/api/anon/invite/member"}, method={RequestMethod.POST})
    public ResultResponse inviteMember(@Valid @RequestBody InviteMemberRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long adminId = (Long)session.getAttribute("userId");
        if (adminId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User admin = (User)this.userRepository.findOne((Serializable)adminId);
        Long depId = dto.getDepId();
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Boolean permission = DepartmentController.isDepPermission((String)"consumer:create", (Long)depId);
        if (!permission.booleanValue()) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)dto.getUserId());
        this.noticeUserService.sendInvite(user, dep, admin, dto.getLinkurl());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6211\u7684\u56e2\u961f", notes="v3.3\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570orgName")
    @Transactional
    @RequestMapping(value={"/api/dep/mine"}, method={RequestMethod.GET})
    public ListResultResponse<DepartmentModel> userDepGet(HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        List dus = this.depUsersRepository.findByUser(user);
        ArrayList<DepartmentModel> departmentModels = new ArrayList<DepartmentModel>();
        if (dus != null && dus.size() > 0) {
            for (DepUsers d : dus) {
                DepUsers depUsers;
                OrgConfigDepartment dep = d.getDepartment();
                Organization organization = dep.getOrgConfig().getOrganization();
                if (organization.getStatus() != null && organization.getStatus() == 0 || dep.getDeleted() == 1 || dep.getStatus() != null && dep.getStatus() == 0 || (depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep)) != null && depUsers.getState() != null && depUsers.getState() == -1 || dep.getOrgConfig().getLevel() != 1) continue;
                DepartmentModel departmentModel = new DepartmentModel();
                departmentModel.setId(dep.getId());
                departmentModel.setDepName(dep.getName());
                departmentModel.setDescription(dep.getDescription());
                departmentModel.setGuid(dep.getGuid().substring(0, 12));
                DepUsers depUsersAdmin = this.depUsersRepository.findTopByDepartmentAndType(dep, Integer.valueOf(1));
                if (depUsersAdmin != null) {
                    User depAdmin = depUsersAdmin.getUser();
                    departmentModel.setUserId(depAdmin.getId());
                    departmentModel.setUsername(depAdmin.getUsername());
                    departmentModel.setName(depAdmin.getName() == null ? depAdmin.getUsername() : depAdmin.getName());
                }
                Integer consumersNum = this.depUsersRepository.countByDepartmentAndUserStatusAndUserStateAndUserDeleted(dep, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0));
                departmentModel.setMemberNum(consumersNum);
                departmentModel.setCreatedAt(dep.getCreatedAt());
                Date joinAt = depUsers.getCreatedAt();
                if (joinAt == null && depUsers.getType() == 1) {
                    joinAt = dep.getCreatedAt();
                }
                departmentModel.setJoinAt(joinAt);
                List orgConfigs = organization.getOrgConfigs();
                for (OrgConfig configs : orgConfigs) {
                    switch (configs.getLevel()) {
                        case 1: {
                            departmentModel.setDepartment(configs.getName());
                            break;
                        }
                        case 2: {
                            departmentModel.setDepartmentManager(configs.getName());
                            break;
                        }
                        case 3: {
                            departmentModel.setDepartmentMember(configs.getName());
                        }
                    }
                }
                departmentModel.setOrgName(organization.getName());
                departmentModels.add(departmentModel);
            }
        }
        departmentModels.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        Integer count = this.orgConfigDepartmentRepository.countByOrgConfigLevelAndDeleted(Integer.valueOf(1), Integer.valueOf(0));
        res.setSize(Long.valueOf(count.intValue()));
        res.setList(departmentModels);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6211\u7684\u56e2\u961f-\u8d85\u7ea7\u7ba1\u7406\u5458")
    @Transactional
    @RequestMapping(value={"/api/dep/mine/admins"}, method={RequestMethod.GET})
    public ListResultResponse<DepMemberModel> userDepAdminGet(HttpServletRequest request) {
        List admins;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        List dus = this.depUsersRepository.findByUser(user);
        ArrayList<DepMemberModel> departmentModels = new ArrayList<DepMemberModel>();
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        if (dus != null && dus.size() > 0) {
            for (DepUsers d : dus) {
                DepUsers depUsersAdmin;
                DepUsers depUsers;
                OrgConfigDepartment dep = d.getDepartment();
                if (dep.getDeleted() == 1 || dep.getStatus() != null && dep.getStatus() == 0 || (depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep)) != null && depUsers.getState() != null && depUsers.getState() == -1 || dep.getOrgConfig().getLevel() != 1 || (depUsersAdmin = this.depUsersRepository.findTopByDepartmentAndType(dep, Integer.valueOf(1))) == null) continue;
                User depAdmin = depUsersAdmin.getUser();
                ids.add(depAdmin.getId());
            }
        }
        if ((admins = this.userRepository.findByIdInAndDeleted(ids, 0)) != null && admins.size() > 0) {
            for (User member : admins) {
                DepMemberModel depMemberModel = new DepMemberModel();
                depMemberModel.setUserId(member.getId());
                depMemberModel.setUsername(member.getUsername());
                depMemberModel.setName(member.getName() == null ? member.getUsername() : member.getName());
                departmentModels.add(depMemberModel);
            }
        }
        res.setList(departmentModels);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u65b0\u5efa\u56e2\u961f")
    @Transactional
    @RequestMapping(value={"/api/dep/create"}, method={RequestMethod.POST})
    public ResultResponse createGroup(@Valid @RequestBody CreateDepRequest dto, HttpServletRequest request) {
        String domainId;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        String string = domainId = request.getHeader("domain") == null ? String.valueOf(session.getAttribute("domain")) : request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        res.setCode(Constants.SC_ERROR);
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Organization organization = user.getOrganization();
        if (organization == null) {
            organization = this.accountService.createOrg(user);
        }
        if (organization.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.org.is.deleted"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (organization.getStatus() != null && organization.getStatus() == 0) {
            res.setMessage(this.messageUtil.getMessage("msg.org.is.forbidden"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment department = new OrgConfigDepartment();
        department.setGuid(UUID.randomUUID().toString().replace("-", ""));
        department.setName(dto.getName());
        department.setDescription(dto.getDescription());
        OrgConfig orgConfig = this.orgConfigRepository.findByOrganizationAndLevel(organization, 1);
        department.setOrgConfig(orgConfig);
        department.setCreator(user.getUsername());
        department.setCreatedAt(new Date());
        department.setDeleted(Integer.valueOf(0));
        department.setStatus(Integer.valueOf(1));
        this.orgConfigDepartmentRepository.save((Object)department);
        DepUsers depUsers = new DepUsers();
        depUsers.setUser(user);
        depUsers.setDepartment(department);
        depUsers.setType(Integer.valueOf(1));
        depUsers.setCreatedAt(new Date());
        depUsers.setState(Integer.valueOf(1));
        this.depUsersRepository.save((Object)depUsers);
        ArrayList depPackages = new ArrayList();
        List allResources = organization.getResourcePricePackage();
        List allK8sJobs = organization.getJobPricePackage();
        List allServices = organization.getModelPricePackage();
        List allAnnotations = organization.getAnnotationPackage();
        depPackages.addAll(allResources);
        depPackages.addAll(allK8sJobs);
        depPackages.addAll(allServices);
        depPackages.addAll(allAnnotations);
        List domainList = this.domainRepository.findByDeletedAndStatus(Integer.valueOf(0), Integer.valueOf(1));
        if (domainList != null && domainList.size() > 0) {
            for (Domain d : domainList) {
                Integer orgHarborStorage;
                Integer orgCapacity;
                for (PricePackage pricePackage : depPackages) {
                    if (pricePackage.getDomain() == null || !pricePackage.getDomain().getId().equals(d.getId()) || pricePackage.getDeleted() == 1 || pricePackage.getStatus() != 1) continue;
                    OrgConfigDepPackage depPackage = new OrgConfigDepPackage();
                    depPackage.setDepartment(department);
                    depPackage.setPricePackage(pricePackage);
                    depPackage.setDomain(d);
                    this.orgConfigDepPackageRepository.save((Object)depPackage);
                }
                DepQuotas depQuotas = new DepQuotas();
                OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(organization, d.getId());
                if (null == orgQuotas) {
                    orgCapacity = -1;
                    orgHarborStorage = -1;
                } else {
                    orgCapacity = orgQuotas.getStorage() != null ? orgQuotas.getStorage() : -1;
                    orgHarborStorage = orgQuotas.getHarborStorage() != null ? orgQuotas.getHarborStorage() : -1;
                }
                Integer allocated = this.depQuotasRepository.sumOrgAllocated(organization, d.getId());
                if (null == allocated) {
                    allocated = 0;
                }
                int capacity = orgCapacity == -1 ? -1 : Math.max(orgCapacity - allocated, 0);
                Integer allocatedHarbor = this.depQuotasRepository.sumOrgharborStorageAllocated(organization, d.getId());
                if (null == allocatedHarbor) {
                    allocatedHarbor = 0;
                }
                int harborStorage = orgHarborStorage == -1 ? -1 : (orgHarborStorage - allocatedHarbor > 0 ? orgHarborStorage - allocatedHarbor : 0);
                depQuotas.setStorage(Integer.valueOf(capacity));
                depQuotas.setHarborStorage(Integer.valueOf(harborStorage));
                depQuotas.setUserStorage(Integer.valueOf(-1));
                depQuotas.setOrganization(organization);
                depQuotas.setDepartment(department);
                depQuotas.setDomain(d);
                depQuotas.setResourceCount(Integer.valueOf(-1));
                depQuotas.setJobCount(Integer.valueOf(-1));
                depQuotas.setModelCount(Integer.valueOf(-1));
                depQuotas.setResourceTime(Double.valueOf(-1.0));
                depQuotas.setJobTime(Double.valueOf(-1.0));
                depQuotas.setModelTime(Double.valueOf(-1.0));
                depQuotas.setAutomlCount(Integer.valueOf(-1));
                depQuotas.setAutomlTime(Double.valueOf(-1.0));
                this.depQuotasRepository.save((Object)depQuotas);
            }
        }
        List defaultPermissions = this.permissionRepository.findByState(Integer.valueOf(1));
        ArrayList<Permission> permissionsSelect = new ArrayList<Permission>();
        ArrayList<String> orgPermissionCodes = new ArrayList<String>();
        orgPermissionCodes.add("consumer");
        orgPermissionCodes.add("info");
        orgPermissionCodes.add("set");
        if (null != organization.getOrganizationPermission()) {
            for (Permission p : organization.getOrganizationPermission()) {
                orgPermissionCodes.add(p.getPermission().replace("member:", ""));
            }
        }
        for (Permission p : defaultPermissions) {
            String pp = p.getPermission().replace("member:", "");
            if (pp.contains(":")) {
                pp = pp.substring(0, pp.indexOf(":"));
            }
            if (p.getType() == -1 || !orgPermissionCodes.contains(pp)) continue;
            permissionsSelect.add(p);
        }
        department.setPermissions(permissionsSelect);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f\u6210\u5458")
    @Transactional
    @RequestMapping(value={"/api/dep/members"}, method={RequestMethod.POST})
    public ListResultResponse<DepMemberModel> membersGet(@Valid @RequestBody SearchDepRequest dto, HttpServletRequest request) {
        OrgConfigDepartment dep;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long depId = dto.getId();
        if (depId == null) {
            depId = (Long)session.getAttribute("departmentId");
        }
        if ((dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId)).getDeleted() == 1) {
            return res;
        }
        List depMembers = this.depUsersRepository.findByDepartment(dep);
        ArrayList<DepMemberModel> responseDtos = new ArrayList<DepMemberModel>();
        if (depMembers != null && depMembers.size() > 0) {
            for (DepUsers du : depMembers) {
                User member = du.getUser();
                if (member.getDeleted() == null || member.getDeleted() == 1 || dto.getSearch() != null && !dto.getSearch().isEmpty() && !member.getUsername().contains(dto.getSearch()) && member.getName() != null && !member.getName().contains(dto.getSearch()) || dto.getLevel() != null && (dto.getLevel() == 1 ? du.getType() != 1 : (dto.getLevel() == 2 ? du.getType() != 2 : du.getType() == 1 || du.getType() == 2))) continue;
                DepMemberModel depMemberModel = new DepMemberModel();
                depMemberModel.setUserId(member.getId());
                depMemberModel.setUsername(member.getUsername());
                depMemberModel.setName(member.getName() == null ? member.getUsername() : member.getName());
                depMemberModel.setPhone(member.getPhone());
                if (member.getState() == -1) continue;
                depMemberModel.setState(du.getState());
                depMemberModel.setLevel(du.getType());
                Date joinTime = du.getCreatedAt();
                if (joinTime == null) {
                    joinTime = member.getCreatedAt();
                }
                if (joinTime == null) {
                    joinTime = new Date();
                }
                depMemberModel.setCreatedAt(joinTime);
                if (du.getType() == 3) {
                    ArrayList<DepUserQuotasModel> userQuotasModels = new ArrayList<DepUserQuotasModel>();
                    User user = du.getUser();
                    List quotas = this.quotasRepository.findByOrganizationAndStatusAndDeleted(dep.getOrgConfig().getOrganization(), Integer.valueOf(1), Integer.valueOf(0));
                    if (null != quotas && !quotas.isEmpty()) {
                        for (OrganizationQuotas quota : quotas) {
                            DepUserQuotas userQuotas;
                            if (quota.getDomain().getDeleted() == 1 || quota.getDomain().getStatus() == 0 || null == (userQuotas = this.depUserQuotasRepository.findByUserAndDepartmentAndDomain(user, dep, quota.getDomain()))) continue;
                            DepUserQuotasModel model = new DepUserQuotasModel();
                            model.setDomainId(quota.getDomain().getId());
                            model.setDomainName(quota.getDomain().getName());
                            model.setStorage(userQuotas.getStorage());
                            model.setCpuQuota(userQuotas.getCpuQuota());
                            model.setMemoryQuota(userQuotas.getMemoryQuota());
                            model.setGpuQuota(userQuotas.getGpuQuota());
                            userQuotasModels.add(model);
                        }
                    }
                    depMemberModel.setUserQuotas(userQuotasModels);
                }
                responseDtos.add(depMemberModel);
            }
            res.setSize(Long.valueOf(depMembers.size()));
        }
        responseDtos.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        res.setList(responseDtos);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u79fb\u9664\u6210\u5458")
    @Transactional
    @RequestMapping(value={"/api/dep/member/remove"}, method={RequestMethod.PUT})
    public ResultResponse deleteRole(@Valid @RequestBody RoleSelectRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        Long depId = dto.getDepId();
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        List users = dep.getUsers();
        List roleIds = dto.getUserIds();
        if (null != roleIds && roleIds.size() == 1 && ((Long)roleIds.get(0)).equals(userId) && session.getAttribute("departmentId").equals(dto.getDepId())) {
            List dus = this.depUsersRepository.findByUser(user);
            if (dus != null && dus.size() > 0) {
                session.setAttribute("departmentId", (Object)((DepUsers)dus.get(0)).getDepartment().getId());
            } else {
                session.setAttribute("departmentId", null);
            }
        }
        for (Long id : roleIds) {
            User role = (User)this.userRepository.findOne((Serializable)id);
            if (!userId.equals(role.getId()) && !DepartmentController.isDepPermission((String)"consumer:remove", (Long)depId)) {
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(role, dep);
            if (depUsers != null) {
                this.depUsersRepository.delete((Object)depUsers);
            }
            for (User u : users) {
                if (role.getId().equals(u.getId()) || u.getDeleted() == 1 || u.getState() != 1) continue;
                if (role.getId().equals(userId)) {
                    this.noticeUserService.sendMemberChange(Integer.valueOf(1), role.getName(), u, dep);
                    continue;
                }
                this.noticeUserService.sendMemberRemove(user.getName(), role.getName(), u, dep);
            }
            if (role.getId().equals(user.getId()) || role.getDeleted() == 1 || role.getState() != 1) continue;
            this.noticeUserService.sendMemberEmail(Integer.valueOf(1), role, dep, user);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u53d8\u66f4\u56e2\u961f\u6210\u5458\u89d2\u8272")
    @Transactional
    @RequestMapping(value={"/api/dep/members/change"}, method={RequestMethod.PUT})
    public ResultResponse membersChange(@Valid @RequestBody MemberChangeRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            return res;
        }
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)Long.valueOf(domainId));
        HttpSession session = request.getSession();
        Long ownerId = (Long)session.getAttribute("userId");
        if (ownerId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)dto.getUserId());
        Long depId = dto.getDepId();
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        if (!DepartmentController.isDepPermission((String)"consumer:update", (Long)depId)) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers.getType() == 2 && ownerId.equals(dto.getUserId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer type = dto.getType();
        if (type == null) {
            type = 3;
        }
        if (type == 3 && depUsers.getType() == 2) {
            DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, Long.valueOf(domainId));
            Integer resourceCount = depQuotas == null ? -1 : depQuotas.getResourceCount();
            Integer jobCount = depQuotas == null ? -1 : depQuotas.getJobCount();
            Integer modelCount = depQuotas == null ? -1 : depQuotas.getModelCount();
            Integer userResourceCount = this.resourceRepository.countByDepartmentIdAndDeletedAndDomainAndUser(depId, Integer.valueOf(0), domain, user);
            Integer userJobCount = this.jobRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user);
            Integer userModelCount = this.serviceRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user);
            if (resourceCount != -1 && null != userResourceCount && userResourceCount > resourceCount || jobCount != -1 && null != userJobCount && userJobCount > jobCount || modelCount != -1 && null != userModelCount && userModelCount > modelCount) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.count.quota.exceed"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        }
        depUsers.setType(type);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f\u8d44\u6e90\u7528\u91cf", notes="v3.3\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570unusual\uff0cother")
    @Transactional
    @RequestMapping(value={"/api/dep/resource/count"}, method={RequestMethod.GET})
    public ListResourceResultResponse<DepResourceCountModel> depCount(HttpServletRequest request) {
        Specification storageSpec;
        List storages;
        1 experimentSpec;
        List experiments;
        Specification serviceSpec;
        List services;
        PricePackage pack;
        Specification jobSpec;
        List jobs;
        Integer serviceOther;
        Integer[] serviceOtherStatus;
        Integer storageOther;
        Integer annotationOther;
        Integer automlOther;
        Integer[] automlOtherStatus;
        Integer jobOther;
        Integer[] jobOtherStatus;
        Integer resourceOther;
        Integer[] resourceOtherStatus;
        Integer serviceUnusual;
        Integer[] serviceUnusualStatus;
        Integer storageUnusual;
        Integer annotationUnusual;
        Integer[] annotationUnusualStatus;
        Integer automlUnusual;
        Integer[] automlUnusualStatus;
        Integer jobUnusual;
        Integer[] jobUnusualStatus;
        Integer resourceUnusual;
        Integer[] resourceUnusualStatus;
        Integer automlAmount;
        Integer annotationAmount;
        Integer storageAmount;
        Integer serviceAmount;
        Integer jobAmount;
        Integer resourceAmount;
        Integer automlUsed;
        Integer annotationUsed;
        Integer storageUsed;
        Integer serviceUsed;
        Integer jobUsed;
        Integer resourceUsed;
        ListResourceResultResponse res = new ListResourceResultResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        Long userId = (Long)request.getSession().getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)request.getSession().getAttribute("departmentId");
        if (depId == null) {
            res.setCode(Constants.SC_OK);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        if (!user.getDepartments().contains(dep)) {
            return res;
        }
        Integer level = this.getDepUserLevel(user, dep);
        if (level == 1 || level == 2) {
            resourceUsed = this.resourceRepository.countByDepartmentAndDeletedAndDomain(dep, Integer.valueOf(0), domain);
            jobUsed = this.jobRepository.countByDepartmentAndDeletedAndDomain(dep, Integer.valueOf(0), domain);
            serviceUsed = this.serviceRepository.countByDepartmentAndDeletedAndDomain(dep, Integer.valueOf(0), domain);
            storageUsed = this.storageRepository.countByDepartmentAndDeletedAndDomain(dep, Integer.valueOf(0), domain);
            if (storageUsed == null) {
                storageUsed = 0;
            }
            annotationUsed = this.annotationRepository.countByDepartmentAndDeletedAndDomain(dep, Integer.valueOf(0), domain);
            automlUsed = this.experimentRepository.countByDepartmentAndDeletedAndDomain(dep, Integer.valueOf(0), domain);
            resourceAmount = this.resourceRepository.countByDepartmentAndDeletedAndStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), domain);
            jobAmount = this.jobRepository.countByDepartmentAndDeletedAndCurrentStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), domain);
            serviceAmount = this.serviceRepository.countByDepartmentAndDeletedAndCurrentStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(2), domain);
            storageAmount = this.storageRepository.countByDepartmentAndDeletedAndStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), domain);
            if (storageAmount == null) {
                storageAmount = 0;
            }
            annotationAmount = this.annotationRepository.countByDepartmentAndDeletedAndStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), domain);
            automlAmount = this.experimentRepository.countByDepartmentAndDeletedAndStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), domain);
            resourceUnusualStatus = new Integer[]{-9, -6, -4, -3, -2, -1};
            resourceUnusual = this.resourceRepository.countByDepartmentAndDeletedAndStatusInAndDomain(dep, Integer.valueOf(0), resourceUnusualStatus, domain);
            jobUnusualStatus = new Integer[]{-9, -3, -2, -1};
            jobUnusual = this.jobRepository.countByDepartmentAndDeletedAndCurrentStatusInAndDomain(dep, Integer.valueOf(0), jobUnusualStatus, domain);
            automlUnusualStatus = new Integer[]{-9, -1};
            automlUnusual = this.experimentRepository.countByDepartmentAndDeletedAndStatusInAndDomain(dep, Integer.valueOf(0), automlUnusualStatus, domain);
            annotationUnusualStatus = new Integer[]{-9, -1};
            annotationUnusual = this.annotationRepository.countByDepartmentAndDeletedAndStatusInAndDomain(dep, Integer.valueOf(0), annotationUnusualStatus, domain);
            storageUnusual = this.storageRepository.countByDepartmentAndDeletedAndStatusInAndDomain(dep, Integer.valueOf(0), domain);
            serviceUnusualStatus = new Integer[]{-9, -5, -4, -3, -1};
            serviceUnusual = this.serviceRepository.countByDepartmentAndDeletedAndCurrentStatusInAndDomain(dep, Integer.valueOf(0), serviceUnusualStatus, domain);
            resourceOtherStatus = new Integer[]{0, 2, 3, 4, 5, 6};
            resourceOther = this.resourceRepository.countByDepartmentAndDeletedAndStatusInAndDomain(dep, Integer.valueOf(0), resourceOtherStatus, domain);
            jobOtherStatus = new Integer[]{0, 2, 3};
            jobOther = this.jobRepository.countByDepartmentAndDeletedAndCurrentStatusInAndDomain(dep, Integer.valueOf(0), jobOtherStatus, domain);
            automlOtherStatus = new Integer[]{0, 2};
            automlOther = this.experimentRepository.countByDepartmentAndDeletedAndStatusInAndDomain(dep, Integer.valueOf(0), automlOtherStatus, domain);
            annotationOther = this.annotationRepository.countByDepartmentAndDeletedAndStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(0), domain);
            storageOther = this.storageRepository.countByDepartmentAndDeletedAndStatusAndDomain(dep, Integer.valueOf(0), Integer.valueOf(0), domain);
            serviceOtherStatus = new Integer[]{-2, 0, 1, 3, 4, 5};
            serviceOther = this.serviceRepository.countByDepartmentAndDeletedAndCurrentStatusInAndDomain(dep, Integer.valueOf(0), serviceOtherStatus, domain);
        } else {
            resourceUsed = this.resourceRepository.countByDepartmentIdAndDeletedAndUserAndDomain(depId, Integer.valueOf(0), user, domain);
            jobUsed = this.jobRepository.countByDepartmentAndDeletedAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            serviceUsed = this.serviceRepository.countByDepartmentAndDeletedAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            storageUsed = this.storageRepository.countByDepartmentAndDeletedAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            if (storageUsed == null) {
                storageUsed = 0;
            }
            annotationUsed = this.annotationRepository.countByDepartmentAndDeletedAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            automlUsed = this.experimentRepository.countByDepartmentAndDeletedAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            resourceAmount = this.resourceRepository.countByDepartmentIdAndDeletedAndStatusAndUserAndDomain(depId, Integer.valueOf(0), Integer.valueOf(1), user, domain);
            jobAmount = this.jobRepository.countByDepartmentAndDeletedAndCurrentStatusAndUserAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), user, domain);
            serviceAmount = this.serviceRepository.countByDepartmentAndDeletedAndCurrentStatusAndUserAndDomain(dep, Integer.valueOf(0), Integer.valueOf(2), user, domain);
            storageAmount = this.storageRepository.countByDepartmentAndDeletedAndStatusAndUserAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), user, domain);
            if (storageAmount == null) {
                storageAmount = 0;
            }
            annotationAmount = this.annotationRepository.countByDepartmentAndDeletedAndStatusAndUserAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), user, domain);
            automlAmount = this.experimentRepository.countByDepartmentAndDeletedAndStatusAndUserAndDomain(dep, Integer.valueOf(0), Integer.valueOf(1), user, domain);
            resourceUnusualStatus = new Integer[]{-9, -6, -4, -3, -2, -1};
            resourceUnusual = this.resourceRepository.countByDepartmentAndDeletedAndStatusInAndUserAndDomain(dep, Integer.valueOf(0), resourceUnusualStatus, user, domain);
            jobUnusualStatus = new Integer[]{-9, -3, -2, -1};
            jobUnusual = this.jobRepository.countByDepartmentAndDeletedAndCurrentStatusInAndUserAndDomain(dep, Integer.valueOf(0), jobUnusualStatus, user, domain);
            automlUnusualStatus = new Integer[]{-9, -1};
            automlUnusual = this.experimentRepository.countByDepartmentAndDeletedAndStatusInAndUserAndDomain(dep, Integer.valueOf(0), automlUnusualStatus, user, domain);
            annotationUnusualStatus = new Integer[]{-9, -1};
            annotationUnusual = this.annotationRepository.countByDepartmentAndDeletedAndStatusInAndUserAndDomain(dep, Integer.valueOf(0), annotationUnusualStatus, user, domain);
            storageUnusual = this.storageRepository.countByDepartmentAndDeletedAndStatusInAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            serviceUnusualStatus = new Integer[]{-9, -5, -4, -3, -1};
            serviceUnusual = this.serviceRepository.countByDepartmentAndDeletedAndCurrentStatusInAndUserAndDomain(dep, Integer.valueOf(0), serviceUnusualStatus, user, domain);
            resourceOtherStatus = new Integer[]{0, 2, 3, 4, 5, 6};
            resourceOther = this.resourceRepository.countByDepartmentAndDeletedAndStatusInAndUserAndDomain(dep, Integer.valueOf(0), resourceOtherStatus, user, domain);
            jobOtherStatus = new Integer[]{0, 2, 3};
            jobOther = this.jobRepository.countByDepartmentAndDeletedAndCurrentStatusInAndUserAndDomain(dep, Integer.valueOf(0), jobOtherStatus, user, domain);
            automlOtherStatus = new Integer[]{0, 2};
            automlOther = this.experimentRepository.countByDepartmentAndDeletedAndStatusInAndUserAndDomain(dep, Integer.valueOf(0), automlOtherStatus, user, domain);
            annotationOther = this.annotationRepository.countByDepartmentAndDeletedAndStatusAndUserAndDomain(dep, Integer.valueOf(0), Integer.valueOf(0), user, domain);
            storageOther = this.storageRepository.countByDepartmentAndDeletedAndStatusAndUserAndDomain(dep, Integer.valueOf(0), Integer.valueOf(0), user, domain);
            serviceOtherStatus = new Integer[]{-2, 0, 1, 3, 4, 5};
            serviceOther = this.serviceRepository.countByDepartmentAndDeletedAndCurrentStatusInAndUserAndDomain(dep, Integer.valueOf(0), serviceOtherStatus, user, domain);
        }
        ArrayList<DepResourceCountModel> list = new ArrayList<DepResourceCountModel>();
        DepResourceCountModel responseDto = new DepResourceCountModel();
        responseDto.setType(Integer.valueOf(0));
        responseDto.setResourceUsed(resourceUsed);
        responseDto.setAmount(resourceAmount);
        responseDto.setUnusual(resourceUnusual);
        responseDto.setOther(resourceOther);
        list.add(responseDto);
        responseDto = new DepResourceCountModel();
        responseDto.setType(Integer.valueOf(1));
        responseDto.setResourceUsed(jobUsed);
        responseDto.setAmount(jobAmount);
        responseDto.setUnusual(jobUnusual);
        responseDto.setOther(jobOther);
        list.add(responseDto);
        responseDto = new DepResourceCountModel();
        responseDto.setType(Integer.valueOf(2));
        responseDto.setResourceUsed(storageUsed);
        responseDto.setAmount(storageAmount);
        responseDto.setUnusual(Integer.valueOf(storageUnusual == null ? 0 : storageUnusual));
        responseDto.setOther(Integer.valueOf(storageOther == null ? 0 : storageOther));
        list.add(responseDto);
        responseDto = new DepResourceCountModel();
        responseDto.setType(Integer.valueOf(3));
        responseDto.setResourceUsed(annotationUsed);
        responseDto.setAmount(annotationAmount);
        responseDto.setUnusual(annotationUnusual);
        responseDto.setOther(annotationOther);
        list.add(responseDto);
        responseDto = new DepResourceCountModel();
        responseDto.setType(Integer.valueOf(5));
        responseDto.setResourceUsed(serviceUsed);
        responseDto.setAmount(serviceAmount);
        responseDto.setUnusual(serviceUnusual);
        responseDto.setOther(serviceOther);
        list.add(responseDto);
        responseDto = new DepResourceCountModel();
        responseDto.setType(Integer.valueOf(7));
        responseDto.setResourceUsed(automlUsed);
        responseDto.setAmount(automlAmount);
        responseDto.setUnusual(automlUnusual);
        responseDto.setOther(automlOther);
        list.add(responseDto);
        Double gpuTotal = 0.0;
        Double cpuTotal = 0.0;
        Double memoryTotal = 0.0;
        Integer storageTotal = 0;
        JSONObject gpuTypeTotal = new JSONObject();
        Specification resourceSpec = (root, query, cb) -> {
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.equal((Expression)root.get("deleted"), (Object)0));
            lstPredicates.add(cb.or(new Predicate[]{cb.equal((Expression)root.get("status"), (Object)1), cb.equal((Expression)root.get("status"), (Object)2), cb.equal((Expression)root.get("status"), (Object)5), cb.equal((Expression)root.get("status"), (Object)6), cb.and((Expression)cb.equal((Expression)root.get("status"), (Object)4), (Expression)cb.greaterThan((Expression)root.get("replicas"), (Comparable)Integer.valueOf(1)))}));
            lstPredicates.add(cb.equal((Expression)root.get("department").get("id"), (Object)depId));
            if (domain != null) {
                lstPredicates.add(cb.equal((Expression)root.get("domain"), (Object)domain));
            }
            if (level == 3) {
                lstPredicates.add(cb.equal((Expression)root.get("user"), (Object)user));
            }
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        };
        List resources = this.resourceRepository.findAll(resourceSpec);
        if (resources != null && resources.size() > 0) {
            for (Resource resource : resources) {
                Integer replicas = resource.getReplicas();
                if (replicas == null) {
                    replicas = 1;
                }
                PricePackage pack2 = resource.getPack();
                gpuTotal = gpuTotal + (pack2.getGpuNum() == null ? 0.0 : (double)(pack2.getGpuNum() * replicas));
                if (pack2.getGpuNum() != null) {
                    String chargeItem = pack2.getGpu().getChargeItem();
                    if (gpuTypeTotal.get(chargeItem) != null) {
                        Integer gpuNum = (Integer)gpuTypeTotal.get(chargeItem);
                        gpuTypeTotal.put((Object)chargeItem, (Object)(gpuNum + pack2.getGpuNum() * replicas));
                    } else {
                        gpuTypeTotal.put((Object)chargeItem, (Object)(pack2.getGpuNum() * replicas));
                    }
                }
                cpuTotal = cpuTotal + (double)(pack2.getCpuNum() * replicas);
                memoryTotal = memoryTotal + (double)(pack2.getMemoryNum() * replicas);
            }
        }
        if ((jobs = this.jobRepository.findAll(jobSpec = (root, query, cb) -> {
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            Join join = root.join("current", JoinType.INNER);
            lstPredicates.add(cb.equal((Expression)root.get("deleted"), (Object)0));
            lstPredicates.add(cb.or((Expression)cb.equal((Expression)join.get("status"), (Object)1), (Expression)cb.and((Expression)cb.equal((Expression)join.get("status"), (Object)0), (Expression)cb.greaterThan((Expression)join.get("replicas"), (Comparable)Integer.valueOf(1)))));
            lstPredicates.add(cb.equal((Expression)root.get("department"), (Object)dep));
            if (domain != null) {
                lstPredicates.add(cb.equal((Expression)root.get("domain"), (Object)domain));
            }
            if (level == 3) {
                lstPredicates.add(cb.equal((Expression)root.get("user"), (Object)user));
            }
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        })) != null && jobs.size() > 0) {
            for (Object job : jobs) {
                List versions = this.jobVersionRepository.getByJobAndDeleted((Job)job, Integer.valueOf(0));
                if (versions == null) continue;
                for (JobVersion version : versions) {
                    Integer replicas = version.getReplicas();
                    if (replicas == null) {
                        replicas = 1;
                    }
                    pack = version.getPack();
                    gpuTotal = gpuTotal + (pack.getGpuNum() == null ? 0.0 : (double)(pack.getGpuNum() * replicas));
                    if (pack.getGpuNum() != null) {
                        String chargeItem = pack.getGpu().getChargeItem();
                        if (gpuTypeTotal.get(chargeItem) != null) {
                            Integer gpuNum = (Integer)gpuTypeTotal.get(chargeItem);
                            gpuTypeTotal.put((Object)chargeItem, (Object)(gpuNum + pack.getGpuNum() * replicas));
                        } else {
                            gpuTypeTotal.put((Object)chargeItem, (Object)(pack.getGpuNum() * replicas));
                        }
                    }
                    cpuTotal = cpuTotal + (double)(pack.getCpuNum() * replicas);
                    memoryTotal = memoryTotal + (double)(pack.getMemoryNum() * replicas);
                }
            }
        }
        if ((services = this.serviceRepository.findAll(serviceSpec = (root, query, cb) -> {
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.equal((Expression)root.get("deleted"), (Object)0));
            lstPredicates.add(cb.or(new Predicate[]{cb.equal((Expression)root.get("current").get("status"), (Object)1), cb.equal((Expression)root.get("current").get("status"), (Object)2), cb.equal((Expression)root.get("current").get("status"), (Object)3), cb.equal((Expression)root.get("current").get("status"), (Object)4), cb.equal((Expression)root.get("current").get("status"), (Object)5)}));
            lstPredicates.add(cb.equal((Expression)root.get("department"), (Object)dep));
            if (domain != null) {
                lstPredicates.add(cb.equal((Expression)root.get("domain"), (Object)domain));
            }
            if (level == 3) {
                lstPredicates.add(cb.equal((Expression)root.get("user"), (Object)user));
            }
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        })) != null && services.size() > 0) {
            for (Service service : services) {
                PricePackage pack3 = service.getCurrent().getPack();
                gpuTotal = gpuTotal + (pack3.getGpuNum() == null ? 0.0 : (double)pack3.getGpuNum().intValue());
                if (pack3.getGpuNum() != null) {
                    String chargeItem = pack3.getGpu().getChargeItem();
                    if (gpuTypeTotal.get(chargeItem) != null) {
                        Integer gpuNum = (Integer)gpuTypeTotal.get(chargeItem);
                        gpuTypeTotal.put((Object)chargeItem, (Object)(gpuNum + pack3.getGpuNum()));
                    } else {
                        gpuTypeTotal.put((Object)chargeItem, (Object)pack3.getGpuNum());
                    }
                }
                cpuTotal = cpuTotal + (double)pack3.getCpuNum().intValue();
                memoryTotal = memoryTotal + (double)pack3.getMemoryNum().intValue();
            }
        }
        if ((experiments = this.experimentRepository.findAll((Specification)(experimentSpec = new /* Unavailable Anonymous Inner Class!! */))) != null && experiments.size() > 0) {
            for (Experiment experiment : experiments) {
                pack = experiment.getJobVersion().getPack();
                Integer replicas = experiment.getJobVersion().getReplicas();
                gpuTotal = gpuTotal + (pack.getGpuNum() == null ? 0.0 : (double)pack.getGpuNum().intValue());
                if (pack.getGpuNum() != null) {
                    String chargeItem = pack.getGpu().getChargeItem();
                    if (gpuTypeTotal.get(chargeItem) != null) {
                        Integer gpuNum = (Integer)gpuTypeTotal.get(chargeItem);
                        gpuTypeTotal.put((Object)chargeItem, (Object)(gpuNum + pack.getGpuNum() * replicas));
                    } else {
                        gpuTypeTotal.put((Object)chargeItem, (Object)(pack.getGpuNum() * replicas));
                    }
                }
                cpuTotal = cpuTotal + (double)pack.getCpuNum().intValue();
                memoryTotal = memoryTotal + (double)pack.getMemoryNum().intValue();
            }
        }
        if ((storages = this.storageRepository.findAll(storageSpec = (root, query, cb) -> {
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.equal((Expression)root.get("deleted"), (Object)0));
            lstPredicates.add(cb.equal((Expression)root.get("status"), (Object)1));
            lstPredicates.add(cb.equal((Expression)root.get("department").get("id"), (Object)depId));
            if (domain != null) {
                lstPredicates.add(cb.equal((Expression)root.get("domain"), (Object)domain));
            }
            if (level == 3) {
                lstPredicates.add(cb.equal((Expression)root.get("user"), (Object)user));
            }
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        })) != null && storages.size() > 0) {
            for (Storage storage : storages) {
                storageTotal = storageTotal + storage.getCapacity();
            }
        }
        res.setCpuTotal(cpuTotal + "");
        res.setGpuTotal(gpuTotal + this.messageUtil.getMessage("msg.gpu.piece"));
        res.setGpuTypeTotal(gpuTypeTotal);
        res.setMemoryTotal(memoryTotal + "GB");
        res.setStorageTotal(storageTotal + "GB");
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f\u8d44\u6e90\u7edf\u8ba1-\u73af\u5883\u5217\u8868(\u8fc7\u671f)")
    @Transactional
    @RequestMapping(value={"/api/dep/info/resource/list"}, method={RequestMethod.POST})
    public ListResultResponse<ResourceModel> depInfoResourceList(@RequestBody @Valid DepResourceInfoRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depOwner = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depOwner != null) {
            return res;
        }
        2 spec = new /* Unavailable Anonymous Inner Class!! */;
        List resources = this.resourceRepository.findAll((Specification)spec);
        if (dto.getTimeSort() != null && dto.getTimeSort() == 1) {
            resources.sort(Comparator.comparing(BaseEntity::getCreatedAt));
        } else {
            resources.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        }
        if (resources.size() > 0) {
            ArrayList<ResourceModel> models = new ArrayList<ResourceModel>(resources.size());
            for (Resource resource : resources) {
                DepUsers depUsers;
                Date latestCostTime;
                ResourceModel model = new ResourceModel();
                model.setId(resource.getId());
                model.setName(resource.getName());
                model.setImage(resource.getImage());
                model.setStatus(resource.getStatus());
                model.setCreatedAt(resource.getCreatedAt());
                model.setAuditedAt(resource.getAuditedAt());
                model.setPackageType(resource.getPackageType());
                model.setReclaimedAt(resource.getReclaimedAt());
                model.setStartedAt(resource.getStartedAt());
                model.setSeq(resource.getGuid().substring(0, 12));
                model.setRemark(resource.getRemark());
                model.setUserId(resource.getUser().getId());
                model.setUsername(resource.getUser().getUsername());
                model.setFullName(resource.getUser().getName() == null ? resource.getUser().getUsername() : resource.getUser().getName());
                PricePackage pack = resource.getPack();
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                    packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setPack(packageInfoModel);
                model.setCost(pack.getCost());
                if (resource.getPackageType() != null && resource.getPackageType() == 0 && null != (latestCostTime = this.materialsRepository.getLatestCostTimeByResource(resource.getId(), Integer.valueOf(0)))) {
                    model.setLastAt(latestCostTime);
                }
                if ((depUsers = this.depUsersRepository.findByUserAndDepartment(resource.getUser(), dep)) != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @ApiOperation(value="\u56e2\u961f\u8d44\u6e90\u7edf\u8ba1-\u4efb\u52a1\u5217\u8868(\u8fc7\u671f)")
    @Transactional
    @RequestMapping(value={"/api/dep/info/job/list"}, method={RequestMethod.POST})
    public ListResultResponse<JobModel> depInfoJobList(@RequestBody @Valid DepResourceInfoRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depOwner = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depOwner != null) {
            return res;
        }
        3 spec = new /* Unavailable Anonymous Inner Class!! */;
        List jobs = this.jobRepository.findAll((Specification)spec);
        if (dto.getTimeSort() != null && dto.getTimeSort() == 1) {
            jobs.sort((a1, a2) -> a1.getCreatedAt().compareTo(a2.getCreatedAt()));
        } else {
            jobs.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        }
        ArrayList<JobModel> models = new ArrayList<JobModel>(jobs.size());
        if (jobs != null && jobs.size() > 0) {
            for (Job job : jobs) {
                JobModel model = new JobModel();
                model.setId(job.getId());
                model.setName(job.getName());
                JobVersion current = job.getCurrent();
                model.setStatus(current.getStatus());
                model.setImage(current.getImage().substring(current.getImage().lastIndexOf("/") + 1));
                model.setCreateTime(job.getCreatedAt());
                if (current.getStatus() > 0 && null != current.getStartedAt()) {
                    model.setTrainBegin(current.getStartedAt());
                    long second = ((null != current.getStopAt() && current.getStopAt().after(current.getStartedAt()) ? current.getStopAt().getTime() : System.currentTimeMillis()) - current.getStartedAt().getTime()) / 1000L;
                    model.setTrainTime(TimeUtil.duration((Long)second));
                }
                model.setPrice(current.getPack().getCost());
                model.setRemark(current.getRemark());
                model.setSeq(current.getGuid().substring(0, 12));
                model.setUserId(job.getUser().getId());
                model.setUsername(job.getUser().getUsername());
                model.setFullName(job.getUser().getName() == null ? job.getUser().getUsername() : job.getUser().getName());
                PricePackage pack = current.getPack();
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                    packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setPack(packageInfoModel);
                DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(job.getUser(), dep);
                if (depUsers != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u6743\u9650\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/dep/permission/{id}"}, method={RequestMethod.GET})
    public ListResultResponse<PermissionModel> getDepPermissions(@ApiParam(value="\u56e2\u961fid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        String pName;
        JSONObject jsonObject;
        PermissionModel model;
        String pp;
        ListResultResponse res = new ListResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)id);
        List permissionSelects = department.getPermissions();
        List permissions = this.permissionRepository.findAllExceptAdmin("*");
        if (permissions != null && permissions.size() > 0) {
            permissions.removeAll(permissionSelects);
        }
        Organization organization = department.getOrgConfig().getOrganization();
        String language = "zh";
        String header = request.getHeader("Accept-Language");
        if (header.startsWith("en")) {
            language = "en";
        }
        ArrayList<String> orgPermissionCodes = new ArrayList<String>();
        orgPermissionCodes.add("consumer");
        orgPermissionCodes.add("info");
        orgPermissionCodes.add("set");
        if (null != organization.getOrganizationPermission()) {
            for (Permission p : organization.getOrganizationPermission()) {
                orgPermissionCodes.add(p.getPermission().replace("member:", ""));
            }
        }
        ArrayList<PermissionModel> list = new ArrayList<PermissionModel>();
        for (Permission p : permissions) {
            pp = p.getPermission().replace("member:", "");
            if (pp.contains(":")) {
                pp = pp.substring(0, pp.indexOf(":"));
            }
            if (p.getType() == -1 || !orgPermissionCodes.contains(pp)) continue;
            model = (PermissionModel)BeanMapper.map((Object)p, PermissionModel.class);
            if (StringUtils.isJson((String)p.getName())) {
                jsonObject = JSONObject.fromObject((Object)p.getName());
                pName = jsonObject.get(language).toString();
            } else {
                pName = p.getName();
            }
            model.setName(pName);
            model.setSelected(Integer.valueOf(0));
            list.add(model);
        }
        for (Permission p : permissionSelects) {
            pp = p.getPermission().replace("member:", "");
            if (pp.contains(":")) {
                pp = pp.substring(0, pp.indexOf(":"));
            }
            if (p.getType() == -1 || !orgPermissionCodes.contains(pp)) continue;
            model = (PermissionModel)BeanMapper.map((Object)p, PermissionModel.class);
            if (StringUtils.isJson((String)p.getName())) {
                jsonObject = JSONObject.fromObject((Object)p.getName());
                pName = jsonObject.get(language).toString();
            } else {
                pName = p.getName();
            }
            model.setName(pName);
            model.setSelected(Integer.valueOf(1));
            list.add(model);
        }
        list.sort((a1, a2) -> a1.getOrders().compareTo(a2.getOrders()));
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u7ba1\u7406\u6743\u9650")
    @Transactional
    @RequestMapping(value={"/api/dep/permission/allot"}, method={RequestMethod.POST})
    public ResultResponse allotDepPermission(@Valid @RequestBody AllotDepPermissionRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getDepId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List permissionSelects = dto.getPermissionSelects();
        ArrayList<Permission> depPermissions = new ArrayList<Permission>();
        for (int i = 0; i < permissionSelects.size(); ++i) {
            Long permissionId = (Long)permissionSelects.get(i);
            Permission permission = (Permission)this.permissionRepository.findOne((Serializable)permissionId);
            if (permission == null) continue;
            depPermissions.add(permission);
        }
        List departmentPermissions = department.getPermissions();
        for (Permission dp : departmentPermissions) {
            if (!dp.getPermission().startsWith("member:") || depPermissions.contains(dp)) continue;
            depPermissions.add(dp);
        }
        department.setPermissions(depPermissions);
        this.orgConfigDepartmentRepository.save((Object)department);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u6210\u5458\u6743\u9650\u7ba1\u7406")
    @Transactional
    @RequestMapping(value={"/api/dep/member/permission/allot"}, method={RequestMethod.POST})
    public ResultResponse allotDepMemberPermission(@Valid @RequestBody AllotDepPermissionRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getDepId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List memberPerissions = this.permissionRepository.findByPermissionLike("%member:%");
        for (Permission p : memberPerissions) {
            DepPermission depPermission = this.depPermissionRepository.findByDepartmentAndPermission(department, p);
            if (depPermission == null) continue;
            this.depPermissionRepository.delete((Object)depPermission);
        }
        List permissionSelects = dto.getPermissionSelects();
        for (int i = 0; i < permissionSelects.size(); ++i) {
            Long permissionId = (Long)permissionSelects.get(i);
            Permission permission = (Permission)this.permissionRepository.findOne((Serializable)permissionId);
            DepPermission depPermission = this.depPermissionRepository.findByDepartmentAndPermission(department, permission);
            if (depPermission != null) continue;
            depPermission = new DepPermission();
            depPermission.setDepartment(department);
            depPermission.setPermission(permission);
            this.depPermissionRepository.save((Object)depPermission);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u57fa\u7840\u8bbe\u7f6e")
    @Transactional
    @RequestMapping(value={"/api/dep/base/alter"}, method={RequestMethod.POST})
    public ResultResponse alterDepBase(@Valid @RequestBody DepBaseRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getDepId());
        if (!DepartmentController.isDepPermission((String)"info:group", (Long)dep.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (dto.getDepName() == null || dto.getDepName().isEmpty()) {
            res.setMessage(this.messageUtil.getMessage("msg.account.department.name.empty"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        dep.setName(dto.getDepName());
        dep.setDescription(dto.getDescription());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u66f4\u65b0\u8d44\u6e90\u914d\u7f6e(\u5957\u9910)")
    @Transactional
    @RequestMapping(value={"/api/dep/allocation/allot"}, method={RequestMethod.POST})
    public ResultResponse allotAllocation(@Valid @RequestBody DepAllocationRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getGroupId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"set:pack", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = dto.getDomainId();
        if (domainId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"set:resource", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Organization org = department.getOrgConfig().getOrganization();
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(department, Long.valueOf(domainId));
        List groupProducts = this.orgConfigDepPackageRepository.findByDepartmentAndDomain(department, null);
        this.orgConfigDepPackageRepository.delete((Iterable)groupProducts);
        groupProducts = this.orgConfigDepPackageRepository.findByDepartmentAndDomain(department, domain);
        this.orgConfigDepPackageRepository.delete((Iterable)groupProducts);
        List packages = dto.getPackageSelects();
        for (Long id : packages) {
            PricePackage aPackage = (PricePackage)this.pricePackageRepository.findOne((Serializable)id);
            OrgConfigDepPackage accountGroupPackage = new OrgConfigDepPackage();
            accountGroupPackage.setDepartment(department);
            accountGroupPackage.setPricePackage(aPackage);
            accountGroupPackage.setDomain(domain);
            this.orgConfigDepPackageRepository.save((Object)accountGroupPackage);
        }
        if (depQuotas == null) {
            depQuotas = new DepQuotas();
            depQuotas.setOrganization(org);
            depQuotas.setDepartment(department);
            depQuotas.setDomain(domain);
            depQuotas.setUserStorage(Integer.valueOf(-1));
            depQuotas.setCpuQuota(Integer.valueOf(-1));
            List priceGpuList = this.priceRepository.findByTypeAndDomainAndDeleted(Integer.valueOf(1), domain, Integer.valueOf(0));
            ArrayList<String> gpuType = new ArrayList<String>();
            HashMap<String, Integer> depGpu = new HashMap<String, Integer>();
            for (Price price : priceGpuList) {
                if (gpuType.contains(price.getChargeItem())) continue;
                gpuType.add(price.getChargeItem());
            }
            for (String s : gpuType) {
                depGpu.put(s, -1);
            }
            depQuotas.setGpuQuota(JSONObject.fromObject(depGpu).toString());
            depQuotas.setMemoryQuota(Integer.valueOf(-1));
            this.depQuotasRepository.save((Object)depQuotas);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u66f4\u65b0\u8d44\u6e90\u914d\u7f6e(\u8d44\u6e90\u914d\u989d\u8bbe\u7f6e)")
    @Transactional
    @RequestMapping(value={"/api/dep/quota/allot"}, method={RequestMethod.POST})
    public ResultResponse allotAllocationQuota(@Valid @RequestBody DepAllocationQuotaRequest dto, HttpServletRequest request) {
        Integer harborStorageAllocated;
        Integer memoryAllocated;
        Integer capacity;
        Integer storageBuild;
        Integer depCapacity;
        ArrayList keySetList;
        Integer orgHarborStorage;
        Integer orgMemory;
        Integer orgCpu;
        Integer orgCapacity;
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getGroupId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = dto.getDomainId();
        if (domainId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"set:resource", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Organization org = department.getOrgConfig().getOrganization();
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(department, Long.valueOf(domainId));
        Map<String, Integer> orgGpu = new HashMap<String, Integer>();
        Map<String, Integer> depGpu = new HashMap();
        Double depCpuBuild = 0.0;
        Double depMemoryBuild = 0.0;
        HashMap<String, Integer> depGpuBuild = new HashMap<String, Integer>();
        List priceGpuList = this.priceRepository.findByTypeAndDomainAndDeleted(Integer.valueOf(1), domain, Integer.valueOf(0));
        ArrayList<String> gpuType = new ArrayList<String>();
        for (Object price : priceGpuList) {
            if (gpuType.contains(price.getChargeItem())) continue;
            gpuType.add(price.getChargeItem());
        }
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, Long.valueOf(domainId));
        for (String s : gpuType) {
            if (null == orgQuotas) {
                orgGpu.put(s, -1);
            }
            depGpuBuild.put(s, 0);
        }
        if (null == orgQuotas) {
            orgCapacity = -1;
            orgCpu = -1;
            orgMemory = -1;
            orgHarborStorage = -1;
        } else {
            orgCapacity = orgQuotas.getStorage() != null ? orgQuotas.getStorage() : 0;
            orgCpu = orgQuotas.getCpuQuota() != null ? orgQuotas.getCpuQuota() : -1;
            orgMemory = orgQuotas.getMemoryQuota() != null ? orgQuotas.getMemoryQuota() : -1;
            orgHarborStorage = orgQuotas.getHarborStorage() != null ? orgQuotas.getHarborStorage() : -1;
            orgGpu = (Map)JSON.parse((String)orgQuotas.getGpuQuota());
            if (null == orgGpu || orgGpu.isEmpty()) {
                orgGpu = new HashMap();
                for (String s : gpuType) {
                    orgGpu.put(s, -1);
                }
            } else {
                keySetList = new ArrayList(orgGpu.keySet());
                for (int i = keySetList.size() - 1; i >= 0; --i) {
                    if (gpuType.contains(keySetList.get(i))) continue;
                    orgGpu.remove(keySetList.get(i));
                }
                for (String s : gpuType) {
                    if (keySetList.contains(s)) continue;
                    orgGpu.put(s, -1);
                }
            }
        }
        if (null == depQuotas) {
            depCapacity = -1;
            depQuotas = new DepQuotas();
            depQuotas.setOrganization(org);
            depQuotas.setDepartment(department);
            depQuotas.setDomain(domain);
            depQuotas.setUserStorage(Integer.valueOf(-1));
            depQuotas.setStorage(Integer.valueOf(-1));
            depQuotas.setCpuQuota(Integer.valueOf(-1));
            HashMap depGpuNew = new HashMap();
            for (Price price : priceGpuList) {
                if (gpuType.contains(price.getChargeItem())) continue;
                gpuType.add(price.getChargeItem());
            }
            for (String s : gpuType) {
                depGpuNew.put(s, -1);
            }
            depQuotas.setGpuQuota(JSONObject.fromObject((Object)depGpuNew).toString());
            depQuotas.setMemoryQuota(Integer.valueOf(-1));
            depQuotas.setHarborStorage(Integer.valueOf(-1));
            this.depQuotasRepository.save((Object)depQuotas);
        } else {
            depCapacity = depQuotas.getStorage() != null ? depQuotas.getStorage() : -1;
            if (!StringUtils.isEmpty((String)depQuotas.getGpuQuota())) {
                depGpu = (Map)JSON.parse((String)depQuotas.getGpuQuota());
            }
            if (null == depGpu || depGpu.isEmpty()) {
                depGpu = new HashMap();
                for (String s : gpuType) {
                    depGpu.put(s, -1);
                }
            } else {
                keySetList = new ArrayList(depGpu.keySet());
                for (int i = keySetList.size() - 1; i >= 0; --i) {
                    if (gpuType.contains(keySetList.get(i))) continue;
                    depGpu.remove(keySetList.get(i));
                }
                for (String s : gpuType) {
                    if (keySetList.contains(s)) continue;
                    depGpu.put(s, -1);
                }
            }
        }
        Integer storageAllocated = this.depQuotasRepository.sumOrgAllocated(org, Long.valueOf(domainId));
        if (null == storageAllocated) {
            storageAllocated = 0;
        }
        if ((storageBuild = this.storageRepository.sumQuotaAllocatedByDepIdAndStatusInAndDomain(dto.getGroupId(), domain)) == null) {
            storageBuild = 0;
        }
        if (orgCapacity == -1) {
            capacity = -1;
        } else {
            capacity = depCapacity == -1 ? Integer.valueOf(orgCapacity - storageAllocated > 0 ? orgCapacity - storageAllocated : 0) : Integer.valueOf(orgCapacity - storageAllocated + depCapacity > 0 ? orgCapacity - storageAllocated + depCapacity : 0);
            capacity = Math.min(orgCapacity, capacity);
            capacity = Math.max(capacity, storageBuild);
        }
        Integer storage = dto.getStorage() == null ? -1 : dto.getStorage();
        if (storage != -1 && capacity != -1 && (storage < -1 || storage > capacity)) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.storage.capacity.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (storage != -1 && storage < storageBuild) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.storage.capacity.less"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!StringUtils.isEmpty((String)(dto.getCpu() + "")) && dto.getCpu() < -1) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.cpu.error"));
            return res;
        }
        if (!StringUtils.isEmpty((String)(dto.getMemory() + "")) && dto.getMemory() < -1) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.memory.error"));
            return res;
        }
        if (!StringUtils.isEmpty((String)(dto.getHarborStorage() + "")) && dto.getHarborStorage() < -1) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.harborstorage.error"));
            return res;
        }
        if (dto.getGpu() != null && !dto.getGpu().isEmpty()) {
            for (Object key : dto.getGpu().keySet()) {
                if ((Integer)dto.getGpu().get(key) >= -1) continue;
                res.setMessage(this.messageUtil.getMessage("msg.dep.gpu.error"));
                return res;
            }
        }
        List resources = this.resourceRepository.findBuildByDepIdAndDomain(department.getId(), domain);
        for (Object r : resources) {
            if (r.getPack().getCpuNum() != null) {
                depCpuBuild = depCpuBuild + (double)(r.getPack().getCpuNum() * r.getReplicas());
            }
            if (r.getPack().getMemoryNum() != null) {
                depMemoryBuild = depMemoryBuild + (double)(r.getPack().getMemoryNum() * r.getReplicas());
            }
            if (r.getPack().getGpuNum() == null) continue;
            if (null == depGpuBuild.get(r.getPack().getGpu().getChargeItem())) {
                depGpuBuild.put(r.getPack().getGpu().getChargeItem(), r.getPack().getGpuNum() * r.getReplicas());
                continue;
            }
            depGpuBuild.put(r.getPack().getGpu().getChargeItem(), (Integer)depGpuBuild.get(r.getPack().getGpu().getChargeItem()) + r.getPack().getGpuNum() * r.getReplicas());
        }
        List jobs = this.jobRepository.findBuildByDepAndDomain(department, domain);
        for (Object r : jobs) {
            if (r.getCurrent().getPack().getCpuNum() != null) {
                depCpuBuild = depCpuBuild + (double)(r.getCurrent().getPack().getCpuNum() * r.getCurrent().getReplicas());
            }
            if (r.getCurrent().getPack().getMemoryNum() != null) {
                depMemoryBuild = depMemoryBuild + (double)(r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getReplicas());
            }
            if (r.getCurrent().getPack().getGpuNum() == null) continue;
            if (null == depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem())) {
                depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas());
                continue;
            }
            depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), (Integer)depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem()) + r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas());
        }
        List services = this.serviceRepository.findBuildByDepAndDomain(department, domain);
        for (Service r : services) {
            if (r.getCurrent().getPack().getCpuNum() != null) {
                depCpuBuild = depCpuBuild + (double)(r.getCurrent().getPack().getCpuNum() * r.getCurrent().getInstance());
            }
            if (r.getCurrent().getPack().getMemoryNum() != null) {
                depMemoryBuild = depMemoryBuild + (double)(r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getInstance());
            }
            if (r.getCurrent().getPack().getGpuNum() == null) continue;
            if (null == depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem())) {
                depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance());
                continue;
            }
            depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), (Integer)depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem()) + r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance());
        }
        Integer cpuAllocated = this.depQuotasRepository.sumOrgCpuAllocated(org, domainId);
        if (null == cpuAllocated) {
            cpuAllocated = 0;
        }
        if (null == (memoryAllocated = this.depQuotasRepository.sumOrgMemoryAllocated(org, domainId))) {
            memoryAllocated = 0;
        }
        if (null == (harborStorageAllocated = this.depQuotasRepository.sumOrgharborStorageAllocated(org, domainId))) {
            harborStorageAllocated = 0;
        }
        List orgConfigs = org.getOrgConfigs();
        OrgConfig orgConfig = null;
        for (OrgConfig c : orgConfigs) {
            if (c.getLevel() != 1) continue;
            orgConfig = c;
            break;
        }
        List depIds = this.orgConfigDepartmentRepository.findIdsByOrgConfigAndDeleted(orgConfig, Integer.valueOf(0));
        List depQuotasList = this.depQuotasRepository.findByDepartmentIdInAndDomain(depIds, domain);
        for (int i = 0; i < gpuType.size(); ++i) {
            String gpuSpe = (String)gpuType.get(i);
            if (null == orgGpu.get(gpuSpe) || (Integer)orgGpu.get(gpuSpe) <= 0) continue;
            for (int j = 0; j < depQuotasList.size(); ++j) {
                Integer num;
                Map split;
                if (((DepQuotas)depQuotasList.get(j)).getDepartment().getId().equals(department.getId()) || (split = (Map)JSON.parse((String)((DepQuotas)depQuotasList.get(j)).getGpuQuota())) == null || null == (num = (Integer)split.get(gpuSpe)) || num <= 0) continue;
                orgGpu.put(gpuSpe, (Integer)orgGpu.get(gpuSpe) - num >= 0 ? (Integer)orgGpu.get(gpuSpe) - num : 0);
            }
        }
        Integer cpuRange = -1;
        Integer memoryRange = -1;
        Integer harborStorageRange = -1;
        if (orgCpu != -1) {
            cpuRange = orgCpu - cpuAllocated > 0 ? orgCpu - cpuAllocated : 0;
        }
        if (orgMemory != -1) {
            memoryRange = orgMemory - memoryAllocated > 0 ? orgMemory - memoryAllocated : 0;
        }
        if (orgHarborStorage != -1) {
            harborStorageRange = orgHarborStorage - harborStorageAllocated > 0 ? orgHarborStorage - harborStorageAllocated : 0;
        }
        if (depQuotas.getCpuQuota() != null && depQuotas.getCpuQuota() != -1 && depQuotas.getCpuQuota() > 0 && cpuRange != -1) {
            cpuRange = orgCpu - cpuAllocated + depQuotas.getCpuQuota() > 0 ? orgCpu - cpuAllocated + depQuotas.getCpuQuota() : 0;
        }
        if (depQuotas.getMemoryQuota() != null && depQuotas.getMemoryQuota() != -1 && depQuotas.getMemoryQuota() > 0 && memoryRange != -1) {
            memoryRange = orgMemory - memoryAllocated + depQuotas.getMemoryQuota() > 0 ? orgMemory - memoryAllocated + depQuotas.getMemoryQuota() : 0;
        }
        if (depQuotas.getHarborStorage() != null && depQuotas.getHarborStorage() != -1 && depQuotas.getHarborStorage() > 0 && harborStorageRange != -1) {
            harborStorageRange = orgHarborStorage - harborStorageAllocated + depQuotas.getHarborStorage() > 0 ? orgHarborStorage - harborStorageAllocated + depQuotas.getHarborStorage() : 0;
        }
        if (dto.getCpu() != null && dto.getCpu() != -1 && (dto.getCpu().doubleValue() < depCpuBuild || cpuRange != -1 && dto.getCpu().doubleValue() > (double)cpuRange.intValue())) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.cpu.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (dto.getMemory() != null && dto.getMemory() != -1 && (dto.getMemory().doubleValue() < depMemoryBuild || memoryRange != -1 && dto.getMemory().doubleValue() > (double)memoryRange.intValue())) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.memory.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer depHarborStorageBuild = this.harborProjectRepository.sumHarborStorageByDepAndDomain(dto.getGroupId(), domainId);
        if (dto.getHarborStorage() != null && dto.getHarborStorage() != -1 && (dto.getHarborStorage() < depHarborStorageBuild || harborStorageRange != -1 && dto.getHarborStorage() > harborStorageRange)) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.harborstorage.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Map gpu = dto.getGpu();
        if (null != gpu) {
            for (String key : gpu.keySet()) {
                if ((Integer)gpu.get(key) == -1 || (null == depGpuBuild.get(key) || (Integer)depGpuBuild.get(key) == -1 || (Integer)gpu.get(key) >= (Integer)depGpuBuild.get(key)) && (orgGpu.get(key) == null || (Integer)orgGpu.get(key) == -1 || (Integer)gpu.get(key) <= (Integer)orgGpu.get(key))) continue;
                res.setMessage(this.messageUtil.getMessage("msg.dep.gpu.error"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        }
        Integer shrink = 0;
        if (depQuotas.getStorage() != null && dto.getStorage() != -1 && dto.getStorage() < depQuotas.getStorage()) {
            shrink = 1;
        }
        if (depQuotas.getCpuQuota() != null && dto.getCpu() != -1 && dto.getCpu() < depQuotas.getCpuQuota()) {
            shrink = 1;
        }
        if (depQuotas.getMemoryQuota() != null && dto.getMemory() != -1 && dto.getMemory() < depQuotas.getMemoryQuota()) {
            shrink = 1;
        }
        if (!StringUtils.isEmpty((String)depQuotas.getGpuQuota())) {
            Map depGpuQuotas = (Map)JSON.parse((String)depQuotas.getGpuQuota());
            for (String key : depGpuQuotas.keySet()) {
                if (depGpuQuotas.get(key) == null || gpu.get(key) == null || (Integer)gpu.get(key) == -1 || (Integer)gpu.get(key) >= (Integer)depGpuQuotas.get(key)) continue;
                shrink = 1;
            }
        }
        if (shrink == 1) {
            List userQuotas = this.depUserQuotasRepository.findByDepartmentAndDomain(department, domain);
            this.depUserQuotasRepository.delete((Iterable)userQuotas);
        }
        depQuotas.setStorage(storage);
        depQuotas.setCpuQuota(dto.getCpu());
        depQuotas.setMemoryQuota(dto.getMemory());
        depQuotas.setGpuQuota(JSONObject.fromObject((Object)gpu).toString());
        depQuotas.setHarborStorage(dto.getHarborStorage());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u66f4\u65b0\u8d44\u6e90\u914d\u7f6e-\u73af\u5883\u6570\u91cf\uff08\u6210\u5458\uff09", notes="v3.3\u4fee\u6539\uff0c\u63a5\u53e3\u4f20\u53c2-\u65b0\u589e\u53c2\u6570automlCount")
    @Transactional
    @RequestMapping(value={"/api/dep/allocation/allot/count"}, method={RequestMethod.POST})
    public ResultResponse allotAllocationCount(@Valid @RequestBody DepAllocationCountRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getGroupId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"set:quantity", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = dto.getDomainId();
        if (domainId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"set:resource", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Organization org = department.getOrgConfig().getOrganization();
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(department, Long.valueOf(domainId));
        Integer orgResourceCount = -1;
        Integer orgJobCount = -1;
        Integer orgModelCount = -1;
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, Long.valueOf(domainId));
        if (null == orgQuotas) {
            orgResourceCount = -1;
            orgJobCount = -1;
            orgModelCount = -1;
        } else {
            orgResourceCount = orgQuotas.getResourceCount() != null ? orgQuotas.getResourceCount() : -1;
            orgJobCount = orgQuotas.getJobCount() != null ? orgQuotas.getJobCount() : -1;
            orgModelCount = orgQuotas.getModelCount() != null ? orgQuotas.getModelCount() : -1;
        }
        Integer resourceCount = dto.getResourceCount() == null ? -1 : dto.getResourceCount();
        Integer jobCount = dto.getJobCount() == null ? -1 : dto.getJobCount();
        Integer modelCount = dto.getModelCount() == null ? -1 : dto.getModelCount();
        Integer automlount = dto.getAutomlCount() == null ? -1 : dto.getAutomlCount();
        if (resourceCount != -1 || jobCount != -1 || modelCount != -1) {
            if (resourceCount < 0 || resourceCount > orgResourceCount && orgResourceCount != -1 || jobCount < 0 || jobCount > orgJobCount && orgJobCount != -1 || modelCount < 0 || modelCount > orgModelCount && orgModelCount != -1 || automlount < 0) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.count.error"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            List usersList = this.depUsersRepository.findUserByDep(department);
            Integer maxResourceUsed = 0;
            Integer maxJobUsed = 0;
            Integer maxModelUsed = 0;
            Integer maxAutomlUsed = 0;
            for (User u : usersList) {
                Integer resourceUsed = this.resourceRepository.countByDepartmentIdAndDeletedAndDomainAndUser(department.getId(), Integer.valueOf(0), domain, u);
                Integer jobUsed = this.jobRepository.countByDepartmentAndDeletedAndDomainAndUser(department, Integer.valueOf(0), domain, u);
                Integer modelUsed = this.serviceRepository.countByDepartmentAndDeletedAndDomainAndUser(department, Integer.valueOf(0), domain, u);
                Integer automlUsed = this.experimentRepository.countByDepartmentAndDeletedAndDomainAndUser(department, Integer.valueOf(0), domain, u);
                maxResourceUsed = Math.max(maxResourceUsed, resourceUsed);
                maxJobUsed = Math.max(maxJobUsed, jobUsed);
                maxModelUsed = Math.max(maxModelUsed, modelUsed);
                maxAutomlUsed = Math.max(maxAutomlUsed, automlUsed);
            }
            if (resourceCount < maxResourceUsed || jobCount < maxJobUsed || modelCount < maxModelUsed || automlount < maxAutomlUsed) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.count.less"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        }
        if (depQuotas == null) {
            depQuotas = new DepQuotas();
            depQuotas.setOrganization(org);
            depQuotas.setDepartment(department);
            depQuotas.setDomain(domain);
            depQuotas.setUserStorage(Integer.valueOf(-1));
            this.depQuotasRepository.save((Object)depQuotas);
        }
        depQuotas.setResourceCount(resourceCount);
        depQuotas.setJobCount(jobCount);
        depQuotas.setModelCount(modelCount);
        depQuotas.setAutomlCount(automlount);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u66f4\u65b0\u8d44\u6e90\u914d\u7f6e-\u73af\u5883\u65f6\u957f\uff08\u6210\u5458\uff09", notes="v3.3\u4fee\u6539\uff0c\u63a5\u53e3\u4f20\u53c2-\u65b0\u589e\u53c2\u6570automlTime")
    @Transactional
    @RequestMapping(value={"/api/dep/allocation/allot/time"}, method={RequestMethod.POST})
    public ResultResponse allotAllocationTime(@Valid @RequestBody DepAllocationTimeRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getGroupId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"set:duration", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = dto.getDomainId();
        if (domainId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"set:resource", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer count = this.resourceRepository.countByDepIdAndDeletedAndDomainAndPackageType(department.getId(), Integer.valueOf(0), Long.valueOf(domainId), Integer.valueOf(0));
        if (count == null) {
            count = 0;
        }
        Double resourceTime = dto.getResourceTime() == null ? -1.0 : dto.getResourceTime();
        Double jobTime = dto.getJobTime() == null ? -1.0 : dto.getJobTime();
        Double modelTime = dto.getModelTime() == null ? -1.0 : dto.getModelTime();
        Double automlTime = dto.getAutomlTime() == null ? -1.0 : dto.getAutomlTime();
        if ((resourceTime != -1.0 || jobTime != -1.0 || modelTime != -1.0) && count > 0) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.resource.prepay.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if ((resourceTime != -1.0 || jobTime != -1.0 || modelTime != -1.0 || automlTime != -1.0) && (resourceTime < 0.0 || jobTime < 0.0 || modelTime < 0.0 || automlTime < 0.0)) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.resource.time.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Organization org = department.getOrgConfig().getOrganization();
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(department, Long.valueOf(domainId));
        if (depQuotas == null) {
            depQuotas = new DepQuotas();
            depQuotas.setOrganization(org);
            depQuotas.setDepartment(department);
            depQuotas.setDomain(domain);
            depQuotas.setUserStorage(Integer.valueOf(-1));
            this.depQuotasRepository.save((Object)depQuotas);
        }
        depQuotas.setTimeStart(new Date());
        depQuotas.setResourceTime(resourceTime);
        depQuotas.setJobTime(jobTime);
        depQuotas.setModelTime(modelTime);
        depQuotas.setAutomlTime(automlTime);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u66f4\u65b0\u8d44\u6e90\u914d\u7f6e-\u6210\u5458\u5b58\u50a8")
    @Transactional
    @RequestMapping(value={"/api/dep/allocation/allot/storage"}, method={RequestMethod.POST})
    public ResultResponse allotAllocation(@Valid @RequestBody DepAllocationUserStorageRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getGroupId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = dto.getDomainId();
        if (domainId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Organization org = department.getOrgConfig().getOrganization();
        if (!DepartmentController.isDepPermission((String)"set:resource", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(department, Long.valueOf(domainId));
        if (depQuotas == null) {
            depQuotas = new DepQuotas();
            depQuotas.setOrganization(org);
            depQuotas.setDepartment(department);
            depQuotas.setDomain(domain);
            depQuotas.setUserStorage(Integer.valueOf(-1));
            depQuotas = (DepQuotas)this.depQuotasRepository.saveAndFlush((Object)depQuotas);
        }
        if (null != dto.getUserStorage() && dto.getUserStorage() != -1) {
            Integer depStorage = depQuotas.getStorage();
            Integer storage = dto.getUserStorage();
            if (storage != -1 && depStorage != -1 && (storage < -1 || storage > depStorage)) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.storage.capacity.error"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            depQuotas.setUserStorage(dto.getUserStorage());
        } else {
            depQuotas.setUserStorage(Integer.valueOf(-1));
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56e2\u961f-\u8d44\u6e90\u914d\u7f6e\u8be6\u60c5", notes="v3.3\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570automlCount\uff0cautomlTime\uff1b3.5\u4fee\u6539\uff0c\u65b0\u589e\u8fd4\u56de\u6570\u636e\u6807\u6ce8\u5957\u9910")
    @Transactional
    @RequestMapping(value={"/api/dep/package/allocation"}, method={RequestMethod.POST})
    public DepAllocationResponse depAllocation(@Valid @RequestBody DomainDepRequest requestDto, HttpServletRequest request) {
        Integer capacity;
        Double automlTime;
        Double modelTime;
        Double jobTime;
        Double resourceTime;
        Integer depAutomlAllocated;
        Integer depModelAllocated;
        Integer depJobAllocated;
        Integer depResourceAllocated;
        Integer depCapacity;
        Integer harborStorageAllocated;
        Integer memoryAllocated;
        Integer storageBuild;
        Integer orgHarborStorage;
        Integer orgMemory;
        Integer orgCpu;
        Integer orgModelCount;
        Integer orgJobCount;
        Integer orgResourceCount;
        Integer orgCapacity;
        DepAllocationResponse res = new DepAllocationResponse();
        ArrayList<PackageModel> packageSelects = new ArrayList<PackageModel>();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)requestDto.getDepId());
        Domain domain = this.domainRepository.findByIdAndDeleted(requestDto.getDomainId(), Integer.valueOf(0));
        Organization org = dep.getOrgConfig().getOrganization();
        List<Object> allPackage = new ArrayList();
        List allResources = org.getResourcePricePackage();
        List allK8sJobs = org.getJobPricePackage();
        List allServices = org.getModelPricePackage();
        List allAnnotations = org.getAnnotationPackage();
        allPackage.addAll(allResources);
        allPackage.addAll(allK8sJobs);
        allPackage.addAll(allServices);
        allPackage.addAll(allAnnotations);
        allPackage = allPackage.stream().distinct().collect(Collectors.toList());
        for (int i = allPackage.size() - 1; i >= 0; --i) {
            PricePackage pricePackage = (PricePackage)allPackage.get(i);
            if (pricePackage.getDomain() != null && pricePackage.getDomain().getId().equals(requestDto.getDomainId())) continue;
            allPackage.remove(pricePackage);
        }
        List orgConfigdepPackages = dep.getOrgConfigdepPackages();
        if (orgConfigdepPackages != null && orgConfigdepPackages.size() > 0) {
            for (OrgConfigDepPackage p : orgConfigdepPackages) {
                PricePackage pricePackage = p.getPricePackage();
                if (pricePackage.getDomain() == null || !pricePackage.getDomain().getId().equals(requestDto.getDomainId())) {
                    allPackage.remove(pricePackage);
                    continue;
                }
                if (!allPackage.contains(pricePackage)) {
                    OrgConfigDepPackage depPackage = this.orgConfigDepPackageRepository.findTopByDepartmentAndPricePackageAndDomain(dep, pricePackage, domain);
                    if (depPackage == null) continue;
                    this.orgConfigDepPackageRepository.delete((Object)depPackage);
                    continue;
                }
                allPackage.remove(pricePackage);
                if (pricePackage.getDeleted() == 1 || pricePackage.getStatus() != 1) continue;
                PackageModel pack = (PackageModel)BeanMapper.map((Object)pricePackage, PackageModel.class);
                packageSelects.add(pack);
            }
        }
        List packages = BeanMapper.mapList(allPackage, PricePackage.class, PackageModel.class);
        packages.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        packageSelects.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        res.setPackages(packages);
        res.setPackageSelects(packageSelects);
        Integer userStorage = -1;
        Map<String, Integer> orgGpu = new HashMap<String, Integer>();
        Integer depCpu = -1;
        Integer depMemory = -1;
        Integer depHarborStorage = -1;
        Map<String, Integer> depGpu = new HashMap();
        Double depCpuBuild = 0.0;
        Double depMemoryBuild = 0.0;
        HashMap<String, Integer> depGpuBuild = new HashMap<String, Integer>();
        List priceGpuList = this.priceRepository.findByTypeAndDomainAndDeleted(Integer.valueOf(1), domain, Integer.valueOf(0));
        ArrayList<String> gpuType = new ArrayList<String>();
        for (Object price : priceGpuList) {
            if (gpuType.contains(price.getChargeItem())) continue;
            gpuType.add(price.getChargeItem());
        }
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, requestDto.getDomainId());
        for (String s : gpuType) {
            if (null == orgQuotas) {
                orgGpu.put(s, -1);
            }
            depGpuBuild.put(s, 0);
        }
        if (null == orgQuotas) {
            orgCapacity = -1;
            orgResourceCount = -1;
            orgJobCount = -1;
            orgModelCount = -1;
            orgCpu = -1;
            orgMemory = -1;
            orgHarborStorage = -1;
        } else {
            orgCapacity = orgQuotas.getStorage() != null ? orgQuotas.getStorage() : 0;
            orgResourceCount = orgQuotas.getResourceCount() != null ? orgQuotas.getResourceCount() : -1;
            orgJobCount = orgQuotas.getJobCount() != null ? orgQuotas.getJobCount() : -1;
            orgModelCount = orgQuotas.getModelCount() != null ? orgQuotas.getModelCount() : -1;
            orgCpu = orgQuotas.getCpuQuota() != null ? orgQuotas.getCpuQuota() : -1;
            orgMemory = orgQuotas.getMemoryQuota() != null ? orgQuotas.getMemoryQuota() : -1;
            orgHarborStorage = orgQuotas.getHarborStorage() != null ? orgQuotas.getHarborStorage() : -1;
            orgGpu = (Map)JSON.parse((String)orgQuotas.getGpuQuota());
            if (null == orgGpu || orgGpu.isEmpty()) {
                orgGpu = new HashMap();
                for (String s : gpuType) {
                    orgGpu.put(s, -1);
                }
            } else {
                ArrayList keySetList = new ArrayList(orgGpu.keySet());
                for (int i = keySetList.size() - 1; i >= 0; --i) {
                    if (gpuType.contains(keySetList.get(i))) continue;
                    orgGpu.remove(keySetList.get(i));
                }
                for (String s : gpuType) {
                    if (keySetList.contains(s)) continue;
                    orgGpu.put(s, -1);
                }
            }
        }
        res.setOrgStorage(orgCapacity);
        res.setOrgCpu(orgCpu);
        res.setOrgMemory(orgMemory);
        res.setOrgGpu(orgGpu);
        res.setOrgHarborStorage(orgHarborStorage);
        Integer storageAllocated = this.depQuotasRepository.sumOrgAllocated(org, requestDto.getDomainId());
        if (null == storageAllocated) {
            storageAllocated = 0;
        }
        if ((storageBuild = this.storageRepository.sumQuotaAllocatedByDepIdAndStatusInAndDomain(requestDto.getDepId(), domain)) == null) {
            storageBuild = 0;
        }
        res.setStorageBuild(storageBuild);
        List resources = this.resourceRepository.findBuildByDepIdAndDomain(dep.getId(), domain);
        for (Object r : resources) {
            if (r.getPack().getCpuNum() != null) {
                depCpuBuild = depCpuBuild + (double)(r.getPack().getCpuNum() * r.getReplicas());
            }
            if (r.getPack().getMemoryNum() != null) {
                depMemoryBuild = depMemoryBuild + (double)(r.getPack().getMemoryNum() * r.getReplicas());
            }
            if (r.getPack().getGpuNum() == null) continue;
            if (null == depGpuBuild.get(r.getPack().getGpu().getChargeItem())) {
                depGpuBuild.put(r.getPack().getGpu().getChargeItem(), r.getPack().getGpuNum() * r.getReplicas());
                continue;
            }
            depGpuBuild.put(r.getPack().getGpu().getChargeItem(), (Integer)depGpuBuild.get(r.getPack().getGpu().getChargeItem()) + r.getPack().getGpuNum() * r.getReplicas());
        }
        List jobs = this.jobRepository.findBuildByDepAndDomain(dep, domain);
        for (Object r : jobs) {
            if (r.getCurrent().getPack().getCpuNum() != null) {
                depCpuBuild = depCpuBuild + (double)(r.getCurrent().getPack().getCpuNum() * r.getCurrent().getReplicas());
            }
            if (r.getCurrent().getPack().getMemoryNum() != null) {
                depMemoryBuild = depMemoryBuild + (double)(r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getReplicas());
            }
            if (r.getCurrent().getPack().getGpuNum() == null) continue;
            if (null == depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem())) {
                depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas());
                continue;
            }
            depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), (Integer)depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem()) + r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas());
        }
        List services = this.serviceRepository.findBuildByDepAndDomain(dep, domain);
        for (Object r : services) {
            if (r.getCurrent().getPack().getCpuNum() != null) {
                depCpuBuild = depCpuBuild + (double)(r.getCurrent().getPack().getCpuNum() * r.getCurrent().getInstance());
            }
            if (r.getCurrent().getPack().getMemoryNum() != null) {
                depMemoryBuild = depMemoryBuild + (double)(r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getInstance());
            }
            if (r.getCurrent().getPack().getGpuNum() == null) continue;
            if (null == depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem())) {
                depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance());
                continue;
            }
            depGpuBuild.put(r.getCurrent().getPack().getGpu().getChargeItem(), (Integer)depGpuBuild.get(r.getCurrent().getPack().getGpu().getChargeItem()) + r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance());
        }
        List annotations = this.annotationRepository.findBuildByDepAndDomain(dep, domain);
        for (Annotation r : annotations) {
            if (r.getPack().getCpuNum() != null) {
                depCpuBuild = depCpuBuild + (double)r.getPack().getCpuNum().intValue();
            }
            if (r.getPack().getMemoryNum() != null) {
                depMemoryBuild = depMemoryBuild + (double)r.getPack().getMemoryNum().intValue();
            }
            if (r.getPack().getGpuNum() == null) continue;
            if (null == depGpuBuild.get(r.getPack().getGpu().getChargeItem())) {
                depGpuBuild.put(r.getPack().getGpu().getChargeItem(), r.getPack().getGpuNum());
                continue;
            }
            depGpuBuild.put(r.getPack().getGpu().getChargeItem(), (Integer)depGpuBuild.get(r.getPack().getGpu().getChargeItem()) + r.getPack().getGpuNum());
        }
        Integer depHarborStorageBuild = this.harborProjectRepository.sumHarborStorageByDepAndDomain(requestDto.getDepId(), requestDto.getDomainId());
        Integer cpuAllocated = this.depQuotasRepository.sumOrgCpuAllocated(org, requestDto.getDomainId());
        if (null == cpuAllocated) {
            cpuAllocated = 0;
        }
        if (null == (memoryAllocated = this.depQuotasRepository.sumOrgMemoryAllocated(org, requestDto.getDomainId()))) {
            memoryAllocated = 0;
        }
        if (null == (harborStorageAllocated = this.depQuotasRepository.sumOrgharborStorageAllocated(org, requestDto.getDomainId()))) {
            harborStorageAllocated = 0;
        }
        List orgConfigs = org.getOrgConfigs();
        OrgConfig orgConfig = null;
        for (OrgConfig c : orgConfigs) {
            if (c.getLevel() != 1) continue;
            orgConfig = c;
            break;
        }
        List depIds = this.orgConfigDepartmentRepository.findIdsByOrgConfigAndDeleted(orgConfig, Integer.valueOf(0));
        List depQuotasList = this.depQuotasRepository.findByDepartmentIdInAndDomain(depIds, domain);
        for (int i = 0; i < gpuType.size(); ++i) {
            String gpuSpe = (String)gpuType.get(i);
            if (StringUtils.isEmpty((String)String.valueOf(orgGpu.get(gpuSpe))) || Integer.valueOf(String.valueOf(orgGpu.get(gpuSpe))) <= 0) continue;
            Integer orgGpuValue = Integer.valueOf(String.valueOf(orgGpu.get(gpuSpe)));
            for (int j = 0; j < depQuotasList.size(); ++j) {
                Integer num;
                Map split;
                if (((DepQuotas)depQuotasList.get(j)).getDepartment().getId().equals(dep.getId()) || (split = (Map)JSON.parse((String)((DepQuotas)depQuotasList.get(j)).getGpuQuota())) == null || null == (num = (Integer)split.get(gpuSpe)) || num <= 0) continue;
                orgGpu.put(gpuSpe, orgGpuValue - num >= 0 ? orgGpuValue - num : 0);
                if (depGpu.get(gpuSpe) == null || (Integer)depGpu.get(gpuSpe) <= 0) continue;
                orgGpu.put(gpuSpe, orgGpuValue - num + (Integer)depGpu.get(gpuSpe) >= 0 ? orgGpuValue - num + (Integer)depGpu.get(gpuSpe) : 0);
            }
        }
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, requestDto.getDomainId());
        if (null == depQuotas) {
            depQuotas = new DepQuotas();
            depQuotas.setStorage(Integer.valueOf(-1));
            depQuotas.setUserStorage(Integer.valueOf(-1));
            depQuotas.setOrganization(org);
            depQuotas.setDepartment(dep);
            Domain d = this.domainRepository.findByIdAndDeleted(requestDto.getDomainId(), Integer.valueOf(0));
            depQuotas.setDomain(d);
            depQuotas.setResourceCount(Integer.valueOf(-1));
            depQuotas.setJobCount(Integer.valueOf(-1));
            depQuotas.setModelCount(Integer.valueOf(-1));
            depQuotas.setResourceTime(Double.valueOf(-1.0));
            depQuotas.setJobTime(Double.valueOf(-1.0));
            depQuotas.setModelTime(Double.valueOf(-1.0));
            depQuotas.setUserStorage(Integer.valueOf(-1));
            depQuotas.setCpuQuota(Integer.valueOf(-1));
            depQuotas.setMemoryQuota(Integer.valueOf(-1));
            depQuotas.setAutomlCount(Integer.valueOf(-1));
            depQuotas.setAutomlTime(Double.valueOf(-1.0));
            HashMap<String, Integer> cpuQuota = new HashMap<String, Integer>();
            for (String s : gpuType) {
                cpuQuota.put(s, -1);
            }
            depQuotas.setGpuQuota(JSONObject.fromObject(cpuQuota).toString());
            depQuotas.setHarborStorage(Integer.valueOf(-1));
            this.depQuotasRepository.save((Object)depQuotas);
            depCapacity = depQuotas.getStorage();
            depResourceAllocated = -1;
            depJobAllocated = -1;
            depModelAllocated = -1;
            depAutomlAllocated = -1;
            resourceTime = -1.0;
            jobTime = -1.0;
            modelTime = -1.0;
            automlTime = -1.0;
            if (orgCapacity == -1) {
                capacity = -1;
            } else {
                capacity = orgCapacity - storageAllocated > 0 ? orgCapacity - storageAllocated : 0;
                capacity = Math.min(orgCapacity, capacity);
                capacity = Math.max(capacity, storageBuild);
            }
            res.setCapacity(capacity);
            depHarborStorage = -1;
        } else {
            depCapacity = depQuotas.getStorage() != null ? depQuotas.getStorage() : -1;
            depResourceAllocated = depQuotas.getResourceCount() != null ? depQuotas.getResourceCount() : -1;
            depJobAllocated = depQuotas.getJobCount() != null ? depQuotas.getJobCount() : -1;
            depModelAllocated = depQuotas.getModelCount() != null ? depQuotas.getModelCount() : -1;
            depAutomlAllocated = depQuotas.getAutomlCount() != null ? depQuotas.getAutomlCount() : -1;
            resourceTime = depQuotas.getResourceTime() != null ? depQuotas.getResourceTime() : -1.0;
            jobTime = depQuotas.getJobTime() != null ? depQuotas.getJobTime() : -1.0;
            modelTime = depQuotas.getModelTime() != null ? depQuotas.getModelTime() : -1.0;
            automlTime = depQuotas.getAutomlTime() != null ? depQuotas.getAutomlTime() : -1.0;
            if (orgCapacity == -1) {
                capacity = -1;
            } else {
                capacity = depCapacity == -1 ? Integer.valueOf(orgCapacity - storageAllocated > 0 ? orgCapacity - storageAllocated : 0) : Integer.valueOf(orgCapacity - storageAllocated + depCapacity > 0 ? orgCapacity - storageAllocated + depCapacity : 0);
                capacity = Math.min(orgCapacity, capacity);
                capacity = Math.max(capacity, storageBuild);
            }
            res.setCapacity(capacity);
            userStorage = depQuotas.getUserStorage() != null ? depQuotas.getUserStorage() : -1;
            depCpu = depQuotas.getCpuQuota() != null ? depQuotas.getCpuQuota() : -1;
            depMemory = depQuotas.getMemoryQuota() != null ? depQuotas.getMemoryQuota() : -1;
            depHarborStorage = depQuotas.getHarborStorage() != null ? depQuotas.getHarborStorage() : -1;
            if (!StringUtils.isEmpty((String)depQuotas.getGpuQuota())) {
                depGpu = (Map)JSON.parse((String)depQuotas.getGpuQuota());
            }
            if (null == depGpu || depGpu.isEmpty()) {
                depGpu = new HashMap();
                for (String s : gpuType) {
                    depGpu.put(s, -1);
                }
            } else {
                ArrayList keySetList = new ArrayList(depGpu.keySet());
                for (int i = keySetList.size() - 1; i >= 0; --i) {
                    if (gpuType.contains(keySetList.get(i))) continue;
                    depGpu.remove(keySetList.get(i));
                }
                for (String s : gpuType) {
                    if (keySetList.contains(s)) continue;
                    depGpu.put(s, -1);
                }
            }
        }
        res.setStorage(depCapacity);
        res.setUserStorage(userStorage);
        res.setResourceCount(depResourceAllocated);
        res.setJobCount(depJobAllocated);
        res.setModelCount(depModelAllocated);
        res.setResourceTime(resourceTime);
        res.setJobTime(jobTime);
        res.setModelTime(modelTime);
        res.setAutomlCount(depAutomlAllocated);
        res.setAutomlTime(automlTime);
        res.setResourceCountRange(orgResourceCount);
        res.setJobCountRange(orgJobCount);
        res.setModelCountRange(orgModelCount);
        Integer cpuRange = -1;
        Integer memoryRange = -1;
        Integer harborStorageRange = -1;
        if (orgCpu != -1) {
            cpuRange = orgCpu - cpuAllocated > 0 ? orgCpu - cpuAllocated : 0;
            if (depCpu != -1) {
                cpuRange = orgCpu - cpuAllocated + depCpu > 0 ? orgCpu - cpuAllocated + depCpu : 0;
            }
        }
        if (orgMemory != -1) {
            memoryRange = orgMemory - memoryAllocated > 0 ? orgMemory - memoryAllocated : 0;
            if (depMemory != -1) {
                memoryRange = orgMemory - memoryAllocated + depMemory > 0 ? orgMemory - memoryAllocated + depMemory : 0;
            }
        }
        if (orgHarborStorage != -1) {
            harborStorageRange = orgHarborStorage - harborStorageAllocated > 0 ? orgHarborStorage - harborStorageAllocated : 0;
            if (depHarborStorage != -1) {
                harborStorageRange = orgHarborStorage - harborStorageAllocated + depHarborStorage > 0 ? orgHarborStorage - harborStorageAllocated + depHarborStorage : 0;
            }
        }
        res.setCpuRange(cpuRange);
        res.setMemoryRange(memoryRange);
        res.setGpuRange(orgGpu);
        res.setHarborStorageRange(harborStorageRange);
        res.setCpuBuild(Integer.valueOf(new Double(depCpuBuild).intValue()));
        res.setMemoryBuild(Integer.valueOf(new Double(depMemoryBuild).intValue()));
        res.setGpuBuild(depGpuBuild);
        res.setHarborStorageBuild(depHarborStorageBuild);
        res.setCpu(depCpu);
        res.setMemory(depMemory);
        res.setGpu(depGpu);
        res.setHarborStorage(depHarborStorage);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7ec4\u7ec7\u4fe1\u606f")
    @Transactional
    @RequestMapping(value={"/api/org/info"}, method={RequestMethod.GET})
    public OrgInfoResponse orgInfo(HttpServletRequest request) {
        OrgInfoResponse res = new OrgInfoResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        Organization organization = user.getOrganization();
        if (organization == null) {
            organization = this.accountService.createOrg(user);
        }
        res.setOrgStatus(organization.getStatus());
        res.setId(organization.getId());
        res.setName(organization.getName());
        if (organization.getStatus() != null && organization.getStatus() == 0) {
            res.setCode(Constants.SC_OK);
            return res;
        }
        res.setGuid(organization.getGuid().substring(0, 12));
        List orgConfigs = organization.getOrgConfigs();
        for (OrgConfig configs : orgConfigs) {
            switch (configs.getLevel()) {
                case 1: {
                    res.setDepartment(configs.getName());
                    break;
                }
                case 2: {
                    res.setDepartmentManager(configs.getName());
                    break;
                }
                case 3: {
                    res.setDepartmentMember(configs.getName());
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7ec4\u7ec7\u4fe1\u606f\u4fee\u6539")
    @Transactional
    @RequestMapping(value={"/api/org/info/alter"}, method={RequestMethod.POST})
    public OrgInfoResponse alterOrgInfo(@Valid @RequestBody OrgInfoRequest dto, HttpServletRequest request) {
        String departmentMember;
        String departmentManager;
        RequestContext context = new RequestContext(request);
        OrgInfoResponse res = new OrgInfoResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        Organization org = (Organization)this.organizationRepository.findOne((Serializable)dto.getId());
        Organization organization = this.organizationRepository.findTopByNameAndDeleted(dto.getName(), Integer.valueOf(0));
        if (organization != null && !org.getName().equals(dto.getName())) {
            res.setMessage(this.messageUtil.getMessage("msg.org.name.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String department = dto.getDepartment();
        if (department == null || department.isEmpty()) {
            department = context.getMessage("msg.dep");
        }
        if ((departmentManager = dto.getDepartmentManager()) == null || departmentManager.isEmpty()) {
            departmentManager = context.getMessage("msg.admin");
        }
        if ((departmentMember = dto.getDepartmentMember()) == null || departmentMember.isEmpty()) {
            departmentMember = context.getMessage("msg.member");
        }
        organization = user.getOrganization();
        organization.setName(dto.getName());
        List orgConfigs = organization.getOrgConfigs();
        for (OrgConfig configs : orgConfigs) {
            switch (configs.getLevel()) {
                case 1: {
                    configs.setName(department);
                    break;
                }
                case 2: {
                    configs.setName(departmentManager);
                    break;
                }
                case 3: {
                    configs.setName(departmentMember);
                }
            }
        }
        organization.setUpdatedAt(new Date());
        organization.setUpdater(user.getUsername());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u603b\u89c8-\u8d39\u7528\u4e2d\u5fc3(\u6628\u65e5\u53ca\u6240\u5728\u6708\u6d88\u8d39)")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/overview/payment"}, method={RequestMethod.POST})
    @ResponseBody
    public ListPaymentResultResponse<OverviewPaymentModel> getUserPayment(@Valid @RequestBody DateRequest requestDto, HttpServletRequest request) {
        Object df;
        4 spec;
        ListPaymentResultResponse res = new ListPaymentResultResponse();
        ArrayList<OverviewPaymentModel> dtoList = new ArrayList<OverviewPaymentModel>();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        Organization organization = user.getOrganization();
        if (organization.getStatus() != null && organization.getStatus() == 0) {
            return res;
        }
        Integer level = 3;
        if (depId != null) {
            OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
            level = this.getDepUserLevel(user, dep);
        }
        if (requestDto.getDepId() != null && requestDto.getDepId() == -1L) {
            res.setCode(Constants.SC_OK);
            return res;
        }
        Date day = requestDto.getDay();
        if (day == null) {
            day = new Date();
        }
        Date sTime = TimeUtil.getFirstDayDateOfMonth((Date)day);
        Integer days = TimeUtil.getDaysOfMonth((Date)day);
        Calendar calendar = Calendar.getInstance();
        OverviewPaymentModel dto = null;
        Integer finalLevel = level;
        for (int i = 0; i < days; ++i) {
            calendar.setTime(sTime);
            calendar.add(5, i);
            spec = new /* Unavailable Anonymous Inner Class!! */;
            Double money = 0.0;
            List userPaymentList = this.paymentRepository.findAll((Specification)spec);
            if (userPaymentList != null && userPaymentList.size() > 0) {
                for (Payment payment : userPaymentList) {
                    money = money + payment.getMoney();
                }
            }
            df = new DecimalFormat("0.0000");
            dto = new OverviewPaymentModel();
            dto.setPaymentDate(TimeUtil.startOfDay((Date)calendar.getTime()));
            dto.setMoney(Double.valueOf(((Format)df).format(money)));
            dtoList.add(dto);
        }
        calendar.setTime(day);
        calendar.add(5, -1);
        Date finalDay = calendar.getTime();
        spec = new /* Unavailable Anonymous Inner Class!! */;
        List userPaymentList = this.paymentRepository.findAll((Specification)spec);
        Double blance = 0.0;
        if (userPaymentList != null && userPaymentList.size() > 0) {
            for (Payment payment : userPaymentList) {
                blance = blance + payment.getMoney();
            }
        }
        df = new DecimalFormat("0.0000");
        res.setBalance(Double.valueOf(((Format)df).format(blance)));
        res.setList(dtoList);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u90e8\u95e8\u8be6\u60c5")
    @Transactional
    @RequestMapping(value={"/api/dep/info/{id}"}, method={RequestMethod.GET})
    public DepInfoResponse depInfo(@ApiParam(value="\u90e8\u95e8id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        DepInfoResponse res = new DepInfoResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)id);
        res.setDepId(dep.getId());
        res.setDepName(dep.getName());
        res.setDescription(dep.getDescription());
        res.setGuid(dep.getGuid().substring(0, 12));
        DepUsers depUsersAdmin = this.depUsersRepository.findTopByDepartmentAndType(dep, Integer.valueOf(1));
        if (depUsersAdmin != null) {
            User depAdmin = depUsersAdmin.getUser();
            res.setUsername(depAdmin.getUsername());
            res.setName(depAdmin.getName() == null ? depAdmin.getUsername() : depAdmin.getName());
        }
        Integer enabledNum = this.depUsersRepository.countByDepartmentAndUserStatusAndUserStateAndUserDeletedAndState(dep, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1));
        res.setEnabledNum(enabledNum);
        Integer disabledNum = this.depUsersRepository.countByDepartmentAndUserStatusAndUserStateAndUserDeletedAndState(dep, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(-1));
        res.setDisabledNum(disabledNum);
        Integer consumersNum = enabledNum + disabledNum;
        res.setMemberNum(consumersNum);
        res.setCreatedAt(dep.getCreatedAt());
        Organization organization = dep.getOrgConfig().getOrganization();
        List orgConfigs = organization.getOrgConfigs();
        for (OrgConfig configs : orgConfigs) {
            switch (configs.getLevel()) {
                case 1: {
                    res.setDepartment(configs.getName());
                    break;
                }
                case 2: {
                    res.setDepartmentManager(configs.getName());
                    break;
                }
                case 3: {
                    res.setDepartmentMember(configs.getName());
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u603b\u89c8-\u914d\u989d\u4f7f\u7528\u548c\u8d44\u6e90\u914d\u7f6e", notes="v3.3\u65b0\u589e")
    @Transactional
    @RequestMapping(value={"/api/dep/overview/quota"}, method={RequestMethod.GET})
    public DepOverviewResponse overviewQuota(HttpServletRequest request) {
        DepOverviewResponse res = new DepOverviewResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomain(dep, domain);
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomain(org, domain);
        List priceGpuList = this.priceRepository.findByTypeAndDomainAndDeleted(Integer.valueOf(1), domain, Integer.valueOf(0));
        ArrayList<String> gpuType = new ArrayList<String>();
        for (Object price : priceGpuList) {
            if (gpuType.contains(price.getChargeItem())) continue;
            gpuType.add(price.getChargeItem());
        }
        if (null == depQuotas) {
            depQuotas = new DepQuotas();
            depQuotas.setOrganization(org);
            depQuotas.setDepartment(dep);
            depQuotas.setDomain(domain);
            depQuotas.setUserStorage(Integer.valueOf(-1));
            depQuotas.setCpuQuota(Integer.valueOf(-1));
            HashMap<String, Integer> depGpu = new HashMap<String, Integer>();
            for (String s : gpuType) {
                depGpu.put(s, -1);
            }
            depQuotas.setGpuQuota(JSONObject.fromObject(depGpu).toString());
            depQuotas.setMemoryQuota(Integer.valueOf(-1));
            depQuotas = (DepQuotas)this.depQuotasRepository.saveAndFlush((Object)depQuotas);
        }
        if (orgQuotas == null) {
            orgQuotas = new OrganizationQuotas();
            orgQuotas.setResourceCount(Integer.valueOf(-1));
            orgQuotas.setJobCount(Integer.valueOf(-1));
            orgQuotas.setModelCount(Integer.valueOf(-1));
            orgQuotas.setStorage(Integer.valueOf(100));
            orgQuotas.setCreatedAt(new Date());
            orgQuotas.setDeleted(Integer.valueOf(0));
            orgQuotas.setDomain(domain);
            orgQuotas.setStatus(domain.getStatus());
            orgQuotas.setGuid(UUID.randomUUID().toString().replaceAll("-", ""));
            orgQuotas.setOrganization(org);
            this.organizationQuotasRepository.save((Object)orgQuotas);
        }
        ArrayList<DepOverviewQuotasModel> quotas = new ArrayList<DepOverviewQuotasModel>();
        ArrayList<DepOverviewAllocationModel> allocations = new ArrayList<DepOverviewAllocationModel>();
        DepOverviewQuotasModel cpuQuotaNodel = new DepOverviewQuotasModel();
        cpuQuotaNodel.setType(Integer.valueOf(1));
        cpuQuotaNodel.setItem(this.messageUtil.getMessage("msg.cpu"));
        DepOverviewQuotasModel memoryQuotaNodel = new DepOverviewQuotasModel();
        memoryQuotaNodel.setType(Integer.valueOf(2));
        memoryQuotaNodel.setItem(this.messageUtil.getMessage("msg.memory"));
        DepOverviewQuotasModel storageQuotaNodel = new DepOverviewQuotasModel();
        storageQuotaNodel.setType(Integer.valueOf(3));
        storageQuotaNodel.setItem(this.messageUtil.getMessage("msg.storage"));
        if (null != depUsers && depUsers.getType() == 3) {
            DepOverviewAllocationModel resourceAllocationNodel = new DepOverviewAllocationModel();
            resourceAllocationNodel.setType(Integer.valueOf(0));
            DepOverviewAllocationModel jobAllocationModel = new DepOverviewAllocationModel();
            jobAllocationModel.setType(Integer.valueOf(1));
            DepOverviewAllocationModel serviceAllocationModel = new DepOverviewAllocationModel();
            serviceAllocationModel.setType(Integer.valueOf(2));
            DepOverviewAllocationModel automlAllocationModel = new DepOverviewAllocationModel();
            automlAllocationModel.setType(Integer.valueOf(3));
            if (null != depQuotas) {
                Long rUserDuration;
                Integer userCount;
                DecimalFormat df = new DecimalFormat("#.00");
                if (null != depQuotas.getResourceCount() && depQuotas.getResourceCount() != -1) {
                    userCount = this.resourceRepository.countByDepartmentIdAndDeletedAndDomainAndUser(depId, Integer.valueOf(0), domain, user);
                    resourceAllocationNodel.setCountQuota(depQuotas.getResourceCount());
                    resourceAllocationNodel.setCountUsed(userCount);
                }
                if (null != depQuotas.getResourceTime() && depQuotas.getResourceTime() != -1.0) {
                    rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(0), userId, depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                    if (rUserDuration == null) {
                        rUserDuration = 0L;
                    }
                    resourceAllocationNodel.setDurationQuota(depQuotas.getResourceTime());
                    resourceAllocationNodel.setDurationUsed(Double.valueOf(df.format((double)rUserDuration.longValue() / 3600.0)));
                }
                if (null != depQuotas.getJobCount() && depQuotas.getJobCount() != -1) {
                    userCount = this.jobRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user);
                    jobAllocationModel.setCountQuota(depQuotas.getJobCount());
                    jobAllocationModel.setCountUsed(userCount);
                }
                if (null != depQuotas.getJobTime() && depQuotas.getJobTime() != -1.0) {
                    rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(1), userId, depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                    if (rUserDuration == null) {
                        rUserDuration = 0L;
                    }
                    jobAllocationModel.setDurationQuota(depQuotas.getJobTime());
                    jobAllocationModel.setDurationUsed(Double.valueOf(df.format((double)rUserDuration.longValue() / 3600.0)));
                }
                if (null != depQuotas.getModelCount() && depQuotas.getModelTime() != -1.0) {
                    userCount = this.serviceRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user);
                    serviceAllocationModel.setCountQuota(depQuotas.getModelCount());
                    serviceAllocationModel.setCountUsed(userCount);
                }
                if (null != depQuotas.getModelTime() && depQuotas.getModelTime() != -1.0) {
                    rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(2), userId, depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                    if (rUserDuration == null) {
                        rUserDuration = 0L;
                    }
                    serviceAllocationModel.setDurationQuota(depQuotas.getModelTime());
                    serviceAllocationModel.setDurationUsed(Double.valueOf(df.format((double)rUserDuration.longValue() / 3600.0)));
                }
                if (null != depQuotas.getAutomlCount() && depQuotas.getAutomlCount() != -1) {
                    userCount = this.experimentRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user);
                    automlAllocationModel.setCountQuota(depQuotas.getAutomlCount());
                    automlAllocationModel.setCountUsed(userCount);
                }
                if (null != depQuotas.getAutomlTime() && depQuotas.getAutomlTime() != -1.0) {
                    List namespaces = this.experimentRepository.findGuidByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user);
                    Long rUserDuration2 = 0L;
                    if (null != namespaces && !namespaces.isEmpty() && (rUserDuration2 = this.referTrialDurationRepository.calculateByNamespaceIn(namespaces, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L))) == null) {
                        rUserDuration2 = 0L;
                    }
                    automlAllocationModel.setDurationQuota(depQuotas.getAutomlTime());
                    Double durationUsed = Double.valueOf(df.format((double)rUserDuration2.longValue() / 3600.0));
                    automlAllocationModel.setDurationUsed(Double.valueOf(Math.min(depQuotas.getAutomlTime(), durationUsed)));
                }
                allocations.add(resourceAllocationNodel);
                allocations.add(jobAllocationModel);
                allocations.add(serviceAllocationModel);
                allocations.add(automlAllocationModel);
            }
            int userStorageBuid = this.storageRepository.sumQuotaAllocatedByDepIdAndUserAndDomain(depId, user, domain);
            int userCpuBuild = 0;
            int userMemoryBuild = 0;
            HashMap<String, Integer> userGpuBuild = new HashMap<String, Integer>();
            List resources = this.resourceRepository.findBuildByDepIdAndDomainAndUser(dep.getId(), domain, user);
            for (Object r : resources) {
                if (r.getPack().getCpuNum() != null) {
                    userCpuBuild += r.getPack().getCpuNum() * r.getReplicas();
                }
                if (r.getPack().getMemoryNum() == null) continue;
                userMemoryBuild += r.getPack().getMemoryNum() * r.getReplicas();
            }
            List jobs = this.jobRepository.findBuildByDepAndDomainAndUser(dep, domain, user);
            for (Object r : jobs) {
                if (r.getCurrent().getPack().getCpuNum() != null) {
                    userCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getReplicas();
                }
                if (r.getCurrent().getPack().getMemoryNum() == null) continue;
                userMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getReplicas();
            }
            List services = this.serviceRepository.findBuildByDepAndDomainAndUser(dep, domain, user);
            for (Object r : services) {
                if (r.getCurrent().getPack().getCpuNum() != null) {
                    userCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getInstance();
                }
                if (r.getCurrent().getPack().getMemoryNum() == null) continue;
                userMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getInstance();
            }
            List experiments = this.experimentRepository.findBuildByDepAndDomainAndUser(dep, domain, user);
            for (Object r : experiments) {
                if (r.getJobVersion().getPack().getCpuNum() != null) {
                    userCpuBuild += r.getJobVersion().getPack().getCpuNum() * r.getJobVersion().getReplicas();
                }
                if (r.getJobVersion().getPack().getMemoryNum() == null) continue;
                userMemoryBuild += r.getJobVersion().getPack().getMemoryNum() * r.getJobVersion().getReplicas();
            }
            List annotations = this.annotationRepository.findBuildByDepAndDomainAndUser(dep, domain, user);
            for (Object r : annotations) {
                if (r.getPack().getCpuNum() != null) {
                    userCpuBuild += r.getPack().getCpuNum().intValue();
                }
                if (r.getPack().getMemoryNum() == null) continue;
                userMemoryBuild += r.getPack().getMemoryNum().intValue();
            }
            for (String s : gpuType) {
                int userGpuTypeBuild = 0;
                List pricePackageIds = this.pricePackageRepository.findIdsByGpuChargeItemAndDomain(s, domain);
                if (null != pricePackageIds && !pricePackageIds.isEmpty()) {
                    int gpuUsed;
                    resources = this.resourceRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(dep.getId(), domain, pricePackageIds, user);
                    for (Resource r : resources) {
                        if (r.getPack().getGpu() == null) continue;
                        gpuUsed = r.getPack().getGpuNum() * r.getReplicas();
                        if (r.getPack().getSlice() != null && r.getPack().getSlice() > 1) {
                            gpuUsed = r.getPack().getGpuNum();
                        }
                        userGpuTypeBuild += gpuUsed;
                    }
                    jobs = this.jobRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(dep, domain, pricePackageIds, user);
                    for (Resource r : jobs) {
                        if (r.getCurrent().getPack().getGpu() == null) continue;
                        gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas();
                        if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                            gpuUsed = r.getCurrent().getPack().getGpuNum();
                        }
                        userGpuTypeBuild += gpuUsed;
                    }
                    services = this.serviceRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(dep, domain, pricePackageIds, user);
                    for (Resource r : services) {
                        if (r.getCurrent().getPack().getGpu() == null) continue;
                        gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance();
                        if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                            gpuUsed = r.getCurrent().getPack().getGpuNum();
                        }
                        userGpuTypeBuild += gpuUsed;
                    }
                    experiments = this.experimentRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(dep, domain, pricePackageIds, user);
                    for (Resource r : experiments) {
                        if (r.getJobVersion().getPack().getGpu() == null) continue;
                        gpuUsed = r.getJobVersion().getPack().getGpuNum() * r.getJobVersion().getReplicas();
                        if (r.getJobVersion().getPack().getSlice() != null && r.getJobVersion().getPack().getSlice() > 1) {
                            gpuUsed = r.getJobVersion().getPack().getGpuNum();
                        }
                        userGpuTypeBuild += gpuUsed;
                    }
                    annotations = this.annotationRepository.findGpuBuildByDepAndDomainAndPriceIdInAndUser(dep, domain, pricePackageIds, user);
                    for (Resource r : annotations) {
                        if (r.getPack().getGpu() == null) continue;
                        gpuUsed = r.getPack().getGpuNum();
                        if (r.getPack().getSlice() != null && r.getPack().getSlice() > 1) {
                            gpuUsed = r.getPack().getGpuNum();
                        }
                        userGpuTypeBuild += gpuUsed;
                    }
                }
                userGpuBuild.put(s, userGpuTypeBuild);
            }
            DepUserQuotas userQuotas = this.depUserQuotasRepository.findByUserAndDepartmentAndDomain(user, dep, domain);
            HashMap gpuQuota = new HashMap();
            Map userGpuQuota = new HashMap();
            Map depGpuQuota = new HashMap();
            Map orgGpuQuota = new HashMap();
            if (null != userQuotas && !StringUtils.isEmpty((String)userQuotas.getGpuQuota())) {
                userGpuQuota = (Map)JSON.parseObject((String)userQuotas.getGpuQuota(), Map.class);
            }
            if (!StringUtils.isEmpty((String)depQuotas.getGpuQuota())) {
                depGpuQuota = (Map)JSON.parseObject((String)depQuotas.getGpuQuota(), Map.class);
            }
            if (orgQuotas != null && !StringUtils.isEmpty((String)orgQuotas.getGpuQuota())) {
                orgGpuQuota = (Map)JSON.parseObject((String)orgQuotas.getGpuQuota(), Map.class);
            }
            if (gpuQuota == null) {
                gpuQuota = new HashMap();
            }
            for (String s : gpuType) {
                if (userGpuQuota.get(s) != null && (Integer)userGpuQuota.get(s) != -1) {
                    gpuQuota.put(s, userGpuQuota.get(s));
                    continue;
                }
                if (depGpuQuota.get(s) != null && (Integer)depGpuQuota.get(s) != -1) {
                    gpuQuota.put(s, depGpuQuota.get(s));
                    continue;
                }
                if (orgGpuQuota.get(s) != null && (Integer)orgGpuQuota.get(s) != -1) {
                    gpuQuota.put(s, orgGpuQuota.get(s));
                    continue;
                }
                gpuQuota.put(s, -1);
            }
            if (null != userQuotas && null != userQuotas.getCpuQuota() && userQuotas.getCpuQuota() != -1) {
                cpuQuotaNodel.setQuotas(userQuotas.getCpuQuota());
            } else if (null != depQuotas.getCpuQuota() && depQuotas.getCpuQuota() != -1) {
                cpuQuotaNodel.setQuotas(depQuotas.getCpuQuota());
            } else if (null != orgQuotas.getCpuQuota() && orgQuotas.getCpuQuota() != -1) {
                cpuQuotaNodel.setQuotas(orgQuotas.getCpuQuota());
            } else {
                cpuQuotaNodel.setQuotas(Integer.valueOf(-1));
            }
            if (null != userQuotas && null != userQuotas.getMemoryQuota() && userQuotas.getMemoryQuota() != -1) {
                memoryQuotaNodel.setQuotas(userQuotas.getMemoryQuota());
            } else if (null != depQuotas.getMemoryQuota() && depQuotas.getMemoryQuota() != -1) {
                memoryQuotaNodel.setQuotas(depQuotas.getMemoryQuota());
            } else if (null != orgQuotas.getMemoryQuota() && orgQuotas.getMemoryQuota() != -1) {
                memoryQuotaNodel.setQuotas(orgQuotas.getMemoryQuota());
            } else {
                memoryQuotaNodel.setQuotas(Integer.valueOf(-1));
            }
            if (null != userQuotas && null != userQuotas.getStorage() && userQuotas.getStorage() != -1) {
                storageQuotaNodel.setQuotas(userQuotas.getStorage());
            } else if (null != depQuotas.getStorage() && depQuotas.getStorage() != -1) {
                storageQuotaNodel.setQuotas(depQuotas.getStorage());
            } else if (null != orgQuotas.getStorage() && orgQuotas.getStorage() != -1) {
                storageQuotaNodel.setQuotas(orgQuotas.getStorage());
            } else {
                storageQuotaNodel.setQuotas(Integer.valueOf(-1));
            }
            for (String s : gpuType) {
                DepOverviewQuotasModel gpuQuotasModel = new DepOverviewQuotasModel();
                gpuQuotasModel.setType(Integer.valueOf(0));
                gpuQuotasModel.setItem(s);
                gpuQuotasModel.setUsed((Integer)userGpuBuild.get(s));
                if (null != gpuQuota.get(s) && (Integer)gpuQuota.get(s) != -1) {
                    gpuQuotasModel.setQuotas((Integer)gpuQuota.get(s));
                    gpuQuotasModel.setRemain(Integer.valueOf(Math.max((Integer)gpuQuota.get(s) - (Integer)userGpuBuild.get(s), 0)));
                }
                quotas.add(gpuQuotasModel);
            }
            cpuQuotaNodel.setUsed(Integer.valueOf(userCpuBuild));
            if (null != cpuQuotaNodel.getQuotas() && cpuQuotaNodel.getQuotas() != -1) {
                cpuQuotaNodel.setRemain(Integer.valueOf(cpuQuotaNodel.getQuotas() - userCpuBuild));
            }
            memoryQuotaNodel.setUsed(Integer.valueOf(userMemoryBuild));
            if (null != memoryQuotaNodel.getQuotas() && memoryQuotaNodel.getQuotas() != -1) {
                memoryQuotaNodel.setRemain(Integer.valueOf(memoryQuotaNodel.getQuotas() - userMemoryBuild));
            }
            storageQuotaNodel.setUsed(Integer.valueOf(userStorageBuid));
            if (null != storageQuotaNodel.getQuotas() && storageQuotaNodel.getQuotas() != -1) {
                storageQuotaNodel.setRemain(Integer.valueOf(storageQuotaNodel.getQuotas() - userStorageBuid));
            }
            quotas.add(cpuQuotaNodel);
            quotas.add(memoryQuotaNodel);
            quotas.add(storageQuotaNodel);
        } else {
            int depStorageBuid = this.storageRepository.sumQuotaAllocatedByDepIdAndDomain(depId, domain);
            int depCpuBuild = 0;
            int depMemoryBuild = 0;
            HashMap<String, Integer> depGpuBuild = new HashMap<String, Integer>();
            List resources = this.resourceRepository.findBuildByDepIdAndDomain(dep.getId(), domain);
            for (Object r : resources) {
                if (r.getPack().getCpuNum() != null) {
                    depCpuBuild += r.getPack().getCpuNum() * r.getReplicas();
                }
                if (r.getPack().getMemoryNum() == null) continue;
                depMemoryBuild += r.getPack().getMemoryNum() * r.getReplicas();
            }
            List jobs = this.jobRepository.findBuildByDepAndDomain(dep, domain);
            for (Object r : jobs) {
                if (r.getCurrent().getPack().getCpuNum() != null) {
                    depCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getReplicas();
                }
                if (r.getCurrent().getPack().getMemoryNum() == null) continue;
                depMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getReplicas();
            }
            List services = this.serviceRepository.findBuildByDepAndDomain(dep, domain);
            for (Object r : services) {
                if (r.getCurrent().getPack().getCpuNum() != null) {
                    depCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getInstance();
                }
                if (r.getCurrent().getPack().getMemoryNum() == null) continue;
                depMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getInstance();
            }
            List experiments = this.experimentRepository.findBuildByDepAndDomain(dep, domain);
            for (Object r : experiments) {
                if (r.getJobVersion().getPack().getCpuNum() != null) {
                    depCpuBuild += r.getJobVersion().getPack().getCpuNum() * r.getJobVersion().getReplicas();
                }
                if (r.getJobVersion().getPack().getMemoryNum() == null) continue;
                depMemoryBuild += r.getJobVersion().getPack().getMemoryNum() * r.getJobVersion().getReplicas();
            }
            List annotations = this.annotationRepository.findBuildByDepAndDomain(dep, domain);
            for (Object r : annotations) {
                if (r.getPack().getCpuNum() != null) {
                    depCpuBuild += r.getPack().getCpuNum().intValue();
                }
                if (r.getPack().getMemoryNum() == null) continue;
                depMemoryBuild += r.getPack().getMemoryNum().intValue();
            }
            for (String s : gpuType) {
                int depGpuTypeBuild = 0;
                List pricePackageIds = this.pricePackageRepository.findIdsByGpuChargeItemAndDomain(s, domain);
                if (null != pricePackageIds && !pricePackageIds.isEmpty()) {
                    int gpuUsed;
                    resources = this.resourceRepository.findGpuBuildByDepIdAndDomainAndPriceIdIn(dep.getId(), domain, pricePackageIds);
                    for (Resource r : resources) {
                        if (r.getPack().getGpu() == null) continue;
                        gpuUsed = r.getPack().getGpuNum() * r.getReplicas();
                        if (r.getPack().getSlice() != null && r.getPack().getSlice() > 1) {
                            gpuUsed = r.getPack().getGpuNum();
                        }
                        depGpuTypeBuild += gpuUsed;
                    }
                    jobs = this.jobRepository.findGpuBuildByDepIdAndDomainAndPriceIdIn(dep, domain, pricePackageIds);
                    for (Resource r : jobs) {
                        if (r.getCurrent().getPack().getGpu() == null) continue;
                        gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas();
                        if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                            gpuUsed = r.getCurrent().getPack().getGpuNum();
                        }
                        depGpuTypeBuild += gpuUsed;
                    }
                    services = this.serviceRepository.findGpuBuildByDepIdAndDomainAndPriceIdIn(dep, domain, pricePackageIds);
                    for (Resource r : services) {
                        if (r.getCurrent().getPack().getGpu() == null) continue;
                        gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance();
                        if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                            gpuUsed = r.getCurrent().getPack().getGpuNum();
                        }
                        depGpuTypeBuild += gpuUsed;
                    }
                    experiments = this.experimentRepository.findGpuBuildByDepIdAndDomainAndPriceIdIn(dep, domain, pricePackageIds);
                    for (Resource r : experiments) {
                        if (r.getJobVersion().getPack().getGpu() == null) continue;
                        gpuUsed = r.getJobVersion().getPack().getGpuNum() * r.getJobVersion().getReplicas();
                        if (r.getJobVersion().getPack().getSlice() != null && r.getJobVersion().getPack().getSlice() > 1) {
                            gpuUsed = r.getJobVersion().getPack().getGpuNum();
                        }
                        depGpuTypeBuild += gpuUsed;
                    }
                    annotations = this.annotationRepository.findGpuBuildByDepAndDomainAndPriceIdIn(dep, domain, pricePackageIds);
                    for (Resource r : annotations) {
                        if (r.getPack().getGpu() == null) continue;
                        gpuUsed = r.getPack().getGpuNum();
                        if (r.getPack().getSlice() != null && r.getPack().getSlice() > 1) {
                            gpuUsed = r.getPack().getGpuNum();
                        }
                        depGpuTypeBuild += gpuUsed;
                    }
                }
                depGpuBuild.put(s, depGpuTypeBuild);
            }
            HashMap<String, Integer> gpuQuota = new HashMap<String, Integer>();
            Map depGpuQuota = new HashMap();
            Map orgGpuQuota = new HashMap();
            if (!StringUtils.isEmpty((String)depQuotas.getGpuQuota())) {
                depGpuQuota = (Map)JSON.parseObject((String)depQuotas.getGpuQuota(), Map.class);
            }
            if (!StringUtils.isEmpty((String)orgQuotas.getGpuQuota())) {
                orgGpuQuota = (Map)JSON.parseObject((String)orgQuotas.getGpuQuota(), Map.class);
            }
            if (gpuQuota == null) {
                gpuQuota = new HashMap();
            }
            for (String s : gpuType) {
                if (!StringUtils.isEmpty((String)String.valueOf(depGpuQuota.get(s))) && Integer.valueOf(String.valueOf(depGpuQuota.get(s))) != -1) {
                    gpuQuota.put(s, Integer.valueOf(String.valueOf(depGpuQuota.get(s))));
                    continue;
                }
                if (!StringUtils.isEmpty((String)String.valueOf(orgGpuQuota.get(s))) && Integer.valueOf(String.valueOf(orgGpuQuota.get(s))) != -1) {
                    gpuQuota.put(s, Integer.valueOf(String.valueOf(orgGpuQuota.get(s))));
                    continue;
                }
                gpuQuota.put(s, -1);
            }
            if (null != depQuotas.getCpuQuota() && depQuotas.getCpuQuota() != -1) {
                cpuQuotaNodel.setQuotas(depQuotas.getCpuQuota());
            } else if (null != orgQuotas.getCpuQuota() && orgQuotas.getCpuQuota() != -1) {
                cpuQuotaNodel.setQuotas(orgQuotas.getCpuQuota());
            } else {
                cpuQuotaNodel.setQuotas(Integer.valueOf(-1));
            }
            if (null != depQuotas.getMemoryQuota() && depQuotas.getMemoryQuota() != -1) {
                memoryQuotaNodel.setQuotas(depQuotas.getMemoryQuota());
            } else if (null != orgQuotas.getMemoryQuota() && orgQuotas.getMemoryQuota() != -1) {
                memoryQuotaNodel.setQuotas(orgQuotas.getMemoryQuota());
            } else {
                memoryQuotaNodel.setQuotas(Integer.valueOf(-1));
            }
            if (null != depQuotas.getStorage() && depQuotas.getStorage() != -1) {
                storageQuotaNodel.setQuotas(depQuotas.getStorage());
            } else if (null != orgQuotas.getStorage() && orgQuotas.getStorage() != -1) {
                storageQuotaNodel.setQuotas(orgQuotas.getStorage());
            } else {
                storageQuotaNodel.setQuotas(Integer.valueOf(-1));
            }
            for (String s : gpuType) {
                DepOverviewQuotasModel gpuQuotasModel = new DepOverviewQuotasModel();
                gpuQuotasModel.setType(Integer.valueOf(0));
                gpuQuotasModel.setItem(s);
                gpuQuotasModel.setUsed((Integer)depGpuBuild.get(s));
                if (!StringUtils.isEmpty((String)String.valueOf(gpuQuota.get(s))) && Integer.valueOf(String.valueOf(gpuQuota.get(s))) != -1) {
                    Integer value = Integer.valueOf(String.valueOf(gpuQuota.get(s)));
                    gpuQuotasModel.setQuotas(value);
                    gpuQuotasModel.setRemain(Integer.valueOf(Math.max(value - (Integer)depGpuBuild.get(s), 0)));
                }
                quotas.add(gpuQuotasModel);
            }
            cpuQuotaNodel.setUsed(Integer.valueOf(depCpuBuild));
            if (null != cpuQuotaNodel.getQuotas() && cpuQuotaNodel.getQuotas() != -1) {
                cpuQuotaNodel.setRemain(Integer.valueOf(cpuQuotaNodel.getQuotas() - depCpuBuild));
            }
            memoryQuotaNodel.setUsed(Integer.valueOf(depMemoryBuild));
            if (null != memoryQuotaNodel.getQuotas() && memoryQuotaNodel.getQuotas() != -1) {
                memoryQuotaNodel.setRemain(Integer.valueOf(memoryQuotaNodel.getQuotas() - depMemoryBuild));
            }
            storageQuotaNodel.setUsed(Integer.valueOf(depStorageBuid));
            if (null != storageQuotaNodel.getQuotas() && storageQuotaNodel.getQuotas() != -1) {
                storageQuotaNodel.setRemain(Integer.valueOf(storageQuotaNodel.getQuotas() - depStorageBuid));
            }
            quotas.add(cpuQuotaNodel);
            quotas.add(memoryQuotaNodel);
            quotas.add(storageQuotaNodel);
        }
        res.setQuotas(quotas);
        res.setAllocations(allocations);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u603b\u89c8-\u5b58\u50a8\u4f7f\u7528\u91cf\u7edf\u8ba1", notes="v3.3\u65b0\u589e")
    @Transactional
    @RequestMapping(value={"/api/dep/overview/storage"}, method={RequestMethod.POST})
    public ListResultResponse<StorageUsageModel> overviewStorage(@RequestBody @Valid DepStorageInfoRequest dto, HttpServletRequest request) throws Exception {
        Long depId;
        OrgConfigDepartment dep;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depOwner = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)(depId = (Long)session.getAttribute("departmentId"))));
        if (depOwner != null && depOwner.getType() == 3) {
            return res;
        }
        List dus = this.depUsersRepository.findByDepartment(dep);
        ArrayList<StorageUsageModel> list = new ArrayList<StorageUsageModel>();
        if (dus != null && dus.size() > 0) {
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            for (DepUsers du : dus) {
                User storageUser = du.getUser();
                StorageUsageModel model = new StorageUsageModel();
                model.setUserId(storageUser.getId());
                model.setUsername(storageUser.getUsername());
                model.setFullName(storageUser.getName() == null ? storageUser.getUsername() : storageUser.getName());
                Integer capacity = 0;
                float used = 0.0f;
                List userStorageList = this.storageRepository.findByUserAndDepartmentAndDeleted(storageUser, dep, Integer.valueOf(0));
                if (userStorageList != null && !userStorageList.isEmpty()) {
                    for (Storage storage : userStorageList) {
                        if (storage.getName().equals(storage.getGuid()) && !storage.getUser().getOrganization().getId().equals(dep.getOrgConfig().getOrganization().getId())) continue;
                        capacity = capacity + storage.getCapacity();
                        String volumeUsed = this.storageServiceFactory.getVolumeUsed(storage, k8sFactory);
                        used += Float.parseFloat(volumeUsed == null ? "0" : volumeUsed);
                    }
                }
                model.setCapacity(capacity);
                model.setUsed(SizeConverter.convertBytes((float)used, (boolean)true));
                list.add(model);
            }
        }
        if (dto.getUsedSort() != null && dto.getUsedSort() == 1) {
            list.sort(Comparator.comparing(StorageUsageModel::getUsed));
        } else {
            list.sort((a1, a2) -> a2.getUsed().compareTo(a1.getUsed()));
        }
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    public static boolean isDepPermission(String permission, Long depId) {
        Subject subject = SecurityUtils.getSubject();
        return subject.isPermitted(permission + ":" + depId);
    }

    public static boolean isMemberDepPermission(Integer level, Boolean isMine, String permission, Long depId) {
        Subject subject = SecurityUtils.getSubject();
        if (level == null) {
            level = 3;
        }
        if (level == 3) {
            if (!isMine.booleanValue()) {
                return false;
            }
            subject.isPermitted(permission + ":" + depId);
        } else if (level == 2) {
            if (isMine.booleanValue()) {
                return true;
            }
            subject.isPermitted(permission + ":" + depId);
        } else {
            return true;
        }
        return subject.isPermitted(permission + ":" + depId);
    }

    Integer getDepUserLevel(User user, OrgConfigDepartment department) {
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, department);
        Integer level = 3;
        if (depUsers == null) {
            return level;
        }
        level = depUsers.getType();
        if (level == null) {
            level = 3;
        }
        return level;
    }

    @Transactional
    public void resourceSchedule() {
        Date now = new Date();
        List rDepQuotasList = this.depQuotasRepository.getScheduledResource();
        if (null != rDepQuotasList && rDepQuotasList.size() > 0) {
            for (DepQuotas depQuota : rDepQuotasList) {
                List usersList = this.depUsersRepository.findUserByDep(depQuota.getDepartment());
                if (null == usersList || usersList.size() <= 0) continue;
                try {
                    K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)depQuota.getDomain().getId());
                    AppsV1Api appsV1Api = k8sFactory.appsV1Api;
                    for (User user : usersList) {
                        List resourceStopList;
                        Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(0), user.getId(), depQuota.getDepartment().getId(), depQuota.getDomain().getId(), Long.valueOf(depQuota.getTimeStart().getTime() / 1000L));
                        if (rUserDuration == null) {
                            rUserDuration = 0L;
                        }
                        if (!((double)rUserDuration.longValue() >= depQuota.getResourceTime() * 60.0 * 60.0) || (resourceStopList = this.resourceRepository.findStopResource(depQuota.getDomain(), user, depQuota.getDepartment().getId())) == null || resourceStopList.isEmpty()) continue;
                        for (Resource resource : resourceStopList) {
                            List durations;
                            List expansions;
                            V1Patch array = new V1Patch("[{\"op\": \"replace\", \"path\": \"/spec/replicas\",\"value\": 0}]");
                            appsV1Api.patchNamespacedDeployment("deploy-resource", resource.getGuid(), array, null, null, null, null);
                            if (resource.getReplicas() > 1) {
                                if (resource.getImage().contains("horovod")) {
                                    appsV1Api.patchNamespacedStatefulSet("mnist-horovod", resource.getGuid(), array, null, null, null, null);
                                } else {
                                    appsV1Api.patchNamespacedDeployment("deploy-worker", resource.getGuid(), array, null, null, null, null);
                                }
                            }
                            resource.setStatus(Integer.valueOf(3));
                            resource.setErrorMessage(this.messageSource.getMessage("msg.time.used.up", null, null));
                            OperationLog log = new OperationLog();
                            OrgConfigDepartment dep = resource.getDepartment();
                            log.setDepartment(dep);
                            log.setOrganization(dep.getOrgConfig().getOrganization());
                            log.setDomain(resource.getDomain());
                            log.setUsername(this.messageSource.getMessage("msg.system", null, null));
                            log.setResourceGuid(resource.getGuid());
                            log.setResourceName(resource.getName());
                            log.setResourceType(Integer.valueOf(0));
                            log.setDuration(Long.valueOf(new Date().getTime() - now.getTime()));
                            log.setRes(Constants.SC_OK);
                            log.setCreatedAt(new Date());
                            log.setContent(this.messageUtil.getMessageJson("msg.reclaim.auto"));
                            this.operationLogRepository.save((Object)log);
                            if (null != resource.getMLabProject()) {
                                MLabProject mLabProject = resource.getMLabProject();
                                mLabProject.setStatus(Integer.valueOf(0));
                            }
                            resource.setReclaimedAt(now);
                            List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0));
                            if (null != materials && !materials.isEmpty()) {
                                for (Materials material : materials) {
                                    material.setLastedAt(now);
                                    material.setOperation(null);
                                }
                            }
                            if ((expansions = resource.getExpansions()) != null) {
                                Materials material;
                                material = expansions.iterator();
                                while (material.hasNext()) {
                                    ResourceExpansion expansion = (ResourceExpansion)material.next();
                                    if (expansion.getStatus() == null || expansion.getStatus() != 0) continue;
                                    expansion.setStatus(Integer.valueOf(-1));
                                }
                            }
                            if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(resource.getId(), Integer.valueOf(0))) != null) {
                                for (ReferDuration duration : durations) {
                                    duration.setEnd(now);
                                }
                            }
                            this.resourceRepository.save((Object)resource);
                        }
                    }
                }
                catch (ApiException e) {
                    logger.error(e.getResponseBody(), (Throwable)e);
                }
            }
        }
    }

    @Transactional
    public void jobSchedule() {
        List jDepQuotasList = this.depQuotasRepository.getScheduledJob();
        if (null != jDepQuotasList && jDepQuotasList.size() > 0) {
            Date now = new Date();
            for (DepQuotas depQuota : jDepQuotasList) {
                List usersList = this.depUsersRepository.findUserByDep(depQuota.getDepartment());
                if (null == usersList || usersList.size() <= 0) continue;
                try {
                    K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)depQuota.getDomain().getId());
                    for (User user : usersList) {
                        List joblist;
                        Long jUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(1), user.getId(), depQuota.getDepartment().getId(), depQuota.getDomain().getId(), Long.valueOf(depQuota.getTimeStart().getTime() / 1000L));
                        if (jUserDuration == null) {
                            jUserDuration = 0L;
                        }
                        if (!((double)jUserDuration.longValue() >= depQuota.getJobTime() * 60.0 * 60.0) || (joblist = this.jobRepository.findByDomainAndDepartmentAndUserAndDeleted(depQuota.getDomain(), depQuota.getDepartment(), user, Integer.valueOf(0))) == null || joblist.isEmpty()) continue;
                        for (Job job : joblist) {
                            List versions = this.jobVersionRepository.getByJobAndDeletedAndStatusNot(job, Integer.valueOf(0), Integer.valueOf(3));
                            if (versions == null) continue;
                            for (JobVersion version : versions) {
                                if (version.getStatus() != 1 && version.getStatus() != -9) continue;
                                version.setStatus(Integer.valueOf(3));
                                version.setErrorMessage(this.messageSource.getMessage("msg.time.used.up", null, null));
                                version.setStopAt(now);
                                OperationLog log = new OperationLog();
                                log.setDepartment(version.getJob().getDepartment());
                                log.setOrganization(version.getJob().getDepartment().getOrgConfig().getOrganization());
                                log.setDomain(version.getJob().getDomain());
                                log.setUsername(this.messageSource.getMessage("msg.system", null, null));
                                log.setResourceGuid(version.getGuid());
                                log.setResourceName(version.getName());
                                log.setResourceType(Integer.valueOf(1));
                                log.setDuration(Long.valueOf(new Date().getTime() - now.getTime()));
                                log.setRes(Constants.SC_OK);
                                log.setCreatedAt(new Date());
                                log.setContent(this.messageUtil.getMessageJson("msg.stop.auto"));
                                this.operationLogRepository.save((Object)log);
                                List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(version.getId(), Integer.valueOf(1));
                                if (null != materials) {
                                    for (Materials material : materials) {
                                        material.setLastedAt(now);
                                        material.setOperation(null);
                                    }
                                }
                                k8sFactory.deleteNamespace(version.getGuid());
                                List durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(version.getId(), Integer.valueOf(1));
                                if (durations == null) continue;
                                for (ReferDuration duration : durations) {
                                    duration.setEnd(now);
                                }
                            }
                        }
                    }
                }
                catch (ApiException e) {
                    logger.error(e.getResponseBody());
                }
            }
        }
    }

    @Transactional
    public void modelSchedule() {
        Date now = new Date();
        List sDepQuotasList = this.depQuotasRepository.getScheduledService();
        if (null != sDepQuotasList && sDepQuotasList.size() > 0) {
            for (DepQuotas depQuota : sDepQuotasList) {
                List usersList = this.depUsersRepository.findUserByDep(depQuota.getDepartment());
                if (null == usersList || usersList.size() <= 0) continue;
                for (User user : usersList) {
                    List serviceStopList;
                    Long sUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(2), user.getId(), depQuota.getDepartment().getId(), depQuota.getDomain().getId(), Long.valueOf(depQuota.getTimeStart().getTime() / 1000L));
                    if (sUserDuration == null) {
                        sUserDuration = 0L;
                    }
                    if (!((double)sUserDuration.longValue() >= depQuota.getModelTime() * 60.0 * 60.0) || (serviceStopList = this.serviceRepository.findStopService(depQuota.getDomain(), user, depQuota.getDepartment())) == null || serviceStopList.isEmpty()) continue;
                    for (Service service : serviceStopList) {
                        List durations;
                        ServiceDeployRecord current = service.getCurrent();
                        current.setStatus(Integer.valueOf(-2));
                        current.setErrorMessage(this.messageSource.getMessage("msg.time.used.up", null, null));
                        OperationLog log = new OperationLog();
                        log.setDepartment(service.getDepartment());
                        log.setOrganization(service.getDepartment().getOrgConfig().getOrganization());
                        log.setDomain(service.getDomain());
                        log.setUsername(this.messageSource.getMessage("msg.system", null, null));
                        log.setResourceGuid(service.getCurrent().getGuid());
                        log.setResourceName(service.getName());
                        log.setResourceType(Integer.valueOf(5));
                        log.setDuration(Long.valueOf(new Date().getTime() - now.getTime()));
                        log.setRes(Constants.SC_OK);
                        log.setCreatedAt(new Date());
                        log.setContent(this.messageUtil.getMessageJson("msg.stop.auto"));
                        this.operationLogRepository.save((Object)log);
                        List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(service.getId(), Integer.valueOf(3));
                        if (null != materials) {
                            for (Object material : materials) {
                                material.setLastedAt(now);
                                material.setOperation(null);
                            }
                        }
                        if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(service.getId(), Integer.valueOf(2))) != null) {
                            Object material;
                            material = durations.iterator();
                            while (material.hasNext()) {
                                ReferDuration duration = (ReferDuration)material.next();
                                duration.setEnd(now);
                            }
                        }
                        if (current.getDuration() != null && current.getDuration() > 0) {
                            try {
                                TriggerKey triggerKey = TriggerKey.triggerKey((String)current.getInference());
                                if (this.scheduler.checkExists(triggerKey)) {
                                    this.scheduler.unscheduleJob(triggerKey);
                                }
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            GenericKubernetesApi inferenceServiceApi = FactoryCollection.k8sFactory((Long)service.getDomain().getId()).inferenceServiceApi;
                            inferenceServiceApi.delete(current.getGuid(), current.getInference());
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    @Transactional
    public void automlSchedule() {
        Date now = new Date();
        List rDepQuotasList = this.depQuotasRepository.getScheduledAutoml();
        if (null != rDepQuotasList && rDepQuotasList.size() > 0) {
            for (DepQuotas depQuota : rDepQuotasList) {
                List usersList = this.depUsersRepository.findUserByDep(depQuota.getDepartment());
                if (null == usersList || usersList.size() <= 0) continue;
                try {
                    for (User user : usersList) {
                        List experiments;
                        List namespaces = this.experimentRepository.findGuidByDepartmentAndDomainAndUser(depQuota.getDepartment(), depQuota.getDomain(), user);
                        Long rUserDuration = 0L;
                        if (null != namespaces && !namespaces.isEmpty()) {
                            rUserDuration = this.referTrialDurationRepository.calculateByNamespaceIn(namespaces, Long.valueOf(depQuota.getTimeStart().getTime() / 1000L));
                        }
                        if (rUserDuration == null) {
                            rUserDuration = 0L;
                        }
                        if (!((double)rUserDuration.longValue() >= depQuota.getResourceTime() * 60.0 * 60.0) || (experiments = this.experimentRepository.findWorkExperiment(depQuota.getDomain(), user, depQuota.getDepartment())) == null || experiments.isEmpty()) continue;
                        for (Experiment experiment : experiments) {
                            List durations;
                            experiment.setStopAt(now);
                            try {
                                FactoryCollection.k8sFactory((Long)experiment.getDomain().getId()).experimentApi.delete(experiment.getGuid(), "exp").throwsApiException();
                                experiment.setStatus(Integer.valueOf(3));
                                List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(experiment.getId(), Integer.valueOf(6));
                                for (Materials material : materials) {
                                    material.setLastedAt(now);
                                }
                            }
                            catch (ApiException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                            if ((durations = this.referTrialDurationRepository.findByNamespaceAndEndIsNull(experiment.getGuid())) == null) continue;
                            for (ReferTrialDuration duration : durations) {
                                duration.setEnd(now);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @ConstructorProperties(value={"userRepository", "accountInviteRepository", "accountUserRegisterRepository", "depUsersRepository", "orgConfigDepartmentRepository", "orgConfigRepository", "resourceRepository", "jobRepository", "serviceRepository", "storageRepository", "materialsRepository", "paymentRepository", "permissionRepository", "depPermissionRepository", "accountController", "orgConfigDepPackageRepository", "pricePackageRepository", "noticeUserService", "accountNoticePushRepository", "organizationRepository", "harborProjectRepository", "balancesRepository", "annotationRepository", "organizationQuotasRepository", "domainRepository", "depQuotasRepository", "referDurationRepository", "jobVersionRepository", "jobParamsRepository", "modelRepository", "modelVersionRepository", "scheduler", "priceRepository", "depUserQuotasRepository", "quotasRepository", "operationLogRepository", "messageSource", "experimentRepository", "referTrialDurationRepository", "accountService", "messageUtil", "storageServiceFactory"})
    public DepartmentController(UserRepository userRepository, AccountInviteRepository accountInviteRepository, AccountUserRegisterRepository accountUserRegisterRepository, DepUsersRepository depUsersRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, OrgConfigRepository orgConfigRepository, ResourceRepository resourceRepository, JobRepository jobRepository, ServiceRepository serviceRepository, StorageRepository storageRepository, MaterialsRepository materialsRepository, PaymentRepository paymentRepository, PermissionRepository permissionRepository, DepPermissionRepository depPermissionRepository, AccountController accountController, OrgConfigDepPackageRepository orgConfigDepPackageRepository, PricePackageRepository pricePackageRepository, NoticeUserService noticeUserService, AccountNoticePushRepository accountNoticePushRepository, OrganizationRepository organizationRepository, HarborProjectRepository harborProjectRepository, BalancesRepository balancesRepository, AnnotationRepository annotationRepository, OrganizationQuotasRepository organizationQuotasRepository, DomainRepository domainRepository, DepQuotasRepository depQuotasRepository, ReferDurationRepository referDurationRepository, JobVersionRepository jobVersionRepository, JobParamsRepository jobParamsRepository, ModelRepository modelRepository, ModelVersionRepository modelVersionRepository, Scheduler scheduler, PriceRepository priceRepository, DepUserQuotasRepository depUserQuotasRepository, OrganizationQuotasRepository quotasRepository, OperationLogRepository operationLogRepository, MessageSource messageSource, ExperimentRepository experimentRepository, ReferTrialDurationRepository referTrialDurationRepository, AccountService accountService, MessageUtil messageUtil, StorageServiceFactory storageServiceFactory) {
        this.userRepository = userRepository;
        this.accountInviteRepository = accountInviteRepository;
        this.accountUserRegisterRepository = accountUserRegisterRepository;
        this.depUsersRepository = depUsersRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.orgConfigRepository = orgConfigRepository;
        this.resourceRepository = resourceRepository;
        this.jobRepository = jobRepository;
        this.serviceRepository = serviceRepository;
        this.storageRepository = storageRepository;
        this.materialsRepository = materialsRepository;
        this.paymentRepository = paymentRepository;
        this.permissionRepository = permissionRepository;
        this.depPermissionRepository = depPermissionRepository;
        this.accountController = accountController;
        this.orgConfigDepPackageRepository = orgConfigDepPackageRepository;
        this.pricePackageRepository = pricePackageRepository;
        this.noticeUserService = noticeUserService;
        this.accountNoticePushRepository = accountNoticePushRepository;
        this.organizationRepository = organizationRepository;
        this.harborProjectRepository = harborProjectRepository;
        this.balancesRepository = balancesRepository;
        this.annotationRepository = annotationRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.domainRepository = domainRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.referDurationRepository = referDurationRepository;
        this.jobVersionRepository = jobVersionRepository;
        this.jobParamsRepository = jobParamsRepository;
        this.modelRepository = modelRepository;
        this.modelVersionRepository = modelVersionRepository;
        this.scheduler = scheduler;
        this.priceRepository = priceRepository;
        this.depUserQuotasRepository = depUserQuotasRepository;
        this.quotasRepository = quotasRepository;
        this.operationLogRepository = operationLogRepository;
        this.messageSource = messageSource;
        this.experimentRepository = experimentRepository;
        this.referTrialDurationRepository = referTrialDurationRepository;
        this.accountService = accountService;
        this.messageUtil = messageUtil;
        this.storageServiceFactory = storageServiceFactory;
    }
}

