/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainConfigValueRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.ExperimentRepository;
import com.mopaas.server.dao.K8sEngineRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.ReferTrialDurationRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.DomainConfigValue;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.User;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.model.request.ReferDurationRequest;
import com.mopaas.server.model.request.ReferStorageRequest;
import com.mopaas.server.model.response.DomainModel;
import com.mopaas.server.model.response.DomainResourceModel;
import com.mopaas.server.model.response.ListDomainResourceResultResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.ReferDurationModel;
import com.mopaas.server.model.response.ReferStorageModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.CommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u533a\u57df\u63a5\u53e3")
@RestController
public class DomainController {
    final OrgConfigDepartmentRepository departmentRepository;
    final OrganizationQuotasRepository quotasRepository;
    final UserRepository userRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DepUsersRepository depUsersRepository;
    final ReferDurationRepository referDurationRepository;
    final DomainRepository domainRepository;
    final StorageRepository storageRepository;
    final K8sEngineRepository k8sEngineRepository;
    final ReferTrialDurationRepository referTrialDurationRepository;
    final ExperimentRepository experimentRepository;
    final MessageUtil messageUtil;
    final StorageServiceFactory storageServiceFactory;
    final CommonService commonService;
    final DomainConfigValueRepository domainConfigValueRepository;

    @ApiOperation(value="\u83b7\u53d6\u533a\u57df\u5217\u8868")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/domain/list"})
    public ListResultResponse<DomainModel> list(HttpServletRequest request) {
        Organization org;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId != null) {
            OrgConfigDepartment department = (OrgConfigDepartment)this.departmentRepository.findOne((Serializable)depId);
            if (null != department && department.getDeleted() != 1) {
                org = department.getOrgConfig().getOrganization();
            } else {
                User user = (User)this.userRepository.findOne((Serializable)userId);
                org = user.getOrganization();
            }
        } else {
            User user = (User)this.userRepository.findOne((Serializable)userId);
            org = user.getOrganization();
        }
        List quotas = this.quotasRepository.findByOrganizationAndStatus(org, Integer.valueOf(1));
        if (null != quotas && !quotas.isEmpty()) {
            HashSet<DomainModel> sets = new HashSet<DomainModel>();
            for (OrganizationQuotas quota : quotas) {
                Domain domain;
                if (quota.getDeleted() != null && quota.getDeleted() == 1 || (domain = quota.getDomain()).getDeleted() == 1 || domain.getStatus() == 0) continue;
                DomainModel model = new DomainModel();
                BeanUtils.copyProperties((Object)domain, (Object)model);
                DomainConfigValue serviceAddr = this.domainConfigValueRepository.findByKeyNameAndDomainId("ai.service.address", domain.getId());
                model.setServiceAddr(serviceAddr.getValue());
                sets.add(model);
            }
            res.setList(new ArrayList(sets));
        }
        return res;
    }

    @ApiOperation(value="\u8d44\u6e90\u4f7f\u7528\u65f6\u957f\u7edf\u8ba1", notes="v3.3\u4fee\u6539\uff0c\u4f20\u53c2type\u65b0\u589e\u7c7b\u578b3\uff1a\u8d85\u53c2\u8c03\u4f18")
    @Transactional(readOnly=true)
    @PostMapping(value={"api/reference/statistics"})
    public ResultResponse referDuration(@RequestBody @Valid ReferDurationRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        Long depId = dto.getDepId();
        if (depId == null || depId < 1L) {
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getDepId());
        DepUsers depUser = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)dto.getDomain());
        ArrayList<ReferDurationModel> list = new ArrayList<ReferDurationModel>();
        if (null != depUser && depUser.getType() != 3) {
            List users = dep.getUsers();
            if (null != users && !users.isEmpty()) {
                for (User user1 : users) {
                    List namespaces;
                    DepUsers du = this.depUsersRepository.findByUserAndDepartment(user1, dep);
                    ReferDurationModel model = new ReferDurationModel();
                    if (null == du) {
                        model.setQuited(Integer.valueOf(1));
                    } else {
                        model.setQuited(Integer.valueOf(0));
                    }
                    model.setName(user1.getName());
                    model.setUsername(user1.getUsername());
                    Long totalSeconds = dto.getType() == 3 ? (null != (namespaces = this.experimentRepository.findGuidByDepartmentAndDomainAndUser(dep, domain, user1)) && !namespaces.isEmpty() ? this.referTrialDurationRepository.sumByNamespaceIn(namespaces, dto.getBegin(), dto.getEnd()) : Long.valueOf(0L)) : this.referDurationRepository.sumByReferTypeAndUserAndDepAndDomain(dto.getType(), user1.getId(), dto.getDepId(), dto.getDomain(), dto.getBegin(), dto.getEnd());
                    totalSeconds = totalSeconds == null || totalSeconds < 0L ? 0L : totalSeconds;
                    model.setTotalSeconds(totalSeconds);
                    model.setDuration(TimeUtil.duration((Long)totalSeconds));
                    list.add(model);
                }
                if (dto.getSort() == 0) {
                    list.sort((o1, o2) -> (int)(o2.getTotalSeconds() - o1.getTotalSeconds()));
                } else {
                    list.sort((o1, o2) -> (int)(o1.getTotalSeconds() - o2.getTotalSeconds()));
                }
            }
        } else {
            List namespaces;
            Long totalSeconds = dto.getType() == 3 ? (null != (namespaces = this.experimentRepository.findGuidByDepartmentAndDomainAndUser(dep, domain, user)) && !namespaces.isEmpty() ? this.referTrialDurationRepository.sumByNamespaceIn(namespaces, dto.getBegin(), dto.getEnd()) : Long.valueOf(0L)) : this.referDurationRepository.sumByReferTypeAndUserAndDepAndDomain(dto.getType(), userId, dto.getDepId(), dto.getDomain(), dto.getBegin(), dto.getEnd());
            totalSeconds = totalSeconds == null || totalSeconds < 0L ? 0L : totalSeconds;
            ReferDurationModel model = new ReferDurationModel();
            model.setName(user.getName());
            model.setUsername(user.getUsername());
            model.setTotalSeconds(totalSeconds);
            model.setDuration(TimeUtil.duration((Long)totalSeconds));
            list.add(model);
        }
        res.setList(list);
        return res;
    }

    @ApiOperation(value="\u5b58\u50a8\u8d44\u6e90\u4f7f\u7528\u7edf\u8ba1")
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/storage/statistics"})
    public ResultResponse referStorage(@RequestBody @Valid ReferStorageRequest dto, HttpServletRequest request) throws Exception {
        ListResultResponse res = new ListResultResponse();
        Long depId = dto.getDepId();
        if (depId == null || depId < 1L) {
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = dto.getDomain();
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getDepId());
        DepUsers depUser = this.depUsersRepository.findByUserAndDepartment(user, dep);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        ArrayList<ReferStorageModel> list = new ArrayList<ReferStorageModel>();
        if (null != depUser && depUser.getType() != 3) {
            List users = dep.getUsers();
            if (null != users && !users.isEmpty()) {
                for (User user1 : users) {
                    long used = 0L;
                    DepUsers du = this.depUsersRepository.findByUserAndDepartment(user1, dep);
                    ReferStorageModel model = new ReferStorageModel();
                    if (null == du) {
                        model.setQuited(Integer.valueOf(1));
                    } else {
                        model.setQuited(Integer.valueOf(0));
                    }
                    model.setName(user1.getName());
                    model.setUsername(user1.getUsername());
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date begin = format.parse(format.format(dto.getBegin() * 1000L));
                    Date end = format.parse(format.format(dto.getEnd() * 1000L));
                    List storagelist = this.storageRepository.findByDepIdAndDomainAndUserAndCreatedAtBetween(depId, domain, user1, begin, end);
                    Integer capacity = this.storageRepository.sumQuotaAllocatedByDepIdAndDomainAndUserAndCreatedAtBetween(depId, domain, user1, begin, end);
                    if (null != storagelist && storagelist.size() > 0) {
                        for (Storage storage : storagelist) {
                            String volumeUsed = this.storageServiceFactory.getVolumeUsed(storage, k8sFactory);
                            used += Long.parseLong(volumeUsed == null ? "0" : volumeUsed);
                        }
                    }
                    model.setCapacity(Integer.valueOf(capacity == null ? 0 : capacity));
                    model.setUsedBytes(Long.valueOf(used));
                    model.setUsed(SizeConverter.BTrim.convert((float)used));
                    list.add(model);
                }
                if (dto.getSort() == 0) {
                    list.sort((o1, o2) -> o2.getCapacity() - o1.getCapacity());
                } else {
                    list.sort(Comparator.comparingInt(ReferStorageModel::getCapacity));
                }
            }
        } else {
            ReferStorageModel model = new ReferStorageModel();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin = format.parse(format.format(dto.getBegin() * 1000L));
            Date end = format.parse(format.format(dto.getEnd() * 1000L));
            Integer capacity = this.storageRepository.sumQuotaAllocatedByDepIdAndDomainAndUserAndCreatedAtBetween(depId, domain, user, begin, end);
            long used = 0L;
            List storagelist = this.storageRepository.findByDepIdAndDomainAndUserAndCreatedAtBetween(depId, domain, user, begin, end);
            if (null != storagelist && storagelist.size() > 0) {
                for (Storage storage : storagelist) {
                    String volumeUsed = this.storageServiceFactory.getVolumeUsed(storage, k8sFactory);
                    used += Long.parseLong(volumeUsed == null ? "0" : volumeUsed);
                }
            }
            model.setName(user.getName());
            model.setUsername(user.getUsername());
            model.setCapacity(capacity);
            model.setUsedBytes(Long.valueOf(used));
            model.setUsed(SizeConverter.BTrim.convert((float)used));
            list.add(model);
        }
        res.setList(list);
        return res;
    }

    @ApiOperation(value="\u533a\u57df\u8d44\u6e90\u5269\u4f59")
    @Transactional(readOnly=true)
    @GetMapping(value={"/api/domain/resource"})
    public ListDomainResourceResultResponse<DomainResourceModel> resource(HttpServletRequest request) {
        ListDomainResourceResultResponse res = new ListDomainResourceResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = (Long)session.getAttribute("domain");
        JSONObject object = this.commonService.domainResourceFree(domainId);
        res.setGpuNum(Integer.valueOf(object.getIntValue("gpu")));
        res.setCpuNum(Integer.valueOf(object.getIntValue("cpu")));
        res.setMemoryNum(Integer.valueOf(object.getIntValue("memory")));
        res.setList((List)object.getObject("resource_list", ArrayList.class));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ConstructorProperties(value={"departmentRepository", "quotasRepository", "userRepository", "orgConfigDepartmentRepository", "depUsersRepository", "referDurationRepository", "domainRepository", "storageRepository", "k8sEngineRepository", "referTrialDurationRepository", "experimentRepository", "messageUtil", "storageServiceFactory", "commonService", "domainConfigValueRepository"})
    public DomainController(OrgConfigDepartmentRepository departmentRepository, OrganizationQuotasRepository quotasRepository, UserRepository userRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DepUsersRepository depUsersRepository, ReferDurationRepository referDurationRepository, DomainRepository domainRepository, StorageRepository storageRepository, K8sEngineRepository k8sEngineRepository, ReferTrialDurationRepository referTrialDurationRepository, ExperimentRepository experimentRepository, MessageUtil messageUtil, StorageServiceFactory storageServiceFactory, CommonService commonService, DomainConfigValueRepository domainConfigValueRepository) {
        this.departmentRepository = departmentRepository;
        this.quotasRepository = quotasRepository;
        this.userRepository = userRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.depUsersRepository = depUsersRepository;
        this.referDurationRepository = referDurationRepository;
        this.domainRepository = domainRepository;
        this.storageRepository = storageRepository;
        this.k8sEngineRepository = k8sEngineRepository;
        this.referTrialDurationRepository = referTrialDurationRepository;
        this.experimentRepository = experimentRepository;
        this.messageUtil = messageUtil;
        this.storageServiceFactory = storageServiceFactory;
        this.commonService = commonService;
        this.domainConfigValueRepository = domainConfigValueRepository;
    }
}

