/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.base.Strings;
import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.ElasticsearchUtils;
import com.mopaas.server.common.EncodeUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.controller.JobController;
import com.mopaas.server.dao.AccountNoticePushRepository;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.JobParamsRepository;
import com.mopaas.server.dao.JobRepository;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.ModelVersionRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.StorageDeptRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.Job;
import com.mopaas.server.entity.JobParams;
import com.mopaas.server.entity.JobStorage;
import com.mopaas.server.entity.JobVersion;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.ModelVersion;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.ReferDuration;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.User;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.harbor.model.DetailedTag;
import com.mopaas.server.model.InstantMetricModel;
import com.mopaas.server.model.request.CreateJobRequest;
import com.mopaas.server.model.request.IdRequest;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.JobParamRequest;
import com.mopaas.server.model.request.JobParamSortPageRequest;
import com.mopaas.server.model.request.LogSearchRequest;
import com.mopaas.server.model.request.RJSortPageRequest;
import com.mopaas.server.model.request.RemarkUpdateRequest;
import com.mopaas.server.model.request.TensorboardRequest;
import com.mopaas.server.model.response.JobCompareModel;
import com.mopaas.server.model.response.JobMetricsResponse;
import com.mopaas.server.model.response.JobModel;
import com.mopaas.server.model.response.JobParamModel;
import com.mopaas.server.model.response.JobParamResponse;
import com.mopaas.server.model.response.JobStorageModel;
import com.mopaas.server.model.response.JobVersionInfoModel;
import com.mopaas.server.model.response.JobVersionResponse;
import com.mopaas.server.model.response.ListJobVersionResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.LogResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.VersionResponse;
import com.mopaas.server.service.CommonService;
import com.mopaas.server.service.JobService;
import com.mopaas.server.service.NoticeUserService;
import com.mopaas.server.service.ResourceService;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventList;
import io.kubernetes.client.openapi.models.V1ContainerStateTerminated;
import io.kubernetes.client.openapi.models.V1ContainerStateWaiting;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.RequestContext;

@Api(tags={"\u8bad\u7ec3\u4efb\u52a1"})
@RestController
public class JobController {
    final JobRepository jobRepository;
    final UserRepository userRepository;
    final PricePackageRepository pricePackageRepository;
    final StorageRepository storageRepository;
    final MaterialsRepository materialsRepository;
    final BalancesRepository balancesRepository;
    final StorageDeptRepository storageDeptRepository;
    final AccountNoticePushRepository accountNoticePushRepository;
    final SystemConfigRepository systemConfigRepository;
    final MessageSource messageSource;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DepUsersRepository depUsersRepository;
    final DomainRepository domainRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final ReferDurationRepository referDurationRepository;
    final DepQuotasRepository depQuotasRepository;
    final JobParamsRepository jobParamsRepository;
    final JobVersionRepository jobVersionRepository;
    final ModelVersionRepository modelVersionRepository;
    final ResourceService resourceService;
    final JobService jobService;
    final MessageUtil messageUtil;
    final StorageServiceFactory storageServiceFactory;
    final NoticeUserService noticeUserService;
    final CommonService commonService;
    private static final Logger logger = LoggerFactory.getLogger(JobController.class);

    @ApiOperation(value="\u83b7\u53d6\u8bad\u7ec3\u4efb\u52a1\u7248\u672c,\u7f16\u8f91\u4efb\u52a1\u65f6\u4f20job id", notes="v3.4\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570jobPriority")
    @Transactional
    @PutMapping(value={"api/job/version"})
    public VersionResponse getVersion(@RequestBody IdRequest dto, HttpServletRequest request) {
        VersionResponse res = new VersionResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (dto.getId() != null) {
            Job job = (Job)this.jobRepository.findOne((Serializable)dto.getId());
            int v = Integer.parseInt(job.getCurrent().getVersion().substring(1)) + 1;
            if (v <= 9) {
                res.setVersion("V000" + v);
            } else if (v <= 99) {
                res.setVersion("V00" + v);
            } else if (v <= 999) {
                res.setVersion("V0" + v);
            } else {
                res.setVersion("V" + v);
            }
        } else {
            res.setVersion("V0001");
        }
        res.setJobPriority(user.getJobPriority());
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.create.job")
    @ApiOperation(value="\u65b0\u5efa\u8bad\u7ec3\u4efb\u52a1", notes="v3.5\u4fee\u6539:\u65b0\u589elogDir\u53c2\u6570")
    @Transactional
    @RequestMapping(value={"/api/job/new"}, method={RequestMethod.POST})
    public ResultResponse createJob(@RequestBody @Valid CreateJobRequest dto, HttpServletRequest request) throws Exception {
        Job job;
        Double balance;
        PricePackage pack;
        DepQuotas depQuotas;
        DepUsers depUsers;
        Integer org_count;
        Integer count;
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getName());
        HttpSession session = request.getSession();
        Long domain_id = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domain_id, Integer.valueOf(0));
        if (null == domain) {
            throw new MessageCodeException(dto.getName(), null, "msg.domain.unavailable", new String[0]);
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(dto.getName(), null, "msg.account.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(dto.getName(), null, "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        if (null == dto.getId() && null != (count = this.jobRepository.countByNameAndDepartmentAndDeleted(dto.getName(), dep, Integer.valueOf(0))) && count > 0) {
            throw new MessageJsonException(dto.getName(), null, "msg.dep.resource.name.exist.error", new String[]{"msg.type.job"});
        }
        Integer paramNameCount = this.jobParamsRepository.countByNameAndUserAndDepartmentAndDeleted(dto.getParamName(), user, dep, Integer.valueOf(0));
        if (null != paramNameCount && paramNameCount > 0) {
            throw new MessageCodeException(dto.getName(), null, "msg.job.param.name.exist", new String[0]);
        }
        Organization org = dep.getOrgConfig().getOrganization();
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domain_id);
        if (null == orgQuotas) {
            throw new MessageCodeException(dto.getName(), null, "msg.domain.resource.quota.unset", new String[0]);
        }
        if (orgQuotas.getStatus() != 1) {
            throw new MessageCodeException(dto.getName(), null, "msg.account.org.domain.disabled", new String[0]);
        }
        Integer job_limit = orgQuotas.getJobCount();
        if (null != job_limit && job_limit != -1 && (org_count = this.jobRepository.countByDepOrganizationAndDeleted(org, Integer.valueOf(0))) >= job_limit) {
            throw new MessageCodeException(dto.getName(), null, "msg.job.org.insufficient", new String[0]);
        }
        DepUsers currentUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (null != dto.getId()) {
            JobVersion parent = (JobVersion)this.jobVersionRepository.findOne((Serializable)dto.getId());
            depUsers = this.depUsersRepository.findByUserAndDepartment(parent.getJob().getUser(), dep);
            if (!DepartmentController.isMemberDepPermission((Integer)currentUsers.getType(), (Boolean)userId.equals(parent.getJob().getUser().getId()), (String)"job:version", (Long)depId)) {
                throw new MessageCodeException(dto.getName(), null, "msg.account.unauthorized", new String[0]);
            }
        } else {
            depUsers = currentUsers;
            if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"job:create", (Long)depId)) {
                throw new MessageCodeException(dto.getName(), null, "msg.account.unauthorized", new String[0]);
            }
            if (!Strings.isNullOrEmpty((String)dto.getParamName()) && depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"job:param", (Long)depId)) {
                throw new MessageCodeException(dto.getName(), null, "msg.account.unauthorized", new String[0]);
            }
        }
        if (depUsers != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domain_id))) {
            Integer user_count;
            String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
            for (OrgConfig config : org.getOrgConfigs()) {
                if (1 != config.getLevel()) continue;
                depName = config.getName();
                break;
            }
            if (null == dto.getId() && null != depQuotas.getJobCount() && depQuotas.getJobCount() != -1 && null != (user_count = this.jobRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, depUsers.getUser())) && user_count >= depQuotas.getJobCount()) {
                throw new MessageCodeException(dto.getName(), null, "msg.dep.resource.insufficient.error", new String[]{depName});
            }
            if (null != depQuotas.getJobTime() && depQuotas.getJobTime() != -1.0) {
                Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(1), depUsers.getUser().getId(), depId, domain_id, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getJobTime() * 60.0 * 60.0) {
                    throw new MessageCodeException(dto.getName(), null, "msg.dep.resource.time.insufficient.error", new String[]{depName});
                }
            }
        }
        if (null == (pack = this.pricePackageRepository.findByIdAndStatusAndDeleted(dto.getPackageId(), Integer.valueOf(1), Integer.valueOf(0)))) {
            throw new MessageCodeException(dto.getName(), null, "msg.package.not.available", new String[0]);
        }
        if (pack.getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            throw new MessageCodeException(dto.getName(), null, "msg.org.balance.insufficient", new String[0]);
        }
        if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
            String gpu_type = pack.getGpu().getChargeItem();
            String gpushare = pack.getSlice() == 0 ? "vgpu" : (pack.getSlice() == 1 ? "false" : "true");
            if (!FactoryCollection.k8sFactory((Long)domain_id).checkGpuNode(gpu_type, gpushare).booleanValue()) {
                throw new MessageCodeException(dto.getName(), null, "msg.sys.resource.insufficient", new String[0]);
            }
        }
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(domain).department(dep).user(user).name(dto.getName()).pack(pack).replica(dto.getReplicas()).operate("create").build();
        this.commonService.judgeResource(identityDto);
        Integer priority = Optional.ofNullable(user.getJobPriority()).orElse(0);
        DetailedTag tag = this.commonService.getHarborImage(domain_id, dto.getRepository(), dto.getTag());
        if (tag.getLabels().stream().noneMatch(e -> "active".equals(e.getName()))) {
            throw new MessageCodeException(dto.getName(), null, "msg.repo.tag.inactive", new String[0]);
        }
        String guid = UUID.randomUUID().toString().replace("-", "");
        JobVersion version = new JobVersion();
        this.jobVersionRepository.saveAndFlush((Object)version);
        if (null != dto.getId()) {
            JobVersion parent = (JobVersion)this.jobVersionRepository.findOne((Serializable)dto.getId());
            version.setParent(parent);
            job = parent.getJob();
        } else {
            job = new Job();
            job.setUser(user);
            job.setDeleted(Integer.valueOf(0));
            job.setDepartment(dep);
            job.setDomain(domain);
            job.setName(dto.getName());
            this.jobRepository.save((Object)job);
        }
        job.setCurrent(version);
        version.setJob(job);
        version.setName(dto.getName());
        version.setVersion(dto.getVersion());
        version.setRemark(dto.getRemark());
        String image = FactoryCollection.harborDomain((Long)domain_id) + "/" + dto.getRepository() + ":" + dto.getTag();
        version.setImage(image);
        version.setFrameType(dto.getFrameType());
        version.setEntrypoint(dto.getEntrypoint());
        version.setOutput(dto.getOutput());
        if (!StringUtils.isEmpty((String)dto.getLogDir())) {
            version.setLogDir(dto.getLogDir());
            version.setTensorboardState(Integer.valueOf(1));
        } else {
            version.setTensorboardState(Integer.valueOf(0));
        }
        version.setPack(pack);
        version.setGuid(guid);
        res.setGuid(guid);
        version.setDeleted(Integer.valueOf(0));
        version.setStatus(Integer.valueOf(0));
        version.setReplicas(dto.getReplicas());
        version.setPriority(priority);
        if (dto.getParams() != null) {
            JSONArray jsonArray = dto.getParams();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject param = jsonArray.getJSONObject(i);
                String name = param.getString("name");
                if (name.matches("^[\\w-]{1,64}$")) continue;
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.job.params.name.not.match"));
                return res;
            }
            version.setParams(JSON.toJSONString((Object)dto.getParams(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty}));
        }
        Map storages = dto.getStorages();
        ArrayList volume_list = new ArrayList();
        if (storages != null && storages.size() > 0) {
            storages.forEach((k, v) -> {
                Storage storage = (Storage)this.storageRepository.findOne((Serializable)k);
                if (null != storage) {
                    if (storage.getDeleted() != 0) {
                        throw new MessageCodeException(storage.getName(), storage.getGuid(), "msg.storage.not.found", new String[]{storage.getName()});
                    }
                    JobStorage r_storage = new JobStorage();
                    r_storage.setJobVersion(version);
                    r_storage.setStorage(storage);
                    r_storage.setPath(v);
                    volume_list.add(r_storage);
                }
            });
            version.setStorages(volume_list);
        }
        if (!Strings.isNullOrEmpty((String)dto.getParamName())) {
            JobParams params = new JobParams();
            params.setName(dto.getParamName());
            params.setRemark(dto.getParamRemark());
            params.setUser(user);
            params.setDepartment(dep);
            params.setDomain(domain);
            params.setSequence(UUID.randomUUID().toString().substring(24));
            params.setImage(version.getImage());
            params.setFrameType(version.getFrameType());
            params.setEntrypoint(version.getEntrypoint());
            params.setOutput(version.getOutput());
            params.setLogDir(version.getLogDir());
            params.setParams(version.getParams());
            params.setPack(version.getPack());
            params.setReplicas(version.getReplicas());
            params.setDeleted(Integer.valueOf(0));
            if (dto.getStorages() != null) {
                params.setStorages(JSON.toJSONString((Object)dto.getStorages()));
            }
            this.jobParamsRepository.save((Object)params);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u540d\u79f0")
    @Transactional
    @GetMapping(value={"/api/job/{id}/{name}"})
    public ResultResponse update(@PathVariable(value="id") Long id, @PathVariable(value="name") @ApiParam(value="\u4efb\u52a1\u65b0\u540d\u79f0") String name, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        Job job = this.jobRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == job) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.job.not.exist"));
            return res;
        }
        Integer count = this.jobRepository.countByNameAndDepartmentAndDeleted(name, job.getDepartment(), Integer.valueOf(0));
        if (null != count && count > 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.dep.resource.name.exist.error", new String[]{this.messageUtil.getMessage("msg.type.job")}));
            return res;
        }
        job.setName(name);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u5217\u8868", notes="v3.5\u4fee\u6539:\u8fd4\u56de\u65b0\u589e\u53c2\u6570tensorboard,tensorboardState\u53c2\u6570")
    @Transactional
    @RequestMapping(value={"/api/job/list"}, method={RequestMethod.POST})
    public ListResultResponse<JobModel> listJob(@RequestBody @Valid RJSortPageRequest dto, HttpServletRequest request) {
        PageRequest pageable;
        Integer finalLevel;
        2 spec;
        Page page;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (page = this.jobRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */), (Pageable)(pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"currentCreatedAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"currentId"}))))) {
            List jobs = page.getContent();
            res.setPages(Integer.valueOf(page.getTotalPages()));
            res.setSize(Long.valueOf(page.getTotalElements()));
            ArrayList<JobModel> models = new ArrayList<JobModel>(jobs.size());
            for (Job job : jobs) {
                JobVersion version = job.getCurrent();
                JobModel model = new JobModel();
                model.setVersions(this.jobVersionRepository.countByJobAndDeleted(job, Integer.valueOf(0)));
                model.setId(job.getId());
                model.setName(job.getName());
                model.setStatus(version.getStatus());
                model.setImage(version.getImage().substring(version.getImage().lastIndexOf("/") + 1));
                model.setCreateTime(version.getCreatedAt());
                if (null != version.getStartedAt()) {
                    model.setTrainBegin(version.getStartedAt());
                    long second = ((null == version.getStopAt() || version.getStopAt().before(version.getStartedAt()) ? System.currentTimeMillis() : version.getStopAt().getTime()) - version.getStartedAt().getTime()) / 1000L;
                    model.setTrainTime(TimeUtil.duration((Long)second));
                }
                PricePackage pack = version.getPack();
                model.setPrice(Double.valueOf(pack.getCost() * (double)version.getReplicas().intValue()));
                model.setRemark(version.getRemark());
                model.setSeq(version.getGuid());
                model.setUserId(job.getUser().getId());
                model.setUsername(job.getUser().getUsername());
                model.setFullName(job.getUser().getName() == null ? job.getUser().getUsername() : job.getUser().getName());
                DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(job.getUser(), dep);
                if (resourceDepUser != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                model.setReplicas(version.getReplicas());
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (null != pack.getGpu() && !Strings.isNullOrEmpty((String)pack.getGpu().getChargeItem())) {
                    packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setPack(packageInfoModel);
                if (version.getStatus() != 0 && version.getStatus() != 1 && version.getStatus() != 2 && version.getStatus() != 3) {
                    String errorMessage = version.getErrorMessage();
                    if (errorMessage == null) {
                        CoreV1EventList coreV1EventList = null;
                        try {
                            coreV1EventList = FactoryCollection.k8sFactory((Long)domainId).coreV1Api.listNamespacedEvent(version.getGuid(), null, null, null, null, null, null, null, null, null, null);
                        }
                        catch (ApiException e) {
                            logger.info(e.getResponseBody());
                        }
                        if (null != coreV1EventList) {
                            List items = coreV1EventList.getItems();
                            for (int i = items.size() - 1; i >= 0; --i) {
                                CoreV1Event event = (CoreV1Event)items.get(i);
                                if (!event.getType().contains("Warning")) continue;
                                errorMessage = event.getMessage();
                                break;
                            }
                        }
                    }
                    model.setErrorMessage(errorMessage);
                    version.setErrorMessage(errorMessage);
                }
                model.setJobPriority(version.getPriority());
                model.setTensorboardState(version.getTensorboardState());
                if (null != version.getTensorboard() && version.getTensorboardState() == 1) {
                    model.setTensorboard(version.getTensorboard());
                }
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.remove.job")
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    @Transactional
    @DeleteMapping(value={"/api/job"})
    public ResultResponse remove(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) throws ApiException {
        HttpSession session;
        Long depId;
        ResultResponse res = new ResultResponse();
        List jobs = this.jobRepository.findByIdInAndDeleted(dto.getIds(), 0);
        if (null == jobs) {
            return res;
        }
        StringBuilder resourceNames = new StringBuilder();
        for (Job job : jobs) {
            resourceNames.append("," + job.getName());
        }
        if (resourceNames.length() > 1) {
            res.setEntity(String.valueOf(resourceNames).substring(1));
        }
        if ((depId = (Long)(session = request.getSession()).getAttribute("departmentId")) == null) {
            throw new MessageCodeException(null, null, "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Date now = new Date();
        Long domainId = (Long)session.getAttribute("domain");
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        StringBuilder jobGuids = new StringBuilder();
        for (Job job : jobs) {
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(job.getUser().getId()), (String)"job:deleted", (Long)depId)) {
                throw new MessageCodeException(null, null, "msg.account.unauthorized", new String[0]);
            }
            List versions = this.jobVersionRepository.getByJobAndDeleted(job, Integer.valueOf(0));
            for (JobVersion version : versions) {
                List storages;
                List durations;
                jobGuids.append("," + version.getGuid());
                res.setGuid(String.valueOf(jobGuids).substring(1));
                List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(version.getId(), Integer.valueOf(1));
                if (null != materials) {
                    for (Object material : materials) {
                        material.setLastedAt(now);
                        material.setOperation(null);
                    }
                }
                if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(version.getId(), Integer.valueOf(1))) != null) {
                    Object material;
                    material = durations.iterator();
                    while (material.hasNext()) {
                        ReferDuration duration = (ReferDuration)material.next();
                        duration.setEnd(now);
                    }
                }
                if (null != (storages = version.getStorages()) && !storages.isEmpty()) {
                    for (JobStorage js : storages) {
                        Storage storage = js.getStorage();
                        if (null == storage.getType() || storage.getType() != 3) continue;
                        try {
                            V1PersistentVolume pv = k8sFactory.coreV1Api.readPersistentVolume("pv-" + version.getGuid() + storage.getGuid().substring(20), null, null, null);
                            if (null == pv) continue;
                            k8sFactory.coreV1Api.deletePersistentVolume("pv-" + version.getGuid() + storage.getGuid().substring(20), null, null, null, null, null, null);
                        }
                        catch (ApiException e) {
                            logger.info(e.getResponseBody());
                        }
                    }
                }
                k8sFactory.deleteNamespace(version.getGuid());
                version.setDeleted(Integer.valueOf(1));
            }
            job.setDeleted(Integer.valueOf(1));
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.remove.version.job")
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u7248\u672c")
    @Transactional
    @DeleteMapping(value={"/api/job/version/{id}"})
    public ResultResponse removeJobVersion(@PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        List storages;
        List durations;
        ResultResponse res = new ResultResponse();
        JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)id);
        res.setEntity(version.getName());
        res.setGuid(version.getGuid());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(version.getName(), version.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Job job = version.getJob();
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(job.getUser().getId()), (String)"job:deleted", (Long)depId)) {
            throw new MessageCodeException(version.getName(), version.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        Date now = new Date();
        Long domainId = (Long)session.getAttribute("domain");
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(version.getId(), Integer.valueOf(1));
        if (null != materials) {
            for (Object material : materials) {
                material.setLastedAt(now);
                material.setOperation(null);
            }
        }
        if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(version.getId(), Integer.valueOf(1))) != null) {
            for (Object duration : durations) {
                duration.setEnd(now);
            }
        }
        if (null != (storages = version.getStorages()) && !storages.isEmpty()) {
            for (JobStorage js : storages) {
                Storage storage = js.getStorage();
                if (null == storage.getType() || storage.getType() != 3) continue;
                try {
                    V1PersistentVolume pv = k8sFactory.coreV1Api.readPersistentVolume("pv-" + version.getGuid() + storage.getGuid().substring(20), null, null, null);
                    if (null == pv) continue;
                    k8sFactory.coreV1Api.deletePersistentVolume("pv-" + version.getGuid() + storage.getGuid().substring(20), null, null, null, null, null, null);
                }
                catch (ApiException e) {
                    logger.info(e.getResponseBody());
                }
            }
        }
        k8sFactory.deleteNamespace(version.getGuid());
        if (job.getCurrent().getId().equals(version.getId())) {
            List versions = this.jobVersionRepository.getTop2ByJobAndDeletedOrderByIdDesc(job, Integer.valueOf(0));
            if (versions.size() > 1) {
                job.setCurrent(version.getId().equals(((JobVersion)versions.get(0)).getId()) ? (JobVersion)versions.get(1) : (JobVersion)versions.get(0));
            } else {
                job.setDeleted(Integer.valueOf(1));
            }
        }
        version.setDeleted(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7248\u672c\u5217\u8868", notes="v3.5\u4fee\u6539:\u8fd4\u56de\u65b0\u589e\u53c2\u6570tensorboard,tensorboardState\u53c2\u6570")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/job/{id}/versions"})
    public ListJobVersionResponse<JobVersionInfoModel> listVersion(@PathVariable(value="id") Long id) {
        ListJobVersionResponse res = new ListJobVersionResponse();
        Job job = (Job)this.jobRepository.findOne((Serializable)id);
        if (null != job) {
            res.setJobName(job.getName());
            res.setUsername(job.getUser().getUsername());
            res.setFullName(job.getUser().getName());
            List versions = this.jobVersionRepository.getByJobAndDeletedOrderByIdDesc(job, Integer.valueOf(0));
            ArrayList<JobVersionInfoModel> models = new ArrayList<JobVersionInfoModel>(versions.size());
            for (JobVersion version : versions) {
                JobVersionInfoModel model = new JobVersionInfoModel();
                model.setId(version.getId());
                model.setGuid(version.getGuid());
                model.setParentVersion(version.getParent() != null ? version.getParent().getVersion() : null);
                model.setVersion(version.getVersion());
                model.setStatus(version.getStatus());
                model.setImage(version.getImage());
                PackageInfoModel pack = (PackageInfoModel)BeanMapper.map((Object)version.getPack(), PackageInfoModel.class);
                if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
                    pack.setGpuType(version.getPack().getGpu().getChargeItem());
                }
                model.setPack(pack);
                model.setReplicas(version.getReplicas());
                if (version.getStatus() > 0 && null != version.getStartedAt()) {
                    long second = null != version.getStopAt() ? ((version.getStopAt().after(version.getStartedAt()) ? version.getStopAt().getTime() : version.getStartedAt().getTime()) - version.getStartedAt().getTime()) / 1000L : (System.currentTimeMillis() - version.getStartedAt().getTime()) / 1000L;
                    model.setTrainTime(TimeUtil.duration((Long)second));
                }
                model.setJobPriority(version.getPriority());
                model.setCreatedAt(version.getCreatedAt());
                model.setErrorMessage(version.getErrorMessage());
                model.setTensorboardState(version.getTensorboardState());
                if (null != version.getTensorboard() && version.getTensorboardState() == 1) {
                    model.setTensorboard(version.getTensorboard());
                }
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7248\u672c\u8be6\u60c5", notes="v3.5\u4fee\u6539:\u8fd4\u56de\u65b0\u589e\u53c2\u6570tensorboard,tensorboardState\u53c2\u6570")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/job/version/{id}"})
    public JobVersionResponse getVersion(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String address = "k8s/%s/index.php?user/loginSubmit";
        JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)id);
        Job job = version.getJob();
        JobVersionResponse res = (JobVersionResponse)BeanMapper.map((Object)version, JobVersionResponse.class);
        res.setImage(version.getImage().substring(version.getImage().indexOf("/") + 1));
        res.setParentVersion(version.getParent() != null ? version.getParent().getVersion() : null);
        res.setJobId(job.getId());
        res.setJobName(job.getName());
        res.setJobSeq(version.getGuid().substring(0, 12));
        res.setStatus(version.getStatus());
        res.setUsername(job.getUser().getUsername());
        res.setFullName(job.getUser().getName());
        res.setNamespace(version.getGuid());
        res.setJobPriority(version.getPriority());
        res.setLogDir(version.getLogDir());
        res.setTensorboardState(version.getTensorboardState());
        if (null != version.getTensorboard()) {
            res.setTensorboard(version.getTensorboard());
        }
        PricePackage pack = version.getPack();
        PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
        if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
            packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
        }
        res.setPack(packageInfoModel);
        res.setPrice(pack.getCost());
        if (null != version.getStartedAt()) {
            res.setTrainBegin(version.getStartedAt());
            long second = ((null == version.getStopAt() || version.getStopAt().before(version.getStartedAt()) ? System.currentTimeMillis() : version.getStopAt().getTime()) - version.getStartedAt().getTime()) / 1000L;
            res.setTrainTime(TimeUtil.duration((Long)second));
        }
        ArrayList<JobStorageModel> storageModels = new ArrayList<JobStorageModel>();
        List storages = version.getStorages();
        if (null != storages && storages.size() > 0) {
            for (JobStorage js : storages) {
                JobStorageModel model = new JobStorageModel();
                Storage storage = js.getStorage();
                model.setId(storage.getId());
                model.setName(storage.getName());
                model.setPassword(EncodeUtil.rawInput((String)storage.getPassword()));
                model.setWebUrl(String.format(address, storage.getWebPort()));
                model.setMountPath(StringUtils.isEmpty((String)js.getPath()) ? "/ai/" + storage.getMountPath() : js.getPath());
                model.setGuid(storage.getGuid());
                storageModels.add(model);
            }
        }
        res.setStorages(storageModels);
        DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(job.getUser(), job.getDepartment());
        if (resourceDepUser != null) {
            res.setCreatorQuited(Integer.valueOf(0));
        } else {
            res.setCreatorQuited(Integer.valueOf(1));
        }
        ArrayList<String> args = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)version.getParams())) {
            JSONArray jsonArray;
            Map<String, String> params = new HashMap();
            if (version.getParams().startsWith("[")) {
                jsonArray = JSONArray.parseArray((String)version.getParams());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject param = jsonArray.getJSONObject(i);
                    params.put(param.getString("name"), param.getString("value"));
                    String paramValue = "--" + param.getString("name") + "=" + param.getString("value");
                    args.add(paramValue);
                }
                res.setParams(version.getParams());
            } else {
                JSONObject object;
                params = (Map)JSON.parseObject((String)version.getParams(), Map.class);
                jsonArray = new JSONArray();
                params.forEach((k, v) -> {
                    JSONObject object = new JSONObject();
                    object.put("name", k);
                    String param = "--" + k;
                    if (null != v) {
                        if (v.contains(":/")) {
                            param = param + "=" + v.split(":")[1];
                            object.put("value", (Object)v.split(":")[1]);
                        } else {
                            param = param + "=" + v;
                            object.put("value", v);
                        }
                    }
                    object.put("remark", (Object)"");
                    jsonArray.add((Object)object);
                    args.add(param);
                });
                if (!Strings.isNullOrEmpty((String)version.getCodeDir()) && !jsonArray.toJSONString().contains("code_dir")) {
                    object = new JSONObject();
                    object.put("name", (Object)"code_dir");
                    if (version.getCodeDir().contains(":/")) {
                        object.put("value", (Object)version.getCodeDir().split(":")[1]);
                    } else {
                        object.put("value", (Object)version.getCodeDir());
                    }
                    object.put("remark", (Object)"");
                    jsonArray.add((Object)object);
                }
                if (!Strings.isNullOrEmpty((String)version.getInput()) && !jsonArray.toJSONString().contains("data_dir")) {
                    object = new JSONObject();
                    object.put("name", (Object)"data_dir");
                    if (version.getInput().contains(":/")) {
                        object.put("value", (Object)version.getInput().split(":")[1]);
                    } else {
                        object.put("value", (Object)version.getInput());
                    }
                    object.put("remark", (Object)"");
                    jsonArray.add((Object)object);
                }
                if (!Strings.isNullOrEmpty((String)version.getLogDir()) && !jsonArray.toJSONString().contains("log_dir")) {
                    object = new JSONObject();
                    object.put("name", (Object)"log_dir");
                    if (version.getLogDir().contains(":/")) {
                        object.put("value", (Object)version.getLogDir().split(":")[1]);
                    } else {
                        object.put("value", (Object)version.getLogDir());
                    }
                    object.put("remark", (Object)"");
                    jsonArray.add((Object)object);
                }
                res.setParams(jsonArray.toJSONString());
            }
        }
        ArrayList<String> command = new ArrayList<String>(4);
        String entrypoint = version.getEntrypoint().contains(":/") ? version.getEntrypoint().split(":")[1] : version.getEntrypoint();
        String file = entrypoint.substring(entrypoint.lastIndexOf("/") + 1);
        if (entrypoint.endsWith(".py")) {
            command.add("python");
        } else {
            command.add("sh");
        }
        command.add(file);
        command.addAll(args);
        res.setStartCommand(StringUtils.strip((String)((Object)command).toString(), (String)"[]").replace(",", ""));
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.stop.job")
    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1")
    @Transactional
    @RequestMapping(value={"/api/job/stop/{id}"}, method={RequestMethod.PUT})
    public ResultResponse stopJob(@PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        Job job = this.jobRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == job) {
            throw new MessageCodeException(null, null, "msg.job.not.exist", new String[0]);
        }
        res.setGuid(job.getCurrent().getGuid());
        res.setEntity(job.getName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(job.getName(), job.getCurrent().getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(job.getUser().getId()), (String)"job:stop", (Long)depId)) {
            throw new MessageCodeException(job.getName(), job.getCurrent().getGuid(), "msg.account.unauthorized", new String[0]);
        }
        JobVersion jobCurrent = job.getCurrent();
        if (jobCurrent.getStatus() != 0 && jobCurrent.getStatus() != 1) {
            throw new MessageCodeException(job.getName(), job.getCurrent().getGuid(), "mgs.job.cannot.stop", new String[0]);
        }
        Long domainId = (Long)session.getAttribute("domain");
        this.jobService.doStop(jobCurrent, domainId);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.stop.version.job")
    @ApiOperation(value="\u505c\u6b62\u6307\u5b9a\u7248\u672c")
    @Transactional
    @RequestMapping(value={"/api/job/stop/version/{id}"}, method={RequestMethod.PUT})
    public ResultResponse stopJobVersion(@PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)id);
        res.setEntity(version.getName());
        res.setGuid(version.getGuid());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(version.getName(), version.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(version.getJob().getUser().getId()), (String)"job:stop", (Long)depId)) {
            throw new MessageCodeException(version.getName(), version.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        if (version.getStatus() != 0 && version.getStatus() != 1) {
            throw new MessageCodeException(version.getName(), version.getGuid(), "mgs.job.cannot.stop", new String[0]);
        }
        Long domainId = (Long)session.getAttribute("domain");
        this.jobService.doStop(version, domainId);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4efb\u52a1\u65e5\u5fd7", notes="v3.3\u4fee\u6539\u63a5\u53e3\u4f20\u53c2-\u65b0\u589e\u53c2\u6570scrollId")
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/job/version/{id}/log"})
    public LogResponse log(@ApiParam(value="\u4efb\u52a1\u7248\u672cid") @PathVariable(value="id") Long id, @RequestBody LogSearchRequest dto, HttpServletRequest request) {
        LogResponse res = new LogResponse();
        RequestContext context = new RequestContext(request);
        JobVersion jobVersion = (JobVersion)this.jobVersionRepository.findOne((Serializable)id);
        try {
            Date start = Optional.ofNullable(jobVersion.getCreatedAt()).orElse(dto.getStart());
            Date end = Optional.ofNullable(jobVersion.getStopAt()).orElse(dto.getEnd());
            res = ElasticsearchUtils.query((Long)jobVersion.getJob().getDomain().getId(), (String)jobVersion.getGuid(), null, (String)dto.getKeyword(), (Date)(null == dto.getStart() || start.after(dto.getStart()) ? start : dto.getStart()), (Date)(null == dto.getEnd() || end.before(dto.getEnd()) ? new Date(end.getTime() + 3600000L) : dto.getEnd()), (String)dto.getScrollId(), (Integer)dto.getSize());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            res.setCode(Constants.SC_MSG);
            res.setMessage(context.getMessage("msg.job.log.error"));
        }
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.download.log")
    @ApiOperation(value="\u4efb\u52a1\u65e5\u5fd7\u4e0b\u8f7d")
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/job/version/{id}/log/download"})
    public ResultResponse logDownload(@ApiParam(value="\u4efb\u52a1\u7248\u672cid") @PathVariable(value="id") Long id, @RequestBody LogSearchRequest dto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultResponse res = new ResultResponse();
        JobVersion jobVersion = (JobVersion)this.jobVersionRepository.findOne((Serializable)id);
        res.setEntity(jobVersion.getName());
        res.setGuid(jobVersion.getGuid());
        Date start = Optional.ofNullable(jobVersion.getCreatedAt()).orElse(dto.getStart());
        Date end = Optional.ofNullable(jobVersion.getStopAt()).orElse(dto.getEnd());
        ElasticsearchUtils.downloadLog((HttpServletRequest)request, (HttpServletResponse)response, (String)jobVersion.getGuid(), null, (String)jobVersion.getName(), (Date)(null == dto.getStart() || start.after(dto.getStart()) ? start : dto.getStart()), (Date)(null == dto.getEnd() || end.before(dto.getEnd()) ? new Date(end.getTime() + 3600000L) : dto.getEnd()));
        return res;
    }

    private String message(String key, String ... args) {
        return this.messageSource.getMessage(key, (Object[])args, null);
    }

    @Transactional
    public void schedule() {
        List versions = this.jobVersionRepository.findSchedule();
        if (null != versions && versions.size() > 0) {
            for (JobVersion version : versions) {
                Job job = version.getJob();
                try {
                    List durations;
                    SystemConfig platform;
                    Date finish;
                    Date startTime;
                    K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)job.getDomain().getId());
                    String phase = null;
                    OffsetDateTime startAt = null;
                    V1ContainerStateTerminated terminated = null;
                    List pods = k8sFactory.listPods(version.getGuid());
                    for (V1Pod pod : pods) {
                        V1ContainerStatus containerStatus;
                        V1PodCondition condition2;
                        List containerStatuses;
                        if (null == phase || !"Running".equals(pod.getStatus().getPhase())) {
                            phase = pod.getStatus().getPhase();
                        }
                        if ("Running".equals(phase)) {
                            containerStatuses = pod.getStatus().getContainerStatuses();
                            for (V1ContainerStatus containerStatus2 : containerStatuses) {
                                if (!containerStatus2.getReady().booleanValue()) {
                                    V1ContainerStateWaiting waiting = containerStatus2.getState().getWaiting();
                                    if (null != waiting && "CrashLoopBackOff".equals(waiting.getReason())) {
                                        phase = "Failed";
                                        terminated = containerStatus2.getLastState().getTerminated();
                                        continue;
                                    }
                                    phase = null;
                                    continue;
                                }
                                OffsetDateTime dateTime = containerStatus2.getState().getRunning().getStartedAt();
                                if (null != startAt && dateTime.isBefore(startAt)) continue;
                                startAt = dateTime;
                            }
                        }
                        if ("Pending".equals(phase) && version.getStatus() != -9) {
                            List containerStatuses2;
                            List conditions = pod.getStatus().getConditions();
                            if (null != conditions && conditions.size() > 0) {
                                for (V1PodCondition condition2 : conditions) {
                                    if (!"PodScheduled".equals(condition2.getType()) || null == condition2.getMessage() || !condition2.getMessage().contains("Insufficient") && !condition2.getMessage().contains("minAvailable") && !condition2.getMessage().contains("fit failed")) continue;
                                    version.setStatus(Integer.valueOf(-9));
                                    version.setErrorMessage(condition2.getMessage());
                                }
                            }
                            if (null == (containerStatuses2 = pod.getStatus().getContainerStatuses())) continue;
                            condition2 = containerStatuses2.iterator();
                            while (condition2.hasNext()) {
                                containerStatus = (V1ContainerStatus)condition2.next();
                                if (containerStatus.getLastState() == null || containerStatus.getLastState().getTerminated() == null) continue;
                                String reason = containerStatus.getLastState().getTerminated().getReason();
                                if ("Error".equals(reason)) {
                                    version.setStatus(Integer.valueOf(-1));
                                    version.setErrorMessage(containerStatus.getLastState().getTerminated().getMessage());
                                    continue;
                                }
                                if (!"OOMKilled".equals(reason)) continue;
                                version.setStatus(Integer.valueOf(-1));
                                version.setErrorMessage(reason);
                            }
                            continue;
                        }
                        if (("Failed".equals(pod.getStatus().getPhase()) || "Succeeded".equals(pod.getStatus().getPhase())) && (containerStatuses = pod.getStatus().getContainerStatuses()) != null) {
                            condition2 = containerStatuses.iterator();
                            while (condition2.hasNext()) {
                                containerStatus = (V1ContainerStatus)condition2.next();
                                V1ContainerStateTerminated stateTerminated = containerStatus.getState().getTerminated();
                                if (null != terminated && (null == stateTerminated || !stateTerminated.getFinishedAt().isBefore(terminated.getFinishedAt()))) continue;
                                terminated = stateTerminated;
                            }
                        }
                        if (startAt != null || null == terminated) continue;
                        startAt = terminated.getStartedAt();
                    }
                    Date date = startTime = startAt != null ? Date.from(startAt.toInstant()) : null;
                    if ("Running".equals(phase)) {
                        if (version.getStatus() != 0 && version.getStatus() != -9) continue;
                        OrgConfigDepartment department = job.getDepartment();
                        User user = job.getUser();
                        Materials material = new Materials();
                        material.setDomain(job.getDomain());
                        material.setResourceId(version.getId());
                        material.setUser(user);
                        material.setDepartment(department);
                        material.setOrganization(department.getOrgConfig().getOrganization());
                        material.setType(Integer.valueOf(1));
                        material.setPackageType(Integer.valueOf(2));
                        material.setCostTime(startTime);
                        material.setCreatedAt(startTime);
                        material.setPack(version.getPack());
                        material.setResourceInstance(version.getReplicas());
                        this.materialsRepository.save(material);
                        SystemConfig platform2 = this.systemConfigRepository.findByConfigName("PLATFORM");
                        if (null != platform2 && !Strings.isNullOrEmpty((String)platform2.getConfigValue())) {
                            this.noticeUserService.pushNotice(this.messageUtil.getMessageJson("msg.job.train.start.title"), this.messageUtil.getMessageJson("msg.job.train.start", new String[]{platform2.getConfigValue(), job.getName()}), user);
                            this.noticeUserService.jobMessage(Integer.valueOf(0), user, job.getName());
                        }
                        version.setStartedAt(startTime);
                        version.setStatus(Integer.valueOf(1));
                        version.setErrorMessage(null);
                        ReferDuration duration = new ReferDuration();
                        duration.setStart(startTime);
                        duration.setReference(version.getId());
                        duration.setReferType(Integer.valueOf(1));
                        duration.setUser(user);
                        duration.setDepartment(job.getDepartment());
                        duration.setDomain(job.getDomain());
                        this.referDurationRepository.save((Object)duration);
                        continue;
                    }
                    if (!"Succeeded".equals(phase) && !"Failed".equals(phase)) continue;
                    Date date2 = finish = terminated != null ? Date.from(terminated.getFinishedAt().toInstant()) : new Date();
                    if ("Succeeded".equals(phase)) {
                        version.setStatus(Integer.valueOf(2));
                        version.setErrorMessage(null);
                        platform = this.systemConfigRepository.findByConfigName("PLATFORM");
                        if (null != platform && !Strings.isNullOrEmpty((String)platform.getConfigValue())) {
                            this.noticeUserService.pushNotice(this.messageUtil.getMessageJson("msg.job.train.succeeded.title"), this.messageUtil.getMessageJson("msg.job.train.succeeded", new String[]{platform.getConfigValue(), job.getName()}), job.getUser());
                            this.noticeUserService.jobMessage(Integer.valueOf(2), job.getUser(), job.getName());
                        }
                        version.setStopAt(finish);
                        version.setStartedAt(startTime);
                    } else {
                        platform = this.systemConfigRepository.findByConfigName("PLATFORM");
                        if (null != platform && !Strings.isNullOrEmpty((String)platform.getConfigValue())) {
                            this.noticeUserService.pushNotice(this.messageUtil.getMessageJson("msg.job.train.failed.title"), this.messageUtil.getMessageJson("msg.job.train.failed", new String[]{platform.getConfigValue(), job.getName()}), job.getUser());
                            this.noticeUserService.jobMessage(Integer.valueOf(1), job.getUser(), job.getName());
                        }
                        version.setStatus(Integer.valueOf(-1));
                        version.setStopAt(finish);
                        version.setStartedAt(startTime);
                        Object errorMessage = null;
                        CoreV1EventList coreV1EventList = FactoryCollection.k8sFactory((Long)job.getDomain().getId()).coreV1Api.listNamespacedEvent(version.getGuid(), null, null, null, null, null, null, null, null, null, null);
                        if (null != coreV1EventList) {
                            List items = coreV1EventList.getItems();
                            for (int i = items.size() - 1; i >= 0; --i) {
                                CoreV1Event event = (CoreV1Event)items.get(i);
                                if (!event.getType().contains("Warning")) continue;
                                errorMessage = event.getMessage();
                                break;
                            }
                        }
                        if (null == errorMessage || "Error".equals(errorMessage)) {
                            errorMessage = "Error\uff0c" + this.message("msg.job.error", new String[0]);
                        }
                        version.setErrorMessage(errorMessage);
                    }
                    List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(version.getId(), Integer.valueOf(1));
                    if (null != materials && materials.size() > 0) {
                        for (Materials material : materials) {
                            material.setLastedAt(finish);
                            material.setOperation(null);
                        }
                    }
                    if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(version.getId(), Integer.valueOf(1))) != null) {
                        for (ReferDuration duration : durations) {
                            duration.setEnd(finish);
                        }
                    }
                    if (!"Succeeded".equals(phase)) continue;
                    k8sFactory.deletePods(version.getGuid());
                }
                catch (ApiException e) {
                    logger.info(e.getResponseBody());
                }
            }
        }
    }

    @ApiOperation(value="\u5b9e\u65f6\u76d1\u63a7")
    @Transactional
    @GetMapping(value={"api/job/version/{id}/metrics"})
    public JobMetricsResponse<InstantMetricModel> metric(@ApiParam(value="\u4efb\u52a1\u7248\u672cid") @PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        List podList;
        JobMetricsResponse res = new JobMetricsResponse();
        Long domainId = (Long)request.getSession().getAttribute("domain");
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        JobVersion jobVersion = (JobVersion)this.jobVersionRepository.findOne((Serializable)id);
        res.setStatus(jobVersion.getStatus());
        if (null != jobVersion.getStartedAt()) {
            long second = ((null == jobVersion.getStopAt() || jobVersion.getStopAt().before(jobVersion.getStartedAt()) ? System.currentTimeMillis() : jobVersion.getStopAt().getTime()) - jobVersion.getStartedAt().getTime()) / 1000L;
            res.setTrainTime(TimeUtil.duration((Long)second));
        }
        if (null != (podList = k8sFactory.listPods(jobVersion.getGuid())) && podList.size() > 0) {
            String namespace = jobVersion.getGuid();
            ArrayList<InstantMetricModel> models = new ArrayList<InstantMetricModel>(podList.size());
            res.setList(models);
            PricePackage pack = jobVersion.getPack();
            for (V1Pod pod : podList) {
                if (pod.getStatus().getContainerStatuses() == null || !((V1ContainerStatus)pod.getStatus().getContainerStatuses().get(0)).getReady().booleanValue() || !pod.getMetadata().getLabels().containsKey("kubeflow-role")) continue;
                InstantMetricModel model = k8sFactory.podCpuMemoryUsage(pod.getMetadata().getUid(), pack.getCpuNum());
                model.setGpuUsage(k8sFactory.podGpusMetrics(pod));
                models.add(model);
            }
        }
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.update.remark")
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u7248\u672c\u5907\u6ce8")
    @Transactional
    @RequestMapping(value={"/api/job/remark"}, method={RequestMethod.POST})
    public ResultResponse updateRemark(@RequestBody @Valid RemarkUpdateRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        JobVersion jobVersion = (JobVersion)this.jobVersionRepository.findOne((Serializable)dto.getId());
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(jobVersion.getName(), jobVersion.getGuid(), "msg.account.unauthenticated", new String[0]);
        }
        res.setEntity(jobVersion.getName());
        res.setGuid(jobVersion.getName());
        jobVersion.setRemark(dto.getRemark());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u53c2\u6570\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/job/param/list"}, method={RequestMethod.POST})
    public ListResultResponse<JobParamModel> listJobParam(@RequestBody @Valid JobParamSortPageRequest dto, HttpServletRequest request) {
        PageRequest pageable;
        Integer finalLevel;
        3 spec;
        Page page;
        ListResultResponse res = new ListResultResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (page = this.jobParamsRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */), (Pageable)(pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"}))))) {
            List jobParams = page.getContent();
            res.setPages(Integer.valueOf(page.getTotalPages()));
            res.setSize(Long.valueOf(page.getTotalElements()));
            ArrayList<JobParamModel> models = new ArrayList<JobParamModel>(jobParams.size());
            for (JobParams params : jobParams) {
                JobParamModel model = new JobParamModel();
                model.setId(params.getId());
                model.setName(params.getName());
                model.setImage(params.getImage().substring(params.getImage().lastIndexOf("/") + 1));
                model.setCreateTime(params.getCreatedAt());
                PricePackage pack = params.getPack();
                model.setSeq(params.getSequence());
                model.setUsername(params.getUser().getUsername());
                model.setFullName(params.getUser().getName() == null ? params.getUser().getUsername() : params.getUser().getName());
                model.setReplicas(params.getReplicas());
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (null != pack.getGpu() && !Strings.isNullOrEmpty((String)pack.getGpu().getChargeItem())) {
                    packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setPack(packageInfoModel);
                DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(params.getUser(), dep);
                if (resourceDepUser != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.remove.params.job")
    @ApiOperation(value="\u5220\u9664\u53c2\u6570")
    @Transactional
    @DeleteMapping(value={"/api/job/params"})
    public ResultResponse removeParams(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) {
        String domainId;
        ResultResponse res = new ResultResponse();
        List paramsList = this.jobParamsRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        if (null == paramsList) {
            return res;
        }
        StringBuilder resourceNames = new StringBuilder();
        for (JobParams params : paramsList) {
            resourceNames.append("," + params.getName());
        }
        if (resourceNames.length() > 1) {
            res.setEntity(String.valueOf(resourceNames).substring(1));
        }
        if (Strings.isNullOrEmpty((String)(domainId = request.getHeader("domain"))) || !domainId.matches("[\\d]*")) {
            throw new MessageCodeException(null, null, "msg.domain.is.necessary", new String[0]);
        }
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(null, null, "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (null != dto.getIds() && dto.getIds().size() > 0) {
            Long id = (Long)dto.getIds().get(0);
            JobParams jobParams = (JobParams)this.jobParamsRepository.findOne((Serializable)id);
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(jobParams.getUser().getId()), (String)"job:paramsdelete", (Long)depId)) {
                throw new MessageCodeException(null, null, "msg.account.unauthorized", new String[0]);
            }
        }
        this.jobParamsRepository.removeByIds(dto.getIds());
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u53c2\u6570\u8be6\u60c5", notes="v3.4\u4fee\u6539\uff0c\u53d6\u6d88codeDir\uff0cinput\uff0clogDir\u76f8\u5173\u8fd4\u56de\u53c2\u6570\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570jobPriority,startCommand,storages\uff0c\u4fee\u6539params\u683c\u5f0f")
    @Transactional(readOnly=true)
    @GetMapping(value={"/api/job/param/{id}"})
    public JobParamResponse getParam(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String address = "k8s/%s/index.php?user/loginSubmit";
        JobParams params = (JobParams)this.jobParamsRepository.findOne((Serializable)id);
        JobParamResponse res = new JobParamResponse();
        res.setId(params.getId());
        res.setName(params.getName());
        res.setSequence(params.getSequence());
        res.setImage(params.getImage().substring(params.getImage().indexOf("/") + 1));
        res.setEntrypoint(params.getEntrypoint());
        res.setOutput(params.getOutput());
        res.setParams(params.getParams());
        res.setUsername(params.getUser().getUsername());
        res.setFullName(params.getUser().getName());
        res.setCreatedAt(params.getCreatedAt());
        res.setLogDir(params.getLogDir());
        PricePackage pack = params.getPack();
        PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
        if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
            packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
        }
        res.setPack(packageInfoModel);
        res.setReplicas(params.getReplicas());
        ArrayList<JobStorageModel> storageModels = new ArrayList<JobStorageModel>();
        if (!StringUtils.isEmpty((String)params.getStorages())) {
            try {
                Map storageMap = (Map)JSONObject.parseObject((String)params.getStorages(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                storageMap.forEach((k, v) -> {
                    JobStorageModel model = new JobStorageModel();
                    Storage storage = (Storage)this.storageRepository.findOne((Serializable)k);
                    model.setId(storage.getId());
                    model.setName(storage.getName());
                    model.setPassword(EncodeUtil.rawInput((String)storage.getPassword()));
                    model.setWebUrl(String.format(address, storage.getWebPort()));
                    model.setMountPath(v);
                    storageModels.add(model);
                });
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
            if (storageModels.isEmpty()) {
                try {
                    List list = (List)JSONObject.parseObject((String)params.getStorages(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                    for (Long sid : list) {
                        JobStorageModel model = new JobStorageModel();
                        Storage storage = (Storage)this.storageRepository.findOne((Serializable)sid);
                        model.setId(storage.getId());
                        model.setName(storage.getName());
                        model.setPassword(EncodeUtil.rawInput((String)storage.getPassword()));
                        model.setWebUrl(String.format(address, storage.getWebPort()));
                        model.setMountPath("/ai/" + storage.getMountPath());
                        storageModels.add(model);
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
            }
        }
        res.setStorages(storageModels);
        ArrayList<String> args = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)params.getParams())) {
            JSONArray jsonArray;
            Map<String, String> paramsMap = new HashMap();
            if (params.getParams().startsWith("[")) {
                jsonArray = JSONArray.parseArray((String)params.getParams());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject param = jsonArray.getJSONObject(i);
                    paramsMap.put(param.getString("name"), param.getString("value"));
                    String paramValue = "--" + param.getString("name") + "=" + param.getString("value");
                    args.add(paramValue);
                }
                res.setParams(params.getParams());
            } else {
                paramsMap = (Map)JSON.parseObject((String)params.getParams(), Map.class);
                jsonArray = new JSONArray();
                paramsMap.forEach((k, v) -> {
                    JSONObject object = new JSONObject();
                    object.put("name", k);
                    String param = "--" + k;
                    if (null != v) {
                        if (v.contains(":/")) {
                            param = param + "=" + v.split(":")[1];
                            object.put("value", (Object)v.split(":")[1]);
                        } else {
                            param = param + "=" + v;
                            object.put("value", v);
                        }
                    }
                    object.put("remark", (Object)"");
                    jsonArray.add((Object)object);
                    args.add(param);
                });
                res.setParams(jsonArray.toJSONString());
            }
        }
        ArrayList<String> command = new ArrayList<String>(4);
        String entrypoint = params.getEntrypoint().contains(":/") ? params.getEntrypoint().split(":")[1] : params.getEntrypoint();
        String file = entrypoint.substring(entrypoint.lastIndexOf("/") + 1);
        if (entrypoint.endsWith(".py")) {
            command.add("python");
        } else {
            command.add("sh");
        }
        command.add(file);
        command.addAll(args);
        res.setStartCommand(StringUtils.strip((String)((Object)command).toString(), (String)"[]").replace(",", ""));
        DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(params.getUser(), params.getDepartment());
        if (resourceDepUser != null) {
            res.setCreatorQuited(Integer.valueOf(0));
        } else {
            res.setCreatorQuited(Integer.valueOf(1));
        }
        return res;
    }

    @ApiOperation(value="\u7f16\u8f91\u8bad\u7ec3\u4efb\u52a1\u53c2\u6570", notes="v3.4\u4fee\u6539\uff0c\u53d6\u6d88\u53c2\u6570codeDir\uff0cinput\uff0clogDir\uff0c\u65b0\u589e\u53c2\u6570storages\uff0c\u4fee\u6539params\u683c\u5f0f")
    @Transactional
    @PostMapping(value={"/api/job/param"})
    public ResultResponse updateJobParam(@RequestBody @Valid JobParamRequest dto, HttpServletRequest request) {
        Integer paramNameCount;
        ResultResponse res = new ResultResponse();
        request.setAttribute("resourceType", (Object)1);
        request.setAttribute("resourceName", (Object)dto.getName());
        if (dto.getId() != null) {
            request.setAttribute("operation", (Object)this.messageUtil.getMessageJson("msg.edit.param"));
        }
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        JobParams params = null;
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (dto.getId() != null) {
            params = (JobParams)this.jobParamsRepository.findOne((Serializable)dto.getId());
            if (null != params && !DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(params.getUser().getId()), (String)"job:paramsedit", (Long)depId)) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                return res;
            }
            paramNameCount = this.jobParamsRepository.countByNameAndUserAndDepartmentAndDeletedAndIdNot(dto.getName(), user, dep, Integer.valueOf(0), dto.getId());
            if (null != paramNameCount && paramNameCount > 0) {
                res.setMessage(this.messageUtil.getMessage("msg.job.param.name.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.job.param.name.exist"));
                return res;
            }
        } else {
            if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"job:param", (Long)depId)) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                return res;
            }
            paramNameCount = this.jobParamsRepository.countByNameAndUserAndDepartmentAndDeleted(dto.getName(), user, dep, Integer.valueOf(0));
            if (null != paramNameCount && paramNameCount > 0) {
                res.setMessage(this.messageUtil.getMessage("msg.job.param.name.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.job.param.name.exist"));
                return res;
            }
        }
        if (params == null) {
            params = new JobParams();
            params.setUser((User)this.userRepository.findOne((Serializable)userId));
            params.setDepartment(dep);
            params.setDomain(domain);
            params.setSequence(UUID.randomUUID().toString().substring(24));
            this.jobParamsRepository.save((Object)params);
        }
        params.setName(dto.getName());
        params.setRemark(dto.getRemark());
        params.setEntrypoint(dto.getEntrypoint());
        params.setOutput(dto.getOutput());
        String image = FactoryCollection.harborDomain((Long)domainId) + "/" + dto.getRepository() + ":" + dto.getTag();
        params.setImage(image);
        params.setFrameType(dto.getFrame());
        params.setPack((PricePackage)this.pricePackageRepository.findOne((Serializable)dto.getPack()));
        params.setReplicas(dto.getReplicas());
        if (dto.getParams() != null) {
            JSONArray jsonArray = JSONArray.parseArray((String)dto.getParams());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject param = jsonArray.getJSONObject(i);
                String name = param.getString("name");
                if (name.matches("^[\\w-]{1,64}$")) continue;
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.job.params.name.not.match"));
                return res;
            }
            params.setParams(dto.getParams());
        }
        params.setLogDir(dto.getLogDir());
        if (dto.getStorages() != null) {
            params.setStorages(JSON.toJSONString((Object)dto.getStorages()));
        }
        params.setDeleted(Integer.valueOf(0));
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u7f16\u8f91\u8bad\u7ec3\u4efb\u52a1\u53c2\u6570\u540d\u79f0")
    @Transactional
    @PutMapping(value={"api/job/param/{id}/name/{name}"})
    public ResultResponse updateJobParamName(@NotNull @PathVariable(value="id") Long id, @NotNull @PathVariable(value="name") String name, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domain_id = Long.valueOf(domainId);
        Domain domain = this.domainRepository.findByIdAndDeleted(domain_id, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Integer paramNameCount = this.jobParamsRepository.countByNameAndUserAndDepartmentAndDeleted(name, user, dep, Integer.valueOf(0));
        if (null != paramNameCount && paramNameCount > 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.job.param.name.exist"));
            return res;
        }
        JobParams params = (JobParams)this.jobParamsRepository.findOne((Serializable)id);
        params.setName(name);
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.update.remark")
    @ApiOperation(value="\u7f16\u8f91\u8bad\u7ec3\u4efb\u52a1\u53c2\u6570\u5907\u6ce8")
    @Transactional
    @PutMapping(value={"/api/job/param/{id}/remark/{remark}"})
    public ResultResponse updateJobParamRemark(@NotNull @PathVariable(value="id") Long id, @NotNull @PathVariable(value="remark") String remark, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        JobParams params = (JobParams)this.jobParamsRepository.findOne((Serializable)id);
        res.setEntity(params.getName());
        params.setRemark(remark);
        return res;
    }

    @ApiOperation(value="\u8bad\u7ec3\u4efb\u52a1-\u8d44\u6e90\u662f\u5426\u53ef\u7528")
    @Transactional
    @RequestMapping(value={"/api/job/quota"}, method={RequestMethod.GET})
    public ResultResponse jobQuota(HttpServletRequest request) {
        DepQuotas depQuotas;
        Integer org_count;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domainId);
        if (null == orgQuotas) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (orgQuotas.getStatus() != 1) {
            res.setMessage(this.messageUtil.getMessage("msg.account.org.domain.disabled"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer job_limit = orgQuotas.getJobCount();
        if (null != job_limit && job_limit != -1 && (org_count = this.jobRepository.countByDepOrganizationAndDeleted(org, Integer.valueOf(0))) >= job_limit) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.job.org.insufficient"));
            return res;
        }
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId))) {
            Integer user_count;
            String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
            for (OrgConfig config : org.getOrgConfigs()) {
                if (1 != config.getLevel()) continue;
                depName = config.getName();
                break;
            }
            if (null != depQuotas.getJobCount() && depQuotas.getJobCount() != -1 && null != (user_count = this.jobRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user)) && user_count >= depQuotas.getJobCount()) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.insufficient.error", new String[]{depName}));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (null != depQuotas.getJobTime() && depQuotas.getJobTime() != -1.0) {
                Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(1), userId, depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getJobTime() * 60.0 * 60.0) {
                    res.setMessage(this.messageUtil.getMessage("msg.dep.resource.time.insufficient.error", new String[]{depName}));
                    res.setCode(Constants.SC_MSG);
                    return res;
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7248\u672c\u5bf9\u6bd4")
    @Transactional
    @RequestMapping(value={"/api/job/compare/{id}"}, method={RequestMethod.GET})
    public ListResultResponse<JobCompareModel> compare(@NotNull @PathVariable(value="id") Long id, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Job job = this.jobRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == job) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.job.not.exist"));
            return res;
        }
        List versions = this.jobVersionRepository.getByJobAndDeletedOrderByIdDesc(job, Integer.valueOf(0));
        if (null != versions && versions.size() > 0) {
            ArrayList<JobCompareModel> models = new ArrayList<JobCompareModel>();
            for (JobVersion version : versions) {
                JobCompareModel model = new JobCompareModel();
                model.setId(version.getId());
                model.setVersion(version.getVersion());
                model.setParams(version.getParams());
                ModelVersion modelVersion = this.modelVersionRepository.findTopByJobVersionAndDeletedOrderByIdDesc(version, Integer.valueOf(0));
                if (null != modelVersion) {
                    model.setF1(modelVersion.getF1());
                    model.setRecall(modelVersion.getRecall());
                    model.setPrecision(modelVersion.get_precision());
                    model.setAccuracy(modelVersion.getAccuracy());
                }
                models.add(model);
            }
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=1, msgExpression="msg.job.tensorboard.enable")
    @ApiOperation(value="tensorboard\u5f00\u5173", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"/api/job/{id}/tensorboard"})
    public ResultResponse tensorboard(@ApiParam(value="jobVersion id") @PathVariable(value="id") Long id, @RequestBody @Valid TensorboardRequest dto, HttpServletRequest request) throws Exception {
        ResultResponse res = new ResultResponse();
        JobVersion jobVersion = this.jobVersionRepository.findById(id);
        res.setEntity(jobVersion.getJob().getName());
        res.setGuid(jobVersion.getGuid());
        if (dto.getState() == 1 && StringUtils.isEmpty((String)dto.getLogDir())) {
            throw new MessageCodeException(res.getEntity(), res.getGuid(), "msg.tensorboard.logdir.empty", new String[0]);
        }
        jobVersion.setTensorboardState(dto.getState());
        jobVersion.setLogDir(dto.getLogDir());
        Long domainId = (Long)request.getSession().getAttribute("domain");
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        ArrayList volumeMounts = new ArrayList();
        ArrayList volumes = new ArrayList();
        if (dto.getState() == 1) {
            this.jobService.storage(jobVersion, k8sFactory, volumeMounts, volumes);
        }
        this.jobService.tensorboard(jobVersion, k8sFactory, volumes, volumeMounts);
        return res;
    }

    @ConstructorProperties(value={"jobRepository", "userRepository", "pricePackageRepository", "storageRepository", "materialsRepository", "balancesRepository", "storageDeptRepository", "accountNoticePushRepository", "systemConfigRepository", "messageSource", "orgConfigDepartmentRepository", "depUsersRepository", "domainRepository", "organizationQuotasRepository", "referDurationRepository", "depQuotasRepository", "jobParamsRepository", "jobVersionRepository", "modelVersionRepository", "resourceService", "jobService", "messageUtil", "storageServiceFactory", "noticeUserService", "commonService"})
    public JobController(JobRepository jobRepository, UserRepository userRepository, PricePackageRepository pricePackageRepository, StorageRepository storageRepository, MaterialsRepository materialsRepository, BalancesRepository balancesRepository, StorageDeptRepository storageDeptRepository, AccountNoticePushRepository accountNoticePushRepository, SystemConfigRepository systemConfigRepository, MessageSource messageSource, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DepUsersRepository depUsersRepository, DomainRepository domainRepository, OrganizationQuotasRepository organizationQuotasRepository, ReferDurationRepository referDurationRepository, DepQuotasRepository depQuotasRepository, JobParamsRepository jobParamsRepository, JobVersionRepository jobVersionRepository, ModelVersionRepository modelVersionRepository, ResourceService resourceService, JobService jobService, MessageUtil messageUtil, StorageServiceFactory storageServiceFactory, NoticeUserService noticeUserService, CommonService commonService) {
        this.jobRepository = jobRepository;
        this.userRepository = userRepository;
        this.pricePackageRepository = pricePackageRepository;
        this.storageRepository = storageRepository;
        this.materialsRepository = materialsRepository;
        this.balancesRepository = balancesRepository;
        this.storageDeptRepository = storageDeptRepository;
        this.accountNoticePushRepository = accountNoticePushRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.messageSource = messageSource;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.depUsersRepository = depUsersRepository;
        this.domainRepository = domainRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.referDurationRepository = referDurationRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.jobParamsRepository = jobParamsRepository;
        this.jobVersionRepository = jobVersionRepository;
        this.modelVersionRepository = modelVersionRepository;
        this.resourceService = resourceService;
        this.jobService = jobService;
        this.messageUtil = messageUtil;
        this.storageServiceFactory = storageServiceFactory;
        this.noticeUserService = noticeUserService;
        this.commonService = commonService;
    }
}

