/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.EncodeUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.controller.ModelController;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.HarborFrameRepoRepository;
import com.mopaas.server.dao.HarborLabelRepository;
import com.mopaas.server.dao.HarborProjectDeptRepository;
import com.mopaas.server.dao.HarborProjectRepository;
import com.mopaas.server.dao.HarborRepoTagRepository;
import com.mopaas.server.dao.JobRepository;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.ModelRepository;
import com.mopaas.server.dao.ModelVersionRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.ServiceDeployRecordRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.HarborProject;
import com.mopaas.server.entity.Job;
import com.mopaas.server.entity.JobStorage;
import com.mopaas.server.entity.JobVersion;
import com.mopaas.server.entity.Model;
import com.mopaas.server.entity.ModelVersion;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.User;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.HarborFactory;
import com.mopaas.server.harbor.ApiException;
import com.mopaas.server.harbor.api.ProductsApi;
import com.mopaas.server.harbor.model.DetailedTag;
import com.mopaas.server.harbor.model.Label;
import com.mopaas.server.harbor.model.Project;
import com.mopaas.server.harbor.model.Repository;
import com.mopaas.server.model.request.IdRequest;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.ModelCreateRequest;
import com.mopaas.server.model.request.RJSortPageRequest;
import com.mopaas.server.model.request.RemarkUpdateRequest;
import com.mopaas.server.model.response.IdNameModel;
import com.mopaas.server.model.response.IdResponse;
import com.mopaas.server.model.response.InferenceServiceFrameListResponse;
import com.mopaas.server.model.response.JobOriginModel;
import com.mopaas.server.model.response.JobVersionModel;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.ModelModel;
import com.mopaas.server.model.response.ModelVersionModel;
import com.mopaas.server.model.response.ModelVersionResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.VersionResponse;
import com.mopaas.server.service.CommonService;
import com.mopaas.server.service.ModelAsyncService;
import io.minio.Result;
import io.minio.messages.Item;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6a21\u578b\u7ba1\u7406"})
@RestController
public class ModelController {
    final ModelRepository modelRepository;
    final ModelVersionRepository modelVersionRepository;
    final DomainRepository domainRepository;
    final UserRepository userRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final JobVersionRepository jobVersionRepository;
    final StorageRepository storageRepository;
    final DepUsersRepository depUsersRepository;
    final ServiceDeployRecordRepository serviceDeployRecordRepository;
    final JobRepository jobRepository;
    final HarborLabelRepository harborLabelRepository;
    final HarborFrameRepoRepository harborFrameRepoRepository;
    final HarborFactory harborFactory;
    final HarborProjectRepository harborProjectRepository;
    final HarborProjectDeptRepository harborProjectDeptRepository;
    final HarborRepoTagRepository harborRepoTagRepository;
    final CommonService commonService;
    final MessageUtil messageUtil;
    final ModelAsyncService modelAsyncService;
    private final Logger logger = LoggerFactory.getLogger(ModelController.class);

    @ApiOperation(value="\u83b7\u53d6\u6a21\u578b\u7248\u672c,\u65b0\u589e\u7248\u672c\u65f6\u4f20model id")
    @Transactional
    @PutMapping(value={"api/model/version"})
    public VersionResponse getVersion(@RequestBody IdRequest dto, HttpServletRequest request) {
        VersionResponse res = new VersionResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (dto.getId() != null) {
            ModelVersion version = this.modelVersionRepository.findTopByModelIdAndDeletedOrderByIdDesc(dto.getId(), Integer.valueOf(0));
            if (version != null) {
                CharSequence[] split = version.getVersion().split("\\.");
                split[split.length - 1] = String.valueOf(Integer.parseInt(split[split.length - 1]) + 1);
                res.setVersion(String.join((CharSequence)".", split));
            } else {
                res.setVersion("1.0.0");
            }
        } else {
            res.setVersion("1.0.0");
        }
        return res;
    }

    @ApiOperation(value="\u6a21\u578b\u7c7b\u578b\u5217\u8868-v3.4\u65b0\u589e")
    @GetMapping(value={"api/model/frame/types"})
    @Transactional
    public ListResultResponse<IdNameModel> frameTypes(HttpServletRequest request) throws ApiException {
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        ListResultResponse res = new ListResultResponse();
        List sysFrames = this.harborFrameRepoRepository.findByDomainId(domainId);
        Set models = sysFrames.stream().filter(t -> t.getLabels().stream().filter(l -> "active".equals(l.getName()) || "ai-serve".equals(l.getName())).count() == 2L).flatMap(t -> t.getLabels().stream().filter(l -> l.getType() == 0).map(s -> IdNameModel.builder().id(Long.valueOf(s.getHarborId().longValue())).name(s.getName()).build())).collect(Collectors.toSet());
        List featureLabels = this.commonService.getFeatureLabels(domainId);
        ProductsApi productsApi = FactoryCollection.harborApi((Long)domainId);
        List projects = this.commonService.harborProjects(domainId, depId, userId);
        for (HarborProject project : projects) {
            List repositories = productsApi.repositoriesGet(Integer.valueOf(project.getProjectId().intValue()), null, null, null, null, null);
            for (Repository repository : repositories) {
                List tags = productsApi.repositoriesRepoNameTagsGet(repository.getName(), null);
                Set idNameModels = tags.stream().filter(t -> t.getLabels().stream().filter(l -> "active".equals(l.getName()) || "ai-serve".equals(l.getName())).count() == 2L).flatMap(r -> r.getLabels().stream().filter(l -> !featureLabels.contains(l.getName()))).map(l -> IdNameModel.builder().id(Long.valueOf(l.getId().longValue())).name(l.getName()).build()).collect(Collectors.toSet());
                models.addAll(idNameModels);
            }
        }
        res.setList(models);
        return res;
    }

    @ApiOperation(value="\u6a21\u578b\u6846\u67b6\u5217\u8868-v3.4\u65b0\u589e")
    @Transactional
    @GetMapping(value={"api/model/frames/{frameId}"})
    public InferenceServiceFrameListResponse frames(@ApiParam(value="\u6846\u67b6\u7c7b\u578bLabelId") @PathVariable(value="frameId") Integer frameId, HttpServletRequest request) throws ApiException {
        List projects;
        InferenceServiceFrameListResponse res = new InferenceServiceFrameListResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        List h_projects = harborApi.projectsGet("frame_system", null, null, null, null);
        Optional<Project> any = h_projects.stream().filter(p -> "frame_system".equals(p.getName())).findAny();
        if (any.isPresent()) {
            res.setFrames(this.filterFrames(frameId, harborApi, any.get().getProjectId()));
        }
        if (!CollectionUtils.isEmpty((Collection)(projects = this.commonService.harborProjects(domainId, depId, userId)))) {
            HashMap frames = new HashMap();
            for (HarborProject project : projects) {
                frames.putAll(this.filterFrames(frameId, harborApi, Integer.valueOf(project.getProjectId().intValue())));
            }
            res.setUframes(frames);
        }
        return res;
    }

    @NotNull
    private Map<String, Map<String, String>> filterFrames(Integer frameId, ProductsApi harborApi, Integer project) throws ApiException {
        HashMap<String, Map<String, String>> frames = new HashMap<String, Map<String, String>>();
        List repositories = harborApi.repositoriesGet(project, null, null, null, null, null);
        for (Repository repository : repositories) {
            List repoTags;
            String repo = repository.getName();
            List tags = harborApi.repositoriesRepoNameTagsGet(repo, null);
            if (null == tags || tags.isEmpty() || CollectionUtils.isEmpty(repoTags = tags.stream().filter(t -> t.getLabels().stream().filter(l -> l.getId().equals(frameId) || "active".equals(l.getName()) || "ai-serve".equals(l.getName())).count() == 3L).collect(Collectors.toList()))) continue;
            frames.put(repo, new TreeMap());
            for (DetailedTag tag : repoTags) {
                Optional<Label> first = tag.getLabels().stream().filter(e -> "gpu".equals(e.getName()) || "x86".equals(e.getName())).findFirst();
                ((Map)frames.get(repo)).put(tag.getName(), first.isPresent() ? first.get().getName() : "x86");
            }
        }
        return frames;
    }

    @ApiOperation(value="\u5bfc\u5165\u6a21\u578b\u6216\u65b0\u5efa\u6a21\u578b\u7248\u672c")
    @Transactional
    @PostMapping(value={"/api/model/new"})
    public IdResponse create(@RequestBody @Valid ModelCreateRequest dto, HttpServletRequest request) {
        String[] split;
        Integer count;
        IdResponse res = new IdResponse();
        request.setAttribute("resourceType", (Object)4);
        request.setAttribute("resourceName", (Object)dto.getName());
        HttpSession session = request.getSession();
        Long domain_id = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domain_id, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Model model = null;
        if (dto.getId() != null) {
            request.setAttribute("operation", (Object)this.messageUtil.getMessageJson("msg.create.version"));
            model = this.modelRepository.findByIdAndDeleted(dto.getId(), Integer.valueOf(0));
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(model.getUser().getId()), (String)"model:create", (Long)depId)) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                return res;
            }
        } else if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"model:import", (Long)depId)) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthorized"));
            return res;
        }
        if (null == dto.getId()) {
            count = this.modelRepository.countByNameAndDepartmentAndDeleted(dto.getName(), dep, Integer.valueOf(0));
            if (null != count && count > 0) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.name.exist.error", new String[]{this.messageUtil.getMessage("msg.type.model")}));
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.dep.resource.name.exist.error", new String[]{this.messageUtil.getMessageZh("msg.type.model")}, new String[]{this.messageUtil.getMessageEn("msg.type.model")}));
                return res;
            }
        } else {
            if (null == model) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.model.not.exist"));
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.model.not.exist"));
                return res;
            }
            count = this.modelVersionRepository.countByModelAndVersionAndDeleted(model, dto.getVersion(), Integer.valueOf(0));
            if (count != null && count > 0) {
                res.setMessage(this.messageUtil.getMessage("msg.model.version.existed"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.model.version.existed"));
                return res;
            }
        }
        JobVersion jobVersion = null;
        String storagePath = dto.getModelPath();
        if (dto.getJobVersionId() != null) {
            jobVersion = this.jobVersionRepository.getByIdAndDeleted(dto.getJobVersionId(), Integer.valueOf(0));
            if (jobVersion == null) {
                res.setMessage(this.messageUtil.getMessage("msg.job.version.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.job.version.not.exist"));
                return res;
            }
            storagePath = jobVersion.getOutput();
        }
        String path = storagePath;
        Storage storage = null;
        if (storagePath.contains(":/")) {
            split = storagePath.split(":");
            storage = this.storageRepository.findByIdAndDeleted(Long.valueOf(Long.parseLong(split[0])), Integer.valueOf(0));
            path = split[1];
        } else {
            split = storagePath.replace("/ai/", "").split("/");
            List storages = jobVersion.getStorages();
            for (JobStorage js : storages) {
                if (!js.getStorage().getGuid().contains(split[0]) && !storagePath.startsWith(js.getPath())) continue;
                storage = js.getStorage();
            }
        }
        if (storage == null) {
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.not.exist"));
            return res;
        }
        ModelVersion version = (ModelVersion)BeanMapper.map((Object)dto, ModelVersion.class);
        version.setId(null);
        version.setDeleted(Integer.valueOf(0));
        version.setStatus(Integer.valueOf(0));
        version.set_precision(dto.getPrecision());
        version.setJobVersion(jobVersion);
        if (dto.getTags() != null) {
            version.setTags(JSON.toJSONString((Object)dto.getTags()));
        }
        this.modelVersionRepository.save((Object)version);
        if (null == model) {
            model = new Model();
            model.setName(dto.getName());
            model.setDomain(domain);
            model.setDepartment(dep);
            model.setUser(user);
            model.setDeleted(Integer.valueOf(0));
            model.setSequence(UUID.randomUUID().toString().substring(24));
            this.modelRepository.save((Object)model);
        }
        model.setCurrent(version);
        version.setModel(model);
        version.setObsPath("ai-model/" + user.getUsername() + "/" + model.getSequence() + "/" + version.getVersion() + "/0001/");
        Storage finalStorage = storage;
        String finalPath = path;
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        request.setAttribute("result", (Object)"true");
        res.setId(version.getId());
        return res;
    }

    @ApiOperation(value="\u6a21\u578b\u6765\u6e90-\u6a21\u578b\u8bad\u7ec3")
    @Transactional
    @RequestMapping(value={"/api/model/job/list"}, method={RequestMethod.GET})
    public ListResultResponse<JobOriginModel> listModelJob(HttpServletRequest request) {
        Integer finalLevel;
        2 spec;
        List jobs;
        ListResultResponse res = new ListResultResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (jobs = this.jobRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */))) && jobs.size() > 0) {
            ArrayList<JobOriginModel> models = new ArrayList<JobOriginModel>();
            for (Job job : jobs) {
                JobOriginModel model = new JobOriginModel();
                model.setId(job.getId());
                model.setName(job.getName());
                List versions = this.jobVersionRepository.getByJobAndDeletedOrderByIdDesc(job, Integer.valueOf(0));
                if (null != versions && versions.size() > 0) {
                    ArrayList<JobVersionModel> versionModels = new ArrayList<JobVersionModel>();
                    for (JobVersion version : versions) {
                        if (version.getStatus() != 2) continue;
                        JobVersionModel versionModel = new JobVersionModel();
                        versionModel.setId(version.getId());
                        versionModel.setParentVersion(version.getParent() != null ? version.getParent().getVersion() : null);
                        versionModel.setVersion(version.getVersion());
                        versionModel.setCreatedAt(version.getCreatedAt());
                        versionModel.setReplicas(version.getReplicas());
                        PricePackage pack = version.getPack();
                        PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                        if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                            packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
                        }
                        versionModel.setPack(packageInfoModel);
                        versionModels.add(versionModel);
                    }
                    model.setVersions(versionModels);
                }
                models.add(model);
            }
            models.sort((a1, a2) -> a2.getId().compareTo(a1.getId()));
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u578b\u5217\u8868-v3.4\u4fee\u6539:\u8fd4\u56de\u53c2\u6570frameId")
    @Transactional
    @RequestMapping(value={"/api/model/list"}, method={RequestMethod.POST})
    public ListResultResponse<ModelModel> listJob(@RequestBody @Valid RJSortPageRequest dto, HttpServletRequest request) {
        PageRequest pageable;
        Integer finalLevel;
        3 spec;
        Page page;
        ListResultResponse res = new ListResultResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (page = this.modelRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */), (Pageable)(pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"currentCreatedAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"currentId"}))))) {
            List models = page.getContent();
            res.setPages(Integer.valueOf(page.getTotalPages()));
            res.setSize(Long.valueOf(page.getTotalElements()));
            ArrayList<ModelModel> _models = new ArrayList<ModelModel>();
            for (Model model : models) {
                String[] split;
                Storage storage;
                ModelModel _model = new ModelModel();
                _model.setId(model.getId());
                _model.setName(model.getName());
                _model.setSequence(model.getSequence());
                _model.setUsername(model.getUser().getUsername());
                _model.setFullName(model.getUser().getName() == null ? model.getUser().getUsername() : model.getUser().getName());
                ModelVersion version = model.getCurrent();
                _model.setVid(version.getId());
                _model.setStatus(version.getStatus());
                _model.setVersion(version.getVersion());
                _model.setType(Integer.valueOf(version.getJobVersion() != null ? 0 : 1));
                _model.setRemark(version.getRemark());
                _model.setCreateAt(version.getCreatedAt());
                _model.setFrameId(version.getFrameId());
                _model.setFrame(version.getFrame());
                JobVersion jobVersion = version.getJobVersion();
                if (jobVersion != null) {
                    _model.setSource(this.messageUtil.getMessage("msg.job.train") + ":" + jobVersion.getName() + "/" + jobVersion.getVersion());
                } else if (null != version.getModelPath() && null != (storage = (Storage)this.storageRepository.findOne((Serializable)Long.valueOf(Long.parseLong((split = version.getModelPath().split(":"))[0]))))) {
                    _model.setSource(storage.getName() + ":" + split[1]);
                }
                List versions = model.getVersions();
                if (versions != null) {
                    ArrayList<ModelModel.VersionModel> versionModels = new ArrayList<ModelModel.VersionModel>();
                    for (ModelVersion modelVersion : versions) {
                        String[] split2;
                        Storage storage2;
                        if (modelVersion.getDeleted() != 0) continue;
                        ModelModel.VersionModel versionModel = new ModelModel.VersionModel();
                        versionModel.setVid(modelVersion.getId());
                        versionModel.setStatus(modelVersion.getStatus());
                        versionModel.setVersion(modelVersion.getVersion());
                        versionModel.setType(Integer.valueOf(modelVersion.getJobVersion() != null ? 0 : 1));
                        versionModel.setRemark(modelVersion.getRemark());
                        versionModel.setCreateAt(modelVersion.getCreatedAt());
                        versionModel.setFrameId(modelVersion.getFrameId());
                        versionModel.setFrame(modelVersion.getFrame());
                        jobVersion = modelVersion.getJobVersion();
                        if (jobVersion != null) {
                            versionModel.setSource(this.messageUtil.getMessage("msg.job.train") + ":" + jobVersion.getName() + "/" + jobVersion.getVersion());
                        } else if (null != modelVersion.getModelPath() && null != (storage2 = (Storage)this.storageRepository.findOne((Serializable)Long.valueOf(Long.parseLong((split2 = modelVersion.getModelPath().split(":"))[0]))))) {
                            versionModel.setSource(storage2.getName() + ":" + split2[1]);
                        }
                        versionModels.add(versionModel);
                    }
                    _model.setVersions(versionModels);
                }
                _models.add(_model);
            }
            res.setList(_models);
        }
        return res;
    }

    @LogAnnotation(type=4, msgExpression="msg.remove.version.model")
    @ApiOperation(value="\u5220\u9664\u6a21\u578b\u7248\u672c")
    @Transactional
    @DeleteMapping(value={"/api/model/version/{id}"})
    public ResultResponse versionRemove(@ApiParam(value="\u6a21\u578b\u7248\u672cid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        ModelVersion modelVersion = this.modelVersionRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == modelVersion) {
            throw new MessageCodeException(null, null, "msg.model.version.not.exist", new String[0]);
        }
        res.setEntity(modelVersion.getName());
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(modelVersion.getName(), modelVersion.getModel().getSequence(), "msg.account.dep.unauthenticated", new String[0]);
        }
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(modelVersion.getModel().getUser().getId()), (String)"model:delete", (Long)depId)) {
            throw new MessageCodeException(modelVersion.getName(), modelVersion.getModel().getSequence(), "msg.account.unauthorized", new String[0]);
        }
        Integer serviceDeployRefer = this.serviceDeployRecordRepository.countByModelVersionAndDeleted(modelVersion, Integer.valueOf(0));
        if (serviceDeployRefer > 0) {
            String[] modelNames = new String[]{modelVersion.getName(), modelVersion.getVersion()};
            throw new MessageCodeException(modelVersion.getName(), modelVersion.getModel().getSequence(), "msg.model.remove.refer", modelNames);
        }
        try {
            Model model = modelVersion.getModel();
            if (model.getCurrent().getId().equals(modelVersion.getId())) {
                List top2 = this.modelVersionRepository.getTop2ByModelAndDeletedOrderByIdDesc(model, Integer.valueOf(0));
                if (top2.size() > 1) {
                    model.setCurrent(modelVersion.getId().equals(((ModelVersion)top2.get(0)).getId()) ? (ModelVersion)top2.get(1) : (ModelVersion)top2.get(0));
                } else {
                    model.setDeleted(Integer.valueOf(1));
                }
            }
            modelVersion.setDeleted(Integer.valueOf(1));
            String[] split = modelVersion.getObsPath().split("/");
            FactoryCollection.minioRemoveObjects((Long)domainId, (String)"ai-model", (String)(split[1] + "/" + split[2] + "/" + split[3]));
        }
        catch (Exception e) {
            this.logger.error("delete model [" + modelVersion.getName() + "] version [" + modelVersion.getVersion() + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    @ApiOperation(value="\u5220\u9664\u6a21\u578b")
    @Transactional
    @DeleteMapping(value={"/api/model"})
    public ResultResponse remove(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        request.setAttribute("resourceType", (Object)4);
        List models = this.modelRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        if (null == models) {
            request.setAttribute("result", (Object)"true");
            return res;
        }
        StringBuilder resourceNames = new StringBuilder();
        for (Model model : models) {
            resourceNames.append("," + model.getName());
            request.setAttribute("resourceName", (Object)String.valueOf(resourceNames).substring(1));
        }
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        ArrayList<ModelVersion> modelVersions = new ArrayList<ModelVersion>();
        for (Model model : models) {
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(model.getUser().getId()), (String)"model:delete", (Long)depId)) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthorized"));
                return res;
            }
            List versions = this.modelVersionRepository.findByModelAndDeleted(model, Integer.valueOf(0));
            for (ModelVersion version : versions) {
                Integer serviceDeployRefer = this.serviceDeployRecordRepository.countByModelVersionAndDeleted(version, Integer.valueOf(0));
                if (serviceDeployRefer > 0) {
                    res.setCode(Constants.SC_MSG);
                    String[] modelNames = new String[]{model.getName(), version.getVersion()};
                    res.setMessage(this.messageUtil.getMessage("msg.model.remove.refer", modelNames));
                    request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.model.remove.refer", modelNames));
                    return res;
                }
                modelVersions.add(version);
            }
        }
        if (!modelVersions.isEmpty()) {
            Long domainId = (Long)session.getAttribute("domain");
            for (ModelVersion version : modelVersions) {
                this.modelAsyncService.modelRemove(version, domainId);
                version.setDeleted(Integer.valueOf(1));
                version.getModel().setDeleted(Integer.valueOf(1));
            }
        }
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=4, msgExpression="msg.rename.model")
    @ApiOperation(value="\u6a21\u578b\u91cd\u547d\u540d")
    @Transactional
    @PutMapping(value={"/api/model/{id}/name/{name}"})
    public ResultResponse rename(@PathVariable(value="id") Long id, @PathVariable(value="name") @ApiParam(value="\u6a21\u578b\u65b0\u540d\u79f0") String name, HttpServletRequest request) {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        Model model = this.modelRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == model) {
            throw new MessageCodeException(null, null, "msg.model.not.exist", new String[0]);
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(model.getName(), model.getSequence(), "msg.account.unauthenticated", new String[0]);
        }
        Long depId = (Long)session.getAttribute("departmentId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(model.getUser().getId()), (String)"model:name", (Long)depId)) {
            throw new MessageCodeException(model.getName(), model.getSequence(), "msg.account.unauthorized", new String[0]);
        }
        res.setEntity(model.getName());
        Integer count = this.modelRepository.countByNameAndDepartmentAndDeleted(name, model.getDepartment(), Integer.valueOf(0));
        if (null != count && count > 0) {
            throw new MessageJsonException(model.getName(), model.getSequence(), "msg.dep.resource.name.exist.error", new String[]{"msg.type.model"});
        }
        model.setName(name);
        return res;
    }

    @LogAnnotation(type=4, msgExpression="msg.update.remark")
    @ApiOperation(value="\u4fee\u6539\u6a21\u578b\u7ba1\u7406\u5907\u6ce8")
    @Transactional
    @RequestMapping(value={"/api/model/remark"}, method={RequestMethod.PUT})
    public ResultResponse updateRemark(@RequestBody @Valid RemarkUpdateRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(null, null, "msg.account.unauthenticated", new String[0]);
        }
        ModelVersion version = this.modelVersionRepository.findByIdAndDeleted(dto.getId(), Integer.valueOf(0));
        if (null == version) {
            throw new MessageCodeException(null, null, "msg.model.version.not.exist", new String[0]);
        }
        res.setEntity(version.getName());
        version.setRemark(dto.getRemark());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u578b\u7248\u672c\u5217\u8868")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/model/{id}/versions"})
    public ListResultResponse<ModelVersionModel> listVersion(@PathVariable(value="id") Long id) {
        ListResultResponse res = new ListResultResponse();
        Model _model = (Model)this.modelRepository.findOne((Serializable)id);
        if (null != _model) {
            List versions = this.modelVersionRepository.getByModelAndDeletedOrderByIdDesc(_model, Integer.valueOf(0));
            ArrayList<ModelVersionModel> models = new ArrayList<ModelVersionModel>();
            for (ModelVersion version : versions) {
                ModelVersionModel model = new ModelVersionModel();
                model.setId(version.getId());
                model.setVersion(version.getVersion());
                model.setCreatedAt(version.getCreatedAt());
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u578b\u8be6\u60c5")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/model/version/{id}"})
    public ModelVersionResponse model(@PathVariable(value="id") Long id, HttpServletRequest request) {
        Long domainId = (Long)request.getSession().getAttribute("domain");
        ModelVersion version = this.modelVersionRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == version) {
            ModelVersionResponse res = new ModelVersionResponse();
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.model.not.exist"));
            return res;
        }
        ModelVersionResponse res = (ModelVersionResponse)BeanMapper.map((Object)version, ModelVersionResponse.class);
        Model model = version.getModel();
        res.setUsername(model.getUser().getUsername());
        res.setFullName(model.getUser().getName());
        res.setName(model.getName());
        res.setModelSequence(model.getSequence());
        res.setModelVersion(version.getVersion());
        res.setPrecision(version.get_precision());
        JobVersion jobVersion = version.getJobVersion();
        if (jobVersion != null) {
            res.setJobId(version.getJobVersion().getJob().getId());
            res.setJobVersionId(version.getJobVersion().getId());
            res.setSource(this.messageUtil.getMessage("msg.job.train") + ":" + jobVersion.getName() + "/" + jobVersion.getVersion());
        } else if (null != version.getModelPath()) {
            String[] split = version.getModelPath().split(":");
            Storage storage = (Storage)this.storageRepository.findOne((Serializable)Long.valueOf(Long.parseLong(split[0])));
            if (null == storage) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
                return res;
            }
            res.setModelPath(version.getModelPath());
            res.setSource(storage.getName() + ":" + split[1]);
            res.setStorage(storage.getName());
            res.setStorageAccessPwd(EncodeUtil.rawInput((String)storage.getPassword()));
            String address = "k8s/%s/index.php?user/loginSubmit";
            res.setStorageAccessUrl(String.format(address, storage.getWebPort()));
        }
        if (null != version.getStatus() && version.getStatus() == 1) {
            try {
                Iterator iterator = FactoryCollection.minioClient((Long)domainId).listObjects("ai-model", model.getUser().getUsername() + "/" + model.getSequence() + "/" + version.getVersion()).iterator();
                float size = 0.0f;
                while (iterator.hasNext()) {
                    Item item = (Item)((Result)iterator.next()).get();
                    size += (float)item.objectSize();
                }
                res.setSize(SizeConverter.BTrim.convert(size));
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return res;
    }

    @ApiOperation(value="\u6a21\u578b\u4e0b\u8f7d")
    @Transactional
    @PostMapping(value={"/api/model/version/{id}/download"})
    public ResultResponse download(@ApiParam(value="\u6a21\u578b\u7248\u672cid") @PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        ModelVersion version = this.modelVersionRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == version) {
            res = new ModelVersionResponse();
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.model.not.exist"));
            return res;
        }
        String obsPath = version.getObsPath();
        String prefix = obsPath.substring(obsPath.indexOf("/"), obsPath.lastIndexOf("/"));
        FactoryCollection.download((HttpServletResponse)response, (Long)domainId, (String)"ai-model", (String)prefix);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ConstructorProperties(value={"modelRepository", "modelVersionRepository", "domainRepository", "userRepository", "orgConfigDepartmentRepository", "jobVersionRepository", "storageRepository", "depUsersRepository", "serviceDeployRecordRepository", "jobRepository", "harborLabelRepository", "harborFrameRepoRepository", "harborFactory", "harborProjectRepository", "harborProjectDeptRepository", "harborRepoTagRepository", "commonService", "messageUtil", "modelAsyncService"})
    public ModelController(ModelRepository modelRepository, ModelVersionRepository modelVersionRepository, DomainRepository domainRepository, UserRepository userRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, JobVersionRepository jobVersionRepository, StorageRepository storageRepository, DepUsersRepository depUsersRepository, ServiceDeployRecordRepository serviceDeployRecordRepository, JobRepository jobRepository, HarborLabelRepository harborLabelRepository, HarborFrameRepoRepository harborFrameRepoRepository, HarborFactory harborFactory, HarborProjectRepository harborProjectRepository, HarborProjectDeptRepository harborProjectDeptRepository, HarborRepoTagRepository harborRepoTagRepository, CommonService commonService, MessageUtil messageUtil, ModelAsyncService modelAsyncService) {
        this.modelRepository = modelRepository;
        this.modelVersionRepository = modelVersionRepository;
        this.domainRepository = domainRepository;
        this.userRepository = userRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.jobVersionRepository = jobVersionRepository;
        this.storageRepository = storageRepository;
        this.depUsersRepository = depUsersRepository;
        this.serviceDeployRecordRepository = serviceDeployRecordRepository;
        this.jobRepository = jobRepository;
        this.harborLabelRepository = harborLabelRepository;
        this.harborFrameRepoRepository = harborFrameRepoRepository;
        this.harborFactory = harborFactory;
        this.harborProjectRepository = harborProjectRepository;
        this.harborProjectDeptRepository = harborProjectDeptRepository;
        this.harborRepoTagRepository = harborRepoTagRepository;
        this.commonService = commonService;
        this.messageUtil = messageUtil;
        this.modelAsyncService = modelAsyncService;
    }
}

