/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.HarborLabelRepository;
import com.mopaas.server.dao.HarborProjectDeptRepository;
import com.mopaas.server.dao.HarborProjectRepository;
import com.mopaas.server.dao.HarborRepoTagRepository;
import com.mopaas.server.dao.HarborUserRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.HarborProject;
import com.mopaas.server.entity.HarborProjectDept;
import com.mopaas.server.entity.HarborRepoTag;
import com.mopaas.server.entity.HarborUser;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.harbor.ApiException;
import com.mopaas.server.harbor.api.ProductsApi;
import com.mopaas.server.harbor.model.DetailedTag;
import com.mopaas.server.harbor.model.Label;
import com.mopaas.server.harbor.model.Project;
import com.mopaas.server.harbor.model.ProjectMemberEntity;
import com.mopaas.server.harbor.model.Repository;
import com.mopaas.server.harbor.model.RepositoryDescription;
import com.mopaas.server.harbor.model.User;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.ImageAllSearchRequest;
import com.mopaas.server.model.request.ImageRepoNamesRequest;
import com.mopaas.server.model.request.ImageSelectRequest;
import com.mopaas.server.model.request.ImageSelectsRequest;
import com.mopaas.server.model.request.RepoDepSelectRequest;
import com.mopaas.server.model.request.UpdateImageRequest;
import com.mopaas.server.model.response.BooleanResponse;
import com.mopaas.server.model.response.DepSelectModel;
import com.mopaas.server.model.response.ImageModel;
import com.mopaas.server.model.response.ImageTagInfoModel;
import com.mopaas.server.model.response.ListImageAllResultResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.CommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import okhttp3.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u955c\u50cf\u4ed3\u5e93-\u670d\u52a1\u955c\u50cf\uff08\u6a21\u578b\u670d\u52a1\uff09"})
@RestController
public class ModelImageController {
    final UserRepository userRepository;
    final HarborProjectRepository harborProjectRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final HarborProjectDeptRepository harborProjectDeptRepository;
    final DepUsersRepository depUsersRepository;
    final DomainRepository domainRepository;
    final HarborUserRepository harborUserRepository;
    final MessageUtil messageUtil;
    final HarborRepoTagRepository harborRepoTagRepository;
    final ResourceRepository resourceRepository;
    final HarborLabelRepository harborLabelRepository;
    final CommonService commonService;
    private static final Logger logger = LoggerFactory.getLogger(ModelImageController.class);
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u7ed1\u5b9a\u90ae\u7bb1")
    @Transactional
    @RequestMapping(value={"/api/model/isbinding/email"}, method={RequestMethod.GET})
    public BooleanResponse isBindingEmail(HttpServletRequest request) {
        BooleanResponse res = new BooleanResponse();
        res.setCode(Constants.SC_ERROR);
        Long userId = (Long)request.getSession().getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String email = user.getEmail();
        Boolean aboolean = false;
        if (email != null && !email.isEmpty()) {
            aboolean = true;
        }
        res.setABoolean(aboolean.booleanValue());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5207\u6362\u8bbf\u95ee\u7ea7\u522b(\u516c\u5f00\u3001\u79c1\u6709)")
    @Transactional
    @RequestMapping(value={"/api/model/repository/public/{projectId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResultResponse changePublic(@PathVariable(value="projectId") Long projectId, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        Long userId = (Long)request.getSession().getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomain(projectId, domain);
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)harborProject.getProjectName());
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = huser.getHarborUsername();
        Integer flag = this.getPermission(projectId, harborUsername, harborApi);
        if (flag == 0) {
            res.setMessage(this.messageUtil.getMessage("msg.repo.project.permission.denied"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.permission.denied"));
            return res;
        }
        if (harborProject.getIsPublic() == 0) {
            harborProject.setIsPublic(Integer.valueOf(1));
        } else {
            harborProject.setIsPublic(Integer.valueOf(0));
        }
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u955c\u50cf\u4ed3\u5e93")
    @Transactional
    @RequestMapping(value={"/api/model/repository/delete"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResultResponse deleteRepos(@ApiParam(value="projectId") @Valid @RequestBody IdsRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        request.setAttribute("resourceType", (Object)6);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer count = this.harborProjectRepository.countByProjectIdInAndDomain(dto.getIds(), domain);
        if (count == null || count == 0) {
            res.setMessage(this.messageUtil.getMessage("msg.frame.repo.not.exist"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.frame.repo.not.exist"));
            return res;
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = huser.getHarborUsername();
        try {
            List userList = harborApi.usersGet(harborUsername, null, null, null);
            User harborUser = null;
            for (User u : userList) {
                if (!harborUsername.equals(u.getUsername())) continue;
                harborUser = u;
                break;
            }
            if (harborUser == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.user.not.initialize"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        List ids = dto.getIds();
        StringBuilder resourceNames = new StringBuilder();
        if (ids != null && ids.size() > 0) {
            HarborProject harborProject;
            for (Long projectId : ids) {
                harborProject = this.harborProjectRepository.findByProjectIdAndDomain(projectId, domain);
                if (harborProject == null) continue;
                resourceNames.append("," + harborProject.getProjectName());
                request.setAttribute("resourceName", (Object)String.valueOf(resourceNames).substring(1));
                DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
                if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(harborProject.getOwner().getId()), (String)"image:repo-delete", (Long)depId)) {
                    res.setCode(Constants.SC_MSG);
                    res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                    request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthorized"));
                    return res;
                }
                try {
                    Project project = harborApi.projectsProjectIdGet(projectId);
                    if (project == null) {
                        res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                        res.setCode(Constants.SC_MSG);
                        request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.not.exist"));
                        return res;
                    }
                    Integer repoCount = project.getRepoCount();
                    if (repoCount == null || repoCount <= 0) continue;
                    res.setMessage(this.messageUtil.getMessage("msg.harbor.image.remove.error"));
                    res.setCode(Constants.SC_MSG);
                    request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.harbor.image.remove.error"));
                    return res;
                }
                catch (ApiException e) {
                    logger.error(e.getResponseBody());
                    if (!e.getResponseBody().contains("contains repositories")) continue;
                    res.setMessage(this.messageUtil.getMessage("msg.harbor.image.remove.error"));
                    res.setCode(Constants.SC_MSG);
                    request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.harbor.image.remove.error"));
                    return res;
                }
            }
            for (Long projectId : ids) {
                harborProject = this.harborProjectRepository.findByProjectIdAndDomain(projectId, domain);
                try {
                    this.harborProjectDeptRepository.removeByProjectId(projectId);
                    harborApi.projectsProjectIdDelete(projectId);
                    harborProject.setDeleted(Integer.valueOf(1));
                    res.setCode(Constants.SC_OK);
                }
                catch (ApiException e) {
                    logger.error(e.getResponseBody());
                    if (!e.getResponseBody().contains("contains repositories")) continue;
                    res.setMessage(this.messageUtil.getMessage("msg.harbor.image.remove.error"));
                    res.setCode(Constants.SC_MSG);
                    request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.harbor.image.remove.error"));
                    return res;
                }
            }
        }
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u955c\u50cf\u7ba1\u7406\u5217\u8868\uff0cv3.5\u65b0\u589e\uff0c\u8fd4\u56de\u6240\u6709project\u4e0b\u955c\u50cf")
    @Transactional
    @RequestMapping(value={"/api/model/repository/image/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ListImageAllResultResponse<ImageModel> getAllImageList(@Valid @RequestBody ImageAllSearchRequest dto, HttpServletRequest request) throws ApiException {
        List projectList;
        ListImageAllResultResponse res = new ListImageAllResultResponse();
        Long userId = (Long)request.getSession().getAttribute("userId");
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        Long depId = (Long)request.getSession().getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depOwner = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer userType = 3;
        if (depOwner != null) {
            userType = depOwner.getType();
        }
        if (userType < 3) {
            if (null != dto.getUserId()) {
                projectList = this.harborProjectRepository.findByDepartmentIdAndOwnerIdAndDomainId(depId, dto.getUserId(), domainId);
            } else {
                projectList = this.harborProjectRepository.findByDepartmentId(depId);
                List harborProjectDeptList = this.harborProjectDeptRepository.findByDepartmentId(depId);
                for (HarborProjectDept dept : harborProjectDeptList) {
                    HarborProject project = this.harborProjectRepository.findByProjectIdAndDomainId(dept.getProjectId(), domainId);
                    if (null == project || !projectList.stream().noneMatch(e -> project.getId().equals(e.getId()))) continue;
                    projectList.add(project);
                }
            }
        } else {
            projectList = this.harborProjectRepository.findByDepartmentIdAndOwnerIdAndDomainId(depId, userId, domainId);
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        ArrayList<ImageModel> imageList = new ArrayList<ImageModel>();
        for (HarborProject harborProject : projectList) {
            Long projectId = harborProject.getProjectId();
            try {
                HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(harborProject.getOwner(), domain);
                List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
                User harborUser = null;
                for (User u : userList) {
                    if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                    harborUser = u;
                    break;
                }
                if (harborUser == null) continue;
                List repositories = null;
                repositories = dto.getSearch() != null && !dto.getSearch().isEmpty() ? harborApi.repositoriesGet(Integer.valueOf(projectId.intValue()), dto.getSearch(), null, null, Integer.valueOf(1), Integer.valueOf(100)) : harborApi.repositoriesGet(Integer.valueOf(projectId.intValue()), null, null, null, Integer.valueOf(1), Integer.valueOf(100));
                com.mopaas.server.entity.User owner = harborProject.getOwner();
                Integer flag = 0;
                if (harborProject.getIsPublic() == 1) {
                    flag = 1;
                } else if (owner.getId().equals(user.getId())) {
                    flag = 1;
                }
                Project project = harborApi.projectsProjectIdGet(projectId);
                if (repositories == null || repositories.size() <= 0) continue;
                for (Repository repo : repositories) {
                    List tags = harborApi.repositoriesRepoNameTagsGet(repo.getName(), null);
                    ImageModel imageModel = new ImageModel();
                    imageModel.setPermission(flag);
                    imageModel.setProjectId(projectId);
                    imageModel.setProjectName(project.getName());
                    imageModel.setName(repo.getName().substring(repo.getName().lastIndexOf("/") + 1));
                    imageModel.setCreateTime(TimeUtil.tranDate((String)repo.getCreationTime()));
                    imageModel.setUpdateTime(TimeUtil.tranDate((String)repo.getUpdateTime()));
                    imageModel.setUserName(harborProject.getOwner().getUsername());
                    imageModel.setFullName(harborProject.getOwner().getName());
                    ArrayList<ImageTagInfoModel> tagList = new ArrayList<ImageTagInfoModel>();
                    List frames = this.commonService.getFrames(domainId);
                    if (tags != null) {
                        DetailedTag latest = tags.stream().filter(t -> !t.getName().endsWith("-origin")).max(Comparator.comparing(DetailedTag::getPushTime)).get();
                        imageModel.setAddress(FactoryCollection.harborDomainExternal((Long)domainId) + "/" + repo.getName() + ":" + latest.getName());
                        for (DetailedTag tag : tags) {
                            if (tag.getName().endsWith("-origin")) continue;
                            ImageTagInfoModel tagInfoModel = new ImageTagInfoModel();
                            int state = 0;
                            List labels = tag.getLabels();
                            if (!CollectionUtils.isEmpty((Collection)labels) && labels.stream().anyMatch(l -> "active".equals(l.getName()))) {
                                state = 1;
                            }
                            int isLabeled = 0;
                            if (!CollectionUtils.isEmpty((Collection)labels) && labels.stream().filter(l -> frames.contains(l.getName()) || l.getName().equals("gpu") || l.getName().equals("x86")).count() > 1L && labels.stream().anyMatch(l -> l.getName().startsWith("ai-"))) {
                                isLabeled = 1;
                            }
                            tagInfoModel.setIsLabeled(Integer.valueOf(isLabeled));
                            HarborRepoTag hrt = this.harborRepoTagRepository.findTopByRepositoryAndTagOrderByIdDesc(repo.getName(), tag.getName());
                            if (null != hrt) {
                                tagInfoModel.setId(hrt.getId());
                                tagInfoModel.setType(hrt.getType());
                            }
                            tagInfoModel.setTag(tag.getName());
                            tagInfoModel.setState(Integer.valueOf(state));
                            tagList.add(tagInfoModel);
                        }
                    } else {
                        List labels = harborApi.repositoriesRepoNameTagsTagLabelsGet(repo.getName(), "latest");
                        imageModel.setAddress(FactoryCollection.harborDomainExternal((Long)domainId) + "/" + repo.getName() + ":latest");
                        ImageTagInfoModel tagInfoModel = new ImageTagInfoModel();
                        int state = 0;
                        if (!CollectionUtils.isEmpty((Collection)labels) && labels.stream().anyMatch(l -> "active".equals(l.getName()))) {
                            state = 1;
                        }
                        int isLabeled = 0;
                        if (!CollectionUtils.isEmpty((Collection)labels) && labels.stream().filter(l -> frames.contains(l.getName()) || l.getName().equals("gpu") || l.getName().equals("x86")).count() > 1L && labels.stream().anyMatch(l -> l.getName().startsWith("ai-"))) {
                            isLabeled = 1;
                        }
                        tagInfoModel.setIsLabeled(Integer.valueOf(isLabeled));
                        HarborRepoTag hrt = this.harborRepoTagRepository.findTopByRepositoryAndTagOrderByIdDesc(repo.getName(), "latest");
                        if (null != hrt) {
                            tagInfoModel.setId(hrt.getId());
                            tagInfoModel.setType(hrt.getType());
                        }
                        tagInfoModel.setState(Integer.valueOf(state));
                        tagInfoModel.setTag("latest");
                        tagList.add(tagInfoModel);
                    }
                    imageModel.setTagList(tagList);
                    String repoDescription = repo.getDescription();
                    if (repoDescription != null && !repoDescription.isEmpty()) {
                        imageModel.setDescription(repoDescription);
                    }
                    imageList.add(imageModel);
                }
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
        imageList.sort((a1, a2) -> a2.getCreateTime().compareTo(a1.getCreateTime()));
        res.setList(imageList);
        res.setSize(Long.valueOf(imageList.size()));
        return res;
    }

    @ApiOperation(value="\u5220\u9664\u955c\u50cf")
    @Transactional
    @RequestMapping(value={"/api/repository/image/delete"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResultResponse deleteImage(@Valid @RequestBody ImageSelectsRequest dto, HttpServletRequest request) throws ApiException {
        HttpSession session;
        Long userId;
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)dto.getRepoName());
        if (dto.getTags() != null) {
            request.setAttribute("operation", (Object)this.messageUtil.getMessageJson("msg.delete.version"));
        }
        if ((userId = (Long)(session = request.getSession()).getAttribute("userId")) == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.user.not.exist"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        String harborAddr = FactoryCollection.harborDomain((Long)domainId);
        String image = harborAddr + "/" + dto.getRepoName() + ":";
        if (dto.getTags() != null && !dto.getTags().isEmpty()) {
            List tags = dto.getTags();
            for (String tag : tags) {
                Integer count = this.resourceRepository.countByImageLikeAndDomainAndDeleted("%" + image + tag + "%", domain, 0);
                if (count <= 0) continue;
                res.setMessage(this.messageUtil.getMessage("msg.image.tag.can.not.delete"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.image.tag.can.not.delete"));
                return res;
            }
        } else {
            Integer count = this.resourceRepository.countByImageLikeAndDomainAndDeleted("%" + image + "%", domain, 0);
            if (count > 0) {
                res.setMessage(this.messageUtil.getMessage("msg.image.can.not.delete"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.image.can.not.delete"));
                return res;
            }
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        String projectName = dto.getRepoName().substring(0, dto.getRepoName().indexOf("/"));
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = huser.getHarborUsername();
        try {
            List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
            User harborUser = null;
            for (User u : userList) {
                if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                harborUser = u;
                break;
            }
            if (harborUser == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.user.not.initialize"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.user.not.initialize"));
                return res;
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        try {
            Project project = this.getProjectByName(projectName, harborApi);
            if (project == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.not.exist"));
                return res;
            }
            HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomain(Long.valueOf(project.getProjectId().intValue()), domain);
            if (dto.getTags() == null || dto.getTags().isEmpty()) {
                if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(harborProject.getOwner().getId()), (String)"image:delete", (Long)depId)) {
                    res.setCode(Constants.SC_MSG);
                    res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                    return res;
                }
            } else if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(harborProject.getOwner().getId()), (String)"image:version-delete", (Long)depId)) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                return res;
            }
            List harborTags = harborApi.repositoriesRepoNameTagsGet(dto.getRepoName(), null);
            Integer count = 0;
            for (DetailedTag tag : harborTags) {
                if (tag.getName().endsWith("-origin")) continue;
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            List tags = dto.getTags();
            if (tags != null && tags.size() > 0 && tags.size() < count) {
                for (String tag : tags) {
                    harborApi.repositoriesRepoNameTagsTagDelete(dto.getRepoName(), tag);
                    this.harborRepoTagRepository.deleteByRepositoryAndTag(dto.getRepoName(), tag);
                }
            } else {
                harborApi.repositoriesRepoNameDelete(dto.getRepoName());
                this.harborRepoTagRepository.deleteByRepository(dto.getRepoName());
            }
            res.setCode(Constants.SC_OK);
        }
        catch (ApiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            res.setMessage(e.getResponseBody());
            request.setAttribute("errorMessage", (Object)res.getMessage());
            return res;
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @LogAnnotation(type=6, msgExpression="msg.remove.image")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u955c\u50cf")
    @Transactional
    @RequestMapping(value={"/api/repository/image/delete/batch"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResultResponse deleteImagesBatch(@Valid @RequestBody ImageRepoNamesRequest dto, HttpServletRequest request) throws ApiException {
        HttpSession session;
        Long userId;
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        StringBuilder resourceNames = new StringBuilder();
        for (String repoName : dto.getRepoNames()) {
            resourceNames.append("," + repoName);
        }
        String names = null;
        if (resourceNames.length() > 1) {
            names = String.valueOf(resourceNames).substring(1);
            res.setEntity(names);
        }
        if ((userId = (Long)(session = request.getSession()).getAttribute("userId")) == null) {
            throw new MessageCodeException(names, null, "msg.account.unauthenticated", new String[0]);
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            throw new MessageCodeException(names, null, "msg.user.not.exist", new String[0]);
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(names, null, "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            throw new MessageCodeException(names, null, "msg.domain.unavailable", new String[0]);
        }
        String harborAddr = FactoryCollection.harborDomain((Long)domainId);
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = huser.getHarborUsername();
        try {
            List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
            User harborUser = null;
            for (User u : userList) {
                if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                harborUser = u;
                break;
            }
            if (harborUser == null) {
                throw new MessageCodeException(names, null, "msg.repo.user.not.initialize", new String[0]);
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        StringBuilder resourceUsedNames = new StringBuilder();
        for (String repoName : dto.getRepoNames()) {
            String image = harborAddr + "/" + repoName + ":";
            Integer usedCount = this.resourceRepository.countByImageLikeAndDomainAndDeleted("%" + image + "%", domain, 0);
            if (usedCount <= 0) continue;
            resourceUsedNames.append("," + repoName);
        }
        if (resourceUsedNames.length() > 0) {
            throw new MessageCodeException(names, null, "msg.image.can.not.delete.batch", new String[]{String.valueOf(resourceUsedNames).substring(1)});
        }
        for (String repoName : dto.getRepoNames()) {
            String projectName = repoName.substring(0, repoName.indexOf("/"));
            try {
                Project project = this.getProjectByName(projectName, harborApi);
                if (project == null) {
                    throw new MessageCodeException(names, null, "msg.repo.project.not.exist", new String[0]);
                }
                HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomain(Long.valueOf(project.getProjectId().intValue()), domain);
                if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(harborProject.getOwner().getId()), (String)"image:delete", (Long)depId)) {
                    throw new MessageCodeException(names, null, "msg.account.unauthorized", new String[0]);
                }
                harborApi.repositoriesRepoNameDelete(repoName);
                this.harborRepoTagRepository.deleteByRepository(repoName);
                res.setCode(Constants.SC_OK);
            }
            catch (ApiException e) {
                logger.error(e.getMessage(), (Throwable)e);
                res.setMessage(e.getResponseBody());
                return res;
            }
        }
        return res;
    }

    @ApiOperation(value="\u955c\u50cf-\u4fee\u6539\u955c\u50cf")
    @Transactional
    @RequestMapping(value={"/api/repository/image/update"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse updateImage(@Valid @RequestBody UpdateImageRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)dto.getRepoName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        String projectName = dto.getRepoName().substring(0, dto.getRepoName().indexOf("/"));
        HarborProject harborProject = this.harborProjectRepository.findTopByDomainAndProjectNameAndDeleted(domain, projectName, Integer.valueOf(0));
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(harborProject.getOwner().getId()), (String)"image:remark", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = huser.getHarborUsername();
        try {
            List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
            User harborUser = null;
            for (Object u : userList) {
                if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                harborUser = u;
                break;
            }
            if (harborUser == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.user.not.initialize"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.user.not.initialize"));
                return res;
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        try {
            Project project = this.getProjectByName(projectName, harborApi);
            if (project == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.not.exist"));
                return res;
            }
            Repository repo = null;
            List repositories = harborApi.repositoriesGet(project.getProjectId(), dto.getRepoName(), null, null, Integer.valueOf(1), Integer.valueOf(100));
            if (repositories != null && repositories.size() > 0) {
                for (Repository r : repositories) {
                    if (!r.getName().equals(dto.getRepoName())) continue;
                    repo = r;
                    break;
                }
            }
            if (repo == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.repository.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.repository.not.exist"));
                return res;
            }
            RepositoryDescription description = new RepositoryDescription();
            description.setDescription(dto.getDescription());
            harborApi.repositoriesRepoNamePut(repo.getName(), description);
            res.setCode(Constants.SC_OK);
        }
        catch (ApiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            res.setMessage(e.getResponseBody());
            request.setAttribute("errorMessage", (Object)res.getMessage());
            return res;
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u955c\u50cf-\u7981\u7528")
    @Transactional
    @RequestMapping(value={"/api/model/repository/image/inactive"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse inactiveImage(@Valid @RequestBody ImageSelectRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)(dto.getRepoName() + ":" + dto.getTag()));
        Long userId = (Long)request.getSession().getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.user.not.exist"));
            return res;
        }
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = huser.getHarborUsername();
        try {
            List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
            User harborUser = null;
            for (User u : userList) {
                if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                harborUser = u;
                break;
            }
            if (harborUser == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.user.not.initialize"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.user.not.initialize"));
                return res;
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        try {
            String projectName = dto.getRepoName().substring(0, dto.getRepoName().indexOf("/"));
            Project project = this.getProjectByName(projectName, harborApi);
            if (project == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.not.exist"));
                return res;
            }
            Repository repo = null;
            List repositories = harborApi.repositoriesGet(project.getProjectId(), dto.getRepoName(), null, null, Integer.valueOf(1), Integer.valueOf(100));
            if (repositories != null && repositories.size() > 0) {
                for (Repository r : repositories) {
                    if (!r.getName().equals(dto.getRepoName())) continue;
                    repo = r;
                    break;
                }
            }
            if (repo == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.repository.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.repository.not.exist"));
                return res;
            }
            Label active = (Label)harborApi.labelsGet("g", "active", null, null, null).get(0);
            if (dto.getTag() != null && !dto.getTag().isEmpty()) {
                if (active != null) {
                    harborApi.repositoriesRepoNameTagsTagLabelsLabelIdDelete(dto.getRepoName(), dto.getTag(), active.getId());
                }
            } else if (active != null) {
                harborApi.repositoriesRepoNameLabelsLabelIdDelete(dto.getRepoName(), active.getId());
            }
            res.setCode(Constants.SC_OK);
        }
        catch (ApiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            res.setMessage(e.getResponseBody());
            request.setAttribute("errorMessage", (Object)res.getMessage());
            return res;
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u955c\u50cf-\u542f\u7528")
    @Transactional
    @RequestMapping(value={"/api/model/repository/image/active"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse activeImage(@Valid @RequestBody ImageSelectRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        request.setAttribute("resourceType", (Object)6);
        request.setAttribute("resourceName", (Object)(dto.getRepoName() + ":" + dto.getTag()));
        Long userId = (Long)request.getSession().getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.user.not.exist"));
            return res;
        }
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        Long depId = (Long)request.getSession().getAttribute("departmentId");
        if (!DepartmentController.isDepPermission((String)"image:status", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = huser.getHarborUsername();
        try {
            List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
            User harborUser = null;
            for (User u : userList) {
                if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                harborUser = u;
                break;
            }
            if (harborUser == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.user.not.initialize"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.user.not.initialize"));
                return res;
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        try {
            String projectName = dto.getRepoName().substring(0, dto.getRepoName().indexOf("/"));
            Project project = this.getProjectByName(projectName, harborApi);
            if (project == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.not.exist"));
                return res;
            }
            Repository repo = null;
            List repositories = harborApi.repositoriesGet(project.getProjectId(), dto.getRepoName(), null, null, Integer.valueOf(1), Integer.valueOf(100));
            if (repositories != null && repositories.size() > 0) {
                for (Repository r : repositories) {
                    if (!r.getName().equals(dto.getRepoName())) continue;
                    repo = r;
                    break;
                }
            }
            if (repo == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.repository.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.repository.not.exist"));
                return res;
            }
            Label active = (Label)harborApi.labelsGet("g", "active", null, null, null).get(0);
            if (dto.getTag() != null && !dto.getTag().isEmpty()) {
                if (active != null) {
                    harborApi.repositoriesRepoNameTagsTagLabelsPost(dto.getRepoName(), dto.getTag(), active);
                }
            } else if (active != null) {
                harborApi.repositoriesRepoNameLabelsPost(dto.getRepoName(), active);
            }
            res.setCode(Constants.SC_OK);
        }
        catch (ApiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            res.setMessage(e.getResponseBody());
            request.setAttribute("errorMessage", (Object)res.getMessage());
            return res;
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u5171\u4eab\u955c\u50cf-\u90e8\u95e8\u9009\u62e9\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/model/repository/share/{projectId}"}, method={RequestMethod.GET})
    public ListResultResponse<DepSelectModel> RepoShareDeps(@ApiParam(value="\u955c\u50cf\u4ed3\u5e93\u5206\u7ec4id") @PathVariable(value="projectId") Long projectId, HttpServletRequest request) throws ApiException {
        ListResultResponse res = new ListResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        ArrayList<DepSelectModel> list = new ArrayList<DepSelectModel>();
        try {
            Project project = harborApi.projectsProjectIdGet(projectId);
            if (project == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomain(projectId, domain);
            if (harborProject == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            com.mopaas.server.entity.User owner = harborProject.getOwner();
            Long depId = harborProject.getDepartment().getId();
            OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
            Long orgConfigId = dep.getOrgConfig().getId();
            List departments = this.orgConfigDepartmentRepository.findByOrgConfigIdAndDeleted(orgConfigId, Integer.valueOf(0));
            for (OrgConfigDepartment d : departments) {
                DepUsers depUsers = this.depUsersRepository.findByUserAndDepartmentAndState(owner, d, Integer.valueOf(1));
                if (depUsers == null) continue;
                HarborProjectDept projectDept = this.harborProjectDeptRepository.findByDepartmentIdAndProjectId(d.getId(), projectId);
                DepSelectModel depSelectModel = new DepSelectModel();
                depSelectModel.setId(d.getId());
                depSelectModel.setName(d.getName());
                depSelectModel.setOrgName(d.getOrgConfig().getOrganization().getName());
                if (projectDept != null) {
                    depSelectModel.setStatus(Integer.valueOf(1));
                } else {
                    depSelectModel.setStatus(Integer.valueOf(0));
                }
                depSelectModel.setCreatedAt(d.getCreatedAt());
                list.add(depSelectModel);
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        list.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5171\u4eab\u955c\u50cf")
    @Transactional
    @RequestMapping(value={"/api/model/repository/share"}, method={RequestMethod.POST})
    public ResultResponse repoShare(@Valid @RequestBody RepoDepSelectRequest dto, HttpServletRequest request) throws ApiException {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        request.setAttribute("resourceType", (Object)6);
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        Long projectId = dto.getProjectId();
        HarborProject harborProject = this.harborProjectRepository.findByProjectIdAndDomain(projectId, domain);
        if (harborProject == null) {
            res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        request.setAttribute("resourceName", (Object)harborProject.getProjectName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        com.mopaas.server.entity.User user = (com.mopaas.server.entity.User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(harborProject.getOwner().getId()), (String)"image:share", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        List groupSelects = dto.getGroupSelects();
        try {
            Project project = harborApi.projectsProjectIdGet(projectId);
            if (project == null) {
                res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.repo.project.not.exist"));
                return res;
            }
            List harborProjectDepts = this.harborProjectDeptRepository.findByProjectId(projectId);
            this.harborProjectDeptRepository.delete((Iterable)harborProjectDepts);
            for (int i = 0; i < groupSelects.size(); ++i) {
                HarborProjectDept harborProjectDept = new HarborProjectDept();
                harborProjectDept.setProjectId(projectId);
                harborProjectDept.setProjectName(project.getName());
                harborProjectDept.setDepartment((OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)groupSelects.get(i)));
                this.harborProjectDeptRepository.save((Object)harborProjectDept);
            }
        }
        catch (ApiException e) {
            logger.error("", (Throwable)e);
        }
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    private Integer getPermission(Long projectId, String username, ProductsApi harborApi) {
        List users = null;
        try {
            users = harborApi.projectsProjectIdMembersGet(projectId, null);
        }
        catch (ApiException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Integer flag = 0;
        if (users != null && users.size() > 0) {
            for (ProjectMemberEntity u : users) {
                if (!username.equals(u.getEntityName())) continue;
                flag = 1;
                break;
            }
        }
        return flag;
    }

    private Project getProjectByName(String projectName, ProductsApi harborApi) {
        Project project = null;
        List projects = null;
        try {
            projects = harborApi.projectsGet(projectName, null, null, null, null);
        }
        catch (ApiException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (projects != null && projects.size() > 0) {
            for (Project p : projects) {
                if (!p.getName().equals(projectName)) continue;
                project = p;
                break;
            }
        }
        return project;
    }

    @ConstructorProperties(value={"userRepository", "harborProjectRepository", "orgConfigDepartmentRepository", "harborProjectDeptRepository", "depUsersRepository", "domainRepository", "harborUserRepository", "messageUtil", "harborRepoTagRepository", "resourceRepository", "harborLabelRepository", "commonService"})
    public ModelImageController(UserRepository userRepository, HarborProjectRepository harborProjectRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, HarborProjectDeptRepository harborProjectDeptRepository, DepUsersRepository depUsersRepository, DomainRepository domainRepository, HarborUserRepository harborUserRepository, MessageUtil messageUtil, HarborRepoTagRepository harborRepoTagRepository, ResourceRepository resourceRepository, HarborLabelRepository harborLabelRepository, CommonService commonService) {
        this.userRepository = userRepository;
        this.harborProjectRepository = harborProjectRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.harborProjectDeptRepository = harborProjectDeptRepository;
        this.depUsersRepository = depUsersRepository;
        this.domainRepository = domainRepository;
        this.harborUserRepository = harborUserRepository;
        this.messageUtil = messageUtil;
        this.harborRepoTagRepository = harborRepoTagRepository;
        this.resourceRepository = resourceRepository;
        this.harborLabelRepository = harborLabelRepository;
        this.commonService = commonService;
    }
}

