/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.google.common.base.Strings;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.StringUtils;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.K8sEventRepository;
import com.mopaas.server.dao.OperationLogRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.ServiceDeployRecordRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.K8sEvent;
import com.mopaas.server.entity.OperationLog;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.User;
import com.mopaas.server.model.request.OLPodSortPageRequest;
import com.mopaas.server.model.request.OLSortPageRequest;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.OperationLogModel;
import com.mopaas.server.model.response.OperationPodModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b89\u5168\u5ba1\u8ba1"})
@RestController
public class OperationLogController {
    @Autowired
    private OperationLogRepository operationLogRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    @Autowired
    private DepUsersRepository depUsersRepository;
    @Autowired
    private DomainRepository domainRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private K8sEventRepository k8sEventRepository;
    @Autowired
    private JobVersionRepository jobVersionRepository;
    @Autowired
    private ServiceDeployRecordRepository deployRecordRepository;
    @Autowired
    private MessageUtil messageUtil;
    private static final Logger logger = LoggerFactory.getLogger(OperationLogController.class);

    @PostMapping(value={"/api/operationlog/list"})
    @Transactional(readOnly=true)
    @ApiOperation(value="\u5b89\u5168\u5ba1\u8ba1\u5217\u8868", notes="")
    public ListResultResponse<OperationLogModel> listOperation(@RequestBody @Valid OLSortPageRequest dto, HttpServletRequest request) {
        String eTime;
        String sTime;
        User finalUserSearch;
        Integer resourceType;
        Integer finalLevel;
        Specification spec;
        Page page;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            return res;
        }
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)Long.valueOf(domainId));
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        ArrayList userResourceGuid = new ArrayList();
        if (level == 3) {
            List list3;
            List list2;
            List list1 = this.resourceRepository.findGuidByUser(user);
            if (null != list1) {
                userResourceGuid.addAll(list1);
            }
            if (null != (list2 = this.jobVersionRepository.findGuidByJobUser(user))) {
                userResourceGuid.addAll(list2);
            }
            if (null != (list3 = this.deployRecordRepository.findGuidByServiceUser(user))) {
                userResourceGuid.addAll(list3);
            }
        }
        PageRequest pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"});
        User userSearch = null;
        if (null != dto.getUserId()) {
            userSearch = (User)this.userRepository.findOne((Serializable)dto.getUserId());
        }
        if (null != (page = this.operationLogRepository.findAll(spec = (arg_0, arg_1, arg_2) -> OperationLogController.lambda$listOperation$0(dep, domain, dto, finalLevel = level, userResourceGuid, user, resourceType = dto.getResourceType(), finalUserSearch = userSearch, sTime = dto.getStartTime() == null ? null : dto.getStartTime().toString(), eTime = dto.getEndTime() == null ? null : dto.getEndTime().toString(), arg_0, arg_1, arg_2), (Pageable)pageable))) {
            List logs = page.getContent();
            res.setPages(Integer.valueOf(page.getTotalPages()));
            res.setSize(Long.valueOf(page.getTotalElements()));
            ArrayList<OperationLogModel> models = new ArrayList<OperationLogModel>();
            for (OperationLog log : logs) {
                JSONObject jsonObject;
                String language = "zh";
                String header = request.getHeader("Accept-Language");
                if (header.startsWith("en")) {
                    language = "en";
                }
                OperationLogModel model = new OperationLogModel();
                model.setId(log.getId());
                model.setName(log.getName());
                model.setUsername(log.getUsername());
                model.setOrgName(log.getOrganization().getName());
                model.setOrgGuid(log.getOrganization().getGuid());
                model.setIp(log.getOperationIp());
                model.setAddress(log.getAddress());
                if (null != log.getContent() && StringUtils.isJson((String)log.getContent())) {
                    jsonObject = JSONObject.fromObject((Object)log.getContent());
                    model.setContent(jsonObject.get(language).toString());
                } else {
                    model.setContent(log.getContent());
                }
                model.setResourceName(log.getResourceName());
                model.setResourceType(log.getResourceType());
                model.setDuration(log.getDuration());
                model.setRes(log.getRes());
                model.setCreatedAt(log.getCreatedAt());
                if (!log.getRes().equals(Constants.SC_OK)) {
                    if (null != log.getErrorMessage() && StringUtils.isJson((String)log.getErrorMessage())) {
                        jsonObject = JSONObject.fromObject((Object)log.getErrorMessage());
                        model.setErrorMessage(jsonObject.get(language) != null ? jsonObject.get(language).toString() : jsonObject.toString());
                    } else {
                        model.setErrorMessage(log.getErrorMessage());
                    }
                }
                models.add(model);
            }
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @PostMapping(value={"/api/operationlog/pod/list"})
    @Transactional(readOnly=true)
    @ApiOperation(value="pod\u5b89\u5168\u5ba1\u8ba1\u5217\u8868", notes="v3.5-\u4fee\u6539\u53c2\u6570resourceId\u4e3anamespace")
    public ListResultResponse<OperationPodModel> listPodOperation(@RequestBody @Valid OLPodSortPageRequest dto) {
        String eTime;
        ListResultResponse res = new ListResultResponse();
        PageRequest pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"lastOccurrenceTime"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"});
        String sTime = dto.getStartTime() == null ? null : dto.getStartTime().toString();
        Specification spec = (arg_0, arg_1, arg_2) -> OperationLogController.lambda$listPodOperation$1(dto, sTime, eTime = dto.getEndTime() == null ? null : dto.getEndTime().toString(), arg_0, arg_1, arg_2);
        Page page = this.k8sEventRepository.findAll(spec, (Pageable)pageable);
        if (null != page) {
            List logs = page.getContent();
            res.setPages(Integer.valueOf(page.getTotalPages()));
            res.setSize(Long.valueOf(page.getTotalElements()));
            ArrayList<OperationPodModel> models = new ArrayList<OperationPodModel>();
            for (K8sEvent log : logs) {
                OperationPodModel model = new OperationPodModel();
                model.setId(log.getId());
                model.setName(log.getName());
                model.setType(log.getType());
                model.setReason(log.getReason());
                model.setMessage(log.getMessage());
                model.setKind(log.getKind());
                model.setLastOccurrenceTime(log.getLastOccurrenceTime().replace("+0800 CST", ""));
                models.add(model);
            }
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    private static /* synthetic */ Predicate lambda$listPodOperation$1(OLPodSortPageRequest dto, String sTime, String eTime, Root root, CriteriaQuery query, CriteriaBuilder cb) {
        ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
        lstPredicates.add(cb.equal((Expression)root.get("kind"), (Object)"Pod"));
        if (!StringUtils.isEmpty((String)dto.getName())) {
            lstPredicates.add(cb.or(new Predicate[]{cb.like((Expression)root.get("name"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("name"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("type"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("reason"), "%" + dto.getName().trim() + "%")}));
        }
        lstPredicates.add(cb.equal((Expression)root.get("namespace"), (Object)dto.getNamespace()));
        if (null != sTime) {
            try {
                lstPredicates.add(cb.greaterThanOrEqualTo((Expression)root.get("lastOccurrenceTime"), (Comparable)TimeUtil.startOfDay((Date)dto.getStartTime())));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (null != eTime) {
            try {
                lstPredicates.add(cb.lessThanOrEqualTo((Expression)root.get("lastOccurrenceTime"), (Comparable)TimeUtil.endOfDay((Date)dto.getEndTime())));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
        query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
        return null;
    }

    private static /* synthetic */ Predicate lambda$listOperation$0(OrgConfigDepartment dep, Domain domain, OLSortPageRequest dto, Integer finalLevel, List userResourceGuid, User user, Integer resourceType, User finalUserSearch, String sTime, String eTime, Root root, CriteriaQuery query, CriteriaBuilder cb) {
        ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
        lstPredicates.add(cb.equal((Expression)root.get("department"), (Object)dep));
        lstPredicates.add(cb.equal((Expression)root.get("domain"), (Object)domain));
        if (!StringUtils.isEmpty((String)dto.getName())) {
            lstPredicates.add(cb.or(new Predicate[]{cb.like((Expression)root.get("name"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("username"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("operationIp"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("address"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("content"), "%" + dto.getName().trim() + "%"), cb.like((Expression)root.get("resourceName"), "%" + dto.getName().trim() + "%")}));
        }
        if (finalLevel == 3) {
            if (!userResourceGuid.isEmpty()) {
                CriteriaBuilder.In in = cb.in((Expression)root.get("resourceGuid"));
                for (String guid : userResourceGuid) {
                    in.value((Object)guid);
                }
                lstPredicates.add(cb.or((Expression)cb.equal((Expression)root.get("username"), (Object)user.getUsername()), (Expression)in));
            } else {
                lstPredicates.add(cb.equal((Expression)root.get("username"), (Object)user.getUsername()));
            }
        }
        if (null != resourceType) {
            lstPredicates.add(cb.equal((Expression)root.get("resourceType"), (Object)resourceType));
        }
        if (null != finalUserSearch) {
            lstPredicates.add(cb.equal((Expression)root.get("username"), (Object)finalUserSearch.getUsername()));
        }
        if (null != sTime) {
            try {
                lstPredicates.add(cb.greaterThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)TimeUtil.startOfDay((Date)dto.getStartTime())));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (null != eTime) {
            try {
                lstPredicates.add(cb.lessThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)TimeUtil.endOfDay((Date)dto.getEndTime())));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
        query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
        return null;
    }
}

