/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.mopaas.server.common.Constants;
import com.mopaas.server.common.DateUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.PingPlusPlusUtil;
import com.mopaas.server.common.alipay.AlipayNotify;
import com.mopaas.server.common.alipay.AlipaySubmit;
import com.mopaas.server.common.alipay.MD5;
import com.mopaas.server.config.AlipayConfig;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.RechargeRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.Balance;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.Recharge;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.User;
import com.mopaas.server.model.request.AlipayRequest;
import com.mopaas.server.model.request.ChargeRequest;
import com.mopaas.server.model.response.AlipayResponse;
import com.mopaas.server.model.response.BalanceResponse;
import com.mopaas.server.model.response.ChargeResponse;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.Event;
import com.pingplusplus.model.Webhooks;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(tags={"\u652f\u4ed8\u76f8\u5173\u64cd\u4f5c"})
@RestController
public class PayController {
    @Autowired
    private BalancesRepository balancesRepository;
    @Autowired
    private RechargeRepository rechargeRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SystemConfigRepository systemConfigRepository;
    @Autowired
    private MessageUtil messageUtil;
    private static final Logger logger = LoggerFactory.getLogger(PayController.class);

    @ApiOperation(value="\u8d26\u6237\u4f59\u989d")
    @Transactional
    @RequestMapping(value={"/api/pay/balance/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public BalanceResponse getBalance(@PathVariable(value="id") Long id, HttpServletRequest request) {
        BalanceResponse res = new BalanceResponse();
        res.setCode(Constants.SC_ERROR);
        User user = (User)this.userRepository.findOne((Serializable)id);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        Organization organization = user.getOrganization();
        List balanceList = this.balancesRepository.findByOrganizationAndStatus(organization, 0);
        Double money = 0.0;
        for (Balance b : balanceList) {
            money = money + b.getMoney();
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        money = Double.valueOf(df.format(money));
        res.setBalance(money);
        Integer free = 0;
        if (organization.getFree() != null) {
            free = organization.getFree();
        }
        res.setFree(free);
        SystemConfig config = this.systemConfigRepository.findByConfigName("Alipay_Config");
        if (config != null && "true".equals(config.getConfigValue())) {
            res.setPayConfig(Integer.valueOf(1));
        } else {
            res.setPayConfig(Integer.valueOf(0));
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u521b\u5efa\u4ea4\u6613")
    @Transactional
    @RequestMapping(value={"/api/pay/charge"}, method={RequestMethod.POST})
    @ResponseBody
    public ChargeResponse charge(@Valid @RequestBody ChargeRequest dto, HttpServletRequest request) {
        ChargeResponse res = new ChargeResponse();
        String channel = dto.getChannel();
        int amount = dto.getAmount();
        String subject = dto.getSubject();
        String body = dto.getBody();
        String clientIp = dto.getClientIp();
        PingPlusPlusUtil pingPlusPlusUtil = new PingPlusPlusUtil();
        String orderNo = "CZ" + DateUtil.getOrderNum() + new Random().nextInt(99999999);
        String PINGPLUSPLUS_API_KEY = this.systemConfigRepository.findByConfigName("PINGPLUSPLUS_API_KEY").getConfigValue();
        String PINGPLUSPLUS_APP_ID = this.systemConfigRepository.findByConfigName("PINGPLUSPLUS_APP_ID").getConfigValue();
        String PINGPLUSPLUS_PKCS8PRIVATEKEY = this.systemConfigRepository.findByConfigName("PINGPLUSPLUS_PKCS8PRIVATEKEY").getConfigValue();
        Charge charge = null;
        charge = pingPlusPlusUtil.createCharge(PINGPLUSPLUS_API_KEY, PINGPLUSPLUS_APP_ID, PINGPLUSPLUS_PKCS8PRIVATEKEY, channel, amount, subject, body, clientIp, orderNo, dto.getUserId(), request);
        if (charge == null) {
            res.setMessage(this.messageUtil.getMessage("msg.pingpp.charge.failed"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        Long userId = dto.getUserId();
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        Recharge recharge = new Recharge();
        recharge.setCreatedAt(new Date());
        recharge.setMoney(Double.valueOf((double)amount / 100.0));
        recharge.setUser(user);
        recharge.setOrganization(user.getOrganization());
        recharge.setStatus(Integer.valueOf(0));
        recharge.setType(Integer.valueOf(1));
        recharge.setTradeNo(orderNo);
        recharge.setRemark(channel);
        this.rechargeRepository.save((Object)recharge);
        res.setCharge(charge);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56de\u8c03\u9a8c\u7b7e(\u81ea\u52a8\u8c03\u7528)")
    @RequestMapping(value={"/api/pay/webhooks"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public void webhooks(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String str;
        request.setCharacterEncoding("UTF8");
        Enumeration headerNames = request.getHeaderNames();
        String signature = null;
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            if (!"x-pingplusplus-signature".equals(key)) continue;
            signature = value;
        }
        BufferedReader reader = request.getReader();
        StringBuffer buffer = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            buffer.append(str);
        }
        reader.close();
        Event event = Webhooks.eventParse((String)buffer.toString());
        if ("charge.succeeded".equals(event.getType())) {
            response.setStatus(200);
        } else if ("refund.succeeded".equals(event.getType())) {
            response.setStatus(200);
        } else {
            response.setStatus(500);
        }
        String PINGPLUSPLUS_PUB_KEY = this.systemConfigRepository.findByConfigName("PINGPLUSPLUS_PUB_KEY").getConfigValue();
        try {
            PayController.verifyData((String)event.toString(), (String)signature, (PublicKey)PayController.getPubKey((String)PINGPLUSPLUS_PUB_KEY));
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        if ("charge.succeeded".equals(event.getType())) {
            JSONObject object = JSONObject.fromObject((Object)event.getData().getObject());
            String orderNo = (String)object.get("orderNo");
            String host = (String)object.get("description");
            int amount = (Integer)object.get("amount");
            if (orderNo == null) {
                logger.error("pay faild:orderNo is null");
                return;
            }
            if (host == null) {
                logger.error("pay faild:host is null");
                return;
            }
            String strURL = "http://" + host + "/api/pay/charge/success";
            PayController.jsonPost((String)strURL, (String)orderNo, (Integer)amount);
        }
    }

    public static void jsonPost(String strURL, String orderNo, Integer amount) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("orderNo", orderNo);
            connection.setRequestProperty("amount", String.valueOf(amount));
            connection.connect();
            int code = connection.getResponseCode();
            InputStream is = null;
            is = code == 200 ? connection.getInputStream() : connection.getErrorStream();
            int length = connection.getContentLength();
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                String result = new String(data, StandardCharsets.UTF_8);
                logger.info(strURL + result);
                is.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u4ea4\u6613\u6210\u529f(\u81ea\u52a8\u8c03\u7528)")
    @Transactional
    @RequestMapping(value={"/api/pay/charge/success"}, method={RequestMethod.POST})
    @ResponseBody
    public void charge(HttpServletRequest request) {
        String orderNo = request.getHeader("orderNo");
        if (orderNo == null) {
            logger.error("pay faild:orderNo is null");
            return;
        }
        String strAmount = request.getHeader("amount");
        if (strAmount == null) {
            logger.error("pay faild:amount is null");
            return;
        }
        int amount = Integer.parseInt(strAmount);
        Recharge recharge = this.rechargeRepository.findByTradeNo(orderNo);
        recharge.setStatus(Integer.valueOf(1));
        this.rechargeRepository.save((Object)recharge);
        User user = recharge.getUser();
        if (user == null) {
            return;
        }
        Balance balance = this.balancesRepository.findByOrganizationAndTypeAndStatus(user.getOrganization(), 1, 0);
        if (balance == null) {
            balance = new Balance();
            balance.setOrganization(user.getOrganization());
            balance.setStatus(Integer.valueOf(0));
            balance.setType(Integer.valueOf(1));
            balance.setMoney(Double.valueOf((double)amount / 100.0));
        } else {
            Double newBalance = (balance.getMoney() * 10000.0 + (double)(amount * 100)) / 10000.0;
            balance.setMoney(newBalance);
            balance.setUpdatedAt(new Date());
        }
        this.balancesRepository.save((Object)balance);
        logger.info("pay success");
    }

    public static PublicKey getPubKey(String pubKey) throws Exception {
        String pubKeyString = pubKey.replaceAll("(-+BEGIN PUBLIC KEY-+\\r?\\n|-+END PUBLIC KEY-+\\r?\\n?)", "");
        byte[] keyBytes = Base64.decodeBase64((String)pubKeyString);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(spec);
        return publicKey;
    }

    public static boolean verifyData(String dataString, String signatureString, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] signatureBytes = Base64.decodeBase64((String)signatureString);
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initVerify(publicKey);
        signature.update(dataString.getBytes(StandardCharsets.UTF_8));
        return signature.verify(signatureBytes);
    }

    @RequestMapping(value={"/api/alipay/charge"}, method={RequestMethod.POST})
    public AlipayResponse payment(@Valid @RequestBody AlipayRequest dto, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pubKey;
        AlipayResponse res = new AlipayResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (dto.getTotal_amount() < 1.0 || dto.getTotal_amount() > 1000000.0) {
            res.setMessage(this.messageUtil.getMessage("msg.pay.amount.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        String notify_url = basePath + "/api/anon/alipay/notify";
        String return_url = dto.getDomain() + "/#/cost/account?state=success";
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        SystemConfig partnerConfig = this.systemConfigRepository.findByConfigName("Alipay_Partner");
        String partner = partnerConfig != null ? partnerConfig.getConfigValue() : null;
        SystemConfig signTypeConfig = this.systemConfigRepository.findByConfigName("Alipay_Sign_Type");
        String signType = signTypeConfig != null ? signTypeConfig.getConfigValue() : "MD5";
        SystemConfig keyConfig = this.systemConfigRepository.findByConfigName("Alipay_Key");
        String key = keyConfig != null ? keyConfig.getConfigValue() : null;
        SystemConfig pubKeyConfig = this.systemConfigRepository.findByConfigName("Alipay_Pub_Key");
        String string = pubKey = pubKeyConfig != null ? pubKeyConfig.getConfigValue() : null;
        if (partner == null || key == null || pubKey == null) {
            res.setMessage(this.messageUtil.getMessage("msg.pay.not.config"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        AlipayConfig alipayConfig = AlipayConfig.alipayConfig((String)partner, (String)signType, (String)key, (String)pubKey);
        String tradeNo = "CZ" + DateUtil.getOrderNum() + new Random().nextInt(99999999);
        sParaTemp.put("out_trade_no", tradeNo);
        sParaTemp.put("subject", dto.getSubject());
        sParaTemp.put("total_fee", String.valueOf(dto.getTotal_amount()));
        sParaTemp.put("body", "Pay " + dto.getTotal_amount() + " yuan to MoPaaS.");
        sParaTemp.put("service", alipayConfig.service);
        sParaTemp.put("partner", alipayConfig.partner);
        sParaTemp.put("seller_id", alipayConfig.seller_id);
        sParaTemp.put("_input_charset", alipayConfig.input_charset);
        sParaTemp.put("payment_type", alipayConfig.payment_type);
        sParaTemp.put("notify_url", notify_url);
        sParaTemp.put("return_url", return_url);
        sParaTemp.put("mysign", MD5.sign((String)(dto.getTotal_amount() + (String)sParaTemp.get("out_trade_no")), (String)alipayConfig.key, (String)alipayConfig.input_charset));
        Recharge recharge = new Recharge();
        recharge.setGuid(UUID.randomUUID().toString().replace("-", ""));
        recharge.setCreatedAt(new Date());
        recharge.setMoney(dto.getTotal_amount());
        recharge.setUser(user);
        recharge.setOrganization(user.getOrganization());
        recharge.setStatus(Integer.valueOf(0));
        recharge.setType(Integer.valueOf(1));
        recharge.setTradeNo(tradeNo);
        this.rechargeRepository.save((Object)recharge);
        String sHtmlText = AlipaySubmit.buildRequest(sParaTemp, (String)"post", (String)"\u7acb\u5373\u4ed8\u6b3e", (AlipayConfig)alipayConfig);
        res.setForm(sHtmlText);
        res.setTradeNo(tradeNo);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @RequestMapping(value={"/api/anon/alipay/notify"}, method={RequestMethod.POST, RequestMethod.GET})
    public String notifyUrl(HttpServletRequest request, HttpServletResponse response) {
        Recharge recharge;
        SystemConfig pubKeyConfig;
        String pubKey;
        SystemConfig keyConfig;
        String key;
        AlipayConfig alipayConfig;
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            valueStr = new String(valueStr.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
            params.put(name, valueStr);
        }
        String out_trade_no = new String(request.getParameter("out_trade_no").getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        String total_fee = new String(request.getParameter("total_fee").getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        String trade_status = new String(request.getParameter("trade_status").getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        SystemConfig partnerConfig = this.systemConfigRepository.findByConfigName("Alipay_Partner");
        String partner = partnerConfig != null ? partnerConfig.getConfigValue() : null;
        SystemConfig signTypeConfig = this.systemConfigRepository.findByConfigName("Alipay_Sign_Type");
        String signType = signTypeConfig != null ? signTypeConfig.getConfigValue() : "MD5";
        if (AlipayNotify.verify(params, (String)signType, (AlipayConfig)(alipayConfig = AlipayConfig.alipayConfig((String)partner, (String)signType, (String)(key = (keyConfig = this.systemConfigRepository.findByConfigName("Alipay_Key")) != null ? keyConfig.getConfigValue() : null), (String)(pubKey = (pubKeyConfig = this.systemConfigRepository.findByConfigName("Alipay_Pub_Key")) != null ? pubKeyConfig.getConfigValue() : null)))) && ("TRADE_FINISHED".equals(trade_status) || "TRADE_SUCCESS".equals(trade_status)) && (recharge = this.rechargeRepository.findByTradeNo(out_trade_no)) != null) {
            if (recharge.getStatus() == 0 && recharge.getMoney().equals(Double.valueOf(total_fee))) {
                Balance balance;
                recharge.setStatus(Integer.valueOf(1));
                User user = recharge.getUser();
                Organization org = user.getOrganization();
                Double money = this.balancesRepository.sumBalance(org, Integer.valueOf(0));
                if (money == null) {
                    money = 0.0;
                }
                if ((balance = this.balancesRepository.findByOrganizationAndTypeAndStatus(user.getOrganization(), 1, 0)) == null) {
                    balance = new Balance();
                    balance.setOrganization(org);
                    balance.setStatus(Integer.valueOf(0));
                    balance.setType(Integer.valueOf(1));
                    balance.setMoney(Double.valueOf(total_fee));
                } else {
                    Double newBalance = balance.getMoney() + Double.valueOf(total_fee);
                    balance.setMoney(newBalance);
                    balance.setUpdatedAt(new Date());
                }
                this.balancesRepository.save((Object)balance);
                if (money < 0.0 && money + Double.valueOf(total_fee) > 0.0) {
                    org.setIsRecharges(Integer.valueOf(0));
                }
                return "success";
            }
            recharge.setStatus(Integer.valueOf(-1));
        }
        return "fail";
    }
}

