/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.google.common.base.Strings;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.SerialUtils;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.K8sEngineRepository;
import com.mopaas.server.dao.PortalConfigRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.Notice;
import com.mopaas.server.entity.PortalConfig;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.model.request.EamilSendRequest;
import com.mopaas.server.model.request.PortalModel;
import com.mopaas.server.model.request.VerifyLicenseRequest;
import com.mopaas.server.model.response.BooleanResponse;
import com.mopaas.server.model.response.ExampleModel;
import com.mopaas.server.model.response.FrameworkPortalModel;
import com.mopaas.server.model.response.PortalConfigResponse;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.NoticeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u83b7\u53d6\u7f51\u7ad9\u95e8\u6237\u914d\u7f6e\u4fe1\u606f"})
@RestController
public class PortalController {
    @Autowired
    private PortalConfigRepository portalConfigRepository;
    @Autowired
    private SystemConfigRepository systemConfigRepository;
    @Autowired
    private K8sEngineRepository engineRepository;
    @Autowired
    private DomainRepository domainRepository;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private MessageUtil messageUtil;

    @ApiOperation(value="\u7f51\u7ad9\u95e8\u6237\u914d\u7f6e\u4fe1\u606f")
    @Transactional
    @RequestMapping(value={"/api/anon/portal/config/all"}, method={RequestMethod.GET})
    public PortalConfigResponse getPortalConfig(HttpServletRequest request, HttpServletResponse response) {
        String mainBoardID;
        String url;
        PortalModel dto;
        SystemConfig system_license;
        PortalConfigResponse res = new PortalConfigResponse();
        String domainId = null;
        HttpSession session = request.getSession();
        if (session != null) {
            domainId = String.valueOf(session.getAttribute("domain"));
        }
        if (domainId == null || domainId.isEmpty() || !domainId.matches("\\d")) {
            Domain domain = this.domainRepository.findTopByDeletedAndStatusOrderById(Integer.valueOf(0), Integer.valueOf(1));
            domainId = String.valueOf(domain.getId());
        }
        String minio = FactoryCollection.minioUrl((Long)Long.valueOf(domainId));
        SystemConfig system_license_type = this.systemConfigRepository.findByConfigName("SYSTEM_LICENSE_TYPE");
        if (system_license_type != null && !Strings.isNullOrEmpty((String)system_license_type.getConfigValue())) {
            res.setSystemLicenseType(system_license_type.getConfigValue());
        }
        if ((system_license = this.systemConfigRepository.findByConfigName("SYSTEM_LICENSE")) != null && !Strings.isNullOrEmpty((String)system_license.getConfigValue())) {
            String[] info = SerialUtils.decodeLicense((String)system_license.getConfigValue());
            if (null != info && info.length == 4) {
                LocalDateTime expire = LocalDateTime.parse(info[1]);
                if (expire.isBefore(LocalDateTime.now(ZoneId.of("Asia/Shanghai"))) && !info[1].startsWith("2000")) {
                    res.setSysType("-1");
                } else {
                    res.setSysType(info[0]);
                }
            } else {
                res.setSysType("-1");
            }
        } else {
            res.setSysType("-2");
        }
        SystemConfig notice_send_user = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        if (null != notice_send_user) {
            res.setNoticeSendUser(notice_send_user.getConfigValue());
        }
        PortalConfig navigation = this.portalConfigRepository.findByPortalKey("navigation");
        PortalConfig slideshow = this.portalConfigRepository.findByPortalKey("slideshow");
        PortalConfig framework = this.portalConfigRepository.findByPortalKey("framework");
        PortalConfig feature = this.portalConfigRepository.findByPortalKey("feature");
        PortalConfig presentation = this.portalConfigRepository.findByPortalKey("presentation");
        PortalConfig caseConfig = this.portalConfigRepository.findByPortalKey("case");
        PortalConfig information = this.portalConfigRepository.findByPortalKey("information");
        PortalConfig userTitle = this.portalConfigRepository.findByPortalKey("user_title");
        if (userTitle != null) {
            res.setUserTitle(userTitle.getName());
        }
        if (navigation != null) {
            List portalNavigationList = this.portalConfigRepository.findByParentId(navigation.getId());
            res.setLogo(Integer.valueOf(0));
            res.setProduct(Integer.valueOf(1));
            res.setPrice(Integer.valueOf(1));
            res.setDocument(Integer.valueOf(1));
            if (portalNavigationList != null && portalNavigationList.size() > 0) {
                for (PortalConfig portalConfig : portalNavigationList) {
                    if (portalConfig.getName() == null) continue;
                    if (portalConfig.getRemark().contains("product")) {
                        res.setProduct(portalConfig.getStatus());
                    }
                    if (portalConfig.getRemark().contains("price")) {
                        res.setPrice(portalConfig.getStatus());
                    }
                    if ("document".equals(portalConfig.getRemark())) {
                        res.setDocument(portalConfig.getStatus());
                        if (portalConfig.getStatus() != null && portalConfig.getStatus() == 0) {
                            res.setDocumentUrl(this.getUrl(portalConfig.getLogoUrl(), minio));
                        }
                    }
                    if (portalConfig.getRemark().contains("\u95e8\u6237\u9996\u9875\u5bfc\u822alogo")) {
                        res.setTitleLogo(this.getUrl(portalConfig.getLogoUrl(), minio));
                    }
                    if (portalConfig.getRemark().contains("tag_logo")) {
                        res.setTagLogo(this.getUrl(portalConfig.getLogoUrl(), minio));
                    }
                    if (!portalConfig.getRemark().contains("\u5e73\u53f0\u5185\u90e8\u5bfc\u822alogo")) continue;
                    res.setNavigateLogo(this.getUrl(portalConfig.getLogoUrl(), minio));
                }
            }
        }
        if (slideshow != null) {
            List portalSlideshowList = this.portalConfigRepository.findByParentIdAndStatusOrderByOrders(slideshow.getId(), Integer.valueOf(0));
            ArrayList<PortalModel> slideshows = new ArrayList<PortalModel>();
            if (portalSlideshowList != null && portalSlideshowList.size() > 0) {
                for (PortalConfig portalConfig : portalSlideshowList) {
                    dto = new PortalModel();
                    dto.setName(portalConfig.getName());
                    url = portalConfig.getLogoUrl();
                    dto.setUrl(this.getUrlJson(url, minio));
                    dto.setRemark(portalConfig.getRemark());
                    slideshows.add(dto);
                }
            }
            res.setSlideshows(slideshows);
        }
        if (framework != null) {
            List portalFrameworkList = this.portalConfigRepository.findByParentIdAndStatusOrderByOrders(framework.getId(), Integer.valueOf(0));
            ArrayList<PortalModel> frameworks = new ArrayList<PortalModel>();
            if (portalFrameworkList != null && portalFrameworkList.size() > 0) {
                for (PortalConfig portalConfig : portalFrameworkList) {
                    dto = new FrameworkPortalModel();
                    dto.setName(portalConfig.getName());
                    url = portalConfig.getLogoUrl();
                    if (!StringUtils.isEmpty((String)url) && !"[]".equals(url)) {
                        dto.setUrl(this.getUrlList(url, minio));
                    }
                    dto.setRemark(portalConfig.getRemark());
                    dto.setExpect(portalConfig.getExpect());
                    frameworks.add(dto);
                }
            }
            res.setFrameworks(frameworks);
        }
        if (feature != null) {
            List portalFeatureList = this.portalConfigRepository.findByParentIdAndStatusOrderByOrders(feature.getId(), Integer.valueOf(0));
            ArrayList<PortalModel> features = new ArrayList<PortalModel>();
            if (portalFeatureList != null && portalFeatureList.size() > 0) {
                for (PortalConfig portalConfig : portalFeatureList) {
                    dto = new com.mopaas.server.model.response.PortalModel();
                    dto.setName(portalConfig.getName());
                    url = portalConfig.getLogoUrl();
                    if (!StringUtils.isEmpty((String)url) && !"[]".equals(url)) {
                        dto.setUrl(this.getUrlList(url, minio));
                    }
                    dto.setRemark(portalConfig.getRemark());
                    features.add(dto);
                }
            }
            res.setFeatures(features);
        }
        if (presentation != null) {
            List portalPresentationList = this.portalConfigRepository.findByParentIdAndStatusOrderByOrders(presentation.getId(), Integer.valueOf(0));
            ArrayList<PortalModel> videos = new ArrayList<PortalModel>();
            if (portalPresentationList != null && portalPresentationList.size() > 0) {
                for (PortalConfig portalConfig : portalPresentationList) {
                    dto = new com.mopaas.server.model.response.PortalModel();
                    dto.setName(portalConfig.getName());
                    String logoUrl = StringUtils.strip((String)portalConfig.getLogoUrl(), (String)"[]").replace("\"", "");
                    String onlineUrl = StringUtils.strip((String)portalConfig.getUrl(), (String)"[]").replace("\"", "");
                    String url2 = null;
                    if (!StringUtils.isEmpty((String)logoUrl)) {
                        url2 = StringUtils.strip((String)logoUrl, (String)"[]").replace("\"", "");
                    } else if (!StringUtils.isEmpty((String)onlineUrl)) {
                        url2 = StringUtils.strip((String)onlineUrl, (String)"[]").replace("\"", "");
                    }
                    if (!StringUtils.isEmpty(url2) && !"[]".equals(url2)) {
                        dto.setUrl(this.getUrlList(url2, minio));
                    }
                    dto.setRemark(portalConfig.getRemark());
                    videos.add(dto);
                }
            }
            res.setVideos(videos);
        }
        if (caseConfig != null) {
            List portalCaseList = this.portalConfigRepository.findByParentIdAndStatusOrderByOrders(caseConfig.getId(), Integer.valueOf(0));
            ArrayList<PortalModel> examples = new ArrayList<PortalModel>();
            if (portalCaseList != null && portalCaseList.size() > 0) {
                for (PortalConfig portalConfig : portalCaseList) {
                    dto = new ExampleModel();
                    dto.setParentName(presentation.getName());
                    dto.setName(portalConfig.getName());
                    url = portalConfig.getLogoUrl();
                    if (!StringUtils.isEmpty((String)url) && !"[]".equals(url)) {
                        dto.setUrl(this.getUrlList(url, minio));
                    }
                    dto.setRemark(portalConfig.getUrl());
                    examples.add(dto);
                }
            }
            res.setExamples(examples);
        }
        if (information != null && information.getStatus() == 0) {
            List portalInformationList = this.portalConfigRepository.findByParentIdAndStatus(information.getId(), Integer.valueOf(0));
            ArrayList<PortalModel> informations = new ArrayList<PortalModel>();
            if (portalInformationList != null && portalInformationList.size() > 0) {
                for (PortalConfig portalConfig : portalInformationList) {
                    dto = new com.mopaas.server.model.response.PortalModel();
                    dto.setName(portalConfig.getName());
                    dto.setRemark(portalConfig.getRemark());
                    url = portalConfig.getLogoUrl();
                    if (!StringUtils.isEmpty((String)url) && !"[]".equals(url)) {
                        String[] urlList = StringUtils.strip((String)url, (String)"[]").replace("\"", "").split(",");
                        dto.setUrl(urlList);
                    }
                    informations.add(dto);
                }
            }
            res.setInformations(informations);
        }
        if (null != (mainBoardID = SerialUtils.getKey())) {
            res.setMainBoardID(mainBoardID);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6821\u9a8clicense\u662f\u5426\u6709\u6548")
    @Transactional
    @RequestMapping(value={"/api/anon/license/verify"}, method={RequestMethod.POST})
    public BooleanResponse isValid(@Valid @RequestBody VerifyLicenseRequest dto, HttpServletRequest request) {
        String[] info;
        BooleanResponse res = new BooleanResponse();
        Boolean flag = false;
        if (null == dto.getLicense() || dto.getLicense().isEmpty()) {
            res.setABoolean(flag.booleanValue());
            return res;
        }
        SystemConfig system_license_type = this.systemConfigRepository.findByConfigName("SYSTEM_LICENSE_TYPE");
        String licenseType = "1";
        if (system_license_type != null && !Strings.isNullOrEmpty((String)system_license_type.getConfigValue())) {
            licenseType = system_license_type.getConfigValue();
        }
        if (null != (info = SerialUtils.decodeLicense((String)dto.getLicense())) && info.length == 4 && licenseType.equals(info[0])) {
            LocalDateTime expire = LocalDateTime.parse(info[1]);
            Integer nodes = this.engineRepository.countAllDomain();
            Integer gpus = this.engineRepository.sumGpuByAllDomain();
            if (expire.isAfter(LocalDateTime.now(ZoneId.of("Asia/Shanghai"))) && nodes <= Integer.parseInt(info[2]) && Optional.ofNullable(gpus).orElse(0) <= Integer.parseInt(info[3])) {
                flag = true;
            }
        }
        res.setABoolean(flag.booleanValue());
        if (flag.booleanValue()) {
            SystemConfig system_license = this.systemConfigRepository.findByConfigName("SYSTEM_LICENSE");
            system_license.setConfigValue(dto.getLicense());
        }
        return res;
    }

    public String[] getUrlList(String urlList, String minio) {
        String[] list = StringUtils.strip((String)urlList, (String)"[]").replace("\"", "").split(",");
        ArrayList<String> res = new ArrayList<String>();
        for (String url : list) {
            if (url.startsWith("/")) {
                url = minio + url;
            }
            res.add(url);
        }
        return res.toArray(new String[0]);
    }

    public String getUrl(String url, String minio) {
        String res = StringUtils.strip((String)url, (String)"[]").replace("\"", "");
        if (res.startsWith("/")) {
            res = minio + res;
        }
        return res;
    }

    public String getUrlJson(String url, String minio) {
        if (com.mopaas.server.common.StringUtils.isJson((String)url)) {
            JSONObject jsonObject = JSONObject.fromObject((Object)url);
            String urlEn = String.valueOf(jsonObject.get("en"));
            String[] urlEnList = this.getUrlList(urlEn, minio);
            jsonObject.put((Object)"en", (Object)urlEnList);
            String urlZh = String.valueOf(jsonObject.get("zh"));
            String[] urlZhList = this.getUrlList(urlZh, minio);
            jsonObject.put((Object)"zh", (Object)urlZhList);
            return String.valueOf(jsonObject);
        }
        return String.valueOf(this.getUrlList(url, minio));
    }

    @ApiOperation(value="\u4e3b\u673a\u5e8f\u5217\u53f7\u53d1\u9001\u90ae\u4ef6")
    @Transactional
    @RequestMapping(value={"/api/anon/email/serialnumber"}, method={RequestMethod.POST})
    public ResultResponse sendEmail(@Valid @RequestBody EamilSendRequest dto, HttpServletRequest request, HttpServletResponse response) {
        ResultResponse res = new ResultResponse();
        String mainBoardID = SerialUtils.getKey();
        if (mainBoardID == null) {
            res.setCode(Integer.valueOf(1));
            res.setMessage(this.messageUtil.getMessage("msg.registerpage.userconfig.null"));
            return res;
        }
        JSONArray sendType = new JSONArray();
        sendType.add((Object)"2");
        Notice notice = new Notice();
        notice.setSendType(String.valueOf(sendType));
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        json.put("type", (Object)"\u4e3b\u673a\u5e8f\u5217\u53f7");
        notice.setEmail(dto.getEmail());
        com.alibaba.fastjson.JSONObject jsonEmail = new com.alibaba.fastjson.JSONObject();
        jsonEmail.put("templateName", (Object)"host_serial_number");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("serialnumber", mainBoardID);
        jsonEmail.put("param", map);
        json.put("email", (Object)jsonEmail);
        notice.setSendContent(json.toString());
        notice.setSendTimes(Integer.valueOf(1));
        notice.setSendComplete(Integer.valueOf(0));
        notice.setCreatedAt(new Date());
        this.noticeService.notice(notice);
        return res;
    }
}

