/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.EncodeUtil;
import com.mopaas.server.common.HttpClientUtils;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.controller.ProjectController;
import com.mopaas.server.controller.StorageController;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.ExpansionRepository;
import com.mopaas.server.dao.HarborFrameRepoRepository;
import com.mopaas.server.dao.HarborRepoTagRepository;
import com.mopaas.server.dao.K8sEngineRepository;
import com.mopaas.server.dao.MLabCodelibFileRepository;
import com.mopaas.server.dao.MLabCodelibTextRepository;
import com.mopaas.server.dao.MLabNotebookRepository;
import com.mopaas.server.dao.MLabProjectForkRepository;
import com.mopaas.server.dao.MLabProjectRepository;
import com.mopaas.server.dao.MLabProjectStorageRepository;
import com.mopaas.server.dao.MLabTextRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.ResourceSnapRepository;
import com.mopaas.server.dao.ResourceStorageRepository;
import com.mopaas.server.dao.StorageDeptRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.dto.VolumeMountDto;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.MLabCodelibFile;
import com.mopaas.server.entity.MLabCodelibText;
import com.mopaas.server.entity.MLabNotebook;
import com.mopaas.server.entity.MLabProject;
import com.mopaas.server.entity.MLabProjectFork;
import com.mopaas.server.entity.MLabProjectStorage;
import com.mopaas.server.entity.MLabText;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.ReferDuration;
import com.mopaas.server.entity.Resource;
import com.mopaas.server.entity.ResourceExpansion;
import com.mopaas.server.entity.ResourceSnap;
import com.mopaas.server.entity.ResourceStorage;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.StorageDept;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.User;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.harbor.api.ProductsApi;
import com.mopaas.server.harbor.model.DetailedTag;
import com.mopaas.server.harbor.model.Label;
import com.mopaas.server.model.request.CodelibEditRequest;
import com.mopaas.server.model.request.CodelibFileCreateRequest;
import com.mopaas.server.model.request.CodelibNewRequest;
import com.mopaas.server.model.request.CompareJupyterRequest;
import com.mopaas.server.model.request.CreateProjectRequest;
import com.mopaas.server.model.request.CreateResourceRequest;
import com.mopaas.server.model.request.EditCodeFileRequest;
import com.mopaas.server.model.request.EditProjectRequest;
import com.mopaas.server.model.request.MLabNotebookPageRequest;
import com.mopaas.server.model.request.RecoverJupyterRequest;
import com.mopaas.server.model.request.RunProjectRequest;
import com.mopaas.server.model.request.SaveJupyterRequest;
import com.mopaas.server.model.request.SearchProjectRequest;
import com.mopaas.server.model.response.BooleanResponse;
import com.mopaas.server.model.response.CodeFileListModel;
import com.mopaas.server.model.response.CodeFileModel;
import com.mopaas.server.model.response.CodeTextModel;
import com.mopaas.server.model.response.CompareJupyterResponse;
import com.mopaas.server.model.response.DomainResourceModel;
import com.mopaas.server.model.response.ForkLogModel;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.MLabNotebookModel;
import com.mopaas.server.model.response.MLabProjectModel;
import com.mopaas.server.model.response.MLabStorageProjectModel;
import com.mopaas.server.model.response.MLabWorkspaceResponse;
import com.mopaas.server.model.response.NotebookResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.ProjectIdResponse;
import com.mopaas.server.model.response.ProjectJupyterResponse;
import com.mopaas.server.model.response.ProjectResponse;
import com.mopaas.server.model.response.ProjectStorageModel;
import com.mopaas.server.model.response.ResourceStatusResponse;
import com.mopaas.server.model.response.ResourceTimeResponse;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.service.CommonService;
import com.mopaas.server.service.NoticeUserService;
import com.mopaas.server.service.ResourceService;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMapVolumeSource;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1EmptyDirVolumeSource;
import io.kubernetes.client.openapi.models.V1HostPathVolumeSource;
import io.kubernetes.client.openapi.models.V1KeyToPath;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimVolumeSource;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MLab-\u9879\u76ee\u76f8\u5173"})
@RestController
public class ProjectController {
    final UserRepository userRepository;
    final MLabProjectRepository mLabProjectRepository;
    final DomainRepository domainRepository;
    final StorageRepository storageRepository;
    final ResourceRepository resourceRepository;
    final MaterialsRepository materialsRepository;
    final ReferDurationRepository referDurationRepository;
    final PricePackageRepository pricePackageRepository;
    final SystemConfigRepository systemConfigRepository;
    final BalancesRepository balancesRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DepUsersRepository depUsersRepository;
    final DepQuotasRepository depQuotasRepository;
    final StorageDeptRepository storageDeptRepository;
    final NoticeUserService noticeUserService;
    final ExpansionRepository expansionRepository;
    final MLabNotebookRepository mLabNotebookRepository;
    final MLabTextRepository mLabTextRepository;
    final MLabProjectStorageRepository mLabProjectStorageRepository;
    final ResourceStorageRepository resourceStorageRepository;
    final MLabProjectForkRepository mLabProjectForkRepository;
    final MLabCodelibFileRepository mLabCodelibFileRepository;
    final MLabCodelibTextRepository mLabCodelibTextRepository;
    final StorageController storageController;
    final ResourceSnapRepository resourceSnapRepository;
    final ResourceService resourceService;
    final MessageUtil messageUtil;
    final StorageServiceFactory storageServiceFactory;
    final K8sEngineRepository k8sEngineRepository;
    final HarborFrameRepoRepository harborFrameRepoRepository;
    final HarborRepoTagRepository harborRepoTagRepository;
    final CommonService commonService;
    @Value(value="${express.url}")
    private String EXPRESS_URL;
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);

    @ApiOperation(value="\u65b0\u5efa\u9879\u76ee", notes="v3.3\u4fee\u6539\uff0c\u4fee\u6539\u4f20\u53c2datas\u7c7b\u578b")
    @Transactional
    @PostMapping(value={"/api/project"})
    public ProjectIdResponse create(@RequestBody @Valid CreateProjectRequest dto, HttpServletRequest request) {
        ProjectIdResponse res = new ProjectIdResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (null == dto.getName() || dto.getName().isEmpty()) {
            res.setMessage(this.messageUtil.getMessage("msg.project.name.empty"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (dto.getName().length() > 45) {
            res.setMessage(this.messageUtil.getMessage("msg.project.name.is.not.correct"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Map datas = dto.getDatas();
        if (datas != null && !datas.isEmpty()) {
            Collection values = datas.values();
            int uniqueVal = (int)values.stream().distinct().count();
            if (values.size() > uniqueVal) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.project.mount.path.duplicated"));
                return res;
            }
            for (Long id : datas.keySet()) {
                if (datas.get(id) != null && !((String)datas.get(id)).isEmpty()) continue;
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.project.dataset.path.empty"));
                return res;
            }
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        MLabProject mLabProject = this.createPrivateProject(user, domain, dto, department);
        MLabText mLabText = new MLabText();
        mLabText.setGuid(UUID.randomUUID().toString().replace("-", ""));
        if (null != dto.getNotebook() && !dto.getNotebook().isEmpty()) {
            com.alibaba.fastjson.JSONObject jsonObject;
            String notebook = dto.getNotebook();
            try {
                jsonObject = JSON.parseObject((String)notebook);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                res.setMessage(this.messageUtil.getMessage("msg.project.file.error"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            com.alibaba.fastjson.JSONArray cells = jsonObject.getJSONArray("cells");
            for (int i = 0; i < cells.size(); ++i) {
                String sourceString;
                com.alibaba.fastjson.JSONObject cell = (com.alibaba.fastjson.JSONObject)cells.get(i);
                String source = String.valueOf(cell.get((Object)"source"));
                if ("[]".equals(source)) {
                    cell.put("source", (Object)"");
                }
                if (!source.startsWith("[") || (sourceString = StringUtils.strip((String)source, (String)"[]")).length() <= 0) continue;
                sourceString = sourceString.substring(1, sourceString.length() - 1).replace("\",\"", "");
                cell.put("source", (Object)sourceString);
                cells.set(i, (Object)cell);
            }
            jsonObject.put("cells", (Object)cells);
            notebook = jsonObject.toString();
            while (notebook.contains("\\\\")) {
                notebook = notebook.replaceAll("\\\\\\\\", "\\\\");
            }
            mLabText.setTextContent(notebook);
        } else {
            MLabText defaultText = (MLabText)this.mLabTextRepository.findOne((Serializable)Long.valueOf(1L));
            if (null != defaultText) {
                mLabText.setTextContent(defaultText.getTextContent());
            }
        }
        mLabText.setDeleted(Integer.valueOf(0));
        mLabText.setCreatedAt(new Date());
        mLabText = (MLabText)this.mLabTextRepository.saveAndFlush((Object)mLabText);
        mLabProject.setMLabText(mLabText);
        res.setProjectId(mLabProject.getId());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u65b0\u5efa\u9879\u76ee\uff08\u5df2\u6709\u73af\u5883\uff09")
    @Transactional
    @PostMapping(value={"/api/resource/{id}/project"})
    public ProjectIdResponse createProject(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ProjectIdResponse res = new ProjectIdResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Resource resource = (Resource)this.resourceRepository.findOne((Serializable)id);
        MLabProject mLabProject = resource.getMLabProject();
        if (null == mLabProject) {
            String name = resource.getName();
            String guid = UUID.randomUUID().toString().replace("-", "");
            String harborDomain = FactoryCollection.harborDomain((Long)resource.getDomain().getId());
            String[] split = resource.getImage().replace(harborDomain + "/", "").split(":");
            String repository = split[0];
            String tag = split[1];
            HashMap<Long, String> datas = new HashMap<Long, String>();
            List storages = resource.getStorages();
            if (null != storages && !storages.isEmpty()) {
                for (ResourceStorage rs : storages) {
                    if (rs.getStorage().getName().equals(rs.getStorage().getUser().getGuid().replace("-", ""))) continue;
                    datas.put(rs.getStorage().getId(), rs.getPath());
                }
            }
            CreateProjectRequest dto = new CreateProjectRequest();
            dto.setName(name);
            dto.setGuid(guid);
            dto.setRepository(repository);
            dto.setTag(tag);
            dto.setDatas(datas);
            mLabProject = this.createPrivateProject(resource.getUser(), resource.getDomain(), dto, resource.getDepartment());
            MLabText mLabText = new MLabText();
            mLabText.setGuid(UUID.randomUUID().toString().replace("-", ""));
            MLabText defaultText = (MLabText)this.mLabTextRepository.findOne((Serializable)Long.valueOf(1L));
            if (null != defaultText) {
                mLabText.setTextContent(defaultText.getTextContent());
            }
            mLabText.setDeleted(Integer.valueOf(0));
            mLabText.setCreatedAt(new Date());
            mLabText = (MLabText)this.mLabTextRepository.saveAndFlush((Object)mLabText);
            mLabProject.setMLabText(mLabText);
            if (resource.getStatus() == 1) {
                mLabProject.setStatus(Integer.valueOf(1));
            }
        }
        res.setProjectId(mLabProject.getId());
        res.setCode(Constants.SC_OK);
        return res;
    }

    private MLabProject createPrivateProject(User user, Domain domain, CreateProjectRequest dto, OrgConfigDepartment department) {
        MLabProject mLabProject = new MLabProject();
        mLabProject.setUser(user);
        mLabProject.setDepartment(department);
        mLabProject.setName(dto.getName());
        mLabProject.setImage(FactoryCollection.harborDomain((Long)domain.getId()) + "/" + dto.getRepository() + ":" + dto.getTag());
        mLabProject.setGuid(dto.getGuid() != null ? dto.getGuid() : UUID.randomUUID().toString().replace("-", ""));
        mLabProject.setCreatedAt(new Date());
        mLabProject.setCreator(user.getUsername());
        mLabProject.setType(Integer.valueOf(1));
        mLabProject.setStatus(Integer.valueOf(0));
        mLabProject.setDeleted(Integer.valueOf(0));
        mLabProject.setDomain(domain);
        mLabProject.setAutoSave(Integer.valueOf(5));
        Map datas = dto.getDatas();
        this.resourceService.checkMlabStorageMount(datas, mLabProject);
        mLabProject = (MLabProject)this.mLabProjectRepository.saveAndFlush((Object)mLabProject);
        return mLabProject;
    }

    @ApiOperation(value="\u7f16\u8f91\u9879\u76ee(\u540d\u79f0\uff0c\u6570\u636e\u96c6)", notes="v3.3\u4fee\u6539\uff0c\u4fee\u6539\u4f20\u53c2datas\u7c7b\u578b")
    @Transactional
    @RequestMapping(value={"/api/project/edit"}, method={RequestMethod.PUT})
    public ResourceStatusResponse editProject(@RequestBody @Valid EditProjectRequest dto, HttpServletRequest request) throws Exception {
        Storage storage;
        ResourceStatusResponse res = new ResourceStatusResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)dto.getId());
        if (null == mLabProject || mLabProject.getDeleted() == 1) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        mLabProject.setName(dto.getName());
        Map datas = dto.getDatas();
        Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        if (null != resource) {
            resource.setName(dto.getName());
            List resourceStorageList = resource.getStorages();
            HashMap<Long, String> oldDatas = new HashMap<Long, String>();
            if (resourceStorageList != null && !resourceStorageList.isEmpty()) {
                for (ResourceStorage rs : resourceStorageList) {
                    oldDatas.put(rs.getStorage().getId(), rs.getPath());
                }
            }
            if (oldDatas.equals(datas)) {
                res.setCode(Constants.SC_OK);
                return res;
            }
        }
        if (datas != null && !datas.isEmpty()) {
            Collection values = datas.values();
            int uniqueVal = (int)values.stream().distinct().count();
            if (values.size() > uniqueVal) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.project.mount.path.duplicated"));
                return res;
            }
            for (Long id : datas.keySet()) {
                if (datas.get(id) != null && !((String)datas.get(id)).isEmpty()) continue;
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.project.dataset.path.empty"));
                return res;
            }
            ArrayList dataIds = new ArrayList(datas.keySet());
            List storages = this.storageRepository.findAll(dataIds);
            if (mLabProject.getType() == 0 && storages.size() > 0) {
                Iterator iterator = storages.iterator();
                while (iterator.hasNext()) {
                    storage = (Storage)iterator.next();
                    if (storage.getExposed() != 0) continue;
                    storage.setExposed(Integer.valueOf(1));
                }
            }
            this.resourceService.checkMlabStorageMount(datas, mLabProject);
        } else if (null != mLabProject.getStorages()) {
            mLabProject.getStorages().clear();
        }
        if (null != resource) {
            String guid = resource.getGuid();
            ArrayList<ResourceStorage> resourceStorages = resource.getStorages();
            if (null != resourceStorages) {
                resourceStorages.clear();
            } else {
                resourceStorages = new ArrayList<ResourceStorage>(4);
            }
            if (null != datas && !datas.isEmpty()) {
                for (Long id : datas.keySet()) {
                    storage = (Storage)this.storageRepository.findOne((Serializable)id);
                    ResourceStorage r_storage = new ResourceStorage();
                    r_storage.setResource(resource);
                    r_storage.setStorage(storage);
                    r_storage.setPath((String)datas.get(id));
                    resourceStorages.add(r_storage);
                }
            }
            try {
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)resource.getDomain().getId());
                AppsV1Api appsV1Api = k8sFactory.appsV1Api;
                V1Deployment deployment = appsV1Api.readNamespacedDeployment("deploy-resource", guid, null, null, null);
                ArrayList<V1Volume> volumes = new ArrayList<V1Volume>();
                volumes.add(new V1Volume().name("shm").emptyDir(new V1EmptyDirVolumeSource().medium("Memory")));
                volumes.add(new V1Volume().name("timezone").hostPath(new V1HostPathVolumeSource().path("/usr/share/zoneinfo/Asia/Shanghai")));
                volumes.add(new V1Volume().name("cpuinfo").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/cpuinfo").type("File")));
                volumes.add(new V1Volume().name("diskstats").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/diskstats").type("File")));
                volumes.add(new V1Volume().name("meminfo").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/meminfo").type("File")));
                volumes.add(new V1Volume().name("stat").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/stat").type("File")));
                volumes.add(new V1Volume().name("swaps").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/swaps").type("File")));
                volumes.add(new V1Volume().name("uptime").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/uptime").type("File")));
                ArrayList<V1VolumeMount> volumeMounts = new ArrayList<V1VolumeMount>();
                volumeMounts.add(new V1VolumeMount().name("shm").mountPath("/dev/shm"));
                volumeMounts.add(new V1VolumeMount().name("timezone").mountPath("/etc/localtime"));
                volumeMounts.add(new V1VolumeMount().name("cpuinfo").mountPath("/proc/cpuinfo").readOnly(Boolean.valueOf(true)));
                volumeMounts.add(new V1VolumeMount().name("diskstats").mountPath("/proc/diskstats").readOnly(Boolean.valueOf(true)));
                volumeMounts.add(new V1VolumeMount().name("meminfo").mountPath("/proc/meminfo").readOnly(Boolean.valueOf(true)));
                volumeMounts.add(new V1VolumeMount().name("stat").mountPath("/proc/stat").readOnly(Boolean.valueOf(true)));
                volumeMounts.add(new V1VolumeMount().name("swaps").mountPath("/proc/swaps").readOnly(Boolean.valueOf(true)));
                volumeMounts.add(new V1VolumeMount().name("uptime").mountPath("/proc/uptime").readOnly(Boolean.valueOf(true)));
                if (resourceStorages.size() > 0) {
                    for (ResourceStorage rs : resourceStorages) {
                        StorageDept storageDept;
                        boolean readOnly;
                        Storage storage2 = rs.getStorage();
                        boolean bl = readOnly = !storage2.getUser().getId().equals(userId);
                        if (readOnly && null != (storageDept = this.storageDeptRepository.findByStorageIdAndDepartmentId(storage2.getId(), resource.getDepartment().getId())) && storageDept.getRw() == 1) {
                            readOnly = false;
                        }
                        if (storage2.getType() != null && storage2.getType() == 2) {
                            k8sFactory.createPVC(guid, "ReadWriteOnce", storage2.getCapacity(), "cephrbd");
                            volumes.add(new V1Volume().name("cephrbd").persistentVolumeClaim(new V1PersistentVolumeClaimVolumeSource().claimName("pvc-" + guid)));
                            volumeMounts.add(new V1VolumeMount().name("cephrbd").mountPath(rs.getPath()));
                            continue;
                        }
                        this.storageServiceFactory.volumeMountPrepare(storage2.getType(), volumes, volumeMounts, VolumeMountDto.builder().k8sFactory(k8sFactory).namespace(guid).storage(storage2.getName()).storageGuid(storage2.getGuid()).mountPath(rs.getPath()).readOnly(Boolean.valueOf(readOnly)).build());
                    }
                }
                if (resource.getReplicas() > 1 && resource.getImage().contains("horovod")) {
                    V1Volume volume_hostfile = new V1Volume().name("mnist-horovod-cm").configMap(new V1ConfigMapVolumeSource().name("mnist-horovod").addItemsItem(new V1KeyToPath().key("hostfile.config").path("hostfile").mode(Integer.valueOf(438))));
                    volumes.add(volume_hostfile);
                    V1VolumeMount cm_mount = new V1VolumeMount().name("mnist-horovod-cm").mountPath("/horovod/generated");
                    volumeMounts.add(cm_mount);
                    V1StatefulSet sts = appsV1Api.readNamespacedStatefulSet("mnist-horovod", guid, null, null, null);
                    sts.getSpec().getTemplate().getSpec().setVolumes(volumes);
                    ((V1Container)sts.getSpec().getTemplate().getSpec().getContainers().get(0)).setVolumeMounts(volumeMounts);
                    appsV1Api.replaceNamespacedStatefulSet("mnist-horovod", guid, sts, null, null, null);
                }
                deployment.getSpec().getTemplate().getSpec().setVolumes(volumes);
                ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setVolumeMounts(volumeMounts);
                appsV1Api.replaceNamespacedDeployment("deploy-resource", guid, deployment, null, null, null);
                if (resource.getStatus() == 1) {
                    resource.setStatus(Integer.valueOf(5));
                    resource.setErrorMessage(null);
                }
                k8sFactory.deletePods(guid);
            }
            catch (ApiException e) {
                logger.info(e.getResponseBody());
            }
            res.setStatus(resource.getStatus());
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u9879\u76ee\u516c\u5f00")
    @Transactional
    @RequestMapping(value={"/api/project/{id}/pub"}, method={RequestMethod.PUT})
    public ResultResponse pubProject(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        mLabProject.setType(Integer.valueOf(0));
        List storages = mLabProject.getStorages();
        if (null != storages && storages.size() > 0) {
            for (Storage storage : storages) {
                if (storage.getName().equals(storage.getUser().getGuid().replace("-", ""))) continue;
                storage.setExposed(Integer.valueOf(1));
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u9879\u76ee\u505c\u6b62")
    @Transactional
    @RequestMapping(value={"/api/project/{id}/stop"}, method={RequestMethod.DELETE})
    public ResultResponse stopProject(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            return res;
        }
        Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        if (null != resource) {
            List durations;
            List expansions;
            List materials;
            AppsV1Api appsV1Api = FactoryCollection.k8sFactory((Long)resource.getDomain().getId()).appsV1Api;
            V1Patch array = new V1Patch("[{\"op\": \"replace\", \"path\": \"/spec/replicas\",\"value\": 0}]");
            appsV1Api.patchNamespacedDeployment("deploy-resource", resource.getGuid(), array, null, null, null, null);
            if (resource.getReplicas() > 1) {
                if (resource.getImage().contains("horovod")) {
                    appsV1Api.patchNamespacedStatefulSet("mnist-horovod", resource.getGuid(), array, null, null, null, null);
                } else {
                    appsV1Api.patchNamespacedDeployment("deploy-worker", resource.getGuid(), array, null, null, null, null);
                }
            }
            resource.setStatus(Integer.valueOf(3));
            resource.setErrorMessage(null);
            Date now = new Date();
            resource.setReclaimedAt(now);
            if (resource.getPackageType() == 1 && null != (materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0))) && !materials.isEmpty()) {
                for (Materials material : materials) {
                    material.setLastedAt(now);
                    material.setOperation(null);
                }
            }
            if ((expansions = resource.getExpansions()) != null) {
                for (ResourceExpansion expansion : expansions) {
                    if (expansion.getStatus() == null || expansion.getStatus() != 0) continue;
                    expansion.setStatus(Integer.valueOf(-1));
                }
            }
            if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(resource.getId(), Integer.valueOf(0))) != null) {
                for (ReferDuration duration : durations) {
                    duration.setEnd(now);
                }
            }
        }
        mLabProject.setStatus(Integer.valueOf(0));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u9879\u76ee\u5220\u9664")
    @Transactional
    @RequestMapping(value={"/api/project/{id}"}, method={RequestMethod.DELETE})
    public ResultResponse deleteProject(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException, com.mopaas.server.harbor.ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            return res;
        }
        Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        if (null != resource) {
            List snapList;
            List storages;
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)resource.getDomain().getId());
            Date now = new Date();
            resource.setUpdatedAt(now);
            resource.setUpdater(user.getUsername());
            List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0));
            if (null != materials) {
                for (Object material : materials) {
                    material.setLastedAt(now);
                    material.setOperation(null);
                }
            }
            if (null != (storages = resource.getStorages()) && storages.size() > 0) {
                for (Object rs : storages) {
                    Storage storage = rs.getStorage();
                    if (null == storage.getType()) continue;
                    if (storage.getType() == 3) {
                        try {
                            V1PersistentVolume pv = k8sFactory.coreV1Api.readPersistentVolume("pv-" + resource.getGuid() + storage.getGuid().substring(20), null, null, null);
                            if (null != pv) {
                                k8sFactory.coreV1Api.deletePersistentVolume("pv-" + resource.getGuid() + storage.getGuid().substring(20), null, null, null, null, null, null);
                            }
                        }
                        catch (Exception e) {
                            logger.info(e.getMessage());
                        }
                    }
                    if (storage.getType() != 2) continue;
                    List cephMaterials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(storage.getId(), Integer.valueOf(2));
                    if (null != cephMaterials) {
                        for (Materials material : cephMaterials) {
                            material.setLastedAt(now);
                            material.setOperation(null);
                        }
                    }
                    storage.setDeleted(Integer.valueOf(1));
                }
            }
            try {
                k8sFactory.deleteNamespace(resource.getGuid());
            }
            catch (Exception e) {
                logger.info("delete resource [" + resource.getName() + "] of the project [" + mLabProject.getName() + "] " + e.getMessage());
            }
            List durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(resource.getId(), Integer.valueOf(0));
            if (durations != null) {
                for (ReferDuration duration : durations) {
                    duration.setEnd(now);
                }
            }
            if (null != (snapList = this.resourceSnapRepository.findByResourceAndDeletedOrderByIdDesc(resource, Integer.valueOf(0))) && snapList.size() > 0) {
                ProductsApi harborApi = FactoryCollection.harborApi((Long)resource.getDomain().getId());
                for (int i = snapList.size() - 1; i >= 0; --i) {
                    ResourceSnap snap = (ResourceSnap)snapList.get(i);
                    String[] imageSplit = snap.getImage().replace(resource.getDomain().getId() + "/", "").replace(":", "/").split("/");
                    try {
                        harborApi.repositoriesRepoNameTagsTagDelete(imageSplit[0] + "/" + imageSplit[1], snap.getImageVersion());
                    }
                    catch (com.mopaas.server.harbor.ApiException e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    snap.setDeleted(Integer.valueOf(1));
                }
            }
            resource.setDeleted(Integer.valueOf(1));
        }
        mLabProject.getStorages().clear();
        mLabProject.setDeleted(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u9879\u76ee\u5217\u8868")
    @Transactional
    @PostMapping(value={"/api/project/list"})
    public ListResultResponse<MLabProjectModel> list(@RequestBody @Valid SearchProjectRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        1 spec = new /* Unavailable Anonymous Inner Class!! */;
        List mLabProjectList = this.mLabProjectRepository.findAll((Specification)spec);
        if (null != mLabProjectList && mLabProjectList.size() > 0) {
            res.setSize(Long.valueOf(mLabProjectList.size()));
            ArrayList<MLabProjectModel> models = new ArrayList<MLabProjectModel>(mLabProjectList.size());
            for (MLabProject mLabProject : mLabProjectList) {
                MLabProjectModel model = new MLabProjectModel();
                model.setId(mLabProject.getId());
                model.setGuid(mLabProject.getGuid());
                model.setName(mLabProject.getName());
                model.setImage(mLabProject.getImage());
                model.setRemark(mLabProject.getRemark());
                model.setType(mLabProject.getType());
                Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
                Integer states = mLabProject.getStatus();
                if (resource != null && resource.getStatus() != 1 && resource.getStatus() != -3 && resource.getStatus() != -2) {
                    states = 0;
                } else if (resource != null && (resource.getStatus() == -3 || resource.getStatus() == -2)) {
                    states = 2;
                }
                model.setStatus(states);
                model.setUserId(mLabProject.getUser().getId());
                model.setUsername(mLabProject.getUser().getUsername());
                model.setFullName(mLabProject.getUser().getName() == null ? mLabProject.getUser().getUsername() : mLabProject.getUser().getName());
                model.setCreatedAt(mLabProject.getCreatedAt());
                model.setStartedAt(mLabProject.getStartedAt());
                models.add(model);
            }
            models.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5957\u9910")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/project/package/list"}, method={RequestMethod.GET})
    public ListResultResponse<PackageInfoModel> listPackage(HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        Long domainId = (Long)session.getAttribute("domain");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization organization = dep.getOrgConfig().getOrganization();
        List orgPricePackage = organization.getResourcePricePackage();
        List pricePackages = dep.getPricePackage();
        ArrayList<PricePackage> packages = new ArrayList<PricePackage>();
        if (pricePackages != null && pricePackages.size() > 0) {
            for (PricePackage pack : pricePackages) {
                if (pack.getType() != 1 || !domainId.equals(pack.getDomain().getId()) || packages.contains(pack) || !orgPricePackage.contains(pack)) continue;
                packages.add(pack);
            }
        }
        if (!packages.isEmpty()) {
            com.alibaba.fastjson.JSONObject object = this.commonService.domainResourceFree(domainId);
            List resourceList = (List)object.getObject("resource_list", ArrayList.class);
            SystemConfig resourceAudit = this.systemConfigRepository.findByConfigName("RESOURCE_AUDIT_" + domainId);
            boolean sysCheck = null != resourceAudit && "true".equals(resourceAudit.getConfigValue());
            ArrayList<PackageInfoModel> list = new ArrayList<PackageInfoModel>(packages.size());
            for (PricePackage pack : packages) {
                if (pack.getStatus() != 1 || pack.getDeleted() != 0) continue;
                PackageInfoModel model = new PackageInfoModel();
                BeanUtils.copyProperties((Object)pack, (Object)model);
                if (sysCheck || pack.getAutoCheck() != 1) {
                    model.setAutoCheck(Integer.valueOf(0));
                } else {
                    model.setAutoCheck(Integer.valueOf(1));
                }
                if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                    model.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setAvailable(Integer.valueOf(0));
                for (DomainResourceModel d : resourceList) {
                    if (model.getCpuNum() > d.getCpuNum() || model.getMemoryNum() > d.getMemoryNum() || (model.getGpuNum() != null && model.getGpuNum() > 0 ? "false".equals(d.getGpuShare()) && model.getSlice() != 1 || "true".equals(d.getGpuShare()) && model.getSlice() <= 1 || "vgpu".equals(d.getGpuShare()) && model.getSlice() != 0 || "mig".equals(d.getGpuShare()) && model.getSlice() != -1 || !model.getGpuType().equals(d.getGpuType()) || model.getSlice() != 1 && d.getGpuNum() == 0 || model.getSlice() == 1 && model.getGpuNum() > d.getGpuNum() : !"x86".equals(d.getMachine()))) continue;
                    model.setAvailable(Integer.valueOf(1));
                    break;
                }
                list.add(model);
            }
            list.sort(Comparator.comparing(PackageInfoModel::getId).reversed());
            res.setList(list);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="fork")
    @Transactional
    @RequestMapping(value={"/api/project/{id}&{note}/fork"}, method={RequestMethod.POST})
    public ProjectIdResponse forkProject(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, @ApiParam(value="\u7248\u672cid") @PathVariable(value="note") Long note, HttpServletRequest request) {
        ProjectIdResponse res = new ProjectIdResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject || mLabProject.getDeleted() == 1) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        if (mLabProject.getType() == 0) {
            CreateProjectRequest createProjectRequest = new CreateProjectRequest();
            createProjectRequest.setName(mLabProject.getName());
            String image = mLabProject.getImage();
            String[] imageSplit = image.substring(image.indexOf("/") + 1).replace(":", "/").split("/");
            createProjectRequest.setRepository(imageSplit[0] + "/" + imageSplit[1]);
            createProjectRequest.setTag(imageSplit[2]);
            HashMap<Long, String> datas = new HashMap<Long, String>();
            for (MLabProjectStorage projectStorage : mLabProject.getMLabProjectStorage()) {
                datas.put(projectStorage.getId(), projectStorage.getPath());
            }
            createProjectRequest.setDatas(datas);
            createProjectRequest.setGuid(UUID.randomUUID().toString().replace("-", ""));
            Long depId = (Long)session.getAttribute("departmentId");
            OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
            MLabProject newMLabProject = this.createPrivateProject(user, domain, createProjectRequest, department);
            Date date = new Date();
            MLabNotebook notebook = (MLabNotebook)this.mLabNotebookRepository.findOne((Serializable)note);
            if (null != notebook) {
                MLabNotebook newNotebook = new MLabNotebook();
                newNotebook.setGuid(UUID.randomUUID().toString().replace("-", ""));
                newNotebook.setNVersion(notebook.getNVersion());
                newNotebook.setCreatedAt(date);
                newNotebook.setUpdatedAt(date);
                newNotebook.setCreator(user.getUsername());
                newNotebook.setUpdater(user.getUsername());
                newNotebook.setMLabProject(newMLabProject);
                newNotebook.setDeleted(Integer.valueOf(0));
                if (!com.mopaas.server.common.StringUtils.isEmpty((String)notebook.getMLabText().getTextContent())) {
                    MLabText text = new MLabText();
                    text.setTextContent(notebook.getMLabText().getTextContent());
                    text.setDeleted(Integer.valueOf(0));
                    text.setCreatedAt(date);
                    text.setGuid(UUID.randomUUID().toString().replace("-", ""));
                    this.mLabTextRepository.save((Object)text);
                    newNotebook.setMLabText(text);
                    MLabText mLabText = new MLabText();
                    mLabText.setGuid(UUID.randomUUID().toString().replace("-", ""));
                    mLabText.setTextContent(notebook.getMLabText().getTextContent());
                    mLabText.setDeleted(Integer.valueOf(0));
                    mLabText.setCreatedAt(date);
                    mLabText = (MLabText)this.mLabTextRepository.saveAndFlush((Object)mLabText);
                    newMLabProject.setMLabText(mLabText);
                } else {
                    newNotebook.setMLabText(null);
                    MLabText mLabText = new MLabText();
                    mLabText.setGuid(UUID.randomUUID().toString().replace("-", ""));
                    MLabText defaultText = (MLabText)this.mLabTextRepository.findOne((Serializable)Long.valueOf(1L));
                    if (null != defaultText) {
                        mLabText.setTextContent(defaultText.getTextContent());
                    }
                    mLabText.setDeleted(Integer.valueOf(0));
                    mLabText.setCreatedAt(date);
                    mLabText = (MLabText)this.mLabTextRepository.saveAndFlush((Object)mLabText);
                    newMLabProject.setMLabText(mLabText);
                }
                this.mLabNotebookRepository.save((Object)newNotebook);
            }
            MLabProjectFork mLabProjectFork = new MLabProjectFork();
            mLabProjectFork.setName(mLabProject.getName());
            mLabProjectFork.setMLabProject(newMLabProject);
            mLabProjectFork.setOrigin(mLabProject);
            mLabProjectFork.setCreatedAt(date);
            this.mLabProjectForkRepository.save((Object)mLabProjectFork);
            res.setProjectId(newMLabProject.getId());
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u90e8\u95e8\u8d44\u6e90\u6821\u9a8c")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/project/{id}/allocation"}, method={RequestMethod.GET})
    public BooleanResponse allocationCheck(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        DepQuotas depQuotas;
        BooleanResponse res = new BooleanResponse();
        res.setABoolean(false);
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId))) {
            String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
            Organization org = dep.getOrgConfig().getOrganization();
            for (OrgConfig config : org.getOrgConfigs()) {
                if (1 != config.getLevel()) continue;
                depName = config.getName();
                break;
            }
            if (null != depQuotas.getResourceCount() && depQuotas.getResourceCount() != -1) {
                Integer user_count = this.resourceRepository.countByDepartmentIdAndDeletedAndDomainAndUser(depId, Integer.valueOf(0), domain, user);
                Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
                if (null != resource) {
                    user_count = user_count - 1;
                }
                if (null != user_count && user_count >= depQuotas.getResourceCount()) {
                    res.setMessage(this.messageUtil.getMessage("msg.dep.resource.insufficient.error", new String[]{depName}));
                    res.setCode(Constants.SC_MSG);
                    return res;
                }
            }
            if (null != depQuotas.getResourceTime() && depQuotas.getResourceTime() != -1.0) {
                Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(0), userId, depId, domain.getId(), Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getResourceTime() * 60.0 * 60.0) {
                    res.setMessage(this.messageUtil.getMessage("msg.dep.resource.time.insufficient.error", new String[]{depName}));
                    res.setCode(Constants.SC_MSG);
                    return res;
                }
            }
        }
        res.setABoolean(true);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u9879\u76ee\u8fd0\u884c")
    @Transactional
    @RequestMapping(value={"/api/project/run"}, method={RequestMethod.POST})
    public ResultResponse runProject(@RequestBody @Valid RunProjectRequest dto, HttpServletRequest request) throws ApiException, com.mopaas.server.harbor.ApiException {
        List reclaims;
        Double balance;
        ResultResponse res = new ResultResponse();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)dto.getId());
        if (null == mLabProject || mLabProject.getDeleted() == 1) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        if (dto.getReplicas() < 2 && mLabProject.getImage().contains("horovod")) {
            res.setMessage(this.messageUtil.getMessage("msg.resource.horovod.replicas"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        PricePackage pack = (PricePackage)this.pricePackageRepository.findOne((Serializable)dto.getPackageId());
        if (pack.getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance < 0.0)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.org.balance.insufficient"));
            return res;
        }
        Domain domain = pack.getDomain();
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domain.getId());
        Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        String image = mLabProject.getImage();
        String[] imageSplit = image.replace(FactoryCollection.harborDomain((Long)domain.getId()) + "/", "").replace(":", "/").split("/");
        String repositoryName = imageSplit[0] + "/" + imageSplit[1];
        String tagName = imageSplit[2];
        Integer priority = Optional.ofNullable(user.getResourcePriority()).orElse(0);
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(domain).organization(org).department(dep).user(user).name(mLabProject.getName()).pack(pack).audit(Boolean.valueOf(false)).priority(null != resource ? resource.getPriority() : priority).replica(dto.getReplicas()).operate("start").build();
        this.resourceService.checkImage(identityDto, repositoryName, tagName, domain.getId());
        if (null == resource) {
            this.resourceService.checkOrgQuota(identityDto, org);
            this.resourceService.checkDepQuota(Integer.valueOf(1), identityDto);
            this.commonService.judgeResource(identityDto);
            reclaims = this.resourceService.judgeSysResource(identityDto);
            identityDto.setPriority(priority);
            String DEFAULT_PWD = UUID.randomUUID().toString().replace("-", "").substring(0, 12);
            CreateResourceRequest crr = CreateResourceRequest.builder().name(mLabProject.getName()).repository(repositoryName).tag(tagName).packageType(Integer.valueOf(1)).password(DEFAULT_PWD).renewal(Integer.valueOf(0)).replicas(dto.getReplicas()).build();
            resource = this.resourceService.assembleResource(crr, identityDto);
            resource.setMLabProject(mLabProject);
            List storages = mLabProject.getStorages();
            ArrayList<ResourceStorage> list = new ArrayList<ResourceStorage>();
            if (null != storages && storages.size() > 0) {
                for (Storage storage : storages) {
                    if (storage.getName().equals(user.getGuid())) continue;
                    ResourceStorage r_storage = new ResourceStorage();
                    r_storage.setResource(resource);
                    r_storage.setStorage(storage);
                    MLabProjectStorage projectStorage = this.mLabProjectStorageRepository.findByMLabProjectAndStorage(mLabProject, storage);
                    if (projectStorage != null && projectStorage.getPath() != null) {
                        r_storage.setPath(projectStorage.getPath());
                    } else {
                        r_storage.setPath("/ai/" + storage.getName());
                    }
                    list.add(r_storage);
                }
            }
            resource.setStorages(list);
            SystemConfig audit = this.systemConfigRepository.findByConfigName("RESOURCE_AUDIT_" + domain.getId());
            if (null != audit && "true".equals(audit.getConfigValue()) || pack.getAutoCheck() != 1) {
                resource.setStatus(Integer.valueOf(0));
                mLabProject.setStatus(Integer.valueOf(0));
                this.noticeUserService.send(Integer.valueOf(0), resource.getName(), user);
                return res;
            }
            if (null != reclaims) {
                this.resourceService.doPreempt(reclaims, k8sFactory);
            }
            this.resourceService.doCreate(resource);
        } else {
            if (resource.getStatus() == 4 || resource.getStatus() == 5 || resource.getStatus() == 6) {
                res.setCode(Constants.SC_OK);
                return res;
            }
            if (resource.getStatus() == -9 || resource.getStatus() == -6) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.sys.resource.insufficient"));
                return res;
            }
            ResourceExpansion expansion = null;
            if (!resource.getPack().getId().equals(dto.getPackageId()) || !resource.getReplicas().equals(dto.getReplicas())) {
                this.commonService.judgeScaleResource(identityDto, pack, dto.getReplicas());
                expansion = new ResourceExpansion();
                expansion.setPackNew(pack);
                expansion.setPackOld(resource.getPack());
                expansion.setResource(resource);
                expansion.setStatus(Integer.valueOf(1));
                expansion.setInstanceNew(dto.getReplicas());
                expansion.setInstanceOld(Integer.valueOf(resource.getReplicas() == null ? 1 : resource.getReplicas()));
                reclaims = this.resourceService.judgeSysScaleResource(expansion, identityDto);
                this.expansionRepository.save((Object)expansion);
                SystemConfig audit = this.systemConfigRepository.findByConfigName("RESOURCE_AUDIT_" + domain.getId());
                if (null != audit && "true".equals(audit.getConfigValue()) || pack.getAutoCheck() != 1) {
                    expansion.setStatus(Integer.valueOf(0));
                    resource.setStatus(Integer.valueOf(2));
                    this.noticeUserService.send(Integer.valueOf(1), resource.getName(), user);
                    return res;
                }
            } else {
                this.commonService.judgeResource(identityDto);
                reclaims = this.resourceService.judgeSysResource(identityDto);
            }
            if (null != reclaims) {
                this.resourceService.doPreempt(reclaims, k8sFactory);
            }
            if (null != expansion) {
                this.resourceService.doScale(resource, expansion);
            } else {
                this.resourceService.doRecovery(resource, identityDto, null);
            }
        }
        resource.setReplicas(dto.getReplicas());
        resource.setPack(pack);
        Date now = new Date();
        mLabProject.setStartedAt(now);
        mLabProject.setLastProbe(Long.valueOf(now.getTime()));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u9879\u76ee\u8be6\u60c5(\u57fa\u7840\u4fe1\u606f\uff0c\u540d\u79f0\u3001\u94fe\u63a5\u72b6\u6001\u3001\u521b\u5efa\u8005\u3001\u521b\u5efa\u65f6\u95f4\u3001\u6846\u67b6\u955c\u50cf)", notes="3.5\u4fee\u6539:\u65b0\u589e\u8fd4\u56de\u53c2\u6570ssh")
    @Transactional
    @GetMapping(value={"/api/project/{id}"})
    public ProjectResponse getProject(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException, ApiException {
        List mLabProjectStorages;
        ProjectResponse res = new ProjectResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        res.setId(mLabProject.getId());
        res.setName(mLabProject.getName());
        res.setType(mLabProject.getType());
        res.setUsername(mLabProject.getUser().getUsername());
        res.setFullName(mLabProject.getUser().getName());
        res.setCreatedAt(mLabProject.getCreatedAt());
        res.setStartedAt(mLabProject.getStartedAt());
        MLabText mLabText = mLabProject.getMLabText();
        if (null != mLabText) {
            res.setSaveAt(mLabText.getUpdatedAt());
        }
        if (null != (mLabProjectStorages = mLabProject.getMLabProjectStorage()) && !mLabProjectStorages.isEmpty()) {
            HashMap<Long, String> datas = new HashMap<Long, String>();
            for (MLabProjectStorage projectStorage : mLabProjectStorages) {
                Storage storage = projectStorage.getStorage();
                if (storage.getName().equals(storage.getUser().getGuid().replace("-", "")) || storage.getDeleted() == 1) continue;
                Resource resource = mLabProject.getResource();
                String path = null;
                if (resource != null) {
                    ResourceStorage resourceStorage = this.resourceStorageRepository.findTopByResourceAndStorage(resource, storage);
                    if (resourceStorage != null) {
                        path = resourceStorage.getPath();
                    }
                } else {
                    path = projectStorage.getPath();
                }
                datas.put(storage.getId(), path);
            }
            res.setDatas(datas);
        }
        Integer num = this.mLabNotebookRepository.countByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        res.setNotebookNum(num);
        Resource resource = this.resourceRepository.findTopByMLabProjectAndDeletedOrderByIdDesc(mLabProject, Integer.valueOf(0));
        if (null != resource) {
            V1Service service = FactoryCollection.k8sFactory((Long)domainId).coreV1Api.readNamespacedService("svc-resource-master", resource.getGuid(), null, null, null);
            List ports = service.getSpec().getPorts();
            ports.stream().filter(p -> "ssh".equals(p.getName())).findAny().ifPresent(p -> res.setSsh("ssh root@" + FactoryCollection.serviceAddr((Long)domainId) + " -p " + p.getNodePort()));
            res.setResourceId(resource.getId());
            PackageInfoModel pack = (PackageInfoModel)BeanMapper.map((Object)resource.getPack(), PackageInfoModel.class);
            if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
                pack.setGpuType(resource.getPack().getGpu().getChargeItem());
            }
            res.setPack(pack);
            if (resource.getStatus() == 1 && mLabProject.getStatus() != 1) {
                mLabProject.setStatus(Integer.valueOf(1));
            }
            Integer states = mLabProject.getStatus();
            if (resource.getStatus() != 1 && resource.getStatus() != -3 && resource.getStatus() != -2) {
                states = 0;
            } else if (resource.getStatus() == -3 || resource.getStatus() == -2) {
                states = 2;
            }
            res.setStatus(states);
            res.setResourceStatus(resource.getStatus());
            res.setReplicas(resource.getReplicas());
            res.setPassword(EncodeUtil.rawInput((String)resource.getPassword()));
        }
        res.setImage(mLabProject.getImage());
        if (null != domainId) {
            String[] imageSplit = mLabProject.getImage().substring(mLabProject.getImage().indexOf("/") + 1).split(":");
            if (imageSplit[0].startsWith("frame_system")) {
                res.setFrameType(Integer.valueOf(0));
            } else {
                res.setFrameType(Integer.valueOf(1));
            }
            DetailedTag tag = this.commonService.getHarborImage(domainId, imageSplit[0], imageSplit[1]);
            List labels = tag.getLabels();
            if (null != labels) {
                Optional<Label> arch = labels.stream().filter(e -> "gpu".equals(e.getName()) || "x86".equals(e.getName())).findFirst();
                res.setArch(arch.map(harborLabel -> "x86".equals(harborLabel.getName()) ? 0 : 1).orElse(2));
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u9879\u76ee\u6570\u636e\u96c6\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/project/{id}/storage/list"}, method={RequestMethod.GET})
    public ListResultResponse<ProjectStorageModel> listStorage(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id) throws Exception {
        ListResultResponse res = new ListResultResponse();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        ArrayList<ProjectStorageModel> list = new ArrayList<ProjectStorageModel>();
        List storages = mLabProject.getStorages();
        if (null != storages && !storages.isEmpty()) {
            res.setSize(Long.valueOf(storages.size()));
            for (Storage storage : storages) {
                if (storage.getName().equals(storage.getUser().getGuid().replace("-", ""))) continue;
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)storage.getDomain().getId());
                ProjectStorageModel model = new ProjectStorageModel();
                model.setId(storage.getId());
                model.setGuid(storage.getGuid());
                model.setName(storage.getName());
                model.setCreatedAt(storage.getCreatedAt());
                model.setUpdatedAt(storage.getUpdatedAt());
                model.setStatus(storage.getStatus());
                model.setCapacity(storage.getCapacity());
                String volumeUsed = this.storageServiceFactory.getVolumeUsed(storage, k8sFactory);
                model.setUsed(SizeConverter.BTrim.convert((float)Long.parseLong(volumeUsed == null ? "0" : volumeUsed)));
                model.setUserId(storage.getUser().getId());
                model.setGuid(storage.getGuid());
                Resource resource = mLabProject.getResource();
                if (resource != null) {
                    ResourceStorage resourceStorage = this.resourceStorageRepository.findTopByResourceAndStorage(resource, storage);
                    if (resourceStorage != null) {
                        model.setMountPath(resourceStorage.getPath());
                    }
                } else {
                    MLabProjectStorage projectStorage = this.mLabProjectStorageRepository.findByMLabProjectAndStorage(mLabProject, storage);
                    if (projectStorage != null) {
                        model.setMountPath(projectStorage.getPath());
                    }
                }
                list.add(model);
            }
            res.setList(list);
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6Jupyter")
    @Transactional
    @GetMapping(value={"/api/project/Jupyter/{id}"})
    public ProjectJupyterResponse getJupyter(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id) {
        ProjectJupyterResponse res = new ProjectJupyterResponse();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        if (null != resource) {
            if (resource.getStatus() == -9) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.sys.resource.insufficient"));
            }
            if (resource.getStatus() == -2 || resource.getStatus() == -3) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.resource.failed"));
            }
            if (resource.getStatus() == 0 || resource.getStatus() == 2) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.resource.check.pending"));
            }
            if (resource.getStatus() != 1) {
                return res;
            }
            try {
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)resource.getDomain().getId());
                V1Service service = k8sFactory.coreV1Api.readNamespacedService("svc-resource-master", resource.getGuid(), null, null, null);
                List ports = service.getSpec().getPorts();
                for (V1ServicePort port : ports) {
                    if (!"jupyter".equals(port.getName())) continue;
                    res.setJupyter(port.getNodePort());
                    break;
                }
                res.setPassword(EncodeUtil.rawInput((String)resource.getPassword()));
            }
            catch (ApiException e) {
                logger.error(e.getResponseBody(), (Throwable)e);
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u56de\u6536\u8d44\u6e90")
    @Transactional
    @PutMapping(value={"api/project/{id}/reclaim"})
    public ResultResponse reclaim(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id) throws ApiException {
        List durations;
        List expansions;
        List materials;
        ResultResponse res = new ResultResponse();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            return res;
        }
        Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        AppsV1Api appsV1Api = FactoryCollection.k8sFactory((Long)resource.getDomain().getId()).appsV1Api;
        V1Patch array = new V1Patch("[{\"op\": \"replace\", \"path\": \"/spec/replicas\",\"value\": 0}]");
        try {
            appsV1Api.patchNamespacedDeployment("deploy-resource", resource.getGuid(), array, null, null, null, null);
            appsV1Api.patchNamespacedStatefulSet("mnist-horovod", resource.getGuid(), array, null, null, null, null);
        }
        catch (ApiException e) {
            logger.info(e.getResponseBody());
        }
        resource.setStatus(Integer.valueOf(3));
        resource.setErrorMessage(null);
        Date now = new Date();
        resource.setReclaimedAt(now);
        if (resource.getPackageType() == 1 && null != (materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0))) && !materials.isEmpty()) {
            for (Materials material : materials) {
                material.setLastedAt(now);
                material.setOperation(null);
            }
        }
        if ((expansions = resource.getExpansions()) != null) {
            for (ResourceExpansion expansion : expansions) {
                if (expansion.getStatus() == null || expansion.getStatus() != 0) continue;
                expansion.setStatus(Integer.valueOf(-1));
            }
        }
        if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(resource.getId(), Integer.valueOf(0))) != null) {
            for (ReferDuration duration : durations) {
                duration.setEnd(now);
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5de5\u4f5c\u533a\u4fdd\u5b58")
    @Transactional
    @PostMapping(value={"/api/project/workspace"})
    public ResultResponse saveWorkspace(@RequestBody @Valid SaveJupyterRequest dto) {
        ResultResponse res = new ResultResponse();
        MLabProject project = (MLabProject)this.mLabProjectRepository.findOne((Serializable)dto.getId());
        if (null == project) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        if (!com.mopaas.server.common.StringUtils.isEmpty((String)dto.getText())) {
            Date now = new Date();
            if (null == project.getMLabText()) {
                MLabText text = new MLabText();
                text.setTextContent(dto.getText());
                text.setDeleted(Integer.valueOf(0));
                text.setGuid(UUID.randomUUID().toString().replace("-", ""));
                text.setCreatedAt(now);
                text.setUpdatedAt(now);
                this.mLabTextRepository.save((Object)text);
                project.setMLabText(text);
            } else {
                project.getMLabText().setTextContent(dto.getText());
                project.getMLabText().setUpdatedAt(now);
            }
        } else {
            project.setMLabText(null);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4fdd\u5b58\u7248\u672c")
    @Transactional
    @PostMapping(value={"/api/project/notebook"})
    public ResultResponse saveNotebook(@RequestBody @Valid SaveJupyterRequest dto) {
        ResultResponse res = new ResultResponse();
        Date date = new Date();
        MLabProject project = (MLabProject)this.mLabProjectRepository.findOne((Serializable)dto.getId());
        if (null == project) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        MLabNotebook oldJupyter = this.mLabNotebookRepository.findTopByMLabProjectOrderByCreatedAtDesc(project);
        MLabNotebook notebook = new MLabNotebook();
        notebook.setGuid(UUID.randomUUID().toString().replace("-", ""));
        notebook.setNVersion(Long.valueOf(null == oldJupyter ? 1L : oldJupyter.getNVersion() + 1L));
        notebook.setCreatedAt(date);
        notebook.setUpdatedAt(date);
        notebook.setCreator(project.getUser().getUsername());
        notebook.setUpdater(project.getUser().getUsername());
        notebook.setMLabProject(project);
        notebook.setDeleted(Integer.valueOf(0));
        if (!com.mopaas.server.common.StringUtils.isEmpty((String)dto.getText())) {
            MLabText text = new MLabText();
            text.setTextContent(dto.getText());
            text.setDeleted(Integer.valueOf(0));
            text.setGuid(UUID.randomUUID().toString().replace("-", ""));
            this.mLabTextRepository.save((Object)text);
            notebook.setMLabText(text);
        } else {
            notebook.setMLabText(null);
        }
        this.mLabNotebookRepository.save((Object)notebook);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7248\u672c\u5217\u8868")
    @Transactional
    @PostMapping(value={"/api/project/notebook/list"})
    public ListResultResponse<MLabNotebookModel> listNotebook(@RequestBody @Valid MLabNotebookPageRequest dto, HttpServletRequest request) {
        int pagesize;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            return res;
        }
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)dto.getProjectId());
        if (null == mLabProject || mLabProject.getDeleted() == 1) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"nVersion"});
        int currentPage = com.mopaas.server.common.StringUtils.isEmpty((String)(dto.getPage() + "")) ? 1 : dto.getPage();
        int n = pagesize = com.mopaas.server.common.StringUtils.isEmpty((String)(dto.getSize() + "")) ? 10 : dto.getSize();
        if (currentPage < 1) {
            currentPage = 1;
        }
        PageRequest pageable = new PageRequest(currentPage - 1, pagesize, sort);
        Specification spec = (root, query, cb) -> {
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.equal((Expression)root.get("deleted"), (Object)0));
            lstPredicates.add(cb.equal((Expression)root.get("mLabProject"), (Object)mLabProject));
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        };
        Page page = this.mLabNotebookRepository.findAll(spec, (Pageable)pageable);
        List mLabNotebooks = page.getContent();
        ArrayList<MLabNotebookModel> list = new ArrayList<MLabNotebookModel>();
        for (MLabNotebook notebook : mLabNotebooks) {
            MLabNotebookModel model = new MLabNotebookModel();
            model.setGuid(notebook.getGuid());
            model.setId(notebook.getId());
            model.setVersion(notebook.getNVersion());
            model.setCreatedAt(notebook.getCreatedAt());
            model.setUpdatedAt(notebook.getUpdatedAt());
            list.add(model);
        }
        res.setList(list);
        res.setSize(Long.valueOf(page.getTotalElements()));
        res.setPages(Integer.valueOf(page.getTotalPages()));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7248\u672c\u8be6\u60c5")
    @Transactional
    @GetMapping(value={"/api/anon/project/notebook/{id}"})
    public MLabNotebookModel getNotebookDetail(@ApiParam(value="\u7248\u672cid") @PathVariable(value="id") Long id) {
        MLabNotebookModel res = new MLabNotebookModel();
        MLabNotebook notebook = (MLabNotebook)this.mLabNotebookRepository.findOne((Serializable)id);
        if (null == notebook) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.notebook.version.not.exist"));
            return res;
        }
        res.setGuid(notebook.getGuid());
        res.setId(notebook.getId());
        res.setText(notebook.getMLabText().getTextContent());
        res.setSize(SizeConverter.BTrim.convert((float)res.getText().length()) + "");
        res.setCreatedAt(notebook.getCreatedAt());
        res.setUpdatedAt(notebook.getUpdatedAt());
        res.setVersion(notebook.getNVersion());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5de5\u4f5c\u533a\u5185\u5bb9")
    @Transactional
    @GetMapping(value={"/api/project/{id}/workspace"})
    public MLabWorkspaceResponse getWorkspace(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id) {
        MLabWorkspaceResponse res = new MLabWorkspaceResponse();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        if (null != mLabProject.getMLabText()) {
            res.setText(mLabProject.getMLabText().getTextContent());
            res.setSize(SizeConverter.BTrim.convert((float)res.getText().length()) + "");
            res.setUpdatedAt(mLabProject.getMLabText().getUpdatedAt());
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7248\u672c\u5bf9\u6bd4")
    @Transactional
    @PostMapping(value={"/api/project/notebook/compare"})
    public CompareJupyterResponse compareNotebook(@RequestBody @Valid CompareJupyterRequest dto) {
        CompareJupyterResponse res = new CompareJupyterResponse();
        MLabNotebook oldjupyter = (MLabNotebook)this.mLabNotebookRepository.findOne((Serializable)dto.getOldNotebookId());
        if (null == oldjupyter) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.notebook.version.not.exist"));
            return res;
        }
        MLabNotebook newjupyter = (MLabNotebook)this.mLabNotebookRepository.findOne((Serializable)dto.getNewNotebookId());
        if (null == newjupyter) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.notebook.version.not.exist"));
            return res;
        }
        if (oldjupyter.getId() > newjupyter.getId()) {
            oldjupyter = (MLabNotebook)this.mLabNotebookRepository.findOne((Serializable)dto.getNewNotebookId());
            newjupyter = (MLabNotebook)this.mLabNotebookRepository.findOne((Serializable)dto.getOldNotebookId());
        }
        ArrayList list = new ArrayList();
        try {
            Iterator olditer;
            JSONArray oldjson = JSONObject.fromObject((Object)oldjupyter.getMLabText().getTextContent()).getJSONArray("cells");
            JSONArray newjson = JSONObject.fromObject((Object)newjupyter.getMLabText().getTextContent()).getJSONArray("cells");
            Iterator newiter = newjson.iterator();
            int i = 0;
            while (newiter.hasNext()) {
                JSONObject cell = JSONObject.fromObject(newiter.next());
                HashMap<String, String> tmp = new HashMap<String, String>();
                tmp.put("cell_type", cell.getString("cell_type"));
                tmp.put("old", "");
                tmp.put("new", cell.getString("source"));
                olditer = oldjson.iterator();
                while (olditer.hasNext()) {
                    JSONObject oldcell = JSONObject.fromObject(olditer.next());
                    if (cell.getString("id") != null && oldcell.getString("id") != null && cell.getString("id").replaceAll("-", "").substring(0, 32).equals(oldcell.getString("id").replaceAll("-", "").substring(0, 32))) {
                        tmp.put("old", oldcell.getString("source"));
                        olditer.remove();
                        i = 1;
                        break;
                    }
                    if (i <= 0) continue;
                    for (Object o : newjson) {
                        JSONObject newcell1 = JSONObject.fromObject(o);
                        if (!oldcell.getString("id").replace("-", "").substring(0, 32).equals(newcell1.getString("id").replace("-", "").substring(0, 32))) continue;
                        i = 0;
                        break;
                    }
                    if (i <= 0) continue;
                    HashMap<String, String> tmp1 = new HashMap<String, String>();
                    tmp1.put("cell_type", oldcell.getString("cell_type"));
                    tmp1.put("old", oldcell.getString("source"));
                    tmp1.put("new", "");
                    list.add(tmp1);
                    olditer.remove();
                }
                if (((String)tmp.get("old")).equals(tmp.get("new"))) {
                    tmp.put("old", null);
                }
                list.add(tmp);
            }
            olditer = oldjson.iterator();
            while (olditer.hasNext()) {
                JSONObject oldcell = JSONObject.fromObject(olditer.next());
                HashMap<String, String> tmp1 = new HashMap<String, String>();
                tmp1.put("cell_type", oldcell.getString("cell_type"));
                tmp1.put("old", oldcell.getString("source"));
                tmp1.put("new", "");
                list.add(tmp1);
            }
            res.setList(list);
            res.setOldVersion(oldjupyter.getNVersion());
            res.setNewVersion(newjupyter.getNVersion());
        }
        catch (Exception e) {
            logger.error("jupyterCompare error=" + e, (Throwable)e);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7248\u672c\u6062\u590d")
    @Transactional
    @PostMapping(value={"/api/project/notebook/recover"})
    public ResultResponse recoverNotebook(@RequestBody @Valid RecoverJupyterRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)dto.getProjectId());
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        MLabNotebook notebook = (MLabNotebook)this.mLabNotebookRepository.findOne((Serializable)dto.getNotebookId());
        if (null == notebook) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.notebook.version.not.exist"));
            return res;
        }
        String notebookText = null;
        if (notebook.getMLabText() != null) {
            notebookText = notebook.getMLabText().getTextContent();
        }
        if (null != mLabProject.getMLabText()) {
            mLabProject.getMLabText().setTextContent(notebookText);
        } else {
            MLabText text = new MLabText();
            text.setTextContent(notebookText);
            text.setDeleted(Integer.valueOf(0));
            text.setGuid(UUID.randomUUID().toString().replace("-", ""));
            text.setCreatedAt(new Date());
            this.mLabTextRepository.save((Object)text);
            mLabProject.setMLabText(text);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4f7f\u7528\u65f6\u957f")
    @Transactional
    @PostMapping(value={"/api/project/{id}/time"})
    public ResourceTimeResponse getYlwJupyterResourceTime(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id) {
        ResourceTimeResponse res = new ResourceTimeResponse();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(mLabProject, Integer.valueOf(0));
        if (null == resource) {
            return res;
        }
        Domain domain = resource.getDomain();
        OrgConfigDepartment dep = resource.getDepartment();
        User user = resource.getUser();
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domain.getId());
        Double totalTimes = -1.0;
        if (depQuotas != null && depUsers != null && depUsers.getType() == 3) {
            totalTimes = depQuotas.getResourceTime();
        }
        DecimalFormat df = new DecimalFormat("0.00");
        if (totalTimes != -1.0) {
            Long usedSeconds = this.referDurationRepository.calculateByReferTypeAndReferenceAndDepAndDomain(Integer.valueOf(0), resource.getId(), resource.getDepartment().getId(), domain.getId(), Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
            if (usedSeconds == null) {
                usedSeconds = 0L;
            }
            Double usedTimes = Double.valueOf(df.format(Double.valueOf(usedSeconds.longValue()) / 3600.0));
            res.setTotalTimes(totalTimes);
            res.setUsedTimes(Double.valueOf(Math.min(usedTimes, totalTimes)));
        } else {
            Long usedSeconds = this.referDurationRepository.calculateByReferTypeAndReferenceAndDepAndDomain(Integer.valueOf(0), resource.getId(), resource.getDepartment().getId(), domain.getId(), Long.valueOf(dep.getCreatedAt().getTime() / 1000L));
            if (usedSeconds == null) {
                usedSeconds = 0L;
            }
            Double usedTimes = Double.valueOf(df.format(Double.valueOf(usedSeconds.longValue()) / 3600.0));
            res.setTotalTimes(Double.valueOf(-1.0));
            res.setUsedTimes(usedTimes);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4e0b\u8f7dnotebook\uff08\u9ed8\u8ba4\u5185\u5bb9\uff09")
    @Transactional
    @GetMapping(value={"/api/project/{id}/notebook/download"})
    public MLabNotebookModel downloadNotebookDefault(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletResponse response) {
        MLabNotebookModel res = new MLabNotebookModel();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        MLabText mLabText = mLabProject.getMLabText();
        String fileName = "Notebook.ipynb";
        if (null != mLabText && !mLabText.getTextContent().isEmpty()) {
            OutputStream out = null;
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
                response.setContentType("text/plain");
                response.setHeader("Content-disposition", "attachment;filename=" + fileName);
                out = response.getOutputStream();
                out.write(mLabText.getTextContent().getBytes(StandardCharsets.UTF_8));
                out.flush();
                out.close();
            }
            catch (IOException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (null != out) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            mLabText = (MLabText)this.mLabTextRepository.findOne((Serializable)Long.valueOf(1L));
            OutputStream out = null;
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
                response.setContentType("text/plain");
                response.setHeader("Content-disposition", "attachment;filename=" + fileName);
                out = response.getOutputStream();
                out.write(mLabText.getTextContent().getBytes(StandardCharsets.UTF_8));
                out.flush();
                out.close();
            }
            catch (IOException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (null != out) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6570\u636e\u96c6\u5173\u8054\u9879\u76ee\u5217\u8868")
    @Transactional
    @GetMapping(value={"/api/storage/{id}/projects"})
    public ListResultResponse<MLabStorageProjectModel> list(@ApiParam(value="\u6570\u636e\u96c6id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            return res;
        }
        Storage storage = (Storage)this.storageRepository.findOne((Serializable)id);
        if (null == storage) {
            return res;
        }
        List mLabProjectList = storage.getMLabProjects();
        if (null != mLabProjectList && mLabProjectList.size() > 0) {
            res.setSize(Long.valueOf(mLabProjectList.size()));
            ArrayList<MLabStorageProjectModel> models = new ArrayList<MLabStorageProjectModel>(mLabProjectList.size());
            for (MLabProject mLabProject : mLabProjectList) {
                MLabStorageProjectModel model = new MLabStorageProjectModel();
                model.setId(mLabProject.getId());
                model.setGuid(mLabProject.getGuid());
                model.setName(mLabProject.getName());
                model.setRemark(mLabProject.getRemark());
                model.setType(mLabProject.getType());
                model.setStatus(mLabProject.getStatus());
                model.setUserId(mLabProject.getUser().getId());
                model.setUsername(mLabProject.getUser().getUsername());
                model.setFullName(mLabProject.getUser().getName() == null ? mLabProject.getUser().getUsername() : mLabProject.getUser().getName());
                model.setCreatedAt(mLabProject.getCreatedAt());
                MLabProjectStorage ps = this.mLabProjectStorageRepository.findByMLabProjectAndStorage(mLabProject, storage);
                model.setMountAt(ps.getCreatedAt());
                models.add(model);
            }
            models.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="fork\u8bb0\u5f55")
    @Transactional
    @RequestMapping(value={"/api/project/{id}/fork/list"}, method={RequestMethod.GET})
    public ListResultResponse<ForkLogModel> listFork(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id) {
        ListResultResponse res = new ListResultResponse();
        MLabProject mLabProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLabProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        ArrayList<ForkLogModel> list = new ArrayList<ForkLogModel>();
        List forks = this.mLabProjectForkRepository.findByOriginId(id);
        if (null != forks && !forks.isEmpty()) {
            for (MLabProjectFork f : forks) {
                ForkLogModel model = new ForkLogModel();
                model.setId(f.getMLabProject().getId());
                model.setProjectName(f.getName());
                model.setCreatedAt(f.getCreatedAt());
                model.setUsername(f.getMLabProject().getUser().getUsername());
                model.setFullName(f.getMLabProject().getUser().getName() == null ? f.getMLabProject().getUser().getUsername() : f.getMLabProject().getUser().getName());
                model.setDeleted(f.getMLabProject().getDeleted());
                list.add(model);
            }
            list.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
            res.setList(list);
        }
        return res;
    }

    @ApiOperation(value="notebook")
    @Transactional
    @RequestMapping(value={"/api/project/{id}/notebook"}, method={RequestMethod.GET})
    public NotebookResponse notebook(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        NotebookResponse res = new NotebookResponse();
        String JAVA_URL = String.valueOf(request.getRequestURL()).replace(request.getRequestURI(), "");
        String url = this.EXPRESS_URL + "/page";
        String inputParam = "url=" + JAVA_URL + "/api/anon/project/notebook/" + id;
        try {
            String notebook = HttpClientUtils.getByHttp((String)url, (String)inputParam);
            res.setNotebook(notebook);
        }
        catch (Exception e) {
            logger.error("get notebook " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u65b0\u5efa\u76ee\u5f55")
    @Transactional
    @RequestMapping(value={"/api/codelib/create"}, method={RequestMethod.POST})
    public ResultResponse createFile(@Valid @RequestBody CodelibFileCreateRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        MLabCodelibFile mLabCodelibFile = this.mLabCodelibFileRepository.findByNameAndUserAndDeletedAndDomainOrderById(dto.getName(), user, Integer.valueOf(0), domain);
        if (null != mLabCodelibFile) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.file.name.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        mLabCodelibFile = new MLabCodelibFile();
        mLabCodelibFile.setDeleted(Integer.valueOf(0));
        mLabCodelibFile.setGuid(UUID.randomUUID().toString().replace("-", ""));
        mLabCodelibFile.setName(dto.getName());
        mLabCodelibFile.setUser(user);
        mLabCodelibFile.setDomain(domain);
        this.mLabCodelibFileRepository.save((Object)mLabCodelibFile);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u6587\u4ef6\u5939\u91cd\u547d\u540d")
    @Transactional
    @RequestMapping(value={"/api/codelib/file/rename"}, method={RequestMethod.PUT})
    public ResourceStatusResponse editFile(@RequestBody @Valid EditCodeFileRequest dto, HttpServletRequest request) {
        ResourceStatusResponse res = new ResourceStatusResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        MLabCodelibFile mLabCodelibFile = (MLabCodelibFile)this.mLabCodelibFileRepository.findOne((Serializable)dto.getId());
        if (null == mLabCodelibFile) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.file.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer count = this.mLabCodelibFileRepository.countByNameAndUserAndDomainAndDeletedAndIdNot(dto.getName(), user, domain, Integer.valueOf(0), dto.getId());
        if (count > 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.file.name.exist"));
            return res;
        }
        mLabCodelibFile.setName(dto.getName());
        mLabCodelibFile.setUpdatedAt(new Date());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u6536\u85cf")
    @Transactional
    @RequestMapping(value={"/api/codelib/collect"}, method={RequestMethod.POST})
    public ResultResponse collectCodelib(@Valid @RequestBody CodelibNewRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        MLabCodelibFile mLabCodelibFile = this.mLabCodelibFileRepository.findByNameAndUserAndDeletedAndDomainOrderById(dto.getFileName(), user, Integer.valueOf(0), domain);
        if (null == mLabCodelibFile || mLabCodelibFile.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.file.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabCodelibText mLabCodelibText = this.mLabCodelibTextRepository.findByNameAndMlabCodelibFileAndDeleted(dto.getCodeName(), mLabCodelibFile, Integer.valueOf(0));
        if (null != mLabCodelibText) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.code.name.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        mLabCodelibText = new MLabCodelibText();
        mLabCodelibText.setDeleted(Integer.valueOf(0));
        mLabCodelibText.setGuid(UUID.randomUUID().toString().replace("-", ""));
        mLabCodelibText.setName(dto.getCodeName());
        mLabCodelibText.setTextContent(dto.getText());
        mLabCodelibText.setMlabCodelibFile(mLabCodelibFile);
        this.mLabCodelibTextRepository.save((Object)mLabCodelibText);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u6536\u85cf-\u6587\u4ef6\u5939\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/codelib/collect/files"}, method={RequestMethod.GET})
    public ListResultResponse<CodeFileListModel> listCollectFile(HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        List mLabCodelibFiles = this.mLabCodelibFileRepository.findByUserAndDeletedAndDomainOrderById(user, Integer.valueOf(0), domain);
        ArrayList<CodeFileListModel> list = new ArrayList<CodeFileListModel>();
        if (null != mLabCodelibFiles && !mLabCodelibFiles.isEmpty()) {
            for (MLabCodelibFile file : mLabCodelibFiles) {
                CodeFileListModel model = new CodeFileListModel();
                model.setId(file.getId());
                model.setName(file.getName());
                list.add(model);
            }
            res.setList(list);
        }
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/codelib/list"}, method={RequestMethod.GET})
    public ListResultResponse<CodeFileModel> list(HttpServletRequest request) throws ApiException {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        ArrayList<CodeFileModel> list = new ArrayList<CodeFileModel>();
        List mLabCodelibFiles = this.mLabCodelibFileRepository.findByUserAndDeletedAndDomainOrderById(user, Integer.valueOf(0), domain);
        if (null != mLabCodelibFiles && !mLabCodelibFiles.isEmpty()) {
            for (MLabCodelibFile file : mLabCodelibFiles) {
                CodeFileModel fileModel = new CodeFileModel();
                fileModel.setId(file.getId());
                fileModel.setName(file.getName());
                fileModel.setCreatedAt(file.getCreatedAt());
                fileModel.setUpdatedAt(file.getUpdatedAt());
                ArrayList<CodeTextModel> codeTextModelList = new ArrayList<CodeTextModel>();
                List texts = file.getMLabCodelibTexts();
                if (null != texts && !texts.isEmpty()) {
                    for (MLabCodelibText text : texts) {
                        CodeTextModel textModel = new CodeTextModel();
                        textModel.setId(text.getId());
                        textModel.setName(text.getName());
                        textModel.setTextContent(text.getTextContent());
                        textModel.setCreatedAt(text.getCreatedAt());
                        textModel.setUpdatedAt(text.getUpdatedAt());
                        codeTextModelList.add(textModel);
                    }
                    fileModel.setCodeTextModels(codeTextModelList);
                }
                list.add(fileModel);
            }
        }
        res.setList(list);
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u5220\u9664\u4ee3\u7801\u7247\u6bb5")
    @Transactional
    @RequestMapping(value={"/api/codelib/code/{id}"}, method={RequestMethod.DELETE})
    public ResultResponse deleteCode(@ApiParam(value="\u4ee3\u7801\u7247\u6bb5id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabCodelibText text = (MLabCodelibText)this.mLabCodelibTextRepository.findOne((Serializable)id);
        if (null == text || text.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.code.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        text.setDeleted(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u5220\u9664\u6587\u4ef6\u5939")
    @Transactional
    @RequestMapping(value={"/api/codelib/file/{id}"}, method={RequestMethod.DELETE})
    public ResultResponse deleteFile(@ApiParam(value="\u6587\u4ef6\u5939id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabCodelibFile file = (MLabCodelibFile)this.mLabCodelibFileRepository.findOne((Serializable)id);
        if (null == file || file.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.file.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List texts = file.getMLabCodelibTexts();
        if (null != texts && !texts.isEmpty()) {
            for (MLabCodelibText text : texts) {
                text.setDeleted(Integer.valueOf(1));
            }
        }
        file.setDeleted(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4ee3\u7801\u5e2e\u52a9-\u7f16\u8f91\u4ee3\u7801")
    @Transactional
    @RequestMapping(value={"/api/codelib/code/edit"}, method={RequestMethod.PUT})
    public ResourceStatusResponse editCode(@RequestBody @Valid CodelibEditRequest dto, HttpServletRequest request) {
        ResourceStatusResponse res = new ResourceStatusResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        MLabCodelibText mLabCodelibText = (MLabCodelibText)this.mLabCodelibTextRepository.findOne((Serializable)dto.getId());
        if (null == mLabCodelibText || mLabCodelibText.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.code.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabCodelibFile mLabCodelibFile = this.mLabCodelibFileRepository.findByNameAndUserAndDeletedAndDomainOrderById(dto.getFileName(), user, Integer.valueOf(0), domain);
        if (null == mLabCodelibFile || mLabCodelibFile.getDeleted() == 1) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.file.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer count = this.mLabCodelibTextRepository.countByNameAndMlabCodelibFileAndDeletedAndIdNot(dto.getCodeName(), mLabCodelibFile, Integer.valueOf(0), dto.getId());
        if (count > 0) {
            res.setMessage(this.messageUtil.getMessage("msg.project.codelib.code.name.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        mLabCodelibText.setName(dto.getCodeName());
        mLabCodelibText.setTextContent(dto.getText());
        mLabCodelibText.setMlabCodelibFile(mLabCodelibFile);
        mLabCodelibText.setUpdatedAt(new Date());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ConstructorProperties(value={"userRepository", "mLabProjectRepository", "domainRepository", "storageRepository", "resourceRepository", "materialsRepository", "referDurationRepository", "pricePackageRepository", "systemConfigRepository", "balancesRepository", "organizationQuotasRepository", "orgConfigDepartmentRepository", "depUsersRepository", "depQuotasRepository", "storageDeptRepository", "noticeUserService", "expansionRepository", "mLabNotebookRepository", "mLabTextRepository", "mLabProjectStorageRepository", "resourceStorageRepository", "mLabProjectForkRepository", "mLabCodelibFileRepository", "mLabCodelibTextRepository", "storageController", "resourceSnapRepository", "resourceService", "messageUtil", "storageServiceFactory", "k8sEngineRepository", "harborFrameRepoRepository", "harborRepoTagRepository", "commonService"})
    public ProjectController(UserRepository userRepository, MLabProjectRepository mLabProjectRepository, DomainRepository domainRepository, StorageRepository storageRepository, ResourceRepository resourceRepository, MaterialsRepository materialsRepository, ReferDurationRepository referDurationRepository, PricePackageRepository pricePackageRepository, SystemConfigRepository systemConfigRepository, BalancesRepository balancesRepository, OrganizationQuotasRepository organizationQuotasRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DepUsersRepository depUsersRepository, DepQuotasRepository depQuotasRepository, StorageDeptRepository storageDeptRepository, NoticeUserService noticeUserService, ExpansionRepository expansionRepository, MLabNotebookRepository mLabNotebookRepository, MLabTextRepository mLabTextRepository, MLabProjectStorageRepository mLabProjectStorageRepository, ResourceStorageRepository resourceStorageRepository, MLabProjectForkRepository mLabProjectForkRepository, MLabCodelibFileRepository mLabCodelibFileRepository, MLabCodelibTextRepository mLabCodelibTextRepository, StorageController storageController, ResourceSnapRepository resourceSnapRepository, ResourceService resourceService, MessageUtil messageUtil, StorageServiceFactory storageServiceFactory, K8sEngineRepository k8sEngineRepository, HarborFrameRepoRepository harborFrameRepoRepository, HarborRepoTagRepository harborRepoTagRepository, CommonService commonService) {
        this.userRepository = userRepository;
        this.mLabProjectRepository = mLabProjectRepository;
        this.domainRepository = domainRepository;
        this.storageRepository = storageRepository;
        this.resourceRepository = resourceRepository;
        this.materialsRepository = materialsRepository;
        this.referDurationRepository = referDurationRepository;
        this.pricePackageRepository = pricePackageRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.balancesRepository = balancesRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.depUsersRepository = depUsersRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.storageDeptRepository = storageDeptRepository;
        this.noticeUserService = noticeUserService;
        this.expansionRepository = expansionRepository;
        this.mLabNotebookRepository = mLabNotebookRepository;
        this.mLabTextRepository = mLabTextRepository;
        this.mLabProjectStorageRepository = mLabProjectStorageRepository;
        this.resourceStorageRepository = resourceStorageRepository;
        this.mLabProjectForkRepository = mLabProjectForkRepository;
        this.mLabCodelibFileRepository = mLabCodelibFileRepository;
        this.mLabCodelibTextRepository = mLabCodelibTextRepository;
        this.storageController = storageController;
        this.resourceSnapRepository = resourceSnapRepository;
        this.resourceService = resourceService;
        this.messageUtil = messageUtil;
        this.storageServiceFactory = storageServiceFactory;
        this.k8sEngineRepository = k8sEngineRepository;
        this.harborFrameRepoRepository = harborFrameRepoRepository;
        this.harborRepoTagRepository = harborRepoTagRepository;
        this.commonService = commonService;
    }
}

