/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Strings;
import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.DateUtil;
import com.mopaas.server.common.EncodeUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.SerialUtils;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.common.StringUtils;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.controller.ResourceController;
import com.mopaas.server.controller.StorageController;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.ExpansionRepository;
import com.mopaas.server.dao.HarborLabelRepository;
import com.mopaas.server.dao.HarborPlatformImageLogoRepository;
import com.mopaas.server.dao.HarborProjectDeptRepository;
import com.mopaas.server.dao.HarborProjectRepository;
import com.mopaas.server.dao.HarborRepoTagRepository;
import com.mopaas.server.dao.HarborUserRepository;
import com.mopaas.server.dao.K8sEngineRepository;
import com.mopaas.server.dao.K8sEventRepository;
import com.mopaas.server.dao.MLabProjectRepository;
import com.mopaas.server.dao.MLabTextRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.OperationLogRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.PaymentRepository;
import com.mopaas.server.dao.PortRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.PriceRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.ResourceSnapRepository;
import com.mopaas.server.dao.StorageDeptRepository;
import com.mopaas.server.dao.StorageExpansionRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.dto.VolumeMountDto;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.HarborPlatformImageLogo;
import com.mopaas.server.entity.HarborProject;
import com.mopaas.server.entity.HarborRepoTag;
import com.mopaas.server.entity.HarborUser;
import com.mopaas.server.entity.K8sEvent;
import com.mopaas.server.entity.MLabProject;
import com.mopaas.server.entity.MLabText;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.OperationLog;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.Payment;
import com.mopaas.server.entity.Price;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.ReferDuration;
import com.mopaas.server.entity.Resource;
import com.mopaas.server.entity.ResourceExpansion;
import com.mopaas.server.entity.ResourceSnap;
import com.mopaas.server.entity.ResourceStorage;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.StorageDept;
import com.mopaas.server.entity.StorageExpansion;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.User;
import com.mopaas.server.exception.BusinessException;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.HarborFactory;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.harbor.api.ProductsApi;
import com.mopaas.server.harbor.model.DetailedTag;
import com.mopaas.server.harbor.model.Label;
import com.mopaas.server.harbor.model.Project;
import com.mopaas.server.harbor.model.ProjectMember;
import com.mopaas.server.harbor.model.ProjectMemberEntity;
import com.mopaas.server.harbor.model.ProjectMetadata;
import com.mopaas.server.harbor.model.ProjectReq;
import com.mopaas.server.harbor.model.ProjectSummary;
import com.mopaas.server.harbor.model.Repository;
import com.mopaas.server.harbor.model.RepositoryDescription;
import com.mopaas.server.harbor.model.RetagReq;
import com.mopaas.server.harbor.model.UserEntity;
import com.mopaas.server.model.InstantMetricModel;
import com.mopaas.server.model.request.CreateResourceRequest;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.ImageCreateRequest;
import com.mopaas.server.model.request.MetricRequest;
import com.mopaas.server.model.request.PasswordEditRequest;
import com.mopaas.server.model.request.RJSortPageRequest;
import com.mopaas.server.model.request.ResourceSnapPageRequest;
import com.mopaas.server.model.request.ResourceSnapRequest;
import com.mopaas.server.model.request.ResourceSnapSelectRequest;
import com.mopaas.server.model.request.ResourceStorageRequest;
import com.mopaas.server.model.request.ScaleRequest;
import com.mopaas.server.model.request.StorageCapacityRequest;
import com.mopaas.server.model.request.TensorboardRequest;
import com.mopaas.server.model.request.UpdateFrameworkRequest;
import com.mopaas.server.model.response.CephExpandModel;
import com.mopaas.server.model.response.CephModel;
import com.mopaas.server.model.response.DataSetCapacityResponse;
import com.mopaas.server.model.response.DistributedNodeResponse;
import com.mopaas.server.model.response.DomainResourceModel;
import com.mopaas.server.model.response.ExpansionModel;
import com.mopaas.server.model.response.FrameworkModel;
import com.mopaas.server.model.response.GapResponse;
import com.mopaas.server.model.response.GfsModel;
import com.mopaas.server.model.response.ImageCommitResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.MLabInfoResponse;
import com.mopaas.server.model.response.MountModel;
import com.mopaas.server.model.response.NotebookMetricResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.PortModel;
import com.mopaas.server.model.response.RangeMetricModel;
import com.mopaas.server.model.response.ResourceModel;
import com.mopaas.server.model.response.ResourceResponse;
import com.mopaas.server.model.response.ResourceSnapModel;
import com.mopaas.server.model.response.ResourceStorageResponse;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.SysConfigResponse;
import com.mopaas.server.service.AsyncPayService;
import com.mopaas.server.service.CommonService;
import com.mopaas.server.service.NoticeUserService;
import com.mopaas.server.service.ResourceService;
import io.kubernetes.client.Exec;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMapVolumeSource;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateTerminated;
import io.kubernetes.client.openapi.models.V1ContainerStateWaiting;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1EmptyDirVolumeSource;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1HostPathVolumeSource;
import io.kubernetes.client.openapi.models.V1KeyToPath;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimVolumeSource;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodStatus;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.RequestContext;

@Api(tags={"\u8bad\u7ec3\u73af\u5883"})
@RestController
public class ResourceController {
    final UserRepository userRepository;
    final HarborProjectRepository harborProjectRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final SystemConfigRepository systemConfigRepository;
    final ResourceRepository resourceRepository;
    final BalancesRepository balancesRepository;
    final PricePackageRepository pricePackageRepository;
    final StorageRepository storageRepository;
    final StorageDeptRepository storageDeptRepository;
    final MaterialsRepository materialsRepository;
    final PaymentRepository paymentRepository;
    final ExpansionRepository expansionRepository;
    final PortRepository portRepository;
    final PricePackageRepository packageRepository;
    final AsyncPayService payService;
    final NoticeUserService noticeUserService;
    final HarborProjectDeptRepository harborProjectDeptRepository;
    final DepUsersRepository depUsersRepository;
    final DomainRepository domainRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final PriceRepository priceRepository;
    final StorageExpansionRepository storageExpansionRepository;
    final ReferDurationRepository referDurationRepository;
    final DepQuotasRepository depQuotasRepository;
    final ResourceSnapRepository resourceSnapRepository;
    final MessageSource messageSource;
    final MLabProjectRepository mLabProjectRepository;
    final MLabTextRepository mLabTextRepository;
    final StorageController storageController;
    final K8sEventRepository k8sEventRepository;
    final OperationLogRepository operationLogRepository;
    final ResourceService resourceService;
    final StorageServiceFactory storageServiceFactory;
    final MessageUtil messageUtil;
    final K8sEngineRepository k8sEngineRepository;
    final HarborRepoTagRepository harborRepoTagRepository;
    final HarborUserRepository harborUserRepository;
    final HarborLabelRepository harborLabelRepository;
    final HarborFactory harborFactory;
    final CommonService commonService;
    final HarborPlatformImageLogoRepository harborPlatformImageLogoRepository;
    private static final Logger logger = LoggerFactory.getLogger(ResourceController.class);
    private static final String SNAP_REPO = "-snapshot";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    V1Patch array = new V1Patch("[{\"op\": \"replace\", \"path\": \"/spec/replicas\",\"value\": 0}]");
    private static final Map<String, Integer> probe = new HashMap();
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    private static final Map<String, Future<?>> FUTURE_MAP = new HashMap();

    @ApiOperation(value="\u5206\u5e03\u5f0f\u8282\u70b9\u6570")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/distributed/nodes"}, method={RequestMethod.GET})
    public DistributedNodeResponse nodes(HttpServletRequest request) {
        Map configs;
        SystemConfig packageDuration;
        DistributedNodeResponse res = new DistributedNodeResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        SystemConfig system_license = this.systemConfigRepository.findByConfigName("SYSTEM_LICENSE");
        String edition = "1";
        String[] info = SerialUtils.decodeLicense((String)system_license.getConfigValue());
        if (null != info) {
            edition = info[0];
        }
        if ("1".equals(edition)) {
            HashMap<String, String> configs2 = new HashMap<String, String>();
            configs2.put("node_1", "1");
            res.setNodes(configs2.values());
        } else {
            packageDuration = this.systemConfigRepository.findByConfigName("NUMBER_OF_NODES_" + domainId);
            if (null != packageDuration && packageDuration.getConfigValue() != null) {
                configs = (Map)JSON.parseObject((String)packageDuration.getConfigValue(), Map.class);
                res.setNodes(configs.values());
            }
        }
        packageDuration = this.systemConfigRepository.findByConfigName("NUMBER_OF_NODES_JOB_" + domainId);
        if (null != packageDuration && packageDuration.getConfigValue() != null) {
            configs = (Map)JSON.parseObject((String)packageDuration.getConfigValue(), Map.class);
            res.setNodeJobs(configs.values());
        }
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.edit.name")
    @ApiOperation(value="\u4fee\u6539\u73af\u5883\u540d\u79f0")
    @Transactional
    @GetMapping(value={"/api/resource/{id}/{name}"})
    public ResultResponse update(HttpServletRequest request, @PathVariable(value="id") Long id, @PathVariable(value="name") @ApiParam(value="\u73af\u5883\u65b0\u540d\u79f0") String name) {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthenticated", new String[0]);
        }
        Long depId = (Long)session.getAttribute("departmentId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:name", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        Integer count = this.resourceRepository.countByNameAndDeletedAndIdNot(name, Integer.valueOf(0), resource.getId());
        if (count > 0) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.name.exist", new String[0]);
        }
        resource.setName(name);
        MLabProject mLabProject = resource.getMLabProject();
        if (null != mLabProject) {
            mLabProject.setName(name);
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u7528\u6846\u67b6\u5217\u8868(\u516c\u5171\u3001\u81ea\u5efa)-v3.4\u4fee\u6539:\u589e\u52a0\u53c2\u6570frameId")
    @Transactional
    @RequestMapping(value={"api/framework/list/{type}"}, method={RequestMethod.GET})
    public ListResultResponse<FrameworkModel> listFramework(@ApiParam(value="\u6846\u67b6\u7c7b\u578b0:\u5f00\u53d1\u73af\u58831:\u6a21\u578b\u8bad\u7ec3") @PathVariable(value="type") Integer type, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long depId = (Long)session.getAttribute("departmentId");
        Long userId = (Long)session.getAttribute("userId");
        String language = request.getHeader("Accept-Language").startsWith("en") ? "en" : "zh";
        List models = this.harborFrames(domainId, "frame_system", type, language);
        List projects = this.commonService.harborProjects(domainId, depId, userId);
        for (HarborProject project : projects) {
            models.addAll(this.harborFrames(domainId, project.getProjectName(), type, null));
        }
        models.sort(Comparator.comparing(FrameworkModel::getName));
        res.setList((Collection)models);
        return res;
    }

    private List<FrameworkModel> harborFrames(Long domainId, String projectName, Integer type, String language) throws com.mopaas.server.harbor.ApiException {
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        List projects = harborApi.projectsGet(projectName, null, null, null, null);
        ArrayList<FrameworkModel> list = new ArrayList<FrameworkModel>();
        if (null != projects && !projects.isEmpty()) {
            SystemConfig labelDescription;
            List frames = this.commonService.getFrames(domainId);
            List frameConfigs = null;
            if (type == 1 && null != (labelDescription = this.systemConfigRepository.findByConfigName("LABEL_DESCRIPTION")) && !Strings.isNullOrEmpty((String)labelDescription.getConfigValue())) {
                frameConfigs = JSONArray.parseArray((String)labelDescription.getConfigValue(), com.alibaba.fastjson.JSONObject.class);
            }
            String minioUrl = FactoryCollection.minioUrl((Long)domainId);
            for (Project project : projects) {
                List repositories;
                if (!projectName.equals(project.getName()) || null == (repositories = harborApi.repositoriesGet(project.getProjectId(), null, null, null, null, null)) || repositories.isEmpty()) continue;
                for (Repository repository : repositories) {
                    String repo = repository.getName();
                    List tags = harborApi.repositoriesRepoNameTagsGet(repo, null);
                    if (null == tags || tags.isEmpty()) continue;
                    List repoTags = tags.stream().filter(t -> t.getLabels().stream().filter(l -> "active".equals(l.getName()) || type == 0 && "ai-develop".equals(l.getName()) || type == 1 && "ai-job".equals(l.getName())).count() == 2L).collect(Collectors.toList());
                    for (DetailedTag tag : repoTags) {
                        FrameworkModel model = new FrameworkModel();
                        Optional<Label> opt = tag.getLabels().stream().filter(l -> frames.contains(l.getName())).findFirst();
                        if (opt.isPresent()) {
                            Optional<com.alibaba.fastjson.JSONObject> configOpt;
                            Label frame = opt.get();
                            model.setFrameId(frame.getId());
                            model.setFrame(frame.getName());
                            if (null != frameConfigs && (configOpt = frameConfigs.stream().filter(c -> frame.getName().equals(c.get((Object)"label"))).findFirst()).isPresent()) {
                                com.alibaba.fastjson.JSONObject conf = configOpt.get();
                                model.setDescription(conf.getString("description_" + language));
                                model.setCode(conf.getString("code"));
                            }
                        }
                        model.setName(repo.substring(repo.lastIndexOf("/") + 1));
                        model.setTag(tag.getName());
                        Optional<Label> arch = tag.getLabels().stream().filter(e -> "gpu".equals(e.getName()) || "x86".equals(e.getName())).findFirst();
                        model.setArch(arch.map(harborLabel -> "x86".equals(harborLabel.getName()) ? 0 : 1).orElse(2));
                        model.setRepository(repo);
                        model.setCreatedAt(tag.getCreated());
                        model.setRemark(repository.getDescription());
                        model.setType(Integer.valueOf("frame_system".equals(projectName) ? 0 : 1));
                        HarborPlatformImageLogo platformImageLogo = this.harborPlatformImageLogoRepository.findByRepositoryAndDomainAndDeleted(repo, domain, 0);
                        if (null != platformImageLogo) {
                            model.setLogo(minioUrl + platformImageLogo.getLogo());
                        }
                        list.add(model);
                    }
                }
            }
        }
        return list;
    }

    @ApiOperation(value="\u83b7\u53d6\u5957\u9910\u5217\u8868", notes="v3.5\u4fee\u6539\uff0c\u6dfb\u52a0\u7c7b\u578b 4:\u6807\u6ce8")
    @Transactional(readOnly=true)
    @GetMapping(value={"/api/package/{type}/list"})
    public ListResultResponse<PackageInfoModel> listPackage(@ApiParam(value="type: 1\u8bad\u7ec3\u73af\u5883 2\u8bad\u7ec3\u4efb\u52a1 3\u6a21\u578b\u670d\u52a1 4\u6807\u6ce8") @PathVariable(value="type") Integer type, @ApiParam(value="\u6269\u7f29\u5bb9\u65f6\u4f20\u9012\u8d44\u6e90guid") @RequestParam(value="guid", required=false) String guid, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization organization = dep.getOrgConfig().getOrganization();
        List orgPricePackage = type == 4 ? organization.getAnnotationPackage() : (type == 3 ? organization.getModelPricePackage() : (type == 2 ? organization.getJobPricePackage() : organization.getResourcePricePackage()));
        List pricePackages = dep.getPricePackage();
        ArrayList<PricePackage> packages = new ArrayList<PricePackage>();
        if (pricePackages != null && pricePackages.size() > 0) {
            for (PricePackage pack : pricePackages) {
                if (!type.equals(pack.getType()) || !domainId.equals(pack.getDomain().getId()) || packages.contains(pack) || !orgPricePackage.contains(pack)) continue;
                packages.add(pack);
            }
        }
        if (!packages.isEmpty()) {
            com.alibaba.fastjson.JSONObject object = this.commonService.domainResourceFree(domainId, guid);
            List resourceList = (List)object.getObject("resource_list", ArrayList.class);
            SystemConfig resourceAudit = this.systemConfigRepository.findByConfigName("RESOURCE_AUDIT_" + domainId);
            boolean sysCheck = null != resourceAudit && "true".equals(resourceAudit.getConfigValue());
            ArrayList<PackageInfoModel> list = new ArrayList<PackageInfoModel>(packages.size());
            for (PricePackage pack : packages) {
                PackageInfoModel model = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (type == 1 && (sysCheck || pack.getAutoCheck() != 1)) {
                    model.setAutoCheck(Integer.valueOf(0));
                } else {
                    model.setAutoCheck(Integer.valueOf(1));
                }
                if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                    model.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setAvailable(Integer.valueOf(0));
                for (DomainResourceModel d : resourceList) {
                    if (type != 2 && (model.getCpuNum() > d.getCpuNum() || model.getMemoryNum() > d.getMemoryNum()) || (model.getGpuNum() != null && model.getGpuNum() > 0 ? type != 2 && d.getGpuNum() < model.getGpuNum() || "false".equals(d.getGpuShare()) && model.getSlice() != 1 || "true".equals(d.getGpuShare()) && model.getSlice() <= 1 || "vgpu".equals(d.getGpuShare()) && model.getSlice() != 0 || "mig".equals(d.getGpuShare()) && model.getSlice() != -1 || !model.getGpuType().equals(d.getGpuType()) : !"x86".equals(d.getMachine()))) continue;
                    model.setAvailable(Integer.valueOf(1));
                    break;
                }
                list.add(model);
            }
            list.sort(Comparator.comparing(PackageInfoModel::getId).reversed());
            res.setList(list);
        }
        return res;
    }

    @ApiOperation(value="\u5957\u9910\u8d2d\u4e70\u65f6\u957f\u5217\u8868")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/resource/package/duration"}, method={RequestMethod.GET})
    public SysConfigResponse getPackageDuration(HttpServletRequest request) {
        SysConfigResponse res = new SysConfigResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        SystemConfig packageDuration = this.systemConfigRepository.findByConfigName("RESOURCE_CONFIG_" + domainId);
        if (null != packageDuration && packageDuration.getConfigValue() != null) {
            res.setValue(packageDuration.getConfigValue());
        }
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.create.resource")
    @ApiOperation(value="\u65b0\u5efa\u5f00\u53d1\u73af\u5883")
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/resource"})
    public ResultResponse create(@RequestBody @Valid CreateResourceRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException, ApiException, InterruptedException {
        Double balance;
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getName());
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"resource:create", (Long)depId)) {
            throw new MessageCodeException(dto.getName(), null, "msg.account.unauthorized", new String[0]);
        }
        if (dto.getRepository().contains("matlab")) {
            if (dto.getPassword().length() < 6 || dto.getPassword().contains("%")) {
                throw new MessageCodeException(dto.getName(), null, "msg.resource.password.invalid", new String[0]);
            }
            if (Strings.isNullOrEmpty((String)dto.getLicense())) {
                throw new MessageCodeException(dto.getName(), null, "msg.resource.matlab.license.empty", new String[0]);
            }
        }
        if (dto.getReplicas() < 2 && dto.getRepository().contains("horovod")) {
            throw new MessageCodeException(dto.getName(), null, "msg.resource.horovod.replicas", new String[0]);
        }
        PricePackage pack = this.pricePackageRepository.findByIdAndStatusAndDeleted(dto.getPackageId(), Integer.valueOf(1), Integer.valueOf(0));
        if (null == pack) {
            throw new MessageCodeException(dto.getName(), null, "msg.package.not.available", new String[0]);
        }
        Integer count = this.resourceRepository.countByNameAndDepartmentIdAndDeleted(dto.getName(), depId, Integer.valueOf(0));
        if (null != count && count > 0) {
            throw new MessageJsonException(dto.getName(), null, "msg.dep.resource.name.exist.error", new String[]{"msg.type.resource"});
        }
        Long domain_id = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domain_id);
        Organization org = dep.getOrgConfig().getOrganization();
        if (pack.getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance < 0.0)) {
            throw new MessageCodeException(dto.getName(), null, "msg.org.balance.insufficient", new String[0]);
        }
        Integer priority = Optional.ofNullable(user.getResourcePriority()).orElse(0);
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(domain).organization(org).department(dep).user(user).audit(Boolean.valueOf(false)).name(dto.getName()).pack(pack).replica(dto.getReplicas()).priority(priority).operate("create").build();
        this.resourceService.checkOrgQuota(identityDto, org);
        this.resourceService.checkDepQuota(dto.getPackageType(), identityDto);
        this.resourceService.checkCephStorage(identityDto, dto.getCephStorage());
        this.resourceService.checkImage(identityDto, dto.getRepository(), dto.getTag(), domain.getId());
        this.commonService.judgeResource(identityDto);
        List reclaims = this.resourceService.judgeSysResource(identityDto);
        Resource resource = this.resourceService.assembleResource(dto, identityDto);
        res.setGuid(resource.getGuid());
        this.resourceService.checkPort(resource, dto.getPorts());
        this.resourceService.checkStorageMount(dto.getStorages(), resource);
        this.resourceService.assembleBlockStorage(dto.getCephStorage(), resource);
        this.resourceService.assembleProject(resource);
        SystemConfig audit = this.systemConfigRepository.findByConfigName("RESOURCE_AUDIT_" + domain_id);
        if (null != audit && "true".equals(audit.getConfigValue()) || pack.getAutoCheck() != 1) {
            resource.setStatus(Integer.valueOf(0));
            this.noticeUserService.send(Integer.valueOf(0), resource.getName(), user);
            return res;
        }
        if (null != reclaims) {
            this.resourceService.doPreempt(reclaims, FactoryCollection.k8sFactory((Long)domain_id));
        }
        this.resourceService.doCreate(resource);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogAnnotation(type=0, msgExpression="msg.reset.pwd")
    @ApiOperation(value="\u91cd\u7f6e\u73af\u5883\u5bc6\u7801")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/password"})
    public ResultResponse restPwd(@ApiParam(value="\u8d44\u6e90\u73af\u5883id") @PathVariable(value="id") Long id, @Valid @RequestBody PasswordEditRequest dto, HttpServletRequest request) throws ApiException, IOException, InterruptedException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:password", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        String password = dto.getPassword();
        resource.setPassword(EncodeUtil.encodeBase64((byte[])password.getBytes(StandardCharsets.UTF_8)));
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        if (resource.getImage().contains("matlab")) {
            if (password.length() < 6 || password.contains("%")) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.password.invalid", new String[0]);
            }
            AppsV1Api appsV1Api = k8sFactory.appsV1Api;
            V1Deployment deployment = appsV1Api.readNamespacedDeployment("deploy-resource", resource.getGuid(), null, null, null);
            if (null != deployment) {
                List env = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getEnv();
                for (V1EnvVar var : env) {
                    if (!"PASSWORD".equals(var.getName())) continue;
                    var.setValue(password);
                }
                appsV1Api.replaceNamespacedDeployment("deploy-resource", resource.getGuid(), deployment, null, null, null);
                resource.setStatus(Integer.valueOf(5));
                k8sFactory.deletePods(resource.getGuid());
            }
        } else {
            List podList = k8sFactory.listPods(resource.getGuid());
            if (!CollectionUtils.isEmpty((Collection)podList) && "Running".equals(((V1Pod)podList.get(0)).getStatus().getPhase())) {
                String[] cmd = new String[]{"bash", "-c", "export JUPYTER_PWD=\"" + password + "\" && echo root:\"" + password + "\" | chpasswd && start-stop-daemon -K --remove-pidfile -p /var/run/jupyter.pid && start-stop-daemon -SbqmC -p /var/run/jupyter.pid -a $(which jupyter-notebook) -- --config=/etc/jupyter/jupyter_notebook_config.py >> /dev/pts/0 2>&1"};
                Process proc = null;
                for (V1Pod pod : podList) {
                    try {
                        proc = new Exec(k8sFactory.client).exec(pod, cmd, false, false);
                        proc.waitFor();
                    }
                    finally {
                        if (null != proc) {
                            proc.destroy();
                        }
                    }
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.renew.auto")
    @ApiOperation(value="\u5f00\u542f\u6216\u5173\u95ed\u81ea\u52a8\u7eed\u8d39")
    @Transactional
    @RequestMapping(value={"/api/resource/{id}/renew/{flag}"}, method={RequestMethod.PATCH})
    public ResultResponse renewResource(@ApiParam(value="\u8d44\u6e90\u73af\u5883id") @PathVariable(value="id") Long id, @ApiParam(value="0:\u5173\u95ed\u81ea\u52a8\u7eed\u8d39 1:\u5f00\u542f") @PathVariable(value="flag") Integer flag, HttpServletRequest request) {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:renew", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        if (flag != 0 && flag != 1) {
            res.setMessage("flag value [0,1]");
            res.setCode(Constants.SC_MSG);
            return res;
        }
        resource.setRenewal(flag);
        Materials materials = this.materialsRepository.findTopByResourceIdAndTypeOrderByIdDesc(resource.getId(), Integer.valueOf(0));
        resource.setRenewal(flag);
        if (null != materials) {
            materials.setRenewal(flag);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.remove.resource")
    @ApiOperation(value="\u5220\u9664\u73af\u5883")
    @Transactional
    @RequestMapping(value={"/api/resource/remove"}, method={RequestMethod.DELETE})
    public ResultResponse remove(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) throws ApiException, com.mopaas.server.harbor.ApiException {
        Long depId;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        List resources = this.resourceRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        if (null == resources) {
            return res;
        }
        StringBuilder resourceNames = new StringBuilder();
        StringBuilder resourceGuids = new StringBuilder();
        for (Resource resource : resources) {
            resourceNames.append(",").append(resource.getName());
            resourceGuids.append(",").append(resource.getGuid());
        }
        if (resourceNames.length() > 1 && resourceGuids.length() > 1) {
            res.setEntity(resourceNames.substring(1));
            res.setGuid(resourceGuids.substring(1));
        }
        if ((depId = (Long)session.getAttribute("departmentId")) == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        for (Resource resource : resources) {
            List snapList;
            MLabProject mLabProject;
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:delete", (Long)depId)) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
            }
            Date now = new Date();
            List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0));
            if (null != materials) {
                for (Materials material : materials) {
                    material.setLastedAt(now);
                    material.setOperation(null);
                }
            }
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            List storages = resource.getStorages();
            if (null != storages && storages.size() > 0) {
                for (Object rs : storages) {
                    Storage storage = rs.getStorage();
                    if (null == storage.getType() || storage.getType() != 2) continue;
                    try {
                        k8sFactory.coreV1Api.deletePersistentVolume("pv-" + resource.getGuid(), null, null, null, null, null, null);
                    }
                    catch (ApiException e) {
                        logger.info(e.getResponseBody());
                    }
                    List cephMaterials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(storage.getId(), Integer.valueOf(2));
                    if (null != cephMaterials) {
                        for (Materials material : cephMaterials) {
                            material.setLastedAt(now);
                            material.setOperation(null);
                        }
                    }
                    storage.setDeleted(Integer.valueOf(1));
                }
            }
            k8sFactory.deleteNamespace(resource.getGuid());
            resource.setDeleted(Integer.valueOf(1));
            List durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(resource.getId(), Integer.valueOf(0));
            if (durations != null) {
                Object rs;
                rs = durations.iterator();
                while (rs.hasNext()) {
                    ReferDuration duration = (ReferDuration)rs.next();
                    duration.setEnd(now);
                }
            }
            if (null != (mLabProject = resource.getMLabProject()) && mLabProject.getDeleted() == 0) {
                mLabProject.getStorages().clear();
                mLabProject.setDeleted(Integer.valueOf(1));
            }
            if (null == (snapList = this.resourceSnapRepository.findByResourceAndDeletedOrderByIdDesc(resource, Integer.valueOf(0))) || snapList.size() <= 0) continue;
            ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
            for (int i = snapList.size() - 1; i >= 0; --i) {
                ResourceSnap snap = (ResourceSnap)snapList.get(i);
                String repo = snap.getImage().substring(snap.getImage().indexOf("/") + 1, snap.getImage().lastIndexOf(":"));
                try {
                    harborApi.repositoriesRepoNameTagsTagDelete(repo, snap.getImageVersion());
                }
                catch (com.mopaas.server.harbor.ApiException e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                snap.setDeleted(Integer.valueOf(1));
            }
        }
        return res;
    }

    @ApiOperation(value="\u73af\u5883\u8be6\u60c5", notes="v3.5\u4fee\u6539:\u8fd4\u56de\u65b0\u589e\u53c2\u6570logDir,tensorboard,tensorboardState\u53c2\u6570")
    @Transactional
    @GetMapping(value={"/api/resource/{id}"})
    public ResourceResponse resource(@PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        Integer count;
        Date latestCostTime;
        Double money;
        List expansions;
        List storages;
        ResourceResponse res = new ResourceResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        OrgConfigDepartment mmDep = resource.getDepartment();
        DepUsers depOwner = this.depUsersRepository.findByUserAndDepartment(user, mmDep);
        Integer userType = 3;
        if (depOwner != null) {
            userType = depOwner.getType();
        }
        if (!userId.equals(resource.getUser().getId()) && userType == 3) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        BeanUtils.copyProperties((Object)resource, (Object)res);
        res.setStatus(Integer.valueOf(res.getStatus() == -6 ? -9 : res.getStatus()));
        res.setUsername(resource.getUser().getUsername());
        res.setFullName(resource.getUser().getName() == null ? resource.getUser().getUsername() : resource.getUser().getName());
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(resource.getUser(), dep);
        if (depUsers != null) {
            res.setCreatorQuited(Integer.valueOf(0));
        } else {
            res.setCreatorQuited(Integer.valueOf(1));
        }
        res.setGuid(resource.getGuid());
        PricePackage pack = resource.getPack();
        PackageInfoModel model = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
        if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
            model.setGpuType(pack.getGpu().getChargeItem());
        }
        res.setPack(model);
        res.setSeq(resource.getGuid().substring(0, 12));
        ResourceSnap snap = this.resourceSnapRepository.findTopByResourceAndImageAndDeletedOrderByRecoverAtDesc(resource, resource.getImage(), Integer.valueOf(0));
        if (snap != null) {
            res.setRecoverAt(snap.getRecoverAt());
        }
        res.setSnapStatus(resource.getSnapStatus());
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        String address = FactoryCollection.serviceAddr((Long)domainId);
        try {
            V1Service service = k8sFactory.coreV1Api.readNamespacedService("svc-resource-master", resource.getGuid(), null, null, null);
            List ports = service.getSpec().getPorts();
            ArrayList portModels = new ArrayList();
            for (V1ServicePort port : ports) {
                if ("ssh".equals(port.getName())) {
                    res.setSsh("ssh root@" + address + " -p " + port.getNodePort());
                    continue;
                }
                if ("jupyter".equals(port.getName())) {
                    if (resource.getImage().contains("matlab")) {
                        res.setVnc(port.getNodePort());
                        continue;
                    }
                    res.setJupyter(port.getNodePort());
                    continue;
                }
                if (resource.getTensorboardState() == 1 && "tensorboard".equals(port.getName())) {
                    res.setTensorboard(port.getNodePort());
                    continue;
                }
                PortModel portModel = new PortModel();
                portModel.setPort(port.getPort());
                portModel.setName(port.getName());
                portModel.setNodePort(port.getNodePort());
                portModels.add(portModel);
            }
            res.setPorts(portModels);
        }
        catch (ApiException e) {
            logger.info(e.getResponseBody());
        }
        res.setLogDir(resource.getLogDir());
        res.setTensorboardState(resource.getTensorboardState());
        List pods = k8sFactory.listPods(resource.getGuid());
        if (null != pods && !pods.isEmpty()) {
            ArrayList podList = new ArrayList();
            for (V1Pod pod : pods) {
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("podName", pod.getMetadata().getName());
                p.put("ip", pod.getStatus().getPodIP());
                Map label = pod.getMetadata().getLabels();
                if (label.containsKey("master") && "true".equals(label.get("master"))) {
                    p.put("type", "master");
                } else {
                    p.put("type", "node");
                }
                podList.add(p);
            }
            res.setPodList(podList);
        }
        if (null != (storages = resource.getStorages()) && storages.size() > 0) {
            ArrayList<MountModel> mountModels = new ArrayList<MountModel>(storages.size());
            CephModel cephModel = null;
            Price price = this.priceRepository.findByTypeAndDomainId(Integer.valueOf(4), domainId);
            for (ResourceStorage storage : storages) {
                Storage s = storage.getStorage();
                if (s.getType() != null && s.getType() == 2) {
                    cephModel = new CephModel();
                    cephModel.setId(s.getId());
                    cephModel.setName(s.getName());
                    cephModel.setPath(storage.getPath());
                    cephModel.setPrice(price.getPrice());
                    String volumeUsed = this.storageServiceFactory.getVolumeUsed(s, k8sFactory);
                    cephModel.setCapacity(StringUtils.HumanFilesize((long)Long.parseLong(volumeUsed == null ? "0" : volumeUsed)) + "/" + StringUtils.HumanFilesize((long)(s.getCapacity().longValue() * 0x40000000L)));
                    Double payment = this.paymentRepository.sumByResourceIdAndType(s.getId(), Integer.valueOf(2));
                    cephModel.setCost(payment);
                    List expansions2 = s.getExpansions();
                    if (null == expansions2 || expansions2.isEmpty()) continue;
                    ArrayList<CephExpandModel> cephExpandModels = new ArrayList<CephExpandModel>(expansions2.size());
                    for (StorageExpansion expansion : expansions2) {
                        CephExpandModel expandModel = new CephExpandModel();
                        expandModel.setBefore(expansion.getBeforeCapacity());
                        expandModel.setAfter(expansion.getAfterCapacity());
                        expandModel.setState(expansion.getState());
                        expandModel.setWhen(expansion.getCreatedAt());
                        cephExpandModels.add(expandModel);
                    }
                    cephModel.setExpands(cephExpandModels);
                    continue;
                }
                MountModel mountModel = new MountModel();
                mountModel.setId(s.getId());
                mountModel.setName(s.getName());
                mountModel.setPath(storage.getPath());
                mountModel.setGuid(s.getGuid().substring(0, 12));
                mountModels.add(mountModel);
            }
            res.setCephModel(cephModel);
            res.setStorages(mountModels);
        }
        if (null != (expansions = resource.getExpansions()) && expansions.size() > 0) {
            ArrayList<ExpansionModel> expansionModels = new ArrayList<ExpansionModel>(expansions.size());
            for (ResourceExpansion expansion : expansions) {
                ExpansionModel eModel = new ExpansionModel();
                PricePackage old = expansion.getPackOld();
                eModel.setPackageNameBefore(old.getName());
                if (null != old.getGpu()) {
                    eModel.setGpuTypeBefore(old.getGpu().getChargeItem());
                    eModel.setGpuBefore(old.getGpuNum());
                }
                eModel.setCpuBefore(old.getCpuNum());
                eModel.setMenBefore(old.getMemoryNum());
                eModel.setSliceBefore(old.getSlice());
                PricePackage newer = expansion.getPackNew();
                eModel.setPackageNameAfter(newer.getName());
                if (null != newer.getGpu()) {
                    eModel.setGpuTypeAfter(newer.getGpu().getChargeItem());
                    eModel.setGpuAfter(newer.getGpuNum());
                }
                eModel.setCpuAfter(newer.getCpuNum());
                eModel.setMenAfter(newer.getMemoryNum());
                eModel.setSliceAfter(newer.getSlice());
                eModel.setStatus(Integer.valueOf(expansion.getStatus() == null ? -2 : expansion.getStatus()));
                eModel.setUpdatedAt(expansion.getUpdatedAt());
                eModel.setRemark(expansion.getRemark());
                eModel.setInstanceBefore(expansion.getInstanceOld());
                eModel.setInstanceAfter(expansion.getInstanceNew());
                expansionModels.add(eModel);
            }
            res.setExpansions(expansionModels);
        }
        res.setMoney(Double.valueOf((money = this.paymentRepository.sumByResourceIdAndTypeAndUser(resource.getId(), Integer.valueOf(0), resource.getUser())) != null ? money : 0.0));
        Payment lastPay = this.paymentRepository.findTopByMaterialResourceIdAndTypeAndMaterialUserOrderByIdDesc(resource.getId(), Integer.valueOf(0), resource.getUser());
        if (null != lastPay) {
            res.setLatestPay(lastPay.getCreatedAt());
        }
        if (null != (latestCostTime = this.materialsRepository.getLatestCostTimeByResource(resource.getId(), Integer.valueOf(0)))) {
            res.setLastAt(latestCostTime);
        }
        if (pack.getGpuNum() != null && pack.getGpuNum() > 0 && null != (pods = k8sFactory.listPods(resource.getGuid())) && !pods.isEmpty()) {
            ArrayList<String> gpuIds = new ArrayList<String>();
            for (V1Pod pod : pods) {
                String[] gpuUUIDs = k8sFactory.getPodGpuUid(pod);
                if (null == gpuUUIDs) continue;
                for (String uuid : gpuUUIDs) {
                    gpuIds.add(uuid.length() > 6 ? uuid.substring(28) : uuid);
                }
            }
            res.setGpuIds(gpuIds);
        }
        if (null != resource.getMLabProject()) {
            res.setProjectId(resource.getMLabProject().getId());
        }
        res.setImageRemoved(Integer.valueOf(0));
        if (resource.getImage().contains(SNAP_REPO) && (count = this.resourceSnapRepository.countByResourceAndImageAndDeleted(resource, resource.getImage(), Integer.valueOf(0))) == 0) {
            res.setImageRemoved(Integer.valueOf(1));
        }
        return res;
    }

    @ApiOperation(value="\u73af\u5883\u5217\u8868", notes="v3.5\u4fee\u6539:\u8fd4\u56de\u65b0\u589e\u53c2\u6570tensorboard,tensorboardState\u53c2\u6570")
    @Transactional
    @PostMapping(value={"/api/resource/list"})
    public ListResultResponse<ResourceModel> list(@RequestBody @Valid RJSortPageRequest dto, HttpServletRequest request) throws ApiException {
        PageRequest pageable;
        Integer finalLevel;
        1 spec;
        Page page;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (page = this.resourceRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */), (Pageable)(pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"}))))) {
            List resources = page.getContent();
            res.setPages(Integer.valueOf(page.getTotalPages()));
            res.setSize(Long.valueOf(page.getTotalElements()));
            ArrayList<ResourceModel> models = new ArrayList<ResourceModel>(resources.size());
            for (Resource resource : resources) {
                Date latestCostTime;
                DepUsers resourceDepUser;
                Integer count;
                ResourceModel model = new ResourceModel();
                model.setId(resource.getId());
                model.setName(resource.getName());
                model.setImage(resource.getImage());
                model.setStatus(Integer.valueOf(resource.getStatus() == -6 ? -9 : resource.getStatus()));
                model.setCreatedAt(resource.getCreatedAt());
                model.setAuditedAt(resource.getAuditedAt());
                model.setPackageType(resource.getPackageType());
                model.setReclaimedAt(resource.getReclaimedAt());
                model.setStartedAt(resource.getStartedAt());
                model.setSeq(resource.getGuid());
                model.setRemark(resource.getRemark());
                model.setUserId(resource.getUser().getId());
                model.setUsername(resource.getUser().getUsername());
                model.setFullName(resource.getUser().getName() == null ? resource.getUser().getUsername() : resource.getUser().getName());
                model.setReplicas(resource.getReplicas());
                model.setImageRemoved(Integer.valueOf(0));
                if (resource.getImage().contains(SNAP_REPO) && (count = this.resourceSnapRepository.countByResourceAndImageAndDeleted(resource, resource.getImage(), Integer.valueOf(0))) == 0) {
                    model.setImageRemoved(Integer.valueOf(1));
                }
                if ((resourceDepUser = this.depUsersRepository.findByUserAndDepartment(resource.getUser(), dep)) != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                PricePackage pack = resource.getPack();
                PackageInfoModel PackageModel2 = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                    PackageModel2.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setPack(PackageModel2);
                model.setCost(Double.valueOf(pack.getCost() * (double)resource.getReplicas().intValue()));
                if (resource.getPackageType() != null && resource.getPackageType() == 0 && null != (latestCostTime = this.materialsRepository.getLatestCostTimeByResource(resource.getId(), Integer.valueOf(0)))) {
                    model.setLastAt(latestCostTime);
                }
                if (null != resource.getMLabProject()) {
                    model.setProjectId(resource.getMLabProject().getId());
                }
                model.setTensorboardState(resource.getTensorboardState());
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)resource.getDomain().getId());
                String address = FactoryCollection.serviceAddr((Long)resource.getDomain().getId());
                if (resource.getStatus() == 1) {
                    try {
                        V1Service service = k8sFactory.coreV1Api.readNamespacedService("svc-resource-master", resource.getGuid(), null, null, null);
                        List ports = service.getSpec().getPorts();
                        for (V1ServicePort port : ports) {
                            if ("ssh".equals(port.getName())) {
                                model.setSsh("ssh root@" + address + " -p " + port.getNodePort());
                                continue;
                            }
                            if ("jupyter".equals(port.getName())) {
                                if (resource.getImage().contains("matlab")) {
                                    model.setVnc(port.getNodePort());
                                    continue;
                                }
                                model.setJupyter(port.getNodePort());
                                continue;
                            }
                            if (resource.getTensorboardState() != 1 || !"tensorboard".equals(port.getName())) continue;
                            model.setTensorboard(port.getNodePort());
                        }
                        model.setPassword(EncodeUtil.rawInput((String)resource.getPassword()));
                    }
                    catch (ApiException e) {
                        logger.info(e.getResponseBody());
                    }
                }
                String errorMessage = null;
                if (!(resource.getStatus() == 0 || resource.getStatus() == 1 || resource.getStatus() == 2 || resource.getStatus() == 3 || null != (errorMessage = resource.getErrorMessage()) && !errorMessage.isEmpty() || resource.getStatus() != -4 && resource.getStatus() != -3 && resource.getStatus() != -2 && resource.getStatus() != 4 && resource.getStatus() != 5 && resource.getStatus() != 6)) {
                    Specification eventSpec = (root, query, cb) -> {
                        ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
                        lstPredicates.add(cb.equal((Expression)root.get("namespace"), (Object)resource.getGuid()));
                        lstPredicates.add(cb.equal((Expression)root.get("type"), (Object)"Warning"));
                        lstPredicates.add(cb.greaterThanOrEqualTo((Expression)root.get("lastOccurrenceTime"), (Comparable)resource.getUpdatedAt()));
                        Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
                        query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
                        return null;
                    };
                    PageRequest eventPageable = new PageRequest(0, 1, Sort.Direction.DESC, new String[]{"id"});
                    Page eventPage = this.k8sEventRepository.findAll(eventSpec, (Pageable)eventPageable);
                    if (null != eventPage && eventPage.getContent().size() > 0) {
                        K8sEvent event = (K8sEvent)eventPage.getContent().get(0);
                        if (null == event.getPopup() || event.getPopup() == 0) {
                            List v1Pods = k8sFactory.listPods(resource.getGuid());
                            if (!v1Pods.isEmpty()) {
                                OffsetDateTime creationTs = null;
                                String podName = null;
                                for (V1Pod pod : v1Pods) {
                                    OffsetDateTime creationTimestamp = pod.getMetadata().getCreationTimestamp();
                                    if (null != creationTs && !creationTimestamp.isAfter(creationTs)) continue;
                                    creationTs = creationTimestamp;
                                    podName = pod.getMetadata().getName();
                                }
                                if (event.getName().equals(podName)) {
                                    errorMessage = event.getMessage();
                                    event.setPopup(Integer.valueOf(1));
                                } else {
                                    event.setPopup(Integer.valueOf(-1));
                                }
                            } else {
                                event.setPopup(Integer.valueOf(1));
                            }
                        } else if (event.getPopup() == 1) {
                            errorMessage = event.getMessage();
                        }
                    }
                    resource.setErrorMessage(errorMessage);
                }
                if (null != errorMessage && StringUtils.isJson(errorMessage)) {
                    JSONObject jsonObject;
                    String language = "zh";
                    String header = request.getHeader("Accept-Language");
                    if (header.startsWith("en")) {
                        language = "en";
                    }
                    model.setErrorMessage((jsonObject = JSONObject.fromObject((Object)errorMessage)).get(language) != null ? jsonObject.get(language).toString() : jsonObject.toString());
                } else {
                    model.setErrorMessage(errorMessage);
                }
                models.add(model);
            }
            res.setList(models);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.scale.resource")
    @ApiOperation(value="\u5347\u964d\u914d\u7f6e")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/scale"})
    public ResultResponse scale(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @RequestBody @Valid ScaleRequest dto, HttpServletRequest request) throws ApiException {
        Double balance;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        Long userId = (Long)session.getAttribute("userId");
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:capacity", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        if (resource.getImage().contains("horovod") && dto.getInstance() == 1) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.horovod.replicas", new String[0]);
        }
        PricePackage pricePackage = this.pricePackageRepository.findByIdAndStatusAndDeleted(dto.getPack(), Integer.valueOf(1), Integer.valueOf(0));
        if (null == pricePackage) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.package.not.available", new String[0]);
        }
        Organization org = dep.getOrgConfig().getOrganization();
        if (pricePackage.getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance < 0.0)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.org.balance.insufficient", new String[0]);
        }
        if (resource.getPack().getId().equals(pricePackage.getId()) && dto.getInstance().equals(resource.getReplicas())) {
            return res;
        }
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().name(resource.getName()).guid(resource.getGuid()).domain(domain).department(dep).organization(org).priority(resource.getPriority()).pack(resource.getPack()).replica(resource.getReplicas()).user(user).operate("scale").build();
        this.commonService.judgeScaleResource(identityDto, pricePackage, dto.getInstance());
        ResourceExpansion expansion = new ResourceExpansion();
        expansion.setPackNew(pricePackage);
        expansion.setPackOld(resource.getPack());
        expansion.setResource(resource);
        expansion.setStatus(Integer.valueOf(1));
        expansion.setInstanceNew(dto.getInstance());
        expansion.setInstanceOld(Integer.valueOf(resource.getReplicas() == null ? 1 : resource.getReplicas()));
        List reclaims = this.resourceService.judgeSysScaleResource(expansion, identityDto);
        this.expansionRepository.save((Object)expansion);
        SystemConfig audit = this.systemConfigRepository.findByConfigName("RESOURCE_AUDIT_" + domainId);
        if (null != audit && "true".equals(audit.getConfigValue()) || pricePackage.getAutoCheck() != 1) {
            expansion.setStatus(Integer.valueOf(0));
            resource.setStatus(Integer.valueOf(2));
            resource.setErrorMessage(null);
            this.noticeUserService.send(Integer.valueOf(1), resource.getName(), user);
            return res;
        }
        if (null != reclaims) {
            this.resourceService.doPreempt(reclaims, FactoryCollection.k8sFactory((Long)domainId));
        }
        this.resourceService.doScale(resource, expansion);
        resource.setReplicas(expansion.getInstanceNew());
        resource.setPack(expansion.getPackNew());
        if (null != expansion.getRemark()) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(expansion.getRemark());
            return res;
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.reclaim.resource")
    @ApiOperation(value="\u56de\u6536\u73af\u5883")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/reclaim"})
    public ResultResponse reclaim(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:change", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        try {
            this.resourceService.doReclaim(FactoryCollection.k8sFactory((Long)domainId), resource);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.system.error", new String[0]);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.recovery.resource")
    @ApiOperation(value="\u6062\u590d\u73af\u5883")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/recovery"})
    public ResultResponse recovery(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @RequestBody ResourceSnapSelectRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:change", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        Organization org = dep.getOrgConfig().getOrganization();
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(resource.getDomain()).organization(org).department(dep).user(resource.getUser()).name(resource.getName()).guid(resource.getGuid()).pack(resource.getPack()).replica(resource.getReplicas()).priority(resource.getPriority()).operate("recovery").build();
        this.resourceService.doRecovery(resource, identityDto, dto.getId());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.reset.resource")
    @ApiOperation(value="\u91cd\u7f6e\u73af\u5883")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/reset"})
    public ResultResponse reset(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @RequestBody ResourceSnapSelectRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:reset", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        if (null != dto.getId() && dto.getId() != 0L) {
            ResourceSnap snap = (ResourceSnap)this.resourceSnapRepository.findOne((Serializable)dto.getId());
            resource.setImage(snap.getImage());
        } else if (null == dto.getId()) {
            String initialImage = resource.getInitialImage() == null ? resource.getImage() : resource.getInitialImage();
            resource.setImage(initialImage);
        }
        this.resourceService.updateWorkload(resource);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.port.resource")
    @ApiOperation(value="\u5220\u9664\u7aef\u53e3")
    @Transactional
    @DeleteMapping(value={"/api/resource/{id}/port/{port}"})
    public ResultResponse ports(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @ApiParam(value="\u7aef\u53e3\u53f7") @PathVariable(value="port") Integer port, HttpServletRequest request) throws ApiException {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:port", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        String guid = resource.getGuid();
        CoreV1Api coreV1Api = FactoryCollection.k8sFactory((Long)domainId).coreV1Api;
        V1Service service = coreV1Api.readNamespacedService("svc-resource-master", guid, null, null, null);
        List servicePorts = service.getSpec().getPorts();
        int idx = 0;
        boolean find = false;
        for (V1ServicePort servicePort : servicePorts) {
            if (servicePort.getPort().equals(port)) {
                find = true;
                break;
            }
            ++idx;
        }
        if (find) {
            coreV1Api.patchNamespacedService("svc-resource-master", guid, new V1Patch("[{\"op\": \"remove\", \"path\": \"/spec/ports/" + idx + "\"}]"), null, null, null, null);
            this.portRepository.removeByEntityIdAndTypeAndPort(resource.getId(), Integer.valueOf(0), port);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.ports.resource")
    @ApiOperation(value="\u6dfb\u52a0\u7aef\u53e3")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/api/resource/{id}/ports"})
    public ResultResponse ports(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @ApiParam(value="\u5f00\u653e\u7aef\u53e3 key:\u7aef\u53e3\u540d\u79f0(\u82f1\u6587\u5c0f\u5199\u5b57\u6bcd\u6216\u6570\u5b57) value:\u7aef\u53e3\u53f7") @RequestBody Map<String, Integer> ports, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        this.resourceService.checkPort(resource, ports);
        Long depId = (Long)session.getAttribute("departmentId");
        Long userId = (Long)session.getAttribute("userId");
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:port", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        String guid = resource.getGuid();
        CoreV1Api coreV1Api = FactoryCollection.k8sFactory((Long)domainId).coreV1Api;
        V1Service service = coreV1Api.readNamespacedService("svc-resource-master", guid, null, null, null);
        List servicePorts = service.getSpec().getPorts();
        resource.getPorts().stream().filter(p -> servicePorts.stream().noneMatch(sp -> sp.getPort().equals(p.getPort()))).forEach(p -> servicePorts.add(new V1ServicePort().name(p.getName()).port(p.getPort())));
        coreV1Api.replaceNamespacedService("svc-resource-master", guid, service, null, null, null);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.duration.resource")
    @ApiOperation(value="\u624b\u52a8\u7eed\u79df")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/duration/{duration}"})
    public ResultResponse renew(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @ApiParam(value="\u7eed\u79df\u65f6\u957f") @PathVariable(value="duration") String duration, HttpServletRequest request) throws Exception {
        ResultResponse res = new ResultResponse();
        RequestContext context = new RequestContext(request);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:relet", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        if (resource.getPackageType() != 0) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.charge.type.error", new String[0]);
        }
        Materials materials = this.materialsRepository.findTopByResourceIdAndTypeOrderByIdDesc(resource.getId(), Integer.valueOf(0));
        Organization org = dep.getOrgConfig().getOrganization();
        if (null == org.getFree() || org.getFree() != 1) {
            String remark;
            double cost;
            int calendar_type;
            int tmp_package_type;
            Double balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0));
            if (null == balance) {
                balance = 0.0;
            }
            if (resource.getPack().getCost() > 0.0 && balance <= 0.0) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.org.balance.insufficient"));
                return res;
            }
            int count = Integer.parseInt(duration.substring(2));
            if (duration.startsWith("m_")) {
                tmp_package_type = 9;
                calendar_type = 2;
                cost = resource.getPack().getMonthCost() * (double)count;
                remark = context.getMessage("msg.renew") + "-" + count + context.getMessage("msg.month.num");
            } else if (duration.startsWith("y_")) {
                calendar_type = 1;
                tmp_package_type = 8;
                cost = resource.getPack().getYearCost() * (double)count;
                remark = context.getMessage("msg.renew") + "-" + count + context.getMessage("msg.year");
            } else {
                calendar_type = 5;
                tmp_package_type = 10;
                cost = resource.getPack().getCost() * 10080.0 * (double)count;
                remark = context.getMessage("msg.renew") + "-" + count + context.getMessage("msg.week");
                count *= 7;
            }
            cost *= (double)resource.getReplicas().intValue();
            if (balance < cost) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.org.balance.insufficient"));
                return res;
            }
            Payment payment = new Payment();
            payment = this.payService.saveBlance(org, cost, payment);
            payment.setTradeNo(DateUtil.getOrderNum() + new Random().nextInt(99999999));
            payment.setGuid(UUID.randomUUID().toString());
            payment.setResourceStatus(resource.getStatus());
            payment.setMoney(Double.valueOf(cost));
            payment.setPackageType(Integer.valueOf(tmp_package_type));
            payment.setMaterial(materials);
            Calendar date = Calendar.getInstance();
            date.setTime(materials.getCostTime());
            date.add(calendar_type, count);
            Date end = date.getTime();
            payment.setCostTime(DATE_FORMAT.format(materials.getCostTime()) + "~" + DATE_FORMAT.format(end));
            materials.setCostTime(end);
            payment.setRemark(remark);
            payment.setType(materials.getType());
            this.paymentRepository.save((Object)payment);
        } else {
            int calendar_type;
            int count = Integer.parseInt(duration.substring(2));
            if (duration.startsWith("m_")) {
                calendar_type = 2;
            } else if (duration.startsWith("y_")) {
                calendar_type = 1;
            } else {
                calendar_type = 5;
                count *= 7;
            }
            Calendar date = Calendar.getInstance();
            date.setTime(materials.getCostTime());
            date.add(calendar_type, count);
            Date end = date.getTime();
            materials.setCostTime(end);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    private Integer packageType(String duration) {
        if (!Strings.isNullOrEmpty((String)duration)) {
            if (duration.startsWith("w_")) {
                return 3;
            }
            if (duration.startsWith("m_")) {
                return 1;
            }
            if (duration.startsWith("y_")) {
                return 0;
            }
        }
        return 2;
    }

    @ApiOperation(value="\u83b7\u53d6\u6269\u5bb9\u5dee\u989d")
    @Transactional
    @RequestMapping(value={"/api/resource/{id}/package/{pack}/{instance}"}, method={RequestMethod.GET})
    public GapResponse getGap(@ApiParam(value="\u8d44\u6e90\u73af\u5883id") @PathVariable(value="id") Long id, @ApiParam(value="\u5957\u9910id") @PathVariable(value="pack") Long packId, @ApiParam(value="\u5b9e\u4f8b\u6570") @PathVariable(value="instance") Integer instance) throws Exception {
        List materials;
        GapResponse res = new GapResponse();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        PricePackage pack = this.packageRepository.findByIdAndStatusAndDeleted(packId, Integer.valueOf(1), Integer.valueOf(0));
        if (null == pack) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.package.not.available"));
            return res;
        }
        Date now = new Date();
        double gap = 0.0;
        if (!(resource.getPackageType() != 0 || packId.equals(resource.getPack().getId()) && instance.equals(resource.getReplicas()) || (materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0))) == null || materials.size() <= 0)) {
            for (Materials m : materials) {
                Materials material = new Materials();
                material.setDomain(resource.getDomain());
                material.setResourceId(resource.getId());
                material.setUser(m.getUser());
                material.setOrganization(m.getOrganization());
                material.setType(Integer.valueOf(0));
                material.setCreatedAt(now);
                material.setLastedAt(now);
                material.setParentMaterials(m);
                material.setRenewal(resource.getRenewal());
                material.setPack(pack);
                material.setPackageType(m.getPackageType());
                material.setResourceInstance(instance);
                material.setPackageDuration(m.getPackageDuration());
                gap += this.payService.calculate(material).doubleValue();
            }
        }
        res.setGap(Double.valueOf(gap));
        return res;
    }

    @ApiOperation(value="\u65f6\u95f4\u6bb5\u5185\u76d1\u63a7")
    @Transactional
    @PostMapping(value={"api/resource/{id}/metrics"})
    public ListResultResponse<RangeMetricModel> metric(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @RequestBody MetricRequest dto, HttpServletRequest request) throws Exception {
        ListResultResponse res = new ListResultResponse();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        res.setList((Collection)this.commonService.rangeMetric(domainId, resource.getGuid(), dto.getBegin(), dto.getEnd(), resource.getPack().getCpuNum()));
        return res;
    }

    @ApiOperation(value="\u5b9e\u65f6\u76d1\u63a7")
    @Transactional
    @GetMapping(value={"api/resource/{id}/metrics"})
    public ListResultResponse<InstantMetricModel> metric(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List instantMetricModels = k8sFactory.podsInstantMetrics(resource.getGuid(), resource.getPack().getCpuNum());
        res.setList((Collection)instantMetricModels);
        return res;
    }

    @ApiOperation(value="notebook\u76d1\u63a7")
    @Transactional
    @GetMapping(value={"api/notebook/{id}/metrics"})
    public NotebookMetricResponse notebookMetricModel(@PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        V1Pod pod;
        String namespace;
        List podList;
        DepQuotas depQuotas;
        NotebookMetricResponse res = new NotebookMetricResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Resource resource = this.resourceRepository.findByMLabProjectIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        Long userId = (Long)session.getAttribute("userId");
        Long all = this.referDurationRepository.calculateAllByReferTypeAndReferenceAndDepAndDomain(Integer.valueOf(0), resource.getId(), depId, domainId);
        res.setDuration(all);
        res.setTimeRemain(Long.valueOf(-1L));
        DepUsers depUser = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        if (null != depUser && depUser.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentIdAndDomainId(depId, domainId)) && depQuotas.getResourceTime().longValue() != -1L) {
            long remainedTime = depQuotas.getResourceTime().longValue() - all;
            res.setTimeRemain(Long.valueOf(remainedTime > 0L ? remainedTime : 0L));
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        Storage pvs = this.storageRepository.findByUserIdAndGuidAndDomainId(userId, domainId);
        if (pvs != null) {
            String volumeUsed = this.storageServiceFactory.getVolumeUsed(pvs, k8sFactory);
            String pvsSize = SizeConverter.convertBytes((float)Float.parseFloat(volumeUsed == null ? "0" : volumeUsed), (boolean)true);
            res.setPvcUsage(pvsSize + "/2 GB");
        }
        if (null != (podList = k8sFactory.listPods(namespace = resource.getGuid())) && podList.size() > 0 && (pod = (V1Pod)podList.get(0)).getStatus().getContainerStatuses() != null && ((V1ContainerStatus)pod.getStatus().getContainerStatuses().get(0)).getReady().booleanValue()) {
            Map nodeSelector;
            InstantMetricModel model = k8sFactory.podCpuMemoryUsage(pod.getMetadata().getUid(), resource.getPack().getCpuNum());
            res.setCpuUsage(model.getCpuUsage());
            res.setMemUsage(model.getMemUsage());
            String query = "/api/v1/query?query=%s{namespace=\"" + namespace + "\",container=\"resource\"}";
            JSONArray result = k8sFactory.parsePromResult(String.format(query, "container_fs_usage_bytes"));
            if (!result.isEmpty()) {
                String fsUsage = SizeConverter.convertBytes((float)Float.parseFloat(result.getJSONObject(0).getJSONArray("value").getString(1)), (boolean)true);
                result = k8sFactory.parsePromResult(String.format(query, "container_fs_limit_bytes"));
                if (!result.isEmpty()) {
                    String fsLimit = SizeConverter.convertBytes((float)Float.parseFloat(result.getJSONObject(0).getJSONArray("value").getString(1)), (boolean)true);
                    res.setDiskUsage(fsUsage + "/" + fsLimit);
                }
            }
            if ((nodeSelector = pod.getSpec().getNodeSelector()).containsKey("gpu")) {
                res.setGpuUsage(k8sFactory.podGpusMetrics(pod));
            }
        }
        return res;
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void schedule() {
        List resources = this.resourceRepository.findSchedule();
        if (null != resources && resources.size() > 0) {
            for (Resource resource : resources) {
                try {
                    ResourceExpansion expansion;
                    Object m3;
                    Materials material;
                    List cephMaterials;
                    K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)resource.getDomain().getId());
                    String namespace = resource.getGuid();
                    try {
                        V1Deployment deploy = k8sFactory.appsV1Api.readNamespacedDeployment("deploy-resource", namespace, null, null, null);
                        if (deploy.getSpec().getReplicas() == 0) {
                            continue;
                        }
                    }
                    catch (ApiException e) {
                        logger.warn("schedule resource[{}] with exception {}", (Object)resource.getName(), (Object)e.getResponseBody());
                    }
                    List pods = k8sFactory.listPods(namespace);
                    resource.setPods(Integer.valueOf(CollectionUtils.isEmpty((Collection)pods) ? 0 : pods.size()));
                    Date startTime = null;
                    Integer status = resource.getStatus();
                    boolean ready = true;
                    if (!CollectionUtils.isEmpty((Collection)pods)) {
                        block5: for (V1Pod pod : pods) {
                            List containerStatuses;
                            V1PodStatus podStatus = pod.getStatus();
                            if (!"Running".equals(podStatus.getPhase())) {
                                List conditions;
                                ready = false;
                                if ("Pending".equals(podStatus.getPhase()) && status != -9 && status != -6 && null != (conditions = podStatus.getConditions()) && conditions.size() > 0) {
                                    for (V1PodCondition condition : conditions) {
                                        if (!"PodScheduled".equals(condition.getType()) || "True".equals(condition.getStatus())) continue;
                                        probe.put(namespace, probe.getOrDefault(namespace, 0) + 1);
                                        if ((Integer)probe.get(namespace) < 5) break;
                                        probe.remove(namespace);
                                        if (status == 6) {
                                            resource.setStatus(Integer.valueOf(-6));
                                        } else {
                                            resource.setStatus(Integer.valueOf(-9));
                                        }
                                        resource.setErrorMessage(condition.getMessage());
                                        break;
                                    }
                                }
                            }
                            if (CollectionUtils.isEmpty((Collection)(containerStatuses = podStatus.getContainerStatuses()))) continue;
                            for (V1ContainerStatus containerStatus : containerStatuses) {
                                if (!containerStatus.getReady().booleanValue()) {
                                    ready = false;
                                    String message = null;
                                    V1ContainerState state = containerStatus.getState() != null ? containerStatus.getState() : containerStatus.getLastState();
                                    if (state == null) continue block5;
                                    V1ContainerStateWaiting waiting = state.getWaiting();
                                    if (waiting != null) {
                                        message = null != waiting.getMessage() ? waiting.getReason() + ":" + waiting.getMessage() : waiting.getReason();
                                    } else {
                                        V1ContainerStateTerminated terminated = state.getTerminated();
                                        if (terminated != null) {
                                            String string = message = null != terminated.getMessage() ? terminated.getReason() + ":" + terminated.getMessage() : terminated.getReason();
                                        }
                                    }
                                    if (null == message || !message.contains("CrashLoopBackOff") && !message.contains("Error") && !message.contains("ImagePullBackOff")) continue block5;
                                    resource.setErrorMessage(message);
                                    resource.setStatus(Integer.valueOf(-2));
                                    continue block5;
                                }
                                Instant dateTime = containerStatus.getState().getRunning().getStartedAt().toInstant();
                                startTime = Date.from(dateTime);
                            }
                        }
                    } else if (status == 1) {
                        List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0));
                        if (null != materials && !materials.isEmpty()) {
                            Date now = new Date();
                            for (Materials material2 : materials) {
                                material2.setLastedAt(now);
                                material2.setOperation(null);
                            }
                        }
                        resource.setStatus(Integer.valueOf(4));
                        continue;
                    }
                    if (!ready || null == startTime || status == 1) continue;
                    OrgConfigDepartment department = resource.getDepartment();
                    Organization organization = department.getOrgConfig().getOrganization();
                    Storage cephStorage = null;
                    List storages = resource.getStorages();
                    if (null != storages && storages.size() > 0) {
                        for (ResourceStorage rs : storages) {
                            Storage storage = rs.getStorage();
                            if (storage.getType() != 2) continue;
                            cephStorage = storage;
                        }
                    }
                    if (!(null == cephStorage || status != -9 && status != 4 || null != (cephMaterials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(cephStorage.getId(), Integer.valueOf(2))) && !cephMaterials.isEmpty())) {
                        Materials cephMaterial = new Materials();
                        cephMaterial.setUser(cephStorage.getUser());
                        cephMaterial.setDepartment(department);
                        cephMaterial.setOrganization(organization);
                        cephMaterial.setResourceId(cephStorage.getId());
                        cephMaterial.setType(Integer.valueOf(2));
                        cephMaterial.setPackageType(Integer.valueOf(2));
                        cephMaterial.setCreatedAt(startTime);
                        cephMaterial.setCostTime(startTime);
                        cephMaterial.setStorageNum(Double.valueOf(cephStorage.getCapacity().doubleValue()));
                        cephMaterial.setDomain(cephStorage.getDomain());
                        this.materialsRepository.save(cephMaterial);
                        cephStorage.setStatus(Integer.valueOf(1));
                    }
                    User user = resource.getUser();
                    List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0));
                    if (resource.getPackageType() == 0) {
                        if (!(status != -9 && status != 4 && status != 5 || null != materials && !materials.isEmpty())) {
                            material = new Materials();
                            material.setDomain(resource.getDomain());
                            material.setResourceId(resource.getId());
                            material.setUser(user);
                            material.setDepartment(department);
                            material.setOrganization(organization);
                            material.setType(Integer.valueOf(0));
                            material.setCostTime(startTime);
                            material.setCreatedAt(startTime);
                            material.setRenewal(resource.getRenewal());
                            material.setPack(resource.getPack());
                            material.setPackageType(this.packageType(resource.getPackageDuration()));
                            material.setResourceInstance(resource.getReplicas());
                            material.setPackageDuration(Integer.valueOf(resource.getPackageDuration().substring(2)));
                            this.payService.pay(material);
                        }
                        if (status == -6 || status == 6) {
                            Materials material_new = null;
                            if (materials != null && materials.size() > 0) {
                                for (Materials m2 : materials) {
                                    m2.setLastedAt(startTime);
                                    if (null == material_new || material_new.getId() < m2.getId()) {
                                        material_new = m2;
                                    }
                                    Materials material3 = new Materials();
                                    material3.setDomain(resource.getDomain());
                                    material3.setResourceId(resource.getId());
                                    material3.setUser(m2.getUser());
                                    material3.setOrganization(m2.getOrganization());
                                    material3.setDepartment(m2.getDepartment());
                                    material3.setType(Integer.valueOf(0));
                                    material3.setCreatedAt(startTime);
                                    material3.setLastedAt(startTime);
                                    material3.setParentMaterials(m2);
                                    material3.setRenewal(resource.getRenewal());
                                    material3.setPack(resource.getPack());
                                    material3.setPackageType(m2.getPackageType());
                                    material3.setResourceInstance(resource.getReplicas());
                                    material3.setPackageDuration(m2.getPackageDuration());
                                    this.payService.pay(material3);
                                }
                            }
                            if (null != material_new) {
                                material_new = (Materials)BeanMapper.map(material_new, Materials.class);
                                material_new.setLastedAt(null);
                                material_new.setId(null);
                                material_new.setPack(resource.getPack());
                                material_new.setGuid(UUID.randomUUID().toString());
                                material_new.setDepartment(resource.getDepartment());
                                material_new.setResourceInstance(resource.getReplicas());
                                this.materialsRepository.save(material_new);
                            }
                        }
                    } else {
                        if (materials != null && materials.size() > 0) {
                            for (Object m3 : materials) {
                                m3.setLastedAt(startTime);
                            }
                        }
                        material = new Materials();
                        material.setDomain(resource.getDomain());
                        material.setResourceId(resource.getId());
                        material.setUser(user);
                        material.setDepartment(department);
                        material.setOrganization(organization);
                        material.setType(Integer.valueOf(0));
                        material.setCostTime(startTime);
                        material.setCreatedAt(startTime);
                        material.setRenewal(resource.getRenewal());
                        material.setPack(resource.getPack());
                        material.setPackageType(Integer.valueOf(2));
                        material.setResourceInstance(resource.getReplicas());
                        this.materialsRepository.save(material);
                    }
                    if ((status == 6 || status == -4 || status == -6) && null != (expansion = this.expansionRepository.findTopByResourceAndStatusOrderByIdDesc(resource, Integer.valueOf(0)))) {
                        expansion.setStatus(Integer.valueOf(1));
                    }
                    resource.setStartedAt(startTime);
                    resource.setStatus(Integer.valueOf(1));
                    resource.setErrorMessage(null);
                    if (null != resource.getMLabProject()) {
                        MLabProject mLabProject = resource.getMLabProject();
                        mLabProject.setStatus(Integer.valueOf(1));
                    }
                    List list = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(resource.getId(), Integer.valueOf(0));
                    m3 = list.iterator();
                    while (m3.hasNext()) {
                        ReferDuration duration = (ReferDuration)m3.next();
                        duration.setEnd(startTime);
                    }
                    ReferDuration duration = new ReferDuration();
                    duration.setStart(startTime);
                    duration.setReference(resource.getId());
                    duration.setUser(user);
                    duration.setDepartment(resource.getDepartment());
                    duration.setReferType(Integer.valueOf(0));
                    duration.setDomain(resource.getDomain());
                    this.referDurationRepository.save((Object)duration);
                }
                catch (Exception e) {
                    logger.error("schedule", (Throwable)e);
                }
            }
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5757\u5b58\u50a8\u53ef\u5206\u914d\u5bb9\u91cf")
    @Transactional(readOnly=true)
    @RequestMapping(value={"api/rawblock/capacity/remained"}, method={RequestMethod.GET})
    public DataSetCapacityResponse getCapacityRemained(HttpServletRequest request) throws ApiException {
        String p_value;
        DataSetCapacityResponse res = new DataSetCapacityResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        SystemConfig config = this.systemConfigRepository.findByConfigName("STORAGE_TYPE_CONFIG_" + domainId);
        if (config == null || config.getConfigValue() == null || !"1".equals(JSON.parseObject((String)config.getConfigValue()).getString("CEPH"))) {
            res.setCapacity(Long.valueOf(0L));
            res.setPrice(Double.valueOf(0.0));
            return res;
        }
        res.setCapacity(Long.valueOf(0L));
        JSONArray result = FactoryCollection.k8sFactory((Long)domainId).parsePromResult("/api/v1/query?query=ceph_osd_total_bytes");
        if (result.size() > 0 && null != (p_value = result.getJSONObject(0).getJSONArray("value").getString(1))) {
            Integer allocatedQuota = this.storageRepository.sumRbdAllocatedQuota(domainId);
            allocatedQuota = allocatedQuota == null ? 0 : allocatedQuota;
            long free = Long.parseLong(p_value) / 0x40000000L - (long)allocatedQuota.intValue() - 2L;
            res.setCapacity(Long.valueOf(free > 0L ? free : 0L));
        }
        Price price = this.priceRepository.findByTypeAndDomainId(Integer.valueOf(4), domainId);
        res.setPrice(price.getPrice());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u76d1\u63a7\u955c\u50cf\u5236\u4f5c\u72b6\u6001")
    @GetMapping(value={"api/commit/probe"})
    @Transactional
    @ApiImplicitParam(name="image", value="\u4e0a\u4e00\u6b65(\u63d0\u4ea4\u5236\u4f5c\u955c\u50cf\u8bf7\u6c42)\u8fd4\u56de\u7684repo\u5185\u5bb9")
    public ImageCommitResponse probeImageCommit(HttpServletRequest request) {
        ImageCommitResponse res;
        block12: {
            res = new ImageCommitResponse();
            String image = request.getParameter("image");
            if (null == image || image.isEmpty()) {
                res.setCode(Constants.SC_MSG);
                res.setMessage("parameter [image] not found");
                return res;
            }
            Future future = (Future)FUTURE_MAP.get(image);
            if (!future.isDone()) {
                res.setStatus(Integer.valueOf(0));
            } else {
                HttpSession session = request.getSession();
                Long domainId = (Long)session.getAttribute("domain");
                String[] split = image.split(":");
                ResourceSnap snap = null;
                try {
                    FUTURE_MAP.remove(image);
                    com.alibaba.fastjson.JSONObject result = (com.alibaba.fastjson.JSONObject)future.get();
                    if (null != result) {
                        if (result.containsKey((Object)"snap")) {
                            snap = (ResourceSnap)this.resourceSnapRepository.findOne((Serializable)result.getLong("snap"));
                            if (null != snap) {
                                snap.setStatus(Integer.valueOf(1));
                            }
                        } else {
                            if (result.containsKey((Object)"status") && result.getInteger("status") == -1) {
                                res.setStatus(Integer.valueOf(-1));
                                res.setMessage(this.messageUtil.getMessage("msg.harbor.quota.exceeded"));
                                return res;
                            }
                            if (result.containsKey((Object)"replaceId")) {
                                String image_full = FactoryCollection.harborDomain((Long)domainId) + "/" + image;
                                res = this.updateImage(result.getLong("replaceId"), image_full, res);
                            }
                        }
                    }
                    DetailedTag harborImage = this.commonService.getHarborImage(domainId, split[0], split[1]);
                    if (null != result && result.containsKey((Object)"adapt")) {
                        this.commonService.imageActive(domainId, split[0], harborImage);
                        HarborRepoTag tag = new HarborRepoTag();
                        tag.setRepository(split[0]);
                        tag.setTag(split[1]);
                        tag.setNamespace(UUID.randomUUID().toString().replace("-", ""));
                        tag.setType(Integer.valueOf(1));
                        tag.setStatus(Integer.valueOf(2));
                        tag.setDeleted(Integer.valueOf(0));
                        this.harborRepoTagRepository.save((Object)tag);
                    }
                    res.setStatus(Integer.valueOf(1));
                }
                catch (Exception e) {
                    logger.error("ImageCommitResponse [" + image + "] ", (Throwable)e);
                    res.setStatus(Integer.valueOf(-1));
                    if (null == snap) break block12;
                    snap.setStatus(Integer.valueOf(-1));
                }
            }
        }
        return res;
    }

    @ApiOperation(value="\u955c\u50cf\u5236\u4f5c")
    @LogAnnotation(type=0, msgExpression="msg.commit.resource")
    @PostMapping(value={"/api/resource/{id}/commit"})
    @Transactional
    public ImageCommitResponse commitImage(@PathVariable(value="id") Long id, @RequestBody @Valid ImageCreateRequest dto, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ImageCommitResponse res = new ImageCommitResponse();
        res.setCode(Constants.SC_MSG);
        HttpSession session = request.getSession();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long domainId = (Long)session.getAttribute("domain");
        String harborDomain = FactoryCollection.harborDomain((Long)domainId);
        if (!dto.getImage().matches("^[a-z0-9]+(?:-[a-z0-9]+)*")) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.commit.name.invalid", new String[0]);
        }
        if (!dto.getTag().matches("^[a-z0-9]+(?:.[a-z0-9]+)*")) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.commit.tag.invalid", new String[0]);
        }
        String repoName = dto.getProject() + "/" + dto.getImage();
        String repo = repoName + ":" + dto.getTag();
        String image_full = harborDomain + "/" + repo;
        ProductsApi productsApi = FactoryCollection.harborApi((Long)domainId);
        try {
            productsApi.repositoriesRepoNameTagsTagGet(repoName, dto.getTag());
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.commit.image.exist", new String[0]);
        }
        catch (com.mopaas.server.harbor.ApiException apiException) {
            Long depId = (Long)session.getAttribute("departmentId");
            if (depId == null) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
            }
            Long userId = (Long)session.getAttribute("userId");
            DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:frame", (Long)depId)) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
            }
            Integer count = this.harborProjectRepository.countByProjectIdAndDomainId(dto.getProjectId(), domainId);
            if (count == 0) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.repo.project.not.exist", new String[0]);
            }
            try {
                Project project = productsApi.projectsProjectIdGet(dto.getProjectId());
                if (null == project) {
                    res.setMessage(this.messageUtil.getMessage("msg.repo.project.not.exist"));
                    return res;
                }
            }
            catch (com.mopaas.server.harbor.ApiException e) {
                logger.error(e.getResponseBody(), (Throwable)e);
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.repo.inaccessible", new String[0]);
            }
            try {
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
                List podList = k8sFactory.listPods(resource.getGuid());
                if (null != podList && podList.size() > 0) {
                    for (V1Pod pod : podList) {
                        V1ContainerStatus containerStatus;
                        if (!pod.getMetadata().getName().startsWith("deploy-resource") || pod.getStatus().getContainerStatuses() == null || !(containerStatus = (V1ContainerStatus)pod.getStatus().getContainerStatuses().get(0)).getReady().booleanValue()) continue;
                        List es_items = k8sFactory.coreV1Api.listNamespacedPod("kube-system", null, null, null, "spec.nodeName=" + pod.getSpec().getNodeName(), "k8s-app=fluentd-es", null, null, null, null, null).getItems();
                        Future<com.alibaba.fastjson.JSONObject> future = THREAD_POOL.submit(() -> {
                            if (es_items != null && !es_items.isEmpty()) {
                                String readLine;
                                V1Pod fluentd = (V1Pod)es_items.get(0);
                                ProjectSummary summary = productsApi.projectsProjectIdSummaryGet(dto.getProjectId());
                                long total = (Long)summary.getQuota().getHard().getOrDefault((Object)"storage", (Object)0L);
                                String container = containerStatus.getContainerID().substring(9);
                                StringBuilder sb = new StringBuilder("docker commit ");
                                Map nodeSelector = pod.getSpec().getNodeSelector();
                                sb.append(container).append(" ").append(image_full);
                                Process proc = null;
                                BufferedReader br = null;
                                String[] cmd = new String[]{"bash", "-c", ""};
                                if (total != -1L) {
                                    long used = (Long)summary.getQuota().getUsed().getOrDefault((Object)"storage", (Object)0L);
                                    sb.append(" && docker inspect -f {{.Size}} ").append(image_full);
                                    cmd[2] = sb.toString();
                                    try {
                                        proc = new Exec(k8sFactory.client).exec(fluentd, cmd, true, true);
                                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                                        String size = null;
                                        while (null != (readLine = br.readLine())) {
                                            size = readLine;
                                            logger.info(readLine);
                                        }
                                        proc.waitFor();
                                        if (null != size && total - used < Long.parseLong(size)) {
                                            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(2);
                                            jsonObject.put("status", (Object)-1);
                                            proc.destroy();
                                            br.close();
                                            cmd[2] = "docker rmi " + image_full;
                                            proc = new Exec(k8sFactory.client).exec(fluentd, cmd, false, true);
                                            br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                                            while (null != (readLine = br.readLine())) {
                                                logger.info(readLine);
                                            }
                                            proc.waitFor();
                                            com.alibaba.fastjson.JSONObject jSONObject = jsonObject;
                                            return jSONObject;
                                        }
                                    }
                                    finally {
                                        if (null != proc) {
                                            proc.destroy();
                                        }
                                        if (null != br) {
                                            br.close();
                                        }
                                    }
                                    sb = new StringBuilder();
                                } else {
                                    sb.append(" && ");
                                }
                                sb.append("docker login -u ").append(FactoryCollection.harborUsername((Long)domainId)).append(" -p ").append(FactoryCollection.harborPassword((Long)domainId)).append(" ").append(harborDomain).append(" && docker push ").append(image_full).append(" && docker rmi ").append(image_full);
                                cmd[2] = sb.toString();
                                try {
                                    String readLine2;
                                    proc = new Exec(k8sFactory.client).exec(fluentd, cmd, true, true);
                                    br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                                    com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(4);
                                    while (null != (readLine2 = br.readLine())) {
                                        if (readLine2.contains("Quota exceeded")) {
                                            jsonObject.put("status", (Object)-1);
                                            readLine = jsonObject;
                                            return readLine;
                                        }
                                        logger.info(readLine2);
                                    }
                                    proc.waitFor();
                                    String[] split = resource.getImage().replace(harborDomain + "/", "").split(":");
                                    this.harborTag(split[0], split[1], productsApi, repoName, dto.getTag(), dto.getRemark());
                                    jsonObject.put("adapt", null);
                                    if (null != dto.getReplaceFramework() && dto.getReplaceFramework() == 1) {
                                        jsonObject.put("replaceId", (Object)id);
                                    }
                                    com.alibaba.fastjson.JSONObject jSONObject = jsonObject;
                                    return jSONObject;
                                }
                                finally {
                                    if (null != proc) {
                                        proc.destroy();
                                    }
                                    if (null != br) {
                                        br.close();
                                    }
                                }
                            }
                            return null;
                        });
                        FUTURE_MAP.put(repo, future);
                        res.setCode(Constants.SC_OK);
                        res.setRepo(repo);
                    }
                }
            }
            catch (Exception e) {
                logger.error("commitImage error !", (Throwable)e);
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.system.error", new String[0]);
            }
            res.setCode(Constants.SC_OK);
            return res;
        }
    }

    @Transactional
    public ImageCommitResponse updateImage(Long resourceId, String image_full, ImageCommitResponse res) {
        Resource resource = this.resourceRepository.findByIdAndDeleted(resourceId, Integer.valueOf(0));
        try {
            if (resource == null) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.resource.not.exist", new String[0]);
            }
            resource.setImage(image_full);
            this.resourceService.updateWorkload(resource);
        }
        catch (ApiException e) {
            logger.error(e.getResponseBody(), (Throwable)e);
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.image.update.failed", new String[0]);
        }
        return res;
    }

    @LogAnnotation(type=2, msgExpression="msg.ceph.resource")
    @ApiOperation(value="\u5757\u5b58\u50a8\u6269\u5bb9")
    @Transactional
    @PutMapping(value={"/api/resource/ceph/{id}/expand"})
    public ResultResponse cephExpand(@RequestBody @Valid StorageCapacityRequest dto, @PathVariable(value="id") @ApiParam(value="\u5757\u5b58\u50a8id") Long id, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            throw new MessageCodeException(null, null, "msg.storage.not.exist", new String[0]);
        }
        res.setEntity(storage.getName());
        res.setGuid(storage.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(storage.getName(), storage.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"resource:cephcapacity", (Long)depId)) {
            throw new MessageCodeException(storage.getName(), storage.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        JSONArray result = k8sFactory.parsePromResult("/api/v1/query?query=ceph_osd_total_bytes");
        String p_value = result.getJSONObject(0).getJSONArray("value").getString(1);
        Integer allocatedQuota = this.storageRepository.sumRbdAllocatedQuota(domainId);
        allocatedQuota = allocatedQuota == null ? 0 : allocatedQuota;
        long free = Long.parseLong(p_value) / 0x40000000L - (long)allocatedQuota.intValue() - 2L;
        if ((long)dto.getCapacity().intValue() > free) {
            throw new MessageCodeException(storage.getName(), storage.getGuid(), "msg.storage.sys.insufficient", new String[0]);
        }
        StorageExpansion expansion = new StorageExpansion();
        expansion.setStorage(storage);
        expansion.setBeforeCapacity(storage.getCapacity());
        expansion.setAfterCapacity(Integer.valueOf(storage.getCapacity() + dto.getCapacity()));
        try {
            V1Patch patch = new V1Patch("[{\"op\":\"replace\",\"path\":\"/spec/resources/requests/storage\",\"value\":\"" + dto.getCapacity() + "Gi\"}]");
            k8sFactory.coreV1Api.patchNamespacedPersistentVolumeClaim("pvc-" + storage.getGuid(), storage.getGuid(), patch, null, null, null, null);
            storage.setCapacity(Integer.valueOf(storage.getCapacity() + dto.getCapacity()));
            Date now = new Date();
            List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(storage.getId(), Integer.valueOf(2));
            if (null != materials && materials.size() > 0) {
                for (Materials material : materials) {
                    material.setLastedAt(now);
                    material.setOperation(null);
                }
            }
            storage.setStatus(Integer.valueOf(1));
            Materials material = new Materials();
            material.setUser(storage.getUser());
            material.setDepartment(storage.getDepartment());
            material.setOrganization(dep.getOrgConfig().getOrganization());
            material.setResourceId(storage.getId());
            material.setType(Integer.valueOf(2));
            material.setPackageType(Integer.valueOf(2));
            material.setStorageNum(Double.valueOf(storage.getCapacity().doubleValue()));
            material.setCreatedAt(now);
            material.setCostTime(now);
            material.setResourceInstance(Integer.valueOf(1));
            material.setDomain(storage.getDomain());
            this.materialsRepository.save(material);
            expansion.setState(Integer.valueOf(1));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            expansion.setState(Integer.valueOf(-1));
        }
        this.storageExpansionRepository.save((Object)expansion);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5feb\u7167\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/resource/snapshots"}, method={RequestMethod.POST})
    public ListResultResponse<ResourceSnapModel> snaps(@RequestBody @Valid ResourceSnapPageRequest dto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Resource resource = this.resourceRepository.findByIdAndDeleted(dto.getResourceId(), Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, resource.getDepartment());
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (!userId.equals(resource.getUser().getId()) && level == 3) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        Integer pageNum = dto.getPage();
        Integer pageSize = dto.getSize();
        if (pageNum == null || pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
        }
        PageRequest pageable = dto.getTimeSort() != null ? new PageRequest(pageNum - 1, pageSize.intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.DEFAULT_DIRECTION, new String[]{"createdAt"}) : new PageRequest(pageNum - 1, pageSize.intValue(), Sort.Direction.DESC, new String[]{"id"});
        String search = dto.getName();
        Specification spec = (root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get("status"), (Object)1), cb.equal((Expression)root.get("deleted"), (Object)0), cb.equal((Expression)root.get("resource"), (Object)resource), cb.like((Expression)root.get("name"), "%" + search.trim() + "%")});
        Page snapPage = this.resourceSnapRepository.findAll(spec, (Pageable)pageable);
        res.setPages(Integer.valueOf(snapPage.getTotalPages()));
        res.setSize(Long.valueOf(snapPage.getTotalElements()));
        List snapList = snapPage.getContent();
        ArrayList<ResourceSnapModel> models = new ArrayList<ResourceSnapModel>();
        for (ResourceSnap snap : snapList) {
            ResourceSnapModel model = new ResourceSnapModel();
            model.setId(snap.getId());
            model.setName(snap.getName());
            model.setRemark(snap.getRemark());
            model.setCreatedAt(snap.getCreatedAt());
            model.setRecoverAt(snap.getRecoverAt());
            model.setImage(snap.getImageName() + ":" + snap.getImageVersion());
            if (resource.getImage().equals(snap.getImage())) {
                model.setUsing(Integer.valueOf(1));
            } else {
                model.setUsing(Integer.valueOf(0));
            }
            models.add(model);
        }
        res.setList(models);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.snapshot.resource")
    @ApiOperation(value="\u521b\u5efa\u5feb\u7167")
    @PostMapping(value={"/api/resource/{id}/snapshot"})
    @Transactional
    public ImageCommitResponse snapshotImage(@PathVariable(value="id") Long id, @RequestBody @Valid ResourceSnapRequest dto, HttpServletRequest request) throws ApiException, com.mopaas.server.harbor.ApiException {
        ImageCommitResponse res = new ImageCommitResponse();
        res.setCode(Constants.SC_MSG);
        HttpSession session = request.getSession();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = (Domain)this.domainRepository.findOne((Serializable)domainId);
        String harborDomain = FactoryCollection.harborDomain((Long)domainId);
        if (dto.getName().length() > 10) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.snap.name.is.not.correct", new String[0]);
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
        String harborUsername = user.getUsername() + user.getGuid().substring(0, 12);
        String projectName = harborUsername.toLowerCase() + SNAP_REPO;
        Object project = null;
        try {
            com.mopaas.server.harbor.model.User harborUser = null;
            List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
            for (com.mopaas.server.harbor.model.User u : userList) {
                if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                harborUser = u;
                break;
            }
            if (harborUser == null) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.snap.repo.user.not.initialize", new String[0]);
            }
            List projects = harborApi.projectsGet(projectName, null, null, null, null);
            if (projects != null && projects.size() > 0) {
                boolean project_exist = false;
                for (Object p : projects) {
                    if (!p.getName().equals(projectName)) continue;
                    project_exist = true;
                    project = p;
                    break;
                }
                if (!project_exist) {
                    ProjectReq projectReq = new ProjectReq();
                    projectReq.setProjectName(projectName);
                    projectReq.metadata(new ProjectMetadata()._public("false"));
                    harborApi.projectsPost(projectReq);
                    projects = harborApi.projectsGet(projectName, null, null, null, null);
                    if (projects != null && projects.size() > 0) {
                        for (Project p : projects) {
                            if (!p.getName().equals(projectName)) continue;
                            project = p;
                            break;
                        }
                    }
                }
            } else {
                ProjectReq projectReq = new ProjectReq();
                projectReq.setProjectName(projectName);
                projectReq.metadata(new ProjectMetadata()._public("false"));
                harborApi.projectsPost(projectReq);
                projects = harborApi.projectsGet(projectName, null, null, null, null);
                if (projects != null && projects.size() > 0) {
                    for (Object p : projects) {
                        if (!p.getName().equals(projectName)) continue;
                        project = p;
                        break;
                    }
                }
            }
            List projectMemberList = harborApi.projectsProjectIdMembersGet(Long.valueOf(project.getProjectId().intValue()), harborUser.getUsername());
            boolean memberFlag = false;
            for (ProjectMemberEntity member : projectMemberList) {
                if (!member.getEntityName().equals(harborUser.getUsername())) continue;
                memberFlag = true;
                break;
            }
            if (!memberFlag) {
                ProjectMember projectMember = new ProjectMember();
                projectMember.setRoleId(Integer.valueOf(1));
                UserEntity userEntity = new UserEntity();
                userEntity.setUserId(harborUser.getUserId());
                userEntity.setUsername(harborUser.getUsername());
                projectMember.setMemberUser(userEntity);
                harborApi.projectsProjectIdMembersPost(Long.valueOf(project.getProjectId().intValue()), projectMember);
            }
        }
        catch (com.mopaas.server.harbor.ApiException e) {
            logger.info(e.getResponseBody(), (Throwable)e);
        }
        String image = resource.getImage();
        String[] imageSplit = image.replace(harborDomain + "/", "").replace(":", "/").split("/");
        String randomTag = "0.0.001";
        List resourceSnapList = this.resourceSnapRepository.findByResourceUserAndImageNameAndDeleted(user, imageSplit[1], Integer.valueOf(0));
        if (resourceSnapList != null && resourceSnapList.size() > 0) {
            resourceSnapList.sort((a1, a2) -> a2.getId().compareTo(a1.getId()));
            ResourceSnap snap = (ResourceSnap)resourceSnapList.get(0);
            String[] snapImageSplit = snap.getImage().replace(harborDomain + "/", "").replace(":", "/").split("/");
            if (snapImageSplit[2].matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")) {
                int version = Integer.parseInt(snapImageSplit[2].replace(".", ""));
                randomTag = ++version > 999999 ? String.format("%03d", Integer.toString(version).substring(0, Integer.toString(version).length() - 6)) + "." + String.format("%03d", Integer.toString(version).substring(Integer.toString(version).length() - 6, Integer.toString(version).length() - 3)) + "." + String.format("%03d", Integer.toString(version).substring(Integer.toString(version).length() - 3)) : (version > 999 ? "0." + String.format("%03d", Integer.toString(version).substring(0, Integer.toString(version).length() - 3)) + "." + String.format("%03d", Integer.toString(version).substring(Integer.toString(version).length() - 3)) : "0.0." + String.format("%03d", version));
            }
        }
        String repo = projectName + "/" + imageSplit[1];
        String repoName = repo + ":" + randomTag;
        String image_full = harborDomain + "/" + repoName;
        ResourceSnap snap = new ResourceSnap();
        snap.setName(dto.getName());
        snap.setRemark(dto.getRemark());
        snap.setImage(image_full);
        snap.setImageName(imageSplit[1]);
        snap.setImageVersion(randomTag);
        snap.setResource(resource);
        snap.setStatus(Integer.valueOf(0));
        snap.setDeleted(Integer.valueOf(0));
        this.resourceSnapRepository.save((Object)snap);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        try {
            List podList = k8sFactory.listPods(resource.getGuid());
            if (null != podList && podList.size() > 0) {
                for (V1Pod pod : podList) {
                    V1ContainerStatus containerStatus;
                    if (!pod.getMetadata().getName().startsWith("deploy-resource") || pod.getStatus().getContainerStatuses() == null || !(containerStatus = (V1ContainerStatus)pod.getStatus().getContainerStatuses().get(0)).getReady().booleanValue()) continue;
                    List es_items = k8sFactory.coreV1Api.listNamespacedPod("kube-system", null, null, null, "spec.nodeName=" + pod.getSpec().getNodeName(), "k8s-app=fluentd-es", null, null, null, null, null).getItems();
                    String finalRandomTag = randomTag;
                    Future<com.alibaba.fastjson.JSONObject> future = THREAD_POOL.submit(() -> {
                        if (es_items != null && !es_items.isEmpty()) {
                            String container = containerStatus.getContainerID().substring(9);
                            StringBuilder sb = new StringBuilder("docker commit ");
                            Map nodeSelector = pod.getSpec().getNodeSelector();
                            sb.append(container).append(" ").append(image_full).append(" && docker login -u ").append(FactoryCollection.harborUsername((Long)domainId)).append(" -p ").append(FactoryCollection.harborPassword((Long)domainId)).append(" ").append(harborDomain).append(" && docker push ").append(image_full).append(" && docker rmi ").append(image_full);
                            String[] cmd = new String[]{"bash", "-c", sb.toString()};
                            Process proc = null;
                            BufferedReader br = null;
                            try {
                                String readLine;
                                proc = new Exec(k8sFactory.client).exec((V1Pod)es_items.get(0), cmd, true, true);
                                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                                while (null != (readLine = br.readLine())) {
                                    logger.info(readLine);
                                }
                                proc.waitFor();
                                String[] split = image.replace(harborDomain + "/", "").split(":");
                                this.harborTag(split[0], split[1], harborApi, repo, finalRandomTag, dto.getRemark());
                            }
                            catch (Exception e) {
                                logger.error("commitImage error !", (Throwable)e);
                            }
                            finally {
                                if (null != proc) {
                                    proc.destroy();
                                }
                                if (null != br) {
                                    br.close();
                                }
                            }
                        }
                        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(2);
                        jsonObject.put("snap", (Object)snap.getId());
                        return jsonObject;
                    });
                    FUTURE_MAP.put(repoName, future);
                    res.setCode(Constants.SC_OK);
                    res.setRepo(repoName);
                }
            }
        }
        catch (Exception e) {
            logger.error("commitImage error !", (Throwable)e);
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.system.error", new String[0]);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    private String harborTag(String repo, String tag, ProductsApi harborApi, String repoNew, String tagNew, String remark) throws com.mopaas.server.harbor.ApiException, InterruptedException {
        DetailedTag detailedTag = harborApi.repositoriesRepoNameTagsTagGet(repo, tag);
        List labels = detailedTag.getLabels();
        if (null != labels && !labels.isEmpty()) {
            for (int _count = 0; _count < 120; ++_count) {
                try {
                    DetailedTag dTag = harborApi.repositoriesRepoNameTagsTagGet(repoNew, tagNew);
                    if (dTag != null) {
                        break;
                    }
                }
                catch (com.mopaas.server.harbor.ApiException e) {
                    logger.error(e.getResponseBody(), (Throwable)e);
                }
                Thread.sleep(500L);
            }
            for (Label label : labels) {
                harborApi.repositoriesRepoNameTagsTagLabelsPost(repoNew, tagNew, label);
            }
        }
        if (!StringUtils.isEmpty((String)remark)) {
            harborApi.repositoriesRepoNamePut(repoNew, new RepositoryDescription().description(remark));
        }
        return detailedTag.getDigest();
    }

    @LogAnnotation(type=0, msgExpression="msg.snapshot.recover.resource")
    @ApiOperation(value="\u5feb\u7167\u6062\u590d")
    @Transactional
    @RequestMapping(value={"/api/resource/snapshot/{id}"}, method={RequestMethod.PUT})
    public ResultResponse snapRecover(@ApiParam(value="\u5feb\u7167ID") @PathVariable(value="id") Long id, HttpServletRequest request) {
        Double balance;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        ResourceSnap snap = (ResourceSnap)this.resourceSnapRepository.findOne((Serializable)id);
        Resource resource = snap.getResource();
        if (null == resource) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthenticated", new String[0]);
        }
        Organization org = resource.getDepartment().getOrgConfig().getOrganization();
        if (resource.getPack().getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.org.balance.insufficient", new String[0]);
        }
        String image = snap.getImage();
        try {
            resource.setImage(image);
            snap.setRecoverAt(new Date());
            this.resourceService.updateWorkload(resource);
        }
        catch (ApiException e) {
            logger.info(e.getResponseBody(), (Throwable)e);
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.framework.resource")
    @ApiOperation(value="\u66f4\u65b0\u6846\u67b6")
    @Transactional
    @RequestMapping(value={"/api/resource/framework"}, method={RequestMethod.PUT})
    public ResultResponse updateFramework(@RequestBody @Valid UpdateFrameworkRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        Resource resource = (Resource)this.resourceRepository.findOne((Serializable)dto.getId());
        String guid = resource.getGuid();
        res.setEntity(resource.getName());
        res.setGuid(guid);
        Long domainId = (Long)request.getSession().getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            throw new MessageCodeException(resource.getName(), guid, "msg.domain.unavailable", new String[0]);
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(resource.getName(), guid, "msg.account.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), guid, "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        if (resource.getImage().contains("horovod") && !dto.getImage().contains("horovod") || !resource.getImage().contains("horovod") && dto.getImage().contains("horovod")) {
            throw new MessageCodeException(resource.getName(), guid, "msg.frame.horovod.incompatible", new String[0]);
        }
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:replaceframework", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), guid, "msg.account.unauthorized", new String[0]);
        }
        String harborDomain = FactoryCollection.harborDomain((Long)domainId);
        String image = harborDomain + "/" + dto.getImage();
        resource.setImage(image);
        this.resourceService.updateWorkload(resource);
        if (null != resource.getMLabProject()) {
            resource.getMLabProject().setImage(image);
        }
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.resource.tensorboard.enable")
    @ApiOperation(value="tensorboard\u5f00\u5173", notes="v3.5\u65b0\u589e")
    @Transactional
    @PostMapping(value={"/api/resource/{id}/tensorboard"})
    public ResultResponse tensorboard(@PathVariable(value="id") Long id, @RequestBody @Valid TensorboardRequest dto) throws ApiException {
        ResultResponse res = new ResultResponse();
        Resource resource = (Resource)this.resourceRepository.findOne((Serializable)id);
        String guid = resource.getGuid();
        res.setEntity(resource.getName());
        res.setGuid(guid);
        resource.setTensorboardState(dto.getState());
        resource.setLogDir(dto.getLogDir());
        this.resourceService.updateWorkload(resource);
        return res;
    }

    @ApiOperation(value="MLab\u73af\u5883\u8be6\u60c5", notes="v3.3\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570slice")
    @Transactional
    @GetMapping(value={"api/notebook/{id}/labInfo"})
    public MLabInfoResponse labInfo(@PathVariable(value="id") Long id, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        Resource resource;
        MLabInfoResponse res = new MLabInfoResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabProject mLProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        res.setProjectName(mLProject.getName());
        MLabText text = mLProject.getMLabText();
        if (text != null) {
            res.setLastSaveTime(text.getUpdatedAt());
        }
        if (null == (resource = this.resourceRepository.findByMLabProjectIdAndDeleted(id, Integer.valueOf(0)))) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        res.setNamespace(resource.getGuid());
        res.setResourceId(resource.getId());
        PricePackage pack = resource.getPack();
        res.setPackName(pack.getName());
        res.setCpuNum(pack.getCpuNum());
        res.setMemoryNum(pack.getMemoryNum());
        res.setReplicas(resource.getReplicas());
        res.setPackId(pack.getId());
        res.setSlice(pack.getSlice());
        if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
            res.setGpuNum(pack.getGpuNum());
            res.setGpuType(pack.getGpu().getChargeItem());
        }
        ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
        String image = resource.getImage();
        res.setFrame(image.substring(image.indexOf("/") + 1));
        String[] imageSplit = res.getFrame().split(":");
        if (imageSplit[0].startsWith("frame_system")) {
            res.setFrameType(Integer.valueOf(0));
        } else {
            res.setFrameType(Integer.valueOf(1));
        }
        try {
            DetailedTag tag = harborApi.repositoriesRepoNameTagsTagGet(imageSplit[0], imageSplit[1]);
            List labels = tag.getLabels();
            if (null != labels) {
                Optional<Label> arch = labels.stream().filter(e -> "gpu".equals(e.getName()) || "x86".equals(e.getName())).findFirst();
                res.setArch(arch.map(harborLabel -> "x86".equals(harborLabel.getName()) ? 0 : 1).orElse(2));
            }
        }
        catch (com.mopaas.server.harbor.ApiException e2) {
            logger.warn(e2.getResponseBody());
        }
        Long all = this.referDurationRepository.calculateAllByReferTypeAndReferenceAndDepAndDomain(Integer.valueOf(0), resource.getId(), mLProject.getDepartment().getId(), domainId);
        res.setAllDuration(Long.valueOf(all == null ? 0L : all));
        Long lastDuration = this.referDurationRepository.calculateByReferTypeAndReferenceAndDepAndDomain(Integer.valueOf(0), resource.getId(), mLProject.getDepartment().getId(), domainId);
        res.setLastDuration(Long.valueOf(lastDuration == null ? 0L : lastDuration));
        MLabProject mLabProject = resource.getMLabProject();
        if (null != mLabProject) {
            res.setAutoSave(mLabProject.getAutoSave());
        }
        return res;
    }

    @ApiOperation(value="\u8bbe\u7f6enotebook\u81ea\u52a8\u4fdd\u5b58\u65f6\u95f4")
    @Transactional
    @PutMapping(value={"api/resource/{id}/autosave/{minutes}"})
    public ResultResponse autoSave(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @ApiParam(value="\u81ea\u52a8\u4fdd\u5b58\u95f4\u9694(\u5206\u949f)") @PathVariable(value="minutes") Integer minutes) {
        ResultResponse res = new ResultResponse();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        if (minutes < 0) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage("minutes should be greater than 0");
            return res;
        }
        MLabProject mLabProject = resource.getMLabProject();
        if (mLabProject != null) {
            mLabProject.setAutoSave(minutes);
        }
        return res;
    }

    @ApiOperation(value="\u8bbe\u7f6enotebook\u9875\u9762\u5173\u95ed\u81ea\u52a8\u91ca\u653e\u8d44\u6e90\u65f6\u95f4\uff0cv3.5\u53d6\u6d88")
    @Transactional
    @PutMapping(value={"api/resource/{id}/autoreclaim/{minutes}"})
    public ResultResponse autoReclaim(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id, @ApiParam(value="\u81ea\u52a8\u56de\u6536(\u5206\u949f)0\u8868\u793a\u7981\u7528") @PathVariable(value="minutes") Integer minutes) {
        ResultResponse res = new ResultResponse();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        if (minutes < 0) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage("minutes should be greater than 0");
            return res;
        }
        MLabProject mLabProject = resource.getMLabProject();
        if (mLabProject != null) {
            mLabProject.setAutoReclaim(minutes);
            mLabProject.setLastProbe(Long.valueOf(System.currentTimeMillis()));
        }
        return res;
    }

    @ApiOperation(value="notebook\u9875\u9762\u63a2\u6d4b")
    @Transactional
    @PutMapping(value={"api/mlab/{id}/probe"})
    public ResultResponse notebookProbe(@ApiParam(value="\u9879\u76eeid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        MLabProject mLProject = (MLabProject)this.mLabProjectRepository.findOne((Serializable)id);
        if (null == mLProject) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.project.not.exist"));
            return res;
        }
        mLProject.setLastProbe(Long.valueOf(System.currentTimeMillis()));
        return res;
    }

    @Transactional
    public void autoReclaimScheduler() throws ApiException {
        List projects = this.mLabProjectRepository.findAllAutoReclaim();
        if (projects != null) {
            long currentTimeMillis = System.currentTimeMillis();
            Date now = new Date(currentTimeMillis);
            for (MLabProject project : projects) {
                if (currentTimeMillis - project.getLastProbe() <= (long)(project.getAutoReclaim() * 60 * 1000)) continue;
                project.setStatus(Integer.valueOf(0));
                Resource resource = this.resourceRepository.findByMLabProjectAndDeleted(project, Integer.valueOf(0));
                if (resource == null) continue;
                AppsV1Api appsV1Api = FactoryCollection.k8sFactory((Long)resource.getDomain().getId()).appsV1Api;
                try {
                    List durations;
                    List expansions;
                    List materials;
                    appsV1Api.patchNamespacedDeployment("deploy-resource", resource.getGuid(), this.array, null, null, null, null);
                    resource.setStatus(Integer.valueOf(3));
                    resource.setErrorMessage(this.messageSource.getMessage("msg.reclaim.auto.resource", null, null));
                    resource.setReclaimedAt(now);
                    project.setLastProbe(null);
                    OperationLog log = new OperationLog();
                    log.setDepartment(resource.getDepartment());
                    log.setOrganization(resource.getDepartment().getOrgConfig().getOrganization());
                    log.setDomain(resource.getDomain());
                    log.setUsername(this.messageSource.getMessage("msg.system", null, null));
                    log.setResourceGuid(resource.getGuid());
                    log.setResourceName(resource.getName());
                    log.setResourceType(Integer.valueOf(0));
                    log.setDuration(Long.valueOf(new Date().getTime() - now.getTime()));
                    log.setRes(Constants.SC_OK);
                    log.setCreatedAt(new Date());
                    log.setContent(this.messageUtil.getMessageJson("msg.reclaim.auto"));
                    this.operationLogRepository.save((Object)log);
                    if (resource.getPackageType() == 1 && null != (materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(resource.getId(), Integer.valueOf(0))) && !materials.isEmpty()) {
                        for (Materials material : materials) {
                            material.setLastedAt(now);
                            material.setOperation(null);
                        }
                    }
                    if ((expansions = resource.getExpansions()) != null) {
                        for (ResourceExpansion expansion : expansions) {
                            if (expansion.getStatus() == null || expansion.getStatus() != 0) continue;
                            expansion.setStatus(Integer.valueOf(-1));
                        }
                    }
                    if ((durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(resource.getId(), Integer.valueOf(0))) == null) continue;
                    for (ReferDuration duration : durations) {
                        duration.setEnd(now);
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
            }
        }
    }

    @ApiOperation(value="\u73af\u5883\u5b58\u50a8\u8be6\u60c5")
    @Transactional
    @GetMapping(value={"/api/resource/{id}/storage"})
    public ResourceStorageResponse resourceStorage(@PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        ResourceStorageResponse res = new ResourceStorageResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List storages = resource.getStorages();
        if (null != storages && storages.size() > 0) {
            ArrayList<GfsModel> mountModels = new ArrayList<GfsModel>(storages.size());
            CephModel cephModel = null;
            Price price = this.priceRepository.findByTypeAndDomainId(Integer.valueOf(4), domainId);
            for (ResourceStorage storage : storages) {
                Storage s = storage.getStorage();
                if (s.getName().equals(s.getUser().getGuid().replace("-", ""))) continue;
                if (s.getType() != null && s.getType() == 2) {
                    cephModel = new CephModel();
                    cephModel.setId(s.getId());
                    cephModel.setName(s.getName());
                    cephModel.setPath(storage.getPath());
                    cephModel.setPrice(price.getPrice());
                    String volumeUsed = this.storageServiceFactory.getVolumeUsed(s, k8sFactory);
                    cephModel.setCapacity(StringUtils.HumanFilesize((long)Long.parseLong(volumeUsed == null ? "0" : volumeUsed)) + "/" + StringUtils.HumanFilesize((long)(s.getCapacity().longValue() * 0x40000000L)));
                    Double payment = this.paymentRepository.sumByResourceIdAndType(s.getId(), Integer.valueOf(2));
                    cephModel.setCost(payment);
                    List expansions = s.getExpansions();
                    if (null == expansions || expansions.isEmpty()) continue;
                    ArrayList<CephExpandModel> cephExpandModels = new ArrayList<CephExpandModel>(expansions.size());
                    for (StorageExpansion expansion : expansions) {
                        CephExpandModel expandModel = new CephExpandModel();
                        expandModel.setBefore(expansion.getBeforeCapacity());
                        expandModel.setAfter(expansion.getAfterCapacity());
                        expandModel.setState(expansion.getState());
                        expandModel.setWhen(expansion.getCreatedAt());
                        cephExpandModels.add(expandModel);
                    }
                    cephModel.setExpands(cephExpandModels);
                    continue;
                }
                GfsModel mountModel = new GfsModel();
                mountModel.setId(s.getId());
                mountModel.setName(s.getName());
                mountModel.setPath(storage.getPath());
                mountModels.add(mountModel);
            }
            res.setCephModel(cephModel);
            res.setStorages(mountModels);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @LogAnnotation(type=0, msgExpression="msg.storage.resource")
    @ApiOperation(value="\u66f4\u6362\u5b58\u50a8")
    @Transactional
    @RequestMapping(value={"/api/resource/storage"}, method={RequestMethod.PUT})
    public ResultResponse reStorage(@RequestBody @Valid ResourceStorageRequest dto, HttpServletRequest request) throws Exception {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Resource resource = this.resourceRepository.findByIdAndDeleted(dto.getId(), Integer.valueOf(0));
        if (null == resource) {
            throw new MessageCodeException(null, null, "msg.resource.not.exist", new String[0]);
        }
        res.setEntity(resource.getName());
        res.setGuid(resource.getGuid());
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthenticated", new String[0]);
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(resource.getUser().getId()), (String)"resource:replacestorage", (Long)depId)) {
            throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        MLabProject mLabProject = resource.getMLabProject();
        resource.getStorages().clear();
        Map dtoStorages = dto.getStorages();
        if (null != dtoStorages && !dtoStorages.isEmpty()) {
            Collection values = dtoStorages.values();
            long count = values.stream().distinct().count();
            if ((long)values.size() > count) {
                throw new MessageCodeException(resource.getName(), resource.getGuid(), "msg.storage.mount.path.duplicated", new String[0]);
            }
            String[] args = new String[]{"/ai/"};
            dtoStorages.forEach((k, v) -> {
                if (!v.startsWith("/ai/") || "/ai/".equals(v)) {
                    throw new BusinessException(this.messageUtil.getMessage("msg.storage.mount.path.error", args));
                }
                ResourceStorage r_storage = new ResourceStorage();
                r_storage.setResource(resource);
                r_storage.setStorage((Storage)this.storageRepository.findOne((Serializable)k));
                r_storage.setPath(v);
                resource.getStorages().add(r_storage);
            });
            if (null != mLabProject) {
                this.resourceService.checkMlabStorageMount(dtoStorages, mLabProject);
            }
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)resource.getDomain().getId());
        V1Namespace namespace = null;
        try {
            namespace = k8sFactory.coreV1Api.readNamespace(resource.getGuid(), null, null, null);
        }
        catch (ApiException e2) {
            logger.info(e2.getResponseBody());
        }
        if (null == namespace) {
            this.resourceService.doCreate(resource);
            return res;
        }
        ArrayList<V1Volume> volumes = new ArrayList<V1Volume>();
        volumes.add(new V1Volume().name("shm").emptyDir(new V1EmptyDirVolumeSource().medium("Memory")));
        volumes.add(new V1Volume().name("timezone").hostPath(new V1HostPathVolumeSource().path("/usr/share/zoneinfo/Asia/Shanghai")));
        volumes.add(new V1Volume().name("cpuinfo").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/cpuinfo").type("File")));
        volumes.add(new V1Volume().name("diskstats").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/diskstats").type("File")));
        volumes.add(new V1Volume().name("meminfo").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/meminfo").type("File")));
        volumes.add(new V1Volume().name("stat").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/stat").type("File")));
        volumes.add(new V1Volume().name("swaps").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/swaps").type("File")));
        volumes.add(new V1Volume().name("uptime").hostPath(new V1HostPathVolumeSource().path("/var/lib/lxcfs/proc/uptime").type("File")));
        ArrayList<V1VolumeMount> volumeMounts = new ArrayList<V1VolumeMount>();
        volumeMounts.add(new V1VolumeMount().name("shm").mountPath("/dev/shm"));
        volumeMounts.add(new V1VolumeMount().name("timezone").mountPath("/etc/localtime"));
        volumeMounts.add(new V1VolumeMount().name("cpuinfo").mountPath("/proc/cpuinfo").readOnly(Boolean.valueOf(true)));
        volumeMounts.add(new V1VolumeMount().name("diskstats").mountPath("/proc/diskstats").readOnly(Boolean.valueOf(true)));
        volumeMounts.add(new V1VolumeMount().name("meminfo").mountPath("/proc/meminfo").readOnly(Boolean.valueOf(true)));
        volumeMounts.add(new V1VolumeMount().name("stat").mountPath("/proc/stat").readOnly(Boolean.valueOf(true)));
        volumeMounts.add(new V1VolumeMount().name("swaps").mountPath("/proc/swaps").readOnly(Boolean.valueOf(true)));
        volumeMounts.add(new V1VolumeMount().name("uptime").mountPath("/proc/uptime").readOnly(Boolean.valueOf(true)));
        List resourceStorages = resource.getStorages();
        if (null != resourceStorages && resourceStorages.size() > 0) {
            for (ResourceStorage rs : resourceStorages) {
                StorageDept storageDept;
                boolean readOnly;
                Storage storage = rs.getStorage();
                boolean bl = readOnly = !storage.getUser().getId().equals(userId);
                if (readOnly && null != (storageDept = this.storageDeptRepository.findByStorageIdAndDepartmentId(storage.getId(), resource.getDepartment().getId())) && storageDept.getRw() == 1) {
                    readOnly = false;
                }
                if (storage.getType() != null && storage.getType() == 2) {
                    volumes.add(new V1Volume().name("ceph").persistentVolumeClaim(new V1PersistentVolumeClaimVolumeSource().claimName("pvc-" + storage.getGuid())));
                    volumeMounts.add(new V1VolumeMount().name("ceph").mountPath(rs.getPath()));
                    continue;
                }
                this.storageServiceFactory.volumeMountPrepare(storage.getType(), volumes, volumeMounts, VolumeMountDto.builder().k8sFactory(k8sFactory).namespace(resource.getGuid()).storage(storage.getName()).storageGuid(storage.getGuid()).mountPath(rs.getPath()).readOnly(Boolean.valueOf(readOnly)).build());
            }
        }
        AppsV1Api appsV1Api = k8sFactory.appsV1Api;
        if (resource.getReplicas() > 1 && resource.getImage().contains("horovod")) {
            V1Volume volume_hostfile = new V1Volume().name("mnist-horovod-cm").configMap(new V1ConfigMapVolumeSource().name("mnist-horovod").addItemsItem(new V1KeyToPath().key("hostfile.config").path("hostfile").mode(Integer.valueOf(438))));
            volumes.add(volume_hostfile);
            V1VolumeMount cm_mount = new V1VolumeMount().name("mnist-horovod-cm").mountPath("/horovod/generated");
            volumeMounts.add(cm_mount);
            V1StatefulSet sts = appsV1Api.readNamespacedStatefulSet("mnist-horovod", resource.getGuid(), null, null, null);
            sts.getSpec().getTemplate().getSpec().setVolumes(volumes);
            ((V1Container)sts.getSpec().getTemplate().getSpec().getContainers().get(0)).setVolumeMounts(volumeMounts);
            appsV1Api.replaceNamespacedStatefulSet("mnist-horovod", resource.getGuid(), sts, null, null, null);
        }
        V1Deployment deployment = appsV1Api.readNamespacedDeployment("deploy-resource", resource.getGuid(), null, null, null);
        List envList = ((V1Container)deployment.getSpec().getTemplate().getSpec().volumes(volumes).getContainers().get(0)).volumeMounts(volumeMounts).getEnv();
        envList.stream().filter(e -> "JUPYTER_PWD".equals(e.getName()) || "PASSWORD".equals(e.getName())).findAny().ifPresent(e -> e.setValue(EncodeUtil.rawInput((String)resource.getPassword())));
        appsV1Api.replaceNamespacedDeployment("deploy-resource", resource.getGuid(), deployment, null, null, null);
        if (resource.getReplicas() > 1 && !resource.getImage().contains("horovod")) {
            V1Deployment deploymentWork = appsV1Api.readNamespacedDeployment("deploy-worker", resource.getGuid(), null, null, null);
            List envVars = ((V1Container)deploymentWork.getSpec().getTemplate().getSpec().volumes(volumes).getContainers().get(0)).volumeMounts(volumeMounts).getEnv();
            envVars.stream().filter(e -> "JUPYTER_PWD".equals(e.getName()) || "PASSWORD".equals(e.getName())).findAny().ifPresent(e -> e.setValue(EncodeUtil.rawInput((String)resource.getPassword())));
            appsV1Api.replaceNamespacedDeployment("deploy-worker", resource.getGuid(), deploymentWork, null, null, null);
        }
        k8sFactory.deletePods(resource.getGuid());
        if (resource.getStatus() == 1) {
            resource.setStatus(Integer.valueOf(5));
            resource.setErrorMessage(null);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5f00\u53d1\u73af\u5883-\u8d44\u6e90\u662f\u5426\u53ef\u7528")
    @Transactional
    @RequestMapping(value={"/api/resource/quota"}, method={RequestMethod.GET})
    public ResultResponse resourceQuota(HttpServletRequest request) {
        DepQuotas depQuotas;
        DepUsers depUsers;
        Integer res_limit;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domain_id = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domain_id, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domain_id);
        if (null == orgQuotas) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (orgQuotas.getStatus() != 1) {
            res.setMessage(this.messageUtil.getMessage("msg.account.org.domain.disabled"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List orgConfigs = org.getOrgConfigs();
        OrgConfig orgConfig = null;
        String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
        for (OrgConfig c : orgConfigs) {
            if (c.getLevel() != 1) continue;
            orgConfig = c;
            depName = orgConfig.getName();
            break;
        }
        if (null != (res_limit = orgQuotas.getResourceCount()) && res_limit != -1) {
            List depIds = this.orgConfigDepartmentRepository.findIdsByOrgConfigAndDeleted(orgConfig, Integer.valueOf(0));
            Integer org_count = 0;
            if (depIds != null && depIds.size() > 0) {
                for (Long dId : depIds) {
                    org_count = org_count + this.resourceRepository.countByDepartmentIdAndDeletedAndDomain(dId, Integer.valueOf(0), domain);
                }
            }
            if (org_count >= res_limit) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.resource.org.insufficient"));
                return res;
            }
        }
        if ((depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep)) != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domain_id))) {
            Integer user_count;
            if (null != depQuotas.getResourceCount() && depQuotas.getResourceCount() != -1 && null != (user_count = this.resourceRepository.countByDepartmentIdAndDeletedAndDomainAndUser(depId, Integer.valueOf(0), domain, user)) && user_count >= depQuotas.getResourceCount()) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.insufficient.error", new String[]{depName}));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (null != depQuotas.getResourceTime() && depQuotas.getResourceTime() != -1.0) {
                Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(0), userId, depId, domain_id, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getResourceTime() * 60.0 * 60.0) {
                    res.setMessage(this.messageUtil.getMessage("msg.dep.resource.time.insufficient.error", new String[]{depName}));
                    res.setCode(Constants.SC_MSG);
                    return res;
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5f00\u542f\u5b9a\u65f6\u5feb\u7167")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/snapshot/enable"})
    public ResultResponse enableSnapshot(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id) {
        ResultResponse res = new ResultResponse();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        resource.setSnapStatus(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5173\u95ed\u5b9a\u65f6\u5feb\u7167")
    @Transactional
    @PutMapping(value={"/api/resource/{id}/snapshot/close"})
    public ResultResponse closeSnapshot(@ApiParam(value="\u73af\u5883id") @PathVariable(value="id") Long id) {
        ResultResponse res = new ResultResponse();
        Resource resource = this.resourceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        resource.setSnapStatus(Integer.valueOf(0));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5feb\u7167\u5220\u9664")
    @Transactional
    @RequestMapping(value={"/api/resource/snapshot/{id}"}, method={RequestMethod.DELETE})
    public ResultResponse snapRemove(@ApiParam(value="\u5feb\u7167ID") @PathVariable(value="id") Long id, HttpServletRequest request) throws com.mopaas.server.harbor.ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        ResourceSnap snap = (ResourceSnap)this.resourceSnapRepository.findOne((Serializable)id);
        Resource resource = snap.getResource();
        if (null == resource) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)0);
        request.setAttribute("resourceGuid", (Object)resource.getGuid());
        request.setAttribute("resourceName", (Object)resource.getName());
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        if (null == snap.getReTag() || snap.getReTag() == 0) {
            String repo = snap.getImage().substring(snap.getImage().indexOf("/") + 1, snap.getImage().lastIndexOf(":"));
            ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
            try {
                harborApi.repositoriesRepoNameTagsTagDelete(repo, snap.getImageVersion());
            }
            catch (com.mopaas.server.harbor.ApiException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                res.setMessage(this.messageUtil.getMessage("msg.system.error"));
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.system.error"));
                res.setCode(Constants.SC_ERROR);
                return res;
            }
        }
        snap.setDeleted(Integer.valueOf(1));
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @Transactional
    public void scheduleSnapshot() throws ApiException, com.mopaas.server.harbor.ApiException {
        List resources = this.resourceRepository.getSnapResource(Integer.valueOf(1));
        if (null != resources && resources.size() > 0) {
            for (Resource resource : resources) {
                User user = resource.getUser();
                Domain domain = resource.getDomain();
                Long domainId = domain.getId();
                String harborDomain = FactoryCollection.harborDomain((Long)domainId);
                ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
                HarborUser huser = this.harborUserRepository.findTopByUserAndDomain(user, domain);
                String harborUsername = user.getUsername() + user.getGuid().substring(0, 12);
                String projectName = harborUsername.toLowerCase() + SNAP_REPO;
                List snapList = this.resourceSnapRepository.findByResourceAndDeletedOrderByIdDesc(resource, Integer.valueOf(0));
                if (null != snapList && snapList.size() >= 20) {
                    for (int i = snapList.size() - 1; i >= 19; --i) {
                        ResourceSnap snap = (ResourceSnap)snapList.get(i);
                        String repo = snap.getImage().substring(snap.getImage().indexOf("/") + 1, snap.getImage().lastIndexOf(":"));
                        try {
                            harborApi.repositoriesRepoNameTagsTagDelete(repo, snap.getImageVersion());
                        }
                        catch (com.mopaas.server.harbor.ApiException e) {
                            logger.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                        snap.setDeleted(Integer.valueOf(1));
                    }
                }
                Object project = null;
                try {
                    Object p2;
                    com.mopaas.server.harbor.model.User harborUser = null;
                    List userList = harborApi.usersGet(huser.getHarborUsername(), null, null, null);
                    for (com.mopaas.server.harbor.model.User u : userList) {
                        if (!huser.getHarborUsername().equals(u.getUsername())) continue;
                        harborUser = u;
                        break;
                    }
                    if (harborUser == null) break;
                    List projects = harborApi.projectsGet(projectName, null, null, null, null);
                    if (projects != null && projects.size() > 0) {
                        boolean project_exist = false;
                        for (Object p2 : projects) {
                            if (!p2.getName().equals(projectName)) continue;
                            project_exist = true;
                            project = p2;
                            break;
                        }
                        if (!project_exist) {
                            ProjectReq projectReq = new ProjectReq();
                            projectReq.setProjectName(projectName);
                            projectReq.metadata(new ProjectMetadata()._public("false"));
                            harborApi.projectsPost(projectReq);
                            projects = harborApi.projectsGet(projectName, null, null, null, null);
                            if (projects != null && projects.size() > 0) {
                                for (Project p3 : projects) {
                                    if (!p3.getName().equals(projectName)) continue;
                                    project = p3;
                                    break;
                                }
                            }
                        }
                    } else {
                        ProjectReq projectReq = new ProjectReq();
                        projectReq.setProjectName(projectName);
                        projectReq.metadata(new ProjectMetadata()._public("false"));
                        harborApi.projectsPost(projectReq);
                        projects = harborApi.projectsGet(projectName, null, null, null, null);
                        if (projects != null && projects.size() > 0) {
                            for (Object p2 : projects) {
                                if (!p2.getName().equals(projectName)) continue;
                                project = p2;
                                break;
                            }
                        }
                    }
                    List projectMemberList = harborApi.projectsProjectIdMembersGet(Long.valueOf(project.getProjectId().intValue()), harborUser.getUsername());
                    boolean memberFlag = false;
                    p2 = projectMemberList.iterator();
                    while (p2.hasNext()) {
                        ProjectMemberEntity member = (ProjectMemberEntity)p2.next();
                        if (!member.getEntityName().equals(harborUser.getUsername())) continue;
                        memberFlag = true;
                        break;
                    }
                    if (!memberFlag) {
                        ProjectMember projectMember = new ProjectMember();
                        projectMember.setRoleId(Integer.valueOf(1));
                        UserEntity userEntity = new UserEntity();
                        userEntity.setUserId(harborUser.getUserId());
                        userEntity.setUsername(harborUser.getUsername());
                        projectMember.setMemberUser(userEntity);
                        harborApi.projectsProjectIdMembersPost(Long.valueOf(project.getProjectId().intValue()), projectMember);
                    }
                }
                catch (com.mopaas.server.harbor.ApiException e) {
                    logger.info(e.getResponseBody(), (Throwable)e);
                }
                String image = resource.getImage();
                String[] imageSplit = image.replace(harborDomain + "/", "").replace(":", "/").split("/");
                String randomTag = "0.0.001";
                List resourceSnapList = this.resourceSnapRepository.findByResourceUserAndImageNameAndDeleted(user, imageSplit[1], Integer.valueOf(0));
                if (resourceSnapList != null && resourceSnapList.size() > 0) {
                    resourceSnapList.sort((a1, a2) -> a2.getId().compareTo(a1.getId()));
                    ResourceSnap snap = (ResourceSnap)resourceSnapList.get(0);
                    String[] snapImageSplit = snap.getImage().replace(harborDomain + "/", "").replace(":", "/").split("/");
                    if (snapImageSplit[2].matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")) {
                        int version = Integer.parseInt(snapImageSplit[2].replace(".", ""));
                        randomTag = ++version > 999999 ? String.format("%03d", Integer.toString(version).substring(0, Integer.toString(version).length() - 6)) + "." + String.format("%03d", Integer.toString(version).substring(Integer.toString(version).length() - 6, Integer.toString(version).length() - 3)) + "." + String.format("%03d", Integer.toString(version).substring(Integer.toString(version).length() - 3)) : (version > 999 ? "0." + String.format("%03d", Integer.toString(version).substring(0, Integer.toString(version).length() - 3)) + "." + String.format("%03d", Integer.toString(version).substring(Integer.toString(version).length() - 3)) : "0.0." + String.format("%03d", version));
                    }
                }
                String repo = projectName + "/" + imageSplit[1];
                String repoName = repo + ":" + randomTag;
                String image_full = harborDomain + "/" + repoName;
                Integer count = this.resourceSnapRepository.countByResourceAndImageAndDeleted(resource, image_full, Integer.valueOf(0));
                if (count > 0) continue;
                ResourceSnap snap = new ResourceSnap();
                Date now = new Date();
                snap.setName("snapshot" + TimeUtil.dateToNumber((Date)now));
                snap.setImage(image_full);
                snap.setImageName(imageSplit[1]);
                snap.setImageVersion(randomTag);
                snap.setResource(resource);
                snap.setStatus(Integer.valueOf(0));
                snap.setDeleted(Integer.valueOf(0));
                this.resourceSnapRepository.save((Object)snap);
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
                try {
                    List podList = k8sFactory.listPods(resource.getGuid());
                    if (null == podList || podList.size() <= 0) continue;
                    for (V1Pod pod : podList) {
                        V1ContainerStatus containerStatus;
                        if (!pod.getMetadata().getName().startsWith("deploy-resource") || pod.getStatus().getContainerStatuses() == null || !(containerStatus = (V1ContainerStatus)pod.getStatus().getContainerStatuses().get(0)).getReady().booleanValue()) continue;
                        logger.info("start schedule snapshot {} at {}", (Object)resource.getName(), (Object)now);
                        List es_items = k8sFactory.coreV1Api.listNamespacedPod("kube-system", null, null, null, "spec.nodeName=" + pod.getSpec().getNodeName(), "k8s-app=fluentd-es", null, null, null, null, null).getItems();
                        String finalRandomTag = randomTag;
                        Future<com.alibaba.fastjson.JSONObject> future = THREAD_POOL.submit(() -> {
                            if (es_items != null && !es_items.isEmpty()) {
                                logger.info("do schedule snapshot {} at {}", (Object)resource.getName(), (Object)now);
                                String container = containerStatus.getContainerID().substring(9);
                                StringBuilder sb = new StringBuilder("docker commit ");
                                Map nodeSelector = pod.getSpec().getNodeSelector();
                                sb.append(container).append(" ").append(image_full).append(" && docker login -u ").append(FactoryCollection.harborUsername((Long)domainId)).append(" -p ").append(FactoryCollection.harborPassword((Long)domainId)).append(" ").append(harborDomain).append(" && docker push ").append(image_full).append(" && docker rmi ").append(image_full);
                                String[] cmd = new String[]{"bash", "-c", sb.toString()};
                                Process proc = null;
                                BufferedReader br = null;
                                try {
                                    String readLine;
                                    proc = new Exec(k8sFactory.client).exec((V1Pod)es_items.get(0), cmd, true, true);
                                    br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                                    while (null != (readLine = br.readLine())) {
                                        logger.info(readLine);
                                    }
                                    proc.waitFor();
                                    String[] split = image.replace(harborDomain + "/", "").split(":");
                                    this.harborTag(split[0], split[1], harborApi, repo, finalRandomTag, null);
                                }
                                catch (Exception e) {
                                    logger.error("commitImage error !", (Throwable)e);
                                    snap.setStatus(Integer.valueOf(-1));
                                }
                                finally {
                                    if (null != proc) {
                                        proc.destroy();
                                    }
                                    if (null != br) {
                                        br.close();
                                    }
                                }
                            }
                            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(1);
                            jsonObject.put("snap", (Object)snap.getId());
                            return jsonObject;
                        });
                        snap.setStatus(Integer.valueOf(1));
                        FUTURE_MAP.put(repoName, future);
                    }
                }
                catch (Exception e) {
                    logger.error("commitImage error !", (Throwable)e);
                    snap.setStatus(Integer.valueOf(-1));
                }
            }
        }
    }

    public void scheduleSnapshotRemove() throws com.mopaas.server.harbor.ApiException {
        List resources = this.resourceRepository.getSnapResource(Integer.valueOf(0));
        if (null != resources && resources.size() > 0) {
            for (Resource resource : resources) {
                Domain domain = resource.getDomain();
                Long domainId = domain.getId();
                ProductsApi harborApi = FactoryCollection.harborApi((Long)domainId);
                List snapList = this.resourceSnapRepository.findByResourceAndDeletedOrderByIdDesc(resource, Integer.valueOf(0));
                if (null == snapList || snapList.size() <= 20) continue;
                for (int i = snapList.size() - 1; i >= 20; --i) {
                    ResourceSnap snap = (ResourceSnap)snapList.get(i);
                    String repo = snap.getImage().substring(snap.getImage().indexOf("/") + 1, snap.getImage().lastIndexOf(":"));
                    try {
                        harborApi.repositoriesRepoNameTagsTagDelete(repo, snap.getImageVersion());
                    }
                    catch (com.mopaas.server.harbor.ApiException e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    snap.setDeleted(Integer.valueOf(1));
                }
            }
        }
    }

    @ApiOperation(value="\u5feb\u7167\u53d1\u5e03", notes="v3.5\u65b0\u589e")
    @LogAnnotation(type=0, msgExpression="msg.snapshot.deploy")
    @PostMapping(value={"/api/resource/snapshot/{id}/tags"})
    @Transactional
    public ResultResponse reTagImage(@PathVariable(value="id") Long id, @RequestBody @Valid ImageCreateRequest dto, HttpServletRequest request) throws InterruptedException {
        Long domainId = (Long)request.getSession().getAttribute("domain");
        ResultResponse res = new ResultResponse();
        ResourceSnap snap = (ResourceSnap)this.resourceSnapRepository.findOne((Serializable)id);
        try {
            String image = snap.getImage().substring(snap.getImage().indexOf("/") + 1);
            String repo = String.format("%s/%s", dto.getProject(), dto.getImage());
            ProductsApi productsApi = FactoryCollection.harborApi((Long)domainId);
            productsApi.repositoriesRepoNameTagsPost(repo, new RetagReq().srcImage(image).tag(dto.getTag()).override(Boolean.TRUE));
            String[] split = image.split(":");
            String digest = this.harborTag(split[0], split[1], productsApi, repo, dto.getTag(), dto.getRemark());
            snap.setReTag(Integer.valueOf(1));
            HarborRepoTag tag = new HarborRepoTag();
            tag.setRepository(repo);
            tag.setTag(dto.getTag());
            tag.setNamespace(UUID.randomUUID().toString().replace("-", ""));
            tag.setType(Integer.valueOf(1));
            tag.setStatus(Integer.valueOf(3));
            tag.setSha256(digest);
            tag.setDeleted(Integer.valueOf(0));
            res.setGuid(tag.getNamespace());
            this.harborRepoTagRepository.save((Object)tag);
        }
        catch (com.mopaas.server.harbor.ApiException e) {
            res.setCode(Constants.SC_MSG);
            if ("Conflict".equals(e.getMessage())) {
                res.setMessage(this.messageUtil.getMessage("msg.image.exist"));
            } else if (e.getResponseBody().contains("Quota exceeded")) {
                res.setMessage(this.messageUtil.getMessage("msg.harbor.quota.exceeded"));
            } else {
                res.setCode(Constants.SC_ERROR);
            }
            logger.error(e.getResponseBody(), (Throwable)e);
        }
        return res;
    }

    @ConstructorProperties(value={"userRepository", "harborProjectRepository", "orgConfigDepartmentRepository", "systemConfigRepository", "resourceRepository", "balancesRepository", "pricePackageRepository", "storageRepository", "storageDeptRepository", "materialsRepository", "paymentRepository", "expansionRepository", "portRepository", "packageRepository", "payService", "noticeUserService", "harborProjectDeptRepository", "depUsersRepository", "domainRepository", "organizationQuotasRepository", "priceRepository", "storageExpansionRepository", "referDurationRepository", "depQuotasRepository", "resourceSnapRepository", "messageSource", "mLabProjectRepository", "mLabTextRepository", "storageController", "k8sEventRepository", "operationLogRepository", "resourceService", "storageServiceFactory", "messageUtil", "k8sEngineRepository", "harborRepoTagRepository", "harborUserRepository", "harborLabelRepository", "harborFactory", "commonService", "harborPlatformImageLogoRepository"})
    public ResourceController(UserRepository userRepository, HarborProjectRepository harborProjectRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, SystemConfigRepository systemConfigRepository, ResourceRepository resourceRepository, BalancesRepository balancesRepository, PricePackageRepository pricePackageRepository, StorageRepository storageRepository, StorageDeptRepository storageDeptRepository, MaterialsRepository materialsRepository, PaymentRepository paymentRepository, ExpansionRepository expansionRepository, PortRepository portRepository, PricePackageRepository packageRepository, AsyncPayService payService, NoticeUserService noticeUserService, HarborProjectDeptRepository harborProjectDeptRepository, DepUsersRepository depUsersRepository, DomainRepository domainRepository, OrganizationQuotasRepository organizationQuotasRepository, PriceRepository priceRepository, StorageExpansionRepository storageExpansionRepository, ReferDurationRepository referDurationRepository, DepQuotasRepository depQuotasRepository, ResourceSnapRepository resourceSnapRepository, MessageSource messageSource, MLabProjectRepository mLabProjectRepository, MLabTextRepository mLabTextRepository, StorageController storageController, K8sEventRepository k8sEventRepository, OperationLogRepository operationLogRepository, ResourceService resourceService, StorageServiceFactory storageServiceFactory, MessageUtil messageUtil, K8sEngineRepository k8sEngineRepository, HarborRepoTagRepository harborRepoTagRepository, HarborUserRepository harborUserRepository, HarborLabelRepository harborLabelRepository, HarborFactory harborFactory, CommonService commonService, HarborPlatformImageLogoRepository harborPlatformImageLogoRepository) {
        this.userRepository = userRepository;
        this.harborProjectRepository = harborProjectRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.resourceRepository = resourceRepository;
        this.balancesRepository = balancesRepository;
        this.pricePackageRepository = pricePackageRepository;
        this.storageRepository = storageRepository;
        this.storageDeptRepository = storageDeptRepository;
        this.materialsRepository = materialsRepository;
        this.paymentRepository = paymentRepository;
        this.expansionRepository = expansionRepository;
        this.portRepository = portRepository;
        this.packageRepository = packageRepository;
        this.payService = payService;
        this.noticeUserService = noticeUserService;
        this.harborProjectDeptRepository = harborProjectDeptRepository;
        this.depUsersRepository = depUsersRepository;
        this.domainRepository = domainRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.priceRepository = priceRepository;
        this.storageExpansionRepository = storageExpansionRepository;
        this.referDurationRepository = referDurationRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.resourceSnapRepository = resourceSnapRepository;
        this.messageSource = messageSource;
        this.mLabProjectRepository = mLabProjectRepository;
        this.mLabTextRepository = mLabTextRepository;
        this.storageController = storageController;
        this.k8sEventRepository = k8sEventRepository;
        this.operationLogRepository = operationLogRepository;
        this.resourceService = resourceService;
        this.storageServiceFactory = storageServiceFactory;
        this.messageUtil = messageUtil;
        this.k8sEngineRepository = k8sEngineRepository;
        this.harborRepoTagRepository = harborRepoTagRepository;
        this.harborUserRepository = harborUserRepository;
        this.harborLabelRepository = harborLabelRepository;
        this.harborFactory = harborFactory;
        this.commonService = commonService;
        this.harborPlatformImageLogoRepository = harborPlatformImageLogoRepository;
    }
}

