/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.ResourceFileRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.Resource;
import com.mopaas.server.entity.ResourceFile;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.model.request.ResourceFileRequest;
import com.mopaas.server.model.response.FileModel;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.ResultResponse;
import io.kubernetes.client.Copy;
import io.kubernetes.client.openapi.models.V1Pod;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileSystemUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6e90\u73af\u5883\u5907\u4efd\u64cd\u4f5c"})
@RestController
public class ResourceFileController {
    @Autowired
    private ResourceFileRepository fileRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    @Autowired
    private DepUsersRepository depUsersRepository;
    @Autowired
    private MessageUtil messageUtil;
    private static final String MINIO_FILE_UPLOAD = "ai-file";
    private static final Logger logger = LoggerFactory.getLogger(ResourceFileController.class);

    @ApiOperation(value="\u5907\u4efd\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/resource/{id}/files"}, method={RequestMethod.GET})
    public ListResultResponse<FileModel> files(@ApiParam(value="\u8d44\u6e90\u73af\u5883id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Resource resource = (Resource)this.resourceRepository.findOne((Serializable)id);
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            return res;
        }
        List files = this.fileRepository.findByResourceAndDeletedOrderByIdDesc(resource, Integer.valueOf(0));
        res.setList((Collection)BeanMapper.mapList((Iterable)files, ResourceFile.class, FileModel.class));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5907\u4efd\u5bfc\u51fa")
    @Transactional
    @RequestMapping(value={"/api/resource/{id}/file/export"}, method={RequestMethod.POST})
    public ResultResponse fileExport(@ApiParam(value="\u8d44\u6e90\u73af\u5883id") @PathVariable(value="id") Long id, @Valid @RequestBody ResourceFileRequest dto, HttpServletRequest request) throws Exception {
        V1Pod pod;
        ResultResponse res = new ResultResponse();
        request.setAttribute("resourceType", (Object)0);
        Resource resource = (Resource)this.resourceRepository.findOne((Serializable)id);
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.not.exist"));
            return res;
        }
        request.setAttribute("resourceGuid", (Object)resource.getGuid());
        request.setAttribute("resourceName", (Object)resource.getName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        String filePath = dto.getUrl();
        if (!filePath.startsWith("/")) {
            res.setMessage(this.messageUtil.getMessage("msg.resource.model.path.begin.error"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.model.path.begin.error"));
            return res;
        }
        if (filePath.startsWith("//") && filePath.endsWith("/")) {
            res.setMessage(this.messageUtil.getMessage("msg.resource.model.path.end.error"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.model.path.end.error"));
            return res;
        }
        String guid = UUID.randomUUID().toString().replace("-", "");
        String timeStamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String[] splits = filePath.split("/");
        String artifact = filePath.endsWith("/") ? guid + ".tar" : guid;
        ResourceFile file = new ResourceFile();
        file.setUrl(dto.getUrl());
        file.setArtifact(artifact);
        file.setRemark(dto.getRemark());
        file.setResource(resource);
        file.setSerial("mx" + timeStamp);
        file.setStatus(Integer.valueOf(0));
        file.setDeleted(Integer.valueOf(0));
        String namespace = resource.getGuid();
        Long domainId = (Long)session.getAttribute("domain");
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List pods = k8sFactory.listPods(namespace);
        if (null != pods && !pods.isEmpty() && "Running".equals((pod = (V1Pod)pods.get(0)).getStatus().getPhase())) {
            MinioClient client = FactoryCollection.minioClient((Long)domainId);
            Copy copy = new Copy(k8sFactory.client);
            if (!filePath.endsWith("/")) {
                try (InputStream response = copy.copyFileFromPod(pod, filePath);){
                    boolean isExist = client.bucketExists(MINIO_FILE_UPLOAD);
                    if (!isExist) {
                        client.makeBucket(MINIO_FILE_UPLOAD);
                    }
                    client.putObject(MINIO_FILE_UPLOAD, artifact, response, null);
                }
            }
            Path path = Files.createTempDirectory("mopaas", new FileAttribute[0]);
            copy.copyDirectoryFromPod(pod, filePath, path);
            String tar = path + File.separator + artifact;
            try (TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(tar));){
                taos.setBigNumberMode(1);
                taos.setLongFileMode(2);
                taos.setAddPaxHeadersForNonAsciiNames(true);
                this.compress(taos, Paths.get(path.toString(), splits[1]).toFile(), "");
                client.putObject(MINIO_FILE_UPLOAD, artifact, tar, "application/tar");
            }
            finally {
                FileSystemUtils.deleteRecursively((File)path.toFile());
            }
            file.setStatus(Integer.valueOf(1));
            this.fileRepository.save((Object)file);
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    private void compress(TarArchiveOutputStream out, File file, String dir) throws IOException {
        File[] children;
        String entity = dir + File.separator + file.getName();
        if (file.isFile()) {
            out.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file, entity));
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            out.closeArchiveEntry();
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.compress(out, child, entity);
            }
        }
    }

    @ApiOperation(value="\u5907\u4efd\u4e0b\u8f7d")
    @Transactional
    @RequestMapping(value={"/api/resource/{resource}/file/{id}/download"}, method={RequestMethod.GET})
    public ResultResponse fileDownload(@ApiParam(value="\u73af\u5883id") @PathVariable(value="resource") Long resId, @ApiParam(value="\u5907\u4efdid") @PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultResponse res = new ResultResponse();
        request.setAttribute("resourceType", (Object)0);
        Resource resource = (Resource)this.resourceRepository.findOne((Serializable)resId);
        if (null == resource) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.not.exist"));
            return res;
        }
        request.setAttribute("resourceGuid", (Object)resource.getGuid());
        request.setAttribute("resourceName", (Object)resource.getName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        ResourceFile file = (ResourceFile)this.fileRepository.findOne((Serializable)id);
        if (null == file) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.file.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.file.not.exist"));
            return res;
        }
        response.reset();
        response.setContentType("application/force-download");
        String[] splits = file.getUrl().split("/");
        String fileName = file.getUrl().endsWith("/") ? splits[splits.length - 1] + ".tar" : splits[splits.length - 1];
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try (InputStream in = null;
             ServletOutputStream out = response.getOutputStream();){
            Long domainId = (Long)session.getAttribute("domain");
            MinioClient client = FactoryCollection.minioClient((Long)domainId);
            ObjectStat stat = client.statObject(MINIO_FILE_UPLOAD, file.getArtifact());
            long length = stat.length();
            if (length > 0L) {
                int len;
                response.setContentLength((int)length);
                in = client.getObject(MINIO_FILE_UPLOAD, file.getArtifact());
                byte[] b = new byte[1024];
                while ((len = in.read(b)) != -1) {
                    out.write(b, 0, len);
                }
                out.flush();
            }
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u5907\u4efd\u5220\u9664")
    @Transactional
    @RequestMapping(value={"/api/resource/file/{id}"}, method={RequestMethod.DELETE})
    public ResultResponse fileRemove(@ApiParam(value="\u5907\u4efdid") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        ResourceFile file = (ResourceFile)this.fileRepository.findOne((Serializable)id);
        if (null == file) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.file.not.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.file.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)0);
        request.setAttribute("resourceGuid", (Object)file.getResource().getGuid());
        request.setAttribute("resourceName", (Object)file.getResource().getName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        try {
            Long domainId = (Long)session.getAttribute("domain");
            MinioClient client = FactoryCollection.minioClient((Long)domainId);
            ObjectStat stat = client.statObject(MINIO_FILE_UPLOAD, file.getArtifact());
            if (null != stat) {
                client.removeObject(MINIO_FILE_UPLOAD, file.getArtifact());
            }
        }
        catch (Exception e) {
            logger.error("file delete minio exception", (Throwable)e);
            request.setAttribute("errorMessage", (Object)e.getMessage());
        }
        file.setDeleted(Integer.valueOf(1));
        request.setAttribute("result", (Object)"true");
        return res;
    }
}

