/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.mopaas.server.aop.log.LogAnnotation;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.ElasticsearchUtils;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.component.InferenceServiceJob;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.controller.ServiceController;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.JwtRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.ModelVersionRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.PaymentRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.ServiceDeployRecordRepository;
import com.mopaas.server.dao.ServiceRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.ModelVersion;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.ReferDuration;
import com.mopaas.server.entity.Service;
import com.mopaas.server.entity.ServiceDeployRecord;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.User;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.model.InstantMetricModel;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.InferenceCodeRequest;
import com.mopaas.server.model.request.LogSearchRequest;
import com.mopaas.server.model.request.RemarkUpdateRequest;
import com.mopaas.server.model.request.ServiceRequest;
import com.mopaas.server.model.request.ServiceSortPageRequest;
import com.mopaas.server.model.response.InferenceCodeResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.LogResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.ServiceBaseInfoResponse;
import com.mopaas.server.model.response.ServiceDeployRecordModel;
import com.mopaas.server.model.response.ServiceDeployRecordResponse;
import com.mopaas.server.model.response.ServiceModel;
import com.mopaas.server.model.response.ServiceResponse;
import com.mopaas.server.service.CommonService;
import com.mopaas.server.service.InferenceService;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventList;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateWaiting;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.RequestContext;

@Api(tags={"\u53d1\u5e03\u6a21\u578b\u670d\u52a1"})
@RestController
public class ServiceController {
    final UserRepository userRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final ServiceRepository serviceRepository;
    final BalancesRepository balancesRepository;
    final PricePackageRepository pricePackageRepository;
    final SystemConfigRepository systemConfigRepository;
    final PaymentRepository paymentRepository;
    final MaterialsRepository materialsRepository;
    final ServiceDeployRecordRepository deployRecordRepository;
    final DepUsersRepository depUsersRepository;
    final DomainRepository domainRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final ReferDurationRepository referDurationRepository;
    final DepQuotasRepository depQuotasRepository;
    final ModelVersionRepository modelVersionRepository;
    final JwtRepository jwtRepository;
    final Scheduler scheduler;
    final CommonService commonService;
    final ServiceDeployRecordRepository serviceDeployRecordRepository;
    final MessageSource messageSource;
    final MessageUtil messageUtil;
    final InferenceService inferenceService;
    private static final Logger logger = LoggerFactory.getLogger(ServiceController.class);
    private static final Map<String, Integer> probe = new HashMap();

    @ApiOperation(value="\u670d\u52a1\u5b9e\u4f8b\u6570\u914d\u7f6e")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/service/instance"})
    public ListResultResponse<String> instanceLimit(HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            return res;
        }
        SystemConfig modelInstance = this.systemConfigRepository.findByConfigName("AI_MODEL_SERVICE_INSTANCES_" + domainId);
        if (null != modelInstance) {
            Map instanceMap = (Map)JSONObject.parseObject((String)modelInstance.getConfigValue(), Map.class);
            List value = instanceMap.values().stream().map(String::valueOf).sorted().collect(Collectors.toList());
            res.setList(value);
        }
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.create.service")
    @ApiOperation(value="\u521b\u5efa\u670d\u52a1-v3.4\u66f4\u65b0")
    @Transactional
    @RequestMapping(value={"/api/service"}, method={RequestMethod.POST})
    public ResultResponse create(@RequestBody @Valid ServiceRequest dto, HttpServletRequest request) throws Exception {
        Double balance;
        PricePackage pack;
        DepQuotas depQuotas;
        Integer org_count;
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getName());
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            throw new MessageCodeException(dto.getName(), null, "msg.domain.unavailable", new String[0]);
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(dto.getName(), null, "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Long userId = (Long)request.getSession().getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"service:release", (Long)depId)) {
            throw new MessageCodeException(dto.getName(), null, "msg.account.unauthorized", new String[0]);
        }
        Organization org = dep.getOrgConfig().getOrganization();
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domainId);
        if (null == orgQuotas) {
            throw new MessageCodeException(dto.getName(), null, "msg.domain.resource.quota.unset", new String[0]);
        }
        if (orgQuotas.getStatus() != 1) {
            throw new MessageCodeException(dto.getName(), null, "msg.account.org.domain.disabled", new String[0]);
        }
        Integer res_limit = orgQuotas.getModelCount();
        if (null != res_limit && res_limit != -1 && (org_count = this.serviceRepository.countByDepOrganizationAndDeleted(org, Integer.valueOf(0))) >= res_limit) {
            throw new MessageCodeException(dto.getName(), null, "msg.service.org.insufficient", new String[0]);
        }
        if (depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId))) {
            Integer user_count;
            String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
            for (OrgConfig config : org.getOrgConfigs()) {
                if (1 != config.getLevel()) continue;
                depName = config.getName();
                break;
            }
            if (null != depQuotas.getModelCount() && depQuotas.getModelCount() != -1 && null != (user_count = this.serviceRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user)) && user_count >= depQuotas.getModelCount()) {
                throw new MessageCodeException(dto.getName(), null, "msg.dep.resource.insufficient.error", new String[]{depName});
            }
            if (null != depQuotas.getModelTime() && depQuotas.getModelTime() != -1.0) {
                Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(2), userId, depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getModelTime() * 60.0 * 60.0) {
                    throw new MessageCodeException(dto.getName(), null, "msg.dep.resource.time.insufficient.error", new String[]{depName});
                }
            }
        }
        if (null == (pack = this.pricePackageRepository.findByIdAndStatusAndDeleted(dto.getPack(), Integer.valueOf(1), Integer.valueOf(0)))) {
            throw new MessageCodeException(dto.getName(), null, "msg.package.not.available", new String[0]);
        }
        if (pack.getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            throw new MessageCodeException(dto.getName(), null, "msg.org.balance.insufficient", new String[0]);
        }
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(domain).organization(org).department(dep).user(user).name(dto.getName()).pack(pack).replica(dto.getInstance()).priority(Integer.valueOf(0)).operate("create").build();
        this.commonService.judgeResource(identityDto);
        Integer count = this.serviceRepository.countByNameAndDepartmentAndDeleted(dto.getName(), dep, Integer.valueOf(0));
        if (count > 0) {
            throw new MessageJsonException(dto.getName(), null, "msg.dep.resource.name.exist.error", new String[]{"msg.type.inference"});
        }
        ModelVersion modelVersion = this.modelVersionRepository.findByIdAndDeleted(dto.getModelVersionId(), Integer.valueOf(0));
        if (null == modelVersion) {
            throw new MessageCodeException(dto.getName(), null, "msg.model.version.not.exist", new String[0]);
        }
        this.commonService.judgeSysResource(identityDto);
        String guid = UUID.randomUUID().toString().replace("-", "");
        res.setGuid(guid);
        ServiceDeployRecord record = new ServiceDeployRecord();
        record.setInference("isvc" + guid.substring(0, 8));
        record.setToken(this.inferenceService.genJwt(guid));
        record.setModelVersion(modelVersion);
        record.setGuid(guid);
        record.setPack(pack);
        record.setStatus(Integer.valueOf(1));
        record.setInstance(dto.getInstance());
        record.setDuration(dto.getDuration());
        record.setDeleted(Integer.valueOf(0));
        record.setRemark(dto.getRemark());
        record.setCode(dto.getCode());
        record.setProtocol(dto.getProtocol());
        record.setImage(FactoryCollection.harborDomain((Long)domainId) + "/" + dto.getImage());
        record.setType(dto.getType());
        this.serviceDeployRecordRepository.save((Object)record);
        Service service = new Service();
        service.setDomain(domain);
        service.setDepartment(dep);
        service.setName(dto.getName());
        service.setUser(user);
        service.setDeleted(Integer.valueOf(0));
        service.setCurrent(record);
        this.serviceRepository.save((Object)service);
        record.setService(service);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/services"}, method={RequestMethod.POST})
    public ListResultResponse<ServiceModel> list(@RequestBody @Valid ServiceSortPageRequest dto, HttpServletRequest request) throws ApiException {
        PageRequest pageable;
        Integer finalLevel;
        2 spec;
        Page pages;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Integer level = 3;
        if (depUsers != null) {
            level = depUsers.getType();
        }
        if (null != (pages = this.serviceRepository.findAll((Specification)(spec = new /* Unavailable Anonymous Inner Class!! */), (Pageable)(pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.DEFAULT_DIRECTION, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"}))))) {
            List services = pages.getContent();
            res.setPages(Integer.valueOf(pages.getTotalPages()));
            res.setSize(Long.valueOf(pages.getTotalElements()));
            ArrayList<ServiceModel> models = new ArrayList<ServiceModel>(services.size());
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            for (Service service : services) {
                ServiceModel model = new ServiceModel();
                model.setId(service.getId());
                model.setName(service.getName());
                ServiceDeployRecord current = service.getCurrent();
                model.setStatus(current.getStatus());
                PackageInfoModel pack = (PackageInfoModel)BeanMapper.map((Object)current.getPack(), PackageInfoModel.class);
                if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
                    pack.setGpuType(current.getPack().getGpu().getChargeItem());
                }
                model.setPack(pack);
                model.setCost(pack.getCost());
                model.setInstance(current.getInstance());
                model.setCreatedAt(service.getCreatedAt());
                model.setRemark(current.getRemark());
                model.setSeq(current.getGuid());
                model.setUserId(service.getUser().getId());
                model.setUsername(service.getUser().getUsername());
                model.setFullName(service.getUser().getName() == null ? service.getUser().getUsername() : service.getUser().getName());
                DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(service.getUser(), dep);
                if (resourceDepUser != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                long second = 0L;
                List durations = this.referDurationRepository.findByReferenceAndReferType(service.getId(), Integer.valueOf(2));
                if (!CollectionUtils.isEmpty((Collection)durations)) {
                    for (ReferDuration duration : durations) {
                        second += Optional.ofNullable(duration.getEnd()).orElse(new Date()).getTime() - duration.getStart().getTime();
                    }
                }
                model.setCallState(k8sFactory.requestSuccess(current.getGuid()) + "/" + k8sFactory.requestTotal(current.getGuid()));
                model.setDuration(TimeUtil.duration((Long)(second / 1000L)));
                try {
                    Date fireTime;
                    TriggerKey triggerKey;
                    if (current.getDuration() != null && !StringUtils.isEmpty((Object)current.getInference()) && this.scheduler.checkExists(triggerKey = TriggerKey.triggerKey((String)current.getInference())) && (fireTime = this.scheduler.getTrigger(triggerKey).getNextFireTime()) != null) {
                        long min = (fireTime.getTime() - org.joda.time.Instant.now().getMillis()) / 60000L;
                        if (min > 0L) {
                            model.setRestTime(this.messageUtil.getMessage("msg.stop.after", new String[]{String.valueOf(min)}));
                        } else if (min == 0L) {
                            model.setRestTime(this.messageUtil.getMessage("msg.stop.in", new String[]{"1"}));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                String errorMessage = current.getErrorMessage();
                if (current.getStatus() != 2) {
                    model.setErrorMessage(errorMessage);
                }
                models.add(model);
            }
            res.setList(models);
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u8be6\u60c5")
    @Transactional
    @RequestMapping(value={"/api/service/{id}"}, method={RequestMethod.GET})
    public ServiceResponse service(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        Date fireTime;
        TriggerKey triggerKey;
        ServiceResponse res = new ServiceResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.service.not.exist"));
            return res;
        }
        DepUsers depOwner = this.depUsersRepository.findByUserAndDepartment(user, service.getDepartment());
        Integer userType = 3;
        if (depOwner != null) {
            userType = depOwner.getType();
        }
        if (!userId.equals(service.getUser().getId()) && userType == 3) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        ServiceDeployRecord current = service.getCurrent();
        res.setInstance(current.getInstance());
        res.setRemark(current.getRemark());
        res.setStartedAt(current.getStartedAt());
        res.setUsername(service.getUser().getUsername());
        res.setFullName(service.getUser().getName() == null ? service.getUser().getUsername() : service.getUser().getName());
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(service.getUser(), dep);
        if (depUsers != null) {
            res.setCreatorQuited(Integer.valueOf(0));
        } else {
            res.setCreatorQuited(Integer.valueOf(1));
        }
        res.setGuid(current.getGuid());
        res.setId(service.getId());
        res.setName(service.getName());
        res.setStatus(current.getStatus());
        res.setSeq(current.getGuid().substring(0, 12));
        res.setCreatedAt(service.getCreatedAt());
        ModelVersion modelVersion = current.getModelVersion();
        res.setModel(modelVersion.getName() + ":" + modelVersion.getVersion());
        res.setImage(current.getImage());
        Double money = this.paymentRepository.sumByResourceIdAndTypeAndUser(service.getId(), Integer.valueOf(3), service.getUser());
        res.setCost(money);
        PackageInfoModel pack = (PackageInfoModel)BeanMapper.map((Object)current.getPack(), PackageInfoModel.class);
        if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
            pack.setGpuType(current.getPack().getGpu().getChargeItem());
        }
        res.setPack(pack);
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        long second = 0L;
        List durations = this.referDurationRepository.findByReferenceAndReferType(service.getId(), Integer.valueOf(2));
        if (!CollectionUtils.isEmpty((Collection)durations)) {
            for (ReferDuration duration : durations) {
                second += Optional.ofNullable(duration.getEnd()).orElse(new Date()).getTime() - duration.getStart().getTime();
            }
        }
        res.setCallState(k8sFactory.requestSuccess(current.getGuid()) + "/" + k8sFactory.requestTotal(current.getGuid()));
        res.setDuration(TimeUtil.duration((Long)(second / 1000L)));
        if (current.getDuration() != null && this.scheduler.checkExists(triggerKey = TriggerKey.triggerKey((String)current.getInference())) && (fireTime = this.scheduler.getTrigger(triggerKey).getNextFireTime()) != null) {
            long min = (fireTime.getTime() - org.joda.time.Instant.now().getMillis()) / 60000L;
            if (min > 0L) {
                res.setRestTime(this.messageUtil.getMessage("msg.stop.after", new String[]{String.valueOf(min)}));
            } else if (min == 0L) {
                res.setRestTime(this.messageUtil.getMessage("msg.stop.in", new String[]{"1"}));
            }
        }
        res.setToken(current.getToken());
        V1Service ingressSvc = k8sFactory.coreV1Api.readNamespacedService("istio-ingressgateway", "istio-system", null, null, null);
        List ports = ingressSvc.getSpec().getPorts();
        Optional<V1ServicePort> port = ports.stream().filter(p -> "http2".equals(p.getName())).findFirst();
        port.ifPresent(p -> res.setUrl("k8s/" + p.getNodePort() + "/v1/models/" + current.getInference() + ":predict"));
        res.setHost(current.getInference() + "-" + current.getGuid() + ".example.com");
        res.setLogContainer("kserve-container");
        return res;
    }

    @ApiOperation(value="\u5b9e\u65f6\u76d1\u63a7")
    @Transactional
    @GetMapping(value={"api/service/{id}/metrics"})
    public ListResultResponse<InstantMetricModel> metric(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        ServiceDeployRecord current;
        String namespace;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.service.not.exist"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List podList = k8sFactory.listPods(namespace = (current = service.getCurrent()).getGuid());
        if (null != podList && podList.size() > 0) {
            ArrayList<InstantMetricModel> models = new ArrayList<InstantMetricModel>(podList.size());
            res.setList(models);
            PricePackage pack = current.getPack();
            block0: for (V1Pod pod : podList) {
                List containerStatuses = pod.getStatus().getContainerStatuses();
                if (null == containerStatuses) continue;
                for (V1ContainerStatus status : containerStatuses) {
                    if (!"kserve-container".equals(status.getName()) || !status.getReady().booleanValue()) continue;
                    InstantMetricModel model = k8sFactory.podCpuMemoryUsage(pod.getMetadata().getName(), "kserve-container", pack.getCpuNum());
                    model.setGpuUsage(k8sFactory.podGpusMetrics(pod));
                    models.add(model);
                    continue block0;
                }
            }
        }
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.remove.service")
    @ApiOperation(value="\u5220\u9664\u670d\u52a1")
    @Transactional
    @RequestMapping(value={"/api/service"}, method={RequestMethod.PUT})
    public ResultResponse remove(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        List services = this.serviceRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        StringBuilder resourceNames = new StringBuilder();
        StringBuilder resourceGuids = new StringBuilder();
        for (Service resource : services) {
            resourceNames.append(",").append(resource.getName());
            resourceGuids.append(",").append(resource.getCurrent().getGuid());
        }
        if (resourceNames.length() > 1 && resourceGuids.length() > 1) {
            res.setEntity(resourceNames.substring(1));
            res.setGuid(resourceGuids.substring(1));
        }
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(null, null, "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!services.isEmpty()) {
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            for (Service service : services) {
                if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(service.getUser().getId()), (String)"service:delete", (Long)depId)) {
                    throw new MessageCodeException(null, null, "msg.account.unauthorized", new String[0]);
                }
                List deployRecords = this.serviceDeployRecordRepository.findByServiceIdAndDeleted(service.getId(), Integer.valueOf(0));
                for (ServiceDeployRecord record : deployRecords) {
                    this.stopTrigger(record.getInference());
                    k8sFactory.deleteNamespace(record.getGuid());
                    record.setDeleted(Integer.valueOf(1));
                    this.podPrePostHandler(service.getId(), record.getGuid(), k8sFactory);
                }
                service.setDeleted(Integer.valueOf(1));
            }
        }
        return res;
    }

    @Transactional
    public void deleteK8sInferenceService(Long serviceId) throws ApiException {
        Service service = (Service)this.serviceRepository.findOne((Serializable)serviceId);
        List deployRecords = this.serviceDeployRecordRepository.findByServiceIdAndDeleted(serviceId, Integer.valueOf(0));
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)service.getDomain().getId());
        for (ServiceDeployRecord record : deployRecords) {
            record.setStatus(Integer.valueOf(-2));
            record.setErrorMessage(null);
            try {
                this.podPrePostHandler(service.getId(), record.getGuid(), k8sFactory);
            }
            catch (ApiException e) {
                logger.info("deleteK8sInferenceService-0:{}", (Object)e.getResponseBody());
            }
            this.stopTrigger(record.getInference());
            try {
                k8sFactory.deletePods(record.getGuid());
                k8sFactory.inferenceServiceApi.delete(record.getGuid(), record.getInference(), K8sFactory.DELETE_OPTIONS);
            }
            catch (Exception e) {
                logger.info("deleteK8sInferenceService-1:{}", (Object)e.getMessage());
            }
        }
    }

    public void stopTrigger(String triggerName) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName);
            if (this.scheduler.checkExists(triggerKey)) {
                this.scheduler.unscheduleJob(triggerKey);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @LogAnnotation(type=5, msgExpression="msg.stop.service")
    @ApiOperation(value="\u505c\u6b62\u670d\u52a1")
    @Transactional
    @RequestMapping(value={"/api/service/{id}/stop"}, method={RequestMethod.PUT})
    public ResultResponse stop(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            throw new MessageCodeException(null, null, "msg.service.not.exist", new String[0]);
        }
        res.setEntity(service.getName());
        ServiceDeployRecord current = service.getCurrent();
        current.setStopAt(new Date());
        res.setGuid(current.getGuid());
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.domain.is.necessary", new String[0]);
        }
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(service.getUser().getId()), (String)"service:start", (Long)depId)) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        this.deleteK8sInferenceService(id);
        return res;
    }

    public void podPrePostHandler(Long service, String guid, K8sFactory k8sFactory) throws ApiException {
        Date now = new Date();
        List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(service, Integer.valueOf(3));
        if (null != materials) {
            for (Materials material : materials) {
                material.setLastedAt(now);
                material.setOperation(null);
            }
        }
        int call_success = k8sFactory.requestSuccess(guid);
        int call_total = k8sFactory.requestTotal(guid);
        List durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(service, Integer.valueOf(2));
        if (durations != null) {
            for (ReferDuration duration : durations) {
                duration.setEnd(now);
                if (null == duration.getRequestSuccess()) {
                    duration.setRequestSuccess(Integer.valueOf(call_success));
                }
                if (null != duration.getRequestTotal()) continue;
                duration.setRequestTotal(Integer.valueOf(call_total));
            }
        }
    }

    @LogAnnotation(type=5, msgExpression="msg.start.service")
    @ApiOperation(value="\u542f\u52a8\u670d\u52a1")
    @Transactional
    @RequestMapping(value={"/api/service/{id}/start"}, method={RequestMethod.PUT})
    public ResultResponse start(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException, InterruptedException {
        DepQuotas depQuotas;
        Double balance;
        ResultResponse res = new ResultResponse();
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            throw new MessageCodeException(null, null, "msg.service.not.exist", new String[0]);
        }
        res.setEntity(service.getName());
        res.setGuid(service.getCurrent().getGuid());
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers currentUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (!DepartmentController.isMemberDepPermission((Integer)currentUsers.getType(), (Boolean)userId.equals(service.getUser().getId()), (String)"service:start", (Long)depId)) {
            throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.account.unauthorized", new String[0]);
        }
        Organization org = dep.getOrgConfig().getOrganization();
        ServiceDeployRecord current = service.getCurrent();
        if (current.getPack().getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.org.balance.insufficient", new String[0]);
        }
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(service.getUser().getId(), depId);
        if (depUsers != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId)) && null != depQuotas.getModelTime() && depQuotas.getModelTime() != -1.0) {
            Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(2), service.getUser().getId(), depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
            if (rUserDuration == null) {
                rUserDuration = 0L;
            }
            if ((double)rUserDuration.longValue() >= depQuotas.getModelTime() * 60.0 * 60.0) {
                String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
                for (OrgConfig config : org.getOrgConfigs()) {
                    if (1 != config.getLevel()) continue;
                    depName = config.getName();
                    break;
                }
                throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.dep.resource.time.insufficient.error", new String[]{depName});
            }
        }
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(service.getDomain()).organization(org).department(dep).user(service.getUser()).name(service.getName()).guid(current.getGuid()).pack(current.getPack()).replica(current.getInstance()).priority(Integer.valueOf(0)).operate("start").build();
        this.commonService.judgeResource(identityDto);
        this.commonService.judgeSysResource(identityDto);
        current.setStatus(Integer.valueOf(1));
        current.setErrorMessage(null);
        this.inferenceService.doInferenceService(current, FactoryCollection.k8sFactory((Long)domainId), Boolean.valueOf(true));
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u57fa\u672c\u4fe1\u606f")
    @Transactional
    @RequestMapping(value={"/api/service/{id}/info"}, method={RequestMethod.GET})
    public ServiceBaseInfoResponse serviceBaseInfo(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id) {
        ServiceBaseInfoResponse res = new ServiceBaseInfoResponse();
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.service.not.exist"));
            return res;
        }
        res.setId(service.getId());
        res.setName(service.getName());
        ServiceDeployRecord current = service.getCurrent();
        res.setInstance(current.getInstance());
        res.setModel(current.getModelVersion().getName());
        res.setModelId(current.getModelVersion().getModel().getId());
        res.setModelVersion(current.getModelVersion().getVersion());
        res.setModelVersionId(current.getModelVersion().getId());
        res.setRemark(current.getRemark());
        res.setPack((PackageInfoModel)BeanMapper.map((Object)current.getPack(), PackageInfoModel.class));
        res.setDuration(current.getDuration());
        res.setInferenceCode(current.getCode());
        res.setImage(current.getImage());
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.get.service.code")
    @ApiOperation(value="\u83b7\u53d6\u63a8\u7406\u811a\u672c\u4ee3\u7801-v3.4\u65b0\u589e")
    @Transactional
    @RequestMapping(value={"/api/service/{id}/code"}, method={RequestMethod.GET})
    public InferenceCodeResponse getCode(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id) {
        InferenceCodeResponse res = new InferenceCodeResponse();
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            throw new MessageCodeException(null, null, "msg.service.not.exist", new String[0]);
        }
        ServiceDeployRecord current = service.getCurrent();
        res.setEntity(service.getName());
        res.setGuid(current.getGuid());
        res.setInferCode(current.getCode());
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.update.service.code")
    @ApiOperation(value="\u66f4\u65b0\u63a8\u7406\u811a\u672c-v3.4\u65b0\u589e")
    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/api/service/{id}/code"}, method={RequestMethod.PUT})
    public ResultResponse updateCode(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, @RequestBody @Valid InferenceCodeRequest code, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            throw new MessageCodeException(null, null, "msg.service.not.exist", new String[0]);
        }
        ServiceDeployRecord current = service.getCurrent();
        res.setEntity(service.getName());
        res.setGuid(current.getGuid());
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        Long depId = (Long)session.getAttribute("departmentId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, department);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(service.getUser().getId()), (String)"service:upload", (Long)depId)) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        try {
            String guid = UUID.randomUUID().toString().replace("-", "");
            ServiceDeployRecord record = new ServiceDeployRecord();
            BeanUtils.copyProperties((Object)current, (Object)record);
            record.setInference("isvc" + guid.substring(0, 8));
            record.setToken(this.inferenceService.genJwt(guid));
            record.setId(null);
            record.setStatus(Integer.valueOf(1));
            record.setErrorMessage(null);
            record.setGuid(guid);
            record.setDeleted(Integer.valueOf(0));
            record.setCode(code.getCode());
            this.serviceDeployRecordRepository.save((Object)record);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            service.setCurrent(record);
            List deployRecords = this.serviceDeployRecordRepository.findByServiceIdAndDeletedAndIdNot(service.getId(), Integer.valueOf(0), record.getId());
            for (ServiceDeployRecord sdr : deployRecords) {
                this.stopTrigger(sdr.getInference());
                k8sFactory.deleteNamespace(sdr.getGuid());
                sdr.setDeleted(Integer.valueOf(1));
                this.podPrePostHandler(service.getId(), sdr.getGuid(), k8sFactory);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), e.getCause());
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.modelservice.code.update.error", new String[0]);
        }
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.edit.service")
    @ApiOperation(value="\u4fee\u6539\u670d\u52a1")
    @Transactional
    @RequestMapping(value={"/api/service/{id}/edit"}, method={RequestMethod.PUT})
    public ResultResponse edit(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, @RequestBody @Valid ServiceRequest dto, HttpServletRequest request) throws ApiException, InterruptedException {
        ServiceDeployRecord record2;
        Double balance;
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        res.setEntity(dto.getName());
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            throw new MessageCodeException(null, null, "msg.service.not.exist", new String[0]);
        }
        ServiceDeployRecord current = service.getCurrent();
        res.setGuid(current.getGuid());
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(service.getUser().getId()), (String)"service:edit", (Long)depId)) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.account.unauthorized", new String[0]);
        }
        Integer count = this.serviceRepository.countByNameAndDepartmentIdAndDomainIdAndDeletedAndIdNot(dto.getName(), depId, domainId, Integer.valueOf(0), service.getId());
        if (count > 0) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.service.name.exist", new String[0]);
        }
        Organization org = dep.getOrgConfig().getOrganization();
        PricePackage pack = this.pricePackageRepository.findByIdAndStatusAndDeleted(dto.getPack(), Integer.valueOf(1), Integer.valueOf(0));
        if (null == pack) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.package.not.available", new String[0]);
        }
        if (pack.getCost() > 0.0 && (null == org.getFree() || org.getFree() != 1) && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            throw new MessageCodeException(service.getName(), current.getGuid(), "msg.org.balance.insufficient", new String[0]);
        }
        ResourceIdentityDto identityDto = ResourceIdentityDto.builder().domain(service.getDomain()).organization(org).department(dep).user(service.getUser()).name(dto.getName()).guid(current.getGuid()).pack(current.getPack()).replica(current.getInstance()).priority(Integer.valueOf(0)).build();
        if (current.getStatus() == 1 || current.getStatus() == 2) {
            this.commonService.judgeScaleResource(identityDto, pack, dto.getInstance());
        } else {
            this.commonService.judgeResource(identityDto);
        }
        this.inferenceService.judgeSysScaleResource(service.getDomain(), current.getGuid(), current.getPack(), pack, dto.getInstance());
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List deployRecords = this.serviceDeployRecordRepository.findByServiceIdAndDeleted(service.getId(), Integer.valueOf(0));
        for (ServiceDeployRecord record2 : deployRecords) {
            this.stopTrigger(record2.getInference());
            k8sFactory.deleteNamespace(record2.getGuid());
            record2.setDeleted(Integer.valueOf(1));
            this.podPrePostHandler(service.getId(), record2.getGuid(), k8sFactory);
        }
        String guid = UUID.randomUUID().toString().replace("-", "");
        service.setName(dto.getName());
        record2 = new ServiceDeployRecord();
        ModelVersion modelVersion = this.modelVersionRepository.findByIdAndDeleted(dto.getModelVersionId(), Integer.valueOf(0));
        record2.setModelVersion(modelVersion);
        record2.setDuration(dto.getDuration());
        record2.setInstance(dto.getInstance());
        record2.setPack(pack);
        record2.setStatus(Integer.valueOf(1));
        record2.setErrorMessage(null);
        record2.setRemark(dto.getRemark());
        record2.setService(service);
        record2.setGuid(guid);
        record2.setInference("isvc" + guid.substring(0, 8));
        record2.setToken(this.inferenceService.genJwt(guid));
        record2.setDeleted(Integer.valueOf(0));
        record2.setCode(dto.getCode());
        record2.setProtocol(dto.getProtocol());
        record2.setType(dto.getType());
        record2.setImage(FactoryCollection.harborDomain((Long)domainId) + "/" + dto.getImage());
        this.serviceDeployRecordRepository.save((Object)record2);
        service.setCurrent(record2);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.update.name")
    @ApiOperation(value="\u4fee\u6539\u670d\u52a1\u540d\u79f0")
    @Transactional
    @RequestMapping(value={"/api/service/{id}/{name}"}, method={RequestMethod.PUT})
    public ServiceResponse update(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, @ApiParam(value="\u670d\u52a1\u65b0\u540d\u79f0") @PathVariable(value="name") String name, HttpServletRequest request) throws Exception {
        OrgConfigDepartment dep;
        ServiceResponse res = new ServiceResponse();
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.service.not.exist"));
            return res;
        }
        res.setEntity(service.getName());
        res.setEntity(service.getCurrent().getGuid());
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.domain.is.necessary", new String[0]);
        }
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.account.dep.unauthenticated", new String[0]);
        }
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(service.getUser().getId()), (String)"service:name", (Long)depId)) {
            throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.account.unauthorized", new String[0]);
        }
        Integer count = this.serviceRepository.countByNameAndDepartmentIdAndDomainIdAndDeletedAndIdNot(name, depId, Long.valueOf(Long.parseLong(domainId)), Integer.valueOf(0), service.getId());
        if (count > 0) {
            throw new MessageCodeException(service.getName(), service.getCurrent().getGuid(), "msg.service.name.exist", new String[0]);
        }
        service.setName(name);
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.update.remark")
    @ApiOperation(value="\u4fee\u6539\u670d\u52a1\u5907\u6ce8")
    @Transactional
    @RequestMapping(value={"/api/service/remark"}, method={RequestMethod.PUT})
    public ServiceResponse updateRemark(@RequestBody @Valid RemarkUpdateRequest dto, HttpServletRequest request) {
        ServiceResponse res = new ServiceResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            throw new MessageCodeException(null, null, "msg.account.unauthenticated", new String[0]);
        }
        Service service = this.serviceRepository.findByIdAndDeleted(dto.getId(), Integer.valueOf(0));
        if (null == service) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.service.not.exist"));
            return res;
        }
        ServiceDeployRecord current = service.getCurrent();
        current.setRemark(dto.getRemark());
        res.setEntity(service.getName());
        res.setGuid(current.getGuid());
        return res;
    }

    @ApiOperation(value="\u6a21\u578b\u670d\u52a1\u65e5\u5fd7", notes="v3.3\u4fee\u6539\u63a5\u53e3\u4f20\u53c2-\u65b0\u589e\u53c2\u6570scrollId")
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/service/{id}/log"})
    public LogResponse log(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, @RequestBody LogSearchRequest dto, HttpServletRequest request) throws ApiException, IOException {
        LogResponse res = new LogResponse();
        RequestContext context = new RequestContext(request);
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.service.not.exist"));
            return res;
        }
        try {
            ServiceDeployRecord current = service.getCurrent();
            Date start = Optional.ofNullable(current.getCreatedAt()).orElse(dto.getStart());
            Date end = Optional.ofNullable(current.getStopAt()).orElse(dto.getEnd());
            if (dto.getStart() != null) {
                Date date = start = start.after(dto.getStart()) ? start : dto.getStart();
            }
            if (dto.getEnd() != null) {
                end = end.before(dto.getEnd()) ? new Date(end.getTime() + 3600000L) : dto.getEnd();
            }
            long domain = Long.parseLong(request.getHeader("domain"));
            res = ElasticsearchUtils.query((Long)domain, (String)current.getGuid(), (String)"kserve-container", (String)dto.getKeyword(), (Date)start, (Date)end, (String)dto.getScrollId(), (Integer)dto.getSize());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            res.setCode(Constants.SC_MSG);
            res.setMessage(context.getMessage("msg.service.log.error"));
        }
        return res;
    }

    @LogAnnotation(type=5, msgExpression="msg.download.log")
    @ApiOperation(value="\u6a21\u578b\u670d\u52a1\u65e5\u5fd7\u4e0b\u8f7d")
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/service/{id}/log/download"})
    public LogResponse logDownload(@ApiParam(value="\u670d\u52a1id") @PathVariable(value="id") Long id, @RequestBody LogSearchRequest dto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LogResponse res = new LogResponse();
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            throw new MessageCodeException(null, null, "msg.service.not.exist", new String[0]);
        }
        res.setEntity(service.getName());
        ServiceDeployRecord current = service.getCurrent();
        res.setGuid(current.getGuid());
        Date start = Optional.ofNullable(current.getCreatedAt()).orElse(dto.getStart());
        Date end = Optional.ofNullable(current.getStopAt()).orElse(dto.getEnd());
        if (dto.getStart() != null) {
            Date date = start = start.after(dto.getStart()) ? start : dto.getStart();
        }
        if (dto.getEnd() != null) {
            end = end.before(dto.getEnd()) ? new Date(end.getTime() + 3600000L) : dto.getEnd();
        }
        ElasticsearchUtils.downloadLog((HttpServletRequest)request, (HttpServletResponse)response, (String)res.getGuid(), (String)"kserve-container", (String)res.getEntity(), (Date)start, (Date)end);
        return res;
    }

    @ApiOperation(value="\u914d\u7f6e\u8bb0\u5f55")
    @Transactional(readOnly=true)
    @GetMapping(value={"api/service/{id}/history"})
    public ServiceDeployRecordResponse history(@PathVariable(value="id") Long id, HttpServletRequest request) {
        ServiceDeployRecordResponse res = new ServiceDeployRecordResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Service service = this.serviceRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == service) {
            res.setCode(Constants.SC_REDIRECT);
            res.setMessage(this.messageUtil.getMessage("msg.service.not.exist"));
            return res;
        }
        ServiceDeployRecord current = service.getCurrent();
        ModelVersion modelVersion = current.getModelVersion();
        res.setModelName(modelVersion.getName());
        res.setModelVersionId(modelVersion.getId());
        res.setModelVersion(modelVersion.getVersion());
        res.setInstance(current.getInstance());
        res.setStatus(current.getStatus());
        res.setModelId(modelVersion.getModel().getId());
        PackageInfoModel pack = (PackageInfoModel)BeanMapper.map((Object)current.getPack(), PackageInfoModel.class);
        if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
            pack.setGpuType(current.getPack().getGpu().getChargeItem());
        }
        res.setPack(pack);
        List deployRecords = service.getDeployRecords();
        if (null != deployRecords && deployRecords.size() > 0) {
            ArrayList<ServiceDeployRecordModel> models = new ArrayList<ServiceDeployRecordModel>();
            for (ServiceDeployRecord deployRecord : deployRecords) {
                ServiceDeployRecordModel model = new ServiceDeployRecordModel();
                ModelVersion version = deployRecord.getModelVersion();
                model.setModelName(version.getName());
                model.setModelVersionId(version.getId());
                model.setModelVersion(version.getVersion());
                model.setModelId(version.getModel().getId());
                model.setInstance(deployRecord.getInstance());
                model.setCreateAt(deployRecord.getStartedAt());
                model.setStatus(deployRecord.getStatus());
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)deployRecord.getPack(), PackageInfoModel.class);
                if (null != packageInfoModel.getGpuNum() && packageInfoModel.getGpuNum() > 0) {
                    packageInfoModel.setGpuType(deployRecord.getPack().getGpu().getChargeItem());
                }
                model.setPack(packageInfoModel);
                models.add(model);
            }
            res.setHistory(models);
        }
        return res;
    }

    @ApiOperation(value="\u6a21\u578b\u670d\u52a1-\u8d44\u6e90\u662f\u5426\u53ef\u7528")
    @Transactional
    @RequestMapping(value={"/api/model/quota"}, method={RequestMethod.GET})
    public ResultResponse modelQuota(HttpServletRequest request) {
        DepQuotas depQuotas;
        Integer org_count;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domainId);
        if (null == orgQuotas) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (orgQuotas.getStatus() != 1) {
            res.setMessage(this.messageUtil.getMessage("msg.account.org.domain.disabled"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer model_limit = orgQuotas.getModelCount();
        if (null != model_limit && model_limit != -1 && (org_count = this.serviceRepository.countByDepOrganizationAndDeleted(org, Integer.valueOf(0))) >= model_limit) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.model.org.insufficient"));
            return res;
        }
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers != null && depUsers.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId))) {
            Integer user_count;
            String depName = this.messageUtil.getMessage("msg.dep").toLowerCase();
            for (OrgConfig config : org.getOrgConfigs()) {
                if (1 != config.getLevel()) continue;
                depName = config.getName();
                break;
            }
            if (null != depQuotas.getModelCount() && depQuotas.getModelCount() != -1 && null != (user_count = this.serviceRepository.countByDepartmentAndDeletedAndDomainAndUser(dep, Integer.valueOf(0), domain, user)) && user_count >= depQuotas.getModelCount()) {
                res.setMessage(this.messageUtil.getMessage("msg.dep.resource.insufficient.error", new String[]{depName}));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (null != depQuotas.getModelTime() && depQuotas.getModelTime() != -1.0) {
                Long rUserDuration = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(1), userId, depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
                if (rUserDuration == null) {
                    rUserDuration = 0L;
                }
                if ((double)rUserDuration.longValue() >= depQuotas.getModelTime() * 60.0 * 60.0) {
                    res.setMessage(this.messageUtil.getMessage("msg.dep.resource.time.insufficient.error", new String[]{depName}));
                    res.setCode(Constants.SC_MSG);
                    return res;
                }
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @Transactional
    public void schedule() {
        List services = this.serviceRepository.findSchedule();
        if (null != services && services.size() > 0) {
            ServiceDeployRecord current = null;
            for (Service svc : services) {
                try {
                    current = svc.getCurrent();
                    K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)svc.getDomain().getId());
                    String guid = current.getGuid();
                    List pods = k8sFactory.listPods(guid);
                    if (null != pods && !pods.isEmpty()) {
                        String phase = null;
                        OffsetDateTime startedAtLast = null;
                        block5: for (V1Pod pod : pods) {
                            phase = pod.getStatus().getPhase();
                            if (!"Running".equals(phase)) {
                                List conditions;
                                if (!probe.containsKey(guid) || (Integer)probe.get(guid) < 3) {
                                    probe.put(guid, probe.containsKey(guid) ? (Integer)probe.get(guid) + 1 : 1);
                                    break;
                                }
                                if (current.getStatus() != -9 && "Pending".equals(phase) && null != (conditions = pod.getStatus().getConditions()) && conditions.size() > 0) {
                                    for (V1PodCondition condition : conditions) {
                                        if (!"PodScheduled".equals(condition.getType()) || null == condition.getMessage() || !condition.getMessage().contains("Insufficient") && !condition.getMessage().contains("minAvailable") && !condition.getMessage().contains("fit failed")) continue;
                                        current.setStatus(Integer.valueOf(-9));
                                        current.setErrorMessage(condition.getMessage());
                                        break;
                                    }
                                }
                            }
                            probe.remove(guid);
                            List containerStatuses = pod.getStatus().getContainerStatuses();
                            if (null == containerStatuses) continue;
                            for (V1ContainerStatus containerStatus : containerStatuses) {
                                if (!containerStatus.getReady().booleanValue()) {
                                    V1ContainerStateWaiting waiting;
                                    V1ContainerState state;
                                    V1ContainerState v1ContainerState = state = containerStatus.getState() != null ? containerStatus.getState() : containerStatus.getLastState();
                                    if (state != null && (waiting = state.getWaiting()) != null) {
                                        String message;
                                        String string = message = StringUtils.isEmpty((Object)waiting.getReason()) ? waiting.getMessage() : waiting.getReason();
                                        if ("CrashLoopBackOff".equals(message) || "Error".equals(message) || "ImagePullBackOff".equals(message)) {
                                            try {
                                                String logs = k8sFactory.logs(pod.getMetadata().getName(), guid, "kserve-container");
                                                if (null != logs) {
                                                    message = message + "\n" + logs;
                                                }
                                            }
                                            catch (ApiException e) {
                                                logger.warn(e.getResponseBody());
                                            }
                                            current.setErrorMessage(message);
                                            current.setStatus(Integer.valueOf(-3));
                                        }
                                    }
                                    phase = null;
                                    continue block5;
                                }
                                OffsetDateTime startedAt = containerStatus.getState().getRunning().getStartedAt();
                                if (null != current.getStartedAt() && !startedAt.toInstant().isAfter(current.getStartedAt().toInstant())) {
                                    phase = null;
                                    continue;
                                }
                                if (null != startedAtLast && !startedAt.isAfter(startedAtLast)) continue;
                                startedAtLast = startedAt;
                                if (current.getStatus() != 2 || null != current.getStartedAt()) continue;
                                Instant startedInstant = startedAtLast.toInstant();
                                Date startTime = new Date(startedInstant.toEpochMilli());
                                current.setStartedAt(startTime);
                            }
                        }
                        if ("Running".equals(phase) && current.getStatus() != 2) {
                            ServiceDeployRecord record;
                            if (current.getStatus() == 3 && (null == (record = this.deployRecordRepository.findTopByServiceOrderByIdDesc(svc)) || record.getStatus() != 2 && record.getStatus() != -1)) continue;
                            current.setStatus(Integer.valueOf(2));
                            current.setErrorMessage(null);
                            User user = svc.getUser();
                            OrgConfigDepartment department = svc.getDepartment();
                            Instant startedInstant = startedAtLast.toInstant();
                            Date startTime = new Date(startedInstant.toEpochMilli());
                            Materials material = new Materials();
                            material.setResourceId(svc.getId());
                            material.setUser(user);
                            material.setDepartment(department);
                            material.setOrganization(department.getOrgConfig().getOrganization());
                            material.setType(Integer.valueOf(3));
                            material.setPackageType(Integer.valueOf(2));
                            material.setCostTime(startTime);
                            material.setCreatedAt(startTime);
                            material.setPack(current.getPack());
                            material.setResourceInstance(current.getInstance());
                            material.setDomain(svc.getDomain());
                            this.materialsRepository.save(material);
                            current.setStartedAt(startTime);
                            ReferDuration duration = new ReferDuration();
                            duration.setStart(startTime);
                            duration.setReference(svc.getId());
                            duration.setReferType(Integer.valueOf(2));
                            duration.setUser(user);
                            duration.setDepartment(svc.getDepartment());
                            duration.setDomain(svc.getDomain());
                            this.referDurationRepository.save((Object)duration);
                            if (current.getDuration() != null && current.getDuration() > 0) {
                                TriggerKey triggerKey;
                                JobKey jobKey = JobKey.jobKey((String)"inference");
                                if (!this.scheduler.checkExists(jobKey)) {
                                    JobDetail job = JobBuilder.newJob(InferenceServiceJob.class).withIdentity(jobKey).build();
                                    this.scheduler.addJob(job, true, true);
                                }
                                if (!this.scheduler.checkExists(triggerKey = TriggerKey.triggerKey((String)current.getInference()))) {
                                    Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).forJob("inference").usingJobData("service", svc.getId()).startAt(Date.from(startedInstant.plus(Duration.ofHours(current.getDuration().intValue())))).build();
                                    this.scheduler.scheduleJob(trigger);
                                }
                            }
                        }
                        probe.remove(guid);
                        continue;
                    }
                    if (probe.getOrDefault(guid, 0) > 10) {
                        probe.remove(guid);
                        current.setStatus(Integer.valueOf(-3));
                        String errorMessage = null;
                        CoreV1EventList coreV1EventList = FactoryCollection.k8sFactory((Long)current.getService().getDomain().getId()).coreV1Api.listNamespacedEvent(guid, null, null, null, null, null, null, null, null, null, null);
                        if (null != coreV1EventList) {
                            List items = coreV1EventList.getItems();
                            for (int i = items.size() - 1; i >= 0; --i) {
                                CoreV1Event event = (CoreV1Event)items.get(i);
                                if (!event.getType().contains("Warning")) continue;
                                errorMessage = event.getMessage();
                                break;
                            }
                        }
                        if (null == errorMessage) {
                            errorMessage = this.messageSource.getMessage("msg.service.deploy.failed", null, null);
                        }
                        current.setErrorMessage(errorMessage);
                        continue;
                    }
                    probe.put(guid, probe.getOrDefault(guid, 0) + 1);
                }
                catch (Exception e) {
                    logger.info("schedule-0", (Throwable)e);
                    if (null == current) continue;
                    current.setErrorMessage(e.getMessage());
                }
            }
        }
    }

    @ConstructorProperties(value={"userRepository", "orgConfigDepartmentRepository", "serviceRepository", "balancesRepository", "pricePackageRepository", "systemConfigRepository", "paymentRepository", "materialsRepository", "deployRecordRepository", "depUsersRepository", "domainRepository", "organizationQuotasRepository", "referDurationRepository", "depQuotasRepository", "modelVersionRepository", "jwtRepository", "scheduler", "commonService", "serviceDeployRecordRepository", "messageSource", "messageUtil", "inferenceService"})
    public ServiceController(UserRepository userRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, ServiceRepository serviceRepository, BalancesRepository balancesRepository, PricePackageRepository pricePackageRepository, SystemConfigRepository systemConfigRepository, PaymentRepository paymentRepository, MaterialsRepository materialsRepository, ServiceDeployRecordRepository deployRecordRepository, DepUsersRepository depUsersRepository, DomainRepository domainRepository, OrganizationQuotasRepository organizationQuotasRepository, ReferDurationRepository referDurationRepository, DepQuotasRepository depQuotasRepository, ModelVersionRepository modelVersionRepository, JwtRepository jwtRepository, Scheduler scheduler, CommonService commonService, ServiceDeployRecordRepository serviceDeployRecordRepository, MessageSource messageSource, MessageUtil messageUtil, InferenceService inferenceService) {
        this.userRepository = userRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.serviceRepository = serviceRepository;
        this.balancesRepository = balancesRepository;
        this.pricePackageRepository = pricePackageRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.paymentRepository = paymentRepository;
        this.materialsRepository = materialsRepository;
        this.deployRecordRepository = deployRecordRepository;
        this.depUsersRepository = depUsersRepository;
        this.domainRepository = domainRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.referDurationRepository = referDurationRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.modelVersionRepository = modelVersionRepository;
        this.jwtRepository = jwtRepository;
        this.scheduler = scheduler;
        this.commonService = commonService;
        this.serviceDeployRecordRepository = serviceDeployRecordRepository;
        this.messageSource = messageSource;
        this.messageUtil = messageUtil;
        this.inferenceService = inferenceService;
    }
}

