/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.api.client.util.Lists;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.EncodeUtil;
import com.mopaas.server.common.HashUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.controller.StorageController;
import com.mopaas.server.dao.AnnotationRepository;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUserQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.ExperimentRepository;
import com.mopaas.server.dao.JobStorageRepository;
import com.mopaas.server.dao.MLabProjectRepository;
import com.mopaas.server.dao.MLabProjectStorageRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.ModelVersionRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.PaymentRepository;
import com.mopaas.server.dao.PriceRepository;
import com.mopaas.server.dao.ResourceStorageRepository;
import com.mopaas.server.dao.ServiceRepository;
import com.mopaas.server.dao.StorageDeptRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.entity.Annotation;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUserQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.Experiment;
import com.mopaas.server.entity.Job;
import com.mopaas.server.entity.JobStorage;
import com.mopaas.server.entity.JobVersion;
import com.mopaas.server.entity.MLabProject;
import com.mopaas.server.entity.MLabProjectStorage;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.ModelVersion;
import com.mopaas.server.entity.OrgConfig;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.Price;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.Resource;
import com.mopaas.server.entity.ResourceStorage;
import com.mopaas.server.entity.Service;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.StorageDept;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.User;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.model.request.IdsRequest;
import com.mopaas.server.model.request.PathRequest;
import com.mopaas.server.model.request.StorageCapacityRequest;
import com.mopaas.server.model.request.StorageNameRequest;
import com.mopaas.server.model.request.StoragePwdRequest;
import com.mopaas.server.model.request.StorageRequest;
import com.mopaas.server.model.request.StorageSortPageRequest;
import com.mopaas.server.model.response.BoundResourceModel;
import com.mopaas.server.model.response.DataSetCapacityResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.ObjectResponse;
import com.mopaas.server.model.response.PackageInfoModel;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.StorageInfoResponse;
import com.mopaas.server.model.response.StorageModel;
import com.mopaas.server.model.response.StorageMountModel;
import com.mopaas.server.model.response.StorageMountResponse;
import com.mopaas.server.model.response.StorageMountsModel;
import com.mopaas.server.model.response.StorageTypeResponse;
import com.mopaas.server.model.response.UploadFileResponse;
import com.mopaas.server.service.StorageService;
import io.kubernetes.client.Exec;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1StorageClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5b58\u50a8\u670d\u52a1"})
@RestController
public class StorageController {
    final StorageRepository storageRepository;
    final MaterialsRepository materialsRepository;
    final SystemConfigRepository systemConfigRepository;
    final UserRepository userRepository;
    final BalancesRepository balancesRepository;
    final PaymentRepository paymentRepository;
    final StorageDeptRepository storageDeptRepository;
    final OrgConfigDepartmentRepository departmentRepository;
    final PriceRepository priceRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final DepUsersRepository depUsersRepository;
    final DomainRepository domainRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final DepQuotasRepository depQuotasRepository;
    final MLabProjectRepository mLabProjectRepository;
    final AnnotationRepository annotationRepository;
    final ModelVersionRepository modelVersionRepository;
    final ServiceRepository serviceRepository;
    final DepUserQuotasRepository depUserQuotasRepository;
    final ResourceStorageRepository resourceStorageRepository;
    final JobStorageRepository jobStorageRepository;
    final StorageService storageService;
    final StorageServiceFactory storageServiceFactory;
    final MLabProjectStorageRepository mLabProjectStorageRepository;
    final ExperimentRepository experimentRepository;
    final MessageUtil messageUtil;
    private static final Logger logger = LoggerFactory.getLogger(StorageController.class);
    private static final String DEPLOY_NAME = "deploy-storage";
    private static final String STORAGE_MOUNT_PATH = "/var/www/html/data/User/admin/home/";
    List<String> fileTypes = Arrays.asList("py", "sh", "txt", "csv", "json", "md", "zip", "tar", "gz");

    @ApiOperation(value="\u83b7\u53d6\u53ef\u5206\u914d\u5bb9\u91cf")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/storage/capacity/remained"}, method={RequestMethod.GET})
    public DataSetCapacityResponse getCapacityRemained(@ApiParam(value="\u6269\u5bb9\u65f6\u4f20storage=id\u503c") @RequestParam(name="storage", required=false) Long storage, HttpServletRequest request) throws ApiException {
        DepUserQuotas userQuotas;
        DepUsers depUser;
        int depRemained;
        Integer depAllAllocated;
        int orgRemained;
        DataSetCapacityResponse res = new DataSetCapacityResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        Organization org = dep.getOrgConfig().getOrganization();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String depName = null;
        String memberName = null;
        for (OrgConfig config : org.getOrgConfigs()) {
            if (1 == config.getLevel()) {
                depName = config.getName();
                continue;
            }
            if (3 != config.getLevel()) continue;
            memberName = config.getName();
        }
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domainId);
        if (null == orgQuotas) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer allAllocated = this.storageRepository.sumQuotaAllocatedByOrgAndDomainId(org, domainId);
        if (null == allAllocated) {
            allAllocated = 0;
        }
        if ((orgRemained = orgQuotas.getStorage() == -1 ? -1 : Math.max(orgQuotas.getStorage() - allAllocated, 0)) != -1 && orgRemained <= 0) {
            res.setType(this.messageUtil.getMessage("msg.org"));
        }
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId);
        int depCapacity = -1;
        if (depQuotas != null && depQuotas.getStorage() != null) {
            int n = depCapacity = depQuotas.getStorage() == null ? -1 : depQuotas.getStorage();
        }
        if (null == (depAllAllocated = this.storageRepository.sumQuotaAllocatedByDepIdAndDomainId(depId, domainId))) {
            depAllAllocated = 0;
        }
        if ((depRemained = depCapacity == -1 ? -1 : Math.max(depCapacity - depAllAllocated, 0)) != -1 && depRemained <= 0) {
            res.setType(depName != null ? depName : this.messageUtil.getMessage("msg.dep"));
        }
        if (null != (depUser = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId)).getType() && depUser.getType() == 3 && null != (userQuotas = this.depUserQuotasRepository.findByUserAndDepartmentAndDomain(user, dep, domain))) {
            int userRemained;
            int storageQuota = userQuotas.getStorage() != null ? userQuotas.getStorage() : -1;
            Integer userAllAllocated = this.storageRepository.sumQuotaAllocatedByDepIdAndDomainAndUser(depId, domain, user);
            if (null == userAllAllocated) {
                userAllAllocated = 0;
            }
            if ((userRemained = storageQuota == -1 ? -1 : Math.max(storageQuota - userAllAllocated, 0)) != -1 && userRemained <= 0) {
                res.setType(memberName != null ? memberName : this.messageUtil.getMessage("msg.member"));
            }
            if (userRemained != -1 && depRemained != -1) {
                depRemained = Math.min(userRemained, depRemained);
            } else if (userRemained != -1) {
                depRemained = userRemained;
            }
        }
        long devRemained = this.storageServiceFactory.getSysCapacityRemained(FactoryCollection.k8sFactory((Long)domainId));
        if (null == res.getType() && devRemained != -1L && devRemained <= 0L) {
            res.setType(this.messageUtil.getMessage("msg.system"));
        }
        long capacity = orgRemained != -1 && depRemained != -1 ? Math.min(devRemained, (long)Math.min(orgRemained, depRemained)) : (orgRemained != -1 ? Math.min(devRemained, (long)orgRemained) : (depRemained != -1 ? Math.min(devRemained, (long)depRemained) : devRemained));
        res.setCapacity(Long.valueOf(capacity));
        Price price = this.priceRepository.findByTypeAndDomainId(Integer.valueOf(4), domainId);
        res.setPrice(price.getPrice());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u65b0\u5efa\u5b58\u50a8")
    @Transactional
    @RequestMapping(value={"/api/storage"}, method={RequestMethod.POST})
    public ResultResponse create(@RequestBody @Valid StorageRequest dto, HttpServletRequest request) throws ApiException {
        Integer userAllAllocated;
        int depRemained;
        Integer depAllAllocated;
        OrganizationQuotas orgQuotas;
        Double balance;
        ResultResponse res = new ResultResponse();
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceName", (Object)dto.getName());
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.unavailable"));
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        if (depUsers.getType() == 3 && !DepartmentController.isDepPermission((String)"storage:create", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(1);
        types.add(3);
        Integer count = this.storageRepository.countByNameAndDepartmentIdAndDeletedAndTypeIn(dto.getName(), depId, Integer.valueOf(0), types);
        if (null != count && count > 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.dep.storage.name.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.dep.storage.name.exist"));
            return res;
        }
        Price diskPrice = this.priceRepository.findByTypeAndDomainId(Integer.valueOf(4), domain.getId());
        Organization org = dep.getOrgConfig().getOrganization();
        if ((null == org.getFree() || org.getFree() != 1) && diskPrice.getPrice() > 0.0 && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.org.balance.insufficient"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.org.balance.insufficient"));
            return res;
        }
        Integer allAllocated = this.storageRepository.sumQuotaAllocatedByOrgAndDomainId(org, domain.getId());
        if (null == allAllocated) {
            allAllocated = 0;
        }
        if (null == (orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domainId))) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.resource.quota.unset"));
            return res;
        }
        if (orgQuotas.getStatus() != 1) {
            res.setMessage(this.messageUtil.getMessage("msg.account.org.domain.disabled"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.org.domain.disabled"));
            return res;
        }
        int orgRemained = orgQuotas.getStorage() == null || orgQuotas.getStorage() == -1 ? dto.getCapacity() : orgQuotas.getStorage() - allAllocated - dto.getCapacity();
        if (orgRemained < 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.org.insufficient"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.org.insufficient"));
            return res;
        }
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId);
        Integer depCapacity = -1;
        if (depQuotas != null && depQuotas.getStorage() != null) {
            depCapacity = depQuotas.getStorage();
        }
        if (null == (depAllAllocated = this.storageRepository.sumQuotaAllocatedByDepIdAndDomain(depId, domain))) {
            depAllAllocated = 0;
        }
        if ((depRemained = depCapacity == -1 ? dto.getCapacity() : depCapacity - depAllAllocated - dto.getCapacity()) < 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.dep.insufficient"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.dep.insufficient"));
            return res;
        }
        DepUserQuotas userQuotas = this.depUserQuotasRepository.findByUserAndDepartmentAndDomain(user, dep, domain);
        int depStorage = -1;
        if (null != depQuotas) {
            int n = depStorage = depQuotas.getStorage() != null ? depQuotas.getStorage() : -1;
        }
        if (null != userQuotas && depUsers.getType() == 3) {
            int storageQuota;
            int n = storageQuota = userQuotas.getStorage() != null ? userQuotas.getStorage() : -1;
            if (storageQuota != -1) {
                depStorage = depStorage == -1 ? storageQuota : Math.min(depStorage, storageQuota);
            }
        }
        if (null == (userAllAllocated = this.storageRepository.sumQuotaAllocatedByDepIdAndDomainAndUser(depId, domain, user))) {
            userAllAllocated = 0;
        }
        if (depStorage != -1 && dto.getCapacity() > depStorage - userAllAllocated) {
            res.setMessage(this.messageUtil.getMessage("msg.resource.range.illegal", new String[]{this.messageUtil.getMessage("msg.storage")}));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.range.illegal", new String[]{this.messageUtil.getMessage("msg.storage")}));
            return res;
        }
        long devRemained = this.storageServiceFactory.getSysCapacityRemained(FactoryCollection.k8sFactory((Long)domainId));
        if (devRemained < 0L) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.sys.insufficient"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.sys.insufficient"));
            return res;
        }
        String guid = UUID.randomUUID().toString().replace("-", "");
        request.setAttribute("resourceGuid", (Object)guid);
        this.storageService.createStorage(dto.getName(), guid, dto.getPassword(), dto.getCapacity(), ResourceIdentityDto.builder().user(user).department(dep).domain(domain).build());
        Storage storage = this.storageRepository.findByGuid(guid);
        if (storage.getStatus() != -1) {
            request.setAttribute("result", (Object)"true");
        }
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u5b58\u50a8")
    @Transactional
    @RequestMapping(value={"/api/storage/{id}"}, method={RequestMethod.PUT})
    public ResultResponse update(@PathVariable(value="id") Long id, @RequestBody @Valid StorageRequest dto, HttpServletRequest request) throws Exception {
        StorageNameRequest snr = new StorageNameRequest();
        snr.setName(dto.getName());
        ResultResponse res = this.updateName(id, snr, request);
        if (!res.getCode().equals(Constants.SC_OK)) {
            return res;
        }
        StorageCapacityRequest scr = new StorageCapacityRequest();
        scr.setCapacity(dto.getCapacity());
        res = this.updateCapacity(id, scr, request);
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u5b58\u50a8\u5bc6\u7801")
    @Transactional
    @RequestMapping(value={"/api/storage/pwd/{id}"}, method={RequestMethod.PUT})
    public ResultResponse updatePwd(@PathVariable(value="id") Long id, @RequestBody @Valid StoragePwdRequest dto, HttpServletRequest request) throws ApiException {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:password", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        if (!EncodeUtil.rawInput((String)storage.getPassword()).equals(dto.getPassword())) {
            V1Patch patch = new V1Patch("[{\"op\":\"replace\",\"path\":\"/spec/template/spec/containers/0/env\",\"value\":[{\"name\":\"SSH_PWD\",\"value\":\"" + dto.getPassword() + "\"},{\"name\":\"ADMIN_PWD\",\"value\":\"" + EncodeUtil.encodeHex((byte[])HashUtil.md5((String)dto.getPassword())).toLowerCase() + "\"}]}]");
            FactoryCollection.k8sFactory((Long)domainId).appsV1Api.patchNamespacedDeployment(DEPLOY_NAME, storage.getGuid(), patch, null, null, null, null);
            storage.setPassword(EncodeUtil.encodeBase64((byte[])dto.getPassword().getBytes(StandardCharsets.UTF_8)));
        }
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u96c6\u662f\u5426\u516c\u5f00")
    @Transactional
    @RequestMapping(value={"/api/storage/expose/{id}/{expose}"}, method={RequestMethod.PUT})
    public ResultResponse exposed(@PathVariable(value="id") Long id, @PathVariable(value="expose") @ApiParam(value="0:\u4e0d\u516c\u5f00;1:\u516c\u5f00") Integer expose, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        storage.setExposed(expose);
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u5b58\u50a8\u540d\u79f0")
    @Transactional
    @RequestMapping(value={"/api/storage/name/{id}"}, method={RequestMethod.PUT})
    public ResultResponse updateName(@PathVariable(value="id") Long id, @RequestBody @Valid StorageNameRequest dto, HttpServletRequest request) {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:name", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(1);
        types.add(3);
        Integer count = this.storageRepository.countByNameAndDepartmentIdAndDeletedAndIdNotAndTypeIn(dto.getName(), depId, Integer.valueOf(0), storage.getId(), types);
        if (null != count && count > 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.name.exist"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.name.exist"));
            return res;
        }
        storage.setName(dto.getName());
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u5b58\u50a8-\u6269\u5bb9")
    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/api/storage/capacity/{id}"}, method={RequestMethod.PUT})
    public ResultResponse updateCapacity(@PathVariable(value="id") Long id, @RequestBody @Valid StorageCapacityRequest dto, HttpServletRequest request) throws Exception {
        Double balance;
        Price diskPrice;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthenticated"));
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, department);
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:capacity", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.unauthorized"));
            return res;
        }
        if (storage.getStatus() == 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.applying"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.applying"));
            return res;
        }
        if (dto.getCapacity() < 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.capacity.less"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.capacity.less"));
            return res;
        }
        Organization org = department.getOrgConfig().getOrganization();
        if (org.getFree() != 1 && null != (diskPrice = this.priceRepository.findByTypeAndDomainId(Integer.valueOf(3), domain.getId())) && diskPrice.getPrice() > 0.0 && (null == (balance = this.balancesRepository.sumBalance(org, Integer.valueOf(0))) || balance <= 0.0)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.org.balance.insufficient"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.org.balance.insufficient"));
            return res;
        }
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomainId(org, domainId);
        if (null == orgQuotas) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.resource.quota.unset"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.domain.resource.quota.unset"));
            return res;
        }
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(department, domainId);
        DepUserQuotas userQuotas = this.depUserQuotasRepository.findByUserAndDepartmentAndDomain(user, department, domain);
        Integer userAllAllocated = this.storageRepository.sumQuotaAllocatedByDepIdAndDomainAndUser(depId, domain, user);
        if (null == userAllAllocated) {
            userAllAllocated = 0;
        }
        int depStorage = -1;
        if (null != depQuotas) {
            depStorage = depQuotas.getStorage() != null ? depQuotas.getStorage() : -1;
        }
        String depName = this.messageUtil.getMessage("msg.dep");
        String memberName = this.messageUtil.getMessage("msg.member");
        for (OrgConfig config : org.getOrgConfigs()) {
            if (1 == config.getLevel()) {
                depName = config.getName();
                continue;
            }
            if (3 != config.getLevel()) continue;
            memberName = config.getName();
        }
        if (null != userQuotas && depUsers.getType() == 3) {
            int storageQuota;
            int n = storageQuota = userQuotas.getStorage() != null ? userQuotas.getStorage() : -1;
            if (storageQuota != -1 && dto.getCapacity() > storageQuota - userAllAllocated + storage.getCapacity()) {
                res.setMessage(this.messageUtil.getMessage("msg.resource.range.illegal", new String[]{memberName + this.messageUtil.getMessage("msg.storage")}));
                res.setCode(Constants.SC_MSG);
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.range.illegal", new String[]{this.messageUtil.getMessage("msg.member") + this.messageUtil.getMessage("msg.storage")}));
                return res;
            }
        }
        if (depStorage != -1 && dto.getCapacity() > depStorage - userAllAllocated + storage.getCapacity()) {
            res.setMessage(this.messageUtil.getMessage("msg.resource.range.illegal", new String[]{depName + this.messageUtil.getMessage("msg.storage")}));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.range.illegal", new String[]{this.messageUtil.getMessage("msg.dep") + this.messageUtil.getMessage("msg.storage")}));
            return res;
        }
        int capacity = dto.getCapacity() + storage.getCapacity();
        int orgRemained = orgQuotas.getStorage() == null || orgQuotas.getStorage() == -1 ? capacity : orgQuotas.getStorage() - capacity;
        if (orgQuotas.getStorage() != -1 && orgRemained < 0) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.resource.range.illegal", new String[]{this.messageUtil.getMessage("msg.org") + this.messageUtil.getMessage("msg.storage")}));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.resource.range.illegal", new String[]{this.messageUtil.getMessage("msg.org") + this.messageUtil.getMessage("msg.storage")}));
            return res;
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        long devRemained = this.storageServiceFactory.getSysCapacityRemained(k8sFactory);
        if (devRemained - (long)dto.getCapacity().intValue() < 0L) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.sys.insufficient"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.sys.insufficient"));
            return res;
        }
        if (!storage.getCapacity().equals(capacity)) {
            storage.setStatus(Integer.valueOf(0));
            Date now = new Date();
            List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(storage.getId(), Integer.valueOf(2));
            if (null != materials && materials.size() > 0) {
                for (Materials material : materials) {
                    material.setLastedAt(now);
                    material.setOperation(null);
                }
            }
            this.storageServiceFactory.addCapacity(storage, Integer.valueOf(capacity), k8sFactory);
            storage.setCapacity(Integer.valueOf(capacity));
        }
        res.setCode(Constants.SC_OK);
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u5220\u9664\u5b58\u50a8")
    @Transactional
    @RequestMapping(value={"/api/storage/remove"}, method={RequestMethod.DELETE})
    public ResultResponse remove(@RequestBody @Valid IdsRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        List storages = this.storageRepository.findByIdInAndDeleted(dto.getIds(), Integer.valueOf(0));
        if (null == storages) {
            request.setAttribute("result", (Object)"true");
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        StringBuilder resourceNames = new StringBuilder();
        StringBuilder resourceGuids = new StringBuilder();
        for (Storage storage : storages) {
            resourceNames.append("," + storage.getName());
            resourceGuids.append("," + storage.getGuid());
        }
        if (resourceNames.length() > 1 && resourceGuids.length() > 1) {
            request.setAttribute("resourceName", (Object)String.valueOf(resourceNames).substring(1));
            request.setAttribute("resourceGuid", (Object)String.valueOf(resourceGuids).substring(1));
        }
        CoreV1Api coreV1Api = FactoryCollection.k8sFactory((Long)domainId).coreV1Api;
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        for (Storage storage : storages) {
            int referenced;
            if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:delete", (Long)depId)) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
                return res;
            }
            String guid = storage.getGuid();
            long id = storage.getId();
            List pods = coreV1Api.listPodForAllNamespaces(null, null, null, "pvc-" + guid + "=", null, null, null, null, null, null).getItems();
            if (!pods.isEmpty()) {
                referenced = 1;
            } else {
                referenced = this.storageRepository.referencedByResource(Long.valueOf(id));
                if (referenced < 1 && (referenced = this.storageRepository.referencedByService(Long.valueOf(id)).intValue()) < 1 && (referenced = this.storageRepository.referencedByJob(Long.valueOf(id)).intValue()) < 1) {
                    referenced = this.storageRepository.referencedByMlab(Long.valueOf(id));
                }
            }
            if (referenced > 0) {
                res.setCode(Constants.SC_MSG);
                res.setMessage(this.messageUtil.getMessage("msg.storage.del.used"));
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.del.used.error"));
                return res;
            }
            try {
                coreV1Api.deleteNamespace(guid, null, null, Integer.valueOf(0), null, "Foreground", null);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            Date now = new Date();
            List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(Long.valueOf(id), Integer.valueOf(2));
            if (null != materials && !materials.isEmpty()) {
                for (Materials material : materials) {
                    material.setLastedAt(now);
                    material.setOperation(null);
                }
            }
            storage.setDeleted(Integer.valueOf(1));
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b58\u50a8\u6302\u8f7d\u8be6\u60c5")
    @Transactional(readOnly=true)
    @PostMapping(value={"api/storage/{storage}/mounts"})
    public ListResultResponse<StorageMountsModel> mounts(@PathVariable(value="storage") Long id, HttpServletRequest request) {
        List mLabProjects;
        List annotations;
        List modelVersions;
        DepUsers depUsers;
        List jobStorages;
        StorageMountsModel model;
        ListResultResponse res = new ListResultResponse();
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        HttpSession session = request.getSession();
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        ArrayList<StorageMountsModel> models = new ArrayList<StorageMountsModel>();
        List resourceStorages = storage.getResourceStorages();
        if (null != resourceStorages && resourceStorages.size() > 0) {
            for (Object rs : resourceStorages) {
                Resource resource = rs.getResource();
                if (null != resource.getDeleted() && resource.getDeleted() == 1) continue;
                model = new StorageMountsModel();
                model.setId(resource.getId());
                model.setName(resource.getName());
                model.setType(Integer.valueOf(0));
                model.setCreatedAt(resource.getCreatedAt());
                model.setSeq(resource.getGuid());
                model.setUsername(resource.getUser().getUsername());
                model.setFullName(resource.getUser().getName() == null ? resource.getUser().getUsername() : resource.getUser().getName());
                DepUsers depUsers2 = this.depUsersRepository.findByUserAndDepartment(resource.getUser(), dep);
                if (depUsers2 != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                model.setStatus(resource.getStatus());
                PricePackage pack = resource.getPack();
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)pack, PackageInfoModel.class);
                if (pack.getGpuNum() != null && pack.getGpuNum() > 0) {
                    packageInfoModel.setGpuType(pack.getGpu().getChargeItem());
                }
                model.setResourcePackage(packageInfoModel);
                model.setReplicas(resource.getReplicas());
                models.add(model);
            }
        }
        if (null != (jobStorages = storage.getJobStorages()) && jobStorages.size() > 0) {
            for (JobStorage js : jobStorages) {
                JobVersion jobVersion = js.getJobVersion();
                Job job = jobVersion.getJob();
                if (null != job.getDeleted() && job.getDeleted() == 1 || null != jobVersion.getDeleted() && jobVersion.getDeleted() == 1) continue;
                model = new StorageMountsModel();
                model.setId(job.getId());
                model.setVersionId(jobVersion.getId());
                model.setName(job.getName());
                model.setType(Integer.valueOf(1));
                model.setCreatedAt(jobVersion.getCreatedAt());
                model.setSeq(jobVersion.getGuid());
                User owner = job.getUser();
                model.setUsername(owner.getUsername());
                model.setFullName(owner.getName() == null ? owner.getUsername() : owner.getName());
                depUsers = this.depUsersRepository.findByUserAndDepartment(owner, dep);
                if (depUsers != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                model.setStatus(jobVersion.getStatus());
                PricePackage resourcePackage = jobVersion.getPack();
                PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)resourcePackage, PackageInfoModel.class);
                if (resourcePackage.getGpuNum() != null && resourcePackage.getGpuNum() > 0) {
                    packageInfoModel.setGpuType(resourcePackage.getGpu().getChargeItem());
                }
                model.setResourcePackage(packageInfoModel);
                model.setVersion(jobVersion.getVersion());
                model.setReplicas(jobVersion.getReplicas());
                models.add(model);
                List experiments = this.experimentRepository.findByJobVersionAndDeleted(jobVersion, Integer.valueOf(0));
                if (CollectionUtils.isEmpty((Collection)experiments)) continue;
                for (Experiment experiment : experiments) {
                    model = new StorageMountsModel();
                    model.setId(experiment.getId());
                    model.setName(experiment.getName());
                    model.setType(Integer.valueOf(5));
                    model.setCreatedAt(experiment.getCreatedAt());
                    model.setSeq(experiment.getGuid());
                    owner = experiment.getUser();
                    model.setUsername(owner.getUsername());
                    model.setFullName(owner.getName() == null ? owner.getUsername() : owner.getName());
                    depUsers = this.depUsersRepository.findByUserAndDepartment(owner, dep);
                    if (depUsers != null) {
                        model.setCreatorQuited(Integer.valueOf(0));
                    } else {
                        model.setCreatorQuited(Integer.valueOf(1));
                    }
                    model.setStatus(experiment.getStatus());
                    model.setResourcePackage(packageInfoModel);
                    model.setVersion(jobVersion.getVersion());
                    model.setReplicas(jobVersion.getReplicas());
                    models.add(model);
                }
            }
        }
        if (null != (modelVersions = this.modelVersionRepository.findByModelPathStartsWithAndDeleted(storage.getId() + ":", Integer.valueOf(0))) && modelVersions.size() > 0) {
            for (Object modelVersion : modelVersions) {
                List services = this.serviceRepository.findByCurrentModelVersionAndDeleted((ModelVersion)modelVersion, Integer.valueOf(0));
                if ((services = services.stream().distinct().collect(Collectors.toList())).size() <= 0) continue;
                for (Service service : services) {
                    model = new StorageMountsModel();
                    model.setId(service.getId());
                    model.setName(service.getName());
                    model.setType(Integer.valueOf(2));
                    model.setCreatedAt(service.getCreatedAt());
                    model.setSeq(service.getCurrent().getGuid());
                    User owner = service.getUser();
                    model.setUsername(owner.getUsername());
                    model.setFullName(owner.getName() == null ? owner.getUsername() : owner.getName());
                    DepUsers depUsers3 = this.depUsersRepository.findByUserAndDepartment(owner, dep);
                    if (depUsers3 != null) {
                        model.setCreatorQuited(Integer.valueOf(0));
                    } else {
                        model.setCreatorQuited(Integer.valueOf(1));
                    }
                    model.setStatus(service.getCurrent().getStatus());
                    PricePackage resourcePackage = service.getCurrent().getPack();
                    PackageInfoModel packageInfoModel = (PackageInfoModel)BeanMapper.map((Object)resourcePackage, PackageInfoModel.class);
                    if (resourcePackage.getGpuNum() != null && resourcePackage.getGpuNum() > 0) {
                        packageInfoModel.setGpuType(resourcePackage.getGpu().getChargeItem());
                    }
                    model.setResourcePackage(packageInfoModel);
                    model.setReplicas(service.getCurrent().getInstance());
                    models.add(model);
                }
            }
        }
        if (null != (annotations = this.annotationRepository.findByStorageAndDeleted(storage, Integer.valueOf(0))) && annotations.size() > 0) {
            for (Annotation annotation : annotations) {
                if (null != annotation.getDeleted() && annotation.getDeleted() == 1) continue;
                model = new StorageMountsModel();
                model.setId(annotation.getId());
                model.setName(annotation.getName());
                model.setType(Integer.valueOf(3));
                model.setCreatedAt(annotation.getCreatedAt());
                model.setSeq(annotation.getGuid());
                model.setUsername(annotation.getUser().getUsername());
                model.setFullName(annotation.getUser().getName() == null ? annotation.getUser().getUsername() : annotation.getUser().getName());
                DepUsers depUsers4 = this.depUsersRepository.findByUserAndDepartment(annotation.getUser(), dep);
                if (depUsers4 != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                model.setStatus(annotation.getStatus());
                models.add(model);
            }
        }
        if (null != (mLabProjects = storage.getMLabProjects()) && mLabProjects.size() > 0) {
            for (MLabProject mLabProject : mLabProjects) {
                if (null != mLabProject.getDeleted() && mLabProject.getDeleted() == 1) continue;
                model = new StorageMountsModel();
                model.setId(mLabProject.getId());
                model.setName(mLabProject.getName());
                model.setType(Integer.valueOf(4));
                model.setCreatedAt(mLabProject.getCreatedAt());
                model.setSeq(mLabProject.getGuid());
                model.setUsername(mLabProject.getUser().getUsername());
                model.setFullName(mLabProject.getUser().getName() == null ? mLabProject.getUser().getUsername() : mLabProject.getUser().getName());
                depUsers = this.depUsersRepository.findByUserAndDepartment(mLabProject.getUser(), dep);
                if (depUsers != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                model.setStatus(mLabProject.getStatus());
                if (mLabProject.getResource() != null) {
                    model.setReplicas(mLabProject.getResource().getReplicas());
                }
                models.add(model);
            }
        }
        res.setList(models);
        return res;
    }

    @ApiOperation(value="\u5b58\u50a8\u5217\u8868")
    @Transactional
    @RequestMapping(value={"/api/storage/list"}, method={RequestMethod.POST})
    public StorageMountResponse<StorageModel> list(@RequestBody @Valid StorageSortPageRequest dto, HttpServletRequest request) throws Exception {
        StorageMountResponse res = new StorageMountResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = null;
        if (dto.getProjectId() != null) {
            MLabProject project = this.mLabProjectRepository.findByIdAndDeleted(dto.getProjectId(), Integer.valueOf(0));
            if (null != project) {
                depId = project.getDepartment().getId();
            }
        } else {
            depId = (Long)session.getAttribute("departmentId");
        }
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Long finalDepId = depId;
        1 spec = new /* Unavailable Anonymous Inner Class!! */;
        PageRequest pageable = dto.getTimeSort() != null ? new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), dto.getTimeSort() == 0 ? Sort.Direction.DESC : Sort.DEFAULT_DIRECTION, new String[]{"createdAt"}) : new PageRequest(dto.getPage() - 1, dto.getSize().intValue(), Sort.Direction.DESC, new String[]{"id"});
        Page page = this.storageRepository.findAll((Specification)spec, (Pageable)pageable);
        if (null != page && page.getTotalElements() > 0L) {
            res.setSize(Long.valueOf(page.getTotalElements()));
            res.setPages(Integer.valueOf(page.getTotalPages()));
            List storages = page.getContent();
            ArrayList<StorageModel> entities = new ArrayList<StorageModel>(page.getSize());
            String address = FactoryCollection.serviceAddr((Long)domainId);
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            for (Storage storage : storages) {
                StorageModel model = new StorageModel();
                StorageDept storageDept = this.storageDeptRepository.findByStorageIdAndDepartment(storage.getId(), dep);
                if (storageDept != null && null != storageDept.getRw() && storageDept.getRw() == 1) {
                    model.setRw(Integer.valueOf(1));
                } else {
                    model.setRw(Integer.valueOf(0));
                }
                Integer count = this.storageDeptRepository.countByStorage(storage);
                model.setShareDepNum(Optional.ofNullable(count).orElse(0));
                model.setId(storage.getId());
                model.setName(storage.getName());
                model.setCapacity(String.valueOf((long)storage.getCapacity().intValue() * 1024L * 1024L * 1024L));
                model.setCreatedAt(storage.getCreatedAt());
                model.setPassword(EncodeUtil.rawInput((String)storage.getPassword()));
                if (DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:scp", (Long)depId)) {
                    model.setScpUrl("scp -P " + storage.getSshPort() + " xxx root@" + address + ":/data");
                }
                if (DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:web", (Long)depId)) {
                    model.setWebUrl("k8s/" + storage.getWebPort() + "/index.php?user/loginSubmit");
                }
                model.setSsh("ssh root@" + address + " -p " + storage.getSshPort());
                model.setShared(storage.getShared());
                model.setStatus(storage.getStatus());
                model.setCost(this.paymentRepository.sumByResourceIdAndTypeAndUser(storage.getId(), Integer.valueOf(2), user));
                String volumeUsed = this.storageServiceFactory.getVolumeUsed(storage, k8sFactory);
                model.setUsed(volumeUsed);
                model.setUserId(storage.getUser().getId());
                model.setUsername(storage.getUser().getUsername());
                model.setFullName(storage.getUser().getName() == null ? storage.getUser().getUsername() : storage.getUser().getName());
                model.setGuid(storage.getGuid());
                DepUsers resourceDepUser = this.depUsersRepository.findByUserAndDepartment(storage.getUser(), dep);
                if (resourceDepUser != null) {
                    model.setCreatorQuited(Integer.valueOf(0));
                } else {
                    model.setCreatorQuited(Integer.valueOf(1));
                }
                model.setExposed(storage.getExposed());
                model.setType(storage.getType());
                if (dto.getProjectId() != null) {
                    MLabProject project = (MLabProject)this.mLabProjectRepository.findOne((Serializable)dto.getProjectId());
                    Resource resource = project.getResource();
                    if (resource != null) {
                        ResourceStorage resourceStorage = this.resourceStorageRepository.findTopByResourceAndStorage(resource, storage);
                        if (resourceStorage != null) {
                            model.setMountPath(resourceStorage.getPath());
                        }
                    } else {
                        MLabProjectStorage projectStorage = this.mLabProjectStorageRepository.findByMLabProjectAndStorage(project, storage);
                        if (projectStorage != null) {
                            model.setMountPath(projectStorage.getPath());
                        }
                    }
                }
                entities.add(model);
            }
            res.setBaseDir("/ai/");
            res.setList(entities);
        }
        return res;
    }

    @ApiOperation(value="\u5b58\u50a8\u4fe1\u606f")
    @Transactional
    @RequestMapping(value={"/api/storage/info/{id}"}, method={RequestMethod.GET})
    public StorageInfoResponse list(@ApiParam(name="id", value="\u5b58\u50a8id") @PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        StorageInfoResponse res = new StorageInfoResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Long userId = (Long)request.getSession().getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)request.getSession().getAttribute("departmentId");
        if (depId == null) {
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers currentUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
        Storage storage = (Storage)this.storageRepository.findOne((Serializable)id);
        res.setId(storage.getId());
        res.setName(storage.getName());
        res.setGuid(storage.getGuid());
        res.setCapacity(String.valueOf((long)storage.getCapacity().intValue() * 1024L * 1024L * 1024L));
        res.setCreatedAt(storage.getCreatedAt());
        res.setPassword(EncodeUtil.rawInput((String)storage.getPassword()));
        String address = FactoryCollection.serviceAddr((Long)domainId);
        if (DepartmentController.isMemberDepPermission((Integer)currentUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:scp", (Long)depId)) {
            res.setScpUrl("scp -P " + storage.getSshPort() + " xxx root@" + address + ":/data");
        }
        if (DepartmentController.isMemberDepPermission((Integer)currentUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:web", (Long)depId)) {
            res.setWebUrl("k8s/" + storage.getWebPort() + "/index.php?user/loginSubmit");
        }
        res.setShared(storage.getShared());
        res.setStatus(storage.getStatus());
        res.setCost(this.paymentRepository.sumByResourceIdAndTypeAndUser(storage.getId(), Integer.valueOf(2), user));
        res.setCreatedTime(TimeUtil.duration((Long)((System.currentTimeMillis() - storage.getCreatedAt().getTime()) / 1000L)));
        String volumeUsed = this.storageServiceFactory.getVolumeUsed(storage, FactoryCollection.k8sFactory((Long)domainId));
        res.setUsed(volumeUsed);
        res.setUsername(storage.getUser().getUsername());
        res.setFullName(storage.getUser().getName() == null ? storage.getUser().getUsername() : storage.getUser().getName());
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(storage.getUser(), dep);
        if (depUsers != null) {
            res.setCreatorQuited(Integer.valueOf(0));
        } else {
            res.setCreatorQuited(Integer.valueOf(1));
        }
        Price price = this.priceRepository.findByTypeAndDomainId(Integer.valueOf(4), domainId);
        res.setPrice(price.getPrice());
        res.setPriceUnit(price.getPriceUnit());
        res.setUnit(price.getUnit());
        res.setQuantityUnit(price.getQuantityUnit());
        res.setExposed(storage.getExposed());
        res.setType(storage.getType());
        res.setBaseDir("/ai/");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @Transactional
    @ApiOperation(value="\u8bbe\u7f6e\u5b58\u50a8\u662f\u5426\u5171\u4eab")
    @PutMapping(value={"/api/storage/{id}/share"})
    public ResultResponse share(@ApiParam(required=true, value="\u5b58\u50a8id") @PathVariable(value="id") Long id, @ApiParam(value="key:\u90e8\u95e8id;value:0\u53ea\u8bfb 1\u8bfb\u5199;\u7a7a\u5219\u53d6\u6d88\u5171\u4eab") @RequestBody(required=false) Map<Long, Integer> params, HttpServletRequest request) {
        OrgConfigDepartment dep;
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.account.dep.unauthenticated"));
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        DepUsers depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId));
        if (!DepartmentController.isMemberDepPermission((Integer)depUsers.getType(), (Boolean)userId.equals(storage.getUser().getId()), (String)"storage:share", (Long)depId)) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            return res;
        }
        this.storageDeptRepository.removeByStorageId(id);
        if (null != params && params.size() > 0) {
            Iterator<Map.Entry<Long, Integer>> iterator = params.entrySet().iterator();
            ArrayList<StorageDept> depts = new ArrayList<StorageDept>(params.size());
            while (iterator.hasNext()) {
                StorageDept dept = new StorageDept();
                dept.setStorage(storage);
                Map.Entry<Long, Integer> entry = iterator.next();
                if (entry.getValue() == null) continue;
                OrgConfigDepartment department = (OrgConfigDepartment)this.departmentRepository.findOne((Serializable)entry.getKey());
                if (null != department) {
                    dept.setDepartment(department);
                }
                if (entry.getValue() == 1) {
                    dept.setRw(Integer.valueOf(1));
                } else {
                    dept.setRw(Integer.valueOf(0));
                }
                depts.add(dept);
            }
            this.storageDeptRepository.save(depts);
            storage.setShared(Integer.valueOf(1));
        } else {
            storage.setShared(Integer.valueOf(0));
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u6302\u8f7d\u5b58\u50a8\u5217\u8868", notes="\u5305\u542b\u7ec4\u7ec7\u5185\u5171\u4eab\u5b58\u50a8")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/storage/mount/list"}, method={RequestMethod.GET})
    public StorageMountResponse<StorageMountModel> mountList(HttpServletRequest request) throws Exception {
        List depts;
        StorageMountModel model;
        StorageMountResponse res = new StorageMountResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        Long domainId = (Long)session.getAttribute("domain");
        HashSet<StorageMountModel> set = new HashSet<StorageMountModel>();
        List storages = this.storageRepository.findByUserIdAndDomainIdAndDepartmentIdAndStatusAndDeletedAndTypeNot(userId, domainId, depId, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(2));
        if (null != storages) {
            for (Storage s : storages) {
                if (s.getName().equalsIgnoreCase(user.getGuid().replace("-", ""))) continue;
                model = new StorageMountModel();
                model.setId(s.getId());
                model.setName(s.getName());
                model.setShared(s.getShared());
                model.setPassword(EncodeUtil.rawInput((String)s.getPassword()));
                model.setWebUrl("k8s/" + s.getWebPort() + "/index.php?user/loginSubmit");
                model.setCapacity(String.valueOf((long)s.getCapacity().intValue() * 1024L * 1024L * 1024L));
                String volumeUsed = this.storageServiceFactory.getVolumeUsed(s, FactoryCollection.k8sFactory((Long)domainId));
                model.setUsed(volumeUsed);
                model.setUpdatedAt(s.getUpdatedAt());
                model.setGuid(s.getGuid().substring(0, 12));
                model.setMountPath("/ai/" + s.getMountPath());
                set.add(model);
            }
        }
        if (null != (depts = this.storageDeptRepository.findByDepartmentId(depId))) {
            for (StorageDept dept : depts) {
                Storage storage = dept.getStorage();
                if (storage.getDeleted() == 1 || !storage.getDomain().getId().equals(domainId)) continue;
                model = new StorageMountModel();
                model.setId(storage.getId());
                model.setName(storage.getName());
                model.setShared(storage.getShared());
                model.setPassword(EncodeUtil.rawInput((String)storage.getPassword()));
                model.setWebUrl("k8s/" + storage.getWebPort() + "/index.php?user/loginSubmit");
                model.setCapacity(String.valueOf((long)storage.getCapacity().intValue() * 1024L * 1024L * 1024L));
                String volumeUsed = this.storageServiceFactory.getVolumeUsed(storage, FactoryCollection.k8sFactory((Long)domainId));
                model.setUsed(volumeUsed);
                model.setUpdatedAt(storage.getUpdatedAt());
                model.setGuid(storage.getGuid().substring(0, 12));
                model.setMountPath("/ai/" + storage.getMountPath());
                set.add(model);
            }
        }
        ArrayList list = Lists.newArrayList(set);
        list.sort((a1, a2) -> a2.getUpdatedAt().compareTo(a1.getUpdatedAt()));
        res.setList((Collection)list);
        res.setBaseDir("/ai/");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5b58\u50a8\u7c7b\u578b(1\u53ef\u9009,0\u4e0d\u53ef\u9009)")
    @Transactional
    @RequestMapping(value={"/api/storage/types"}, method={RequestMethod.GET})
    public StorageTypeResponse getStorageType(HttpServletRequest request) throws ApiException {
        StorageTypeResponse res = new StorageTypeResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        SystemConfig STORAGE_TYPE_CONFIG = this.systemConfigRepository.findByConfigName("STORAGE_TYPE_CONFIG_" + domainId);
        if (STORAGE_TYPE_CONFIG == null || Strings.isNullOrEmpty((String)STORAGE_TYPE_CONFIG.getConfigValue())) {
            return res;
        }
        JSONObject object = JSONObject.parseObject((String)STORAGE_TYPE_CONFIG.getConfigValue());
        res.setStorageType(object);
        res.setCode(Constants.SC_OK);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6570\u636e\u96c6\u6587\u4ef6\u4e0a\u4f20")
    @Transactional
    @RequestMapping(value={"/api/storage/{id}/upload"}, method={RequestMethod.POST})
    public UploadFileResponse uploadPackage(@ApiParam(value="\u5b58\u50a8id") @PathVariable(value="id") Long id, HttpServletRequest request, @ApiParam(value="\u4e0a\u4f20\u6587\u4ef6file") MultipartFile file) throws Exception {
        UploadFileResponse res = new UploadFileResponse();
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setCode(Constants.SC_MSG);
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        if (null != file) {
            InputStream input = file.getInputStream();
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
            List v1Pods = k8sFactory.listPods(storage.getGuid());
            if (null != v1Pods && !v1Pods.isEmpty()) {
                Process proc = new Exec(k8sFactory.client).exec((V1Pod)v1Pods.get(0), new String[]{"sh", "-c", "base64 -d - > /var/www/html/data/User/admin/home/" + file.getOriginalFilename()}, true, false);
                Throwable var10 = null;
                try {
                    try (Base64OutputStream base64OutputStream = new Base64OutputStream(proc.getOutputStream());){
                        Throwable var12 = null;
                        try {
                            ByteStreams.copy((InputStream)input, (OutputStream)base64OutputStream);
                            Thread.sleep(1000L);
                        }
                        catch (Throwable var47) {
                            var12 = var47;
                            throw var47;
                        }
                        finally {
                            if (input != null) {
                                if (var12 != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Throwable var46) {
                                        var12.addSuppressed(var46);
                                    }
                                } else {
                                    input.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var49) {
                        var10 = var49;
                        throw var49;
                    }
                }
                finally {
                    proc.destroy();
                }
            }
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5220\u9664\u5df2\u4e0a\u4f20\u6587\u4ef6")
    @PutMapping(value={"/api/storage/{id}/file/remove"})
    public ResultResponse removeFile(@ApiParam(value="\u5b58\u50a8id") @PathVariable(value="id") Long id, @RequestBody PathRequest dto, HttpServletRequest request) throws ApiException {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_MSG);
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        List v1Pods = k8sFactory.listPods(storage.getGuid());
        if (null != v1Pods && !v1Pods.isEmpty()) {
            Process proc = null;
            try {
                proc = new Exec(k8sFactory.client).exec((V1Pod)v1Pods.get(0), new String[]{"rm", "-rf", STORAGE_MOUNT_PATH + dto.getPath()}, false, false);
                proc.waitFor();
                res.setCode(Constants.SC_OK);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                res.setMessage(this.messageUtil.getMessage("msg.storage.file.remove.error"));
                request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.file.remove.error"));
            }
            finally {
                if (proc != null) {
                    proc.destroy();
                }
            }
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u96c6\u6587\u4ef6\u5217\u8868")
    @Transactional
    @GetMapping(value={"api/storage/{id}/files"})
    @ApiImplicitParam(name="path", value="\u8def\u5f84\uff0c\u4ee5/\u5f00\u5934", required=true, defaultValue="/")
    public ObjectResponse getFileList(@ApiParam(value="\u5b58\u50a8id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ObjectResponse res = new ObjectResponse();
        String path = request.getParameter("path");
        path = null != path ? (path.startsWith("/") ? path : "/" + path) : "/";
        res.setCode(Constants.SC_MSG);
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        String url = "http://" + FactoryCollection.k8sAddr((Long)domainId) + ":" + storage.getWebPort() + "/index.php?user/loginSubmit&isAjax=1&getToken=1&name=admin&password=" + EncodeUtil.rawInput((String)storage.getPassword());
        Request req = new Request.Builder().url(url).build();
        try {
            Response execute = Constants.HTTP_CLIENT.newCall(req).execute();
            JSONObject jsonObject = JSONObject.parseObject((String)execute.body().string());
            if (jsonObject.getBoolean("code").booleanValue()) {
                url = "http://" + FactoryCollection.k8sAddr((Long)domainId) + ":" + storage.getWebPort() + "/index.php?explorer/pathList&path=" + path + "&accessToken=" + jsonObject.getString("data");
                req = new Request.Builder().url(url).build();
                execute = Constants.HTTP_CLIENT.newCall(req).execute();
                jsonObject = JSONObject.parseObject((String)execute.body().string());
                if (jsonObject.getBoolean("code").booleanValue()) {
                    res.setResult(jsonObject.get((Object)"data"));
                    res.setCode(Constants.SC_OK);
                } else {
                    res.setMessage(this.messageUtil.getMessage("msg.storage.access.error"));
                }
            } else {
                res.setMessage(this.messageUtil.getMessage("msg.storage.access.error"));
            }
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            res.setMessage(this.messageUtil.getMessage("msg.storage.access.error"));
        }
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    @Transactional
    @GetMapping(value={"api/storage/{id}/file/content"})
    @ApiImplicitParam(name="path", value="\u8def\u5f84\uff0c\u4ee5/\u5f00\u5934", required=true)
    public ObjectResponse getFileContent(@ApiParam(value="\u5b58\u50a8id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ObjectResponse res = new ObjectResponse();
        res.setCode(Constants.SC_MSG);
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        String path = request.getParameter("path");
        if (path == null) {
            res.setMessage("request parameter path is necessary!");
            return res;
        }
        String fileExt = path.substring(path.lastIndexOf(".") + 1);
        if (!this.fileTypes.contains(fileExt)) {
            res.setCode(Constants.SC_OK);
            return res;
        }
        path = path.startsWith("/") ? path : "/" + path;
        String baseUrl = "http://" + FactoryCollection.k8sAddr((Long)domainId) + ":" + storage.getWebPort() + "/index.php?";
        String url = baseUrl + "user/loginSubmit&isAjax=1&getToken=1&name=admin&password=" + EncodeUtil.rawInput((String)storage.getPassword());
        Request req = new Request.Builder().url(url).build();
        res.setMessage(this.messageUtil.getMessage("msg.storage.access.error"));
        try {
            Response execute = Constants.HTTP_CLIENT.newCall(req).execute();
            JSONObject jsonObject = JSONObject.parseObject((String)execute.body().string());
            if (jsonObject.getBoolean("code").booleanValue()) {
                String accessToken = jsonObject.getString("data");
                url = "zip".equalsIgnoreCase(fileExt) || "tar".equalsIgnoreCase(fileExt) || "gz".equalsIgnoreCase(fileExt) ? baseUrl + "pluginApp/to/zipView/unzipList&path=" + path + "&accessToken=" + accessToken : baseUrl + "editor/fileGet&filename=" + path + "&accessToken=" + accessToken;
                req = new Request.Builder().url(url).build();
                execute = Constants.HTTP_CLIENT.newCall(req).execute();
                jsonObject = JSONObject.parseObject((String)execute.body().string());
                if (jsonObject.getBoolean("code").booleanValue()) {
                    res.setResult(jsonObject.get((Object)"data"));
                    res.setCode(Constants.SC_OK);
                    res.setMessage(null);
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return res;
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6574\u4e2a\u6570\u636e\u96c6")
    @Transactional
    @GetMapping(value={"/api/storage/{id}/files/download"})
    public ObjectResponse downloadFiles(@ApiParam(value="\u5b58\u50a8id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ObjectResponse res = new ObjectResponse();
        res.setCode(Constants.SC_MSG);
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        String baseUrl = "http://" + FactoryCollection.k8sAddr((Long)domainId) + ":" + storage.getWebPort() + "/index.php?";
        String url = baseUrl + "user/loginSubmit&isAjax=1&getToken=1&name=admin&password=" + EncodeUtil.rawInput((String)storage.getPassword());
        Request req = new Request.Builder().url(url).build();
        try {
            Response execute = Constants.HTTP_CLIENT.newCall(req).execute();
            JSONObject jsonObject = JSONObject.parseObject((String)execute.body().string());
            res.setMessage(this.messageUtil.getMessage("msg.storage.access.error"));
            if (jsonObject.getBoolean("code").booleanValue()) {
                String accessToken = jsonObject.getString("data");
                url = baseUrl + "explorer/pathList&path=/&accessToken=" + accessToken;
                req = new Request.Builder().url(url).build();
                execute = Constants.HTTP_CLIENT.newCall(req).execute();
                jsonObject = JSONObject.parseObject((String)execute.body().string());
                if (jsonObject.getBoolean("code").booleanValue()) {
                    JSONObject jo;
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray fileList = data.getJSONArray("fileList");
                    JSONArray folderList = data.getJSONArray("folderList");
                    StringBuilder sb = new StringBuilder("[");
                    boolean first = true;
                    if (!fileList.isEmpty()) {
                        for (Object o : fileList) {
                            jo = JSON.parseObject((String)JSON.toJSONString(o));
                            if (first) {
                                sb.append("{\"type\":\"file\",\"path\":\"").append(jo.getString("path")).append("\"}");
                                first = false;
                                continue;
                            }
                            sb.append(",{\"type\":\"file\",\"path\":\"").append(jo.getString("path")).append("\"}");
                        }
                    }
                    if (!folderList.isEmpty()) {
                        for (Object o : folderList) {
                            jo = JSON.parseObject((String)JSON.toJSONString(o));
                            if (first) {
                                sb.append("{\"type\":\"folder\",\"path\":\"").append(jo.getString("path")).append("\"}");
                                first = false;
                                continue;
                            }
                            sb.append(",{\"type\":\"folder\",\"path\":\"").append(jo.getString("path")).append("\"}");
                        }
                    }
                    if (sb.length() > 1) {
                        sb.append("]");
                        if (sb.toString().equals("[{\"type\":\"folder\",\"path\":\"/lost+found/\"}]")) {
                            res.setMessage(this.messageUtil.getMessage("msg.storage.no.download"));
                            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.no.download"));
                            return res;
                        }
                        url = baseUrl + "explorer/zipDownload&accessToken=" + accessToken;
                        FormBody formBody = new FormBody.Builder().addEncoded("dataArr", sb.toString()).build();
                        req = new Request.Builder().header("Accept-Language", request.getHeader("Accept-Language")).header("User-Agent", request.getHeader("User-Agent")).url(url).post((okhttp3.RequestBody)formBody).build();
                        execute = Constants.HTTP_CLIENT.newCall(req).execute();
                        jsonObject = JSONObject.parseObject((String)execute.body().string());
                        if (jsonObject.getBoolean("code").booleanValue()) {
                            res.setResult((Object)(baseUrl + "explorer/fileDownloadRemoveWithName&path=" + jsonObject.getString("info") + "&accessToken=" + accessToken + "&name=" + storage.getName() + ".zip"));
                            res.setCode(Constants.SC_OK);
                            res.setMessage(null);
                        }
                    } else {
                        res.setMessage(this.messageUtil.getMessage("msg.storage.download.empty"));
                        request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.download.empty"));
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        request.setAttribute("result", (Object)"true");
        return res;
    }

    @ApiOperation(value="\u5355\u4e2a\u6587\u4ef6\u4e0b\u8f7d")
    @Transactional
    @GetMapping(value={"/api/storage/{id}/file/download"})
    @ApiImplicitParam(name="path", value="\u8def\u5f84\uff0c\u4ee5/\u5f00\u5934", required=true, defaultValue="/")
    public ObjectResponse downloadFile(@ApiParam(value="\u5b58\u50a8id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        ObjectResponse res = new ObjectResponse();
        res.setCode(Constants.SC_MSG);
        HttpSession session = request.getSession();
        Long domainId = (Long)session.getAttribute("domain");
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            res.setMessage(this.messageUtil.getMessage("msg.storage.not.exist"));
            return res;
        }
        request.setAttribute("resourceType", (Object)2);
        request.setAttribute("resourceGuid", (Object)storage.getGuid());
        request.setAttribute("resourceName", (Object)storage.getName());
        String path = request.getParameter("path");
        if (path == null) {
            res.setMessage("request parameter path is necessary!");
            request.setAttribute("errorMessage", (Object)res.getMessage());
            return res;
        }
        if ("/lost+found/".equals(path)) {
            res.setMessage(this.messageUtil.getMessage("msg.storage.no.download"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.no.download"));
            return res;
        }
        path = path.startsWith("/") ? path : "/" + path;
        String baseUrl = "http://" + FactoryCollection.k8sAddr((Long)domainId) + ":" + storage.getWebPort() + "/index.php?";
        String url = baseUrl + "user/loginSubmit&isAjax=1&getToken=1&name=admin&password=" + EncodeUtil.rawInput((String)storage.getPassword());
        Request req = new Request.Builder().url(url).build();
        try {
            Response execute = Constants.HTTP_CLIENT.newCall(req).execute();
            JSONObject jsonObject = JSONObject.parseObject((String)execute.body().string());
            if (jsonObject.getBoolean("code").booleanValue()) {
                String accessToken = jsonObject.getString("data");
                if (path.endsWith("/")) {
                    url = baseUrl + "explorer/zipDownload&accessToken=" + accessToken;
                    FormBody formBody = new FormBody.Builder().addEncoded("dataArr", "[{\"type\":\"folder\",\"path\":\"" + path + "\"}]").build();
                    req = new Request.Builder().header("Accept-Language", request.getHeader("Accept-Language")).header("User-Agent", request.getHeader("User-Agent")).url(url).post((okhttp3.RequestBody)formBody).build();
                    execute = Constants.HTTP_CLIENT.newCall(req).execute();
                    jsonObject = JSONObject.parseObject((String)execute.body().string());
                    if (jsonObject.getBoolean("code").booleanValue()) {
                        res.setResult((Object)(baseUrl + "explorer/fileDownloadRemove&path=" + jsonObject.getString("info") + "&accessToken=" + accessToken));
                    }
                } else {
                    res.setResult((Object)(baseUrl + "explorer/fileDownload&path=" + path + "&accessToken=" + accessToken));
                }
            } else {
                res.setMessage(this.messageUtil.getMessage("msg.storage.access.error"));
            }
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            res.setMessage(this.messageUtil.getMessage("msg.storage.access.error"));
            request.setAttribute("errorMessage", (Object)this.messageUtil.getMessageJson("msg.storage.access.error"));
        }
        request.setAttribute("result", (Object)"true");
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b58\u50a8\u7ed1\u5b9a\u73af\u5883")
    @Transactional
    @RequestMapping(value={"/api/storage/capacity/{id}/bound"}, method={RequestMethod.GET})
    public ResultResponse getBound(@PathVariable(value="id") Long id, HttpServletRequest request) throws ApiException {
        List annotations;
        List modelVersions;
        List jobVersionList;
        BoundResourceModel model;
        ListResultResponse res = new ListResultResponse();
        Storage storage = this.storageRepository.findByIdAndDeleted(id, Integer.valueOf(0));
        if (null == storage) {
            return res;
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)storage.getDomain().getId());
        V1StorageClass storageClass = k8sFactory.defaultStorageClass();
        if (null == storageClass || !"longhorn".equals(storageClass.getMetadata().getName())) {
            return res;
        }
        ArrayList<BoundResourceModel> list = new ArrayList<BoundResourceModel>();
        List resourceList = this.resourceStorageRepository.findByStorage(storage);
        if (null != resourceList && resourceList.size() > 0) {
            for (Object resource : resourceList) {
                model = new BoundResourceModel();
                model.setResourceId(resource.getGuid());
                model.setResourceType(Integer.valueOf(0));
                model.setResourceName(resource.getName());
                model.setResourceStatus(resource.getStatus());
                model.setUsername(resource.getUser().getUsername());
                model.setFullName(resource.getUser().getName());
                list.add(model);
            }
        }
        if (null != (jobVersionList = this.jobStorageRepository.findByStorage(storage)) && jobVersionList.size() > 0) {
            for (Object version : jobVersionList) {
                model = new BoundResourceModel();
                model.setResourceId(version.getGuid());
                model.setResourceType(Integer.valueOf(1));
                model.setResourceName(version.getJob().getName());
                model.setResourceStatus(version.getStatus());
                model.setUsername(version.getJob().getUser().getUsername());
                model.setFullName(version.getJob().getUser().getName());
                list.add(model);
            }
        }
        if (null != (modelVersions = this.modelVersionRepository.findByModelPathStartsWithAndDeleted(storage.getId() + ":", Integer.valueOf(0))) && modelVersions.size() > 0) {
            for (ModelVersion modelVersion : modelVersions) {
                List services = this.serviceRepository.findByCurrentModelVersionAndDeletedAndStstusIn(modelVersion, Integer.valueOf(0));
                if (null == (services = services.stream().distinct().collect(Collectors.toList())) || services.size() <= 0) continue;
                for (Service service : services) {
                    model = new BoundResourceModel();
                    model.setResourceId(service.getCurrent().getGuid());
                    model.setResourceType(Integer.valueOf(5));
                    model.setResourceName(service.getName());
                    model.setResourceStatus(service.getCurrent().getStatus());
                    model.setUsername(service.getUser().getUsername());
                    model.setFullName(service.getUser().getName());
                    list.add(model);
                }
            }
        }
        if (null != (annotations = this.annotationRepository.findByStorageAndDeleted(storage, Integer.valueOf(0))) && annotations.size() > 0) {
            for (Annotation annotation : annotations) {
                if (null != annotation.getDeleted() && annotation.getDeleted() == 1) continue;
                model = new BoundResourceModel();
                model.setResourceId(annotation.getGuid());
                model.setResourceType(Integer.valueOf(3));
                model.setResourceName(annotation.getName());
                model.setResourceStatus(annotation.getStatus());
                model.setUsername(annotation.getUser().getUsername());
                model.setFullName(annotation.getUser().getName());
                list.add(model);
            }
        }
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @Transactional
    public void schedule() throws ApiException {
        List storages = this.storageRepository.findSchedule();
        if (null != storages && storages.size() > 0) {
            for (Storage storage : storages) {
                List conditions;
                V1Pod pod;
                User user = storage.getUser();
                K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)storage.getDomain().getId());
                List podList = k8sFactory.listPods(storage.getGuid());
                if (null == podList || podList.size() <= 0 || !"Running".equals((pod = (V1Pod)podList.get(0)).getStatus().getPhase())) continue;
                V1ContainerStatus containerStatus = (V1ContainerStatus)pod.getStatus().getContainerStatuses().get(0);
                if (containerStatus.getReady().booleanValue() && storage.getStatus() != 1) {
                    try {
                        V1Deployment deploy = k8sFactory.appsV1Api.readNamespacedDeployment(DEPLOY_NAME, storage.getGuid(), null, null, null);
                        Integer readyReplicas = deploy.getStatus().getReadyReplicas();
                        if (null == readyReplicas || readyReplicas != 1) continue;
                        Date startTime = Date.from(containerStatus.getState().getRunning().getStartedAt().toInstant());
                        OrgConfigDepartment department = storage.getDepartment();
                        Materials material = new Materials();
                        material.setUser(user);
                        material.setDepartment(department);
                        material.setOrganization(department.getOrgConfig().getOrganization());
                        material.setResourceId(storage.getId());
                        material.setType(Integer.valueOf(2));
                        material.setPackageType(Integer.valueOf(2));
                        material.setCreatedAt(startTime);
                        material.setCostTime(startTime);
                        material.setStorageNum(Double.valueOf(storage.getCapacity().doubleValue()));
                        material.setDomain(storage.getDomain());
                        this.materialsRepository.save(material);
                        storage.setStatus(Integer.valueOf(1));
                    }
                    catch (ApiException e) {
                        logger.error(e.getResponseBody(), (Throwable)e);
                    }
                    continue;
                }
                if (storage.getStatus() == -9 || !"Pending".equals(pod.getStatus().getPhase()) || null == (conditions = pod.getStatus().getConditions()) || conditions.size() <= 0) continue;
                for (V1PodCondition condition : conditions) {
                    if (!"PodScheduled".equals(condition.getType()) || null == condition.getMessage() || !condition.getMessage().contains("Insufficient")) continue;
                    storage.setStatus(Integer.valueOf(-9));
                }
            }
        }
    }

    @ConstructorProperties(value={"storageRepository", "materialsRepository", "systemConfigRepository", "userRepository", "balancesRepository", "paymentRepository", "storageDeptRepository", "departmentRepository", "priceRepository", "orgConfigDepartmentRepository", "depUsersRepository", "domainRepository", "organizationQuotasRepository", "depQuotasRepository", "mLabProjectRepository", "annotationRepository", "modelVersionRepository", "serviceRepository", "depUserQuotasRepository", "resourceStorageRepository", "jobStorageRepository", "storageService", "storageServiceFactory", "mLabProjectStorageRepository", "experimentRepository", "messageUtil"})
    public StorageController(StorageRepository storageRepository, MaterialsRepository materialsRepository, SystemConfigRepository systemConfigRepository, UserRepository userRepository, BalancesRepository balancesRepository, PaymentRepository paymentRepository, StorageDeptRepository storageDeptRepository, OrgConfigDepartmentRepository departmentRepository, PriceRepository priceRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, DepUsersRepository depUsersRepository, DomainRepository domainRepository, OrganizationQuotasRepository organizationQuotasRepository, DepQuotasRepository depQuotasRepository, MLabProjectRepository mLabProjectRepository, AnnotationRepository annotationRepository, ModelVersionRepository modelVersionRepository, ServiceRepository serviceRepository, DepUserQuotasRepository depUserQuotasRepository, ResourceStorageRepository resourceStorageRepository, JobStorageRepository jobStorageRepository, StorageService storageService, StorageServiceFactory storageServiceFactory, MLabProjectStorageRepository mLabProjectStorageRepository, ExperimentRepository experimentRepository, MessageUtil messageUtil) {
        this.storageRepository = storageRepository;
        this.materialsRepository = materialsRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.userRepository = userRepository;
        this.balancesRepository = balancesRepository;
        this.paymentRepository = paymentRepository;
        this.storageDeptRepository = storageDeptRepository;
        this.departmentRepository = departmentRepository;
        this.priceRepository = priceRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.depUsersRepository = depUsersRepository;
        this.domainRepository = domainRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.mLabProjectRepository = mLabProjectRepository;
        this.annotationRepository = annotationRepository;
        this.modelVersionRepository = modelVersionRepository;
        this.serviceRepository = serviceRepository;
        this.depUserQuotasRepository = depUserQuotasRepository;
        this.resourceStorageRepository = resourceStorageRepository;
        this.jobStorageRepository = jobStorageRepository;
        this.storageService = storageService;
        this.storageServiceFactory = storageServiceFactory;
        this.mLabProjectStorageRepository = mLabProjectStorageRepository;
        this.experimentRepository = experimentRepository;
        this.messageUtil = messageUtil;
    }
}

