/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.Constants;
import com.mopaas.server.common.DateUtil;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.common.RandomUtil;
import com.mopaas.server.common.SecurityUtil;
import com.mopaas.server.common.TimeUtil;
import com.mopaas.server.controller.DepartmentController;
import com.mopaas.server.dao.AccountUserRegisterRepository;
import com.mopaas.server.dao.AnnotationRepository;
import com.mopaas.server.dao.BalancesRepository;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUserQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.DomainRepository;
import com.mopaas.server.dao.EmailValidateRepository;
import com.mopaas.server.dao.ExperimentRepository;
import com.mopaas.server.dao.HarborProjectRepository;
import com.mopaas.server.dao.HarborUserRepository;
import com.mopaas.server.dao.JobRepository;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.LoginHistoryRepository;
import com.mopaas.server.dao.OrgConfigDepPackageRepository;
import com.mopaas.server.dao.OrgConfigDepartmentRepository;
import com.mopaas.server.dao.OrgConfigRepository;
import com.mopaas.server.dao.OrganizationQuotasRepository;
import com.mopaas.server.dao.OrganizationRepository;
import com.mopaas.server.dao.PaymentRepository;
import com.mopaas.server.dao.PermissionRepository;
import com.mopaas.server.dao.PortalConfigRepository;
import com.mopaas.server.dao.PricePackageRepository;
import com.mopaas.server.dao.PriceRepository;
import com.mopaas.server.dao.RechargeRepository;
import com.mopaas.server.dao.RegisterConfigRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.ServiceRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.TemplateSmsRepository;
import com.mopaas.server.dao.TicketContinueRepository;
import com.mopaas.server.dao.TicketRepository;
import com.mopaas.server.dao.UserConfigValueRepository;
import com.mopaas.server.dao.UserConfigsRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.AccountUserRegister;
import com.mopaas.server.entity.Annotation;
import com.mopaas.server.entity.Balance;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUserQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.Domain;
import com.mopaas.server.entity.EmailValidate;
import com.mopaas.server.entity.Experiment;
import com.mopaas.server.entity.HarborProject;
import com.mopaas.server.entity.HarborUser;
import com.mopaas.server.entity.JobVersion;
import com.mopaas.server.entity.LoginHistory;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.Notice;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.Organization;
import com.mopaas.server.entity.OrganizationQuotas;
import com.mopaas.server.entity.Payment;
import com.mopaas.server.entity.Permission;
import com.mopaas.server.entity.Price;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.Recharge;
import com.mopaas.server.entity.RegisterConfig;
import com.mopaas.server.entity.Resource;
import com.mopaas.server.entity.Service;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.TemplateSms;
import com.mopaas.server.entity.Ticket;
import com.mopaas.server.entity.TicketContinue;
import com.mopaas.server.entity.User;
import com.mopaas.server.entity.UserConfigValue;
import com.mopaas.server.entity.UserConfigs;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.harbor.ApiException;
import com.mopaas.server.harbor.api.ProductsApi;
import com.mopaas.server.harbor.model.Password;
import com.mopaas.server.harbor.model.Project;
import com.mopaas.server.harbor.model.ProjectMember;
import com.mopaas.server.harbor.model.UserEntity;
import com.mopaas.server.model.request.ContinueTicketRequest;
import com.mopaas.server.model.request.CreateTicketRequest;
import com.mopaas.server.model.request.DepUserAllocationQuotaRequest;
import com.mopaas.server.model.request.DepUserQuotaRangeRequest;
import com.mopaas.server.model.request.EamilValidateCodeRequest;
import com.mopaas.server.model.request.ForgetPwdRequest;
import com.mopaas.server.model.request.LoginRequest;
import com.mopaas.server.model.request.PaymentExportRequest;
import com.mopaas.server.model.request.PaymentRequest;
import com.mopaas.server.model.request.PhoneSafetyRequest;
import com.mopaas.server.model.request.PhoneValidateCodeRequest;
import com.mopaas.server.model.request.RechargeRequest;
import com.mopaas.server.model.request.RegisterRequest;
import com.mopaas.server.model.request.RegisterValidateCodeRequest;
import com.mopaas.server.model.request.ResetEmailRequest;
import com.mopaas.server.model.request.ResetPhoneRequest;
import com.mopaas.server.model.request.ResetPwdRequest;
import com.mopaas.server.model.request.SearchUserTicketRequest;
import com.mopaas.server.model.request.UserInfoAlterRequest;
import com.mopaas.server.model.response.BindingCommunicationResponse;
import com.mopaas.server.model.response.BooleanResponse;
import com.mopaas.server.model.response.DepQuotasModel;
import com.mopaas.server.model.response.DepUserAllocationModel;
import com.mopaas.server.model.response.DepUserQuotaResponse;
import com.mopaas.server.model.response.IsLoginConfigReaponse;
import com.mopaas.server.model.response.IsValidateConfigReaponse;
import com.mopaas.server.model.response.ListPaymentResultResponse;
import com.mopaas.server.model.response.ListResultResponse;
import com.mopaas.server.model.response.LoginResponse;
import com.mopaas.server.model.response.ModuleModel;
import com.mopaas.server.model.response.RechargeModel;
import com.mopaas.server.model.response.RegistryResponse;
import com.mopaas.server.model.response.ReplyContent;
import com.mopaas.server.model.response.ResultResponse;
import com.mopaas.server.model.response.TicketModel;
import com.mopaas.server.model.response.UploadFileResponse;
import com.mopaas.server.model.response.UserConfigInfoModel;
import com.mopaas.server.model.response.UserConfigResponse;
import com.mopaas.server.model.response.UserPaymentModel;
import com.mopaas.server.model.response.UserResponse;
import com.mopaas.server.model.response.UserTicketDetailListResponse;
import com.mopaas.server.model.response.UserTicketModel;
import com.mopaas.server.service.AccountService;
import com.mopaas.server.service.NoticeService;
import io.minio.MinioClient;
import io.minio.policy.PolicyType;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.crypto.hash.Sha1Hash;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class UserController {
    final UserRepository userRepository;
    final PermissionRepository permissionRepository;
    final SystemConfigRepository systemConfigRepository;
    final EmailValidateRepository emailValidateRepository;
    final UserConfigsRepository userConfigsRepository;
    final UserConfigValueRepository userConfigValueRepository;
    final PortalConfigRepository portalConfigRepository;
    final TicketRepository ticketRepository;
    final TicketContinueRepository ticketContinueRepository;
    final OrganizationRepository organizationRepository;
    final OrgConfigRepository orgConfigRepository;
    final PaymentRepository paymentRepository;
    final RechargeRepository rechargeRepository;
    final ResourceRepository resourceRepository;
    final JobRepository jobRepository;
    final ServiceRepository serviceRepository;
    final StorageRepository storageRepository;
    final OrgConfigDepartmentRepository orgConfigDepartmentRepository;
    final PricePackageRepository pricePackageRepository;
    final AccountUserRegisterRepository accountUserRegisterRepository;
    final DepUsersRepository depUsersRepository;
    final OrgConfigDepPackageRepository orgConfigDepPackageRepository;
    final DomainRepository domainRepository;
    final OrganizationQuotasRepository organizationQuotasRepository;
    final DepQuotasRepository depQuotasRepository;
    final JobVersionRepository jobVersionRepository;
    final BalancesRepository balancesRepository;
    final LoginHistoryRepository loginHistoryRepository;
    final PriceRepository priceRepository;
    final DepUserQuotasRepository depUserQuotasRepository;
    final ExperimentRepository experimentRepository;
    final MessageUtil messageUtil;
    final NoticeService noticeService;
    final TemplateSmsRepository templateSmsRepository;
    final RegisterConfigRepository registerConfigRepository;
    final AccountService accountService;
    final HarborUserRepository harborUserRepository;
    final HarborProjectRepository harborProjectRepository;
    final AnnotationRepository annotationRepository;
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private static final String EMAIL_REGEX = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";
    private static final String TEL_REGEX = "^1\\d{10}$";
    private static final String USERNAME_REGEX = "^[a-zA-Z0-9][a-zA-Z0-9_]{0,19}(?<!_)$";
    private static final String SNAP_REPO = "-snapshot";

    @ApiOperation(value="\u662f\u5426\u5df2\u767b\u5f55")
    @Transactional
    @RequestMapping(value={"/api/anon/login/judge"}, method={RequestMethod.GET})
    public BooleanResponse registryJudgeOrganization() {
        BooleanResponse res = new BooleanResponse();
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession();
        Long userId = (Long)session.getAttribute((Object)"userId");
        res.setABoolean(userId != null);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u663e\u793a\u6a21\u5757", notes="v3.3\u65b0\u589e\uff0c3.5\u4fee\u6539\uff0c\u90e8\u95e8\u6743\u9650\u63a7\u5236\u53d6\u6d88")
    @Transactional
    @RequestMapping(value={"/api/module"}, method={RequestMethod.GET})
    public ListResultResponse<ModuleModel> registryJudgeOrganization(HttpServletRequest request) {
        Organization org;
        DepUsers depUsers;
        ListResultResponse res = new ListResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setCode(Constants.SC_OK);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            List dus = this.depUsersRepository.findByUserNotDeleted(user);
            if (dus != null && dus.size() > 0) {
                depUsers = (DepUsers)dus.get(0);
                org = depUsers.getDepartment().getOrgConfig().getOrganization();
            } else {
                org = user.getOrganization();
            }
        } else {
            OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
            org = dep.getOrgConfig().getOrganization();
            depUsers = this.depUsersRepository.findByUserAndDepartment(user, dep);
            if (depUsers == null) {
                res.setCode(Constants.SC_OK);
                return res;
            }
        }
        ArrayList<ModuleModel> list = new ArrayList<ModuleModel>();
        List modules = this.permissionRepository.findByType(Integer.valueOf(2));
        String language = "zh";
        modules.sort(Comparator.comparing(Permission::getOrders));
        ArrayList<String> orgPermissionCodes = new ArrayList<String>();
        if (null != org.getOrganizationPermission()) {
            for (Permission p : org.getOrganizationPermission()) {
                orgPermissionCodes.add(p.getPermission());
            }
        }
        for (Permission p : modules) {
            String label;
            String pName;
            JSONObject jsonObject;
            if (p.getState() != 1) continue;
            ModuleModel model = new ModuleModel();
            if (com.mopaas.server.common.StringUtils.isJson((String)p.getName())) {
                jsonObject = JSONObject.fromObject((Object)p.getName());
                pName = jsonObject.get(language).toString();
            } else {
                pName = p.getName();
            }
            if (null != p.getLabel() && com.mopaas.server.common.StringUtils.isJson((String)p.getLabel())) {
                jsonObject = JSONObject.fromObject((Object)p.getLabel());
                label = jsonObject.get(language).toString();
            } else {
                label = p.getLabel();
            }
            model.setName(pName);
            model.setLabel(label);
            if (!orgPermissionCodes.contains(p.getPermission())) {
                model.setStatus(Integer.valueOf(0));
            } else {
                model.setStatus(Integer.valueOf(1));
            }
            list.add(model);
        }
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7528\u6237\u767b\u5f55", notes="v3.3\u4fee\u6539\u63a5\u53e3\u4f20\u53c2-\u65b0\u589e\u53c2\u6570type")
    @RequestMapping(value={"/api/anon/login"}, method={RequestMethod.POST})
    public LoginResponse login(@RequestBody @Valid LoginRequest dto, HttpServletRequest request) {
        User user;
        LoginResponse res = new LoginResponse();
        UsernamePasswordToken sbToken = new UsernamePasswordToken(dto.getUsername(), new Sha1Hash((Object)dto.getPassword()).toBase64());
        Subject subject = SecurityUtils.getSubject();
        if (subject.getSession().getAttributeKeys().size() > 0) {
            subject.getSession().setAttribute((Object)"userId", null);
            subject.logout();
        }
        if ((user = this.userRepository.findByUsernameAndPassword(dto.getUsername(), new Sha1Hash((Object)dto.getPassword()).toBase64())) == null) {
            throw new UnknownAccountException(this.messageUtil.getMessage("msg.account.unknown"));
        }
        if (user.getDeleted() == null) {
            user.setDeleted(Integer.valueOf(0));
        }
        Organization organization = user.getOrganization();
        List dus = this.depUsersRepository.findByUserNotDeleted(user);
        if (!(null != dto.getType() && dto.getType() != 0 || organization == null || organization.getStatus() != 0 || dus != null && !dus.isEmpty())) {
            throw new UnknownAccountException(this.messageUtil.getMessage("msg.account.org.isLocked"));
        }
        subject.login((AuthenticationToken)sbToken);
        AccountUserRegister register = this.accountUserRegisterRepository.findByUser(user);
        Date now = new Date();
        if (register == null) {
            register = new AccountUserRegister();
            register.setUser(user);
            register.setType(Integer.valueOf(1));
            register.setCreatedAt(now);
            register = (AccountUserRegister)this.accountUserRegisterRepository.saveAndFlush((Object)register);
        }
        register.setUpdatedAt(now);
        if (organization == null) {
            organization = this.accountService.createOrg(user);
        }
        if (organization.getStatus() == 1 && (dus == null || dus.size() <= 0)) {
            OrgConfigDepartment orgConfigDepartment = this.accountService.createDep(user, organization);
        }
        res.setId(Long.parseLong(subject.getSession().getAttribute((Object)"userId").toString()));
        res.setUsername(subject.getPrincipal().toString());
        LoginHistory loginHistory = new LoginHistory();
        loginHistory.setUser(user);
        loginHistory.setStart(now);
        loginHistory.setEnd(now);
        loginHistory.setLoginIp(subject.getSession().getHost());
        this.loginHistoryRepository.save((Object)loginHistory);
        List domains = this.domainRepository.findByDeletedAndStatus(Integer.valueOf(0), Integer.valueOf(1));
        for (Domain d : domains) {
            try {
                HarborUser huser;
                Object projectList;
                Object u2;
                com.mopaas.server.harbor.model.User harborUser;
                List userList;
                ProductsApi harborApi = FactoryCollection.harborApi((Long)d.getId());
                HarborUser tHarborUser = this.harborUserRepository.findTopByUserAndDomain(user, d);
                if (tHarborUser != null && !tHarborUser.getHarborUsername().equals(user.getUsername())) {
                    String harborUsername;
                    String projectName;
                    List projects;
                    userList = harborApi.usersGet(user.getUsername(), null, null, null);
                    harborUser = null;
                    for (Object u2 : userList) {
                        if (!user.getUsername().equals(u2.getUsername())) continue;
                        harborUser = u2;
                        break;
                    }
                    if (harborUser == null) {
                        harborUser = new com.mopaas.server.harbor.model.User();
                        harborUser.username(user.getUsername());
                        harborUser.realname(user.getUsername());
                        harborUser.setRoleName(user.getUsername());
                        harborUser.setEmail(UUID.randomUUID().toString().replaceAll("-", "") + "@mopaas.com");
                        harborUser.setPassword(dto.getPassword());
                        harborApi.usersPost(harborUser);
                    }
                    if ((projectList = this.harborProjectRepository.findByOwnerIdAndDeleted(user.getId(), 0)) != null && !projectList.isEmpty()) {
                        u2 = projectList.iterator();
                        while (u2.hasNext()) {
                            HarborProject project = (HarborProject)u2.next();
                            ProjectMember projectMember = new ProjectMember();
                            projectMember.setRoleId(Integer.valueOf(1));
                            UserEntity userEntity = new UserEntity();
                            userEntity.setUserId(harborUser.getUserId());
                            userEntity.setUsername(harborUser.getUsername());
                            projectMember.setMemberUser(userEntity);
                            harborApi.projectsProjectIdMembersPost(project.getProjectId(), projectMember);
                        }
                    }
                    if ((projects = harborApi.projectsGet(projectName = (harborUsername = user.getUsername() + user.getGuid().substring(0, 12)).toLowerCase() + SNAP_REPO, null, null, null, null)) != null && !projects.isEmpty()) {
                        for (Project project : projects) {
                            ProjectMember projectMember = new ProjectMember();
                            projectMember.setRoleId(Integer.valueOf(1));
                            UserEntity userEntity = new UserEntity();
                            userEntity.setUserId(harborUser.getUserId());
                            userEntity.setUsername(harborUser.getUsername());
                            projectMember.setMemberUser(userEntity);
                            try {
                                harborApi.projectsProjectIdMembersPost(Long.valueOf(project.getProjectId().intValue()), projectMember);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    List userListOld = harborApi.usersGet(tHarborUser.getHarborUsername(), null, null, null);
                    com.mopaas.server.harbor.model.User oldHarborUser = null;
                    for (com.mopaas.server.harbor.model.User u3 : userListOld) {
                        if (!tHarborUser.getHarborUsername().equals(u3.getUsername())) continue;
                        oldHarborUser = u3;
                        break;
                    }
                    if (oldHarborUser != null) {
                        harborApi.usersUserIdDelete(oldHarborUser.getUserId());
                    }
                    tHarborUser.setHarborUsername(user.getUsername());
                    new SecurityUtil();
                    tHarborUser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                    this.harborUserRepository.saveAndFlush((Object)tHarborUser);
                    user.setHarborPassword(new Sha1Hash((Object)dto.getPassword()).toBase64());
                    continue;
                }
                userList = harborApi.usersGet(user.getUsername(), null, null, null);
                harborUser = null;
                projectList = userList.iterator();
                while (projectList.hasNext()) {
                    u2 = (com.mopaas.server.harbor.model.User)projectList.next();
                    if (!user.getUsername().equals(u2.getUsername())) continue;
                    harborUser = u2;
                    break;
                }
                if (null != harborUser && tHarborUser != null) {
                    Base64 base64 = new Base64();
                    String oldPwd = tHarborUser.getHarborPassword();
                    if (base64.decode(oldPwd.getBytes()).length % 8 == 0) {
                        String string;
                        new SecurityUtil();
                        if (SecurityUtil.decrypt((String)tHarborUser.getHarborPassword()).isEmpty()) {
                            string = tHarborUser.getHarborPassword();
                        } else {
                            new SecurityUtil();
                            string = oldPwd = SecurityUtil.decrypt((String)tHarborUser.getHarborPassword());
                        }
                    }
                    if (dto.getPassword().equals(oldPwd)) continue;
                    Password password = new Password();
                    password.setNewPassword(dto.getPassword());
                    password.setOldPassword(oldPwd);
                    try {
                        harborApi.usersUserIdPasswordPut(harborUser.getUserId(), password);
                        new SecurityUtil();
                        tHarborUser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                        this.harborUserRepository.saveAndFlush((Object)tHarborUser);
                        user.setHarborPassword(new Sha1Hash((Object)dto.getPassword()).toBase64());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (null != harborUser) {
                    huser = new HarborUser();
                    huser.setUser(user);
                    huser.setDomain(d);
                    huser.setHarborUsername(user.getUsername());
                    new SecurityUtil();
                    huser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                    this.harborUserRepository.save((Object)huser);
                    continue;
                }
                harborUser = new com.mopaas.server.harbor.model.User();
                harborUser.username(user.getUsername());
                harborUser.realname(user.getUsername());
                harborUser.setRoleName(user.getUsername());
                harborUser.setEmail(UUID.randomUUID().toString().replaceAll("-", "") + "@mopaas.com");
                harborUser.setPassword(dto.getPassword());
                harborApi.usersPost(harborUser);
                huser = new HarborUser();
                huser.setUser(user);
                huser.setDomain(d);
                huser.setHarborUsername(user.getUsername());
                new SecurityUtil();
                huser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                this.harborUserRepository.save((Object)huser);
            }
            catch (ApiException e) {
                logger.error(e.getResponseBody(), (Throwable)e);
            }
        }
        return res;
    }

    @ApiOperation(value="\u7ec4\u7ec7\u662f\u5426\u5df2\u521b\u5efa")
    @Transactional
    @RequestMapping(value={"/api/anon/registry/judge/organization/{organizationName}"}, method={RequestMethod.GET})
    public BooleanResponse registryJudgeOrganization(@ApiParam(value="\u7ec4\u7ec7\u540d\u79f0") @PathVariable(value="organizationName") String organizationName) {
        BooleanResponse res = new BooleanResponse();
        Organization organization = this.organizationRepository.findTopByNameAndDeleted(organizationName, Integer.valueOf(0));
        res.setABoolean(organization != null);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7528\u6237\u6ce8\u518c")
    @Transactional
    @RequestMapping(value={"/api/anon/registry"}, method={RequestMethod.POST})
    public RegistryResponse registry(@Valid @RequestBody RegisterRequest dto, HttpServletRequest request) throws ApiException {
        OrgConfigDepartment orgConfigDepartment;
        Map userConfigValues;
        RegistryResponse res = new RegistryResponse();
        String phone = dto.getPhone();
        String email = dto.getEmail();
        if (phone != null && !phone.isEmpty() && phone.matches(EMAIL_REGEX)) {
            email = phone;
        }
        if (email != null && !email.isEmpty() && email.matches(TEL_REGEX)) {
            phone = email;
        }
        if (!dto.getUsername().matches(USERNAME_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = this.userRepository.findByUsername(dto.getUsername());
        if (user != null) {
            if (user.getStatus() == 0) {
                res.setMessage(this.messageUtil.getMessage("msg.user.status.pending"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (user.getStatus() == -1) {
                res.setMessage(this.messageUtil.getMessage("msg.user.status.unapproved"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        }
        user = null;
        if (phone != null && !phone.isEmpty() && phone.matches(TEL_REGEX)) {
            user = this.userRepository.findByPhone(phone);
        }
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.phone.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (email != null && !email.isEmpty() && email.matches(EMAIL_REGEX)) {
            user = this.userRepository.findByEmail(email);
        }
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.email.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        user = this.userRepository.findByPhone(dto.getUsername());
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.available"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        user = this.userRepository.findByEmail(dto.getUsername());
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.available"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        user = this.userRepository.findByUsername(dto.getUsername());
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (dto.getPassword() == null || dto.getPassword().isEmpty() || dto.getPassword().length() < 1) {
            res.setMessage(this.messageUtil.getMessage("msg.password.is.not.correct"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        SystemConfig notice_send_user = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        Boolean validateState = true;
        if (notice_send_user != null && notice_send_user.getConfigValue() != null) {
            validateState = notice_send_user.getConfigValue().contains("1");
        }
        if (!"139725".equals(dto.getValidateCode()) && validateState.booleanValue()) {
            String validateCode = dto.getValidateCode();
            EmailValidate emailValidate = null;
            if (phone != null && !phone.isEmpty()) {
                emailValidate = this.emailValidateRepository.findByPhoneAndType(phone, Integer.valueOf(0));
            } else if (email != null && !email.isEmpty()) {
                emailValidate = this.emailValidateRepository.findByEmail(email);
            }
            if (emailValidate == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            long createDate = emailValidate.getUpdatedAt().getTime();
            long outDate = createDate + 300000L;
            long nowDate = System.currentTimeMillis();
            if (!oldValidateCode.equalsIgnoreCase(validateCode)) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (nowDate > outDate) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            emailValidate.setValidateCode(null);
            this.emailValidateRepository.save((Object)emailValidate);
        }
        Date now = new Date();
        user = new User();
        user.setDeleted(Integer.valueOf(0));
        user.setUsername(dto.getUsername());
        user.setName(dto.getUsername().trim());
        user.setPassword(new Sha1Hash((Object)dto.getPassword()).toBase64());
        user.setGuid(UUID.randomUUID().toString().replace("-", ""));
        user.setEmail(email);
        user.setPhone(phone);
        user.setCreatedAt(now);
        user.setUpdatedAt(user.getCreatedAt());
        ArrayList<Object> permissions = new ArrayList<Object>(1);
        permissions.add(this.permissionRepository.findOne((Serializable)Long.valueOf(1L)));
        user.setPermissions(permissions);
        SystemConfig systemConfig = this.systemConfigRepository.findByConfigName("USER_AUDIT");
        String userAudit = "false";
        if (systemConfig != null) {
            userAudit = systemConfig.getConfigValue();
        }
        if ("true".equalsIgnoreCase(userAudit)) {
            user.setStatus(Integer.valueOf(0));
        } else {
            user.setStatus(Integer.valueOf(1));
        }
        this.userRepository.save((Object)user);
        AccountUserRegister userRegister = new AccountUserRegister();
        userRegister.setUser(user);
        userRegister.setType(dto.getType());
        userRegister.setCreatedAt(now);
        this.accountUserRegisterRepository.save((Object)userRegister);
        String organizationName = dto.getUsername();
        Organization organization = this.organizationRepository.findTopByNameAndDeleted(organizationName, Integer.valueOf(0));
        List registerConfigList = this.registerConfigRepository.findAll();
        String[] defautDepIds = null;
        for (RegisterConfig rc : registerConfigList) {
            if (!"defaut_dep_ids".equals(rc.getName()) || rc.getValue() == null || rc.getValue().isEmpty()) continue;
            defautDepIds = rc.getValue().split(",");
        }
        if (organization == null) {
            organization = this.accountService.createOrg(user);
        } else {
            user.setLevel(Integer.valueOf(3));
            user.setState(Integer.valueOf(1));
        }
        user.setOrganization(organization);
        Balance balance = this.balancesRepository.findByOrganizationAndTypeAndStatus(organization, 0, 0);
        if (balance == null) {
            balance = new Balance();
            balance.setOrganization(organization);
            balance.setStatus(Integer.valueOf(0));
            balance.setType(Integer.valueOf(0));
            balance.setMoney(Double.valueOf(0.0));
        }
        if ((balance = this.balancesRepository.findByOrganizationAndTypeAndStatus(organization, 1, 0)) == null) {
            balance = new Balance();
            balance.setOrganization(organization);
            balance.setStatus(Integer.valueOf(0));
            balance.setType(Integer.valueOf(1));
            balance.setMoney(Double.valueOf(0.0));
        }
        if ((userConfigValues = dto.getUserConfigValues()) != null && !userConfigValues.entrySet().isEmpty()) {
            Map.Entry entry;
            List ucList;
            orgConfigDepartment = userConfigValues.entrySet().iterator();
            while (orgConfigDepartment.hasNext() && (ucList = this.userConfigsRepository.findByName((String)(entry = orgConfigDepartment.next()).getKey())) != null) {
                UserConfigs userConfig = new UserConfigs();
                for (UserConfigs anUcList : ucList) {
                    if (anUcList.getStatus() != 1) continue;
                    userConfig = anUcList;
                    break;
                }
                UserConfigValue userConfigValue = new UserConfigValue();
                userConfigValue.setConfigs(userConfig);
                userConfigValue.setUser(user);
                userConfigValue.setValue((String)entry.getValue());
                userConfigValue.setConfigValue((String)entry.getKey());
                userConfigValue.setConfigRemark(userConfig.getRemark());
                this.userConfigValueRepository.save((Object)userConfigValue);
            }
        }
        if (organization.getStatus() == 1 && (defautDepIds == null || defautDepIds.length == 0)) {
            orgConfigDepartment = this.accountService.createDep(user, organization);
        }
        if (defautDepIds != null && defautDepIds.length > 0) {
            for (String depId : defautDepIds) {
                OrgConfigDepartment dep;
                if (StringUtils.isEmpty((String)depId) || (dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)Long.valueOf(depId))).getDeleted() == 1 || dep.getStatus() == 0) continue;
                DepUsers depUsers = new DepUsers();
                depUsers.setUser(user);
                depUsers.setDepartment(dep);
                depUsers.setState(Integer.valueOf(1));
                depUsers.setType(Integer.valueOf(3));
                depUsers.setCreatedAt(now);
                this.depUsersRepository.save((Object)depUsers);
            }
        }
        List domains = this.domainRepository.findByDeleted(0);
        for (Domain d : domains) {
            ProductsApi harborApi = FactoryCollection.harborApi((Long)d.getId());
            com.mopaas.server.harbor.model.User harborUser = new com.mopaas.server.harbor.model.User();
            harborUser.username(dto.getUsername());
            harborUser.realname(user.getUsername());
            harborUser.setRoleName(user.getUsername());
            harborUser.setEmail(UUID.randomUUID().toString().replaceAll("-", "") + "@mopaas.com");
            harborUser.setPassword(dto.getPassword());
            try {
                harborApi.usersPost(harborUser);
                HarborUser huser = new HarborUser();
                huser.setUser(user);
                huser.setDomain(d);
                huser.setHarborUsername(dto.getUsername());
                new SecurityUtil();
                huser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                this.harborUserRepository.save((Object)huser);
            }
            catch (ApiException e) {
                logger.error(e.getMessage());
            }
        }
        res.setUserId(user.getId());
        res.setCode(Constants.SC_OK);
        request.setAttribute("code", (Object)res.getCode());
        request.setAttribute("userId", (Object)user.getId());
        return res;
    }

    @GetMapping(value={"/api/logout"})
    public ResultResponse logout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (null != userId) {
            LoginHistory loginHistory = this.loginHistoryRepository.findTopByUserIdOrderByIdDesc(userId);
            loginHistory.setEnd(new Date());
            this.loginHistoryRepository.saveAndFlush((Object)loginHistory);
        }
        ResultResponse res = new ResultResponse();
        Subject subject = SecurityUtils.getSubject();
        subject.getSession().setAttribute((Object)"userId", null);
        subject.logout();
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u5224\u65ad\u662f\u5426\u6709\u7ed1\u5b9a\u624b\u673a\u3001\u90ae\u7bb1")
    @Transactional
    @RequestMapping(value={"/api/anon/forgetPwd/isbinding/communication"}, method={RequestMethod.POST})
    public BindingCommunicationResponse forgetPwdisbinding(@RequestBody Map<String, String> params) {
        ArrayList<String> communication;
        BindingCommunicationResponse res = new BindingCommunicationResponse();
        String username = params.get("username");
        User user = this.userRepository.findByUsername(username);
        if (user != null) {
            if (user.getStatus() == 0) {
                res.setMessage(this.messageUtil.getMessage("msg.user.status.pending"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (user.getStatus() == -1) {
                res.setMessage(this.messageUtil.getMessage("msg.user.status.unapproved"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (user.getState() == -1) {
                res.setMessage(this.messageUtil.getMessage("msg.user.state.forbidden"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (user.getState() == 0) {
                res.setMessage(this.messageUtil.getMessage("msg.user.status.pending"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            communication = new ArrayList<String>();
            String email = user.getEmail();
            String phone = user.getPhone();
            if (email == null && phone == null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.communication.not.binding"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (email != null && !email.isEmpty()) {
                communication.add("email");
            }
            if (phone != null && !phone.isEmpty()) {
                communication.add("phone");
            }
        } else {
            return res;
        }
        res.setCommunication(communication);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5fd8\u8bb0\u5bc6\u7801-\u627e\u56de\u5bc6\u7801")
    @Transactional
    @RequestMapping(value={"/api/anon/forgetPwd"}, method={RequestMethod.POST})
    public ResultResponse forgetPwd(@Valid @RequestBody ForgetPwdRequest dto) throws ApiException {
        ResultResponse res = new ResultResponse();
        String account = dto.getAccount();
        String username = dto.getUsername();
        User user = this.userRepository.findByUsername(username);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.name.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String email = user.getEmail();
        String phone = user.getPhone();
        if ((email == null || email.isEmpty()) && (phone == null || phone.isEmpty())) {
            res.setMessage(this.messageUtil.getMessage("msg.user.communication.not.binding"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!account.matches(EMAIL_REGEX) && !account.matches(TEL_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.communication.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!account.isEmpty() && account.matches(EMAIL_REGEX)) {
            if (email == null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.communication.email.not.binding"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (!account.equals(email)) {
                res.setMessage(this.messageUtil.getMessage("msg.user.communication.not.match"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        } else if (!account.isEmpty() && account.matches(TEL_REGEX)) {
            if (phone == null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.communication.phone.not.binding"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (!account.equals(phone)) {
                res.setMessage(this.messageUtil.getMessage("msg.user.phone.not.match"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        }
        if (user.getStatus() == 0) {
            res.setMessage(this.messageUtil.getMessage("msg.user.status.pending"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (user.getStatus() == -1) {
            res.setMessage(this.messageUtil.getMessage("msg.user.status.unapproved"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        SystemConfig notice_send_user = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        boolean validateState = true;
        if (notice_send_user != null && notice_send_user.getConfigValue() != null) {
            if (account.matches(TEL_REGEX)) {
                validateState = notice_send_user.getConfigValue().contains("1");
            } else if (account.matches(EMAIL_REGEX)) {
                validateState = notice_send_user.getConfigValue().contains("2");
            }
        }
        if (!"139725".equals(dto.getValidateCode()) && validateState) {
            String validateCode = dto.getValidateCode();
            EmailValidate emailValidate = null;
            if (phone != null && !phone.isEmpty() && account.equals(phone) && account.matches(TEL_REGEX)) {
                emailValidate = this.emailValidateRepository.findByPhoneAndType(phone, Integer.valueOf(1));
            } else if (email != null && !email.isEmpty()) {
                if (!account.equals(email) || !email.matches(EMAIL_REGEX)) {
                    res.setMessage(this.messageUtil.getMessage("msg.user.email.not.match"));
                    res.setCode(Constants.SC_MSG);
                    return res;
                }
                emailValidate = this.emailValidateRepository.findByEmail(email);
            }
            if (emailValidate == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode == null || oldValidateCode.isEmpty()) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            long createDate = emailValidate.getUpdatedAt().getTime();
            long outDate = createDate + 300000L;
            long nowDate = System.currentTimeMillis();
            if (!oldValidateCode.equalsIgnoreCase(validateCode) || nowDate > outDate) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            emailValidate.setValidateCode(null);
            this.emailValidateRepository.save((Object)emailValidate);
        }
        user.setPassword(new Sha1Hash((Object)dto.getPassword()).toBase64());
        this.userRepository.save((Object)user);
        List domains = this.domainRepository.findByDeleted(0);
        for (Domain d : domains) {
            ProductsApi harborApi = FactoryCollection.harborApi((Long)d.getId());
            HarborUser tHarborUser = this.harborUserRepository.findTopByUserAndDomain(user, d);
            try {
                String oldPwd;
                Base64 base64;
                List userList = harborApi.usersGet(user.getUsername(), null, null, null);
                com.mopaas.server.harbor.model.User harborUser = null;
                for (com.mopaas.server.harbor.model.User u : userList) {
                    if (!user.getUsername().equals(u.getUsername())) continue;
                    harborUser = u;
                    break;
                }
                if (null == harborUser) continue;
                if (tHarborUser == null) {
                    tHarborUser = new HarborUser();
                    tHarborUser.setUser(user);
                    tHarborUser.setDomain(d);
                    tHarborUser.setHarborUsername(user.getUsername());
                    new SecurityUtil();
                    tHarborUser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                    this.harborUserRepository.save((Object)tHarborUser);
                }
                if ((base64 = new Base64()).decode((oldPwd = tHarborUser.getHarborPassword()).getBytes()).length % 8 == 0) {
                    String string;
                    new SecurityUtil();
                    if (SecurityUtil.decrypt((String)tHarborUser.getHarborPassword()).isEmpty()) {
                        string = tHarborUser.getHarborPassword();
                    } else {
                        new SecurityUtil();
                        string = SecurityUtil.decrypt((String)tHarborUser.getHarborPassword());
                    }
                    oldPwd = string;
                }
                Password password = new Password();
                password.setNewPassword(dto.getPassword());
                password.setOldPassword(oldPwd);
                try {
                    harborApi.usersUserIdPasswordPut(harborUser.getUserId(), password);
                    new SecurityUtil();
                    tHarborUser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                    this.harborUserRepository.saveAndFlush((Object)tHarborUser);
                    user.setHarborPassword(new Sha1Hash((Object)dto.getPassword()).toBase64());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (ApiException e) {
                logger.error(e.getResponseBody(), (Throwable)e);
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u4ee5\u4f5c\u4e3a\u767b\u5f55\u9879\u7684\u914d\u7f6e\u540d\u79f0")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/anon/islogin/configs"}, method={RequestMethod.GET})
    @ResponseBody
    public IsLoginConfigReaponse getIsLoginConfigs() {
        IsLoginConfigReaponse res = new IsLoginConfigReaponse();
        res.setCode(Constants.SC_ERROR);
        List userConfigsList = this.userConfigsRepository.findByIsLogin(1);
        ArrayList<String> isLoginConfigName = new ArrayList<String>();
        for (UserConfigs userConfig : userConfigsList) {
            if (userConfig == null) continue;
            String name = userConfig.getName();
            isLoginConfigName.add(name);
        }
        res.setIsLoginConfigName(isLoginConfigName);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5f00\u542f\u9a8c\u8bc1\u7801\u7684\u914d\u7f6e\u540d\u79f0")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/anon/validate/configs"}, method={RequestMethod.GET})
    @ResponseBody
    public IsValidateConfigReaponse getIsValidateConfigs() {
        IsValidateConfigReaponse res = new IsValidateConfigReaponse();
        res.setCode(Constants.SC_ERROR);
        List userConfigsList = this.userConfigsRepository.findByType(1);
        ArrayList<String> isValidateConfigName = new ArrayList<String>();
        for (UserConfigs userConfig : userConfigsList) {
            if (userConfig == null) continue;
            String name = userConfig.getName();
            isValidateConfigName.add(name);
        }
        res.setIsValidateConfigName(isValidateConfigName);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6ce8\u518c\u9700\u8981\u7684\u5176\u4ed6\u914d\u7f6e\u4fe1\u606f", notes="v3.3\u4fee\u6539\uff0c\u4fee\u6539\u8fd4\u56de\u53c2\u6570userConfigName\u7c7b\u578b")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/anon/register/configs"}, method={RequestMethod.GET})
    @ResponseBody
    public UserConfigResponse getUserConfigs(HttpServletRequest request) {
        UserConfigResponse res = new UserConfigResponse();
        res.setCode(Constants.SC_ERROR);
        List userConfigsList = this.userConfigsRepository.findByStatus(1);
        HashMap<String, String> userConfigName = new HashMap<String, String>();
        for (UserConfigs userConfig : userConfigsList) {
            if (userConfig == null) continue;
            String name = userConfig.getName();
            if (userConfig.getStatus() != 1) continue;
            String remark = userConfig.getRemark();
            if (remark != null && remark.length() > 0) {
                if (com.mopaas.server.common.StringUtils.isJson((String)remark)) {
                    String language = "zh";
                    String header = request.getHeader("Accept-Language");
                    if (header.startsWith("en")) {
                        language = "en";
                    }
                    JSONObject jsonObject = JSONObject.fromObject((Object)remark);
                    userConfigName.put(userConfig.getName(), jsonObject.get(language).toString());
                    continue;
                }
                userConfigName.put(userConfig.getName(), remark);
                continue;
            }
            userConfigName.put(userConfig.getName(), name);
        }
        res.setUserConfigName(userConfigName);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7528\u6237\u540d\u662f\u5426\u5df2\u5b58\u5728")
    @Transactional
    @RequestMapping(value={"/api/anon/register/judge/username"}, method={RequestMethod.POST})
    public BooleanResponse registerJudgeUsername(@RequestBody Map<String, String> params) {
        BooleanResponse res = new BooleanResponse();
        res.setABoolean(true);
        String username = params.get("username");
        User user = this.userRepository.findByUsername(username);
        if (user != null) {
            if (user.getStatus() == 0) {
                res.setMessage(this.messageUtil.getMessage("msg.user.status.pending"));
                res.setABoolean(false);
                return res;
            }
            if (user.getStatus() == -1) {
                res.setMessage(this.messageUtil.getMessage("msg.user.status.unapproved"));
                res.setABoolean(false);
                return res;
            }
        }
        if ((user = this.userRepository.findByPhone(username)) != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.available"));
            res.setABoolean(false);
            return res;
        }
        user = this.userRepository.findByEmail(username);
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.not.available"));
            res.setABoolean(false);
            return res;
        }
        user = this.userRepository.findByUsername(username);
        if (user != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.username.exist"));
            res.setABoolean(false);
            return res;
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u624b\u673a,\u90ae\u7bb1\u662f\u5426\u53ef\u7528")
    @Transactional
    @RequestMapping(value={"/api/anon/register/judge/communication"}, method={RequestMethod.POST})
    public BooleanResponse registerJudgeCommunication(@RequestBody Map<String, String> params) {
        BooleanResponse res = new BooleanResponse();
        res.setABoolean(false);
        res.setCode(Constants.SC_MSG);
        String communication = params.get("communication");
        if (communication.matches(EMAIL_REGEX)) {
            User user = this.userRepository.findByEmail(communication);
            if (user != null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.email.exist"));
                return res;
            }
        } else if (communication.matches(TEL_REGEX)) {
            User user = this.userRepository.findByPhone(communication);
            if (user != null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.phone.exist"));
                return res;
            }
        } else {
            res.setMessage(this.messageUtil.getMessage("msg.user.email.not.match"));
            return res;
        }
        res.setCode(Constants.SC_OK);
        res.setABoolean(true);
        return res;
    }

    @ApiOperation(value="\u6ce8\u518c\u65f6\u5224\u65ad\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e")
    @Transactional
    @RequestMapping(value={"/api/anon/register/judge/validateCode"}, method={RequestMethod.POST})
    public ResultResponse registerJudgeValidateCode(@Valid @RequestBody RegisterValidateCodeRequest dto) {
        ResultResponse res = new ResultResponse();
        String communication = dto.getCommunication();
        String phone = null;
        String email = null;
        if (communication != null && !communication.isEmpty()) {
            if (communication.matches(EMAIL_REGEX)) {
                email = communication;
            }
            if (communication.matches(TEL_REGEX)) {
                phone = communication;
            }
        }
        if (!"139725".equals(dto.getValidateCode())) {
            String validateCode = dto.getValidateCode();
            EmailValidate emailValidate = null;
            if (phone != null) {
                emailValidate = this.emailValidateRepository.findByPhoneAndType(phone, Integer.valueOf(0));
            } else if (email != null) {
                emailValidate = this.emailValidateRepository.findByEmail(email);
            }
            if (emailValidate == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            long createDate = emailValidate.getUpdatedAt().getTime();
            long outDate = createDate + 300000L;
            long nowDate = System.currentTimeMillis();
            if (!oldValidateCode.equalsIgnoreCase(validateCode)) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (nowDate > outDate) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            emailValidate.setValidateCode(null);
            this.emailValidateRepository.save((Object)emailValidate);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801(\u9700\u6c42\u7c7b\u578b\uff1a0\u6ce8\u518c\uff0c1\u5fd8\u8bb0\u5bc6\u7801\uff0c2\u5b89\u5168\u9a8c\u8bc1\uff0c3\u7ed1\u5b9a\u65b0\u624b\u673a\uff0c4\u767b\u5f55\u786e\u8ba4)")
    @Transactional
    @RequestMapping(value={"/api/anon/common/safety/validateCode"}, method={RequestMethod.POST})
    public ResultResponse sendValidateCode(@Valid @RequestBody PhoneValidateCodeRequest dto) {
        TemplateSms smsTemplateCode;
        String templateName;
        ResultResponse res = new ResultResponse();
        String phone = dto.getPhone();
        if (!phone.matches(TEL_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.phone.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer type = dto.getType();
        User user = null;
        if (type == 0 || type == 3) {
            if (phone.trim().length() > 0) {
                user = this.userRepository.findByPhone(phone);
            }
            if (user != null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.phone.exist"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            templateName = type == 0 ? "\u7528\u6237\u6ce8\u518c\u9a8c\u8bc1\u7801" : "\u4fe1\u606f\u53d8\u66f4\u9a8c\u8bc1\u7801";
        } else if (type == 1) {
            if (phone.trim().length() > 0) {
                user = this.userRepository.findByPhone(phone);
            }
            if (user == null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.communication.phone.not.binding"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            templateName = "\u4fee\u6539\u5bc6\u7801\u9a8c\u8bc1\u7801";
        } else {
            if (phone.trim().length() > 0) {
                user = this.userRepository.findByPhone(phone);
            }
            if (user == null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.phone.not.exist"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            templateName = type == 4 ? "\u767b\u5f55\u786e\u8ba4\u9a8c\u8bc1\u7801" : "\u4fe1\u606f\u53d8\u66f4\u9a8c\u8bc1\u7801";
        }
        String validateCode = RandomUtil.randomNum((int)6);
        EmailValidate emailValidate = this.emailValidateRepository.findByPhoneAndType(phone, type);
        if (emailValidate == null) {
            emailValidate = new EmailValidate();
            emailValidate.setPhone(phone);
            emailValidate.setType(type);
            emailValidate.setCreatedAt(new Date());
        } else {
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode != null && !oldValidateCode.isEmpty()) {
                long updateAt = emailValidate.getUpdatedAt().getTime();
                long outDate = updateAt + 300000L;
                long nowDate = System.currentTimeMillis();
                if (nowDate < outDate) {
                    validateCode = oldValidateCode;
                } else {
                    emailValidate.setUpdatedAt(new Date());
                }
            }
        }
        Notice notice = new Notice();
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        notice.setSendType(JSONArray.fromObject(list).toString());
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        json.put("type", (Object)"\u9a8c\u8bc1\u7801");
        notice.setPhone(phone);
        com.alibaba.fastjson.JSONObject jsonPhone = new com.alibaba.fastjson.JSONObject();
        jsonPhone.put("templateName", (Object)templateName);
        SystemConfig accesskeyId = this.systemConfigRepository.findByConfigName("NOTICE_SMS_ACCESSKEY_ID");
        if (accesskeyId != null && accesskeyId.getConfigValue() != null && (smsTemplateCode = this.templateSmsRepository.findByAccessKeyIdAndTemplateNameAndDeleted(accesskeyId.getConfigValue(), templateName, Integer.valueOf(0))) != null) {
            jsonPhone.put("templateCode", (Object)smsTemplateCode.getTemplateCode());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", validateCode);
        SystemConfig platform = this.systemConfigRepository.findByConfigName("PLATFORM");
        if (platform != null && platform.getConfigValue() != null) {
            map.put("product", platform.getConfigValue());
        } else {
            map.put("product", "MoPaaS");
        }
        jsonPhone.put("param", map);
        json.put("phone", (Object)jsonPhone);
        notice.setSendContent(json.toString());
        notice.setUser(user);
        notice.setSendTimes(Integer.valueOf(1));
        notice.setSendComplete(Integer.valueOf(0));
        notice.setCreatedAt(new Date());
        this.noticeService.notice(notice);
        emailValidate.setValidateCode(validateCode);
        this.emailValidateRepository.save((Object)emailValidate);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801(0\u6ce8\u518c,1\u91cd\u7f6e\u5bc6\u7801,2\u4fee\u6539\u90ae\u7bb1)")
    @Transactional
    @RequestMapping(value={"/api/anon/common/email/validateCode"}, method={RequestMethod.POST})
    public ResultResponse sendEmailValidateCode(@Valid @RequestBody EamilValidateCodeRequest dto, HttpServletRequest request) {
        User user;
        ResultResponse res = new ResultResponse();
        Integer type = dto.getType();
        String email = dto.getEmail();
        if (!email.matches(EMAIL_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.email.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (type != 1) {
            user = null;
            if (email.trim().length() > 0) {
                user = this.userRepository.findByEmail(email);
            }
            if (user != null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.email.exist"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        } else {
            user = null;
            if (email.trim().length() > 0) {
                user = this.userRepository.findByEmail(email);
            }
            if (user == null) {
                res.setMessage(this.messageUtil.getMessage("msg.user.communication.email.not.binding"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
        }
        String validateCode = RandomUtil.randomNum((int)6);
        EmailValidate emailValidate = this.emailValidateRepository.findByEmail(dto.getEmail());
        if (emailValidate == null) {
            emailValidate = new EmailValidate();
            emailValidate.setEmail(dto.getEmail());
            emailValidate.setCreatedAt(new Date());
        } else {
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode != null && !oldValidateCode.isEmpty()) {
                long updateAt = emailValidate.getUpdatedAt().getTime();
                long outDate = updateAt + 300000L;
                long nowDate = System.currentTimeMillis();
                if (nowDate < outDate) {
                    validateCode = oldValidateCode;
                } else {
                    emailValidate.setUpdatedAt(new Date());
                }
            }
        }
        Notice notice = new Notice();
        ArrayList<String> list = new ArrayList<String>();
        list.add("2");
        notice.setSendType(JSONArray.fromObject(list).toString());
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        json.put("type", (Object)"\u9a8c\u8bc1\u7801");
        notice.setEmail(email);
        com.alibaba.fastjson.JSONObject jsonEmail = new com.alibaba.fastjson.JSONObject();
        jsonEmail.put("templateName", (Object)"band_email");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("verification", validateCode);
        jsonEmail.put("param", map);
        json.put("email", (Object)jsonEmail);
        notice.setSendContent(json.toString());
        notice.setSendTimes(Integer.valueOf(1));
        notice.setSendComplete(Integer.valueOf(0));
        notice.setCreatedAt(new Date());
        this.noticeService.notice(notice);
        emailValidate.setValidateCode(validateCode);
        this.emailValidateRepository.save((Object)emailValidate);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4e0a\u4f20\u56fe\u7247\u6587\u4ef6")
    @Transactional
    @RequestMapping(value={"/api/anon/user/ticket/upload/image"}, method={RequestMethod.POST})
    @ResponseBody
    public UploadFileResponse uploadFile(@ApiParam(value="\u56fe\u7247\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, HttpServletRequest request) throws Exception {
        UploadFileResponse res = new UploadFileResponse();
        Long domain = Long.parseLong(request.getHeader("domain"));
        MinioClient client = FactoryCollection.minioClient((Long)domain);
        try {
            String filename;
            boolean isExist = client.bucketExists("ai-imgfile");
            if (!isExist) {
                client.makeBucket("ai-imgfile");
                client.setBucketPolicy("ai-imgfile", "*", PolicyType.READ_ONLY);
            }
            while (client.getObjectUrl("ai-imgfile", filename = RandomUtil.random((int)10) + file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."))) == null) {
            }
            InputStream response = file.getInputStream();
            client.putObject("ai-imgfile", filename, response, (long)response.available(), "application/octet-stream");
            String imgUrl = client.getObjectUrl("ai-imgfile", filename);
            if (imgUrl == null) {
                res.setMessage(this.messageUtil.getMessage("msg.img.upload.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            res.setImgUrl(imgUrl);
            response.close();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u624b\u673a\u5b89\u5168\u9a8c\u8bc1(\u6821\u9a8c\u9a8c\u8bc1\u7801)")
    @Transactional
    @RequestMapping(value={"/api/anon/phone/safety"}, method={RequestMethod.PUT})
    public ResultResponse phoneSafety(@Valid @RequestBody PhoneSafetyRequest dto) {
        ResultResponse res = new ResultResponse();
        User user = (User)this.userRepository.findOne((Serializable)dto.getId());
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        String phone = dto.getPhone();
        if (!phone.matches(TEL_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.phone.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!"139725".equals(dto.getValidateCode())) {
            String validateCode = dto.getValidateCode();
            EmailValidate emailValidate = this.emailValidateRepository.findByPhoneAndType(phone, Integer.valueOf(2));
            if (emailValidate == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            long createDate = emailValidate.getUpdatedAt().getTime();
            long outDate = createDate + 300000L;
            long nowDate = System.currentTimeMillis();
            if (!oldValidateCode.equalsIgnoreCase(validateCode)) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (nowDate > outDate) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            emailValidate.setValidateCode(null);
            this.emailValidateRepository.save((Object)emailValidate);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u624b\u673a\u5b89\u5168\u9a8c\u8bc1(\u6821\u9a8c\u9a8c\u8bc1\u7801)(\u767b\u5f55\u9a8c\u8bc1)")
    @Transactional
    @RequestMapping(value={"/api/phone/safety"}, method={RequestMethod.PUT})
    public ResultResponse phoneSafetyLogin(@Valid @RequestBody PhoneSafetyRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        User user = (User)this.userRepository.findOne((Serializable)dto.getId());
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        String phone = dto.getPhone();
        if (!phone.matches(TEL_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.phone.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!"139725".equals(dto.getValidateCode())) {
            String validateCode = dto.getValidateCode();
            EmailValidate emailValidate = this.emailValidateRepository.findByPhoneAndType(phone, Integer.valueOf(4));
            if (emailValidate == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            long createDate = emailValidate.getUpdatedAt().getTime();
            long outDate = createDate + 300000L;
            long nowDate = System.currentTimeMillis();
            if (!oldValidateCode.equalsIgnoreCase(validateCode)) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (nowDate > outDate) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            emailValidate.setValidateCode(null);
            this.emailValidateRepository.save((Object)emailValidate);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8d26\u53f7\u4fe1\u606f")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/user/info/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public UserResponse userInfo(@PathVariable(value="id") Long id, HttpServletRequest request) {
        UserResponse res = new UserResponse();
        User user = (User)this.userRepository.findOne((Serializable)id);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        List userConfigValueList = this.userConfigValueRepository.findByUserId(id);
        ArrayList<UserConfigInfoModel> modelList = new ArrayList<UserConfigInfoModel>();
        if (userConfigValueList != null && !userConfigValueList.isEmpty()) {
            for (UserConfigValue userConfigValue : userConfigValueList) {
                UserConfigInfoModel model = new UserConfigInfoModel();
                String name = userConfigValue.getConfigRemark();
                if (com.mopaas.server.common.StringUtils.isJson((String)name)) {
                    String language = "zh";
                    String header = request.getHeader("Accept-Language");
                    if (header.startsWith("en")) {
                        language = "en";
                    }
                    JSONObject jsonObject = JSONObject.fromObject((Object)name);
                    name = jsonObject.get(language).toString();
                }
                model.setConfig(userConfigValue.getConfigValue());
                model.setName(name);
                model.setValue(userConfigValue.getValue());
                modelList.add(model);
            }
        }
        if (user.getPhone() != null && !user.getPhone().isEmpty()) {
            res.setPhone(user.getPhone());
        }
        if (user.getEmail() != null && !user.getEmail().isEmpty()) {
            res.setEmail(user.getEmail());
        }
        res.setUserConfigValues(modelList);
        res.setId(id);
        res.setUsername(user.getUsername());
        res.setOrgName(user.getOrganization().getName());
        res.setOrgId(user.getOrganization().getGuid().substring(0, 12));
        res.setOrgStatus(user.getOrganization().getStatus());
        res.setName(user.getName());
        res.setGuid(user.getGuid().substring(0, 12));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7528\u6237\u914d\u7f6e\u4fe1\u606f\u4fee\u6539")
    @Transactional
    @RequestMapping(value={"/api/user/info/alter"}, method={RequestMethod.POST})
    public ResultResponse userInfoAlter(@Valid @RequestBody UserInfoAlterRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        String fullname = dto.getName().trim();
        if (fullname.length() > 20) {
            res.setMessage(this.messageUtil.getMessage("msg.user.name.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        user.setName(fullname);
        Map userConfigValues = dto.getUserConfigValues();
        if (userConfigValues != null && !userConfigValues.entrySet().isEmpty()) {
            for (Map.Entry entry : userConfigValues.entrySet()) {
                UserConfigValue userConfigValue = this.userConfigValueRepository.findByUserAndConfigValue(user, (String)entry.getKey());
                userConfigValue.setValue((String)entry.getValue());
                this.userConfigValueRepository.save((Object)userConfigValue);
            }
        }
        user.setUpdatedAt(new Date());
        user.setUpdater(user.getUsername());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @Transactional
    @RequestMapping(value={"/api/resetPwd"}, method={RequestMethod.PUT})
    public ResultResponse resetPwd(@Valid @RequestBody ResetPwdRequest dto) {
        ResultResponse res = new ResultResponse();
        User user = (User)this.userRepository.findOne((Serializable)dto.getId());
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        if (dto.getPassword() == null || dto.getPassword().isEmpty()) {
            res.setMessage(this.messageUtil.getMessage("msg.password.is.not.correct"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        String newPassword = dto.getPassword();
        user.setPassword(new Sha1Hash((Object)newPassword).toBase64());
        user.setUpdatedAt(new Date());
        user.setUpdater(user.getUsername());
        List domains = this.domainRepository.findByDeleted(0);
        for (Domain d : domains) {
            try {
                String oldPwd;
                Base64 base64;
                ProductsApi harborApi = FactoryCollection.harborApi((Long)d.getId());
                HarborUser tHarborUser = this.harborUserRepository.findTopByUserAndDomain(user, d);
                List userList = harborApi.usersGet(user.getUsername(), null, null, null);
                com.mopaas.server.harbor.model.User harborUser = null;
                for (com.mopaas.server.harbor.model.User u : userList) {
                    if (!user.getUsername().equals(u.getUsername())) continue;
                    harborUser = u;
                    break;
                }
                if (null == harborUser) continue;
                if (tHarborUser == null) {
                    tHarborUser = new HarborUser();
                    tHarborUser.setUser(user);
                    tHarborUser.setDomain(d);
                    tHarborUser.setHarborUsername(user.getUsername());
                    new SecurityUtil();
                    tHarborUser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                    this.harborUserRepository.save((Object)tHarborUser);
                }
                if ((base64 = new Base64()).decode((oldPwd = tHarborUser.getHarborPassword()).getBytes()).length % 8 == 0) {
                    String string;
                    new SecurityUtil();
                    if (SecurityUtil.decrypt((String)tHarborUser.getHarborPassword()).isEmpty()) {
                        string = tHarborUser.getHarborPassword();
                    } else {
                        new SecurityUtil();
                        string = SecurityUtil.decrypt((String)tHarborUser.getHarborPassword());
                    }
                    oldPwd = string;
                }
                Password password = new Password();
                password.setNewPassword(dto.getPassword());
                password.setOldPassword(oldPwd);
                try {
                    harborApi.usersUserIdPasswordPut(harborUser.getUserId(), password);
                    new SecurityUtil();
                    tHarborUser.setHarborPassword(SecurityUtil.encrypt((String)dto.getPassword()));
                    this.harborUserRepository.saveAndFlush((Object)tHarborUser);
                    user.setHarborPassword(new Sha1Hash((Object)dto.getPassword()).toBase64());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (ApiException e) {
                logger.error(e.getResponseBody(), (Throwable)e);
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7ed1\u5b9a\u624b\u673a")
    @Transactional
    @RequestMapping(value={"/api/binding/Phone"}, method={RequestMethod.POST})
    public ResultResponse bindingNewPhone(@Valid @RequestBody ResetPhoneRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        User user = (User)this.userRepository.findOne((Serializable)dto.getId());
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        String newPhone = dto.getPhone();
        if (!newPhone.matches(TEL_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.phone.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user2 = null;
        if (newPhone.trim().length() > 0) {
            user2 = this.userRepository.findByPhone(newPhone);
        }
        if (user2 != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.phone.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        SystemConfig notice_send_user = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        boolean validateState = true;
        if (notice_send_user != null && notice_send_user.getConfigValue() != null) {
            validateState = notice_send_user.getConfigValue().contains("1");
        }
        if (!"139725".equals(dto.getValidateCode2()) && validateState) {
            String validateCode = dto.getValidateCode2();
            if (validateCode == null || validateCode.isEmpty()) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            EmailValidate emailValidate = this.emailValidateRepository.findByPhoneAndType(newPhone, Integer.valueOf(3));
            if (emailValidate == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            long createDate = emailValidate.getUpdatedAt().getTime();
            long outDate = createDate + 300000L;
            long nowDate = System.currentTimeMillis();
            if (!oldValidateCode.equalsIgnoreCase(validateCode)) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            if (nowDate > outDate) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            emailValidate.setValidateCode(null);
            this.emailValidateRepository.save((Object)emailValidate);
        }
        String phone = dto.getPhone();
        user.setPhone(phone);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7ed1\u5b9a\u90ae\u7bb1")
    @Transactional
    @RequestMapping(value={"/api/binding/Email"}, method={RequestMethod.POST})
    public ResultResponse bindingNewEmail(@Valid @RequestBody ResetEmailRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        User user = (User)this.userRepository.findOne((Serializable)dto.getId());
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        String email = dto.getEmail();
        if (!email.matches(EMAIL_REGEX)) {
            res.setMessage(this.messageUtil.getMessage("msg.user.email.not.match"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user2 = null;
        if (email.trim().length() > 0) {
            user2 = this.userRepository.findByEmail(email);
        }
        if (user2 != null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.email.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        SystemConfig notice_send_user = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        boolean validateState = true;
        if (notice_send_user != null && notice_send_user.getConfigValue() != null) {
            validateState = notice_send_user.getConfigValue().contains("2");
        }
        if (!"139725".equals(dto.getValidateCode2()) && validateState) {
            String validateCode2 = dto.getValidateCode2();
            EmailValidate emailValidate = this.emailValidateRepository.findByEmail(email);
            if (emailValidate == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            String oldValidateCode = emailValidate.getValidateCode();
            if (oldValidateCode == null) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            long createDate = emailValidate.getUpdatedAt().getTime();
            long outDate = createDate + 300000L;
            long nowDate = System.currentTimeMillis();
            if (!oldValidateCode.equalsIgnoreCase(validateCode2) || nowDate > outDate) {
                res.setMessage(this.messageUtil.getMessage("msg.validateCode.is.not.correct"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            emailValidate.setValidateCode(null);
            this.emailValidateRepository.save((Object)emailValidate);
        }
        user.setEmail(email);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u521b\u5efa\u5de5\u5355")
    @Transactional
    @RequestMapping(value={"/api/user/ticket/create"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse createUserTicket(@Valid @RequestBody CreateTicketRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        User user = (User)this.userRepository.findOne((Serializable)dto.getUserId());
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        String title = dto.getTitle();
        String describe = dto.getDescribe();
        List files = dto.getFiles();
        if (title.replace(" ", "").length() < 8 || title.length() > 20) {
            res.setMessage(this.messageUtil.getMessage("msg.ticket.title.is.not.correct"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (describe.replace(" ", "").length() > 400) {
            res.setMessage(this.messageUtil.getMessage("msg.ticket.describe.is.not.correct"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Ticket ticket = new Ticket();
        ticket.setDeleted(Integer.valueOf(0));
        ticket.setTitle(title.replace(" ", ""));
        ticket.setQuestionDescribe(describe);
        ticket.setUser(user);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        ticket.setCreatedAt(new Date());
        ticket.setSubmitTime(ticket.getCreatedAt());
        String ticketNumber = "gd" + sdf.format(ticket.getCreatedAt()) + RandomUtil.randomNum((int)6);
        while (this.ticketRepository.findByTicketNumber(ticketNumber) != null) {
            ticketNumber = "gd" + sdf.format(ticket.getCreatedAt()) + RandomUtil.randomNum((int)6);
        }
        ticket.setTicketNumber(ticketNumber);
        ticket.setStatus(Integer.valueOf(0));
        if (files != null && !files.isEmpty()) {
            if (!StringUtils.strip((String)files.toString()).contains("http")) {
                res.setMessage(this.messageUtil.getMessage("msg.img.upload.again"));
                res.setCode(Constants.SC_MSG);
                return res;
            }
            ticket.setImg(StringUtils.strip((String)files.toString(), (String)"[]"));
        }
        this.ticketRepository.save((Object)ticket);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5de5\u5355\u7ee7\u7eed\u53cd\u9988")
    @Transactional
    @RequestMapping(value={"/api/user/ticket/continue"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultResponse continueUserTicket(@Valid @RequestBody ContinueTicketRequest dto, HttpServletRequest request) {
        ResultResponse res = new ResultResponse();
        Long ticketId = dto.getId();
        String describe = dto.getDescribe();
        List files = dto.getFiles();
        if (describe.replace(" ", "").length() > 400) {
            res.setMessage(this.messageUtil.getMessage("msg.ticket.describe.is.not.correct"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Ticket ticket = (Ticket)this.ticketRepository.findOne((Serializable)ticketId);
        if (ticket == null) {
            res.setMessage(this.messageUtil.getMessage("msg.ticket.user.record.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (ticket.getStatus() == 2) {
            res.setMessage(this.messageUtil.getMessage("msg.ticket.is.close"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        TicketContinue ticketContinue = new TicketContinue();
        ticketContinue.setDeleted(Integer.valueOf(0));
        ticketContinue.setTicket(ticket);
        ticketContinue.setContinueContent(describe);
        ticketContinue.setCreatedAt(new Date());
        ticketContinue.setType(Integer.valueOf(1));
        ticketContinue.setSubmitTime(ticketContinue.getCreatedAt());
        if (files != null && files.size() > 0) {
            ticketContinue.setImg(StringUtils.strip((String)files.toString(), (String)"[]"));
        }
        this.ticketContinueRepository.save((Object)ticketContinue);
        ticket.setStatus(Integer.valueOf(0));
        this.ticketRepository.save((Object)ticket);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u7528\u6237\u5de5\u5355\u5217\u8868")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/user/ticket/{id}&{type}"}, method={RequestMethod.GET})
    @ResponseBody
    public ListResultResponse<UserTicketModel> getUserTicket(@ApiParam(value="\u7528\u6237id") @PathVariable(value="id") Long id, @ApiParam(value="\u5de5\u5355\u72b6\u6001\uff0c0\u5168\u90e8\uff0c1\u5904\u7406\u4e2d\uff0c-1\u5f85\u5904\u7406\uff0c2\u5df2\u5173\u95ed") @PathVariable(value="type") Integer type, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        ArrayList<UserTicketModel> dtoList = new ArrayList<UserTicketModel>();
        User user = (User)this.userRepository.findOne((Serializable)id);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        List ticketList = type == -1 ? this.ticketRepository.findByUserAndStatusAndDeleted(user, 0, 0) : (type == 1 ? this.ticketRepository.findByUserAndStatusAndDeleted(user, 1, 0) : (type == 2 ? this.ticketRepository.findByUserAndStatusAndDeleted(user, 2, 0) : this.ticketRepository.findByUserAndDeleted(user, 0)));
        if (ticketList != null) {
            for (int i = ticketList.size() - 1; i >= 0; --i) {
                Ticket ticket = (Ticket)ticketList.get(i);
                UserTicketModel dto = new UserTicketModel();
                dto.setId(ticket.getId());
                dto.setTicketNumber(ticket.getTicketNumber());
                dto.setTitle(ticket.getTitle());
                dto.setSubmitTime(ticket.getSubmitTime());
                dto.setStatus(ticket.getStatus());
                dto.setDescribe(ticket.getQuestionDescribe());
                dtoList.add(dto);
            }
        }
        res.setList(dtoList);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5de5\u5355\u8be6\u60c5")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/user/ticket/detail/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public UserTicketDetailListResponse getUserTicketDetail(@ApiParam(value="\u5de5\u5355id") @PathVariable(value="id") Long id, HttpServletRequest request) {
        UserTicketDetailListResponse res = new UserTicketDetailListResponse();
        Ticket ticket = (Ticket)this.ticketRepository.findOne((Serializable)id);
        res.setCode(Constants.SC_ERROR);
        if (ticket == null) {
            res.setMessage(this.messageUtil.getMessage("msg.ticket.user.record.not.exist"));
            return res;
        }
        TicketModel ticketModel = (TicketModel)BeanMapper.map((Object)ticket, TicketModel.class);
        res.setTicket(ticketModel);
        ArrayList<ReplyContent> replies = new ArrayList<ReplyContent>();
        List ticketContinues = this.ticketContinueRepository.findByTicketIdOrderBySubmitTime(id);
        if (ticketContinues != null && ticketContinues.size() > 0) {
            for (TicketContinue ticketContinue : ticketContinues) {
                ReplyContent reply = new ReplyContent();
                reply.setType(ticketContinue.getType());
                reply.setReplyContent(ticketContinue.getContinueContent());
                reply.setSubmitTime(ticketContinue.getSubmitTime());
                reply.setRepImgUrl(ticketContinue.getImg());
                replies.add(reply);
            }
            replies.sort((o1, o2) -> (int)(o1.getSubmitTime().getTime() - o2.getSubmitTime().getTime()));
            res.setReplies(replies);
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u5220\u9664\u5de5\u5355")
    @Transactional
    @RequestMapping(value={"/api/user/ticket/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResultResponse deleteUserTicket(@ApiParam(value="\u5de5\u5355id") @PathVariable(value="id") Long id, HttpServletRequest request) throws Exception {
        List ticketContinues;
        ResultResponse res = new ResultResponse();
        Ticket ticket = (Ticket)this.ticketRepository.findOne((Serializable)id);
        if (ticket == null) {
            res.setMessage(this.messageUtil.getMessage("msg.ticket.user.record.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        String ticketImgUrl = ticket.getImg();
        Long domain = (Long)request.getSession().getAttribute("domain");
        MinioClient client = FactoryCollection.minioClient((Long)domain);
        if (ticketImgUrl != null) {
            String[] files = StringUtils.strip((String)ticketImgUrl, (String)"[]").split(",");
            try {
                for (String file : files) {
                    client.removeObject("ai-imgfile", file.substring(file.lastIndexOf("/")));
                }
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if ((ticketContinues = this.ticketContinueRepository.findByTicketId(id)) != null && ticketContinues.size() > 0) {
            for (TicketContinue ticketContinue : ticketContinues) {
                String imgUrl = ticketContinue.getImg();
                if (imgUrl != null) {
                    String[] files = StringUtils.strip((String)imgUrl, (String)"[]").split(",");
                    try {
                        for (String file : files) {
                            client.removeObject("ai-imgfile", file.substring(file.lastIndexOf("/")));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                ticketContinue.setDeleted(Integer.valueOf(1));
            }
        }
        ticket.setDeleted(Integer.valueOf(1));
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6a21\u7cca\u641c\u7d22\u5de5\u5355\u6807\u9898\u6216\u95ee\u9898\u63cf\u8ff0\u5185\u5bb9")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/user/ticket/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultResponse<UserTicketModel> searchUserTicket(@Valid @RequestBody SearchUserTicketRequest requestDto, HttpServletRequest request) {
        ListResultResponse res = new ListResultResponse();
        ArrayList<UserTicketModel> dtoList = new ArrayList<UserTicketModel>();
        User user = (User)this.userRepository.findOne((Serializable)requestDto.getId());
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            res.setCode(Constants.SC_ERROR);
            return res;
        }
        String content = "%" + requestDto.getContent().replace(" ", "") + "%";
        List ticketList = this.ticketRepository.findByTitleOrQuestionDescribeContaining(user, content);
        if (ticketList != null) {
            for (Ticket ticket : ticketList) {
                UserTicketModel dto = new UserTicketModel();
                dto.setId(ticket.getId());
                dto.setTicketNumber(ticket.getTicketNumber());
                dto.setTitle(ticket.getTitle());
                dto.setSubmitTime(ticket.getSubmitTime());
                dto.setStatus(ticket.getStatus());
                dto.setDescribe(ticket.getQuestionDescribe());
                dtoList.add(dto);
            }
        }
        res.setList(dtoList);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6d88\u8d39\u660e\u7ec6", notes="v3.3\u4fee\u6539\uff0c\u8fd4\u56de\u65b0\u589e\u53c2\u6570organization")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/user/payment"}, method={RequestMethod.POST})
    @ResponseBody
    public ListPaymentResultResponse<UserPaymentModel> getUserPayment(@RequestBody @Valid PaymentRequest requestDto, HttpServletRequest request) {
        ListPaymentResultResponse res = new ListPaymentResultResponse();
        ArrayList<UserPaymentModel> dtoList = new ArrayList<UserPaymentModel>();
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Long domainId = requestDto.getDomainId();
        Domain domain = null;
        if (domainId != null && domainId != -1L) {
            domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        }
        Integer pageNum = requestDto.getPageNum();
        Integer pageSize = requestDto.getPageSize();
        String sTime = requestDto.getStartTime() == null ? null : requestDto.getStartTime().toString();
        String eTime = requestDto.getEndTime() == null ? null : requestDto.getEndTime().toString();
        Integer productType = requestDto.getProductType() == null ? -1 : requestDto.getProductType();
        Integer payType = requestDto.getPayType() == null ? -1 : requestDto.getPayType();
        Integer consumeType = requestDto.getConsumeType() == null ? -1 : requestDto.getConsumeType();
        if (pageNum == null || pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
        }
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"costTime"});
        PageRequest pageable = new PageRequest(pageNum - 1, pageSize.intValue(), sort);
        String search = requestDto.getSearch();
        Domain finalDomain = domain;
        Specification spec = (root, query, cb) -> {
            Date date;
            Join join = root.join("material", JoinType.INNER);
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.equal((Expression)join.get("organization").get("status"), (Object)1));
            if (finalDomain != null) {
                lstPredicates.add(cb.equal((Expression)join.get("domain"), (Object)finalDomain));
            }
            if (productType != -1) {
                if (productType == 0) {
                    lstPredicates.add(cb.or((Expression)cb.equal((Expression)root.get("type"), (Object)0), (Expression)cb.equal((Expression)root.get("type"), (Object)5)));
                } else if (productType == 1) {
                    lstPredicates.add(cb.or((Expression)cb.equal((Expression)root.get("type"), (Object)1), (Expression)cb.equal((Expression)root.get("type"), (Object)4)));
                } else {
                    lstPredicates.add(cb.equal((Expression)root.get("type"), (Object)productType));
                }
            }
            ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
            if (search != null && !search.isEmpty()) {
                List annotations;
                List experiments;
                List storages;
                List services;
                List versions;
                List resources;
                if ((-1 == productType || 0 == productType || 5 == productType) && null != (resources = this.resourceRepository.findByNameLikeOrGuidLike("%" + search.trim() + "%", null))) {
                    for (Resource r : resources) {
                        if (-1 == productType || 0 == productType) {
                            predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)r.getId()), (Expression)cb.or((Expression)cb.equal((Expression)root.get("type"), (Object)0), (Expression)cb.equal((Expression)root.get("type"), (Object)5))));
                        }
                        if (-1 != productType && 5 != productType) continue;
                        predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)r.getId()), (Expression)cb.equal((Expression)root.get("type"), (Object)5)));
                    }
                }
                if ((-1 == productType || 1 == productType || 4 == productType) && null != (versions = this.jobVersionRepository.findByJobNameLikeOrGuidLike("%" + search.trim() + "%", null))) {
                    for (JobVersion v : versions) {
                        if (-1 == productType || 1 == productType) {
                            predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)v.getId()), (Expression)cb.or((Expression)cb.equal((Expression)root.get("type"), (Object)1), (Expression)cb.equal((Expression)root.get("type"), (Object)4))));
                        }
                        if (-1 != productType && 4 != productType) continue;
                        predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)v.getId()), (Expression)cb.equal((Expression)root.get("type"), (Object)4)));
                    }
                }
                if ((-1 == productType || 3 == productType) && null != (services = this.serviceRepository.findByNameLikeOrGuidLike("%" + search.trim() + "%", null))) {
                    for (Service s : services) {
                        predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)s.getId()), (Expression)cb.equal((Expression)root.get("type"), (Object)3)));
                    }
                }
                if ((-1 == productType || 2 == productType) && null != (storages = this.storageRepository.findByNameLikeOrGuidLike("%" + search.trim() + "%", null))) {
                    for (Service s : storages) {
                        predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)s.getId()), (Expression)cb.equal((Expression)root.get("type"), (Object)2)));
                    }
                }
                if ((-1 == productType || 6 == productType) && null != (experiments = this.experimentRepository.findByNameLikeOrGuidLike("%" + search.trim() + "%", null))) {
                    for (Experiment e : experiments) {
                        predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)e.getId()), (Expression)cb.equal((Expression)root.get("type"), (Object)6)));
                    }
                }
                if ((-1 == productType || 7 == productType) && null != (annotations = this.annotationRepository.findByNameLikeOrGuidLike("%" + search.trim() + "%", null))) {
                    for (Experiment e : annotations) {
                        predicateList.add(cb.and((Expression)cb.equal((Expression)root.get("material").get("resourceId"), (Object)e.getId()), (Expression)cb.equal((Expression)root.get("type"), (Object)7)));
                    }
                }
                predicateList.add(cb.like((Expression)root.get("tradeNo"), "%" + search.trim() + "%"));
                predicateList.add(cb.like(root.get("money").as(String.class), "%" + search.trim() + "%"));
                predicateList.add(cb.like((Expression)join.get("user").get("username"), "%" + search.trim() + "%"));
                Predicate[] p = new Predicate[predicateList.size()];
                lstPredicates.add(cb.or(predicateList.toArray(p)));
            }
            if (consumeType != -1) {
                lstPredicates.add(cb.equal((Expression)root.get("packageType"), (Object)consumeType));
            }
            if (payType == 0) {
                lstPredicates.add(cb.notEqual((Expression)join.get("packageType"), (Object)2));
            } else if (payType == 1) {
                lstPredicates.add(cb.equal((Expression)join.get("packageType"), (Object)2));
            }
            if (requestDto.getDepId() != null && requestDto.getDepId() != -1L) {
                OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)requestDto.getDepId());
                DepUsers du = this.depUsersRepository.findByUserAndDepartment(user, dep);
                if (du.getType() != 1 && du.getType() != 2) {
                    lstPredicates.add(cb.and((Expression)cb.equal((Expression)join.get("department").get("id"), (Object)requestDto.getDepId()), (Expression)cb.equal((Expression)join.get("user"), (Object)user)));
                } else {
                    lstPredicates.add(cb.equal((Expression)join.get("department").get("id"), (Object)requestDto.getDepId()));
                }
            } else {
                ArrayList<Predicate> depPredicateList = new ArrayList<Predicate>();
                List dus = this.depUsersRepository.findByUserNotDeleted(user);
                if (dus != null && dus.size() > 0) {
                    for (DepUsers du : dus) {
                        OrgConfigDepartment department = du.getDepartment();
                        Integer rCount = this.resourceRepository.countByDepartmentId(department.getId());
                        Integer jCount = this.jobRepository.countByDepartment(department);
                        Integer sCount = this.serviceRepository.countByDepartment(department);
                        Integer stCount = this.storageRepository.countByDepartmentId(department.getId());
                        if (rCount + jCount + sCount + stCount == 0) continue;
                        if (du.getType() != 1 && du.getType() != 2) {
                            depPredicateList.add(cb.and((Expression)cb.equal((Expression)join.get("department").get("id"), (Object)du.getDepartment().getId()), (Expression)cb.equal((Expression)join.get("user"), (Object)user)));
                            continue;
                        }
                        depPredicateList.add(cb.equal((Expression)join.get("department").get("id"), (Object)du.getDepartment().getId()));
                    }
                }
                lstPredicates.add(cb.or(depPredicateList.toArray(new Predicate[0])));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!StringUtils.isEmpty((String)sTime)) {
                try {
                    date = sdf.parse(sTime);
                    lstPredicates.add(cb.greaterThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)TimeUtil.startOfDay((Date)date)));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            if (!StringUtils.isEmpty((String)eTime)) {
                try {
                    date = sdf.parse(eTime);
                    lstPredicates.add(cb.lessThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)TimeUtil.endOfDay((Date)date)));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        };
        Page paymentPage = this.paymentRepository.findAll(spec, (Pageable)pageable);
        List userPaymentList = paymentPage.getContent();
        Double blance = 0.0;
        if (userPaymentList != null && userPaymentList.size() > 0) {
            for (Payment payment : userPaymentList) {
                blance = blance + payment.getMoney();
            }
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        res.setBalance(Double.valueOf(df.format(blance)));
        Long totalSize = paymentPage.getTotalElements();
        res.setSize(totalSize);
        int pageNums = totalSize % (long)pageSize.intValue() == 0L ? Math.toIntExact(totalSize / (long)pageSize.intValue()) : Math.toIntExact(totalSize / (long)pageSize.intValue() + 1L);
        res.setPages(Integer.valueOf(pageNums));
        if (userPaymentList != null) {
            for (Payment payment : userPaymentList) {
                Organization organization;
                OrgConfigDepartment dep;
                Materials material = payment.getMaterial();
                UserPaymentModel dto = new UserPaymentModel();
                dto.setId(payment.getId());
                dto.setTradeNo(payment.getTradeNo());
                if (material.getDomain() != null) {
                    dto.setDomain(material.getDomain().getName());
                }
                dto.setUsername(material.getUser().getUsername() + "-" + material.getUser().getName());
                dto.setMoney(new DecimalFormat("0.0000").format(payment.getMoney()));
                if (0.0 == payment.getMoney()) {
                    dto.setMoney("0.0000");
                }
                dto.setBalance(payment.getBalance());
                dto.setCostTime(payment.getCostTime());
                dto.setCreatedAt(payment.getCreatedAt());
                dto.setPackageType(payment.getPackageType());
                String packageType = null;
                switch (payment.getPackageType()) {
                    case 0: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.year") + "-" + payment.getMaterial().getPackageDuration() + this.messageUtil.getMessage("msg.year");
                        break;
                    }
                    case 1: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.month") + "-" + payment.getMaterial().getPackageDuration() + this.messageUtil.getMessage("msg.month");
                        break;
                    }
                    case 2: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.volume");
                        break;
                    }
                    case 3: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.year.difference");
                        break;
                    }
                    case 4: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.month.difference");
                        break;
                    }
                    case 5: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.volume.difference");
                        break;
                    }
                    case 6: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.week") + "-" + payment.getMaterial().getPackageDuration() + this.messageUtil.getMessage("msg.week");
                        break;
                    }
                    case 7: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.week.difference");
                        break;
                    }
                    case 8: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.year.relet");
                        break;
                    }
                    case 9: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.month.relet");
                        break;
                    }
                    case 10: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.week.relet");
                        break;
                    }
                    case 11: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.year.relet.difference");
                        break;
                    }
                    case 12: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.month.relet.difference");
                        break;
                    }
                    case 13: {
                        packageType = this.messageUtil.getMessage("msg.payment.typevalue.week.relet.difference");
                    }
                }
                dto.setPackageDuration(packageType);
                String type = null;
                String resourceName = null;
                String resourceGuid = null;
                Integer replicas = material.getResourceInstance() == null ? 1 : material.getResourceInstance();
                Integer instances = 1;
                Long resourceId = material.getResourceId();
                Long resourceDepId = null;
                switch (payment.getType()) {
                    case 0: {
                        type = this.messageUtil.getMessage("msg.type.resource");
                        Resource resource = (Resource)this.resourceRepository.findOne((Serializable)resourceId);
                        if (resource == null) break;
                        resourceGuid = resource.getGuid();
                        resourceName = resource.getName();
                        resourceDepId = resource.getDepartment().getId();
                        break;
                    }
                    case 1: {
                        type = this.messageUtil.getMessage("msg.type.job");
                        JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)resourceId);
                        if (version == null) break;
                        resourceGuid = version.getGuid();
                        resourceName = version.getJob().getName();
                        resourceDepId = version.getJob().getDepartment().getId();
                        dto.setVersion(version.getVersion());
                        break;
                    }
                    case 2: {
                        type = this.messageUtil.getMessage("msg.type.storage");
                        Storage storage = (Storage)this.storageRepository.findOne((Serializable)resourceId);
                        if (storage == null) break;
                        resourceGuid = storage.getGuid();
                        resourceName = storage.getName();
                        Double storageNum = material.getStorageNum();
                        Integer capacity = null;
                        if (storageNum != null) {
                            capacity = storageNum.intValue();
                        }
                        if (capacity == null) {
                            capacity = storage.getCapacity();
                        }
                        dto.setResourceDetails(capacity + "GB");
                        resourceDepId = storage.getDepartment().getId();
                        dto.setUsername(storage.getUser().getUsername() + "-" + storage.getUser().getName());
                        replicas = null;
                        break;
                    }
                    case 3: {
                        type = this.messageUtil.getMessage("msg.type.service");
                        Service modelService = (Service)this.serviceRepository.findOne((Serializable)resourceId);
                        if (modelService == null) break;
                        resourceGuid = modelService.getCurrent().getGuid();
                        resourceName = modelService.getName();
                        resourceDepId = modelService.getDepartment().getId();
                        instances = modelService.getCurrent().getInstance();
                        break;
                    }
                    case 4: {
                        type = this.messageUtil.getMessage("msg.type.job");
                        JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)resourceId);
                        if (version == null) break;
                        resourceGuid = version.getGuid();
                        resourceName = version.getJob().getName();
                        resourceDepId = version.getJob().getDepartment().getId();
                        dto.setVersion(version.getVersion());
                        break;
                    }
                    case 5: {
                        type = this.messageUtil.getMessage("msg.type.resource");
                        Resource resourcedis = (Resource)this.resourceRepository.findOne((Serializable)resourceId);
                        if (resourcedis == null) break;
                        resourceGuid = resourcedis.getGuid();
                        resourceName = resourcedis.getName();
                        resourceDepId = resourcedis.getDepartment().getId();
                        break;
                    }
                    case 6: {
                        type = this.messageUtil.getMessage("msg.type.automl");
                        Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)resourceId);
                        if (experiment != null) {
                            resourceGuid = experiment.getGuid();
                            resourceName = experiment.getName();
                            resourceDepId = experiment.getDepartment().getId();
                        }
                    }
                    case 7: {
                        type = this.messageUtil.getMessage("msg.type.annotation");
                        Annotation annotation = this.annotationRepository.findByIdAndDeletedNotNull(resourceId);
                        if (annotation == null) break;
                        resourceGuid = annotation.getGuid();
                        resourceName = annotation.getName();
                        resourceDepId = annotation.getDepartment().getId();
                    }
                }
                dto.setReplicas(replicas);
                dto.setType(type);
                if (resourceGuid != null) {
                    dto.setResourceName(resourceName + "/" + resourceGuid.substring(0, 12));
                }
                PricePackage pricePackage = material.getPack();
                String resourceDetails = null;
                if (pricePackage != null) {
                    if (pricePackage.getGpuNum() == null || pricePackage.getGpuNum() == 0) {
                        if (payment.getType() == 3) {
                            resourceDetails = pricePackage.getName() + "\uff08CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.instances") + "\uff1a" + instances + this.messageUtil.getMessage("msg.instances.num");
                        } else if (payment.getType() == 4 || payment.getType() == 5 || payment.getType() == 0 || payment.getType() == 1) {
                            resourceDetails = pricePackage.getName() + "\uff08CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.node") + "\uff1a" + replicas + this.messageUtil.getMessage("msg.instances.num");
                        } else if (payment.getType() != 2) {
                            resourceDetails = pricePackage.getName() + "\uff08CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09";
                        }
                        dto.setResourceDetails(resourceDetails);
                    } else {
                        if (payment.getType() == 3) {
                            resourceDetails = pricePackage.getName() + "\uff08GPU:" + (pricePackage.getGpuNum() == null ? 0 : pricePackage.getGpuNum()) + this.messageUtil.getMessage("msg.gpu.num") + "\u3001CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.instances") + "\uff1a" + instances + this.messageUtil.getMessage("msg.instances.num");
                        } else if (payment.getType() == 4 || payment.getType() == 5 || payment.getType() == 0 || payment.getType() == 1) {
                            resourceDetails = pricePackage.getName() + "\uff08GPU:" + (pricePackage.getGpuNum() == null ? 0 : pricePackage.getGpuNum()) + this.messageUtil.getMessage("msg.gpu.num") + "\u3001CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.node") + "\uff1a" + replicas + this.messageUtil.getMessage("msg.instances.num");
                        } else if (payment.getType() != 2) {
                            resourceDetails = pricePackage.getName() + "\uff08GPU:" + (pricePackage.getGpuNum() == null ? 0 : pricePackage.getGpuNum()) + this.messageUtil.getMessage("msg.gpu.num") + "\u3001CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09";
                        }
                        dto.setResourceDetails(resourceDetails);
                    }
                }
                if (resourceDepId != null) {
                    dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne(resourceDepId);
                    dto.setDepartment(dep.getName() + "/" + dep.getGuid().substring(0, 12));
                    organization = dep.getOrgConfig().getOrganization();
                    dto.setOrganization(organization.getName() + "/" + organization.getGuid().substring(0, 12));
                } else {
                    dep = material.getDepartment();
                    dto.setDepartment(dep.getName() + "/" + dep.getGuid().substring(0, 12));
                    organization = material.getOrganization();
                    dto.setOrganization(organization.getName() + "/" + organization.getGuid().substring(0, 12));
                }
                dtoList.add(dto);
            }
        }
        res.setList(dtoList);
        res.setCode(Constants.SC_OK);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6d88\u8d39\u660e\u7ec6\u5bfc\u51fa")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/user/payment/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportUserPayment(@RequestBody @Valid PaymentExportRequest requestDto, HttpServletRequest request, HttpServletResponse response) {
        User user = (User)this.userRepository.findOne((Serializable)requestDto.getId());
        Long domainId = requestDto.getDomainId();
        Domain domain = null;
        if (domainId != null && domainId != -1L) {
            domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        }
        String sTime = null;
        String eTime = null;
        Integer productType = requestDto.getProductType();
        Integer payType = requestDto.getPayType();
        Integer consumeType = requestDto.getConsumeType();
        if (productType == null) {
            productType = -1;
        }
        if (payType == null) {
            payType = -1;
        }
        if (consumeType == null) {
            consumeType = -1;
        }
        if (requestDto.getStartTime() != null) {
            sTime = requestDto.getStartTime().toString();
        }
        if (requestDto.getEndTime() != null) {
            eTime = requestDto.getEndTime().toString();
        }
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"costTime"});
        String finalSTime = sTime;
        String finalETime = eTime;
        Integer finalProductType = productType;
        Integer finalConsumeType = consumeType;
        Integer finalpayType = payType;
        Domain finalDomain = domain;
        Specification spec = (root, query, cb) -> {
            Date date;
            Join join = root.join("material", JoinType.INNER);
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.equal((Expression)join.get("organization").get("status"), (Object)1));
            if (finalDomain != null) {
                lstPredicates.add(cb.equal((Expression)join.get("domain"), (Object)finalDomain));
            }
            if (finalProductType != -1) {
                if (finalProductType == 0) {
                    lstPredicates.add(cb.or((Expression)cb.equal((Expression)root.get("type"), (Object)0), (Expression)cb.equal((Expression)root.get("type"), (Object)5)));
                } else if (finalProductType == 1) {
                    lstPredicates.add(cb.or((Expression)cb.equal((Expression)root.get("type"), (Object)1), (Expression)cb.equal((Expression)root.get("type"), (Object)4)));
                } else {
                    lstPredicates.add(cb.equal((Expression)root.get("type"), (Object)finalProductType));
                }
            }
            if (finalConsumeType != -1) {
                lstPredicates.add(cb.equal((Expression)root.get("packageType"), (Object)finalConsumeType));
            }
            if (finalpayType == 0) {
                lstPredicates.add(cb.notEqual((Expression)join.get("packageType"), (Object)2));
            } else if (finalpayType == 1) {
                lstPredicates.add(cb.equal((Expression)join.get("packageType"), (Object)2));
            }
            if (requestDto.getDepId() != null && requestDto.getDepId() != -1L) {
                OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)requestDto.getDepId());
                DepUsers du = this.depUsersRepository.findByUserAndDepartment(user, dep);
                if (du.getType() != 1 && du.getType() != 2) {
                    lstPredicates.add(cb.and((Expression)cb.equal((Expression)join.get("department").get("id"), (Object)requestDto.getDepId()), (Expression)cb.equal((Expression)join.get("user"), (Object)user)));
                } else {
                    lstPredicates.add(cb.equal((Expression)join.get("department").get("id"), (Object)requestDto.getDepId()));
                }
            } else {
                ArrayList<Predicate> depPredicateList = new ArrayList<Predicate>();
                List dus = this.depUsersRepository.findByUserNotDeleted(user);
                if (dus != null && dus.size() > 0) {
                    for (DepUsers du : dus) {
                        OrgConfigDepartment department = du.getDepartment();
                        Integer rCount = this.resourceRepository.countByDepartmentId(department.getId());
                        Integer jCount = this.jobRepository.countByDepartment(department);
                        Integer sCount = this.serviceRepository.countByDepartment(department);
                        Integer stCount = this.storageRepository.countByDepartmentId(department.getId());
                        if (rCount + jCount + sCount + stCount == 0) continue;
                        if (du.getType() != 1 && du.getType() != 2) {
                            depPredicateList.add(cb.and((Expression)cb.equal((Expression)join.get("department").get("id"), (Object)du.getDepartment().getId()), (Expression)cb.equal((Expression)join.get("user"), (Object)user)));
                            continue;
                        }
                        depPredicateList.add(cb.equal((Expression)join.get("department").get("id"), (Object)du.getDepartment().getId()));
                    }
                }
                lstPredicates.add(cb.or(depPredicateList.toArray(new Predicate[depPredicateList.size()])));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!StringUtils.isEmpty((String)finalSTime)) {
                try {
                    date = sdf.parse(finalSTime);
                    lstPredicates.add(cb.greaterThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)TimeUtil.startOfDay((Date)date)));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            if (!StringUtils.isEmpty((String)finalETime)) {
                try {
                    date = sdf.parse(finalETime);
                    lstPredicates.add(cb.lessThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)TimeUtil.endOfDay((Date)date)));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        };
        List userPaymentList = this.paymentRepository.findAll(spec, sort);
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("payments");
        Row titleRow = sheet.createRow(0);
        titleRow.createCell(0).setCellValue(this.messageUtil.getMessage("msg.payment.cell0"));
        titleRow.createCell(1).setCellValue(this.messageUtil.getMessage("msg.payment.cell1"));
        titleRow.createCell(2).setCellValue(this.messageUtil.getMessage("msg.payment.cell2"));
        titleRow.createCell(3).setCellValue(this.messageUtil.getMessage("msg.payment.cell3"));
        titleRow.createCell(4).setCellValue(this.messageUtil.getMessage("msg.payment.cell4"));
        titleRow.createCell(5).setCellValue(this.messageUtil.getMessage("msg.payment.cell5"));
        titleRow.createCell(6).setCellValue(this.messageUtil.getMessage("msg.payment.cell6"));
        titleRow.createCell(7).setCellValue(this.messageUtil.getMessage("msg.payment.cell7"));
        titleRow.createCell(8).setCellValue(this.messageUtil.getMessage("msg.payment.cell8"));
        titleRow.createCell(9).setCellValue(this.messageUtil.getMessage("msg.payment.cell9"));
        titleRow.createCell(10).setCellValue(this.messageUtil.getMessage("msg.payment.cell10"));
        int cell = 1;
        for (Payment payment : userPaymentList) {
            Organization organization;
            OrgConfigDepartment dep;
            Materials material = payment.getMaterial();
            PricePackage pricePackage = material.getPack();
            Row row = sheet.createRow(cell);
            row.createCell(0).setCellValue(payment.getTradeNo());
            DecimalFormat df = new DecimalFormat("0.0000");
            row.createCell(1).setCellValue(Double.valueOf(df.format(payment.getMoney())).doubleValue());
            if (material.getDomain() != null) {
                row.createCell(2).setCellValue(material.getDomain().getName());
            }
            String type = null;
            String resourceName = null;
            String resourceGuid = null;
            String replicas = material.getResourceInstance() == null ? "1" : String.valueOf(material.getResourceInstance());
            Integer instances = 1;
            Long resourceId = material.getResourceId();
            Integer capacity = 0;
            Long resourceDepId = null;
            switch (payment.getType()) {
                case 0: {
                    type = this.messageUtil.getMessage("msg.type.resource");
                    Resource resource = (Resource)this.resourceRepository.findOne((Serializable)resourceId);
                    if (resource == null) break;
                    resourceGuid = resource.getGuid();
                    resourceName = resource.getName();
                    resourceDepId = resource.getDepartment().getId();
                    break;
                }
                case 1: {
                    type = this.messageUtil.getMessage("msg.type.job");
                    JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)resourceId);
                    if (version == null) break;
                    resourceGuid = version.getGuid();
                    resourceName = version.getJob().getName();
                    resourceDepId = version.getJob().getDepartment().getId();
                    break;
                }
                case 2: {
                    type = this.messageUtil.getMessage("msg.type.storage");
                    Storage storage = (Storage)this.storageRepository.findOne((Serializable)resourceId);
                    if (storage != null) {
                        resourceGuid = storage.getGuid();
                        resourceName = storage.getName();
                        Double storageNum = material.getStorageNum();
                        capacity = null;
                        if (storageNum != null) {
                            capacity = storageNum.intValue();
                        }
                        if (capacity == null) {
                            capacity = storage.getCapacity();
                        }
                        resourceDepId = storage.getDepartment().getId();
                    }
                    replicas = "";
                    break;
                }
                case 3: {
                    type = this.messageUtil.getMessage("msg.type.service");
                    Service modelService = (Service)this.serviceRepository.findOne((Serializable)resourceId);
                    if (modelService == null) break;
                    resourceGuid = modelService.getCurrent().getGuid();
                    resourceName = modelService.getName();
                    resourceDepId = modelService.getDepartment().getId();
                    instances = modelService.getCurrent().getInstance();
                    break;
                }
                case 4: {
                    type = this.messageUtil.getMessage("msg.type.job");
                    JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)resourceId);
                    if (version == null) break;
                    resourceGuid = version.getGuid();
                    resourceName = version.getJob().getName();
                    resourceDepId = version.getJob().getDepartment().getId();
                    break;
                }
                case 5: {
                    type = this.messageUtil.getMessage("msg.type.resource");
                    Resource resourcedis = (Resource)this.resourceRepository.findOne((Serializable)resourceId);
                    if (resourcedis == null) break;
                    resourceGuid = resourcedis.getGuid();
                    resourceName = resourcedis.getName();
                    resourceDepId = resourcedis.getDepartment().getId();
                    break;
                }
                case 6: {
                    type = this.messageUtil.getMessage("msg.type.automl");
                    Experiment experiment = (Experiment)this.experimentRepository.findOne((Serializable)resourceId);
                    if (experiment != null) {
                        resourceGuid = experiment.getGuid();
                        resourceName = experiment.getName();
                        resourceDepId = experiment.getDepartment().getId();
                    }
                }
                case 7: {
                    type = this.messageUtil.getMessage("msg.type.annotation");
                    Annotation annotation = (Annotation)this.annotationRepository.findOne((Serializable)resourceId);
                    if (annotation == null) break;
                    resourceGuid = annotation.getGuid();
                    resourceName = annotation.getName();
                    resourceDepId = annotation.getDepartment().getId();
                }
            }
            row.createCell(3).setCellValue(type);
            if (resourceGuid != null) {
                row.createCell(4).setCellValue(resourceName + "/" + resourceGuid.substring(0, 12));
            }
            String resourceDetails = null;
            if (pricePackage != null) {
                if (pricePackage.getGpuNum() == null || pricePackage.getGpuNum() == 0) {
                    if (payment.getType() == 3) {
                        resourceDetails = pricePackage.getName() + "\uff08CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.instances") + "\uff1a" + instances + this.messageUtil.getMessage("msg.instances.num");
                    } else if (payment.getType() == 4 || payment.getType() == 5) {
                        resourceDetails = pricePackage.getName() + "\uff08CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.node") + "\uff1a" + replicas + this.messageUtil.getMessage("msg.instances.num");
                    } else if (payment.getType() != 2) {
                        resourceDetails = pricePackage.getName() + "\uff08CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09";
                    } else if (capacity != 0) {
                        resourceDetails = capacity + "GB";
                    }
                } else if (payment.getType() == 3) {
                    resourceDetails = pricePackage.getName() + "\uff08GPU:" + (pricePackage.getGpuNum() == null ? 0 : pricePackage.getGpuNum()) + this.messageUtil.getMessage("msg.gpu.num") + "\u3001CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.instances") + "\uff1a" + instances + this.messageUtil.getMessage("msg.instances.num");
                } else if (payment.getType() == 4 || payment.getType() == 5) {
                    resourceDetails = pricePackage.getName() + "\uff08GPU:" + (pricePackage.getGpuNum() == null ? 0 : pricePackage.getGpuNum()) + this.messageUtil.getMessage("msg.gpu.num") + "\u3001CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09" + this.messageUtil.getMessage("msg.node") + "\uff1a" + replicas + this.messageUtil.getMessage("msg.instances.num");
                } else if (payment.getType() != 2) {
                    resourceDetails = pricePackage.getName() + "\uff08GPU:" + (pricePackage.getGpuNum() == null ? 0 : pricePackage.getGpuNum()) + this.messageUtil.getMessage("msg.gpu.num") + "\u3001CPU:" + (pricePackage.getCpuNum() == null ? 0 : pricePackage.getCpuNum()) + this.messageUtil.getMessage("msg.cpu.num") + "\u3001" + this.messageUtil.getMessage("msg.memory") + "\uff1a" + (pricePackage.getMemoryNum() == null ? 0 : pricePackage.getMemoryNum()) + "GB\uff09";
                } else if (capacity != 0) {
                    resourceDetails = capacity + "GB";
                }
            }
            row.createCell(5).setCellValue(resourceDetails);
            String costTime = payment.getCostTime();
            if (costTime == null) {
                costTime = DateUtil.format((Date)payment.getCreatedAt());
            }
            row.createCell(6).setCellValue(costTime);
            String packageType = null;
            switch (payment.getPackageType()) {
                case 0: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.year") + "-" + payment.getMaterial().getPackageDuration() + this.messageUtil.getMessage("msg.year");
                    break;
                }
                case 1: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.month") + "-" + payment.getMaterial().getPackageDuration() + this.messageUtil.getMessage("msg.month");
                    break;
                }
                case 2: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.volume");
                    break;
                }
                case 3: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.year.difference");
                    break;
                }
                case 4: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.month.difference");
                    break;
                }
                case 5: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.volume.difference");
                    break;
                }
                case 6: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.week") + "-" + payment.getMaterial().getPackageDuration() + this.messageUtil.getMessage("msg.week");
                    break;
                }
                case 7: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.week.difference");
                    break;
                }
                case 8: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.year.relet");
                    break;
                }
                case 9: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.month.relet");
                    break;
                }
                case 10: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.week.relet");
                    break;
                }
                case 11: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.year.relet.difference");
                    break;
                }
                case 12: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.month.relet.difference");
                    break;
                }
                case 13: {
                    packageType = this.messageUtil.getMessage("msg.payment.typevalue.week.relet.difference");
                }
            }
            row.createCell(7).setCellValue(packageType);
            if (resourceDepId != null) {
                dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)resourceDepId);
                row.createCell(8).setCellValue(dep.getName() + "/" + dep.getGuid().substring(0, 12));
                organization = dep.getOrgConfig().getOrganization();
                row.createCell(10).setCellValue(organization.getName() + "/" + organization.getGuid().substring(0, 12));
            } else {
                dep = material.getDepartment();
                row.createCell(8).setCellValue(dep.getName() + "/" + dep.getGuid().substring(0, 12));
                organization = material.getOrganization();
                row.createCell(10).setCellValue(organization.getName() + "/" + organization.getGuid().substring(0, 12));
            }
            if (material.getUser() != null) {
                row.createCell(9).setCellValue(material.getUser().getUsername() + "-" + material.getUser().getName());
            }
            ++cell;
        }
        String fileName = user.getUsername() + DateUtil.getOrderNum() + ".xlsx";
        OutputStream out = null;
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            out = response.getOutputStream();
            wb.write(out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @ApiOperation(value="\u5145\u503c\u660e\u7ec6")
    @Transactional(readOnly=true)
    @RequestMapping(value={"/api/user/recharge"}, method={RequestMethod.POST})
    @ResponseBody
    public ListPaymentResultResponse<RechargeModel> getUserRecharge(@RequestBody @Valid RechargeRequest requestDto, HttpServletRequest request) {
        HttpSession session = request.getSession();
        ListPaymentResultResponse res = new ListPaymentResultResponse();
        res.setCode(Constants.SC_ERROR);
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        Organization organization = user.getOrganization();
        Integer pageNum = requestDto.getPageNum();
        Integer pageSize = requestDto.getPageSize();
        String sTime = null;
        String eTime = null;
        Integer type = requestDto.getType();
        Integer status = requestDto.getStatus();
        if (type == null) {
            type = -1;
        }
        if (status == null) {
            status = -1;
        }
        if (requestDto.getStartTime() != null) {
            sTime = requestDto.getStartTime().toString();
        }
        if (requestDto.getEndTime() != null) {
            eTime = requestDto.getEndTime().toString();
        }
        if (pageNum == null || pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
        }
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"createdAt"});
        PageRequest pageable = new PageRequest(pageNum - 1, pageSize.intValue(), sort);
        String finalSTime = sTime;
        String finalETime = eTime;
        Integer finalType = type;
        Integer finalStatus = status;
        Specification spec = (root, query, cb) -> {
            Date date;
            ArrayList<Predicate> lstPredicates = new ArrayList<Predicate>();
            lstPredicates.add(cb.equal((Expression)root.get("organization"), (Object)organization));
            ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
            if (!com.mopaas.server.common.StringUtils.isEmpty((String)requestDto.getSearch())) {
                predicateList.add(cb.like((Expression)root.get("tradeNo"), "%" + requestDto.getSearch().trim() + "%"));
                Predicate[] p = new Predicate[predicateList.size()];
                predicateList.toArray(p);
                lstPredicates.add(cb.or(p));
            }
            if (finalType != -1) {
                lstPredicates.add(cb.equal((Expression)root.get("type"), (Object)finalType));
            }
            if (finalStatus != -1) {
                lstPredicates.add(cb.equal((Expression)root.get("status"), (Object)finalStatus));
            } else {
                lstPredicates.add(cb.notEqual((Expression)root.get("status"), (Object)0));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!StringUtils.isEmpty((String)finalSTime)) {
                try {
                    date = sdf.parse(finalSTime);
                    lstPredicates.add(cb.greaterThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)date));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            if (!StringUtils.isEmpty((String)finalETime)) {
                try {
                    date = sdf.parse(finalETime);
                    lstPredicates.add(cb.lessThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)date));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            Predicate[] arrayPredicates = new Predicate[lstPredicates.size()];
            query.where((Expression)cb.and(lstPredicates.toArray(arrayPredicates)));
            return null;
        };
        Page rechargePage = this.rechargeRepository.findAll(spec, (Pageable)pageable);
        List userRechargeList = rechargePage.getContent();
        ArrayList<RechargeModel> list = new ArrayList<RechargeModel>();
        Double blance = 0.0;
        if (userRechargeList != null && userRechargeList.size() > 0) {
            for (Recharge recharge : userRechargeList) {
                RechargeModel model = (RechargeModel)BeanMapper.map((Object)recharge, RechargeModel.class);
                blance = blance + recharge.getMoney();
                list.add(model);
            }
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        res.setBalance(Double.valueOf(df.format(blance)));
        Integer totalSize = this.rechargeRepository.count(spec);
        res.setSize(Long.valueOf(totalSize.intValue()));
        int pageNums = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        res.setPages(Integer.valueOf(pageNums));
        res.setList(list);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6210\u5458\u914d\u989d")
    @Transactional
    @RequestMapping(value={"/api/dep/user/quota"}, method={RequestMethod.GET})
    public DepUserQuotaResponse depAllocation(HttpServletRequest request) {
        DepUserQuotaResponse res = new DepUserQuotaResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        String domainId = request.getHeader("domain");
        if (Strings.isNullOrEmpty((String)domainId) || !domainId.matches("[\\d]*")) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)userId);
        if (user == null) {
            res.setMessage(this.messageUtil.getMessage("msg.user.not.exist"));
            return res;
        }
        Long depId = (Long)session.getAttribute("departmentId");
        if (depId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.dep.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)depId);
        DepUsers depUsers = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        Integer depResourceAllocated = -1;
        Integer depJobAllocated = -1;
        Integer depModelAllocated = -1;
        if (null != depUsers && depUsers.getType() == 3) {
            Organization org = dep.getOrgConfig().getOrganization();
            DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, Long.valueOf(domainId));
            if (null == depQuotas) {
                depQuotas = new DepQuotas();
                depQuotas.setStorage(Integer.valueOf(-1));
                depQuotas.setUserStorage(Integer.valueOf(-1));
                depQuotas.setOrganization(org);
                depQuotas.setDepartment(dep);
                Domain d = this.domainRepository.findByIdAndDeleted(Long.valueOf(domainId), Integer.valueOf(0));
                depQuotas.setDomain(d);
                depQuotas.setResourceCount(Integer.valueOf(-1));
                depQuotas.setJobCount(Integer.valueOf(-1));
                depQuotas.setModelCount(Integer.valueOf(-1));
                depQuotas.setResourceTime(Double.valueOf(-1.0));
                depQuotas.setJobTime(Double.valueOf(-1.0));
                depQuotas.setModelTime(Double.valueOf(-1.0));
                depQuotas.setUserStorage(Integer.valueOf(-1));
                depQuotas.setAutomlCount(Integer.valueOf(-1));
                depQuotas.setAutomlTime(Double.valueOf(-1.0));
                depQuotas.setHarborStorage(Integer.valueOf(-1));
                this.depQuotasRepository.save((Object)depQuotas);
            } else {
                depResourceAllocated = depQuotas.getResourceCount() != null ? depQuotas.getResourceCount() : -1;
                depJobAllocated = depQuotas.getJobCount() != null ? depQuotas.getJobCount() : -1;
                depModelAllocated = depQuotas.getModelCount() != null ? depQuotas.getModelCount() : -1;
            }
            Integer resourceUsed = this.resourceRepository.countByDepartmentIdAndDeletedAndUserAndDomain(depId, Integer.valueOf(0), user, domain);
            Integer jobUsed = this.jobRepository.countByDepartmentAndDeletedAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            Integer modelUsed = this.serviceRepository.countByDepartmentAndDeletedAndUserAndDomain(dep, Integer.valueOf(0), user, domain);
            if (depResourceAllocated != -1 && depResourceAllocated <= resourceUsed) {
                res.setResourceUsable(Boolean.valueOf(false));
            }
            if (depJobAllocated != -1 && depJobAllocated <= jobUsed) {
                res.setResourceUsable(Boolean.valueOf(false));
            }
            if (depModelAllocated != -1 && depModelAllocated <= modelUsed) {
                res.setModelUsable(Boolean.valueOf(false));
            }
        }
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6210\u5458-\u8d44\u6e90\u914d\u989d\u8303\u56f4")
    @Transactional
    @RequestMapping(value={"/api/dep/user/quota/range"}, method={RequestMethod.POST})
    public ResultResponse getUserQuota(@Valid @RequestBody DepUserQuotaRangeRequest dto, HttpServletRequest request) {
        DepUserAllocationModel res = new DepUserAllocationModel();
        res.setCode(Constants.SC_ERROR);
        User user = (User)this.userRepository.findOne((Serializable)dto.getUserId());
        if (null == user) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment dep = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getGroupId());
        if (dep == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = dto.getDomainId();
        if (domainId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        List priceGpuList = this.priceRepository.findByTypeAndDomainAndDeleted(Integer.valueOf(1), domain, Integer.valueOf(0));
        ArrayList<String> gpuType = new ArrayList<String>();
        for (Price price : priceGpuList) {
            if (gpuType.contains(price.getChargeItem())) continue;
            gpuType.add(price.getChargeItem());
        }
        OrganizationQuotas orgQuotas = this.organizationQuotasRepository.findByOrganizationAndDomain(dep.getOrgConfig().getOrganization(), domain);
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(dep, domainId);
        HashMap<String, Integer> gpuQuota = new HashMap<String, Integer>();
        Map depGpuQuota = new HashMap();
        Map orgGpuQuota = new HashMap();
        if (null != depQuotas.getGpuQuota()) {
            depGpuQuota = (Map)JSON.parseObject((String)depQuotas.getGpuQuota(), Map.class);
        }
        if (null != orgQuotas.getGpuQuota()) {
            orgGpuQuota = (Map)JSON.parseObject((String)orgQuotas.getGpuQuota(), Map.class);
        }
        for (String s : gpuType) {
            if (!com.mopaas.server.common.StringUtils.isEmpty((String)String.valueOf(depGpuQuota.get(s))) && Integer.valueOf(String.valueOf(depGpuQuota.get(s))) != -1) {
                gpuQuota.put(s, Integer.valueOf(String.valueOf(depGpuQuota.get(s))));
                continue;
            }
            if (!com.mopaas.server.common.StringUtils.isEmpty((String)String.valueOf(orgGpuQuota.get(s))) && Integer.valueOf(String.valueOf(orgGpuQuota.get(s))) != -1) {
                gpuQuota.put(s, Integer.valueOf(String.valueOf(orgGpuQuota.get(s))));
                continue;
            }
            gpuQuota.put(s, -1);
        }
        int depCpu = null != depQuotas.getCpuQuota() && depQuotas.getCpuQuota() != -1 ? depQuotas.getCpuQuota() : (null != orgQuotas.getCpuQuota() && orgQuotas.getCpuQuota() != -1 ? orgQuotas.getCpuQuota() : -1);
        int depMemory = null != depQuotas.getMemoryQuota() && depQuotas.getMemoryQuota() != -1 ? depQuotas.getMemoryQuota() : (null != orgQuotas.getMemoryQuota() && orgQuotas.getMemoryQuota() != -1 ? orgQuotas.getMemoryQuota() : -1);
        int depCapacity = null != depQuotas.getStorage() && depQuotas.getStorage() != -1 ? depQuotas.getStorage() : (null != orgQuotas.getStorage() && orgQuotas.getStorage() != -1 ? orgQuotas.getStorage() : -1);
        DepQuotasModel depModel = new DepQuotasModel();
        depModel.setStorage(Integer.valueOf(depCapacity));
        depModel.setCpuQuota(Integer.valueOf(depCpu));
        depModel.setMemoryQuota(Integer.valueOf(depMemory));
        depModel.setGpuQuota(JSONObject.fromObject(gpuQuota).toString());
        res.setDepQuotasModel(depModel);
        DepUserQuotas userQuotas = this.depUserQuotasRepository.findByUserAndDepartmentAndDomain(user, dep, domain);
        int storage = -1;
        int cpu = -1;
        int memory = -1;
        Map<String, Integer> gpu = new HashMap<String, Integer>();
        if (null != userQuotas) {
            storage = userQuotas.getStorage() == null ? -1 : userQuotas.getStorage();
            cpu = userQuotas.getCpuQuota() == null ? -1 : userQuotas.getCpuQuota();
            memory = userQuotas.getMemoryQuota() == null ? -1 : userQuotas.getMemoryQuota();
            gpu = (Map)JSON.parse((String)userQuotas.getGpuQuota());
        }
        if (gpu == null || gpu.size() == 0) {
            gpu = new HashMap();
            for (String s : gpuType) {
                gpu.put(s, -1);
            }
        } else {
            ArrayList keySetList = new ArrayList(gpu.keySet());
            for (int i = keySetList.size() - 1; i >= 0; --i) {
                if (gpuType.contains(keySetList.get(i))) continue;
                gpu.remove(keySetList.get(i));
            }
            for (String s : gpuType) {
                if (keySetList.contains(s)) continue;
                gpu.put(s, -1);
            }
        }
        res.setStorage(Integer.valueOf(storage));
        res.setCpu(Integer.valueOf(cpu));
        res.setMemory(Integer.valueOf(memory));
        res.setGpu(gpu);
        Integer userStorageUsed = this.storageRepository.sumQuotaAllocatedByDepIdAndStatusInAndUserAndDomain(dep.getId(), user, domain);
        if (userStorageUsed == null) {
            userStorageUsed = 0;
        }
        res.setStorageBuild(userStorageUsed);
        int userCpuBuild = 0;
        int userMemoryBuild = 0;
        HashMap<String, Integer> userGpuBuild = new HashMap<String, Integer>();
        List resources = this.resourceRepository.findBuildByDepIdAndDomainAndUser(dep.getId(), domain, user);
        for (Object r : resources) {
            if (r.getPack().getCpuNum() != null) {
                userCpuBuild += r.getPack().getCpuNum() * r.getReplicas();
            }
            if (r.getPack().getMemoryNum() == null) continue;
            userMemoryBuild += r.getPack().getMemoryNum() * r.getReplicas();
        }
        List jobs = this.jobRepository.findBuildByDepAndDomainAndUser(dep, domain, user);
        for (Object r : jobs) {
            if (r.getCurrent().getPack().getCpuNum() != null) {
                userCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getReplicas();
            }
            if (r.getCurrent().getPack().getMemoryNum() == null) continue;
            userMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getReplicas();
        }
        List services = this.serviceRepository.findBuildByDepAndDomainAndUser(dep, domain, user);
        for (Object r : services) {
            if (r.getCurrent().getPack().getCpuNum() != null) {
                userCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getInstance();
            }
            if (r.getCurrent().getPack().getMemoryNum() == null) continue;
            userMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getInstance();
        }
        List annotations = this.annotationRepository.findBuildByDepAndDomainAndUser(dep, domain, user);
        for (Annotation r : annotations) {
            if (r.getPack().getCpuNum() != null) {
                userCpuBuild += r.getPack().getCpuNum().intValue();
            }
            if (r.getPack().getMemoryNum() == null) continue;
            userMemoryBuild += r.getPack().getMemoryNum().intValue();
        }
        res.setCpuBuild(Integer.valueOf(userCpuBuild));
        res.setMemoryBuild(Integer.valueOf(userMemoryBuild));
        for (String s : gpuType) {
            double gpuTypeBuild = 0.0;
            List pricePackageIds = this.pricePackageRepository.findIdsByGpuChargeItemAndDomain(s, domain);
            if (null != pricePackageIds && !pricePackageIds.isEmpty()) {
                int gpuUsed;
                resources = this.resourceRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(dep.getId(), domain, pricePackageIds, user);
                for (Resource r : resources) {
                    if (r.getPack().getGpu() == null) continue;
                    gpuUsed = r.getPack().getGpuNum() * r.getReplicas();
                    if (r.getPack().getSlice() != null && r.getPack().getSlice() > 1) {
                        gpuUsed = r.getPack().getGpuNum();
                    }
                    gpuTypeBuild += (double)gpuUsed;
                }
                jobs = this.jobRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(dep, domain, pricePackageIds, user);
                for (Resource r : jobs) {
                    if (r.getCurrent().getPack().getGpu() == null) continue;
                    gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas();
                    if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                        gpuUsed = r.getCurrent().getPack().getGpuNum();
                    }
                    gpuTypeBuild += (double)gpuUsed;
                }
                services = this.serviceRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(dep, domain, pricePackageIds, user);
                for (Resource r : services) {
                    if (r.getCurrent().getPack().getGpu() == null) continue;
                    gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance();
                    if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                        gpuUsed = r.getCurrent().getPack().getGpuNum();
                    }
                    gpuTypeBuild += (double)gpuUsed;
                }
                annotations = this.annotationRepository.findGpuBuildByDepAndDomainAndPriceIdInAndUser(dep, domain, pricePackageIds, user);
                for (Resource r : annotations) {
                    if (r.getPack().getGpu() == null) continue;
                    gpuUsed = r.getPack().getGpuNum();
                    if (r.getPack().getSlice() != null && r.getPack().getSlice() > 1) {
                        gpuUsed = r.getPack().getGpuNum();
                    }
                    gpuTypeBuild += (double)gpuUsed;
                }
            }
            userGpuBuild.put(s, new Double(gpuTypeBuild).intValue());
        }
        res.setGpuBuild(userGpuBuild);
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ApiOperation(value="\u6210\u5458-\u8d44\u6e90\u914d\u989d\u8bbe\u7f6e")
    @Transactional
    @RequestMapping(value={"/api/dep/user/quota/allot"}, method={RequestMethod.POST})
    public ResultResponse allotAllocationQuota(@Valid @RequestBody DepUserAllocationQuotaRequest dto, HttpServletRequest request) {
        Integer storage;
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_ERROR);
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthenticated"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        User user = (User)this.userRepository.findOne((Serializable)dto.getUserId());
        if (null == user) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        OrgConfigDepartment department = (OrgConfigDepartment)this.orgConfigDepartmentRepository.findOne((Serializable)dto.getGroupId());
        if (department == null) {
            res.setMessage(this.messageUtil.getMessage("msg.account.not.exist"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Long domainId = dto.getDomainId();
        if (domainId == null) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.is.necessary"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Domain domain = this.domainRepository.findByIdAndDeleted(domainId, Integer.valueOf(0));
        if (null == domain) {
            res.setMessage(this.messageUtil.getMessage("msg.domain.unavailable"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!DepartmentController.isDepPermission((String)"consumer:quotas", (Long)department.getId())) {
            res.setMessage(this.messageUtil.getMessage("msg.account.unauthorized"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        DepQuotas depQuotas = this.depQuotasRepository.findByDepartmentAndDomainId(department, domainId);
        Integer depCapacity = 0;
        Integer depCpu = -1;
        Integer depMemory = -1;
        Map depGpu = new HashMap();
        if (null != depQuotas) {
            depCapacity = depQuotas.getStorage() != null ? depQuotas.getStorage() : 0;
            depCpu = depQuotas.getCpuQuota() != null ? depQuotas.getCpuQuota() : -1;
            depMemory = depQuotas.getMemoryQuota() != null ? depQuotas.getMemoryQuota() : -1;
            if (null != depQuotas.getGpuQuota()) {
                depGpu = (Map)JSON.parse((String)depQuotas.getGpuQuota());
            }
        }
        if ((storage = Integer.valueOf(dto.getStorage() == null ? -1 : dto.getStorage())) != -1 && depCapacity != -1 && (storage < -1 || storage > depCapacity)) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.storage.capacity.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer userStorageUsed = this.storageRepository.sumQuotaAllocatedByDepIdAndStatusInAndUserAndDomain(department.getId(), user, domain);
        if (userStorageUsed == null) {
            userStorageUsed = 0;
        }
        if (storage != -1 && storage < userStorageUsed) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.storage.capacity.less"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        if (!com.mopaas.server.common.StringUtils.isEmpty((String)(dto.getCpu() + "")) && dto.getCpu() < -1) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.cpu.error"));
            return res;
        }
        if (!com.mopaas.server.common.StringUtils.isEmpty((String)(dto.getMemory() + "")) && dto.getMemory() < -1) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.memory.error"));
            return res;
        }
        if (dto.getGpu() != null && !dto.getGpu().isEmpty()) {
            for (String key : dto.getGpu().keySet()) {
                if ((Integer)dto.getGpu().get(key) >= -1) continue;
                res.setMessage(this.messageUtil.getMessage("msg.dep.gpu.error"));
                return res;
            }
        }
        int userCpuBuild = 0;
        int userMemoryBuild = 0;
        HashMap<String, Integer> userGpuBuild = new HashMap<String, Integer>();
        List resources = this.resourceRepository.findBuildByDepIdAndDomainAndUser(department.getId(), domain, user);
        for (Object r : resources) {
            if (r.getPack().getCpuNum() == null) continue;
            userCpuBuild += r.getPack().getCpuNum() * r.getReplicas();
        }
        List jobs = this.jobRepository.findBuildByDepAndDomainAndUser(department, domain, user);
        for (Object r : jobs) {
            if (r.getCurrent().getPack().getCpuNum() == null) continue;
            userCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getReplicas();
        }
        List services = this.serviceRepository.findBuildByDepAndDomainAndUser(department, domain, user);
        for (Service r : services) {
            if (r.getCurrent().getPack().getCpuNum() == null) continue;
            userCpuBuild += r.getCurrent().getPack().getCpuNum() * r.getCurrent().getInstance();
        }
        resources = this.resourceRepository.findBuildByDepIdAndDomainAndUser(department.getId(), domain, user);
        for (Service r : resources) {
            if (r.getPack().getMemoryNum() == null) continue;
            userMemoryBuild += r.getPack().getMemoryNum() * r.getReplicas();
        }
        jobs = this.jobRepository.findBuildByDepAndDomainAndUser(department, domain, user);
        for (Service r : jobs) {
            if (r.getCurrent().getPack().getMemoryNum() == null) continue;
            userMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getReplicas();
        }
        services = this.serviceRepository.findBuildByDepAndDomainAndUser(department, domain, user);
        for (Service r : services) {
            if (r.getCurrent().getPack().getMemoryNum() == null) continue;
            userMemoryBuild += r.getCurrent().getPack().getMemoryNum() * r.getCurrent().getInstance();
        }
        List priceGpuList = this.priceRepository.findByTypeAndDomainAndDeleted(Integer.valueOf(1), domain, Integer.valueOf(0));
        ArrayList<String> gpuType = new ArrayList<String>();
        for (Price price : priceGpuList) {
            if (gpuType.contains(price.getChargeItem())) continue;
            gpuType.add(price.getChargeItem());
        }
        for (String s : gpuType) {
            int gpuTypeBuild = 0;
            List pricePackageIds = this.pricePackageRepository.findIdsByGpuChargeItemAndDomain(s, domain);
            if (null != pricePackageIds && !pricePackageIds.isEmpty()) {
                int gpuUsed;
                resources = this.resourceRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(department.getId(), domain, pricePackageIds, user);
                for (Resource r : resources) {
                    if (r.getPack().getGpu() == null) continue;
                    gpuUsed = r.getPack().getGpuNum() * r.getReplicas();
                    if (r.getPack().getSlice() != null && r.getPack().getSlice() > 1) {
                        gpuUsed = r.getPack().getGpuNum();
                    }
                    gpuTypeBuild += gpuUsed;
                }
                jobs = this.jobRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(department, domain, pricePackageIds, user);
                for (Resource r : jobs) {
                    if (r.getCurrent().getPack().getGpu() == null) continue;
                    gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getReplicas();
                    if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                        gpuUsed = r.getCurrent().getPack().getGpuNum();
                    }
                    gpuTypeBuild += gpuUsed;
                }
                services = this.serviceRepository.findGpuBuildByDepIdAndDomainAndPriceIdInAndUser(department, domain, pricePackageIds, user);
                for (Resource r : services) {
                    if (r.getCurrent().getPack().getGpu() == null) continue;
                    gpuUsed = r.getCurrent().getPack().getGpuNum() * r.getCurrent().getInstance();
                    if (r.getCurrent().getPack().getSlice() != null && r.getCurrent().getPack().getSlice() > 1) {
                        gpuUsed = r.getCurrent().getPack().getGpuNum();
                    }
                    gpuTypeBuild += gpuUsed;
                }
            }
            userGpuBuild.put(s, gpuTypeBuild);
        }
        Integer cpu = dto.getCpu() == null ? -1 : dto.getCpu();
        if (cpu != -1 && (cpu < userCpuBuild || depCpu != -1 && cpu > depCpu)) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.cpu.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        Integer memory = dto.getMemory() == null ? -1 : dto.getMemory();
        if (memory != -1 && (memory < userMemoryBuild || depMemory != -1 && memory > depMemory)) {
            res.setMessage(this.messageUtil.getMessage("msg.dep.memory.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        HashMap gpu = dto.getGpu();
        if (null == gpu) {
            gpu = new HashMap();
        }
        for (String key : gpu.keySet()) {
            Integer depnum;
            Integer n = depnum = depGpu.get(key) == null ? Integer.valueOf(-1) : (Integer)depGpu.get(key);
            if ((Integer)gpu.get(key) == -1 || (Integer)gpu.get(key) >= (Integer)userGpuBuild.get(key) && (depnum == -1 || (Integer)gpu.get(key) <= depnum)) continue;
            res.setMessage(this.messageUtil.getMessage("msg.dep.gpu.error"));
            res.setCode(Constants.SC_MSG);
            return res;
        }
        DepUserQuotas userQuotas = this.depUserQuotasRepository.findByUserAndDepartmentAndDomain(user, department, domain);
        if (null == userQuotas) {
            userQuotas = new DepUserQuotas();
            userQuotas.setDomain(domain);
            userQuotas.setDepartment(department);
            userQuotas.setUser(user);
            this.depUserQuotasRepository.save((Object)userQuotas);
        }
        userQuotas.setStorage(Integer.valueOf(dto.getStorage() == null ? -1 : dto.getStorage()));
        userQuotas.setCpuQuota(dto.getCpu());
        userQuotas.setMemoryQuota(dto.getMemory());
        userQuotas.setGpuQuota(JSONObject.fromObject(gpu).toString());
        res.setCode(Constants.SC_OK);
        return res;
    }

    @ConstructorProperties(value={"userRepository", "permissionRepository", "systemConfigRepository", "emailValidateRepository", "userConfigsRepository", "userConfigValueRepository", "portalConfigRepository", "ticketRepository", "ticketContinueRepository", "organizationRepository", "orgConfigRepository", "paymentRepository", "rechargeRepository", "resourceRepository", "jobRepository", "serviceRepository", "storageRepository", "orgConfigDepartmentRepository", "pricePackageRepository", "accountUserRegisterRepository", "depUsersRepository", "orgConfigDepPackageRepository", "domainRepository", "organizationQuotasRepository", "depQuotasRepository", "jobVersionRepository", "balancesRepository", "loginHistoryRepository", "priceRepository", "depUserQuotasRepository", "experimentRepository", "messageUtil", "noticeService", "templateSmsRepository", "registerConfigRepository", "accountService", "harborUserRepository", "harborProjectRepository", "annotationRepository"})
    public UserController(UserRepository userRepository, PermissionRepository permissionRepository, SystemConfigRepository systemConfigRepository, EmailValidateRepository emailValidateRepository, UserConfigsRepository userConfigsRepository, UserConfigValueRepository userConfigValueRepository, PortalConfigRepository portalConfigRepository, TicketRepository ticketRepository, TicketContinueRepository ticketContinueRepository, OrganizationRepository organizationRepository, OrgConfigRepository orgConfigRepository, PaymentRepository paymentRepository, RechargeRepository rechargeRepository, ResourceRepository resourceRepository, JobRepository jobRepository, ServiceRepository serviceRepository, StorageRepository storageRepository, OrgConfigDepartmentRepository orgConfigDepartmentRepository, PricePackageRepository pricePackageRepository, AccountUserRegisterRepository accountUserRegisterRepository, DepUsersRepository depUsersRepository, OrgConfigDepPackageRepository orgConfigDepPackageRepository, DomainRepository domainRepository, OrganizationQuotasRepository organizationQuotasRepository, DepQuotasRepository depQuotasRepository, JobVersionRepository jobVersionRepository, BalancesRepository balancesRepository, LoginHistoryRepository loginHistoryRepository, PriceRepository priceRepository, DepUserQuotasRepository depUserQuotasRepository, ExperimentRepository experimentRepository, MessageUtil messageUtil, NoticeService noticeService, TemplateSmsRepository templateSmsRepository, RegisterConfigRepository registerConfigRepository, AccountService accountService, HarborUserRepository harborUserRepository, HarborProjectRepository harborProjectRepository, AnnotationRepository annotationRepository) {
        this.userRepository = userRepository;
        this.permissionRepository = permissionRepository;
        this.systemConfigRepository = systemConfigRepository;
        this.emailValidateRepository = emailValidateRepository;
        this.userConfigsRepository = userConfigsRepository;
        this.userConfigValueRepository = userConfigValueRepository;
        this.portalConfigRepository = portalConfigRepository;
        this.ticketRepository = ticketRepository;
        this.ticketContinueRepository = ticketContinueRepository;
        this.organizationRepository = organizationRepository;
        this.orgConfigRepository = orgConfigRepository;
        this.paymentRepository = paymentRepository;
        this.rechargeRepository = rechargeRepository;
        this.resourceRepository = resourceRepository;
        this.jobRepository = jobRepository;
        this.serviceRepository = serviceRepository;
        this.storageRepository = storageRepository;
        this.orgConfigDepartmentRepository = orgConfigDepartmentRepository;
        this.pricePackageRepository = pricePackageRepository;
        this.accountUserRegisterRepository = accountUserRegisterRepository;
        this.depUsersRepository = depUsersRepository;
        this.orgConfigDepPackageRepository = orgConfigDepPackageRepository;
        this.domainRepository = domainRepository;
        this.organizationQuotasRepository = organizationQuotasRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.jobVersionRepository = jobVersionRepository;
        this.balancesRepository = balancesRepository;
        this.loginHistoryRepository = loginHistoryRepository;
        this.priceRepository = priceRepository;
        this.depUserQuotasRepository = depUserQuotasRepository;
        this.experimentRepository = experimentRepository;
        this.messageUtil = messageUtil;
        this.noticeService = noticeService;
        this.templateSmsRepository = templateSmsRepository;
        this.registerConfigRepository = registerConfigRepository;
        this.accountService = accountService;
        this.harborUserRepository = harborUserRepository;
        this.harborProjectRepository = harborProjectRepository;
        this.annotationRepository = annotationRepository;
    }
}

