/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.exception;

import com.mopaas.server.common.Constants;
import com.mopaas.server.exception.BusinessException;
import com.mopaas.server.exception.MessageCodeException;
import com.mopaas.server.exception.MessageJsonException;
import com.mopaas.server.model.response.ResultResponse;
import io.kubernetes.client.openapi.ApiException;
import java.beans.ConstructorProperties;
import java.net.SocketException;
import java.util.Locale;
import org.apache.shiro.session.UnknownSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerExceptionHandler {
    final MessageSource messageSource;
    private static final Logger logger = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler
    public void handleException(ApiException e) {
        logger.error(e.getResponseBody(), (Throwable)e);
    }

    @ExceptionHandler
    public ResultResponse handleBusinessException(BusinessException e) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_MSG);
        res.setMessage(e.getMessage());
        return res;
    }

    @ExceptionHandler
    public ResultResponse handleMsgCodeException(MessageCodeException e, Locale locale) {
        ResultResponse res = new ResultResponse();
        res.setCode(Constants.SC_MSG);
        res.setMessage(this.messageSource.getMessage(e.getCode(), (Object[])e.getArgs(), locale));
        return res;
    }

    @ExceptionHandler
    public ResultResponse handleMsgJsonException(MessageJsonException e, Locale locale) {
        ResultResponse res = new ResultResponse();
        String[] args = e.getArgs();
        if (null != args) {
            StringBuilder sb = new StringBuilder(8);
            for (String arg : args) {
                if (!arg.startsWith("msg.")) {
                    sb.append(arg);
                    continue;
                }
                sb.append(this.messageSource.getMessage(arg, null, locale));
            }
            res.setMessage(this.messageSource.getMessage(e.getCode(), (Object[])new String[]{sb.toString()}, locale));
        }
        res.setCode(Constants.SC_MSG);
        return res;
    }

    @ExceptionHandler
    public void handleSocketException(SocketException e) {
    }

    @ExceptionHandler
    public void handleUnknownSessionException(UnknownSessionException e) {
    }

    @ConstructorProperties(value={"messageSource"})
    public ControllerExceptionHandler(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

