/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.service;

import com.mopaas.server.dao.DatasetVersionRepository;
import com.mopaas.server.entity.DatasetVersion;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.factory.FactoryCollection;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatasetService {
    final DatasetVersionRepository datasetVersionRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Transactional
    public void importData(Long versionId, Storage storage, String path, Long domain_id) {
        DatasetVersion version = (DatasetVersion)this.datasetVersionRepository.findOne((Serializable)versionId);
        String processKey = "dataset" + versionId + version.getVersion();
        try {
            Integer exitValue = FactoryCollection.minioCP((Long)domain_id, (String)storage.getGuid(), (String)storage.getName(), (String)path, (String)("ai-dataset/" + version.getObsPath()), (String)processKey);
            if (exitValue == 0) {
                version.setStatus(Integer.valueOf(1));
            } else {
                version.setStatus(Integer.valueOf(-1));
            }
        }
        catch (Exception e) {
            LOGGER.error("import dataset [{}-{}] failed", new Object[]{version.getDataset().getName(), version.getVersion(), e});
            version.setStatus(Integer.valueOf(-1));
            version.setErrorMessage(e.toString());
        }
        finally {
            if (FactoryCollection.PROCESS_MAP.containsKey(processKey)) {
                ((Process)FactoryCollection.PROCESS_MAP.get(processKey)).destroy();
            }
        }
    }

    @ConstructorProperties(value={"datasetVersionRepository"})
    public DatasetService(DatasetVersionRepository datasetVersionRepository) {
        this.datasetVersionRepository = datasetVersionRepository;
    }
}

