/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonSyntaxException;
import com.mopaas.server.common.BeanMapper;
import com.mopaas.server.common.MessageUtil;
import com.mopaas.server.dao.JobVersionRepository;
import com.mopaas.server.dao.K8sEngineRepository;
import com.mopaas.server.dao.MaterialsRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.StorageDeptRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dto.JudgeResourceDto;
import com.mopaas.server.dto.ResourceIdentityDto;
import com.mopaas.server.dto.VolumeMountDto;
import com.mopaas.server.entity.Job;
import com.mopaas.server.entity.JobStorage;
import com.mopaas.server.entity.JobVersion;
import com.mopaas.server.entity.Materials;
import com.mopaas.server.entity.OperationLog;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.ReferDuration;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.entity.StorageDept;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.kubeflow.kfjob.V1MPIJob;
import com.mopaas.server.kubeflow.kfjob.V1MPIJobSpec;
import com.mopaas.server.kubeflow.kfjob.V1MXJob;
import com.mopaas.server.kubeflow.kfjob.V1MXJobSpec;
import com.mopaas.server.kubeflow.kfjob.V1PyTorchJob;
import com.mopaas.server.kubeflow.kfjob.V1PyTorchJobSpec;
import com.mopaas.server.kubeflow.kfjob.V1ReplicaSpec;
import com.mopaas.server.kubeflow.kfjob.V1RunPolicy;
import com.mopaas.server.kubeflow.kfjob.V1SchedulingPolicy;
import com.mopaas.server.kubeflow.kfjob.V1TFJob;
import com.mopaas.server.kubeflow.kfjob.V1TFJobSpec;
import com.mopaas.server.service.CommonService;
import com.mopaas.server.service.OperationLogService;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1EmptyDirVolumeSource;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1HostPathVolumeSource;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.kubernetes.client.util.generic.KubernetesApiResponse;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class JobService {
    final MessageUtil messageUtil;
    final K8sEngineRepository k8sEngineRepository;
    final JobVersionRepository jobVersionRepository;
    final MaterialsRepository materialsRepository;
    final ReferDurationRepository referDurationRepository;
    final OperationLogService operationLogService;
    final CommonService commonService;
    final StorageDeptRepository storageDeptRepository;
    final StorageServiceFactory storageServiceFactory;
    final SystemConfigRepository systemConfigRepository;
    final StorageRepository storageRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobService.class);
    private static final String TENSORBOARD = "tensorboard";

    @Transactional
    public void judgeSysResource(ResourceIdentityDto dto) throws ApiException {
        JudgeResourceDto jrd = this.commonService.preJudgeSysResource(dto);
        if (null == jrd) {
            return;
        }
        Integer packType = jrd.getPackType();
        String gpuType = jrd.getGpuType();
        Integer priority = dto.getPriority();
        Long domainId = dto.getDomain().getId();
        List lowerJobs = packType == 0 ? this.jobVersionRepository.getVGPUByDomainAndPriorityAndGpuType(domainId, priority, gpuType) : (packType == 1 ? this.jobVersionRepository.getByDomainAndPriorityAndGpuType(domainId, priority, gpuType) : (packType == 2 ? this.jobVersionRepository.getGpuShareByDomainAndPriorityAndGpuType(domainId, priority, gpuType) : this.jobVersionRepository.getX86ByDomainAndPriority(domainId, priority)));
        lowerJobs.sort(Comparator.comparingInt(JobVersion::getPriority));
        ArrayList<JobVersion> reclaimJobs = new ArrayList<JobVersion>();
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        Integer replicas = dto.getReplica();
        for (JobVersion version : lowerJobs) {
            reclaimJobs.add(version);
            this.commonService.nodeFreeCalculate(k8sFactory.listPods(version.getGuid()), jrd, version.getPack(), dto.getPack());
            if (jrd.getAllMultiple() < replicas) continue;
            for (JobVersion r : reclaimJobs) {
                this.doStop(r, domainId);
                this.preemptLog(r);
            }
            return;
        }
        this.commonService.sysResourceInsufficientException(jrd);
    }

    private void preemptLog(JobVersion version) {
        OperationLog log = new OperationLog();
        log.setResourceName(version.getName());
        log.setResourceGuid(version.getGuid());
        log.setResourceType(Integer.valueOf(0));
        log.setRes(Integer.valueOf(1));
        log.setUsername("system");
        log.setName("system");
        log.setCreatedAt(new Date());
        log.setDuration(Long.valueOf(0L));
        log.setDomain(version.getJob().getDomain());
        log.setOperationIp("127.0.0.1");
        log.setOrganization(version.getJob().getUser().getOrganization());
        log.setContent(this.messageUtil.getMessageJson("msg.resource.preempt.reclaim"));
        this.operationLogService.save(log);
    }

    @Transactional
    public void doStop(JobVersion version, Long domainId) throws ApiException {
        version.setStatus(Integer.valueOf(3));
        version.setErrorMessage(null);
        Date now = new Date();
        version.setStopAt(now);
        List materials = this.materialsRepository.findByResourceIdAndTypeAndLastedAtIsNull(version.getId(), Integer.valueOf(1));
        if (null != materials) {
            for (Materials material : materials) {
                material.setLastedAt(now);
                material.setOperation(null);
            }
        }
        FactoryCollection.k8sFactory((Long)domainId).deleteNamespace(version.getGuid());
        List durations = this.referDurationRepository.findByReferenceAndReferTypeAndEndIsNull(version.getId(), Integer.valueOf(1));
        if (durations != null) {
            for (ReferDuration duration : durations) {
                duration.setEnd(now);
            }
        }
    }

    @Async
    @Transactional
    public void doCreate(Long versionId) {
        JobVersion version = (JobVersion)this.jobVersionRepository.findOne((Serializable)versionId);
        String guid = version.getGuid();
        Job job = version.getJob();
        Long domain_id = job.getDomain().getId();
        try {
            K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domain_id);
            k8sFactory.createNamespace(guid);
            HashMap<String, String> nodeSelector = new HashMap<String, String>(8);
            nodeSelector.put("schedulable", "true");
            PricePackage pack = version.getPack();
            V1ResourceRequirements requirements = new V1ResourceRequirements().putLimitsItem("cpu", new Quantity(String.valueOf(pack.getCpuNum()))).putLimitsItem("memory", new Quantity(pack.getMemoryNum() + "Gi"));
            V1PodSpec podSpec = new V1PodSpec().nodeSelector(nodeSelector);
            String gpu_type = null;
            if (null != pack.getGpuNum() && pack.getGpuNum() > 0) {
                gpu_type = pack.getGpu().getChargeItem();
                nodeSelector.put("gpu", gpu_type);
                if (pack.getSlice() == 0) {
                    requirements.putLimitsItem("huawei.com/" + gpu_type, new Quantity(String.valueOf(pack.getGpuNum())));
                    nodeSelector.put("gpushare", "vgpu");
                } else {
                    podSpec.priorityClassName("p" + version.getPriority());
                    requirements.putLimitsItem("huawei.com/" + gpu_type, new Quantity(String.valueOf(pack.getGpuNum())));
                    if (pack.getSlice() == 1) {
                        nodeSelector.put("gpushare", "false");
                    } else {
                        nodeSelector.put("gpushare", "true");
                    }
                }
            } else {
                nodeSelector.put("machine", "x86");
            }
            HashMap<String, String> label = new HashMap<String, String>();
            label.put("ai.module", "training");
            ArrayList<V1VolumeMount> volumeMounts = new ArrayList<V1VolumeMount>();
            ArrayList<V1Volume> volumes = new ArrayList<V1Volume>();
            volumeMounts.add(new V1VolumeMount().name("driver").mountPath("/usr/local/Ascend/driver").readOnly(Boolean.valueOf(true)));
            volumeMounts.add(new V1VolumeMount().name("sbin").mountPath("/usr/local/sbin").readOnly(Boolean.valueOf(true)));
            volumeMounts.add(new V1VolumeMount().name("davinci-manager").mountPath("/dev/davinci_manager").readOnly(Boolean.valueOf(true)));
            volumeMounts.add(new V1VolumeMount().name("hisi-hdc").mountPath("/dev/hisi_hdc").readOnly(Boolean.valueOf(true)));
            volumeMounts.add(new V1VolumeMount().name("devmm-svm").mountPath("/dev/devmm_svm").readOnly(Boolean.valueOf(true)));
            volumes.add(new V1Volume().name("driver").hostPath(new V1HostPathVolumeSource().path("/usr/local/Ascend/driver")));
            volumes.add(new V1Volume().name("sbin").hostPath(new V1HostPathVolumeSource().path("/usr/local/sbin")));
            volumes.add(new V1Volume().name("davinci-manager").hostPath(new V1HostPathVolumeSource().path("/dev/davinci_manager").type("CharDevice")));
            volumes.add(new V1Volume().name("hisi-hdc").hostPath(new V1HostPathVolumeSource().path("/dev/hisi_hdc").type("CharDevice")));
            volumes.add(new V1Volume().name("devmm-svm").hostPath(new V1HostPathVolumeSource().path("/dev/devmm_svm").type("CharDevice")));
            this.storage(version, k8sFactory, volumeMounts, volumes);
            k8sFactory.createHarborSecret(guid, domain_id);
            podSpec.volumes(volumes).addImagePullSecretsItem(new V1LocalObjectReference().name("harbor"));
            V1ObjectMeta podTemplateMeta = new V1ObjectMeta().labels(label).putAnnotationsItem("sidecar.istio.io/inject", "false");
            ArrayList args = new ArrayList(4);
            if (!StringUtils.isEmpty((Object)version.getParams())) {
                Map<String, String> params = new HashMap();
                if (version.getParams().startsWith("[")) {
                    JSONArray jsonArray = JSONArray.parseArray((String)version.getParams());
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject param = jsonArray.getJSONObject(i);
                        params.put(param.getString("name"), param.getString("value"));
                    }
                } else {
                    params = (Map)JSON.parseObject((String)version.getParams(), Map.class);
                }
                params.forEach((k, v) -> {
                    if (!StringUtils.isEmpty((Object)v)) {
                        if (v.contains(":/")) {
                            args.add("--" + k + "=" + v.split(":")[1]);
                        } else {
                            args.add("--" + k + "=" + v);
                        }
                    }
                });
            }
            ArrayList<String> commands = new ArrayList<String>(args.size() + 2);
            String entrypoint = version.getEntrypoint().contains(":/") ? version.getEntrypoint().split(":")[1] : version.getEntrypoint();
            String path = entrypoint.substring(0, entrypoint.lastIndexOf("/"));
            String file = entrypoint.substring(entrypoint.lastIndexOf("/") + 1);
            if (entrypoint.endsWith(".py")) {
                commands.add("python");
            } else {
                commands.add("bash");
            }
            commands.add(file);
            commands.addAll(args);
            V1RunPolicy runPolicy = new V1RunPolicy().cleanPodPolicy("Running").schedulingPolicy(new V1SchedulingPolicy().priorityClass(podSpec.getPriorityClassName()));
            if ("tensorflow".equalsIgnoreCase(version.getFrameType())) {
                podTemplateMeta.putLabelsItem("kubeflow-role", "train").putLabelsItem("log", "true");
                if (null != gpu_type) {
                    podTemplateMeta.putLabelsItem("gpu", gpu_type);
                }
                V1TFJob tfJob = new V1TFJob().apiVersion("kubeflow.org/v1").kind("TFJob").metadata(new V1ObjectMeta().name("tf-job-" + guid.substring(24)).namespace(guid)).spec(new V1TFJobSpec().runPolicy(runPolicy).putTfReplicaSpecsItem("Worker", new V1ReplicaSpec().replicas(version.getReplicas()).restartPolicy("Never").template(new V1PodTemplateSpec().metadata(podTemplateMeta).spec(podSpec.addContainersItem(new V1Container().name("tensorflow").workingDir(path).resources(requirements).image(version.getImage()).args(commands).volumeMounts(volumeMounts))))));
                try {
                    KubernetesApiResponse response = k8sFactory.tfJobApi.create((KubernetesObject)tfJob);
                    if (!response.isSuccess()) {
                        throw new RuntimeException(response.getStatus().toString());
                    }
                }
                catch (JsonSyntaxException | IllegalStateException e) {
                    LOGGER.error(e.toString());
                }
            } else if ("pytorch".equalsIgnoreCase(version.getFrameType())) {
                podTemplateMeta.putLabelsItem("kubeflow-role", "train").putLabelsItem("log", "true");
                if (null != gpu_type) {
                    podTemplateMeta.putLabelsItem("gpu", gpu_type);
                }
                V1PodTemplateSpec podTemplateSpec = new V1PodTemplateSpec().metadata(podTemplateMeta).spec(podSpec.addContainersItem(new V1Container().name("pytorch").workingDir(path).image(version.getImage()).resources(requirements).args(commands).volumeMounts(volumeMounts)));
                V1PyTorchJobSpec pyTorchJobSpec = new V1PyTorchJobSpec().runPolicy(runPolicy).putPytorchReplicaSpecsItem("Master", new V1ReplicaSpec().replicas(Integer.valueOf(1)).restartPolicy("Never").template(podTemplateSpec));
                if (version.getReplicas() > 1) {
                    pyTorchJobSpec.putPytorchReplicaSpecsItem("Worker", new V1ReplicaSpec().replicas(Integer.valueOf(version.getReplicas() - 1)).restartPolicy("Never").template(podTemplateSpec));
                }
                V1PyTorchJob torchJob = new V1PyTorchJob().apiVersion("kubeflow.org/v1").kind("PyTorchJob").metadata(new V1ObjectMeta().name("pytorch-job" + guid.substring(24)).namespace(guid)).spec(pyTorchJobSpec);
                try {
                    KubernetesApiResponse response = k8sFactory.pyTorchJobApi.create((KubernetesObject)torchJob);
                    if (!response.isSuccess()) {
                        throw new RuntimeException(response.getStatus().toString());
                    }
                }
                catch (JsonSyntaxException | IllegalStateException e) {
                    LOGGER.error(e.toString());
                }
            } else if ("mxnet".equalsIgnoreCase(version.getFrameType())) {
                V1PodSpec workPodSpec = (V1PodSpec)BeanMapper.map((Object)podSpec, V1PodSpec.class);
                V1ObjectMeta workerPodTemplateMeta = ((V1ObjectMeta)BeanMapper.map((Object)podTemplateMeta, V1ObjectMeta.class)).putLabelsItem("kubeflow-role", "train").putLabelsItem("log", "true");
                if (null != gpu_type) {
                    workerPodTemplateMeta.putLabelsItem("gpu", gpu_type);
                }
                V1PodTemplateSpec podTemplateSpec = new V1PodTemplateSpec().metadata(podTemplateMeta).spec(podSpec.addContainersItem(new V1Container().name("mxnet").workingDir(path).image(version.getImage()).args(commands).volumeMounts(volumeMounts)));
                V1MXJobSpec mxJobSpec = new V1MXJobSpec().jobMode("MXTrain").runPolicy(runPolicy).putMXReplicaSpecsItem("Scheduler", new V1ReplicaSpec().replicas(Integer.valueOf(1)).restartPolicy("Never").template(podTemplateSpec)).putMXReplicaSpecsItem("Server", new V1ReplicaSpec().replicas(Integer.valueOf(1)).restartPolicy("Never").template(podTemplateSpec));
                mxJobSpec.putMXReplicaSpecsItem("Worker", new V1ReplicaSpec().replicas(version.getReplicas()).restartPolicy("Never").template(new V1PodTemplateSpec().metadata(workerPodTemplateMeta).spec(workPodSpec.addContainersItem(new V1Container().name("mxnet").workingDir(path).resources(requirements).image(version.getImage()).args(commands).volumeMounts(volumeMounts)))));
                V1MXJob mxJob = new V1MXJob().apiVersion("kubeflow.org/v1").kind("MXJob").metadata(new V1ObjectMeta().name("mxnet-job" + guid.substring(24)).namespace(guid)).spec(mxJobSpec);
                try {
                    KubernetesApiResponse response = k8sFactory.mxJobApi.create((KubernetesObject)mxJob);
                    if (!response.isSuccess()) {
                        throw new RuntimeException(response.getStatus().toString());
                    }
                }
                catch (JsonSyntaxException | IllegalStateException e) {
                    LOGGER.error(e.getMessage());
                }
            } else if ("mpi".equalsIgnoreCase(version.getFrameType())) {
                V1PodSpec workPodSpec = (V1PodSpec)BeanMapper.map((Object)podSpec, V1PodSpec.class);
                podTemplateMeta.putLabelsItem("log", "true");
                V1ObjectMeta workerPodTemplateMeta = ((V1ObjectMeta)BeanMapper.map((Object)podTemplateMeta, V1ObjectMeta.class)).putLabelsItem("kubeflow-role", "train");
                if (null != gpu_type) {
                    workerPodTemplateMeta.putLabelsItem("gpu", gpu_type);
                }
                V1MPIJobSpec mpiJobSpec = new V1MPIJobSpec().cleanPodPolicy("Running").runPolicy(runPolicy).slotsPerWorker(Integer.valueOf(pack.getGpuNum() != null ? pack.getGpuNum() : 1)).putMpiReplicaSpecsItem("Launcher", new V1ReplicaSpec().replicas(Integer.valueOf(1)).restartPolicy("Never").template(new V1PodTemplateSpec().metadata(podTemplateMeta).spec(podSpec.addContainersItem(new V1Container().name("mpi").image(version.getImage()).workingDir(path).addArgsItem("mpirun").addArgsItem("--allow-run-as-root").addArgsItem("--display-map").addArgsItem("-np").addArgsItem(String.valueOf(version.getReplicas() * pack.getGpuNum())).addArgsItem("-bind-to").addArgsItem("none").addArgsItem("-map-by").addArgsItem("slot").addArgsItem("-x").addArgsItem("NCCL_DEBUG=INFO").addArgsItem("-x").addArgsItem("LD_LIBRARY_PATH").addArgsItem("-x").addArgsItem("PATH").addArgsItem("-mca").addArgsItem("pml").addArgsItem("ob1").addArgsItem("-mca").addArgsItem("btl").addArgsItem("^openib").addArgsItem("python").addArgsItem(file).args(args).volumeMounts(volumeMounts))))).putMpiReplicaSpecsItem("Worker", new V1ReplicaSpec().replicas(version.getReplicas()).restartPolicy("Never").template(new V1PodTemplateSpec().metadata(workerPodTemplateMeta).spec(workPodSpec.addContainersItem(new V1Container().name("mpi").workingDir(path).image(version.getImage()).resources(requirements).volumeMounts(volumeMounts)))));
                V1MPIJob mpiJob = new V1MPIJob().apiVersion("kubeflow.org/v1").kind("MPIJob").metadata(new V1ObjectMeta().name("mpi-job" + guid.substring(24)).namespace(guid)).spec(mpiJobSpec);
                try {
                    KubernetesApiResponse response = k8sFactory.mpiJobApi.create((KubernetesObject)mpiJob);
                    if (!response.isSuccess()) {
                        throw new RuntimeException(response.getStatus().toString());
                    }
                }
                catch (JsonSyntaxException | IllegalStateException e) {
                    LOGGER.error(e.toString());
                }
            }
            this.tensorboard(version, k8sFactory, volumes, volumeMounts);
        }
        catch (Exception e) {
            try {
                FactoryCollection.k8sFactory((Long)domain_id).deleteNamespace(guid);
            }
            catch (ApiException apiException) {
                LOGGER.info(apiException.getResponseBody());
            }
            version.setStatus(Integer.valueOf(-2));
            version.setErrorMessage(e instanceof ApiException ? ((ApiException)((Object)e)).getResponseBody() : e.getMessage());
            LOGGER.error("job create [" + job.getId() + "]" + job.getName() + version.getErrorMessage(), (Throwable)e);
        }
    }

    public void storage(JobVersion version, K8sFactory k8sFactory, List<V1VolumeMount> volumeMounts, List<V1Volume> volumes) throws Exception {
        volumeMounts.add(new V1VolumeMount().name("timezone").mountPath("/etc/localtime"));
        volumeMounts.add(new V1VolumeMount().name("shm").mountPath("/dev/shm"));
        volumes.add(new V1Volume().name("shm").emptyDir(new V1EmptyDirVolumeSource().medium("Memory")));
        volumes.add(new V1Volume().name("timezone").hostPath(new V1HostPathVolumeSource().path("/usr/share/zoneinfo/Asia/Shanghai")));
        List jobStorages = version.getStorages();
        if (null != jobStorages && jobStorages.size() > 0) {
            Job job = version.getJob();
            for (JobStorage js : jobStorages) {
                StorageDept storageDept;
                boolean readOnly;
                Storage storage = js.getStorage();
                boolean bl = readOnly = !storage.getUser().equals((Object)job.getUser());
                if (readOnly && null != (storageDept = this.storageDeptRepository.findByStorageIdAndDepartment(storage.getId(), job.getDepartment())) && storageDept.getRw() == 1) {
                    readOnly = false;
                }
                this.storageServiceFactory.volumeMountPrepare(storage.getType(), volumes, volumeMounts, VolumeMountDto.builder().k8sFactory(k8sFactory).namespace(version.getGuid()).storage(storage.getName()).storageGuid(storage.getGuid()).mountPath(StringUtils.isEmpty((Object)js.getPath()) ? "/ai/" + storage.getGuid().substring(0, 12) : js.getPath()).readOnly(Boolean.valueOf(readOnly)).build());
            }
        }
    }

    public void tensorboard(JobVersion version, K8sFactory k8sFactory, List<V1Volume> volumes, List<V1VolumeMount> volumeMounts) throws ApiException {
        String guid = version.getGuid();
        AppsV1Api appsV1Api = k8sFactory.appsV1Api;
        if (version.getTensorboardState() == 1 && !StringUtils.isEmpty((Object)version.getLogDir())) {
            try {
                V1Deployment deployment = appsV1Api.readNamespacedDeployment(TENSORBOARD, guid, null, null, null);
                List envList = ((V1Container)deployment.getSpec().replicas(Integer.valueOf(1)).getTemplate().getSpec().volumes(volumes).getContainers().get(0)).volumeMounts(volumeMounts).getEnv();
                Optional<V1EnvVar> optional = envList.stream().filter(e -> "TENSORBOARD_LOG_DIR".equals(e.getName())).findAny();
                if (optional.isPresent()) {
                    optional.get().setValue(version.getLogDir());
                } else {
                    envList.add(new V1EnvVar().name("TENSORBOARD_LOG_DIR").value(version.getLogDir()));
                }
                appsV1Api.replaceNamespacedDeployment(TENSORBOARD, guid, deployment, null, null, null);
                return;
            }
            catch (ApiException e2) {
                LOGGER.info(e2.getResponseBody());
                V1ObjectMeta meta = new V1ObjectMeta().name(TENSORBOARD).namespace(guid);
                V1Deployment deployment = new V1Deployment().metadata(meta).spec(new V1DeploymentSpec().replicas(Integer.valueOf(1)).selector(new V1LabelSelector().putMatchLabelsItem("app", TENSORBOARD)).template(new V1PodTemplateSpec().metadata(new V1ObjectMeta().putLabelsItem("app", TENSORBOARD)).spec(new V1PodSpec().volumes(volumes).addContainersItem(new V1Container().name(TENSORBOARD).image(version.getImage()).addEnvItem(new V1EnvVar().name("TENSORBOARD_LOG_DIR").value(version.getLogDir())).volumeMounts(volumeMounts)))));
                appsV1Api.createNamespacedDeployment(guid, deployment, null, null, null);
                V1Service svc = k8sFactory.createSvc(guid, new V1Service().metadata(meta).spec(new V1ServiceSpec().type("NodePort").putSelectorItem("app", TENSORBOARD).addPortsItem(new V1ServicePort().name(TENSORBOARD).port(Integer.valueOf(6006)))));
                version.setTensorboard(((V1ServicePort)svc.getSpec().getPorts().get(0)).getNodePort());
            }
        } else {
            try {
                V1Deployment deployment = appsV1Api.readNamespacedDeployment(TENSORBOARD, guid, null, null, null);
                deployment.getSpec().replicas(Integer.valueOf(0));
                appsV1Api.replaceNamespacedDeployment(TENSORBOARD, guid, deployment, null, null, null);
            }
            catch (ApiException e3) {
                LOGGER.info(e3.getResponseBody());
            }
        }
    }

    @ConstructorProperties(value={"messageUtil", "k8sEngineRepository", "jobVersionRepository", "materialsRepository", "referDurationRepository", "operationLogService", "commonService", "storageDeptRepository", "storageServiceFactory", "systemConfigRepository", "storageRepository"})
    public JobService(MessageUtil messageUtil, K8sEngineRepository k8sEngineRepository, JobVersionRepository jobVersionRepository, MaterialsRepository materialsRepository, ReferDurationRepository referDurationRepository, OperationLogService operationLogService, CommonService commonService, StorageDeptRepository storageDeptRepository, StorageServiceFactory storageServiceFactory, SystemConfigRepository systemConfigRepository, StorageRepository storageRepository) {
        this.messageUtil = messageUtil;
        this.k8sEngineRepository = k8sEngineRepository;
        this.jobVersionRepository = jobVersionRepository;
        this.materialsRepository = materialsRepository;
        this.referDurationRepository = referDurationRepository;
        this.operationLogService = operationLogService;
        this.commonService = commonService;
        this.storageDeptRepository = storageDeptRepository;
        this.storageServiceFactory = storageServiceFactory;
        this.systemConfigRepository = systemConfigRepository;
        this.storageRepository = storageRepository;
    }
}

