/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.service;

import com.mopaas.server.dao.ModelVersionRepository;
import com.mopaas.server.entity.ModelVersion;
import com.mopaas.server.entity.Storage;
import com.mopaas.server.factory.FactoryCollection;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
public class ModelAsyncService {
    final ModelVersionRepository modelVersionRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelAsyncService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Transactional
    public void modelImport(Long versionId, Storage storage, String path, Long domain_id) {
        ModelVersion version = (ModelVersion)this.modelVersionRepository.findOne((Serializable)versionId);
        String relativePath = path.substring(path.indexOf("/", 4));
        relativePath = relativePath.length() == 1 ? "*" : relativePath.substring(1);
        String processKey = "model" + version.getId() + version.getVersion();
        try {
            Integer exitValue = FactoryCollection.minioCP((Long)domain_id, (String)storage.getGuid(), (String)storage.getName(), (String)relativePath, (String)version.getObsPath(), (String)processKey);
            if (exitValue == 0) {
                version.setStatus(Integer.valueOf(1));
            } else {
                version.setStatus(Integer.valueOf(-1));
            }
        }
        catch (Exception e) {
            LOGGER.error("import model [{}-{}] failed", new Object[]{version.getName(), version.getVersion(), e});
            version.setStatus(Integer.valueOf(-1));
            version.setErrorMessage(e.toString());
        }
        finally {
            if (FactoryCollection.PROCESS_MAP.containsKey(processKey)) {
                ((Process)FactoryCollection.PROCESS_MAP.get(processKey)).destroy();
            }
        }
    }

    @Async
    public void modelRemove(ModelVersion version, Long domain_id) {
        try {
            String processKey = version.getId() + version.getVersion();
            if (FactoryCollection.PROCESS_MAP.containsKey(processKey)) {
                ((Process)FactoryCollection.PROCESS_MAP.get(processKey)).destroy();
            }
            if (!StringUtils.isEmpty((Object)version.getObsPath())) {
                String[] split = version.getObsPath().split("/");
                FactoryCollection.minioRemoveObjects((Long)domain_id, (String)"ai-model", (String)(split[1] + "/" + split[2]));
            }
        }
        catch (Exception e) {
            LOGGER.error("delete model [{}-{}] failed, reason : {}", new Object[]{version.getName(), version.getVersion(), e.getMessage()});
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @ConstructorProperties(value={"modelVersionRepository"})
    public ModelAsyncService(ModelVersionRepository modelVersionRepository) {
        this.modelVersionRepository = modelVersionRepository;
    }
}

