/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.mopaas.server.dao.AccountNoticePushRepository;
import com.mopaas.server.dao.MgrUserRepository;
import com.mopaas.server.dao.NoticeRepository;
import com.mopaas.server.dao.PortalConfigRepository;
import com.mopaas.server.dao.SystemConfigRepository;
import com.mopaas.server.dao.TemplateSmsRepository;
import com.mopaas.server.dao.UserRepository;
import com.mopaas.server.entity.AccountNoticePush;
import com.mopaas.server.entity.MgrUser;
import com.mopaas.server.entity.Notice;
import com.mopaas.server.entity.OrgConfigDepartment;
import com.mopaas.server.entity.SystemConfig;
import com.mopaas.server.entity.TemplateSms;
import com.mopaas.server.entity.User;
import com.mopaas.server.service.NoticeService;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class NoticeUserService {
    final SystemConfigRepository systemConfigRepository;
    final MgrUserRepository mgrUserRepository;
    final NoticeRepository noticeRepository;
    final PortalConfigRepository portalConfigRepository;
    final MessageSource messageSource;
    final AccountNoticePushRepository accountNoticePushRepository;
    final UserRepository userRepository;
    final NoticeService noticeService;
    final TemplateSmsRepository templateSmsRepository;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Logger logger = LoggerFactory.getLogger(NoticeUserService.class);

    private String message(String key, String ... args) {
        return this.messageSource.getMessage(key, (Object[])args, null);
    }

    public void send(Integer type, String name, User user) {
        SystemConfig notice_send_mgr = this.systemConfigRepository.findByConfigName("NOTICE_SEND_MGR");
        if (notice_send_mgr == null || Strings.isNullOrEmpty((String)notice_send_mgr.getConfigValue())) {
            return;
        }
        String sendMgr = notice_send_mgr.getConfigValue();
        if (sendMgr == null || sendMgr.isEmpty()) {
            return;
        }
        boolean message = sendMgr.contains("1");
        boolean email = sendMgr.contains("2");
        if (!message && !email) {
            return;
        }
        List users = this.mgrUserRepository.findByActiveAndNoticeStatus(Integer.valueOf(1), Integer.valueOf(1));
        if (null == users || users.isEmpty()) {
            return;
        }
        JSONArray sendType = new JSONArray();
        if (message) {
            sendType.add((Object)"1");
        }
        if (email) {
            sendType.add((Object)"2");
        }
        try {
            for (MgrUser mgr : users) {
                Notice notice = new Notice();
                notice.setSendType(String.valueOf(sendType));
                JSONObject json = new JSONObject();
                json.put("type", (Object)(type == 0 ? "\u521b\u5efa\u73af\u5883\u5f85\u5ba1\u6838" : "\u73af\u5883\u8d44\u6e90\u6269\u7f29\u5bb9\u5f85\u5ba1\u6838"));
                if (email) {
                    notice.setEmail(mgr.getEmail());
                    JSONObject jsonEmail = new JSONObject();
                    jsonEmail.put("templateName", (Object)(type == 0 ? "resource_to_be_audited" : "resource_scale_audited"));
                    HashMap map = new HashMap();
                    jsonEmail.put("param", map);
                    json.put("email", (Object)jsonEmail);
                }
                if (message) {
                    TemplateSms smsTemplateCode;
                    notice.setPhone(mgr.getTel());
                    JSONObject jsonPhone = new JSONObject();
                    String templateName = type == 0 ? "resource_to_be_audited" : "resource_scale_audited";
                    jsonPhone.put("templateName", (Object)templateName);
                    SystemConfig accesskeyId = this.systemConfigRepository.findByConfigName("NOTICE_SMS_ACCESSKEY_ID");
                    if (accesskeyId != null && accesskeyId.getConfigValue() != null && (smsTemplateCode = this.templateSmsRepository.findByAccessKeyIdAndTemplateNameAndDeleted(accesskeyId.getConfigValue(), templateName, Integer.valueOf(0))) != null) {
                        jsonPhone.put("templateCode", (Object)smsTemplateCode.getTemplateCode());
                    }
                    HashMap map = new HashMap();
                    jsonPhone.put("param", map);
                    json.put("phone", (Object)jsonPhone);
                }
                notice.setSendContent(json.toString());
                notice.setUser(user);
                notice.setName(name);
                notice.setSendTimes(Integer.valueOf(1));
                notice.setSendComplete(Integer.valueOf(0));
                notice.setCreatedAt(new Date());
                this.noticeService.notice(notice);
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void sendInvite(User user, OrgConfigDepartment department, User adminUser, String linkurl) {
        JSONObject noticeContentJsonObject = new JSONObject();
        noticeContentJsonObject.put("zh", (Object)(adminUser.getName() + this.messageSource.getMessage("msg.notice.title", null, Locale.CHINA) + department.getName() + " \uff0c" + this.messageSource.getMessage("msg.notice.content", null, Locale.CHINA) + "~\n<a href=\"" + linkurl + "\" target=\"_blank\" style=\"color:#00ebf6\">" + linkurl + "</a>"));
        noticeContentJsonObject.put("en", (Object)(adminUser.getName() + " " + this.messageSource.getMessage("msg.notice.title", null, Locale.US) + department.getName() + " \uff0c" + this.messageSource.getMessage("msg.notice.content", null, Locale.US) + "~\n<a href=\"" + linkurl + "\" target=\"_blank\" style=\"color:#00ebf6\">" + linkurl + "</a>"));
        String noticeContent = noticeContentJsonObject.toString();
        AccountNoticePush noticePush = new AccountNoticePush();
        noticePush.setContent(noticeContent);
        noticePush.setOrganization(department.getOrgConfig().getOrganization());
        noticePush.setUser(user);
        noticePush.setState(Integer.valueOf(0));
        noticePush.setDepartment(department);
        noticePush.setDeleted(Integer.valueOf(0));
        noticePush.setCreatedAt(new Date());
        noticePush.setCreator(adminUser.getUsername());
        noticePush.setType(Integer.valueOf(0));
        this.accountNoticePushRepository.save((Object)noticePush);
        SystemConfig notice_send_mgr = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        if (notice_send_mgr == null || Strings.isNullOrEmpty((String)notice_send_mgr.getConfigValue())) {
            return;
        }
        String sendMgr = notice_send_mgr.getConfigValue();
        if (sendMgr == null || sendMgr.isEmpty()) {
            return;
        }
        boolean emailState = sendMgr.contains("2");
        if (!emailState) {
            return;
        }
        String email = user.getEmail();
        if (email != null) {
            Notice notice = new Notice();
            ArrayList<String> list = new ArrayList<String>();
            list.add("2");
            notice.setSendType(JSONArray.fromObject(list).toString());
            JSONObject json = new JSONObject();
            json.put("type", (Object)"\u90e8\u95e8\u9080\u8bf7");
            JSONObject jsonEmail = new JSONObject();
            jsonEmail.put("templateName", (Object)"invitation_join_deptment");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("admin", adminUser.getName());
            map.put("department", department.getName());
            map.put("url", linkurl);
            jsonEmail.put("param", map);
            json.put("email", (Object)jsonEmail);
            notice.setSendContent(json.toString());
            notice.setUser(user);
            notice.setName(user.getUsername());
            notice.setSendTimes(Integer.valueOf(1));
            notice.setEmail(email);
            notice.setSendComplete(Integer.valueOf(0));
            notice.setCreatedAt(new Date());
            this.noticeService.notice(notice);
        }
    }

    public void sendMemberChange(Integer type, String username, User user, OrgConfigDepartment department) {
        String noticeContent = null;
        JSONObject noticeContentJsonObject = new JSONObject();
        if (type == 0) {
            noticeContentJsonObject.put("zh", (Object)(username + " " + this.messageSource.getMessage("msg.notice.join", null, Locale.CHINA) + " " + department.getName() + " \u3002"));
            noticeContentJsonObject.put("en", (Object)(username + " " + this.messageSource.getMessage("msg.notice.join", null, Locale.US) + " " + department.getName() + " \u3002"));
            noticeContent = noticeContentJsonObject.toString();
        } else if (type == 1) {
            noticeContentJsonObject.put("zh", (Object)(username + " " + this.messageSource.getMessage("msg.notice.quit", null, Locale.CHINA) + " " + department.getName() + " \u3002"));
            noticeContentJsonObject.put("en", (Object)(username + " " + this.messageSource.getMessage("msg.notice.quit", null, Locale.US) + " " + department.getName() + " \u3002"));
            noticeContent = noticeContentJsonObject.toString();
        } else {
            return;
        }
        AccountNoticePush noticePush = new AccountNoticePush();
        noticePush.setContent(noticeContent);
        noticePush.setOrganization(department.getOrgConfig().getOrganization());
        noticePush.setUser(user);
        noticePush.setState(Integer.valueOf(0));
        noticePush.setDepartment(department);
        noticePush.setDeleted(Integer.valueOf(0));
        noticePush.setCreatedAt(new Date());
        noticePush.setCreator(this.message("msg.system", new String[0]));
        noticePush.setType(Integer.valueOf(0));
        this.accountNoticePushRepository.save((Object)noticePush);
    }

    public void sendMemberRemove(String adminName, String username, User user, OrgConfigDepartment department) {
        String noticeContent = null;
        JSONObject noticeContentJsonObject = new JSONObject();
        noticeContentJsonObject.put("zh", (Object)this.messageSource.getMessage("msg.notice.content.quit", null, Locale.CHINA).replace("#username#", username).replace("#adminname#", adminName).replace("#department#", department.getName()));
        noticeContentJsonObject.put("en", (Object)this.messageSource.getMessage("msg.notice.content.quit", null, Locale.US).replace("#username#", username).replace("#adminname#", adminName).replace("#department#", department.getName()));
        noticeContent = noticeContentJsonObject.toString();
        AccountNoticePush noticePush = new AccountNoticePush();
        noticePush.setContent(noticeContent);
        noticePush.setOrganization(department.getOrgConfig().getOrganization());
        noticePush.setUser(user);
        noticePush.setState(Integer.valueOf(0));
        noticePush.setDepartment(department);
        noticePush.setDeleted(Integer.valueOf(0));
        noticePush.setCreatedAt(new Date());
        noticePush.setCreator(this.message("msg.system", new String[0]));
        noticePush.setType(Integer.valueOf(0));
        this.accountNoticePushRepository.save((Object)noticePush);
    }

    public void sendMemberEmail(Integer type, User user, OrgConfigDepartment department, User admin) {
        SystemConfig notice_send_mgr = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        if (notice_send_mgr == null || Strings.isNullOrEmpty((String)notice_send_mgr.getConfigValue())) {
            return;
        }
        String sendMgr = notice_send_mgr.getConfigValue();
        if (sendMgr == null || sendMgr.isEmpty()) {
            return;
        }
        boolean emailState = sendMgr.contains("2");
        if (!emailState) {
            return;
        }
        String email = user.getEmail();
        if (email != null) {
            Notice notice = new Notice();
            ArrayList<String> list = new ArrayList<String>();
            list.add("2");
            notice.setSendType(JSONArray.fromObject(list).toString());
            JSONObject json = new JSONObject();
            json.put("type", (Object)(type == 0 ? "\u5220\u9664\u90e8\u95e8" : "\u79fb\u9664\u90e8\u95e8"));
            JSONObject jsonEmail = new JSONObject();
            jsonEmail.put("templateName", (Object)(type == 0 ? "delete_depment" : "remove_deptment"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("admin", admin.getUsername());
            map.put("adminname", admin.getName());
            map.put("department", department.getName());
            jsonEmail.put("param", map);
            json.put("email", (Object)jsonEmail);
            notice.setSendContent(json.toString());
            notice.setUser(user);
            notice.setName(user.getUsername());
            notice.setSendTimes(Integer.valueOf(1));
            notice.setEmail(email);
            notice.setSendComplete(Integer.valueOf(0));
            notice.setCreatedAt(new Date());
            this.noticeService.notice(notice);
        }
    }

    public void pushNotice(String title, String content, User user) {
        AccountNoticePush accountNoticePush = new AccountNoticePush();
        accountNoticePush.setTitle(title);
        accountNoticePush.setContent(content);
        accountNoticePush.setUser(user);
        accountNoticePush.setState(Integer.valueOf(0));
        accountNoticePush.setDeleted(Integer.valueOf(0));
        accountNoticePush.setCreatedAt(new Date());
        accountNoticePush.setCreator(this.messageSource.getMessage("msg.system", null, null));
        accountNoticePush.setType(Integer.valueOf(1));
        this.accountNoticePushRepository.save((Object)accountNoticePush);
    }

    public void jobMessage(Integer type, User user, String resourceName) {
        TemplateSms smsTemplateCode;
        String templateName;
        String typeName;
        SystemConfig notice_send_user = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        if (notice_send_user == null || Strings.isNullOrEmpty((String)notice_send_user.getConfigValue())) {
            return;
        }
        String sendUser = notice_send_user.getConfigValue();
        if (sendUser == null || sendUser.isEmpty()) {
            return;
        }
        boolean message = sendUser.contains("1");
        boolean email = sendUser.contains("2");
        if (!message && !email) {
            return;
        }
        JSONArray sendType = new JSONArray();
        if (message) {
            sendType.add((Object)"1");
        }
        if (type == 0) {
            typeName = "\u8bad\u7ec3\u4efb\u52a1\u8bad\u7ec3\u5f00\u59cb";
            templateName = "job_training_start";
        } else if (type == 1) {
            typeName = "\u8bad\u7ec3\u4efb\u52a1\u8bad\u7ec3\u5931\u8d25";
            templateName = "job_training_fail";
        } else {
            typeName = "\u8bad\u7ec3\u4efb\u52a1\u8bad\u7ec3\u5b8c\u6210";
            templateName = "job_training_complete";
        }
        Notice notice = new Notice();
        notice.setSendType(String.valueOf(sendType));
        JSONObject json = new JSONObject();
        json.put("type", (Object)typeName);
        notice.setPhone(user.getPhone());
        JSONObject jsonPhone = new JSONObject();
        jsonPhone.put("templateName", (Object)templateName);
        SystemConfig accesskeyId = this.systemConfigRepository.findByConfigName("NOTICE_SMS_ACCESSKEY_ID");
        if (accesskeyId != null && accesskeyId.getConfigValue() != null && (smsTemplateCode = this.templateSmsRepository.findByAccessKeyIdAndTemplateNameAndDeleted(accesskeyId.getConfigValue(), templateName, Integer.valueOf(0))) != null) {
            jsonPhone.put("templateCode", (Object)smsTemplateCode.getTemplateCode());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("resourceName", resourceName);
        jsonPhone.put("param", map);
        json.put("phone", (Object)jsonPhone);
        notice.setSendContent(json.toString());
        notice.setUser(user);
        notice.setName(resourceName);
        notice.setSendTimes(Integer.valueOf(1));
        notice.setSendComplete(Integer.valueOf(0));
        notice.setCreatedAt(new Date());
        this.noticeService.notice(notice);
    }

    public void automlMessage(Integer type, User user, String resourceName) {
        TemplateSms smsTemplateCode;
        String templateName;
        String typeName;
        SystemConfig notice_send_user = this.systemConfigRepository.findByConfigName("NOTICE_SEND_USER");
        if (notice_send_user == null || Strings.isNullOrEmpty((String)notice_send_user.getConfigValue())) {
            return;
        }
        String sendUser = notice_send_user.getConfigValue();
        if (sendUser == null || sendUser.isEmpty()) {
            return;
        }
        boolean message = sendUser.contains("1");
        boolean email = sendUser.contains("2");
        if (!message && !email) {
            return;
        }
        JSONArray sendType = new JSONArray();
        if (message) {
            sendType.add((Object)"1");
        }
        if (type == 0) {
            typeName = "\u8d85\u53c2\u8c03\u4f18\u8bd5\u9a8c\u5f00\u59cb\u8fd0\u884c";
            templateName = "experiment_running_start";
        } else if (type == 1) {
            typeName = "\u8d85\u53c2\u8c03\u4f18\u8bd5\u9a8c\u8fd0\u884c\u5931\u8d25";
            templateName = "experiment_running_fail";
        } else {
            typeName = "\u8d85\u53c2\u8c03\u4f18\u8bd5\u9a8c\u8fd0\u884c\u5b8c\u6210";
            templateName = "experiment_running_complete";
        }
        Notice notice = new Notice();
        notice.setSendType(String.valueOf(sendType));
        JSONObject json = new JSONObject();
        json.put("type", (Object)typeName);
        notice.setPhone(user.getPhone());
        JSONObject jsonPhone = new JSONObject();
        jsonPhone.put("templateName", (Object)templateName);
        SystemConfig accesskeyId = this.systemConfigRepository.findByConfigName("NOTICE_SMS_ACCESSKEY_ID");
        if (accesskeyId != null && accesskeyId.getConfigValue() != null && (smsTemplateCode = this.templateSmsRepository.findByAccessKeyIdAndTemplateNameAndDeleted(accesskeyId.getConfigValue(), templateName, Integer.valueOf(0))) != null) {
            jsonPhone.put("templateCode", (Object)smsTemplateCode.getTemplateCode());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("resourceName", resourceName);
        jsonPhone.put("param", map);
        json.put("phone", (Object)jsonPhone);
        notice.setSendContent(json.toString());
        notice.setUser(user);
        notice.setName(resourceName);
        notice.setSendTimes(Integer.valueOf(1));
        notice.setSendComplete(Integer.valueOf(0));
        notice.setCreatedAt(new Date());
        this.noticeService.notice(notice);
    }

    @ConstructorProperties(value={"systemConfigRepository", "mgrUserRepository", "noticeRepository", "portalConfigRepository", "messageSource", "accountNoticePushRepository", "userRepository", "noticeService", "templateSmsRepository"})
    public NoticeUserService(SystemConfigRepository systemConfigRepository, MgrUserRepository mgrUserRepository, NoticeRepository noticeRepository, PortalConfigRepository portalConfigRepository, MessageSource messageSource, AccountNoticePushRepository accountNoticePushRepository, UserRepository userRepository, NoticeService noticeService, TemplateSmsRepository templateSmsRepository) {
        this.systemConfigRepository = systemConfigRepository;
        this.mgrUserRepository = mgrUserRepository;
        this.noticeRepository = noticeRepository;
        this.portalConfigRepository = portalConfigRepository;
        this.messageSource = messageSource;
        this.accountNoticePushRepository = accountNoticePushRepository;
        this.userRepository = userRepository;
        this.noticeService = noticeService;
        this.templateSmsRepository = templateSmsRepository;
    }
}

