/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.ws;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Component
public class WsHandshakeInterceptor
implements HandshakeInterceptor {
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        if (request instanceof ServletServerHttpRequest) {
            String id;
            HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
            String namespace = servletRequest.getParameter("namespace");
            if (null != namespace) {
                attributes.put("namespace", namespace);
                attributes.put("domain", Long.parseLong(servletRequest.getParameter("domain")));
                String container = servletRequest.getParameter("container");
                if (null != container) {
                    attributes.put("container", container);
                }
            }
            if ((id = servletRequest.getParameter("id")) != null) {
                attributes.put("id", id);
            }
        }
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

