/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.ws;

import com.mopaas.server.common.ElasticsearchUtils;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.model.response.LogResponse;
import io.kubernetes.client.PodLogs;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class WsK8sPodLogHandler
extends TextWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(WsK8sPodLogHandler.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        EXECUTOR_SERVICE.execute(() -> {
            try {
                this.sendLog(session);
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendLog(WebSocketSession session) throws Exception {
        String namespace = (String)session.getAttributes().get("namespace");
        Long domain = (Long)session.getAttributes().get("domain");
        String container = session.getAttributes().get("container") != null ? (String)session.getAttributes().get("container") : null;
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domain);
        List pods = k8sFactory.listPods(namespace);
        String pod_name = null;
        for (V1Pod pod : pods) {
            if (!pod.getMetadata().getLabels().containsKey("log")) continue;
            pod_name = pod.getMetadata().getName();
            break;
        }
        if (null != pod_name) {
            BufferedReader reader = null;
            try {
                String line;
                InputStream stream = new PodLogs(k8sFactory.client).streamNamespacedPodLog(namespace, pod_name, container, null, Integer.valueOf(1000), false);
                reader = new BufferedReader(new InputStreamReader(stream));
                while (session.isOpen() && null != (line = reader.readLine())) {
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(line + "\r\n")));
                }
            }
            finally {
                if (null != reader) {
                    reader.close();
                }
                if (session.isOpen()) {
                    session.close();
                }
            }
        } else {
            LogResponse logResponse = ElasticsearchUtils.query((Long)domain, (String)namespace, (String)container, null, null, null, null, (Integer)1000);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)logResponse.getLog()));
            session.close();
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        logger.info("socket is closed with status code:{}; reason:{}", (Object)status.getCode(), (Object)status.getReason());
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        logger.error(exception.getMessage());
    }
}

