/*
 * Decompiled with CFR 0.152.
 */
package com.mopaas.server.ws;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mopaas.server.common.SizeConverter;
import com.mopaas.server.dao.DepQuotasRepository;
import com.mopaas.server.dao.DepUsersRepository;
import com.mopaas.server.dao.MLabProjectRepository;
import com.mopaas.server.dao.ReferDurationRepository;
import com.mopaas.server.dao.ResourceRepository;
import com.mopaas.server.dao.StorageRepository;
import com.mopaas.server.entity.DepQuotas;
import com.mopaas.server.entity.DepUsers;
import com.mopaas.server.entity.MLabProject;
import com.mopaas.server.entity.PricePackage;
import com.mopaas.server.entity.Resource;
import com.mopaas.server.factory.FactoryCollection;
import com.mopaas.server.factory.K8sFactory;
import com.mopaas.server.factory.StorageServiceFactory;
import com.mopaas.server.model.InstantMetricModel;
import com.mopaas.server.model.response.NotebookMetricResponse;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Pod;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class WsNotebookMetricsHandler
extends TextWebSocketHandler {
    final ResourceRepository resourceRepository;
    final ReferDurationRepository referDurationRepository;
    final DepUsersRepository depUsersRepository;
    final DepQuotasRepository depQuotasRepository;
    final StorageRepository storageRepository;
    final MLabProjectRepository mLabProjectRepository;
    final StorageServiceFactory storageServiceFactory;
    private static final ObjectMapper mapper = new ObjectMapper();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        Map attributes = session.getAttributes();
        Object id = attributes.get("id");
        if (null != id) {
            Resource resource = (Resource)this.resourceRepository.findOne((Serializable)Long.valueOf(Long.parseLong(String.valueOf(id))));
            if (null != resource) {
                attributes.put("id", resource.getId());
                attributes.put("guid", resource.getGuid());
                attributes.put("userId", resource.getUser().getId());
                attributes.put("depId", resource.getDepartment().getId());
                attributes.put("domainId", resource.getDomain().getId());
                PricePackage pack = resource.getPack();
                attributes.put("cpu", pack.getCpuNum());
                attributes.put("mem", pack.getMemoryNum());
                if (resource.getMLabProject() != null) {
                    attributes.put("mLabId", resource.getMLabProject().getId());
                }
            } else {
                session.close(new CloseStatus(1000, "resource not found"));
            }
        } else {
            session.close(new CloseStatus(1000, "id not found"));
        }
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        this.sendMessage(session);
    }

    public void sendMessage(WebSocketSession session) throws Exception {
        DepQuotas depQuotas;
        MLabProject project;
        Map attributes = session.getAttributes();
        Long userId = (Long)attributes.get("userId");
        Long depId = (Long)attributes.get("depId");
        Long domainId = (Long)attributes.get("domainId");
        Object mLabId = attributes.get("mLabId");
        if (mLabId != null && (project = (MLabProject)this.mLabProjectRepository.findOne((Serializable)((Long)mLabId))) != null) {
            project.setLastProbe(Long.valueOf(System.currentTimeMillis()));
        }
        K8sFactory k8sFactory = FactoryCollection.k8sFactory((Long)domainId);
        NotebookMetricResponse res = new NotebookMetricResponse();
        Long all = this.referDurationRepository.calculateAllByReferTypeAndReferenceAndDepAndDomain(Integer.valueOf(0), (Long)attributes.get("id"), depId, domainId);
        res.setDuration(all);
        res.setTimeRemain(Long.valueOf(-1L));
        DepUsers depUser = this.depUsersRepository.findTopByUserIdAndDepartmentId(userId, depId);
        if (null != depUser && depUser.getType() == 3 && null != (depQuotas = this.depQuotasRepository.findByDepartmentIdAndDomainId(depId, domainId)) && depQuotas.getResourceTime().longValue() != -1L) {
            Long calculate = this.referDurationRepository.calculateByReferTypeAndUserAndDepAndDomain(Integer.valueOf(0), userId, depId, domainId, Long.valueOf(depQuotas.getTimeStart().getTime() / 1000L));
            calculate = null == calculate ? 0L : calculate;
            double remainedTime = depQuotas.getResourceTime() * 60.0 * 60.0 - (double)calculate.longValue();
            res.setTimeRemain(Long.valueOf(remainedTime > 0.0 ? (long)remainedTime : 0L));
        }
        String namespace = (String)attributes.get("guid");
        int cpuCores = (Integer)attributes.get("cpu");
        List podList = k8sFactory.listPods(namespace);
        if (null != podList && podList.size() > 0) {
            V1Pod pod = (V1Pod)podList.get(0);
            if (pod.getStatus().getContainerStatuses() != null && ((V1ContainerStatus)pod.getStatus().getContainerStatuses().get(0)).getReady().booleanValue()) {
                Map nodeSelector;
                InstantMetricModel model = k8sFactory.podCpuMemoryUsage(pod.getMetadata().getUid(), Integer.valueOf(cpuCores));
                res.setCpuUsage(model.getCpuUsage());
                res.setMemUsage(model.getMemUsage());
                String container = ((V1Container)pod.getSpec().getContainers().get(0)).getName();
                String query = "/api/v1/query?query=%s{namespace=\"" + namespace + "\",container=\"" + container + "\"}";
                JSONArray result = k8sFactory.parsePromResult(String.format(query, "container_fs_usage_bytes"));
                if (!result.isEmpty()) {
                    String fsUsage = SizeConverter.convertBytes((float)Float.parseFloat(result.getJSONObject(0).getJSONArray("value").getString(1)), (boolean)true);
                    result = k8sFactory.parsePromResult(String.format(query, "container_fs_limit_bytes"));
                    if (!result.isEmpty()) {
                        String fsLimit = SizeConverter.convertBytes((float)Float.parseFloat(result.getJSONObject(0).getJSONArray("value").getString(1)), (boolean)true);
                        res.setDiskUsage(fsUsage + "/" + fsLimit);
                    }
                }
                if ((nodeSelector = pod.getSpec().getNodeSelector()).containsKey("gpu")) {
                    res.setGpuUsage(k8sFactory.podGpusMetrics(pod));
                }
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)mapper.writeValueAsString((Object)res)));
            } else {
                session.close(new CloseStatus(1000, "resource is not ready"));
            }
        } else {
            session.close(new CloseStatus(1000, "resource has been reclaimed"));
        }
    }

    @ConstructorProperties(value={"resourceRepository", "referDurationRepository", "depUsersRepository", "depQuotasRepository", "storageRepository", "mLabProjectRepository", "storageServiceFactory"})
    public WsNotebookMetricsHandler(ResourceRepository resourceRepository, ReferDurationRepository referDurationRepository, DepUsersRepository depUsersRepository, DepQuotasRepository depQuotasRepository, StorageRepository storageRepository, MLabProjectRepository mLabProjectRepository, StorageServiceFactory storageServiceFactory) {
        this.resourceRepository = resourceRepository;
        this.referDurationRepository = referDurationRepository;
        this.depUsersRepository = depUsersRepository;
        this.depQuotasRepository = depQuotasRepository;
        this.storageRepository = storageRepository;
        this.mLabProjectRepository = mLabProjectRepository;
        this.storageServiceFactory = storageServiceFactory;
    }
}

